/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.navigation;

import com.destroystokyo.paper.event.entity.EntityPathfindEvent;
import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IPosition;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.server.MCUtil;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.level.ChunkCache;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.level.pathfinder.PathPoint;
import net.minecraft.world.level.pathfinder.Pathfinder;
import net.minecraft.world.level.pathfinder.PathfinderAbstract;
import net.minecraft.world.level.pathfinder.PathfinderNormal;
import net.minecraft.world.phys.Vec3D;

public abstract class NavigationAbstract {
    private static final int p = 20;
    protected final EntityInsentient a;
    protected final World b;
    @Nullable
    protected PathEntity c;
    protected double d;
    protected int e;
    protected int f;
    protected Vec3D g = Vec3D.a;
    protected BaseBlockPosition h = BaseBlockPosition.g;
    protected long i;
    protected long j;
    protected double k;
    protected float l = 0.5f;
    protected boolean m;
    protected long n;
    protected PathfinderAbstract o;
    @Nullable
    private BlockPosition q;
    private int r;
    private float s = 1.0f;
    public final Pathfinder t;
    private boolean u;
    private int lastFailure = 0;
    private int pathfindFailures = 0;

    public final EntityInsentient getEntity() {
        return this.a;
    }

    protected final boolean needsPathRecalculation() {
        return this.m;
    }

    public boolean isViableForPathRecalculationChecking() {
        return !this.needsPathRecalculation() && this.c != null && !this.c.c() && this.c.e() != 0;
    }

    public NavigationAbstract(EntityInsentient mob, World world) {
        this.a = mob;
        this.b = world;
        int i2 = MathHelper.b(mob.b(GenericAttributes.b) * 16.0);
        this.t = this.a(i2);
    }

    public void g() {
        this.s = 1.0f;
    }

    public void a(float rangeMultiplier) {
        this.s = rangeMultiplier;
    }

    @Nullable
    public BlockPosition h() {
        return this.q;
    }

    protected abstract Pathfinder a(int var1);

    public void a(double speed) {
        this.d = speed;
    }

    public void i() {
        if (this.b.U() - this.n > 20L) {
            if (this.q != null) {
                this.c = null;
                this.c = this.a(this.q, this.r);
                this.n = this.b.U();
                this.m = false;
            }
        } else {
            this.m = true;
        }
    }

    @Nullable
    public final PathEntity a(double x2, double y2, double z2, int distance) {
        return this.a(new BlockPosition(x2, y2, z2), distance);
    }

    @Nullable
    public PathEntity a(Stream<BlockPosition> positions, int distance) {
        return this.a(positions.collect(Collectors.toSet()), 8, false, distance);
    }

    @Nullable
    public PathEntity a(Set<BlockPosition> positions, int distance) {
        return this.a(positions, 8, false, distance);
    }

    @Nullable
    public PathEntity a(BlockPosition target, int distance) {
        return this.createPath(target, null, distance);
    }

    @Nullable
    public PathEntity createPath(BlockPosition target, Entity entity, int distance) {
        return this.createPath((Set<BlockPosition>)ImmutableSet.of((Object)target), entity, 8, false, distance);
    }

    @Nullable
    public PathEntity a(BlockPosition target, int minDistance, int maxDistance) {
        return this.a((Set<BlockPosition>)ImmutableSet.of((Object)target), 8, false, minDistance, maxDistance);
    }

    @Nullable
    public PathEntity a(Entity entity, int distance) {
        return this.createPath((Set<BlockPosition>)ImmutableSet.of((Object)entity.cW()), entity, 16, true, distance);
    }

    @Nullable
    protected PathEntity a(Set<BlockPosition> positions, int range, boolean useHeadPos, int distance) {
        return this.a(positions, range, useHeadPos, distance, (float)this.a.b(GenericAttributes.b));
    }

    @Nullable
    protected PathEntity a(Set<BlockPosition> positions, int range, boolean useHeadPos, int distance, float followRange) {
        return this.createPath(positions, null, range, useHeadPos, distance, (float)this.a.b(GenericAttributes.b));
    }

    @Nullable
    protected PathEntity createPath(Set<BlockPosition> positions, Entity target, int range, boolean useHeadPos, int distance) {
        return this.createPath(positions, target, range, useHeadPos, distance, (float)this.a.b(GenericAttributes.b));
    }

    @Nullable
    protected PathEntity createPath(Set<BlockPosition> positions, Entity target, int range, boolean useHeadPos, int distance, float followRange) {
        if (positions.isEmpty()) {
            return null;
        }
        if (this.a.de() < (double)this.b.u_()) {
            return null;
        }
        if (!this.a()) {
            return null;
        }
        if (this.c != null && !this.c.c() && positions.contains(this.q)) {
            return this.c;
        }
        boolean copiedSet = false;
        for (BlockPosition possibleTarget : positions) {
            if (this.a.cA().p_().a(possibleTarget) && new EntityPathfindEvent((org.bukkit.entity.Entity)this.a.getBukkitEntity(), MCUtil.toLocation(this.a.s, possibleTarget), (org.bukkit.entity.Entity)(target == null ? null : target.getBukkitEntity())).callEvent()) continue;
            if (!copiedSet) {
                copiedSet = true;
                positions = new HashSet<BlockPosition>(positions);
            }
            positions.remove(possibleTarget);
            if (!positions.isEmpty()) continue;
            return null;
        }
        this.b.ab().a("pathfind");
        BlockPosition blockPos = useHeadPos ? this.a.cW().b() : this.a.cW();
        int i2 = (int)(followRange + (float)range);
        ChunkCache pathNavigationRegion = new ChunkCache(this.b, blockPos.b(-i2, -i2, -i2), blockPos.b(i2, i2, i2));
        PathEntity path = this.t.a(pathNavigationRegion, this.a, positions, followRange, distance, this.s);
        this.b.ab().c();
        if (path != null && path.m() != null) {
            this.q = path.m();
            this.r = distance;
            this.f();
        }
        return path;
    }

    public boolean a(double x2, double y2, double z2, double speed) {
        return this.a(this.a(x2, y2, z2, 1), speed);
    }

    public boolean a(Entity entity, double speed) {
        if (this.pathfindFailures > 10 && this.c == null && MinecraftServer.currentTick < this.lastFailure + 40) {
            return false;
        }
        PathEntity path = this.a(entity, 1);
        if (path != null && this.a(path, speed)) {
            this.lastFailure = 0;
            this.pathfindFailures = 0;
            return true;
        }
        ++this.pathfindFailures;
        this.lastFailure = MinecraftServer.currentTick;
        return false;
    }

    public boolean a(@Nullable PathEntity path, double speed) {
        if (path == null) {
            this.c = null;
            return false;
        }
        if (!path.a(this.c)) {
            this.c = path;
        }
        if (this.l()) {
            return false;
        }
        this.F_();
        if (this.c.e() <= 0) {
            return false;
        }
        this.d = speed;
        Vec3D vec3 = this.b();
        this.f = this.e;
        this.g = vec3;
        return true;
    }

    @Nullable
    public PathEntity j() {
        return this.c;
    }

    public void c() {
        ++this.e;
        if (this.m) {
            this.i();
        }
        if (!this.l()) {
            if (this.a()) {
                this.k();
            } else if (this.c != null && !this.c.c()) {
                Vec3D vec3 = this.b();
                Vec3D vec32 = this.c.a(this.a);
                if (vec3.c > vec32.c && !this.a.aw() && MathHelper.b(vec3.b) == MathHelper.b(vec32.b) && MathHelper.b(vec3.d) == MathHelper.b(vec32.d)) {
                    this.c.a();
                }
            }
            PacketDebug.a(this.b, this.a, this.c, this.l);
            if (!this.l()) {
                Vec3D vec33 = this.c.a(this.a);
                this.a.A().a(vec33.b, this.a(vec33), vec33.d, this.d);
            }
        }
    }

    protected double a(Vec3D pos) {
        BlockPosition blockPos = new BlockPosition(pos);
        return this.b.a_(blockPos.c()).g() ? pos.c : PathfinderNormal.a((IBlockAccess)this.b, blockPos);
    }

    protected void k() {
        boolean bl;
        Vec3D vec3 = this.b();
        this.l = this.a.cT() > 0.75f ? this.a.cT() / 2.0f : 0.75f - this.a.cT() / 2.0f;
        BlockPosition vec3i = this.c.g();
        double d2 = Math.abs(this.a.dc() - ((double)vec3i.u() + 0.5));
        double e2 = Math.abs(this.a.de() - (double)vec3i.v());
        double f2 = Math.abs(this.a.di() - ((double)vec3i.w() + 0.5));
        boolean bl2 = bl = d2 < (double)this.l && f2 < (double)this.l && e2 < 1.0;
        if (bl || this.a.b(this.c.h().l) && this.c(vec3)) {
            this.c.a();
        }
        this.b(vec3);
    }

    private boolean c(Vec3D currentPos) {
        Vec3D vec34;
        if (this.c.f() + 1 >= this.c.e()) {
            return false;
        }
        Vec3D vec3 = Vec3D.c(this.c.g());
        if (!currentPos.a((IPosition)vec3, 2.0)) {
            return false;
        }
        if (this.a(currentPos, this.c.a(this.a))) {
            return true;
        }
        Vec3D vec32 = Vec3D.c(this.c.d(this.c.f() + 1));
        Vec3D vec33 = vec32.d(vec3);
        return vec33.b(vec34 = currentPos.d(vec3)) > 0.0;
    }

    protected void b(Vec3D currentPos) {
        if (this.e - this.f > 100) {
            if (currentPos.g(this.g) < 2.25) {
                this.u = true;
                this.n();
            } else {
                this.u = false;
            }
            this.f = this.e;
            this.g = currentPos;
        }
        if (this.c != null && !this.c.c()) {
            BlockPosition vec3i = this.c.g();
            if (vec3i.equals(this.h)) {
                this.i += SystemUtils.b() - this.j;
            } else {
                this.h = vec3i;
                double d2 = currentPos.f(Vec3D.c(this.h));
                double d3 = this.k = this.a.eD() > 0.0f ? d2 / (double)this.a.eD() * 1000.0 : 0.0;
            }
            if (this.k > 0.0 && (double)this.i > this.k * 3.0) {
                this.e();
            }
            this.j = SystemUtils.b();
        }
    }

    private void e() {
        this.f();
        this.n();
    }

    private void f() {
        this.h = BaseBlockPosition.g;
        this.i = 0L;
        this.k = 0.0;
        this.u = false;
    }

    public boolean l() {
        return this.c == null || this.c.c();
    }

    public boolean m() {
        return !this.l();
    }

    public void n() {
        this.c = null;
    }

    protected abstract Vec3D b();

    protected abstract boolean a();

    protected boolean o() {
        return this.a.aT() || this.a.bc();
    }

    protected void F_() {
        if (this.c != null) {
            for (int i2 = 0; i2 < this.c.e(); ++i2) {
                PathPoint node = this.c.a(i2);
                PathPoint node2 = i2 + 1 < this.c.e() ? this.c.a(i2 + 1) : null;
                IBlockData blockState = this.b.a_(new BlockPosition(node.a, node.b, node.c));
                if (!blockState.a(TagsBlock.aW)) continue;
                this.c.a(i2, node.a(node.a, node.b + 1, node.c));
                if (node2 == null || node.b < node2.b) continue;
                this.c.a(i2 + 1, node.a(node2.a, node.b + 1, node2.c));
            }
        }
    }

    protected boolean a(Vec3D origin, Vec3D target) {
        return false;
    }

    public boolean a(BlockPosition pos) {
        BlockPosition blockPos = pos.c();
        return this.b.a_(blockPos).i(this.b, blockPos);
    }

    public PathfinderAbstract p() {
        return this.o;
    }

    public void d(boolean canSwim) {
        this.o.c(canSwim);
    }

    public boolean q() {
        return this.o.f();
    }

    public boolean b(BlockPosition pos) {
        if (this.m) {
            return false;
        }
        if (this.c != null && !this.c.c() && this.c.e() != 0) {
            PathPoint node = this.c.d();
            Vec3D vec3 = new Vec3D(((double)node.a + this.a.dc()) / 2.0, ((double)node.b + this.a.de()) / 2.0, ((double)node.c + this.a.di()) / 2.0);
            return pos.a(vec3, (double)(this.c.e() - this.c.f()));
        }
        return false;
    }

    public float r() {
        return this.l;
    }

    public boolean s() {
        return this.u;
    }
}

