/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.goal;

import com.destroystokyo.paper.util.set.OptimizedSmallEnumSet;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import io.papermc.paper.util.IntegerUtil;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalWrapped;
import org.slf4j.Logger;

public class PathfinderGoalSelector {
    private static final Logger a = LogUtils.getLogger();
    private static final PathfinderGoalWrapped b = new PathfinderGoalWrapped(Integer.MAX_VALUE, new PathfinderGoal(){

        @Override
        public boolean a() {
            return false;
        }
    }){

        @Override
        public boolean h() {
            return false;
        }
    };
    private final Map<PathfinderGoal.Type, PathfinderGoalWrapped> c = new EnumMap<PathfinderGoal.Type, PathfinderGoalWrapped>(PathfinderGoal.Type.class);
    public final Set<PathfinderGoalWrapped> d = Sets.newLinkedHashSet();
    private final Supplier<GameProfilerFiller> e;
    private final EnumSet<PathfinderGoal.Type> f = EnumSet.noneOf(PathfinderGoal.Type.class);
    private final OptimizedSmallEnumSet<PathfinderGoal.Type> goalTypes = new OptimizedSmallEnumSet<PathfinderGoal.Type>(PathfinderGoal.Type.class);
    private int g;
    private int h = 3;
    private int curRate;
    private static final PathfinderGoal.Type[] GOAL_FLAG_VALUES = PathfinderGoal.Type.values();

    public PathfinderGoalSelector(Supplier<GameProfilerFiller> profiler) {
        this.e = profiler;
    }

    public void a(int priority, PathfinderGoal goal) {
        this.d.add(new PathfinderGoalWrapped(priority, goal));
    }

    @VisibleForTesting
    public void a() {
        this.d.clear();
    }

    public boolean inactiveTick() {
        ++this.curRate;
        return this.curRate % this.h == 0;
    }

    public boolean hasTasks() {
        for (PathfinderGoalWrapped task : this.d) {
            if (!task.h()) continue;
            return true;
        }
        return false;
    }

    public void a(PathfinderGoal goal) {
        Iterator<PathfinderGoalWrapped> iterator = this.d.iterator();
        while (iterator.hasNext()) {
            PathfinderGoalWrapped goalWrapped = iterator.next();
            if (goalWrapped.k() != goal) continue;
            if (goalWrapped.h()) {
                goalWrapped.d();
            }
            iterator.remove();
        }
    }

    private static boolean goalContainsAnyFlags(PathfinderGoalWrapped goal, OptimizedSmallEnumSet<PathfinderGoal.Type> controls) {
        return goal.getFlags().hasCommonElements(controls);
    }

    private static boolean a(PathfinderGoalWrapped goal, Map<PathfinderGoal.Type, PathfinderGoalWrapped> goalsByControl) {
        long flagIterator = goal.getFlags().getBackingSet();
        int wrappedGoalSize = goal.getFlags().size();
        for (int i2 = 0; i2 < wrappedGoalSize; ++i2) {
            PathfinderGoal.Type flag = GOAL_FLAG_VALUES[Long.numberOfTrailingZeros(flagIterator)];
            flagIterator ^= IntegerUtil.getTrailingBit(flagIterator);
            if (goalsByControl.getOrDefault((Object)flag, b).a(goal)) continue;
            return false;
        }
        return true;
    }

    public void b() {
        GameProfilerFiller profilerFiller = this.e.get();
        profilerFiller.a("goalCleanup");
        for (PathfinderGoalWrapped wrappedGoal : this.d) {
            if (!wrappedGoal.h() || !PathfinderGoalSelector.goalContainsAnyFlags(wrappedGoal, this.goalTypes) && wrappedGoal.b()) continue;
            wrappedGoal.d();
        }
        Iterator<Map.Entry<PathfinderGoal.Type, PathfinderGoalWrapped>> iterator = this.c.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<PathfinderGoal.Type, PathfinderGoalWrapped> entry = iterator.next();
            if (entry.getValue().h()) continue;
            iterator.remove();
        }
        profilerFiller.c();
        profilerFiller.a("goalUpdate");
        for (PathfinderGoalWrapped wrappedGoal2 : this.d) {
            if (wrappedGoal2.h() || PathfinderGoalSelector.goalContainsAnyFlags(wrappedGoal2, this.goalTypes) || !PathfinderGoalSelector.a(wrappedGoal2, this.c) || !wrappedGoal2.a()) continue;
            long flagIterator = wrappedGoal2.getFlags().getBackingSet();
            int wrappedGoalSize = wrappedGoal2.getFlags().size();
            for (int i2 = 0; i2 < wrappedGoalSize; ++i2) {
                PathfinderGoal.Type flag = GOAL_FLAG_VALUES[Long.numberOfTrailingZeros(flagIterator)];
                flagIterator ^= IntegerUtil.getTrailingBit(flagIterator);
                PathfinderGoalWrapped wrappedGoal3 = this.c.getOrDefault((Object)flag, b);
                wrappedGoal3.d();
                this.c.put(flag, wrappedGoal2);
            }
            wrappedGoal2.c();
        }
        profilerFiller.c();
        this.a(true);
    }

    public void a(boolean tickAll) {
        GameProfilerFiller profilerFiller = this.e.get();
        profilerFiller.a("goalTick");
        for (PathfinderGoalWrapped wrappedGoal : this.d) {
            if (!wrappedGoal.h() || !tickAll && !wrappedGoal.E_()) continue;
            wrappedGoal.e();
        }
        profilerFiller.c();
    }

    public Set<PathfinderGoalWrapped> c() {
        return this.d;
    }

    public Stream<PathfinderGoalWrapped> d() {
        return this.d.stream().filter(PathfinderGoalWrapped::h);
    }

    public void a(int timeInterval) {
        this.h = timeInterval;
    }

    public void a(PathfinderGoal.Type control) {
        this.goalTypes.addUnchecked(control);
    }

    public void b(PathfinderGoal.Type control) {
        this.goalTypes.removeUnchecked(control);
    }

    public void a(PathfinderGoal.Type control, boolean enabled) {
        if (enabled) {
            this.b(control);
        } else {
            this.a(control);
        }
    }
}

