/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.goal;

import com.google.common.collect.Lists;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.ai.util.PathfinderGoalUtil;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceType;
import net.minecraft.world.level.block.BlockDoor;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.level.pathfinder.PathPoint;
import net.minecraft.world.phys.Vec3D;

public class PathfinderGoalMoveThroughVillage
extends PathfinderGoal {
    protected final EntityCreature a;
    private final double b;
    @Nullable
    private PathEntity c;
    private BlockPosition d;
    private final boolean e;
    private final List<BlockPosition> f = Lists.newArrayList();
    private final int g;
    private final BooleanSupplier h;

    public PathfinderGoalMoveThroughVillage(EntityCreature entity, double speed, boolean requiresNighttime, int distance, BooleanSupplier doorPassingThroughGetter) {
        this.a = entity;
        this.b = speed;
        this.e = requiresNighttime;
        this.g = distance;
        this.h = doorPassingThroughGetter;
        this.a(EnumSet.of(PathfinderGoal.Type.a));
        if (!PathfinderGoalUtil.a(entity)) {
            throw new IllegalArgumentException("Unsupported mob for MoveThroughVillageGoal");
        }
    }

    @Override
    @Override
    public boolean a() {
        if (!PathfinderGoalUtil.a(this.a)) {
            return false;
        }
        this.h();
        if (this.e && this.a.s.O()) {
            return false;
        }
        WorldServer serverLevel = (WorldServer)this.a.s;
        BlockPosition blockPos = this.a.cW();
        if (!serverLevel.a(blockPos, 6)) {
            return false;
        }
        Vec3D vec3 = LandRandomPos.a(this.a, 15, 7, pos -> {
            if (!serverLevel.b((BlockPosition)pos)) {
                return Double.NEGATIVE_INFINITY;
            }
            Optional<BlockPosition> optional = serverLevel.z().c(VillagePlaceType.b, this::a, (BlockPosition)pos, 10, VillagePlace.Occupancy.b);
            if (!optional.isPresent()) {
                return Double.NEGATIVE_INFINITY;
            }
            return -optional.get().j(blockPos);
        });
        if (vec3 == null) {
            return false;
        }
        Optional<BlockPosition> optional = serverLevel.z().c(VillagePlaceType.b, this::a, new BlockPosition(vec3), 10, VillagePlace.Occupancy.b);
        if (!optional.isPresent()) {
            return false;
        }
        this.d = optional.get().h();
        Navigation groundPathNavigation = (Navigation)this.a.D();
        boolean bl = groundPathNavigation.f();
        groundPathNavigation.a(this.h.getAsBoolean());
        this.c = groundPathNavigation.a(this.d, 0);
        groundPathNavigation.a(bl);
        if (this.c == null) {
            Vec3D vec32 = DefaultRandomPos.a(this.a, 10, 7, Vec3D.c(this.d), 1.5707963705062866);
            if (vec32 == null) {
                return false;
            }
            groundPathNavigation.a(this.h.getAsBoolean());
            this.c = this.a.D().a(vec32.b, vec32.c, vec32.d, 0);
            groundPathNavigation.a(bl);
            if (this.c == null) {
                return false;
            }
        }
        for (int i2 = 0; i2 < this.c.e(); ++i2) {
            PathPoint node = this.c.a(i2);
            BlockPosition blockPos2 = new BlockPosition(node.a, node.b + 1, node.c);
            if (!BlockDoor.a(this.a.s, blockPos2)) continue;
            this.c = this.a.D().a((double)node.a, (double)node.b, (double)node.c, 0);
            break;
        }
        return this.c != null;
    }

    @Override
    @Override
    public boolean b() {
        if (this.a.D().l()) {
            return false;
        }
        return !this.d.a(this.a.cV(), (double)(this.a.cT() + (float)this.g));
    }

    @Override
    @Override
    public void c() {
        this.a.D().a(this.c, this.b);
    }

    @Override
    @Override
    public void d() {
        if (this.a.D().l() || this.d.a(this.a.cV(), (double)this.g)) {
            this.f.add(this.d);
        }
    }

    private boolean a(BlockPosition pos) {
        for (BlockPosition blockPos : this.f) {
            if (!Objects.equals(pos, blockPos)) continue;
            return false;
        }
        return true;
    }

    private void h() {
        if (this.f.size() > 15) {
            this.f.remove(0);
        }
    }
}

