/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import java.util.stream.Stream;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorPositionEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.MemoryTarget;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.level.pathfinder.PathfinderNormal;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_18_R2.event.CraftEventFactory;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;

public class PrepareRamNearestTarget<E extends EntityCreature>
extends Behavior<E> {
    public static final int a = 160;
    private final ToIntFunction<E> c;
    private final int d;
    private final int e;
    private final float f;
    private final PathfinderTargetCondition g;
    private final int h;
    private final Function<E, SoundEffect> i;
    private Optional<Long> j = Optional.empty();
    private Optional<a> k = Optional.empty();

    public PrepareRamNearestTarget(ToIntFunction<E> cooldownFactory, int minDistance, int maxDistance, float speed, PathfinderTargetCondition targetPredicate, int prepareTime, Function<E, SoundEffect> soundFactory) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.n, (Object)((Object)MemoryStatus.c), MemoryModuleType.T, (Object)((Object)MemoryStatus.b), MemoryModuleType.h, (Object)((Object)MemoryStatus.a), MemoryModuleType.U, (Object)((Object)MemoryStatus.b)), 160);
        this.c = cooldownFactory;
        this.d = minDistance;
        this.e = maxDistance;
        this.f = speed;
        this.g = targetPredicate;
        this.h = prepareTime;
        this.i = soundFactory;
    }

    @Override
    protected void a(WorldServer world, EntityCreature entity, long time) {
        BehaviorController<?> behaviorcontroller = entity.du();
        behaviorcontroller.c(MemoryModuleType.h).flatMap(nearestvisiblelivingentities -> nearestvisiblelivingentities.a(entityliving -> this.g.a(entity, (EntityLiving)entityliving))).ifPresent(entityliving -> {
            EntityTargetLivingEntityEvent event = CraftEventFactory.callEntityTargetLivingEvent(entity, entityliving, entityliving instanceof EntityPlayer ? EntityTargetEvent.TargetReason.CLOSEST_PLAYER : EntityTargetEvent.TargetReason.CLOSEST_ENTITY);
            if (event.isCancelled() || event.getTarget() == null) {
                return;
            }
            entityliving = ((CraftLivingEntity)event.getTarget()).getHandle();
            this.b(entity, (EntityLiving)entityliving);
        });
    }

    protected void b(WorldServer worldserver, E e0, long i2) {
        BehaviorController<Vec3D> behaviorcontroller = ((EntityLiving)e0).du();
        if (!behaviorcontroller.a(MemoryModuleType.U)) {
            worldserver.a((Entity)e0, (byte)59);
            behaviorcontroller.a(MemoryModuleType.T, Integer.valueOf(this.c.applyAsInt(e0)));
        }
    }

    protected boolean c(WorldServer worldserver, EntityCreature entitycreature, long i2) {
        return this.k.isPresent() && this.k.get().c().bl();
    }

    @Override
    protected void d(WorldServer world, E entity, long time) {
        if (this.k.isPresent()) {
            boolean flag;
            ((EntityLiving)entity).du().a(MemoryModuleType.m, new MemoryTarget(this.k.get().a(), this.f, 0));
            ((EntityLiving)entity).du().a(MemoryModuleType.n, new BehaviorPositionEntity(this.k.get().c(), true));
            boolean bl = flag = !this.k.get().c().cW().equals(this.k.get().b());
            if (flag) {
                world.a((Entity)entity, (byte)59);
                ((EntityInsentient)entity).D().n();
                this.b((EntityCreature)entity, this.k.get().c);
            } else {
                BlockPosition blockposition = ((Entity)entity).cW();
                if (blockposition.equals(this.k.get().a())) {
                    world.a((Entity)entity, (byte)58);
                    if (!this.j.isPresent()) {
                        this.j = Optional.of(time);
                    }
                    if (time - this.j.get() >= (long)this.h) {
                        ((EntityLiving)entity).du().a(MemoryModuleType.U, this.a(blockposition, this.k.get().b()));
                        world.a((EntityHuman)null, (Entity)entity, this.i.apply(entity), SoundCategory.f, 1.0f, ((EntityLiving)entity).ew());
                        this.k = Optional.empty();
                    }
                }
            }
        }
    }

    private Vec3D a(BlockPosition start, BlockPosition end) {
        double d0 = 0.5;
        double d1 = 0.5 * (double)MathHelper.k((double)(end.u() - start.u()));
        double d2 = 0.5 * (double)MathHelper.k((double)(end.w() - start.w()));
        return Vec3D.c(end).b(d1, 0.0, d2);
    }

    private Optional<BlockPosition> a(EntityCreature entity, EntityLiving target) {
        BlockPosition blockposition = target.cW();
        if (!this.a(entity, blockposition)) {
            return Optional.empty();
        }
        ArrayList list = Lists.newArrayList();
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = blockposition.i();
        for (EnumDirection enumdirection : EnumDirection.EnumDirectionLimit.a) {
            blockposition_mutableblockposition.g(blockposition);
            for (int i2 = 0; i2 < this.e; ++i2) {
                if (this.a(entity, (BlockPosition)blockposition_mutableblockposition.c(enumdirection))) {
                    continue;
                }
                blockposition_mutableblockposition.c(enumdirection.f());
                break;
            }
            if (blockposition_mutableblockposition.k(blockposition) < this.d) continue;
            list.add(blockposition_mutableblockposition.h());
        }
        NavigationAbstract navigationabstract = entity.D();
        Stream stream = list.stream();
        BlockPosition blockposition1 = entity.cW();
        Objects.requireNonNull(blockposition1);
        return stream.sorted(Comparator.comparingDouble(blockposition1::j)).filter(blockposition2 -> {
            PathEntity pathentity = navigationabstract.a((BlockPosition)blockposition2, 0);
            return pathentity != null && pathentity.j();
        }).findFirst();
    }

    private boolean a(EntityCreature entity, BlockPosition target) {
        return entity.D().a(target) && entity.a(PathfinderNormal.a((IBlockAccess)entity.s, target.i())) == 0.0f;
    }

    private void b(EntityCreature entity, EntityLiving target) {
        this.j = Optional.empty();
        this.k = this.a(entity, target).map(blockposition -> new a((BlockPosition)blockposition, target.cW(), target));
    }

    public static class a {
        private final BlockPosition a;
        private final BlockPosition b;
        final EntityLiving c;

        public a(BlockPosition start, BlockPosition end, EntityLiving entity) {
            this.a = start;
            this.b = end;
            this.c = entity;
        }

        public BlockPosition a() {
            return this.a;
        }

        public BlockPosition b() {
            return this.b;
        }

        public EntityLiving c() {
            return this.c;
        }
    }
}

