/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.util.MathHelper;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandom2;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorTarget;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.level.pathfinder.PathfinderNormal;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;

public class LongJumpToRandomPos<E extends EntityInsentient>
extends Behavior<E> {
    private static final int c = 20;
    private static final int d = 40;
    private static final int e = 8;
    public static final int a = 200;
    private final UniformInt f;
    private final int g;
    private final int h;
    private final float i;
    private final List<a> j = new ArrayList<a>();
    private Optional<Vec3D> k = Optional.empty();
    private Optional<a> l = Optional.empty();
    private int m;
    private long n;
    private Function<E, SoundEffect> o;

    public LongJumpToRandomPos(UniformInt cooldownRange, int verticalRange, int horizontalRange, float maxRange, Function<E, SoundEffect> entityToSound) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.n, (Object)((Object)MemoryStatus.c), MemoryModuleType.Q, (Object)((Object)MemoryStatus.b), MemoryModuleType.R, (Object)((Object)MemoryStatus.b)), 200);
        this.f = cooldownRange;
        this.g = verticalRange;
        this.h = horizontalRange;
        this.i = maxRange;
        this.o = entityToSound;
    }

    @Override
    @Override
    protected boolean a(WorldServer world, EntityInsentient entity) {
        return entity.aw() && !world.a_(entity.cW()).a(Blocks.ns);
    }

    @Override
    protected boolean a(WorldServer serverLevel, EntityInsentient mob, long l2) {
        boolean bl;
        boolean bl2 = bl = this.k.isPresent() && this.k.get().equals(mob.cV()) && this.m > 0 && (this.l.isPresent() || !this.j.isEmpty());
        if (!bl && !mob.du().c(MemoryModuleType.R).isPresent()) {
            mob.du().a(MemoryModuleType.Q, Integer.valueOf(this.f.a(serverLevel.v) / 2));
        }
        return bl;
    }

    @Override
    protected void b(WorldServer serverLevel, EntityInsentient mob, long l2) {
        this.l = Optional.empty();
        this.m = 20;
        this.j.clear();
        this.k = Optional.of(mob.cV());
        BlockPosition blockPos = mob.cW();
        int i2 = blockPos.u();
        int j2 = blockPos.v();
        int k2 = blockPos.w();
        Iterable<BlockPosition> iterable = BlockPosition.b(i2 - this.h, j2 - this.g, k2 - this.h, i2 + this.h, j2 + this.g, k2 + this.h);
        NavigationAbstract pathNavigation = mob.D();
        for (BlockPosition blockPos2 : iterable) {
            double d2 = blockPos2.j(blockPos);
            if (i2 == blockPos2.u() && k2 == blockPos2.w() || !pathNavigation.a(blockPos2) || mob.a(PathfinderNormal.a((IBlockAccess)mob.s, blockPos2.i())) != 0.0f) continue;
            Optional<Vec3D> optional = this.a(mob, Vec3D.a(blockPos2));
            optional.ifPresent(vel -> this.j.add(new a(new BlockPosition(blockPos2), (Vec3D)vel, MathHelper.e(d2))));
        }
    }

    @Override
    @Override
    protected void c(WorldServer serverLevel, E mob, long l2) {
        if (this.l.isPresent()) {
            if (l2 - this.n >= 40L) {
                ((Entity)mob).o(((EntityLiving)mob).aX);
                ((EntityLiving)mob).p(true);
                Vec3D vec3 = this.l.get().c();
                double d2 = vec3.f();
                double e2 = d2 + ((EntityLiving)mob).ez();
                ((Entity)mob).g(vec3.a(e2 / d2));
                ((EntityLiving)mob).du().a(MemoryModuleType.R, true);
                serverLevel.a(null, (Entity)mob, this.o.apply(mob), SoundCategory.g, 1.0f, 1.0f);
            }
        } else {
            --this.m;
            Optional<a> optional = WeightedRandom2.a(serverLevel.v, this.j);
            if (optional.isPresent()) {
                this.j.remove(optional.get());
                ((EntityLiving)mob).du().a(MemoryModuleType.n, new BehaviorTarget(optional.get().b()));
                NavigationAbstract pathNavigation = ((EntityInsentient)mob).D();
                PathEntity path = pathNavigation.a(optional.get().b(), 0, 8);
                if (path == null || !path.j()) {
                    this.l = optional;
                    this.n = l2;
                }
            }
        }
    }

    private Optional<Vec3D> a(EntityInsentient entity, Vec3D pos) {
        Optional<Vec3D> optional = Optional.empty();
        for (int i2 = 65; i2 < 85; i2 += 5) {
            Optional<Vec3D> optional2 = this.a(entity, pos, i2);
            if (optional.isPresent() && (!optional2.isPresent() || !(optional2.get().g() < optional.get().g()))) continue;
            optional = optional2;
        }
        return optional;
    }

    private Optional<Vec3D> a(EntityInsentient entity, Vec3D pos, int range) {
        Vec3D vec3 = entity.cV();
        Vec3D vec32 = new Vec3D(pos.b - vec3.b, 0.0, pos.d - vec3.d).d().a(0.5);
        pos = pos.d(vec32);
        Vec3D vec33 = pos.d(vec3);
        float f2 = (float)range * (float)Math.PI / 180.0f;
        double d2 = Math.atan2(vec33.d, vec33.b);
        double e2 = vec33.a(0.0, vec33.c, 0.0).g();
        double g2 = Math.sqrt(e2);
        double h2 = vec33.c;
        double i2 = Math.sin(2.0f * f2);
        double j2 = 0.08;
        double k2 = Math.pow(Math.cos(f2), 2.0);
        double l2 = Math.sin(f2);
        double m2 = Math.cos(f2);
        double n2 = Math.sin(d2);
        double o2 = Math.cos(d2);
        double p2 = e2 * 0.08 / (g2 * i2 - 2.0 * h2 * k2);
        if (p2 < 0.0) {
            return Optional.empty();
        }
        double q2 = Math.sqrt(p2);
        if (q2 > (double)this.i) {
            return Optional.empty();
        }
        double r2 = q2 * m2;
        double s2 = q2 * l2;
        int t2 = MathHelper.e(g2 / r2) * 2;
        double u2 = 0.0;
        Vec3D vec34 = null;
        for (int v2 = 0; v2 < t2 - 1; ++v2) {
            double w2 = l2 / m2 * (u2 += g2 / (double)t2) - Math.pow(u2, 2.0) * 0.08 / (2.0 * p2 * Math.pow(m2, 2.0));
            double x2 = u2 * o2;
            double y2 = u2 * n2;
            Vec3D vec35 = new Vec3D(vec3.b + x2, vec3.c + w2, vec3.d + y2);
            if (vec34 != null && !this.a(entity, vec34, vec35)) {
                return Optional.empty();
            }
            vec34 = vec35;
        }
        return Optional.of(new Vec3D(r2 * o2, s2, r2 * n2).a((double)0.95f));
    }

    private boolean a(EntityInsentient entity, Vec3D startPos, Vec3D endPos) {
        EntitySize entityDimensions = entity.a(EntityPose.g);
        Vec3D vec3 = endPos.d(startPos);
        double d2 = Math.min(entityDimensions.a, entityDimensions.b);
        int i2 = MathHelper.e(vec3.f() / d2);
        Vec3D vec32 = vec3.d();
        Vec3D vec33 = startPos;
        for (int j2 = 0; j2 < i2; ++j2) {
            vec33 = j2 == i2 - 1 ? endPos : vec33.e(vec32.a(d2 * (double)0.9f));
            AxisAlignedBB aABB = entityDimensions.a(vec33);
            if (entity.s.a((Entity)entity, aABB)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected /* synthetic */ boolean b(WorldServer world, EntityLiving entity, long time) {
        return this.a(world, (EntityInsentient)entity, time);
    }

    @Override
    protected /* synthetic */ void d(WorldServer world, EntityLiving entity, long time) {
        this.c(world, (EntityInsentient)entity, time);
    }

    @Override
    protected /* synthetic */ void a(WorldServer world, EntityLiving entity, long time) {
        this.b(world, (EntityInsentient)entity, time);
    }

    public static class a
    extends WeightedEntry.a {
        private final BlockPosition a;
        private final Vec3D b;

        public a(BlockPosition pos, Vec3D ramVelocity, int weight) {
            super(weight);
            this.a = pos;
            this.b = ramVelocity;
        }

        public BlockPosition b() {
            return this.a;
        }

        public Vec3D c() {
            return this.b;
        }
    }
}

