/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.SectionPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.behavior.BehaviorPositionEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorTarget;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryTarget;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.npc.EntityVillager;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemProjectileWeapon;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDropItemEvent;

public class BehaviorUtil {
    private BehaviorUtil() {
    }

    public static void a(EntityLiving first, EntityLiving second, float speed) {
        BehaviorUtil.c(first, second);
        BehaviorUtil.b(first, second, speed);
    }

    public static boolean a(BehaviorController<?> brain, EntityLiving target) {
        Optional<NearestVisibleLivingEntities> optional = brain.c(MemoryModuleType.h);
        return optional.isPresent() && optional.get().a(target);
    }

    public static boolean a(BehaviorController<?> brain, MemoryModuleType<? extends EntityLiving> memoryModuleType, EntityTypes<?> entityType) {
        return BehaviorUtil.a(brain, memoryModuleType, (EntityLiving entityliving) -> entityliving.ad() == entityType);
    }

    private static boolean a(BehaviorController<?> brain, MemoryModuleType<? extends EntityLiving> memoryType, Predicate<EntityLiving> filter) {
        return brain.c(memoryType).filter(filter).filter(EntityLiving::bl).filter(entityliving -> BehaviorUtil.a(brain, entityliving)).isPresent();
    }

    private static void c(EntityLiving first, EntityLiving second) {
        BehaviorUtil.a(first, second);
        BehaviorUtil.a(second, first);
    }

    public static void a(EntityLiving entity, EntityLiving target) {
        entity.du().a(MemoryModuleType.n, new BehaviorPositionEntity(target, true));
    }

    private static void b(EntityLiving first, EntityLiving second, float speed) {
        boolean flag = true;
        BehaviorUtil.a(first, second, speed, 2);
        BehaviorUtil.a(second, first, speed, 2);
    }

    public static void a(EntityLiving entity, Entity target, float speed, int completionRange) {
        MemoryTarget memorytarget = new MemoryTarget(new BehaviorPositionEntity(target, false), speed, completionRange);
        entity.du().a(MemoryModuleType.n, new BehaviorPositionEntity(target, true));
        entity.du().a(MemoryModuleType.m, memorytarget);
    }

    public static void a(EntityLiving entity, BlockPosition target, float speed, int completionRange) {
        MemoryTarget memorytarget = new MemoryTarget(new BehaviorTarget(target), speed, completionRange);
        entity.du().a(MemoryModuleType.n, new BehaviorTarget(target));
        entity.du().a(MemoryModuleType.m, memorytarget);
    }

    public static void a(EntityLiving entity, ItemStack stack, Vec3D targetLocation) {
        if (stack.b()) {
            return;
        }
        double d0 = entity.dg() - (double)0.3f;
        EntityItem entityitem = new EntityItem(entity.s, entity.dc(), d0, entity.di(), stack);
        float f2 = 0.3f;
        Vec3D vec3d1 = targetLocation.d(entity.cV());
        vec3d1 = vec3d1.d().a((double)0.3f);
        entityitem.g(vec3d1);
        entityitem.n();
        EntityDropItemEvent event = new EntityDropItemEvent((org.bukkit.entity.Entity)entity.getBukkitEntity(), (org.bukkit.entity.Item)entityitem.getBukkitEntity());
        entityitem.s.getCraftServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        entity.s.b(entityitem);
    }

    public static SectionPosition a(WorldServer world, SectionPosition center, int radius) {
        int j2 = world.b(center);
        Stream<SectionPosition> stream = SectionPosition.a(center, radius).filter(sectionposition1 -> world.b((SectionPosition)sectionposition1) < j2);
        Objects.requireNonNull(world);
        return stream.min(Comparator.comparingInt(world::b)).orElse(center);
    }

    public static boolean a(EntityInsentient mob, EntityLiving target, int rangedWeaponReachReduction) {
        Item item = mob.es().c();
        if (item instanceof ItemProjectileWeapon) {
            ItemProjectileWeapon itemprojectileweapon = (ItemProjectileWeapon)item;
            if (mob.a((ItemProjectileWeapon)item)) {
                int j2 = itemprojectileweapon.d() - rangedWeaponReachReduction;
                return mob.a((Entity)target, (double)j2);
            }
        }
        return BehaviorUtil.a(mob, target);
    }

    public static boolean a(EntityInsentient source, EntityLiving target) {
        double d0 = source.h(target.dc(), target.de(), target.di());
        return d0 <= source.i(target);
    }

    public static boolean a(EntityLiving source, EntityLiving target, double extraDistance) {
        Optional<EntityLiving> optional = source.du().c(MemoryModuleType.o);
        if (optional.isEmpty()) {
            return false;
        }
        double d1 = source.f(optional.get().cV());
        double d2 = source.f(target.cV());
        return d2 > d1 + extraDistance * extraDistance;
    }

    public static boolean b(EntityLiving source, EntityLiving target) {
        BehaviorController<NearestVisibleLivingEntities> behaviorcontroller = source.du();
        return !behaviorcontroller.a(MemoryModuleType.h) ? false : behaviorcontroller.c(MemoryModuleType.h).get().a(target);
    }

    public static EntityLiving a(EntityLiving source, Optional<EntityLiving> first, EntityLiving second) {
        return first.isEmpty() ? second : BehaviorUtil.a(source, first.get(), second);
    }

    public static EntityLiving a(EntityLiving source, EntityLiving first, EntityLiving second) {
        Vec3D vec3d = first.cV();
        Vec3D vec3d1 = second.cV();
        return source.f(vec3d) < source.f(vec3d1) ? first : second;
    }

    public static Optional<EntityLiving> a(EntityLiving entity, MemoryModuleType<UUID> uuidMemoryModule) {
        Optional<UUID> optional = entity.du().c(uuidMemoryModule);
        return optional.map(uuid -> ((WorldServer)entity.s).a((UUID)uuid)).map(entity1 -> {
            EntityLiving entityliving2;
            EntityLiving entityliving1 = entity1 instanceof EntityLiving ? (entityliving2 = (EntityLiving)entity1) : null;
            return entityliving1;
        });
    }

    public static Stream<EntityVillager> a(EntityVillager villager, Predicate<EntityVillager> filter) {
        return villager.du().c(MemoryModuleType.g).map(list -> list.stream().filter(entityliving -> entityliving instanceof EntityVillager && entityliving != villager).map(entityliving -> (EntityVillager)entityliving).filter(EntityLiving::bl).filter(filter)).orElseGet(Stream::empty);
    }

    @Nullable
    public static Vec3D a(EntityCreature entity, int horizontalRange, int verticalRange) {
        Vec3D vec3d = DefaultRandomPos.a(entity, horizontalRange, verticalRange);
        int k2 = 0;
        while (vec3d != null && !entity.s.a_(new BlockPosition(vec3d)).a((IBlockAccess)entity.s, new BlockPosition(vec3d), PathMode.b) && k2++ < 10) {
            vec3d = DefaultRandomPos.a(entity, horizontalRange, verticalRange);
        }
        return vec3d;
    }
}

