/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_18_R2.event.CraftEventFactory;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;

public class BehaviorAttackTargetSet<E extends EntityInsentient>
extends Behavior<E> {
    private final Predicate<E> a;
    private final Function<E, Optional<? extends EntityLiving>> c;

    public BehaviorAttackTargetSet(Predicate<E> startCondition, Function<E, Optional<? extends EntityLiving>> targetGetter) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.o, (Object)((Object)MemoryStatus.b), MemoryModuleType.E, (Object)((Object)MemoryStatus.c)));
        this.a = startCondition;
        this.c = targetGetter;
    }

    public BehaviorAttackTargetSet(Function<E, Optional<? extends EntityLiving>> targetGetter) {
        this((E entityinsentient) -> true, targetGetter);
    }

    @Override
    protected boolean a(WorldServer world, E entity) {
        if (!this.a.test(entity)) {
            return false;
        }
        Optional<? extends EntityLiving> optional = this.c.apply(entity);
        return optional.isPresent() ? ((EntityLiving)entity).c(optional.get()) : false;
    }

    @Override
    protected void a(WorldServer world, E entity, long time) {
        this.c.apply(entity).ifPresent(entityliving -> this.a(entity, (EntityLiving)entityliving));
    }

    private void a(E entity, EntityLiving target) {
        EntityTargetLivingEntityEvent event = CraftEventFactory.callEntityTargetLivingEvent(entity, target, target instanceof EntityPlayer ? EntityTargetEvent.TargetReason.CLOSEST_PLAYER : EntityTargetEvent.TargetReason.CLOSEST_ENTITY);
        if (event.isCancelled()) {
            return;
        }
        target = event.getTarget() != null ? ((CraftLivingEntity)event.getTarget()).getHandle() : null;
        ((EntityLiving)entity).du().a(MemoryModuleType.o, target);
        ((EntityLiving)entity).du().b(MemoryModuleType.E);
    }
}

