/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import org.bukkit.craftbukkit.v1_18_R2.event.CraftEventFactory;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;

public class BehaviorAttackTargetForget<E extends EntityInsentient>
extends Behavior<E> {
    private static final int a = 200;
    private final Predicate<EntityLiving> c;
    private final Consumer<E> d;

    public BehaviorAttackTargetForget(Predicate<EntityLiving> condition, Consumer<E> forgetCallback) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.o, (Object)((Object)MemoryStatus.a), MemoryModuleType.E, (Object)((Object)MemoryStatus.c)));
        this.c = condition;
        this.d = forgetCallback;
    }

    public BehaviorAttackTargetForget(Predicate<EntityLiving> alternativeCondition) {
        this(alternativeCondition, entityinsentient -> {});
    }

    public BehaviorAttackTargetForget(Consumer<E> forgetCallback) {
        this((EntityLiving entityliving) -> false, forgetCallback);
    }

    public BehaviorAttackTargetForget() {
        this((EntityLiving entityliving) -> false, entityinsentient -> {});
    }

    @Override
    protected void a(WorldServer world, E entity, long time) {
        EntityLiving entityliving = this.c(entity);
        if (!((EntityLiving)entity).c(entityliving)) {
            this.clearAttackTarget(entity, EntityTargetEvent.TargetReason.TARGET_INVALID);
        } else if (BehaviorAttackTargetForget.a(entity)) {
            this.clearAttackTarget(entity, EntityTargetEvent.TargetReason.FORGOT_TARGET);
        } else if (this.d(entity)) {
            this.clearAttackTarget(entity, EntityTargetEvent.TargetReason.TARGET_DIED);
        } else if (this.b(entity)) {
            this.clearAttackTarget(entity, EntityTargetEvent.TargetReason.TARGET_OTHER_LEVEL);
        } else if (this.c.test(this.c(entity))) {
            this.clearAttackTarget(entity, EntityTargetEvent.TargetReason.TARGET_INVALID);
        }
    }

    private boolean b(E entity) {
        return this.c(entity).s != ((Entity)entity).s;
    }

    private EntityLiving c(E entity) {
        return ((EntityLiving)entity).du().c(MemoryModuleType.o).get();
    }

    private static <E extends EntityLiving> boolean a(E entity) {
        Optional<Long> optional = entity.du().c(MemoryModuleType.E);
        return optional.isPresent() && entity.s.U() - optional.get() > 200L;
    }

    private boolean d(E entity) {
        Optional<EntityLiving> optional = ((EntityLiving)entity).du().c(MemoryModuleType.o);
        return optional.isPresent() && !optional.get().bl();
    }

    protected void clearAttackTarget(E entity, EntityTargetEvent.TargetReason reason) {
        EntityTargetLivingEntityEvent event = CraftEventFactory.callEntityTargetLivingEvent(entity, null, reason);
        if (event.isCancelled()) {
            return;
        }
        this.d.accept(entity);
        ((EntityLiving)entity).du().b(MemoryModuleType.o);
    }
}

