/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.attributes;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.IRegistry;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public class AttributeModifiable {
    private final AttributeBase a;
    private final Map<AttributeModifier.Operation, Set<AttributeModifier>> b = Maps.newEnumMap(AttributeModifier.Operation.class);
    private final Map<UUID, AttributeModifier> c = new Object2ObjectArrayMap();
    private final Set<AttributeModifier> d = new ObjectArraySet();
    private double e;
    private boolean f = true;
    private double g;
    private final Consumer<AttributeModifiable> h;

    public AttributeModifiable(AttributeBase type, Consumer<AttributeModifiable> updateCallback) {
        this.a = type;
        this.h = updateCallback;
        this.e = type.a();
    }

    public AttributeBase a() {
        return this.a;
    }

    public double b() {
        return this.e;
    }

    public void a(double baseValue) {
        if (baseValue == this.e) {
            return;
        }
        this.e = baseValue;
        this.d();
    }

    public Set<AttributeModifier> a(AttributeModifier.Operation operation2) {
        return this.b.computeIfAbsent(operation2, operation -> Sets.newHashSet());
    }

    public Set<AttributeModifier> c() {
        return ImmutableSet.copyOf(this.c.values());
    }

    @Nullable
    public AttributeModifier a(UUID uuid) {
        return this.c.get(uuid);
    }

    public boolean a(AttributeModifier modifier) {
        return this.c.get(modifier.a()) != null;
    }

    private void e(AttributeModifier modifier) {
        AttributeModifier attributeModifier = this.c.putIfAbsent(modifier.a(), modifier);
        if (attributeModifier != null) {
            throw new IllegalArgumentException("Modifier is already applied on this attribute!");
        }
        this.a(modifier.c()).add(modifier);
        this.d();
    }

    public void b(AttributeModifier modifier) {
        this.e(modifier);
    }

    public void c(AttributeModifier modifier) {
        this.e(modifier);
        this.d.add(modifier);
    }

    protected void d() {
        this.f = true;
        this.h.accept(this);
    }

    public void d(AttributeModifier modifier) {
        this.a(modifier.c()).remove(modifier);
        this.c.remove(modifier.a());
        this.d.remove(modifier);
        this.d();
    }

    public void b(UUID uuid) {
        AttributeModifier attributeModifier = this.a(uuid);
        if (attributeModifier != null) {
            this.d(attributeModifier);
        }
    }

    public boolean c(UUID uuid) {
        AttributeModifier attributeModifier = this.a(uuid);
        if (attributeModifier != null && this.d.contains(attributeModifier)) {
            this.d(attributeModifier);
            return true;
        }
        return false;
    }

    public void e() {
        for (AttributeModifier attributeModifier : this.c()) {
            this.d(attributeModifier);
        }
    }

    public double f() {
        if (this.f) {
            this.g = this.h();
            this.f = false;
        }
        return this.g;
    }

    private double h() {
        double d2 = this.b();
        for (AttributeModifier attributeModifier : this.b(AttributeModifier.Operation.a)) {
            d2 += attributeModifier.d();
        }
        double e2 = d2;
        for (AttributeModifier attributeModifier2 : this.b(AttributeModifier.Operation.b)) {
            e2 += d2 * attributeModifier2.d();
        }
        for (AttributeModifier attributeModifier3 : this.b(AttributeModifier.Operation.c)) {
            e2 *= 1.0 + attributeModifier3.d();
        }
        return this.a.a(e2);
    }

    private Collection<AttributeModifier> b(AttributeModifier.Operation operation) {
        return this.b.getOrDefault((Object)operation, Collections.emptySet());
    }

    public void a(AttributeModifiable other) {
        this.e = other.e;
        this.c.clear();
        this.c.putAll(other.c);
        this.d.clear();
        this.d.addAll(other.d);
        this.b.clear();
        other.b.forEach((operation, modifiers) -> this.a((AttributeModifier.Operation)((Object)operation)).addAll((Collection<AttributeModifier>)modifiers));
        this.d();
    }

    public NBTTagCompound g() {
        NBTTagCompound compoundTag = new NBTTagCompound();
        compoundTag.a("Name", IRegistry.aj.b(this.a).toString());
        compoundTag.a("Base", this.e);
        if (!this.d.isEmpty()) {
            NBTTagList listTag = new NBTTagList();
            for (AttributeModifier attributeModifier : this.d) {
                listTag.add(attributeModifier.e());
            }
            compoundTag.a("Modifiers", listTag);
        }
        return compoundTag;
    }

    public void a(NBTTagCompound nbt) {
        this.e = nbt.k("Base");
        if (nbt.b("Modifiers", 9)) {
            NBTTagList listTag = nbt.c("Modifiers", 10);
            for (int i2 = 0; i2 < listTag.size(); ++i2) {
                AttributeModifier attributeModifier = AttributeModifier.a(listTag.a(i2));
                if (attributeModifier == null) continue;
                this.c.put(attributeModifier.a(), attributeModifier);
                this.a(attributeModifier.c()).add(attributeModifier);
                this.d.add(attributeModifier);
            }
        }
        this.d();
    }
}

