/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.attributes;

import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.IRegistry;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import org.slf4j.Logger;

public class AttributeMapBase {
    private static final Logger a = LogUtils.getLogger();
    private final Map<AttributeBase, AttributeModifiable> b = Maps.newHashMap();
    private final Set<AttributeModifiable> c = Sets.newHashSet();
    private final AttributeProvider d;

    public AttributeMapBase(AttributeProvider defaultAttributes) {
        this.d = defaultAttributes;
    }

    private void a(AttributeModifiable instance) {
        if (instance.a().b()) {
            this.c.add(instance);
        }
    }

    public Set<AttributeModifiable> a() {
        return this.c;
    }

    public Collection<AttributeModifiable> b() {
        return this.b.values().stream().filter(attribute -> attribute.a().b()).collect(Collectors.toList());
    }

    @Nullable
    public AttributeModifiable a(AttributeBase attribute) {
        return this.b.computeIfAbsent(attribute, attributex -> this.d.a(this::a, (AttributeBase)attributex));
    }

    public boolean b(AttributeBase attribute) {
        return this.b.get(attribute) != null || this.d.c(attribute);
    }

    public boolean a(AttributeBase attribute, UUID uuid) {
        AttributeModifiable attributeInstance = this.b.get(attribute);
        return attributeInstance != null ? attributeInstance.a(uuid) != null : this.d.b(attribute, uuid);
    }

    public double c(AttributeBase attribute) {
        AttributeModifiable attributeInstance = this.b.get(attribute);
        return attributeInstance != null ? attributeInstance.f() : this.d.a(attribute);
    }

    public double d(AttributeBase attribute) {
        AttributeModifiable attributeInstance = this.b.get(attribute);
        return attributeInstance != null ? attributeInstance.b() : this.d.b(attribute);
    }

    public double b(AttributeBase attribute, UUID uuid) {
        AttributeModifiable attributeInstance = this.b.get(attribute);
        return attributeInstance != null ? attributeInstance.a(uuid).d() : this.d.a(attribute, uuid);
    }

    public void a(Multimap<AttributeBase, AttributeModifier> attributeModifiers) {
        attributeModifiers.asMap().forEach((attribute, collection) -> {
            AttributeModifiable attributeInstance = this.b.get(attribute);
            if (attributeInstance != null) {
                collection.forEach(attributeInstance::d);
            }
        });
    }

    public void b(Multimap<AttributeBase, AttributeModifier> attributeModifiers) {
        attributeModifiers.forEach((attribute, attributeModifier) -> {
            AttributeModifiable attributeInstance = this.a((AttributeBase)attribute);
            if (attributeInstance != null) {
                attributeInstance.d((AttributeModifier)attributeModifier);
                attributeInstance.b((AttributeModifier)attributeModifier);
            }
        });
    }

    public void a(AttributeMapBase other) {
        other.b.values().forEach(attributeInstance -> {
            AttributeModifiable attributeInstance2 = this.a(attributeInstance.a());
            if (attributeInstance2 != null) {
                attributeInstance2.a((AttributeModifiable)attributeInstance);
            }
        });
    }

    public NBTTagList c() {
        NBTTagList listTag = new NBTTagList();
        for (AttributeModifiable attributeInstance : this.b.values()) {
            listTag.add(attributeInstance.g());
        }
        return listTag;
    }

    public void a(NBTTagList nbt) {
        for (int i2 = 0; i2 < nbt.size(); ++i2) {
            NBTTagCompound compoundTag = nbt.a(i2);
            String string = compoundTag.l("Name");
            SystemUtils.a(IRegistry.aj.b(MinecraftKey.a(string)), attribute -> {
                AttributeModifiable attributeInstance = this.a((AttributeBase)attribute);
                if (attributeInstance != null) {
                    attributeInstance.a(compoundTag);
                }
            }, () -> a.warn("Ignoring unknown attribute '{}'", (Object)string));
        }
    }

    public void registerAttribute(AttributeBase attributeBase) {
        AttributeModifiable attributeModifiable = new AttributeModifiable(attributeBase, AttributeModifiable::a);
        this.b.put(attributeBase, attributeModifiable);
    }
}

