/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import co.aikar.timings.MinecraftTimings;
import co.aikar.timings.Timing;
import com.destroystokyo.paper.event.entity.PreCreatureSpawnEvent;
import com.google.common.collect.ImmutableSet;
import com.mojang.logging.LogUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterator;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.MCUtil;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.MathHelper;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAreaEffectCloud;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GlowSquid;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.Marker;
import net.minecraft.world.entity.ambient.EntityBat;
import net.minecraft.world.entity.animal.EntityBee;
import net.minecraft.world.entity.animal.EntityCat;
import net.minecraft.world.entity.animal.EntityChicken;
import net.minecraft.world.entity.animal.EntityCod;
import net.minecraft.world.entity.animal.EntityCow;
import net.minecraft.world.entity.animal.EntityDolphin;
import net.minecraft.world.entity.animal.EntityFox;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.animal.EntityMushroomCow;
import net.minecraft.world.entity.animal.EntityOcelot;
import net.minecraft.world.entity.animal.EntityPanda;
import net.minecraft.world.entity.animal.EntityParrot;
import net.minecraft.world.entity.animal.EntityPig;
import net.minecraft.world.entity.animal.EntityPolarBear;
import net.minecraft.world.entity.animal.EntityPufferFish;
import net.minecraft.world.entity.animal.EntityRabbit;
import net.minecraft.world.entity.animal.EntitySalmon;
import net.minecraft.world.entity.animal.EntitySheep;
import net.minecraft.world.entity.animal.EntitySnowman;
import net.minecraft.world.entity.animal.EntitySquid;
import net.minecraft.world.entity.animal.EntityTropicalFish;
import net.minecraft.world.entity.animal.EntityTurtle;
import net.minecraft.world.entity.animal.EntityWolf;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.entity.animal.horse.EntityHorse;
import net.minecraft.world.entity.animal.horse.EntityHorseDonkey;
import net.minecraft.world.entity.animal.horse.EntityHorseMule;
import net.minecraft.world.entity.animal.horse.EntityHorseSkeleton;
import net.minecraft.world.entity.animal.horse.EntityHorseZombie;
import net.minecraft.world.entity.animal.horse.EntityLlama;
import net.minecraft.world.entity.animal.horse.EntityLlamaTrader;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderCrystal;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.boss.wither.EntityWither;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.entity.decoration.EntityItemFrame;
import net.minecraft.world.entity.decoration.EntityLeash;
import net.minecraft.world.entity.decoration.EntityPainting;
import net.minecraft.world.entity.decoration.GlowItemFrame;
import net.minecraft.world.entity.item.EntityFallingBlock;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.item.EntityTNTPrimed;
import net.minecraft.world.entity.monster.EntityBlaze;
import net.minecraft.world.entity.monster.EntityCaveSpider;
import net.minecraft.world.entity.monster.EntityCreeper;
import net.minecraft.world.entity.monster.EntityDrowned;
import net.minecraft.world.entity.monster.EntityEnderman;
import net.minecraft.world.entity.monster.EntityEndermite;
import net.minecraft.world.entity.monster.EntityEvoker;
import net.minecraft.world.entity.monster.EntityGhast;
import net.minecraft.world.entity.monster.EntityGiantZombie;
import net.minecraft.world.entity.monster.EntityGuardian;
import net.minecraft.world.entity.monster.EntityGuardianElder;
import net.minecraft.world.entity.monster.EntityIllagerIllusioner;
import net.minecraft.world.entity.monster.EntityMagmaCube;
import net.minecraft.world.entity.monster.EntityPhantom;
import net.minecraft.world.entity.monster.EntityPigZombie;
import net.minecraft.world.entity.monster.EntityPillager;
import net.minecraft.world.entity.monster.EntityRavager;
import net.minecraft.world.entity.monster.EntityShulker;
import net.minecraft.world.entity.monster.EntitySilverfish;
import net.minecraft.world.entity.monster.EntitySkeleton;
import net.minecraft.world.entity.monster.EntitySkeletonStray;
import net.minecraft.world.entity.monster.EntitySkeletonWither;
import net.minecraft.world.entity.monster.EntitySlime;
import net.minecraft.world.entity.monster.EntitySpider;
import net.minecraft.world.entity.monster.EntityStrider;
import net.minecraft.world.entity.monster.EntityVex;
import net.minecraft.world.entity.monster.EntityVindicator;
import net.minecraft.world.entity.monster.EntityWitch;
import net.minecraft.world.entity.monster.EntityZoglin;
import net.minecraft.world.entity.monster.EntityZombie;
import net.minecraft.world.entity.monster.EntityZombieHusk;
import net.minecraft.world.entity.monster.EntityZombieVillager;
import net.minecraft.world.entity.monster.hoglin.EntityHoglin;
import net.minecraft.world.entity.monster.piglin.EntityPiglin;
import net.minecraft.world.entity.monster.piglin.EntityPiglinBrute;
import net.minecraft.world.entity.npc.EntityVillager;
import net.minecraft.world.entity.npc.EntityVillagerTrader;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityDragonFireball;
import net.minecraft.world.entity.projectile.EntityEgg;
import net.minecraft.world.entity.projectile.EntityEnderPearl;
import net.minecraft.world.entity.projectile.EntityEnderSignal;
import net.minecraft.world.entity.projectile.EntityEvokerFangs;
import net.minecraft.world.entity.projectile.EntityFireworks;
import net.minecraft.world.entity.projectile.EntityFishingHook;
import net.minecraft.world.entity.projectile.EntityLargeFireball;
import net.minecraft.world.entity.projectile.EntityLlamaSpit;
import net.minecraft.world.entity.projectile.EntityPotion;
import net.minecraft.world.entity.projectile.EntityShulkerBullet;
import net.minecraft.world.entity.projectile.EntitySmallFireball;
import net.minecraft.world.entity.projectile.EntitySnowball;
import net.minecraft.world.entity.projectile.EntitySpectralArrow;
import net.minecraft.world.entity.projectile.EntityThrownExpBottle;
import net.minecraft.world.entity.projectile.EntityThrownTrident;
import net.minecraft.world.entity.projectile.EntityTippedArrow;
import net.minecraft.world.entity.projectile.EntityWitherSkull;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.entity.vehicle.EntityMinecartChest;
import net.minecraft.world.entity.vehicle.EntityMinecartCommandBlock;
import net.minecraft.world.entity.vehicle.EntityMinecartFurnace;
import net.minecraft.world.entity.vehicle.EntityMinecartHopper;
import net.minecraft.world.entity.vehicle.EntityMinecartMobSpawner;
import net.minecraft.world.entity.vehicle.EntityMinecartRideable;
import net.minecraft.world.entity.vehicle.EntityMinecartTNT;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.pathfinder.PathfinderNormal;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.entity.EntityType;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.slf4j.Logger;

public class EntityTypes<T extends Entity>
implements EntityTypeTest<Entity, T> {
    private static final Logger bk = LogUtils.getLogger();
    public static final String a = "EntityTag";
    private final Holder.c<EntityTypes<?>> bl = IRegistry.W.e(this);
    private static final float bm = 1.3964844f;
    public static final EntityTypes<EntityAreaEffectCloud> b = EntityTypes.a("area_effect_cloud", Builder.a(EntityAreaEffectCloud::new, EnumCreatureType.h).c().a(6.0f, 0.5f).a(10).b(10));
    public static final EntityTypes<EntityArmorStand> c = EntityTypes.a("armor_stand", Builder.a(EntityArmorStand::new, EnumCreatureType.h).a(0.5f, 1.975f).a(10));
    public static final EntityTypes<EntityTippedArrow> d = EntityTypes.a("arrow", Builder.a(EntityTippedArrow::new, EnumCreatureType.h).a(0.5f, 0.5f).a(4).b(20));
    public static final EntityTypes<Axolotl> e = EntityTypes.a("axolotl", Builder.a(Axolotl::new, EnumCreatureType.d).a(0.75f, 0.42f).a(10));
    public static final EntityTypes<EntityBat> f = EntityTypes.a("bat", Builder.a(EntityBat::new, EnumCreatureType.c).a(0.5f, 0.9f).a(5));
    public static final EntityTypes<EntityBee> g = EntityTypes.a("bee", Builder.a(EntityBee::new, EnumCreatureType.b).a(0.7f, 0.6f).a(8));
    public static final EntityTypes<EntityBlaze> h = EntityTypes.a("blaze", Builder.a(EntityBlaze::new, EnumCreatureType.a).c().a(0.6f, 1.8f).a(8));
    public static final EntityTypes<EntityBoat> i = EntityTypes.a("boat", Builder.a(EntityBoat::new, EnumCreatureType.h).a(1.375f, 0.5625f).a(10));
    public static final EntityTypes<EntityCat> j = EntityTypes.a("cat", Builder.a(EntityCat::new, EnumCreatureType.b).a(0.6f, 0.7f).a(8));
    public static final EntityTypes<EntityCaveSpider> k = EntityTypes.a("cave_spider", Builder.a(EntityCaveSpider::new, EnumCreatureType.a).a(0.7f, 0.5f).a(8));
    public static final EntityTypes<EntityChicken> l = EntityTypes.a("chicken", Builder.a(EntityChicken::new, EnumCreatureType.b).a(0.4f, 0.7f).a(10));
    public static final EntityTypes<EntityCod> m = EntityTypes.a("cod", Builder.a(EntityCod::new, EnumCreatureType.g).a(0.5f, 0.3f).a(4));
    public static final EntityTypes<EntityCow> n = EntityTypes.a("cow", Builder.a(EntityCow::new, EnumCreatureType.b).a(0.9f, 1.4f).a(10));
    public static final EntityTypes<EntityCreeper> o = EntityTypes.a("creeper", Builder.a(EntityCreeper::new, EnumCreatureType.a).a(0.6f, 1.7f).a(8));
    public static final EntityTypes<EntityDolphin> p = EntityTypes.a("dolphin", Builder.a(EntityDolphin::new, EnumCreatureType.f).a(0.9f, 0.6f));
    public static final EntityTypes<EntityHorseDonkey> q = EntityTypes.a("donkey", Builder.a(EntityHorseDonkey::new, EnumCreatureType.b).a(1.3964844f, 1.5f).a(10));
    public static final EntityTypes<EntityDragonFireball> r = EntityTypes.a("dragon_fireball", Builder.a(EntityDragonFireball::new, EnumCreatureType.h).a(1.0f, 1.0f).a(4).b(10));
    public static final EntityTypes<EntityDrowned> s = EntityTypes.a("drowned", Builder.a(EntityDrowned::new, EnumCreatureType.a).a(0.6f, 1.95f).a(8));
    public static final EntityTypes<EntityGuardianElder> t = EntityTypes.a("elder_guardian", Builder.a(EntityGuardianElder::new, EnumCreatureType.a).a(1.9975f, 1.9975f).a(10));
    public static final EntityTypes<EntityEnderCrystal> u = EntityTypes.a("end_crystal", Builder.a(EntityEnderCrystal::new, EnumCreatureType.h).a(2.0f, 2.0f).a(16).b(Integer.MAX_VALUE));
    public static final EntityTypes<EntityEnderDragon> v = EntityTypes.a("ender_dragon", Builder.a(EntityEnderDragon::new, EnumCreatureType.a).c().a(16.0f, 8.0f).a(10));
    public static final EntityTypes<EntityEnderman> w = EntityTypes.a("enderman", Builder.a(EntityEnderman::new, EnumCreatureType.a).a(0.6f, 2.9f).a(8));
    public static final EntityTypes<EntityEndermite> x = EntityTypes.a("endermite", Builder.a(EntityEndermite::new, EnumCreatureType.a).a(0.4f, 0.3f).a(8));
    public static final EntityTypes<EntityEvoker> y = EntityTypes.a("evoker", Builder.a(EntityEvoker::new, EnumCreatureType.a).a(0.6f, 1.95f).a(8));
    public static final EntityTypes<EntityEvokerFangs> z = EntityTypes.a("evoker_fangs", Builder.a(EntityEvokerFangs::new, EnumCreatureType.h).a(0.5f, 0.8f).a(6).b(2));
    public static final EntityTypes<EntityExperienceOrb> A = EntityTypes.a("experience_orb", Builder.a(EntityExperienceOrb::new, EnumCreatureType.h).a(0.5f, 0.5f).a(6).b(20));
    public static final EntityTypes<EntityEnderSignal> B = EntityTypes.a("eye_of_ender", Builder.a(EntityEnderSignal::new, EnumCreatureType.h).a(0.25f, 0.25f).a(4).b(4));
    public static final EntityTypes<EntityFallingBlock> C = EntityTypes.a("falling_block", Builder.a(EntityFallingBlock::new, EnumCreatureType.h).a(0.98f, 0.98f).a(10).b(20));
    public static final EntityTypes<EntityFireworks> D = EntityTypes.a("firework_rocket", Builder.a(EntityFireworks::new, EnumCreatureType.h).a(0.25f, 0.25f).a(4).b(10));
    public static final EntityTypes<EntityFox> E = EntityTypes.a("fox", Builder.a(EntityFox::new, EnumCreatureType.b).a(0.6f, 0.7f).a(8).a(Blocks.mu));
    public static final EntityTypes<EntityGhast> F = EntityTypes.a("ghast", Builder.a(EntityGhast::new, EnumCreatureType.a).c().a(4.0f, 4.0f).a(10));
    public static final EntityTypes<EntityGiantZombie> G = EntityTypes.a("giant", Builder.a(EntityGiantZombie::new, EnumCreatureType.a).a(3.6f, 12.0f).a(10));
    public static final EntityTypes<GlowItemFrame> H = EntityTypes.a("glow_item_frame", Builder.a(GlowItemFrame::new, EnumCreatureType.h).a(0.5f, 0.5f).a(10).b(Integer.MAX_VALUE));
    public static final EntityTypes<GlowSquid> I = EntityTypes.a("glow_squid", Builder.a(GlowSquid::new, EnumCreatureType.e).a(0.8f, 0.8f).a(10));
    public static final EntityTypes<Goat> J = EntityTypes.a("goat", Builder.a(Goat::new, EnumCreatureType.b).a(0.9f, 1.3f).a(10));
    public static final EntityTypes<EntityGuardian> K = EntityTypes.a("guardian", Builder.a(EntityGuardian::new, EnumCreatureType.a).a(0.85f, 0.85f).a(8));
    public static final EntityTypes<EntityHoglin> L = EntityTypes.a("hoglin", Builder.a(EntityHoglin::new, EnumCreatureType.a).a(1.3964844f, 1.4f).a(8));
    public static final EntityTypes<EntityHorse> M = EntityTypes.a("horse", Builder.a(EntityHorse::new, EnumCreatureType.b).a(1.3964844f, 1.6f).a(10));
    public static final EntityTypes<EntityZombieHusk> N = EntityTypes.a("husk", Builder.a(EntityZombieHusk::new, EnumCreatureType.a).a(0.6f, 1.95f).a(8));
    public static final EntityTypes<EntityIllagerIllusioner> O = EntityTypes.a("illusioner", Builder.a(EntityIllagerIllusioner::new, EnumCreatureType.a).a(0.6f, 1.95f).a(8));
    public static final EntityTypes<EntityIronGolem> P = EntityTypes.a("iron_golem", Builder.a(EntityIronGolem::new, EnumCreatureType.h).a(1.4f, 2.7f).a(10));
    public static final EntityTypes<EntityItem> Q = EntityTypes.a("item", Builder.a(EntityItem::new, EnumCreatureType.h).a(0.25f, 0.25f).a(6).b(20));
    public static final EntityTypes<EntityItemFrame> R = EntityTypes.a("item_frame", Builder.a(EntityItemFrame::new, EnumCreatureType.h).a(0.5f, 0.5f).a(10).b(Integer.MAX_VALUE));
    public static final EntityTypes<EntityLargeFireball> S = EntityTypes.a("fireball", Builder.a(EntityLargeFireball::new, EnumCreatureType.h).a(1.0f, 1.0f).a(4).b(10));
    public static final EntityTypes<EntityLeash> T = EntityTypes.a("leash_knot", Builder.a(EntityLeash::new, EnumCreatureType.h).b().a(0.375f, 0.5f).a(10).b(Integer.MAX_VALUE));
    public static final EntityTypes<EntityLightning> U = EntityTypes.a("lightning_bolt", Builder.a(EntityLightning::new, EnumCreatureType.h).b().a(0.0f, 0.0f).a(16).b(Integer.MAX_VALUE));
    public static final EntityTypes<EntityLlama> V = EntityTypes.a("llama", Builder.a(EntityLlama::new, EnumCreatureType.b).a(0.9f, 1.87f).a(10));
    public static final EntityTypes<EntityLlamaSpit> W = EntityTypes.a("llama_spit", Builder.a(EntityLlamaSpit::new, EnumCreatureType.h).a(0.25f, 0.25f).a(4).b(10));
    public static final EntityTypes<EntityMagmaCube> X = EntityTypes.a("magma_cube", Builder.a(EntityMagmaCube::new, EnumCreatureType.a).c().a(2.04f, 2.04f).a(8));
    public static final EntityTypes<Marker> Y = EntityTypes.a("marker", Builder.a(Marker::new, EnumCreatureType.h).a(0.0f, 0.0f).a(0));
    public static final EntityTypes<EntityMinecartRideable> Z = EntityTypes.a("minecart", Builder.a(EntityMinecartRideable::new, EnumCreatureType.h).a(0.98f, 0.7f).a(8));
    public static final EntityTypes<EntityMinecartChest> aa = EntityTypes.a("chest_minecart", Builder.a(EntityMinecartChest::new, EnumCreatureType.h).a(0.98f, 0.7f).a(8));
    public static final EntityTypes<EntityMinecartCommandBlock> ab = EntityTypes.a("command_block_minecart", Builder.a(EntityMinecartCommandBlock::new, EnumCreatureType.h).a(0.98f, 0.7f).a(8));
    public static final EntityTypes<EntityMinecartFurnace> ac = EntityTypes.a("furnace_minecart", Builder.a(EntityMinecartFurnace::new, EnumCreatureType.h).a(0.98f, 0.7f).a(8));
    public static final EntityTypes<EntityMinecartHopper> ad = EntityTypes.a("hopper_minecart", Builder.a(EntityMinecartHopper::new, EnumCreatureType.h).a(0.98f, 0.7f).a(8));
    public static final EntityTypes<EntityMinecartMobSpawner> ae = EntityTypes.a("spawner_minecart", Builder.a(EntityMinecartMobSpawner::new, EnumCreatureType.h).a(0.98f, 0.7f).a(8));
    public static final EntityTypes<EntityMinecartTNT> af = EntityTypes.a("tnt_minecart", Builder.a(EntityMinecartTNT::new, EnumCreatureType.h).a(0.98f, 0.7f).a(8));
    public static final EntityTypes<EntityHorseMule> ag = EntityTypes.a("mule", Builder.a(EntityHorseMule::new, EnumCreatureType.b).a(1.3964844f, 1.6f).a(8));
    public static final EntityTypes<EntityMushroomCow> ah = EntityTypes.a("mooshroom", Builder.a(EntityMushroomCow::new, EnumCreatureType.b).a(0.9f, 1.4f).a(10));
    public static final EntityTypes<EntityOcelot> ai = EntityTypes.a("ocelot", Builder.a(EntityOcelot::new, EnumCreatureType.b).a(0.6f, 0.7f).a(10));
    public static final EntityTypes<EntityPainting> aj = EntityTypes.a("painting", Builder.a(EntityPainting::new, EnumCreatureType.h).a(0.5f, 0.5f).a(10).b(Integer.MAX_VALUE));
    public static final EntityTypes<EntityPanda> ak = EntityTypes.a("panda", Builder.a(EntityPanda::new, EnumCreatureType.b).a(1.3f, 1.25f).a(10));
    public static final EntityTypes<EntityParrot> al = EntityTypes.a("parrot", Builder.a(EntityParrot::new, EnumCreatureType.b).a(0.5f, 0.9f).a(8));
    public static final EntityTypes<EntityPhantom> am = EntityTypes.a("phantom", Builder.a(EntityPhantom::new, EnumCreatureType.a).a(0.9f, 0.5f).a(8));
    public static final EntityTypes<EntityPig> an = EntityTypes.a("pig", Builder.a(EntityPig::new, EnumCreatureType.b).a(0.9f, 0.9f).a(10));
    public static final EntityTypes<EntityPiglin> ao = EntityTypes.a("piglin", Builder.a(EntityPiglin::new, EnumCreatureType.a).a(0.6f, 1.95f).a(8));
    public static final EntityTypes<EntityPiglinBrute> ap = EntityTypes.a("piglin_brute", Builder.a(EntityPiglinBrute::new, EnumCreatureType.a).a(0.6f, 1.95f).a(8));
    public static final EntityTypes<EntityPillager> aq = EntityTypes.a("pillager", Builder.a(EntityPillager::new, EnumCreatureType.a).d().a(0.6f, 1.95f).a(8));
    public static final EntityTypes<EntityPolarBear> ar = EntityTypes.a("polar_bear", Builder.a(EntityPolarBear::new, EnumCreatureType.b).a(Blocks.oO).a(1.4f, 1.4f).a(10));
    public static final EntityTypes<EntityTNTPrimed> as = EntityTypes.a("tnt", Builder.a(EntityTNTPrimed::new, EnumCreatureType.h).c().a(0.98f, 0.98f).a(10).b(10));
    public static final EntityTypes<EntityPufferFish> at = EntityTypes.a("pufferfish", Builder.a(EntityPufferFish::new, EnumCreatureType.g).a(0.7f, 0.7f).a(4));
    public static final EntityTypes<EntityRabbit> au = EntityTypes.a("rabbit", Builder.a(EntityRabbit::new, EnumCreatureType.b).a(0.4f, 0.5f).a(8));
    public static final EntityTypes<EntityRavager> av = EntityTypes.a("ravager", Builder.a(EntityRavager::new, EnumCreatureType.a).a(1.95f, 2.2f).a(10));
    public static final EntityTypes<EntitySalmon> aw = EntityTypes.a("salmon", Builder.a(EntitySalmon::new, EnumCreatureType.g).a(0.7f, 0.4f).a(4));
    public static final EntityTypes<EntitySheep> ax = EntityTypes.a("sheep", Builder.a(EntitySheep::new, EnumCreatureType.b).a(0.9f, 1.3f).a(10));
    public static final EntityTypes<EntityShulker> ay = EntityTypes.a("shulker", Builder.a(EntityShulker::new, EnumCreatureType.a).c().d().a(1.0f, 1.0f).a(10));
    public static final EntityTypes<EntityShulkerBullet> az = EntityTypes.a("shulker_bullet", Builder.a(EntityShulkerBullet::new, EnumCreatureType.h).a(0.3125f, 0.3125f).a(8));
    public static final EntityTypes<EntitySilverfish> aA = EntityTypes.a("silverfish", Builder.a(EntitySilverfish::new, EnumCreatureType.a).a(0.4f, 0.3f).a(8));
    public static final EntityTypes<EntitySkeleton> aB = EntityTypes.a("skeleton", Builder.a(EntitySkeleton::new, EnumCreatureType.a).a(0.6f, 1.99f).a(8));
    public static final EntityTypes<EntityHorseSkeleton> aC = EntityTypes.a("skeleton_horse", Builder.a(EntityHorseSkeleton::new, EnumCreatureType.b).a(1.3964844f, 1.6f).a(10));
    public static final EntityTypes<EntitySlime> aD = EntityTypes.a("slime", Builder.a(EntitySlime::new, EnumCreatureType.a).a(2.04f, 2.04f).a(10));
    public static final EntityTypes<EntitySmallFireball> aE = EntityTypes.a("small_fireball", Builder.a(EntitySmallFireball::new, EnumCreatureType.h).a(0.3125f, 0.3125f).a(4).b(10));
    public static final EntityTypes<EntitySnowman> aF = EntityTypes.a("snow_golem", Builder.a(EntitySnowman::new, EnumCreatureType.h).a(Blocks.oO).a(0.7f, 1.9f).a(8));
    public static final EntityTypes<EntitySnowball> aG = EntityTypes.a("snowball", Builder.a(EntitySnowball::new, EnumCreatureType.h).a(0.25f, 0.25f).a(4).b(10));
    public static final EntityTypes<EntitySpectralArrow> aH = EntityTypes.a("spectral_arrow", Builder.a(EntitySpectralArrow::new, EnumCreatureType.h).a(0.5f, 0.5f).a(4).b(20));
    public static final EntityTypes<EntitySpider> aI = EntityTypes.a("spider", Builder.a(EntitySpider::new, EnumCreatureType.a).a(1.4f, 0.9f).a(8));
    public static final EntityTypes<EntitySquid> aJ = EntityTypes.a("squid", Builder.a(EntitySquid::new, EnumCreatureType.f).a(0.8f, 0.8f).a(8));
    public static final EntityTypes<EntitySkeletonStray> aK = EntityTypes.a("stray", Builder.a(EntitySkeletonStray::new, EnumCreatureType.a).a(0.6f, 1.99f).a(Blocks.oO).a(8));
    public static final EntityTypes<EntityStrider> aL = EntityTypes.a("strider", Builder.a(EntityStrider::new, EnumCreatureType.b).c().a(0.9f, 1.7f).a(10));
    public static final EntityTypes<EntityEgg> aM = EntityTypes.a("egg", Builder.a(EntityEgg::new, EnumCreatureType.h).a(0.25f, 0.25f).a(4).b(10));
    public static final EntityTypes<EntityEnderPearl> aN = EntityTypes.a("ender_pearl", Builder.a(EntityEnderPearl::new, EnumCreatureType.h).a(0.25f, 0.25f).a(4).b(10));
    public static final EntityTypes<EntityThrownExpBottle> aO = EntityTypes.a("experience_bottle", Builder.a(EntityThrownExpBottle::new, EnumCreatureType.h).a(0.25f, 0.25f).a(4).b(10));
    public static final EntityTypes<EntityPotion> aP = EntityTypes.a("potion", Builder.a(EntityPotion::new, EnumCreatureType.h).a(0.25f, 0.25f).a(4).b(10));
    public static final EntityTypes<EntityThrownTrident> aQ = EntityTypes.a("trident", Builder.a(EntityThrownTrident::new, EnumCreatureType.h).a(0.5f, 0.5f).a(4).b(20));
    public static final EntityTypes<EntityLlamaTrader> aR = EntityTypes.a("trader_llama", Builder.a(EntityLlamaTrader::new, EnumCreatureType.b).a(0.9f, 1.87f).a(10));
    public static final EntityTypes<EntityTropicalFish> aS = EntityTypes.a("tropical_fish", Builder.a(EntityTropicalFish::new, EnumCreatureType.g).a(0.5f, 0.4f).a(4));
    public static final EntityTypes<EntityTurtle> aT = EntityTypes.a("turtle", Builder.a(EntityTurtle::new, EnumCreatureType.b).a(1.2f, 0.4f).a(10));
    public static final EntityTypes<EntityVex> aU = EntityTypes.a("vex", Builder.a(EntityVex::new, EnumCreatureType.a).c().a(0.4f, 0.8f).a(8));
    public static final EntityTypes<EntityVillager> aV = EntityTypes.a("villager", Builder.a(EntityVillager::new, EnumCreatureType.h).a(0.6f, 1.95f).a(10));
    public static final EntityTypes<EntityVindicator> aW = EntityTypes.a("vindicator", Builder.a(EntityVindicator::new, EnumCreatureType.a).a(0.6f, 1.95f).a(8));
    public static final EntityTypes<EntityVillagerTrader> aX = EntityTypes.a("wandering_trader", Builder.a(EntityVillagerTrader::new, EnumCreatureType.b).a(0.6f, 1.95f).a(10));
    public static final EntityTypes<EntityWitch> aY = EntityTypes.a("witch", Builder.a(EntityWitch::new, EnumCreatureType.a).a(0.6f, 1.95f).a(8));
    public static final EntityTypes<EntityWither> aZ = EntityTypes.a("wither", Builder.a(EntityWither::new, EnumCreatureType.a).c().a(Blocks.bG).a(0.9f, 3.5f).a(10));
    public static final EntityTypes<EntitySkeletonWither> ba = EntityTypes.a("wither_skeleton", Builder.a(EntitySkeletonWither::new, EnumCreatureType.a).c().a(Blocks.bG).a(0.7f, 2.4f).a(8));
    public static final EntityTypes<EntityWitherSkull> bb = EntityTypes.a("wither_skull", Builder.a(EntityWitherSkull::new, EnumCreatureType.h).a(0.3125f, 0.3125f).a(4).b(10));
    public static final EntityTypes<EntityWolf> bc = EntityTypes.a("wolf", Builder.a(EntityWolf::new, EnumCreatureType.b).a(0.6f, 0.85f).a(10));
    public static final EntityTypes<EntityZoglin> bd = EntityTypes.a("zoglin", Builder.a(EntityZoglin::new, EnumCreatureType.a).c().a(1.3964844f, 1.4f).a(8));
    public static final EntityTypes<EntityZombie> be = EntityTypes.a("zombie", Builder.a(EntityZombie::new, EnumCreatureType.a).a(0.6f, 1.95f).a(8));
    public static final EntityTypes<EntityHorseZombie> bf = EntityTypes.a("zombie_horse", Builder.a(EntityHorseZombie::new, EnumCreatureType.b).a(1.3964844f, 1.6f).a(10));
    public static final EntityTypes<EntityZombieVillager> bg = EntityTypes.a("zombie_villager", Builder.a(EntityZombieVillager::new, EnumCreatureType.a).a(0.6f, 1.95f).a(8));
    public static final EntityTypes<EntityPigZombie> bh = EntityTypes.a("zombified_piglin", Builder.a(EntityPigZombie::new, EnumCreatureType.a).c().a(0.6f, 1.95f).a(8));
    public static final EntityTypes<EntityHuman> bi = EntityTypes.a("player", Builder.a(EnumCreatureType.h).b().a().a(0.6f, 1.8f).a(32).b(2));
    public static final EntityTypes<EntityFishingHook> bj = EntityTypes.a("fishing_bobber", Builder.a(EntityFishingHook::new, EnumCreatureType.h).b().a().a(0.25f, 0.25f).a(4).b(5));
    private final b<T> bn;
    private final EnumCreatureType bo;
    private final ImmutableSet<Block> bp;
    private final boolean bq;
    private final boolean br;
    private final boolean bs;
    private final boolean bt;
    private final int bu;
    private final int bv;
    @Nullable
    private String bw;
    @Nullable
    private IChatBaseComponent bx;
    @Nullable
    private MinecraftKey by;
    private final EntitySize bz;
    public final String id;
    public final Timing tickTimer;
    public final Timing inactiveTickTimer;
    public final Timing passengerTickTimer;
    public final Timing passengerInactiveTickTimer;

    private static <T extends Entity> EntityTypes<T> a(String id, Builder type) {
        return IRegistry.a(IRegistry.W, id, type.a(id));
    }

    public static MinecraftKey a(EntityTypes<?> type) {
        return IRegistry.W.b(type);
    }

    public static Optional<EntityTypes<?>> a(String id) {
        return IRegistry.W.b(MinecraftKey.a(id));
    }

    public EntityTypes(b<T> factory, EnumCreatureType spawnGroup, boolean saveable, boolean summonable, boolean fireImmune, boolean spawnableFarFromPlayer, ImmutableSet<Block> canSpawnInside, EntitySize dimensions, int maxTrackDistance, int trackTickInterval) {
        this(factory, spawnGroup, saveable, summonable, fireImmune, spawnableFarFromPlayer, canSpawnInside, dimensions, maxTrackDistance, trackTickInterval, "custom");
    }

    public EntityTypes(b<T> factory, EnumCreatureType spawnGroup, boolean saveable, boolean summonable, boolean fireImmune, boolean spawnableFarFromPlayer, ImmutableSet<Block> canSpawnInside, EntitySize dimensions, int maxTrackDistance, int trackTickInterval, String id) {
        this.bn = factory;
        this.bo = spawnGroup;
        this.bt = spawnableFarFromPlayer;
        this.bq = saveable;
        this.br = summonable;
        this.bs = fireImmune;
        this.bp = canSpawnInside;
        this.bz = dimensions;
        this.bu = maxTrackDistance;
        this.bv = trackTickInterval;
        this.id = id;
        this.tickTimer = MinecraftTimings.getEntityTimings(id, "tick");
        this.inactiveTickTimer = MinecraftTimings.getEntityTimings(id, "inactiveTick");
        this.passengerTickTimer = MinecraftTimings.getEntityTimings(id, "passengerTick");
        this.passengerInactiveTickTimer = MinecraftTimings.getEntityTimings(id, "passengerInactiveTick");
    }

    @Nullable
    public Entity a(WorldServer world, @Nullable ItemStack stack, @Nullable EntityHuman player, BlockPosition pos, EnumMobSpawn spawnReason, boolean alignPosition, boolean invertY) {
        return this.a(world, stack == null ? null : stack.t(), stack != null && stack.y() ? stack.w() : null, player, pos, spawnReason, alignPosition, invertY);
    }

    @Nullable
    public T a(WorldServer world, @Nullable NBTTagCompound itemNbt, @Nullable IChatBaseComponent name, @Nullable EntityHuman player, BlockPosition pos, EnumMobSpawn spawnReason, boolean alignPosition, boolean invertY) {
        return this.spawn(world, itemNbt, name, player, pos, spawnReason, alignPosition, invertY, CreatureSpawnEvent.SpawnReason.SPAWNER_EGG);
    }

    @Nullable
    public T spawn(WorldServer worldserver, @Nullable NBTTagCompound nbttagcompound, @Nullable IChatBaseComponent ichatbasecomponent, @Nullable EntityHuman entityhuman, BlockPosition blockposition, EnumMobSpawn enummobspawn, boolean flag, boolean flag1, CreatureSpawnEvent.SpawnReason spawnReason) {
        return this.spawn(worldserver, nbttagcompound, ichatbasecomponent, entityhuman, blockposition, enummobspawn, flag, flag1, spawnReason, null);
    }

    @Nullable
    public T spawn(WorldServer worldserver, @Nullable NBTTagCompound nbttagcompound, @Nullable IChatBaseComponent ichatbasecomponent, @Nullable EntityHuman entityhuman, BlockPosition blockposition, EnumMobSpawn enummobspawn, boolean flag, boolean flag1, CreatureSpawnEvent.SpawnReason spawnReason, @Nullable Consumer<T> op) {
        PreCreatureSpawnEvent event;
        EntityType type = EntityType.fromName((String)EntityTypes.a(this).a());
        if (type != null && !(event = new PreCreatureSpawnEvent(MCUtil.toLocation(worldserver, blockposition), type, spawnReason)).callEvent()) {
            return null;
        }
        T t0 = this.b(worldserver, nbttagcompound, ichatbasecomponent, entityhuman, blockposition, enummobspawn, flag, flag1);
        if (t0 != null && op != null) {
            op.accept(t0);
        }
        if (t0 != null) {
            worldserver.addFreshEntityWithPassengers((Entity)t0, spawnReason);
            return (T)(!((Entity)t0).dp() ? t0 : null);
        }
        return t0;
    }

    @Nullable
    public T b(WorldServer world, @Nullable NBTTagCompound itemNbt, @Nullable IChatBaseComponent name, @Nullable EntityHuman player, BlockPosition pos, EnumMobSpawn spawnReason, boolean alignPosition, boolean invertY) {
        double d0;
        T t0 = this.a(world);
        if (t0 == null) {
            return null;
        }
        if (alignPosition) {
            ((Entity)t0).e((double)pos.u() + 0.5, pos.v() + 1, (double)pos.w() + 0.5);
            d0 = EntityTypes.a((IWorldReader)world, pos, invertY, ((Entity)t0).cw());
        } else {
            d0 = 0.0;
        }
        ((Entity)t0).b((double)pos.u() + 0.5, (double)pos.v() + d0, (double)pos.w() + 0.5, MathHelper.g(world.v.nextFloat() * 360.0f), 0.0f);
        if (t0 instanceof EntityInsentient) {
            EntityInsentient entityinsentient = (EntityInsentient)t0;
            entityinsentient.aZ = entityinsentient.dn();
            entityinsentient.aX = entityinsentient.dn();
            entityinsentient.a(world, world.d_(entityinsentient.cW()), spawnReason, (GroupDataEntity)null, itemNbt);
            entityinsentient.K();
        }
        if (name != null && t0 instanceof EntityLiving) {
            ((Entity)t0).a(name);
        }
        try {
            EntityTypes.a(world, player, t0, itemNbt);
        }
        catch (Throwable t2) {
            bk.warn("Error loading spawn egg NBT", t2);
        }
        return t0;
    }

    protected static double a(IWorldReader world, BlockPosition pos, boolean invertY, AxisAlignedBB boundingBox) {
        AxisAlignedBB axisalignedbb1 = new AxisAlignedBB(pos);
        if (invertY) {
            axisalignedbb1 = axisalignedbb1.b(0.0, -1.0, 0.0);
        }
        Iterable<VoxelShape> iterable = world.c((Entity)null, axisalignedbb1);
        return 1.0 + VoxelShapes.a(EnumDirection.EnumAxis.b, boundingBox, iterable, invertY ? -2.0 : -1.0);
    }

    public static void a(World world, @Nullable EntityHuman player, @Nullable Entity entity, @Nullable NBTTagCompound itemNbt) {
        MinecraftServer minecraftserver;
        if (itemNbt != null && itemNbt.b(a, 10) && (minecraftserver = world.n()) != null && entity != null && (world.x || !entity.cD() || player != null && minecraftserver.ac().f(player.fq()))) {
            NBTTagCompound nbttagcompound1 = entity.f(new NBTTagCompound());
            UUID uuid = entity.cm();
            nbttagcompound1.a(itemNbt.p(a));
            entity.a_(uuid);
            entity.g(nbttagcompound1);
        }
    }

    public boolean b() {
        return this.bq;
    }

    public boolean c() {
        return this.br;
    }

    public boolean d() {
        return this.bs;
    }

    public boolean e() {
        return this.bt;
    }

    public EnumCreatureType f() {
        return this.bo;
    }

    public String g() {
        if (this.bw == null) {
            this.bw = SystemUtils.a("entity", IRegistry.W.b(this));
        }
        return this.bw;
    }

    public IChatBaseComponent h() {
        if (this.bx == null) {
            this.bx = new ChatMessage(this.g());
        }
        return this.bx;
    }

    public String toString() {
        return this.g();
    }

    public String i() {
        int i2 = this.g().lastIndexOf(46);
        return i2 == -1 ? this.g() : this.g().substring(i2 + 1);
    }

    public MinecraftKey j() {
        if (this.by == null) {
            MinecraftKey minecraftkey = IRegistry.W.b(this);
            this.by = new MinecraftKey(minecraftkey.b(), "entities/" + minecraftkey.a());
        }
        return this.by;
    }

    public float k() {
        return this.bz.a;
    }

    public float l() {
        return this.bz.b;
    }

    @Override
    @Nullable
    public T a(World world) {
        return this.bn.create(this, world);
    }

    @Nullable
    public static Entity a(int type, World world) {
        return EntityTypes.a(world, IRegistry.W.a(type));
    }

    public static Optional<Entity> a(NBTTagCompound nbt, World world) {
        return SystemUtils.a(EntityTypes.a(nbt).map(entitytypes -> entitytypes.a(world)), (T entity) -> entity.g(nbt), () -> bk.warn("Skipping Entity with id {}", (Object)nbt.l("id")));
    }

    @Nullable
    private static Entity a(World world, @Nullable EntityTypes<?> type) {
        return type == null ? null : (Entity)type.a(world);
    }

    public AxisAlignedBB a(double feetX, double feetY, double feetZ) {
        float f2 = this.k() / 2.0f;
        return new AxisAlignedBB(feetX - (double)f2, feetY, feetZ - (double)f2, feetX + (double)f2, feetY + (double)this.l(), feetZ + (double)f2);
    }

    @Override
    public boolean a(IBlockData state) {
        return this.bp.contains((Object)state.b()) ? false : (!this.bs && PathfinderNormal.a(state) ? true : state.a(Blocks.bG) || state.a(Blocks.mu) || state.a(Blocks.cN) || state.a(Blocks.oO));
    }

    public EntitySize m() {
        return this.bz;
    }

    public static Optional<EntityTypes<?>> a(NBTTagCompound nbt) {
        return IRegistry.W.b(new MinecraftKey(nbt.l("id")));
    }

    @Nullable
    public static Entity a(NBTTagCompound nbt, World world, Function<Entity, Entity> entityProcessor) {
        return EntityTypes.b(nbt, world).map(entityProcessor).map(entity -> {
            if (nbt.b("Passengers", 9)) {
                NBTTagList nbttaglist = nbt.c("Passengers", 10);
                for (int i2 = 0; i2 < nbttaglist.size(); ++i2) {
                    Entity entity1 = EntityTypes.a(nbttaglist.a(i2), world, entityProcessor);
                    if (entity1 == null) continue;
                    entity1.a((Entity)entity, true);
                }
            }
            return entity;
        }).orElse(null);
    }

    public static Stream<Entity> a(final List<? extends NBTBase> entityNbtList, final World world) {
        final Spliterator<? extends NBTBase> spliterator = entityNbtList.spliterator();
        return StreamSupport.stream(new Spliterator<Entity>(){
            final Map<EntityTypes<?>, Integer> loadedEntityCounts = new HashMap();

            @Override
            public boolean tryAdvance(Consumer<? super Entity> consumer) {
                return spliterator.tryAdvance((? super T nbtbase) -> EntityTypes.a((NBTTagCompound)nbtbase, world, entity -> {
                    EntityTypes<?> entityType = entity.ad();
                    int saveLimit = world2.paperConfig.entityPerChunkSaveLimits.getOrDefault(entityType, -1);
                    if (saveLimit > -1) {
                        if (this.loadedEntityCounts.getOrDefault(entityType, 0) >= saveLimit) {
                            return null;
                        }
                        this.loadedEntityCounts.merge(entityType, 1, Integer::sum);
                    }
                    consumer.accept((Entity)entity);
                    return entity;
                }));
            }

            @Override
            public Spliterator<Entity> trySplit() {
                return null;
            }

            @Override
            public long estimateSize() {
                return entityNbtList.size();
            }

            @Override
            public int characteristics() {
                return 1297;
            }
        }, false);
    }

    private static Optional<Entity> b(NBTTagCompound nbt, World world) {
        try {
            return EntityTypes.a(nbt, world);
        }
        catch (RuntimeException runtimeexception) {
            bk.warn("Exception loading entity: ", (Throwable)runtimeexception);
            return Optional.empty();
        }
    }

    public int n() {
        return this.bu;
    }

    public int o() {
        return this.bv;
    }

    public boolean p() {
        return this != bi && this != W && this != aZ && this != f && this != R && this != H && this != T && this != aj && this != u && this != z;
    }

    @Override
    public boolean a(TagKey<EntityTypes<?>> tag) {
        return this.bl.a(tag);
    }

    @Override
    @Nullable
    public T a(Entity obj) {
        return (T)(obj.ad() == this ? obj : null);
    }

    @Override
    public Class<? extends Entity> a() {
        return Entity.class;
    }

    @Deprecated
    public Holder.c<EntityTypes<?>> q() {
        return this.bl;
    }

    public static Set<MinecraftKey> getEntityNameList() {
        return IRegistry.W.d();
    }

    public static class Builder<T extends Entity> {
        private final b<T> a;
        private final EnumCreatureType b;
        private ImmutableSet<Block> c = ImmutableSet.of();
        private boolean d = true;
        private boolean e = true;
        private boolean f;
        private boolean g;
        private int h = 5;
        private int i = 3;
        private EntitySize j = EntitySize.b(0.6f, 1.8f);

        private Builder(b<T> factory, EnumCreatureType spawnGroup) {
            this.a = factory;
            this.b = spawnGroup;
            this.g = spawnGroup == EnumCreatureType.b || spawnGroup == EnumCreatureType.h;
        }

        public static <T extends Entity> Builder<T> a(b factory, EnumCreatureType spawnGroup) {
            return new Builder<T>(factory, spawnGroup);
        }

        public static <T extends Entity> Builder<T> a(EnumCreatureType spawnGroup) {
            return new Builder<Entity>((entitytypes, world) -> null, spawnGroup);
        }

        public Builder<T> a(float width, float height) {
            this.j = EntitySize.b(width, height);
            return this;
        }

        public Builder<T> a() {
            this.e = false;
            return this;
        }

        public Builder<T> b() {
            this.d = false;
            return this;
        }

        public Builder<T> c() {
            this.f = true;
            return this;
        }

        public Builder<T> a(Block ... blocks) {
            this.c = ImmutableSet.copyOf((Object[])blocks);
            return this;
        }

        public Builder<T> d() {
            this.g = true;
            return this;
        }

        public Builder<T> a(int maxTrackingRange) {
            this.h = maxTrackingRange;
            return this;
        }

        public Builder<T> b(int trackingTickInterval) {
            this.i = trackingTickInterval;
            return this;
        }

        public EntityTypes<T> a(String id) {
            if (this.d) {
                SystemUtils.a(DataConverterTypes.p, id);
            }
            return new EntityTypes<T>(this.a, this.b, this.d, this.e, this.f, this.g, this.c, this.j, this.h, this.i, id);
        }
    }

    public static interface b<T extends Entity> {
        public T create(EntityTypes<T> var1, World var2);
    }
}

