/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;

public class EntitySize {
    public final float a;
    public final float b;
    public final boolean c;

    public EntitySize(float width, float height, boolean fixed) {
        this.a = width;
        this.b = height;
        this.c = fixed;
    }

    public AxisAlignedBB a(Vec3D pos) {
        return this.a(pos.b, pos.c, pos.d);
    }

    public AxisAlignedBB a(double x2, double y2, double z2) {
        float f2 = this.a / 2.0f;
        float g2 = this.b;
        return new AxisAlignedBB(x2 - (double)f2, y2, z2 - (double)f2, x2 + (double)f2, y2 + (double)g2, z2 + (double)f2);
    }

    public EntitySize a(float ratio) {
        return this.a(ratio, ratio);
    }

    public EntitySize a(float widthRatio, float heightRatio) {
        if (this.c || widthRatio == 1.0f && heightRatio == 1.0f) {
            return this;
        }
        return EntitySize.b(this.a * widthRatio, this.b * heightRatio);
    }

    public static EntitySize b(float width, float height) {
        return new EntitySize(width, height, false);
    }

    public static EntitySize c(float width, float height) {
        return new EntitySize(width, height, true);
    }

    @Override
    public String toString() {
        return "EntityDimensions w=" + this.a + ", h=" + this.b + ", fixed=" + this.c;
    }
}

