/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.destroystokyo.paper.event.entity.EntityJumpEvent;
import com.destroystokyo.paper.event.entity.EntityKnockbackByEntityEvent;
import com.destroystokyo.paper.event.player.PlayerArmorChangeEvent;
import com.destroystokyo.paper.event.player.PlayerAttackEntityCooldownResetEvent;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import io.papermc.paper.event.entity.EntityMoveEvent;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.BlockUtil;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.commands.arguments.ArgumentAnchor;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.ParticleParamItem;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutAnimation;
import net.minecraft.network.protocol.game.PacketPlayOutCollect;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEquipment;
import net.minecraft.network.protocol.game.PacketPlayOutEntityStatus;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntityLiving;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsEntity;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.damagesource.CombatMath;
import net.minecraft.world.damagesource.CombatTracker;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTameableAnimal;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.EnumMonsterType;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeDefaults;
import net.minecraft.world.entity.ai.attributes.AttributeMapBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityBird;
import net.minecraft.world.entity.animal.EntityWolf;
import net.minecraft.world.entity.boss.wither.EntityWither;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.food.FoodInfo;
import net.minecraft.world.item.EnumAnimation;
import net.minecraft.world.item.ItemArmor;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemElytra;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionUtil;
import net.minecraft.world.item.enchantment.EnchantmentFrostWalker;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ICollisionAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.block.BlockBed;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.BlockHoney;
import net.minecraft.world.level.block.BlockLadder;
import net.minecraft.world.level.block.BlockSkullAbstract;
import net.minecraft.world.level.block.BlockTrapdoor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PowderSnowBlock;
import net.minecraft.world.level.block.SoundEffectType;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.scores.ScoreboardTeam;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_18_R2.attribute.CraftAttributeMap;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_18_R2.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftItemStack;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.ArrowBodyCountChangeEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityDropItemEvent;
import org.bukkit.event.entity.EntityExhaustionEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntityResurrectEvent;
import org.bukkit.event.entity.EntityTeleportEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.meta.BundleMeta;
import org.bukkit.util.Vector;
import org.slf4j.Logger;
import org.spigotmc.AsyncCatcher;
import org.spigotmc.SpigotConfig;

public abstract class EntityLiving
extends Entity {
    private static final Logger b = LogUtils.getLogger();
    private static final UUID c = UUID.fromString("662A6B8D-DA3E-4C1C-8813-96EA6097278D");
    private static final UUID d = UUID.fromString("87f46a96-686f-4796-b035-22e16ee9e038");
    private static final UUID e = UUID.fromString("1eaf83ff-7207-4596-b37a-d7a07b3ec4ce");
    private static final AttributeModifier bE = new AttributeModifier(c, "Sprinting speed boost", (double)0.3f, AttributeModifier.Operation.c);
    public static final int ao = 2;
    public static final int ap = 4;
    public static final int aq = 98;
    public static final int ar = 100;
    public static final int as = 6;
    public static final int at = 100;
    private static final int bF = 40;
    public static final double au = 0.003;
    public static final double av = 0.08;
    public static final int aw = 20;
    private static final int bG = 7;
    private static final int bH = 10;
    private static final int bI = 2;
    public static final int ax = 4;
    private static final double bJ = 128.0;
    protected static final int ay = 1;
    protected static final int az = 2;
    protected static final int aA = 4;
    protected static final DataWatcherObject<Byte> aB = DataWatcher.a(EntityLiving.class, DataWatcherRegistry.a);
    public static final DataWatcherObject<Float> bK = DataWatcher.a(EntityLiving.class, DataWatcherRegistry.c);
    private static final DataWatcherObject<Integer> bL = DataWatcher.a(EntityLiving.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Boolean> bM = DataWatcher.a(EntityLiving.class, DataWatcherRegistry.i);
    public static final DataWatcherObject<Integer> bN = DataWatcher.a(EntityLiving.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Integer> bO = DataWatcher.a(EntityLiving.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Optional<BlockPosition>> bP = DataWatcher.a(EntityLiving.class, DataWatcherRegistry.m);
    protected static final float aC = 1.74f;
    protected static final EntitySize aD = EntitySize.c(0.2f, 0.2f);
    public static final float aE = 0.5f;
    private final AttributeMapBase bQ;
    public CombatTracker bR = new CombatTracker(this);
    public final Map<MobEffectList, MobEffect> bS = Maps.newHashMap();
    private final NonNullList<ItemStack> bT;
    private final NonNullList<ItemStack> bU;
    public boolean aF;
    private boolean bV;
    public EnumHand aG;
    public int aH;
    public int aI;
    public int aJ;
    public int aK;
    public int aL;
    public float aM;
    public int aN;
    public float aO;
    public float aP;
    protected int aQ;
    public float aR;
    public float aS;
    public float aT;
    public int aU;
    public final float aV;
    public final float aW;
    public float aX;
    public float aY;
    public float aZ;
    public float ba;
    public float bb;
    @Nullable
    public EntityHuman bc;
    public int bd;
    protected boolean be;
    protected int bf;
    protected float bg;
    protected float bh;
    protected float bi;
    protected float bj;
    protected float bk;
    protected int bl;
    public float bm;
    public boolean bn;
    public float bo;
    public float bp;
    public float bq;
    protected int br;
    protected double bs;
    protected double bt;
    protected double bu;
    protected double bv;
    protected double bw;
    protected double bx;
    protected int by;
    public boolean bW;
    @Nullable
    public EntityLiving bX;
    public int bY;
    private EntityLiving bZ;
    private int ca;
    private float cb;
    private int cc;
    private float cd;
    protected ItemStack bz;
    protected int bA;
    protected int bB;
    private BlockPosition ce;
    private Optional<BlockPosition> cf;
    @Nullable
    private DamageSource cg;
    private long ch;
    protected int bC;
    private float ci;
    private float cj;
    protected BehaviorController<?> bD;
    public int expToDrop;
    public boolean forceDrops;
    public ArrayList<org.bukkit.inventory.ItemStack> drops = new ArrayList();
    public final CraftAttributeMap craftAttributes;
    public boolean collides = true;
    public Set<UUID> collidableExemptions = new HashSet<UUID>();
    public boolean bukkitPickUpLoot;
    public boolean silentDeath = false;
    private boolean isTickingEffects = false;
    private List<ProcessableEffect> effectsToProcess = Lists.newArrayList();
    protected boolean clearEquipmentSlots = true;
    protected Set<EnumItemSlot> clearedEquipmentSlots = new HashSet<EnumItemSlot>();
    protected long lastJumpTime = 0L;
    protected long eatStartTime;
    protected int totalEatTimeTicks;
    public int shieldBlockingDelay;

    public CraftLivingEntity getBukkitLivingEntity() {
        return (CraftLivingEntity)super.getBukkitEntity();
    }

    @Override
    public float getBukkitYaw() {
        return this.ce();
    }

    @Override
    public void inactiveTick() {
        super.inactiveTick();
        ++this.bf;
    }

    protected EntityLiving(EntityTypes<? extends EntityLiving> type, net.minecraft.world.level.World world) {
        super(type, world);
        this.shieldBlockingDelay = this.s.paperConfig.shieldBlockingDelay;
        this.bT = NonNullList.a(2, ItemStack.b);
        this.bU = NonNullList.a(4, ItemStack.b);
        this.bV = false;
        this.aU = 20;
        this.bb = 0.02f;
        this.bW = true;
        this.bz = ItemStack.b;
        this.cf = Optional.empty();
        this.bQ = new AttributeMapBase(AttributeDefaults.a(type));
        this.craftAttributes = new CraftAttributeMap(this.bQ);
        this.Y.b(bK, Float.valueOf((float)this.a(GenericAttributes.a).f()));
        this.q = true;
        this.aW = (float)((Math.random() + 1.0) * (double)0.01f);
        this.am();
        this.aV = (float)Math.random() * 12398.0f;
        this.o((float)(Math.random() * 6.2831854820251465));
        this.aZ = this.dn();
        this.P = 0.6f;
        DynamicOpsNBT dynamicopsnbt = DynamicOpsNBT.a;
        this.bD = this.a(new Dynamic<NBTBase>(dynamicopsnbt, (NBTBase)dynamicopsnbt.createMap((Map)ImmutableMap.of((Object)dynamicopsnbt.a("memories"), (Object)((NBTBase)dynamicopsnbt.emptyMap())))));
    }

    public BehaviorController<?> du() {
        return this.bD;
    }

    protected BehaviorController.b<?> dv() {
        return BehaviorController.a(ImmutableList.of(), ImmutableList.of());
    }

    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return this.dv().a(dynamic);
    }

    @Override
    public void ag() {
        this.a(DamageSource.m, Float.MAX_VALUE);
    }

    public boolean a(EntityTypes<?> type) {
        return true;
    }

    @Override
    protected void a_() {
        this.Y.a(aB, (byte)0);
        this.Y.a(bL, 0);
        this.Y.a(bM, false);
        this.Y.a(bN, 0);
        this.Y.a(bO, 0);
        this.Y.a(bK, Float.valueOf(1.0f));
        this.Y.a(bP, Optional.empty());
    }

    public static AttributeProvider.Builder dw() {
        return AttributeProvider.a().a(GenericAttributes.a).a(GenericAttributes.c).a(GenericAttributes.d).a(GenericAttributes.i).a(GenericAttributes.j);
    }

    @Override
    protected void a(double heightDifference, boolean onGround, IBlockData landedState, BlockPosition landedPosition) {
        if (!this.aQ()) {
            this.aX();
        }
        if (!this.s.x && onGround && this.L > 0.0f) {
            this.dB();
            this.dC();
        }
        if (!this.s.x && this.L > 3.0f && onGround) {
            float f2 = MathHelper.f(this.L - 3.0f);
            if (!landedState.g()) {
                double d1 = Math.min((double)(0.2f + f2 / 15.0f), 2.5);
                int i2 = (int)(150.0 * d1);
                if (this instanceof EntityPlayer) {
                    ((WorldServer)this.s).sendParticles((EntityPlayer)this, new ParticleParamBlock(Particles.c, landedState), this.dc(), this.de(), this.di(), i2, 0.0, 0.0, 0.0, 0.15f, false);
                } else {
                    ((WorldServer)this.s).a(new ParticleParamBlock(Particles.c, landedState), this.dc(), this.de(), this.di(), i2, 0.0, 0.0, 0.0, 0.15f);
                }
            }
        }
        super.a(heightDifference, onGround, landedState, landedPosition);
    }

    public boolean dx() {
        return this.er() == EnumMonsterType.b;
    }

    public float a(float tickDelta) {
        return MathHelper.i(tickDelta, this.cj, this.ci);
    }

    @Override
    public void an() {
        this.aO = this.aP;
        if (this.X) {
            this.fa().ifPresent(this::a);
        }
        if (this.dy()) {
            this.dz();
        }
        super.an();
        this.s.ab().a("livingEntityBaseTick");
        if (this.aP() || this.s.x) {
            this.au();
        }
        if (this.bl()) {
            BlockPosition blockposition;
            double d1;
            double d0;
            boolean flag = this instanceof EntityHuman;
            if (this.bm()) {
                this.a(DamageSource.f, 1.0f);
            } else if (flag && !this.s.p_().a(this.cw()) && (d0 = this.s.p_().a(this) + this.s.p_().n()) < 0.0 && (d1 = this.s.p_().o()) > 0.0) {
                this.a(DamageSource.f, (float)Math.max(1, MathHelper.b(-d0 * d1)));
            }
            if (((Entity)this).a(TagsFluid.a) && !this.s.a_(new BlockPosition(this.dc(), this.dg(), this.di())).a(Blocks.lq)) {
                boolean flag1;
                boolean bl = flag1 = !this.dx() && !MobEffectUtil.c(this) && (!flag || !((EntityHuman)this).fs().a);
                if (flag1) {
                    this.i(this.m(this.bY()));
                    if (this.bY() == -20) {
                        this.i(0);
                        Vec3D vec3d = this.da();
                        for (int i2 = 0; i2 < 8; ++i2) {
                            double d2 = this.R.nextDouble() - this.R.nextDouble();
                            double d3 = this.R.nextDouble() - this.R.nextDouble();
                            double d4 = this.R.nextDouble() - this.R.nextDouble();
                            this.s.a(Particles.e, this.dc() + d2, this.de() + d3, this.di() + d4, vec3d.b, vec3d.c, vec3d.d);
                        }
                        this.a(DamageSource.h, 2.0f);
                    }
                }
                if (!this.s.x && this.bF() && this.cN() != null && !this.cN().bH()) {
                    this.p();
                }
            } else if (this.bY() < this.bX()) {
                this.i(this.n(this.bY()));
            }
            if (!this.s.x && !com.google.common.base.Objects.equal((Object)this.ce, (Object)(blockposition = this.cW()))) {
                this.ce = blockposition;
                this.c(blockposition);
            }
        }
        if (this.bl() && (this.aS() || this.al)) {
            if (!this.s.x && this.an) {
                this.ay();
            }
            this.au();
        }
        if (this.aK > 0) {
            --this.aK;
        }
        if (this.W > 0 && !(this instanceof EntityPlayer)) {
            --this.W;
        }
        if (this.eb() && this.s.h(this)) {
            this.dH();
        }
        if (this.bd > 0) {
            --this.bd;
        } else {
            this.bc = null;
        }
        if (this.bZ != null && !this.bZ.bl()) {
            this.bZ = null;
        }
        if (this.bX != null) {
            if (!this.bX.bl()) {
                this.a((EntityLiving)null);
            } else if (this.S - this.bY > 100) {
                this.a((EntityLiving)null);
            }
        }
        this.dS();
        this.bj = this.bi;
        this.aY = this.aX;
        this.ba = this.aZ;
        this.w = this.dn();
        this.x = this.do();
        this.s.ab().c();
    }

    public boolean dy() {
        return this.S % 5 == 0 && this.da().b != 0.0 && this.da().d != 0.0 && !this.B_() && EnchantmentManager.j(this) && this.dA();
    }

    protected void dz() {
        Vec3D vec3d = this.da();
        this.s.a(Particles.D, this.dc() + (this.R.nextDouble() - 0.5) * (double)this.cT(), this.de() + 0.1, this.di() + (this.R.nextDouble() - 0.5) * (double)this.cT(), vec3d.b * -0.2, 0.1, vec3d.d * -0.2);
        float f2 = this.R.nextFloat() * 0.4f + this.R.nextFloat() > 0.9f ? 0.6f : 0.0f;
        this.a(SoundEffects.rM, f2, 0.6f + this.R.nextFloat() * 0.4f);
    }

    protected boolean dA() {
        return this.s.a_(this.aD()).a(TagsBlock.aA);
    }

    @Override
    protected float aC() {
        return this.dA() && EnchantmentManager.a(Enchantments.l, this) > 0 ? 1.0f : super.aC();
    }

    protected boolean b(IBlockData landingState) {
        return !landingState.g() || this.eV();
    }

    protected void dB() {
        AttributeModifiable attributemodifiable = this.a(GenericAttributes.d);
        if (attributemodifiable != null && attributemodifiable.a(d) != null) {
            attributemodifiable.b(d);
        }
    }

    protected void dC() {
        int i2;
        if (!this.aZ().g() && (i2 = EnchantmentManager.a(Enchantments.l, this)) > 0 && this.dA()) {
            AttributeModifiable attributemodifiable = this.a(GenericAttributes.d);
            if (attributemodifiable == null) {
                return;
            }
            attributemodifiable.b(new AttributeModifier(d, "Soul speed boost", (double)(0.03f * (1.0f + (float)i2 * 0.35f)), AttributeModifier.Operation.a));
            if (this.dL().nextFloat() < 0.04f) {
                ItemStack itemstack = this.b(EnumItemSlot.c);
                itemstack.a(1, this, (T entityliving) -> entityliving.c(EnumItemSlot.c));
            }
        }
    }

    protected void dD() {
        AttributeModifiable attributemodifiable = this.a(GenericAttributes.d);
        if (attributemodifiable != null && attributemodifiable.a(e) != null) {
            attributemodifiable.b(e);
        }
    }

    protected void dE() {
        int i2;
        if (!this.aZ().g() && (i2 = this.bZ()) > 0) {
            AttributeModifiable attributemodifiable = this.a(GenericAttributes.d);
            if (attributemodifiable == null) {
                return;
            }
            float f2 = -0.05f * this.ca();
            attributemodifiable.b(new AttributeModifier(e, "Powder snow slow", (double)f2, AttributeModifier.Operation.a));
        }
    }

    protected void c(BlockPosition pos) {
        int i2 = EnchantmentManager.a(Enchantments.j, this);
        if (i2 > 0) {
            EnchantmentFrostWalker.a(this, this.s, pos, i2);
        }
        if (this.b(this.aZ())) {
            this.dB();
        }
        this.dC();
    }

    public boolean y_() {
        return false;
    }

    public float dF() {
        return this.y_() ? 0.5f : 1.0f;
    }

    protected boolean dG() {
        return true;
    }

    @Override
    public boolean bH() {
        return false;
    }

    protected void dH() {
        ++this.aN;
        if (this.aN >= 20 && !this.dp() && !this.s.k_()) {
            this.s.a((Entity)this, (byte)60);
            this.a(Entity.RemovalReason.a);
        }
    }

    protected boolean dI() {
        return !this.y_();
    }

    protected boolean dJ() {
        return !this.y_();
    }

    protected int m(int air) {
        int j2 = EnchantmentManager.d(this);
        return j2 > 0 && this.R.nextInt(j2 + 1) > 0 ? air : air - 1;
    }

    protected int n(int air) {
        return Math.min(air + 4, this.bX());
    }

    protected int d(EntityHuman player) {
        return 0;
    }

    protected boolean dK() {
        return false;
    }

    public Random dL() {
        return this.R;
    }

    @Nullable
    public EntityLiving dM() {
        return this.bX;
    }

    public int dN() {
        return this.bY;
    }

    public void e(@Nullable EntityHuman attacking) {
        this.bc = attacking;
        this.bd = this.S;
    }

    public void a(@Nullable EntityLiving attacker) {
        this.bX = attacker;
        this.bY = this.S;
    }

    @Nullable
    public EntityLiving dO() {
        return this.bZ;
    }

    public int dP() {
        return this.ca;
    }

    public void x(Entity target) {
        this.bZ = target instanceof EntityLiving ? (EntityLiving)target : null;
        this.ca = this.S;
    }

    public int dQ() {
        return this.bf;
    }

    public void o(int despawnCounter) {
        this.bf = despawnCounter;
    }

    public boolean dR() {
        return this.bV;
    }

    public void p(boolean noDrag) {
        this.bV = noDrag;
    }

    protected void c(ItemStack stack) {
        this.equipEventAndSound(stack, false);
    }

    protected void equipEventAndSound(ItemStack itemstack, boolean silent) {
        SoundEffect soundeffect = itemstack.N();
        if (!(itemstack.b() || soundeffect == null || this.B_() || silent)) {
            this.a(GameEvent.u);
            this.a(soundeffect, 1.0f, 1.0f);
        }
    }

    @Override
    public void b(NBTTagCompound nbt) {
        nbt.a("Health", this.ea());
        nbt.a("HurtTime", (short)this.aK);
        nbt.a("HurtByTimestamp", this.bY);
        nbt.a("DeathTime", (short)this.aN);
        nbt.a("AbsorptionAmount", this.eJ());
        nbt.a("Attributes", this.eq().c());
        if (!this.bS.isEmpty()) {
            NBTTagList nbttaglist = new NBTTagList();
            for (MobEffect mobeffect : this.bS.values()) {
                nbttaglist.add(mobeffect.a(new NBTTagCompound()));
            }
            nbt.a("ActiveEffects", nbttaglist);
        }
        nbt.a("FallFlying", this.eV());
        this.fa().ifPresent(blockposition -> {
            nbt.a("SleepingX", blockposition.u());
            nbt.a("SleepingY", blockposition.v());
            nbt.a("SleepingZ", blockposition.w());
        });
        DataResult<NBTBase> dataresult = this.bD.a(DynamicOpsNBT.a);
        Logger logger = b;
        Objects.requireNonNull(logger);
        dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(nbtbase -> nbt.a("Brain", (NBTBase)nbtbase));
    }

    @Override
    public void a(NBTTagCompound nbt) {
        float absorptionAmount = nbt.j("AbsorptionAmount");
        if (Float.isNaN(absorptionAmount)) {
            absorptionAmount = 0.0f;
        }
        this.t(absorptionAmount);
        if (nbt.b("Attributes", 9) && this.s != null && !this.s.x) {
            this.eq().a(nbt.c("Attributes", 10));
        }
        if (nbt.b("ActiveEffects", 9)) {
            NBTTagList nbttaglist = nbt.c("ActiveEffects", 10);
            for (int i2 = 0; i2 < nbttaglist.size(); ++i2) {
                NBTTagCompound nbttagcompound1 = nbttaglist.a(i2);
                MobEffect mobeffect = MobEffect.b(nbttagcompound1);
                if (mobeffect == null) continue;
                this.bS.put(mobeffect.a(), mobeffect);
            }
        }
        if (nbt.e("Bukkit.MaxHealth")) {
            NBTBase nbtbase = nbt.c("Bukkit.MaxHealth");
            if (nbtbase.a() == 5) {
                this.a(GenericAttributes.a).a(((NBTTagFloat)nbtbase).i());
            } else if (nbtbase.a() == 3) {
                this.a(GenericAttributes.a).a(((NBTTagInt)nbtbase).i());
            }
        }
        if (nbt.b("Health", 99)) {
            this.c(nbt.j("Health"));
        }
        this.aK = nbt.g("HurtTime");
        this.aN = nbt.g("DeathTime");
        this.bY = nbt.h("HurtByTimestamp");
        if (nbt.b("Team", 8)) {
            boolean flag;
            String s2 = nbt.l("Team");
            ScoreboardTeam scoreboardteam = this.s.J().f(s2);
            if (!this.s.paperConfig.nonPlayerEntitiesOnScoreboards && !(this instanceof EntityHuman)) {
                scoreboardteam = null;
            }
            boolean bl = flag = scoreboardteam != null && this.s.J().a(this.cn(), scoreboardteam);
            if (!flag) {
                b.warn("Unable to add mob to team \"{}\" (that team probably doesn't exist)", (Object)s2);
            }
        }
        if (nbt.q("FallFlying")) {
            this.b(7, true);
        }
        if (nbt.b("SleepingX", 99) && nbt.b("SleepingY", 99) && nbt.b("SleepingZ", 99)) {
            BlockPosition blockposition = new BlockPosition(nbt.h("SleepingX"), nbt.h("SleepingY"), nbt.h("SleepingZ"));
            this.e(blockposition);
            this.Y.b(Entity.ad, EntityPose.c);
            if (!this.X) {
                this.a(blockposition);
            }
        }
        if (nbt.b("Brain", 10)) {
            this.bD = this.a(new Dynamic<NBTBase>(DynamicOpsNBT.a, nbt.c("Brain")));
        }
    }

    protected void dS() {
        Iterator<MobEffectList> iterator = this.bS.keySet().iterator();
        this.isTickingEffects = true;
        try {
            while (iterator.hasNext()) {
                MobEffectList mobeffectlist = iterator.next();
                MobEffect mobeffect = this.bS.get(mobeffectlist);
                if (!mobeffect.a(this, () -> this.a(mobeffect, true, (Entity)null))) {
                    EntityPotionEffectEvent event;
                    if (this.s.x || (event = CraftEventFactory.callEntityPotionEffectChangeEvent(this, mobeffect, null, EntityPotionEffectEvent.Cause.EXPIRATION)).isCancelled()) continue;
                    iterator.remove();
                    this.a(mobeffect);
                    continue;
                }
                if (mobeffect.b() % 600 != 0) continue;
                this.a(mobeffect, false, (Entity)null);
            }
        }
        catch (ConcurrentModificationException mobeffectlist) {
            // empty catch block
        }
        this.isTickingEffects = false;
        for (ProcessableEffect e2 : this.effectsToProcess) {
            if (e2.effect != null) {
                this.addEffect(e2.effect, e2.cause);
                continue;
            }
            this.removeEffect(e2.type, e2.cause);
        }
        this.effectsToProcess.clear();
        if (this.bW) {
            if (!this.s.x) {
                this.F();
                this.n();
            }
            this.bW = false;
        }
        int i2 = this.Y.a(bL);
        boolean flag = this.Y.a(bM);
        if (i2 > 0) {
            boolean flag1 = this.bU() ? this.R.nextInt(15) == 0 : this.R.nextBoolean();
            if (flag) {
                flag1 &= this.R.nextInt(5) == 0;
            }
            if (flag1 && i2 > 0) {
                double d0 = (double)(i2 >> 16 & 0xFF) / 255.0;
                double d1 = (double)(i2 >> 8 & 0xFF) / 255.0;
                double d2 = (double)(i2 >> 0 & 0xFF) / 255.0;
                this.s.a(flag ? Particles.a : Particles.v, this.d(0.5), this.df(), this.g(0.5), d0, d1, d2);
            }
        }
    }

    protected void F() {
        if (this.bS.isEmpty()) {
            this.dV();
            this.j(false);
        } else {
            Collection<MobEffect> collection = this.bS.values();
            this.Y.b(bM, EntityLiving.c(collection));
            this.Y.b(bL, PotionUtil.a(collection));
            this.j(this.a(MobEffects.n));
        }
    }

    private void n() {
        boolean flag = this.bT();
        if (this.h(6) != flag) {
            this.b(6, flag);
        }
    }

    public double y(@Nullable Entity entity) {
        double d0 = 1.0;
        if (this.bL()) {
            d0 *= 0.8;
        }
        if (this.bU()) {
            float f2 = this.eu();
            if (f2 < 0.1f) {
                f2 = 0.1f;
            }
            d0 *= 0.7 * (double)f2;
        }
        if (entity != null) {
            ItemStack itemstack = this.b(EnumItemSlot.f);
            EntityTypes<?> entitytypes = entity.ad();
            if (entitytypes == EntityTypes.aB && itemstack.a(Items.rr) || entitytypes == EntityTypes.be && itemstack.a(Items.ru) || entitytypes == EntityTypes.o && itemstack.a(Items.rv)) {
                d0 *= 0.5;
            }
        }
        return d0;
    }

    public boolean c(EntityLiving target) {
        return target instanceof EntityHuman && this.s.af() == EnumDifficulty.a ? false : target.dT();
    }

    public boolean a(EntityLiving entity, PathfinderTargetCondition predicate) {
        return predicate.a(this, entity);
    }

    public boolean dT() {
        return !this.cg() && this.dU();
    }

    public boolean dU() {
        return !this.B_() && this.bl();
    }

    public static boolean c(Collection<MobEffect> effects) {
        MobEffect mobeffect;
        Iterator<MobEffect> iterator = effects.iterator();
        do {
            if (iterator.hasNext()) continue;
            return true;
        } while (!(mobeffect = iterator.next()).e() || mobeffect.d());
        return false;
    }

    protected void dV() {
        this.Y.b(bM, false);
        this.Y.b(bL, 0);
    }

    public boolean dW() {
        return this.removeAllEffects(EntityPotionEffectEvent.Cause.UNKNOWN);
    }

    public boolean removeAllEffects(EntityPotionEffectEvent.Cause cause) {
        if (this.s.x) {
            return false;
        }
        Iterator<MobEffect> iterator = this.bS.values().iterator();
        boolean flag = false;
        while (iterator.hasNext()) {
            MobEffect effect = iterator.next();
            EntityPotionEffectEvent event = CraftEventFactory.callEntityPotionEffectChangeEvent(this, effect, null, cause, EntityPotionEffectEvent.Action.CLEARED);
            if (!event.isCancelled()) {
                this.a(effect);
                iterator.remove();
            }
            flag = true;
        }
        return flag;
    }

    public Collection<MobEffect> dX() {
        return this.bS.values();
    }

    public Map<MobEffectList, MobEffect> dY() {
        return this.bS;
    }

    public boolean a(MobEffectList effect) {
        return this.bS.containsKey(effect);
    }

    @Nullable
    public MobEffect b(MobEffectList effect) {
        return this.bS.get(effect);
    }

    public final boolean b(MobEffect effect) {
        return this.b(effect, (Entity)null);
    }

    public boolean addEffect(MobEffect mobeffect, EntityPotionEffectEvent.Cause cause) {
        return this.addEffect(mobeffect, null, cause);
    }

    public boolean b(MobEffect effect, @Nullable Entity source) {
        return this.addEffect(effect, source, EntityPotionEffectEvent.Cause.UNKNOWN);
    }

    public boolean addEffect(MobEffect mobeffect, @Nullable Entity entity, EntityPotionEffectEvent.Cause cause) {
        EntityPotionEffectEvent event;
        AsyncCatcher.catchOp("effect add");
        if (this.isTickingEffects) {
            this.effectsToProcess.add(new ProcessableEffect(mobeffect, cause));
            return true;
        }
        if (!this.c(mobeffect)) {
            return false;
        }
        MobEffect mobeffect1 = this.bS.get(mobeffect.a());
        boolean override = false;
        if (mobeffect1 != null) {
            override = new MobEffect(mobeffect1).b(mobeffect);
        }
        if ((event = CraftEventFactory.callEntityPotionEffectChangeEvent(this, mobeffect1, mobeffect, cause, override)).isCancelled()) {
            return false;
        }
        if (mobeffect1 == null) {
            this.bS.put(mobeffect.a(), mobeffect);
            this.a(mobeffect, entity);
            return true;
        }
        if (event.isOverride()) {
            mobeffect1.b(mobeffect);
            this.a(mobeffect1, true, entity);
            return true;
        }
        return false;
    }

    public boolean c(MobEffect effect) {
        MobEffectList mobeffectlist;
        return this.er() != EnumMonsterType.b || (mobeffectlist = effect.a()) != MobEffects.j && mobeffectlist != MobEffects.s || !this.s.paperConfig.undeadImmuneToCertainEffects;
    }

    public void c(MobEffect effect, @Nullable Entity source) {
        if (this.c(effect)) {
            MobEffect mobeffect1 = this.bS.put(effect.a(), effect);
            if (mobeffect1 == null) {
                this.a(effect, source);
            } else {
                this.a(effect, true, source);
            }
        }
    }

    public boolean dZ() {
        return this.er() == EnumMonsterType.b;
    }

    @Nullable
    public MobEffect c(@Nullable MobEffectList type) {
        return this.c(type, EntityPotionEffectEvent.Cause.UNKNOWN);
    }

    @Nullable
    public MobEffect c(@Nullable MobEffectList mobeffectlist, EntityPotionEffectEvent.Cause cause) {
        if (this.isTickingEffects) {
            this.effectsToProcess.add(new ProcessableEffect(mobeffectlist, cause));
            return null;
        }
        MobEffect effect = this.bS.get(mobeffectlist);
        if (effect == null) {
            return null;
        }
        EntityPotionEffectEvent event = CraftEventFactory.callEntityPotionEffectChangeEvent(this, effect, null, cause);
        if (event.isCancelled()) {
            return null;
        }
        return this.bS.remove(mobeffectlist);
    }

    public boolean d(MobEffectList type) {
        return this.removeEffect(type, EntityPotionEffectEvent.Cause.UNKNOWN);
    }

    public boolean removeEffect(MobEffectList mobeffectlist, EntityPotionEffectEvent.Cause cause) {
        MobEffect mobeffect = this.c(mobeffectlist, cause);
        if (mobeffect != null) {
            this.a(mobeffect);
            return true;
        }
        return false;
    }

    protected void a(MobEffect effect, @Nullable Entity source) {
        this.bW = true;
        if (!this.s.x) {
            effect.a().b(this, this.eq(), effect.c());
        }
    }

    protected void a(MobEffect effect, boolean reapplyEffect, @Nullable Entity source) {
        this.bW = true;
        if (reapplyEffect && !this.s.x) {
            MobEffectList mobeffectlist = effect.a();
            mobeffectlist.a(this, this.eq(), effect.c());
            mobeffectlist.b(this, this.eq(), effect.c());
        }
    }

    protected void a(MobEffect effect) {
        this.bW = true;
        if (!this.s.x) {
            effect.a().a(this, this.eq(), effect.c());
        }
    }

    public void b(float amount) {
        this.heal(amount, EntityRegainHealthEvent.RegainReason.CUSTOM);
    }

    public void heal(float f2, EntityRegainHealthEvent.RegainReason regainReason) {
        this.heal(f2, regainReason, false);
    }

    public void heal(float f2, EntityRegainHealthEvent.RegainReason regainReason, boolean isFastRegen) {
        float f1 = this.ea();
        if (f1 > 0.0f) {
            EntityRegainHealthEvent event = new EntityRegainHealthEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (double)f2, regainReason, isFastRegen);
            if (this.valid) {
                this.s.getCraftServer().getPluginManager().callEvent((Event)event);
            }
            if (!event.isCancelled()) {
                this.c((float)((double)this.ea() + event.getAmount()));
            }
        }
    }

    public float ea() {
        if (this instanceof EntityPlayer) {
            return (float)((EntityPlayer)this).getBukkitEntity().getHealth();
        }
        return this.Y.a(bK).floatValue();
    }

    public void c(float health) {
        if (Float.isNaN(health)) {
            health = this.em();
            if (this.valid) {
                System.err.println("[NAN-HEALTH] " + this.co() + " had NaN health set");
            }
        }
        if (this instanceof EntityPlayer) {
            CraftPlayer player = ((EntityPlayer)this).getBukkitEntity();
            if (health < 0.0f) {
                player.setRealHealth(0.0);
            } else if ((double)health > player.getMaxHealth()) {
                player.setRealHealth(player.getMaxHealth());
            } else {
                player.setRealHealth(health);
            }
            player.updateScaledHealth(false);
            return;
        }
        this.Y.b(bK, Float.valueOf(MathHelper.a(health, 0.0f, this.em())));
    }

    public boolean eb() {
        return this.ea() <= 0.0f;
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        boolean flag2;
        boolean knockbackCancelled;
        if (this.b(source)) {
            return false;
        }
        if (this.s.x) {
            return false;
        }
        if (this.dp() || this.be || this.ea() <= 0.0f) {
            return false;
        }
        if (source.s() && this.a(MobEffects.l)) {
            return false;
        }
        if (this.fc() && !this.s.x) {
            this.fd();
        }
        this.bf = 0;
        float f1 = amount;
        boolean flag = amount > 0.0f && this.e(source);
        float f2 = 0.0f;
        this.aS = 1.5f;
        boolean flag1 = true;
        if ((float)this.W > (float)this.aU / 2.0f) {
            if (amount <= this.bm) {
                return false;
            }
            if (!this.damageEntity0(source, amount - this.bm)) {
                return false;
            }
            this.bm = amount;
            flag1 = false;
        } else {
            if (!this.damageEntity0(source, amount)) {
                return false;
            }
            this.bm = amount;
            this.W = this.aU;
            this.aK = this.aL = 10;
        }
        if (this instanceof EntityAnimal) {
            ((EntityAnimal)this).fG();
            if (this instanceof EntityTameableAnimal) {
                ((EntityTameableAnimal)this).y(false);
            }
        }
        this.aM = 0.0f;
        Entity entity1 = source.l();
        if (entity1 != null) {
            EntityWolf entitywolf;
            if (entity1 instanceof EntityLiving && !source.t()) {
                this.a((EntityLiving)entity1);
            }
            if (entity1 instanceof EntityHuman) {
                this.bd = 100;
                this.bc = (EntityHuman)entity1;
            } else if (entity1 instanceof EntityWolf && (entitywolf = (EntityWolf)entity1).q()) {
                this.bd = 100;
                EntityLiving entityliving = entitywolf.fA();
                this.bc = entityliving != null && entityliving.ad() == EntityTypes.bi ? (EntityHuman)entityliving : null;
            }
        }
        boolean bl = knockbackCancelled = this.s.paperConfig.disableExplosionKnockback && source.d() && this instanceof EntityHuman;
        if (flag1) {
            if (flag) {
                this.s.a((Entity)this, (byte)29);
            } else if (source instanceof EntityDamageSource && ((EntityDamageSource)source).E()) {
                this.s.a((Entity)this, (byte)33);
            } else {
                int b0 = source == DamageSource.h ? 36 : (source.s() ? 37 : (source == DamageSource.u ? 44 : (source == DamageSource.v ? 57 : 2)));
                if (!knockbackCancelled) {
                    this.s.a((Entity)this, (byte)b0);
                }
            }
            if (source != DamageSource.h && (!flag || amount > 0.0f)) {
                this.bf();
            }
            if (entity1 != null) {
                double d1;
                boolean far = entity1.f(this) > 40000.0;
                double d0 = far ? Math.random() - Math.random() : entity1.dc() - this.dc();
                double d2 = d1 = far ? Math.random() - Math.random() : entity1.di() - this.di();
                while (d0 * d0 + d1 * d1 < 1.0E-4) {
                    d0 = (Math.random() - Math.random()) * 0.01;
                    d1 = (Math.random() - Math.random()) * 0.01;
                }
                this.aM = (float)(MathHelper.d(d1, d0) * 57.2957763671875 - (double)this.dn());
                this.knockback(0.4f, d0, d1, entity1);
            } else {
                this.aM = (int)(Math.random() * 2.0) * 180;
            }
        }
        if (knockbackCancelled) {
            this.s.a((Entity)this, (byte)2);
        }
        if (this.eb()) {
            if (!this.g(source)) {
                this.silentDeath = !flag1;
                this.a(source);
                this.silentDeath = false;
            }
        } else if (flag1) {
            this.d(source);
        }
        boolean bl2 = flag2 = !flag || amount > 0.0f;
        if (flag2) {
            this.cg = source;
            this.ch = this.s.U();
        }
        if (this instanceof EntityPlayer) {
            CriterionTriggers.h.a((EntityPlayer)this, source, f1, amount, flag);
            if (f2 > 0.0f && f2 < 3.4028235E37f) {
                ((EntityPlayer)this).a(StatisticList.K, Math.round(f2 * 10.0f));
            }
        }
        if (entity1 instanceof EntityPlayer) {
            CriterionTriggers.g.a((EntityPlayer)entity1, this, source, f1, amount, flag);
        }
        return flag2;
    }

    protected void d(EntityLiving attacker) {
        attacker.e(this);
    }

    protected void e(EntityLiving target) {
        target.knockback(0.5, target.dc() - this.dc(), target.di() - this.di(), this);
    }

    private boolean g(DamageSource source) {
        if (source.i()) {
            return false;
        }
        ItemStack itemstack = null;
        EnumHand[] aenumhand = EnumHand.values();
        int i2 = aenumhand.length;
        ItemStack itemstack1 = ItemStack.b;
        for (int j2 = 0; j2 < i2; ++j2) {
            EnumHand enumhand = aenumhand[j2];
            itemstack1 = this.b(enumhand);
            if (!itemstack1.a(Items.sw)) continue;
            itemstack = itemstack1.n();
            break;
        }
        EntityResurrectEvent event = new EntityResurrectEvent((LivingEntity)this.getBukkitEntity());
        event.setCancelled(itemstack == null);
        this.s.getCraftServer().getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            if (!itemstack1.b()) {
                itemstack1.g(1);
            }
            if (itemstack != null && this instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)this;
                entityplayer.b(StatisticList.c.b(Items.sw));
                CriterionTriggers.B.a(entityplayer, itemstack);
            }
            this.c(1.0f);
            this.removeAllEffects(EntityPotionEffectEvent.Cause.TOTEM);
            this.addEffect(new MobEffect(MobEffects.j, 900, 1), EntityPotionEffectEvent.Cause.TOTEM);
            this.addEffect(new MobEffect(MobEffects.v, 100, 1), EntityPotionEffectEvent.Cause.TOTEM);
            this.addEffect(new MobEffect(MobEffects.l, 800, 0), EntityPotionEffectEvent.Cause.TOTEM);
            this.s.a((Entity)this, (byte)35);
        }
        return !event.isCancelled();
    }

    @Nullable
    public DamageSource ec() {
        if (this.s.U() - this.ch > 40L) {
            this.cg = null;
        }
        return this.cg;
    }

    protected void d(DamageSource source) {
        SoundEffect soundeffect = this.c(source);
        if (soundeffect != null) {
            this.a(soundeffect, this.ev(), this.ew());
        }
    }

    public boolean e(DamageSource source) {
        Vec3D vec3d;
        EntityArrow entityarrow;
        Entity entity = source.k();
        boolean flag = false;
        if (entity instanceof EntityArrow && (entityarrow = (EntityArrow)entity).s() > 0) {
            flag = true;
        }
        if (!source.f() && this.eT() && !flag && (vec3d = source.C()) != null) {
            Vec3D vec3d1 = this.e(1.0f);
            Vec3D vec3d2 = vec3d.a(this.cV()).d();
            vec3d2 = new Vec3D(vec3d2.b, 0.0, vec3d2.d);
            if (vec3d2.b(vec3d1) < 0.0) {
                return true;
            }
        }
        return false;
    }

    private void j(ItemStack stack) {
        if (!stack.b()) {
            if (!this.aL()) {
                this.s.a(this.dc(), this.de(), this.di(), SoundEffects.ju, this.cO(), 0.8f, 0.8f + this.s.v.nextFloat() * 0.4f, false);
            }
            this.a(stack, 5);
        }
    }

    public void a(DamageSource source) {
        if (!this.dp() && !this.be) {
            Entity entity = source.l();
            EntityLiving entityliving = this.el();
            this.be = true;
            if (this.s instanceof WorldServer) {
                EntityDeathEvent deathEvent;
                if (entity != null) {
                    // empty if block
                }
                if ((deathEvent = this.dropAllDeathLoot(source)) == null || !deathEvent.isCancelled()) {
                    if (this instanceof EntityInsentient) {
                        for (EnumItemSlot slot : this.clearedEquipmentSlots) {
                            this.a(slot, ItemStack.b);
                        }
                        this.clearedEquipmentSlots.clear();
                    }
                    if (this.fc()) {
                        this.fd();
                    }
                    if (!this.s.x && this.Y() && SpigotConfig.logNamedDeaths) {
                        b.info("Named entity {} died: {}", (Object)this, (Object)this.ek().b().getString());
                    }
                    this.ek().g();
                    if (entity != null) {
                        entity.a((WorldServer)this.s, this);
                    }
                } else {
                    this.be = false;
                    this.c((float)deathEvent.getReviveHealth());
                }
                this.f(entityliving);
            }
            if (this.be) {
                this.s.a((Entity)this, (byte)3);
                this.b(EntityPose.h);
            }
        }
    }

    protected void f(@Nullable EntityLiving adversary) {
        if (!this.s.x) {
            boolean flag = false;
            if (this.be && adversary instanceof EntityWither) {
                if (this.s.W().b(GameRules.c)) {
                    BlockPosition blockposition = this.cW();
                    IBlockData iblockdata = Blocks.bG.n();
                    if (this.s.a_(blockposition).g() && iblockdata.a((IWorldReader)this.s, blockposition)) {
                        flag = CraftEventFactory.handleBlockFormEvent(this.s, blockposition, iblockdata, 3, this);
                    }
                }
                if (!flag) {
                    EntityItem entityitem = new EntityItem(this.s, this.dc(), this.de(), this.di(), new ItemStack(Items.cD));
                    EntityDropItemEvent event = new EntityDropItemEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (Item)entityitem.getBukkitEntity());
                    CraftEventFactory.callEvent(event);
                    if (event.isCancelled()) {
                        return;
                    }
                    this.s.b(entityitem);
                }
            }
        }
    }

    protected EntityDeathEvent dropAllDeathLoot(DamageSource source) {
        Entity entity = source.l();
        int i2 = entity instanceof EntityHuman ? EnchantmentManager.g((EntityLiving)entity) : 0;
        boolean flag = this.bd > 0;
        this.ed();
        if (this.dJ() && this.s.W().b(GameRules.f)) {
            this.a(source, flag);
            boolean prev = this.clearEquipmentSlots;
            this.clearEquipmentSlots = false;
            this.clearedEquipmentSlots.clear();
            this.a(source, i2, flag);
            this.clearEquipmentSlots = prev;
        }
        EntityDeathEvent deathEvent = CraftEventFactory.callEntityDeathEvent(this, this.drops, () -> {
            EntityLiving entityliving = this.el();
            if (this.bl >= 0 && entityliving != null) {
                entityliving.a(this, this.bl, source);
            }
        });
        this.postDeathDropItems(deathEvent);
        this.drops = new ArrayList();
        this.ee();
        return deathEvent;
    }

    protected void ed() {
    }

    protected void postDeathDropItems(EntityDeathEvent event) {
    }

    public int getExpReward() {
        if (this.s instanceof WorldServer && (this.dK() || this.bd > 0 && this.dI() && this.s.W().b(GameRules.f))) {
            int i2 = this.d(this.bc);
            return i2;
        }
        return 0;
    }

    protected void ee() {
        EntityLiving attacker = this.bc != null ? this.bc : this.bX;
        EntityExperienceOrb.award((WorldServer)this.s, this.cV(), this.expToDrop, this instanceof EntityPlayer ? ExperienceOrb.SpawnReason.PLAYER_DEATH : ExperienceOrb.SpawnReason.ENTITY_DEATH, attacker, this);
        this.expToDrop = 0;
    }

    protected void a(DamageSource source, int lootingMultiplier, boolean allowDrops) {
    }

    public MinecraftKey ef() {
        return this.ad().j();
    }

    protected void a(DamageSource source, boolean causedByPlayer) {
        MinecraftKey minecraftkey = this.ef();
        LootTable loottable = this.s.n().aF().a(minecraftkey);
        LootTableInfo.Builder loottableinfo_builder = this.a(causedByPlayer, source);
        loottable.b(loottableinfo_builder.a(LootContextParameterSets.f), this::b);
    }

    protected LootTableInfo.Builder a(boolean causedByPlayer, DamageSource source) {
        LootTableInfo.Builder loottableinfo_builder = new LootTableInfo.Builder((WorldServer)this.s).a(this.R).a(LootContextParameters.a, this).a(LootContextParameters.f, this.cV()).a(LootContextParameters.c, source).b(LootContextParameters.d, source.l()).b(LootContextParameters.e, source.k());
        if (causedByPlayer && this.bc != null) {
            loottableinfo_builder = loottableinfo_builder.a(LootContextParameters.b, this.bc).a(this.bc.fM());
        }
        return loottableinfo_builder;
    }

    public void p(double strength, double x2, double z2) {
        this.knockback(strength, x2, z2, null);
    }

    public void knockback(double strength, double x2, double z2, Entity knockingBackEntity) {
        if ((strength *= 1.0 - this.b(GenericAttributes.c)) > 0.0) {
            this.af = true;
            Vec3D vec3d = this.da();
            Vec3D vec3d1 = new Vec3D(x2, 0.0, z2).d().a(strength);
            this.n(vec3d.b / 2.0 - vec3d1.b, this.y ? Math.min(0.4, vec3d.c / 2.0 + strength) : vec3d.c, vec3d.d / 2.0 - vec3d1.d);
            Vec3D currentMovement = this.da();
            Vector delta = new Vector(currentMovement.b - vec3d.b, currentMovement.c - vec3d.c, currentMovement.d - vec3d.d);
            this.g(vec3d);
            if (knockingBackEntity == null || new EntityKnockbackByEntityEvent((LivingEntity)this.getBukkitEntity(), (org.bukkit.entity.Entity)knockingBackEntity.getBukkitEntity(), (float)strength, delta).callEvent()) {
                this.n(vec3d.b + delta.getX(), vec3d.c + delta.getY(), vec3d.d + delta.getZ());
            }
        }
    }

    @Nullable
    protected SoundEffect c(DamageSource source) {
        return SoundEffects.gO;
    }

    @Nullable
    public SoundEffect x_() {
        return SoundEffects.gJ;
    }

    private SoundEffect c(int distance) {
        return distance > 4 ? this.eg().b() : this.eg().a();
    }

    public a eg() {
        return new a(SoundEffects.gP, SoundEffects.gH);
    }

    protected SoundEffect d(ItemStack stack) {
        return stack.L();
    }

    public SoundEffect e(ItemStack stack) {
        return stack.M();
    }

    @Override
    public void c(boolean onGround) {
        super.c(onGround);
        if (onGround) {
            this.cf = Optional.empty();
        }
    }

    public Optional<BlockPosition> eh() {
        return this.cf;
    }

    public boolean b_() {
        if (this.B_()) {
            return false;
        }
        BlockPosition blockposition = this.cW();
        IBlockData iblockdata = this.cX();
        if (iblockdata.a(TagsBlock.aC)) {
            this.cf = Optional.of(blockposition);
            return true;
        }
        if (iblockdata.b() instanceof BlockTrapdoor && this.c(blockposition, iblockdata)) {
            this.cf = Optional.of(blockposition);
            return true;
        }
        return false;
    }

    private boolean c(BlockPosition pos, IBlockData state) {
        IBlockData iblockdata1;
        return state.c(BlockTrapdoor.a) != false && (iblockdata1 = this.s.a_(pos.c())).a(Blocks.cn) && iblockdata1.c(BlockLadder.a) == state.c(BlockFacingHorizontal.aD);
    }

    @Override
    public boolean bl() {
        return !this.dp() && this.ea() > 0.0f;
    }

    @Override
    public boolean a(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        boolean flag = super.a(fallDistance, damageMultiplier, damageSource);
        int i2 = this.d(fallDistance, damageMultiplier);
        if (i2 > 0) {
            if (!this.a(damageSource, (float)i2)) {
                return true;
            }
            this.a(this.c(i2), 1.0f, 1.0f);
            this.ei();
            return true;
        }
        return flag;
    }

    protected int d(float fallDistance, float damageMultiplier) {
        MobEffect mobeffect = this.b(MobEffects.h);
        float f2 = mobeffect == null ? 0.0f : (float)(mobeffect.c() + 1);
        return MathHelper.f((fallDistance - 3.0f - f2) * damageMultiplier);
    }

    protected void ei() {
        int k2;
        int j2;
        int i2;
        IBlockData iblockdata;
        if (!this.aL() && !(iblockdata = this.s.a_(new BlockPosition(i2 = MathHelper.b(this.dc()), j2 = MathHelper.b(this.de() - (double)0.2f), k2 = MathHelper.b(this.di())))).g()) {
            SoundEffectType soundeffecttype = iblockdata.q();
            this.a(soundeffecttype.g(), soundeffecttype.a() * 0.5f, soundeffecttype.b() * 0.75f);
        }
    }

    @Override
    public void bA() {
        this.aK = this.aL = 10;
        this.aM = 0.0f;
    }

    public int ej() {
        return MathHelper.b(this.b(GenericAttributes.i));
    }

    protected void b(DamageSource source, float amount) {
    }

    protected void c(DamageSource source, float amount) {
    }

    protected void q(float amount) {
    }

    protected float d(DamageSource source, float amount) {
        if (!source.f()) {
            amount = CombatMath.a(amount, this.ej(), (float)this.b(GenericAttributes.j));
        }
        return amount;
    }

    protected float e(DamageSource source, float amount) {
        if (source.j()) {
            return amount;
        }
        if (amount <= 0.0f) {
            return 0.0f;
        }
        int i2 = EnchantmentManager.a(this.bC(), source);
        if (i2 > 0) {
            amount = CombatMath.a(amount, i2);
        }
        return amount;
    }

    protected boolean damageEntity0(final DamageSource damagesource, float f2) {
        if (!this.b(damagesource)) {
            float f3;
            boolean human = this instanceof EntityHuman;
            float originalDamage = f2;
            Function<Double, Double> hardHat = new Function<Double, Double>(){

                public Double apply(Double f2) {
                    if (damagesource.g() && !EntityLiving.this.b(EnumItemSlot.f).b()) {
                        return -(f2 - f2 * 0.75);
                    }
                    return -0.0;
                }
            };
            float hardHatModifier = ((Double)hardHat.apply((Object)f2)).floatValue();
            Function<Double, Double> blocking = new Function<Double, Double>(){

                public Double apply(Double f2) {
                    return -(EntityLiving.this.e(damagesource) ? f2 : 0.0);
                }
            };
            float blockingModifier = ((Double)blocking.apply((Object)(f2 += hardHatModifier))).floatValue();
            Function<Double, Double> armor = new Function<Double, Double>(){

                public Double apply(Double f2) {
                    return -(f2 - (double)EntityLiving.this.d(damagesource, f2.floatValue()));
                }
            };
            float armorModifier = ((Double)armor.apply((Object)(f2 += blockingModifier))).floatValue();
            Function<Double, Double> resistance = new Function<Double, Double>(){

                public Double apply(Double f2) {
                    if (!damagesource.j() && EntityLiving.this.a(MobEffects.k) && damagesource != DamageSource.m) {
                        int i2 = (EntityLiving.this.b(MobEffects.k).c() + 1) * 5;
                        int j2 = 25 - i2;
                        float f1 = f2.floatValue() * (float)j2;
                        return -(f2 - (double)(f1 / 25.0f));
                    }
                    return -0.0;
                }
            };
            float resistanceModifier = ((Double)resistance.apply((Object)(f2 += armorModifier))).floatValue();
            Function<Double, Double> magic = new Function<Double, Double>(){

                public Double apply(Double f2) {
                    return -(f2 - (double)EntityLiving.this.e(damagesource, f2.floatValue()));
                }
            };
            float magicModifier = ((Double)magic.apply((Object)(f2 += resistanceModifier))).floatValue();
            Function<Double, Double> absorption = new Function<Double, Double>(){

                public Double apply(Double f2) {
                    return -Math.max(f2 - Math.max(f2 - (double)EntityLiving.this.eJ(), 0.0), 0.0);
                }
            };
            float absorptionModifier = ((Double)absorption.apply((Object)(f2 += magicModifier))).floatValue();
            EntityDamageEvent event = CraftEventFactory.handleLivingEntityDamageEvent(this, damagesource, originalDamage, hardHatModifier, blockingModifier, armorModifier, resistanceModifier, magicModifier, absorptionModifier, hardHat, blocking, armor, resistance, magic, absorption);
            if (damagesource.l() instanceof EntityHuman) {
                if (damagesource.l() instanceof EntityPlayer) {
                    EntityPlayer player = (EntityPlayer)damagesource.l();
                    if (new PlayerAttackEntityCooldownResetEvent((Player)player.getBukkitEntity(), (org.bukkit.entity.Entity)this.getBukkitEntity(), player.v(0.0f)).callEvent()) {
                        player.fK();
                    }
                } else {
                    ((EntityHuman)damagesource.l()).fK();
                }
            }
            if (event.isCancelled()) {
                return false;
            }
            f2 = (float)event.getFinalDamage();
            if (event.getDamage(EntityDamageEvent.DamageModifier.RESISTANCE) < 0.0 && (f3 = (float)(-event.getDamage(EntityDamageEvent.DamageModifier.RESISTANCE))) > 0.0f && f3 < 3.4028235E37f) {
                if (this instanceof EntityPlayer) {
                    ((EntityPlayer)this).a(StatisticList.M, Math.round(f3 * 10.0f));
                } else if (damagesource.l() instanceof EntityPlayer) {
                    ((EntityPlayer)damagesource.l()).a(StatisticList.I, Math.round(f3 * 10.0f));
                }
            }
            if (damagesource.g() && !this.b(EnumItemSlot.f).b()) {
                this.c(damagesource, f2);
            }
            if (!damagesource.f()) {
                float armorDamage = (float)(event.getDamage() + event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING) + event.getDamage(EntityDamageEvent.DamageModifier.HARD_HAT));
                this.b(damagesource, armorDamage);
            }
            if (event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING) < 0.0) {
                this.s.a((Entity)this, (byte)29);
                this.q((float)(-event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING)));
                Entity entity = damagesource.k();
                if (entity instanceof EntityLiving && entity.f(this) <= 40000.0) {
                    this.d((EntityLiving)entity);
                }
            }
            absorptionModifier = (float)(-event.getDamage(EntityDamageEvent.DamageModifier.ABSORPTION));
            this.t(Math.max(this.eJ() - absorptionModifier, 0.0f));
            float f22 = absorptionModifier;
            if (f22 > 0.0f && f22 < 3.4028235E37f && this instanceof EntityHuman) {
                ((EntityHuman)this).a(StatisticList.L, Math.round(f22 * 10.0f));
            }
            if (f22 > 0.0f && f22 < 3.4028235E37f && damagesource.l() instanceof EntityPlayer) {
                ((EntityPlayer)damagesource.l()).a(StatisticList.H, Math.round(f22 * 10.0f));
            }
            if (f2 > 0.0f || !human) {
                if (human) {
                    ((EntityHuman)this).causeFoodExhaustion(damagesource.h(), EntityExhaustionEvent.ExhaustionReason.DAMAGED);
                    if (f2 < 3.4028235E37f) {
                        ((EntityHuman)this).a(StatisticList.J, Math.round(f2 * 10.0f));
                    }
                }
                float f32 = this.ea();
                this.c(f32 - f2);
                this.ek().a(damagesource, f32, f2);
                if (!human) {
                    this.t(this.eJ() - f2);
                }
                this.a(GameEvent.r, damagesource.l());
                return true;
            }
            if (event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING) < 0.0) {
                if (this instanceof EntityPlayer) {
                    CriterionTriggers.h.a((EntityPlayer)this, damagesource, f2, originalDamage, true);
                    f22 = (float)(-event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING));
                    if (f22 > 0.0f && f22 < 3.4028235E37f) {
                        ((EntityPlayer)this).a(StatisticList.K, Math.round(originalDamage * 10.0f));
                    }
                }
                if (damagesource.l() instanceof EntityPlayer) {
                    CriterionTriggers.g.a((EntityPlayer)damagesource.l(), this, damagesource, f2, originalDamage, true);
                }
                return false;
            }
            return originalDamage > 0.0f;
        }
        return false;
    }

    public CombatTracker ek() {
        return this.bR;
    }

    @Nullable
    public EntityLiving el() {
        return this.bR.c() != null ? this.bR.c() : (this.bc != null ? this.bc : (this.bX != null ? this.bX : null));
    }

    public final float em() {
        return (float)this.b(GenericAttributes.a);
    }

    public final int en() {
        return this.Y.a(bN);
    }

    public final void p(int stuckArrowCount) {
        this.setArrowCount(stuckArrowCount, false);
    }

    public final void setArrowCount(int i2, boolean flag) {
        ArrowBodyCountChangeEvent event = CraftEventFactory.callArrowBodyCountChangeEvent(this, this.en(), i2, flag);
        if (event.isCancelled()) {
            return;
        }
        this.Y.b(bN, event.getNewAmount());
    }

    public final int eo() {
        return this.Y.a(bO);
    }

    public final void q(int stingerCount) {
        this.Y.b(bO, stingerCount);
    }

    private int r() {
        return MobEffectUtil.a(this) ? 6 - (1 + MobEffectUtil.b(this)) : (this.a(MobEffects.d) ? 6 + (1 + this.b(MobEffects.d).c()) * 2 : 6);
    }

    public void a(EnumHand hand) {
        this.a(hand, false);
    }

    public void a(EnumHand hand, boolean fromServerPlayer) {
        if (!this.aF || this.aH >= this.r() / 2 || this.aH < 0) {
            this.aH = -1;
            this.aF = true;
            this.aG = hand;
            if (this.s instanceof WorldServer) {
                PacketPlayOutAnimation packetplayoutanimation = new PacketPlayOutAnimation(this, hand == EnumHand.a ? 0 : 3);
                ChunkProviderServer chunkproviderserver = ((WorldServer)this.s).k();
                if (fromServerPlayer) {
                    chunkproviderserver.a(this, packetplayoutanimation);
                } else {
                    chunkproviderserver.b(this, packetplayoutanimation);
                }
            }
        }
    }

    @Override
    public void a(byte status) {
        switch (status) {
            case 2: 
            case 33: 
            case 36: 
            case 37: 
            case 44: 
            case 57: {
                DamageSource damagesource;
                SoundEffect soundeffect;
                this.aS = 1.5f;
                this.W = 20;
                this.aK = this.aL = 10;
                this.aM = 0.0f;
                if (status == 33) {
                    this.a(SoundEffects.sU, this.ev(), (this.R.nextFloat() - this.R.nextFloat()) * 0.2f + 1.0f);
                }
                if ((soundeffect = this.c(damagesource = status == 37 ? DamageSource.c : (status == 36 ? DamageSource.h : (status == 44 ? DamageSource.u : (status == 57 ? DamageSource.v : DamageSource.n))))) != null) {
                    this.a(soundeffect, this.ev(), (this.R.nextFloat() - this.R.nextFloat()) * 0.2f + 1.0f);
                }
                this.a(DamageSource.n, 0.0f);
                this.cg = damagesource;
                this.ch = this.s.U();
                break;
            }
            case 3: {
                SoundEffect soundeffect1 = this.x_();
                if (soundeffect1 != null) {
                    this.a(soundeffect1, this.ev(), (this.R.nextFloat() - this.R.nextFloat()) * 0.2f + 1.0f);
                }
                if (this instanceof EntityHuman) break;
                this.c(0.0f);
                this.a(DamageSource.n);
                break;
            }
            default: {
                super.a(status);
                break;
            }
            case 29: {
                this.a(SoundEffects.qz, 1.0f, 0.8f + this.s.v.nextFloat() * 0.4f);
                break;
            }
            case 30: {
                this.a(SoundEffects.qA, 0.8f, 0.8f + this.s.v.nextFloat() * 0.4f);
                break;
            }
            case 46: {
                boolean flag = true;
                for (int i2 = 0; i2 < 128; ++i2) {
                    double d0 = (double)i2 / 127.0;
                    float f2 = (this.R.nextFloat() - 0.5f) * 0.2f;
                    float f1 = (this.R.nextFloat() - 0.5f) * 0.2f;
                    float f22 = (this.R.nextFloat() - 0.5f) * 0.2f;
                    double d1 = MathHelper.d(d0, this.t, this.dc()) + (this.R.nextDouble() - 0.5) * (double)this.cT() * 2.0;
                    double d2 = MathHelper.d(d0, this.u, this.de()) + this.R.nextDouble() * (double)this.cU();
                    double d3 = MathHelper.d(d0, this.v, this.di()) + (this.R.nextDouble() - 0.5) * (double)this.cT() * 2.0;
                    this.s.a(Particles.S, d1, d2, d3, (double)f2, (double)f1, f22);
                }
                return;
            }
            case 47: {
                this.j(this.b(EnumItemSlot.a));
                break;
            }
            case 48: {
                this.j(this.b(EnumItemSlot.b));
                break;
            }
            case 49: {
                this.j(this.b(EnumItemSlot.f));
                break;
            }
            case 50: {
                this.j(this.b(EnumItemSlot.e));
                break;
            }
            case 51: {
                this.j(this.b(EnumItemSlot.d));
                break;
            }
            case 52: {
                this.j(this.b(EnumItemSlot.c));
                break;
            }
            case 54: {
                BlockHoney.b(this);
                break;
            }
            case 55: {
                this.w();
                break;
            }
            case 60: {
                this.u();
            }
        }
    }

    private void u() {
        for (int i2 = 0; i2 < 20; ++i2) {
            double d0 = this.R.nextGaussian() * 0.02;
            double d1 = this.R.nextGaussian() * 0.02;
            double d2 = this.R.nextGaussian() * 0.02;
            this.s.a(Particles.R, this.d(1.0), this.df(), this.g(1.0), d0, d1, d2);
        }
    }

    private void w() {
        ItemStack itemstack = this.b(EnumItemSlot.b);
        this.a(EnumItemSlot.b, this.b(EnumItemSlot.a));
        this.a(EnumItemSlot.a, itemstack);
    }

    @Override
    protected void av() {
        this.a(DamageSource.m, 4.0f);
    }

    protected void ep() {
        int i2 = this.r();
        if (this.aF) {
            ++this.aH;
            if (this.aH >= i2) {
                this.aH = 0;
                this.aF = false;
            }
        } else {
            this.aH = 0;
        }
        this.aP = (float)this.aH / (float)i2;
    }

    @Nullable
    public AttributeModifiable a(AttributeBase attribute) {
        return this.eq().a(attribute);
    }

    public double b(AttributeBase attribute) {
        return this.eq().c(attribute);
    }

    public double c(AttributeBase attribute) {
        return this.eq().d(attribute);
    }

    public AttributeMapBase eq() {
        return this.bQ;
    }

    public EnumMonsterType er() {
        return EnumMonsterType.a;
    }

    public ItemStack es() {
        return this.b(EnumItemSlot.a);
    }

    public ItemStack et() {
        return this.b(EnumItemSlot.b);
    }

    public boolean b(net.minecraft.world.item.Item item) {
        return this.b((ItemStack itemstack) -> itemstack.a(item));
    }

    public boolean b(Predicate<ItemStack> predicate) {
        return predicate.test(this.es()) || predicate.test(this.et());
    }

    public ItemStack b(EnumHand hand) {
        if (hand == EnumHand.a) {
            return this.b(EnumItemSlot.a);
        }
        if (hand == EnumHand.b) {
            return this.b(EnumItemSlot.b);
        }
        throw new IllegalArgumentException("Invalid hand " + hand);
    }

    public void a(EnumHand hand, ItemStack stack) {
        if (hand == EnumHand.a) {
            this.a(EnumItemSlot.a, stack);
        } else {
            if (hand != EnumHand.b) {
                throw new IllegalArgumentException("Invalid hand " + hand);
            }
            this.a(EnumItemSlot.b, stack);
        }
    }

    public boolean a(EnumItemSlot slot) {
        return !this.b(slot).b();
    }

    @Override
    public abstract Iterable<ItemStack> bC();

    public abstract ItemStack b(EnumItemSlot var1);

    public void setItemSlot(EnumItemSlot enumitemslot, ItemStack itemstack, boolean silent) {
        this.a(enumitemslot, itemstack);
    }

    @Override
    public abstract void a(EnumItemSlot var1, ItemStack var2);

    protected void f(ItemStack stack) {
        NBTTagCompound nbttagcompound = stack.t();
        if (nbttagcompound != null) {
            stack.c().b(nbttagcompound);
        }
    }

    public float eu() {
        Iterable<ItemStack> iterable = this.bC();
        int i2 = 0;
        int j2 = 0;
        for (ItemStack itemstack : iterable) {
            if (!itemstack.b()) {
                ++j2;
            }
            ++i2;
        }
        return i2 > 0 ? (float)j2 / (float)i2 : 0.0f;
    }

    @Override
    public void g(boolean sprinting) {
        super.g(sprinting);
        AttributeModifiable attributemodifiable = this.a(GenericAttributes.d);
        if (attributemodifiable.a(c) != null) {
            attributemodifiable.d(bE);
        }
        if (sprinting) {
            attributemodifiable.b(bE);
        }
    }

    public float ev() {
        return 1.0f;
    }

    public float ew() {
        return this.y_() ? (this.R.nextFloat() - this.R.nextFloat()) * 0.2f + 1.5f : (this.R.nextFloat() - this.R.nextFloat()) * 0.2f + 1.0f;
    }

    protected boolean ex() {
        return this.eb();
    }

    @Override
    public void g(Entity entity) {
        if (!this.fc()) {
            super.g(entity);
        }
    }

    private void a(Entity vehicle) {
        Vec3D vec3d;
        if (this.dp()) {
            vec3d = this.cV();
        } else if (!vehicle.dp() && !this.s.a_(vehicle.cW()).a(TagsBlock.av)) {
            vec3d = vehicle.b(this);
        } else {
            double d0 = Math.max(this.de(), vehicle.de());
            vec3d = new Vec3D(this.dc(), d0, this.di());
        }
        this.a(vec3d.b, vec3d.c, vec3d.d);
    }

    @Override
    public boolean cs() {
        return this.cr();
    }

    protected float ey() {
        return 0.42f * this.aB();
    }

    public double ez() {
        return this.a(MobEffects.h) ? (double)(0.1f * (float)(this.b(MobEffects.h).c() + 1)) : 0.0;
    }

    protected void eA() {
        double d0 = (double)this.ey() + this.ez();
        Vec3D vec3d = this.da();
        long time = System.nanoTime();
        boolean canCrit = true;
        if (this instanceof EntityHuman) {
            canCrit = false;
            if (time - this.lastJumpTime > 250000000L) {
                this.lastJumpTime = time;
                canCrit = true;
            }
        }
        this.n(vec3d.b, d0, vec3d.d);
        if (this.bO()) {
            float f2 = this.dn() * ((float)Math.PI / 180);
            if (canCrit) {
                this.g(this.da().b(-MathHelper.a(f2) * 0.2f, 0.0, MathHelper.b(f2) * 0.2f));
            }
        }
        this.af = true;
    }

    protected void eB() {
        this.g(this.da().b(0.0, -0.04f, 0.0));
    }

    protected void c(TagKey<FluidType> fluid) {
        this.g(this.da().b(0.0, 0.04f, 0.0));
    }

    protected float eC() {
        return 0.8f;
    }

    public boolean a(Fluid fluid) {
        return false;
    }

    public void h(Vec3D movementInput) {
        if (this.eI() || this.cM()) {
            boolean flag;
            double d0 = 0.08;
            boolean bl = flag = this.da().c <= 0.0;
            if (flag && this.a(MobEffects.B)) {
                d0 = 0.01;
                this.m();
            }
            Fluid fluid = this.s.b_(this.cW());
            if (this.aQ() && this.dG() && !this.a(fluid)) {
                double d1 = this.de();
                float f2 = this.bO() ? 0.9f : this.eC();
                float f1 = 0.02f;
                float f22 = EnchantmentManager.e(this);
                if (f22 > 3.0f) {
                    f22 = 3.0f;
                }
                if (!this.y) {
                    f22 *= 0.5f;
                }
                if (f22 > 0.0f) {
                    f2 += (0.54600006f - f2) * f22 / 3.0f;
                    f1 += (this.eD() - f1) * f22 / 3.0f;
                }
                if (this.a(MobEffects.D)) {
                    f2 = 0.96f;
                }
                this.a(f1, movementInput);
                this.a(EnumMoveType.a, this.da());
                Vec3D vec3d1 = this.da();
                if (this.z && this.b_()) {
                    vec3d1 = new Vec3D(vec3d1.b, 0.2, vec3d1.d);
                }
                this.g(vec3d1.d(f2, 0.8f, f2));
                Vec3D vec3d2 = this.a(d0, flag, this.da());
                this.g(vec3d2);
                if (this.z && this.f(vec3d2.b, vec3d2.c + (double)0.6f - this.de() + d1, vec3d2.d)) {
                    this.n(vec3d2.b, 0.3f, vec3d2.d);
                }
            } else if (this.bc() && this.dG() && !this.a(fluid)) {
                Vec3D vec3d3;
                double d1 = this.de();
                this.a(0.02f, movementInput);
                this.a(EnumMoveType.a, this.da());
                if (this.b(TagsFluid.b) <= this.cS()) {
                    this.g(this.da().d(0.5, 0.8f, 0.5));
                    vec3d3 = this.a(d0, flag, this.da());
                    this.g(vec3d3);
                } else {
                    this.g(this.da().a(0.5));
                }
                if (!this.aM()) {
                    this.g(this.da().b(0.0, -d0 / 4.0, 0.0));
                }
                vec3d3 = this.da();
                if (this.z && this.f(vec3d3.b, vec3d3.c + (double)0.6f - this.de() + d1, vec3d3.d)) {
                    this.n(vec3d3.b, 0.3f, vec3d3.d);
                }
            } else if (this.eV()) {
                double d7;
                float f3;
                double d6;
                Vec3D vec3d4 = this.da();
                if (vec3d4.c > -0.5) {
                    this.L = 1.0f;
                }
                Vec3D vec3d5 = this.bv();
                float f4 = this.do() * ((float)Math.PI / 180);
                double d2 = Math.sqrt(vec3d5.b * vec3d5.b + vec3d5.d * vec3d5.d);
                double d3 = vec3d4.h();
                double d4 = vec3d5.f();
                double d5 = Math.cos(f4);
                d5 = d5 * d5 * Math.min(1.0, d4 / 0.4);
                vec3d4 = this.da().b(0.0, d0 * (-1.0 + d5 * 0.75), 0.0);
                if (vec3d4.c < 0.0 && d2 > 0.0) {
                    d6 = vec3d4.c * -0.1 * d5;
                    vec3d4 = vec3d4.b(vec3d5.b * d6 / d2, d6, vec3d5.d * d6 / d2);
                }
                if (f4 < 0.0f && d2 > 0.0) {
                    d6 = d3 * (double)(-MathHelper.a(f4)) * 0.04;
                    vec3d4 = vec3d4.b(-vec3d5.b * d6 / d2, d6 * 3.2, -vec3d5.d * d6 / d2);
                }
                if (d2 > 0.0) {
                    vec3d4 = vec3d4.b((vec3d5.b / d2 * d3 - vec3d4.b) * 0.1, 0.0, (vec3d5.d / d2 * d3 - vec3d4.d) * 0.1);
                }
                this.g(vec3d4.d(0.99f, 0.98f, 0.99f));
                this.a(EnumMoveType.a, this.da());
                if (this.z && !this.s.x && (f3 = (float)((d7 = d3 - (d6 = this.da().h())) * 10.0 - 3.0)) > 0.0f) {
                    this.a(this.c((int)f3), 1.0f, 1.0f);
                    this.a(DamageSource.l, f3);
                }
                if (this.y && !this.s.x && this.h(7) && !CraftEventFactory.callToggleGlideEvent(this, false).isCancelled()) {
                    this.b(7, false);
                }
            } else {
                BlockPosition blockposition = this.aD();
                float f4 = this.s.a_(blockposition).b().i();
                float f5 = this.y ? f4 * 0.91f : 0.91f;
                Vec3D vec3d6 = this.a(movementInput, f4);
                double d8 = vec3d6.c;
                if (this.a(MobEffects.y)) {
                    d8 += (0.05 * (double)(this.b(MobEffects.y).c() + 1) - vec3d6.c) * 0.2;
                    this.m();
                } else if (this.s.x && !this.s.C(blockposition)) {
                    d8 = this.de() > (double)this.s.u_() ? -0.1 : 0.0;
                } else if (!this.aM()) {
                    d8 -= d0;
                }
                if (this.dR()) {
                    this.n(vec3d6.b, d8, vec3d6.d);
                } else {
                    this.n(vec3d6.b * (double)f5, d8 * (double)0.98f, vec3d6.d * (double)f5);
                }
            }
        }
        this.a(this, this instanceof EntityBird);
    }

    public void a(EntityLiving entity, boolean flutter) {
        double d2;
        double d1;
        entity.aR = entity.aS;
        double d0 = entity.dc() - entity.t;
        float f2 = (float)Math.sqrt(d0 * d0 + (d1 = flutter ? entity.de() - entity.u : 0.0) * d1 + (d2 = entity.di() - entity.v) * d2) * 4.0f;
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        entity.aS += (f2 - entity.aS) * 0.4f;
        entity.aT += entity.aS;
    }

    public Vec3D a(Vec3D movementInput, float slipperiness) {
        this.a(this.u(slipperiness), movementInput);
        this.g(this.j(this.da()));
        this.a(EnumMoveType.a, this.da());
        Vec3D vec3d1 = this.da();
        if ((this.z || this.bn) && (this.b_() || this.cX().a(Blocks.oO) && PowderSnowBlock.a(this))) {
            vec3d1 = new Vec3D(vec3d1.b, 0.2, vec3d1.d);
        }
        return vec3d1;
    }

    public Vec3D a(double d0, boolean flag, Vec3D vec3d) {
        if (!this.aM() && !this.bO()) {
            double d1 = flag && Math.abs(vec3d.c - 0.005) >= 0.003 && Math.abs(vec3d.c - d0 / 16.0) < 0.003 ? -0.003 : vec3d.c - d0 / 16.0;
            return new Vec3D(vec3d.b, d1, vec3d.d);
        }
        return vec3d;
    }

    private Vec3D j(Vec3D motion) {
        if (this.b_()) {
            this.m();
            float f2 = 0.15f;
            double d0 = MathHelper.a(motion.b, (double)-0.15f, (double)0.15f);
            double d1 = MathHelper.a(motion.d, (double)-0.15f, (double)0.15f);
            double d2 = Math.max(motion.c, (double)-0.15f);
            if (d2 < 0.0 && !this.cX().a(Blocks.me) && this.eU() && this instanceof EntityHuman) {
                d2 = 0.0;
            }
            motion = new Vec3D(d0, d2, d1);
        }
        return motion;
    }

    private float u(float slipperiness) {
        return this.y ? this.eD() * (0.21600002f / (slipperiness * slipperiness * slipperiness)) : this.bb;
    }

    public float eD() {
        return this.cb;
    }

    public void r(float movementSpeed) {
        this.cb = movementSpeed;
    }

    public boolean z(Entity target) {
        this.x(target);
        return false;
    }

    @Override
    public void k() {
        super.k();
        this.A();
        this.D();
        if (!this.s.x) {
            int j2;
            int i2 = this.en();
            if (i2 > 0) {
                if (this.aI <= 0) {
                    this.aI = 20 * (30 - i2);
                }
                --this.aI;
                if (this.aI <= 0) {
                    this.p(i2 - 1);
                }
            }
            if ((j2 = this.eo()) > 0) {
                if (this.aJ <= 0) {
                    this.aJ = 20 * (30 - j2);
                }
                --this.aJ;
                if (this.aJ <= 0) {
                    this.q(j2 - 1);
                }
            }
            this.x();
            if (this.S % 20 == 0) {
                this.ek().g();
            }
            if (this.fc() && !this.E()) {
                this.fd();
            }
        }
        this.w_();
        double d0 = this.dc() - this.t;
        double d1 = this.di() - this.v;
        float f2 = (float)(d0 * d0 + d1 * d1);
        float f1 = this.aX;
        float f22 = 0.0f;
        this.bg = this.bh;
        float f3 = 0.0f;
        if (f2 > 0.0025000002f) {
            f3 = 1.0f;
            f22 = (float)Math.sqrt(f2) * 3.0f;
            float f4 = (float)MathHelper.d(d1, d0) * 57.295776f - 90.0f;
            float f5 = MathHelper.e(MathHelper.g(this.dn()) - f4);
            f1 = 95.0f < f5 && f5 < 265.0f ? f4 - 180.0f : f4;
        }
        if (this.aP > 0.0f) {
            f1 = this.dn();
        }
        if (!this.y) {
            f3 = 0.0f;
        }
        this.bh += (f3 - this.bh) * 0.3f;
        this.s.ab().a("headTurn");
        f22 = this.e(f1, f22);
        this.s.ab().c();
        this.s.ab().a("rangeChecks");
        while (this.dn() - this.w < -180.0f) {
            this.w -= 360.0f;
        }
        while (this.dn() - this.w >= 180.0f) {
            this.w += 360.0f;
        }
        while (this.aX - this.aY < -180.0f) {
            this.aY -= 360.0f;
        }
        while (this.aX - this.aY >= 180.0f) {
            this.aY += 360.0f;
        }
        while (this.do() - this.x < -180.0f) {
            this.x -= 360.0f;
        }
        while (this.do() - this.x >= 180.0f) {
            this.x += 360.0f;
        }
        while (this.aZ - this.ba < -180.0f) {
            this.ba -= 360.0f;
        }
        while (this.aZ - this.ba >= 180.0f) {
            this.ba += 360.0f;
        }
        this.s.ab().c();
        this.bi += f22;
        this.bB = this.eV() ? ++this.bB : 0;
        if (this.fc()) {
            this.p(0.0f);
        }
    }

    public void x() {
        Map<EnumItemSlot, ItemStack> map = this.y();
        if (map != null) {
            this.a(map);
            if (!map.isEmpty()) {
                this.b(map);
            }
        }
    }

    @Nullable
    private Map<EnumItemSlot, ItemStack> y() {
        EnumMap map = null;
        block4: for (EnumItemSlot enumitemslot : EnumItemSlot.values()) {
            ItemStack itemstack;
            switch (enumitemslot.a()) {
                case a: {
                    itemstack = this.e(enumitemslot);
                    break;
                }
                case b: {
                    itemstack = this.d(enumitemslot);
                    break;
                }
                default: {
                    continue block4;
                }
            }
            ItemStack itemstack1 = this.b(enumitemslot);
            if (ItemStack.b(itemstack1, itemstack)) continue;
            if (this instanceof EntityPlayer && enumitemslot.a() == EnumItemSlot.Function.b) {
                org.bukkit.inventory.ItemStack oldItem = CraftItemStack.asBukkitCopy(itemstack);
                org.bukkit.inventory.ItemStack newItem = CraftItemStack.asBukkitCopy(itemstack1);
                new PlayerArmorChangeEvent((Player)this.getBukkitEntity(), PlayerArmorChangeEvent.SlotType.valueOf((String)enumitemslot.name()), oldItem, newItem).callEvent();
            }
            if (map == null) {
                map = Maps.newEnumMap(EnumItemSlot.class);
            }
            map.put(enumitemslot, itemstack1);
            if (!itemstack.b()) {
                this.eq().a(itemstack.a(enumitemslot));
            }
            if (itemstack1.b()) continue;
            this.eq().b(itemstack1.a(enumitemslot));
        }
        return map;
    }

    private void a(Map<EnumItemSlot, ItemStack> equipmentChanges) {
        ItemStack itemstack = equipmentChanges.get((Object)EnumItemSlot.a);
        ItemStack itemstack1 = equipmentChanges.get((Object)EnumItemSlot.b);
        if (itemstack != null && itemstack1 != null && ItemStack.b(itemstack, this.e(EnumItemSlot.b)) && ItemStack.b(itemstack1, this.e(EnumItemSlot.a))) {
            ((WorldServer)this.s).k().b(this, new PacketPlayOutEntityStatus(this, 55));
            equipmentChanges.remove((Object)EnumItemSlot.a);
            equipmentChanges.remove((Object)EnumItemSlot.b);
            this.c(EnumItemSlot.a, itemstack.n());
            this.c(EnumItemSlot.b, itemstack1.n());
        }
    }

    private void b(Map<EnumItemSlot, ItemStack> equipmentChanges) {
        ArrayList list = Lists.newArrayListWithCapacity((int)equipmentChanges.size());
        equipmentChanges.forEach((enumitemslot, itemstack) -> {
            ItemStack toSend;
            ItemStack itemstack1 = itemstack.n();
            list.add(Pair.of((Object)enumitemslot, (Object)this.stripMeta(toSend, (toSend = EntityLiving.sanitizeItemStack(itemstack1, true)) == itemstack1)));
            switch (enumitemslot.a()) {
                case a: {
                    this.c((EnumItemSlot)((Object)enumitemslot), itemstack1);
                    break;
                }
                case b: {
                    this.b((EnumItemSlot)((Object)enumitemslot), itemstack1);
                }
            }
        });
        ((WorldServer)this.s).k().b(this, new PacketPlayOutEntityEquipment(this.ae(), list));
    }

    public ItemStack stripMeta(ItemStack itemStack, boolean copyItemStack) {
        ItemStack copy;
        if (itemStack.b() || !itemStack.s() && itemStack.J() < 2) {
            return itemStack;
        }
        ItemStack itemStack2 = copy = copyItemStack ? itemStack.n() : itemStack;
        if (this.s.paperConfig.hideDurabilityFromClients && (!copy.a(Items.lT) || copy.i() < copy.j() - 1)) {
            copy.b(0);
        }
        if (this.s.paperConfig.hideItemmetaFromClients) {
            copy.e(copy.J() > 1 ? 2 : 1);
            NBTTagCompound tag = copy.t();
            if (tag != null) {
                NBTTagList enchantmentsTag;
                NBTBase nBTBase = tag.c("display");
                if (nBTBase instanceof NBTTagCompound) {
                    NBTTagCompound displayTag = (NBTTagCompound)nBTBase;
                    displayTag.r("Lore");
                    displayTag.r("Name");
                }
                if ((nBTBase = tag.c("Enchantments")) instanceof NBTTagList && !(enchantmentsTag = (NBTTagList)nBTBase).isEmpty()) {
                    NBTTagList enchantments = new NBTTagList();
                    NBTTagCompound fakeEnchantment = new NBTTagCompound();
                    if (EnchantmentManager.a(Enchantments.l, itemStack) > 0) {
                        fakeEnchantment.a("id", Enchantment.SOUL_SPEED.getKey().asString());
                        fakeEnchantment.a("lvl", 1);
                    }
                    enchantments.add(fakeEnchantment);
                    tag.a("Enchantments", enchantments);
                }
                tag.r("AttributeModifiers");
            }
        }
        return copy;
    }

    public static ItemStack sanitizeItemStack(ItemStack itemStack, boolean copyItemStack) {
        NBTTagList oldItems;
        NBTBase nBTBase;
        if (itemStack.b() || !itemStack.s()) {
            return itemStack;
        }
        ItemStack copy = copyItemStack ? itemStack.n() : itemStack;
        NBTTagCompound tag = copy.t();
        if (copy.a(Items.oq) && (nBTBase = tag.c("Items")) instanceof NBTTagList && !(oldItems = (NBTTagList)nBTBase).isEmpty()) {
            BundleMeta bundleMeta = (BundleMeta)copy.asBukkitMirror().getItemMeta();
            int sizeUsed = 0;
            for (org.bukkit.inventory.ItemStack item : bundleMeta.getItems()) {
                int scale = 64 / item.getMaxStackSize();
                sizeUsed += scale * item.getAmount();
            }
            NBTTagList items = new NBTTagList();
            items.add(new ItemStack(Items.ol, sizeUsed).b(new NBTTagCompound()));
            tag.a("Items", items);
        }
        if ((nBTBase = tag.c("BlockEntityTag")) instanceof NBTTagCompound) {
            NBTTagCompound blockEntityTag = (NBTTagCompound)nBTBase;
            blockEntityTag.r("Items");
        }
        return copy;
    }

    private ItemStack d(EnumItemSlot slot) {
        return this.bU.get(slot.b());
    }

    private void b(EnumItemSlot slot, ItemStack armor) {
        this.bU.set(slot.b(), armor);
    }

    private ItemStack e(EnumItemSlot slot) {
        return this.bT.get(slot.b());
    }

    private void c(EnumItemSlot slot, ItemStack stack) {
        this.bT.set(slot.b(), stack);
    }

    protected float e(float bodyRotation, float headRotation) {
        boolean flag;
        float f2 = MathHelper.g(bodyRotation - this.aX);
        this.aX += f2 * 0.3f;
        float f3 = MathHelper.g(this.dn() - this.aX);
        boolean bl = flag = f3 < -90.0f || f3 >= 90.0f;
        if (f3 < -75.0f) {
            f3 = -75.0f;
        }
        if (f3 >= 75.0f) {
            f3 = 75.0f;
        }
        this.aX = this.dn() - f3;
        if (f3 * f3 > 2500.0f) {
            this.aX += f3 * 0.2f;
        }
        if (flag) {
            headRotation *= -1.0f;
        }
        return headRotation;
    }

    public void w_() {
        int i2;
        if (this.cc > 0) {
            --this.cc;
        }
        if (this.cM()) {
            this.br = 0;
            this.d(this.dc(), this.de(), this.di());
        }
        if (this.br > 0) {
            double d0 = this.dc() + (this.bs - this.dc()) / (double)this.br;
            double d1 = this.de() + (this.bt - this.de()) / (double)this.br;
            double d2 = this.di() + (this.bu - this.di()) / (double)this.br;
            double d3 = MathHelper.f(this.bv - (double)this.dn());
            this.o(this.dn() + (float)d3 / (float)this.br);
            this.p(this.do() + (float)(this.bw - (double)this.do()) / (float)this.br);
            --this.br;
            this.e(d0, d1, d2);
            this.a(this.dn(), this.do());
        } else if (!this.eI()) {
            this.g(this.da().a(0.98));
        }
        if (this.by > 0) {
            this.aZ += (float)MathHelper.f(this.bx - (double)this.aZ) / (float)this.by;
            --this.by;
        }
        Vec3D vec3d = this.da();
        double d4 = vec3d.b;
        double d5 = vec3d.c;
        double d6 = vec3d.d;
        if (Math.abs(vec3d.b) < 0.003) {
            d4 = 0.0;
        }
        if (Math.abs(vec3d.c) < 0.003) {
            d5 = 0.0;
        }
        if (Math.abs(vec3d.d) < 0.003) {
            d6 = 0.0;
        }
        this.n(d4, d5, d6);
        this.s.ab().a("ai");
        if (this.ex()) {
            this.bn = false;
            this.bo = 0.0f;
            this.bq = 0.0f;
        } else if (this.eI()) {
            this.s.ab().a("newAi");
            this.eF();
            this.s.ab().c();
        }
        this.s.ab().c();
        this.s.ab().a("jump");
        if (this.bn && this.dG()) {
            double d7 = this.bc() ? this.b(TagsFluid.b) : this.b(TagsFluid.a);
            boolean flag = this.aQ() && d7 > 0.0;
            double d8 = this.cS();
            if (flag && (!this.y || d7 > d8)) {
                this.c(TagsFluid.a);
            } else if (this.bc() && (!this.y || d7 > d8)) {
                this.c(TagsFluid.b);
            } else if ((this.y || flag && d7 <= d8) && this.cc == 0) {
                if (new EntityJumpEvent((LivingEntity)this.getBukkitLivingEntity()).callEvent()) {
                    this.eA();
                    this.cc = 10;
                } else {
                    this.q(false);
                }
            }
        } else {
            this.cc = 0;
        }
        this.s.ab().c();
        this.s.ab().a("travel");
        this.bo *= 0.98f;
        this.bq *= 0.98f;
        this.z();
        AxisAlignedBB axisalignedbb = this.cw();
        this.h(new Vec3D(this.bo, this.bp, this.bq));
        this.s.ab().c();
        this.s.ab().a("freezing");
        boolean flag1 = this.ad().a(TagsEntity.j);
        if (!(this.s.x || this.eb() || this.freezeLocked)) {
            i2 = this.bZ();
            if (this.al && this.dl()) {
                this.j(Math.min(this.cc(), i2 + 1));
            } else {
                this.j(Math.max(0, i2 - 2));
            }
        }
        this.dD();
        this.dE();
        if (!this.s.x && this.S % 40 == 0 && this.cb() && this.dl()) {
            i2 = flag1 ? 5 : 1;
            this.a(DamageSource.v, (float)i2);
        }
        this.s.ab().c();
        this.s.ab().a("push");
        if (this.bC > 0) {
            --this.bC;
            this.a(axisalignedbb, this.cw());
        }
        this.eG();
        this.s.ab().c();
        if (((WorldServer)this.s).hasEntityMoveEvent && !(this instanceof EntityHuman) && (this.t != this.dc() || this.u != this.de() || this.v != this.di() || this.w != this.dn() || this.x != this.do())) {
            Location from = new Location((World)this.s.getWorld(), this.t, this.u, this.v, this.w, this.x);
            Location to = new Location((World)this.s.getWorld(), this.dc(), this.de(), this.di(), this.dn(), this.do());
            EntityMoveEvent event = new EntityMoveEvent((LivingEntity)this.getBukkitLivingEntity(), from, to.clone());
            if (!event.callEvent()) {
                this.a(from.getX(), from.getY(), from.getZ(), from.getYaw(), from.getPitch());
            } else if (!to.equals((Object)event.getTo())) {
                this.a(event.getTo().getX(), event.getTo().getY(), event.getTo().getZ(), event.getTo().getYaw(), event.getTo().getPitch());
            }
        }
        if (!this.s.x && this.eE() && this.aS()) {
            this.a(DamageSource.h, 1.0f);
        }
    }

    public boolean eE() {
        return false;
    }

    private void z() {
        boolean flag = this.h(7);
        if (flag && !this.y && !this.bF() && !this.a(MobEffects.y)) {
            ItemStack itemstack = this.b(EnumItemSlot.e);
            if (itemstack.a(Items.lT) && ItemElytra.d(itemstack)) {
                flag = true;
                int i2 = this.bB + 1;
                if (!this.s.x && i2 % 10 == 0) {
                    int j2 = i2 / 10;
                    if (j2 % 2 == 0) {
                        itemstack.a(1, this, (T entityliving) -> entityliving.c(EnumItemSlot.e));
                    }
                    this.a(GameEvent.q);
                }
            } else {
                flag = false;
            }
        } else {
            flag = false;
        }
        if (!this.s.x && flag != this.h(7) && !CraftEventFactory.callToggleGlideEvent(this, flag).isCancelled()) {
            this.b(7, flag);
        }
    }

    protected void eF() {
    }

    protected void eG() {
        int i2 = this.s.W().c(GameRules.t);
        if (i2 <= 0 && this.s.paperConfig.maxCollisionsPerEntity <= 0) {
            return;
        }
        List<Entity> list = this.s.a((Entity)this, this.cw(), IEntitySelector.pushable(this, this.s.paperConfig.fixClimbingBypassingCrammingRule));
        if (!list.isEmpty()) {
            int j2;
            if (i2 > 0 && list.size() > i2 - 1 && this.R.nextInt(4) == 0) {
                j2 = 0;
                for (int k2 = 0; k2 < list.size(); ++k2) {
                    if (list.get(k2).bF()) continue;
                    ++j2;
                }
                if (j2 > i2 - 1) {
                    this.a(DamageSource.g, 6.0f);
                }
            }
            this.numCollisions = Math.max(0, this.numCollisions - this.s.paperConfig.maxCollisionsPerEntity);
            for (j2 = 0; j2 < list.size() && this.numCollisions < this.s.paperConfig.maxCollisionsPerEntity; ++j2) {
                Entity entity = list.get(j2);
                ++entity.numCollisions;
                ++this.numCollisions;
                this.A(entity);
            }
        }
    }

    protected void a(AxisAlignedBB a2, AxisAlignedBB b2) {
        AxisAlignedBB axisalignedbb2 = a2.b(b2);
        List<Entity> list = this.s.a_(this, axisalignedbb2);
        if (!list.isEmpty()) {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                Entity entity = list.get(i2);
                if (!(entity instanceof EntityLiving)) continue;
                this.g((EntityLiving)entity);
                this.bC = 0;
                this.g(this.da().a(-0.2));
                break;
            }
        } else if (this.z) {
            this.bC = 0;
        }
        if (!this.s.x && this.bC <= 0) {
            this.c(4, false);
        }
    }

    protected void A(Entity entity) {
        entity.g(this);
    }

    protected void g(EntityLiving target) {
    }

    public boolean eH() {
        return (this.Y.a(aB) & 4) != 0;
    }

    @Override
    public void p() {
        this.stopRiding(false);
    }

    @Override
    public void stopRiding(boolean suppressCancellation) {
        Entity entity = this.cN();
        super.stopRiding(suppressCancellation);
        if (entity != null && entity != this.cN() && !this.s.x && entity.valid) {
            this.a(entity);
        }
    }

    @Override
    public void bo() {
        super.bo();
        this.bg = this.bh;
        this.bh = 0.0f;
        this.m();
    }

    @Override
    public void a(double x2, double y2, double z2, float yaw, float pitch, int interpolationSteps, boolean interpolate) {
        this.bs = x2;
        this.bt = y2;
        this.bu = z2;
        this.bv = yaw;
        this.bw = pitch;
        this.br = interpolationSteps;
    }

    @Override
    public void a(float yaw, int interpolationSteps) {
        this.bx = yaw;
        this.by = interpolationSteps;
    }

    public void q(boolean jumping) {
        this.bn = jumping;
    }

    public void a(EntityItem item) {
        EntityHuman entityhuman;
        EntityHuman entityHuman = entityhuman = item.j() != null ? this.s.b(item.j()) : null;
        if (entityhuman instanceof EntityPlayer) {
            CriterionTriggers.O.a((EntityPlayer)entityhuman, item.h(), this);
        }
    }

    public void a(Entity item, int count) {
        if (!item.dp() && !this.s.x && (item instanceof EntityItem || item instanceof EntityArrow || item instanceof EntityExperienceOrb)) {
            ((WorldServer)this.s).k().b(item, new PacketPlayOutCollect(item.ae(), this.ae(), count));
        }
    }

    public boolean B(Entity entity) {
        if (entity.s != this.s) {
            return false;
        }
        Vec3D vec3d = new Vec3D(this.dc(), this.dg(), this.di());
        Vec3D vec3d1 = new Vec3D(entity.dc(), entity.dg(), entity.di());
        return vec3d1.g(vec3d) > 16384.0 ? false : this.s.a(new RayTrace(vec3d, vec3d1, RayTrace.BlockCollisionOption.a, RayTrace.FluidCollisionOption.a, this)).c() == MovingObjectPosition.EnumMovingObjectType.a;
    }

    @Override
    public float g(float tickDelta) {
        return tickDelta == 1.0f ? this.aZ : MathHelper.i(tickDelta, this.ba, this.aZ);
    }

    public float s(float tickDelta) {
        float f1 = this.aP - this.aO;
        if (f1 < 0.0f) {
            f1 += 1.0f;
        }
        return this.aO + f1 * tickDelta;
    }

    public boolean eI() {
        return !this.s.x;
    }

    @Override
    public boolean bh() {
        return !this.dp() && this.collides;
    }

    @Override
    public boolean bi() {
        return this.isCollidable(this.s.paperConfig.fixClimbingBypassingCrammingRule);
    }

    @Override
    public boolean isCollidable(boolean ignoreClimbing) {
        return this.bl() && !this.B_() && (ignoreClimbing || !this.b_()) && this.collides;
    }

    @Override
    public boolean canCollideWithBukkit(Entity entity) {
        return this.bi() && this.collides != this.collidableExemptions.contains(entity.cm());
    }

    @Override
    public float ce() {
        return this.aZ;
    }

    @Override
    public void l(float headYaw) {
        this.aZ = headYaw;
    }

    @Override
    public void m(float bodyYaw) {
        this.aX = bodyYaw;
    }

    @Override
    protected Vec3D a(EnumDirection.EnumAxis portalAxis, BlockUtil.Rectangle portalRect) {
        return EntityLiving.i(super.a(portalAxis, portalRect));
    }

    public static Vec3D i(Vec3D pos) {
        return new Vec3D(pos.b, pos.c, 0.0);
    }

    public float eJ() {
        return this.cd;
    }

    public void t(float amount) {
        if (amount < 0.0f || Float.isNaN(amount)) {
            amount = 0.0f;
        }
        this.cd = amount;
    }

    public void h() {
    }

    public void i() {
    }

    protected void eK() {
        this.bW = true;
    }

    public abstract EnumMainHand eL();

    public boolean eM() {
        return (this.Y.a(aB) & 1) > 0;
    }

    public EnumHand eN() {
        return (this.Y.a(aB) & 2) > 0 ? EnumHand.b : EnumHand.a;
    }

    private void A() {
        if (this.eM()) {
            if (ItemStack.d(this.b(this.eN()), this.bz)) {
                this.bz = this.b(this.eN());
                this.a(this.bz);
            } else {
                this.eS();
            }
        }
    }

    protected void a(ItemStack stack) {
        boolean shouldLagCompensate;
        stack.b(this.s, this, this.eP());
        if (this.C()) {
            this.b(stack, 5);
        }
        boolean bl = shouldLagCompensate = this.bz.c().v() && this.eatStartTime != -1L && System.nanoTime() - this.eatStartTime > (long)((1 + this.totalEatTimeTicks) * 50 * 1000000);
        if (!(--this.bA != 0 && !shouldLagCompensate || this.s.x || this.bz.r())) {
            this.bA = 0;
            this.v();
        }
    }

    private boolean C() {
        int i2 = this.eP();
        FoodInfo foodinfo = this.bz.c().w();
        boolean flag = foodinfo != null && foodinfo.e();
        return (flag |= i2 <= this.bz.p() - 7) && i2 % 4 == 0;
    }

    private void D() {
        this.cj = this.ci;
        this.ci = this.bQ() ? Math.min(1.0f, this.ci + 0.09f) : Math.max(0.0f, this.ci - 0.09f);
    }

    protected void c(int mask, boolean value) {
        byte b0 = this.Y.a(aB);
        int j2 = value ? b0 | mask : b0 & ~mask;
        this.Y.b(aB, (byte)j2);
    }

    public void c(EnumHand hand) {
        this.startUsingItem(hand, false);
    }

    public void startUsingItem(EnumHand hand, boolean forceUpdate) {
        ItemStack itemstack = this.b(hand);
        if (!itemstack.b() && !this.eM() || forceUpdate) {
            this.bz = itemstack;
            this.bA = this.totalEatTimeTicks = itemstack.p();
            this.eatStartTime = System.nanoTime();
            if (!this.s.x) {
                this.c(1, true);
                this.c(2, hand == EnumHand.b);
            }
        }
    }

    @Override
    public void a(DataWatcherObject<?> data) {
        super.a(data);
        if (bP.equals(data)) {
            if (this.s.x) {
                this.fa().ifPresent(this::a);
            }
        } else if (aB.equals(data) && this.s.x) {
            if (this.eM() && this.bz.b()) {
                this.bz = this.b(this.eN());
                if (!this.bz.b()) {
                    this.bA = this.bz.p();
                }
            } else if (!this.eM() && !this.bz.b()) {
                this.bz = ItemStack.b;
                this.totalEatTimeTicks = 0;
                this.bA = 0;
                this.eatStartTime = -1L;
            }
        }
    }

    @Override
    public void a(ArgumentAnchor.Anchor anchorPoint, Vec3D target) {
        super.a(anchorPoint, target);
        this.ba = this.aZ;
        this.aY = this.aX = this.aZ;
    }

    protected void b(ItemStack stack, int particleCount) {
        if (!stack.b() && this.eM()) {
            if (stack.q() == EnumAnimation.c) {
                this.a(this.d(stack), 0.5f, this.s.v.nextFloat() * 0.1f + 0.9f);
            }
            if (stack.q() == EnumAnimation.b) {
                this.a(stack, particleCount);
                this.a(this.e(stack), 0.5f + 0.5f * (float)this.R.nextInt(2), (this.R.nextFloat() - this.R.nextFloat()) * 0.2f + 1.0f);
            }
        }
    }

    private void a(ItemStack stack, int count) {
        for (int j2 = 0; j2 < count; ++j2) {
            Vec3D vec3d = new Vec3D(((double)this.R.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
            vec3d = vec3d.a(-this.do() * ((float)Math.PI / 180));
            vec3d = vec3d.b(-this.dn() * ((float)Math.PI / 180));
            double d0 = (double)(-this.R.nextFloat()) * 0.6 - 0.3;
            Vec3D vec3d1 = new Vec3D(((double)this.R.nextFloat() - 0.5) * 0.3, d0, 0.6);
            vec3d1 = vec3d1.a(-this.do() * ((float)Math.PI / 180));
            vec3d1 = vec3d1.b(-this.dn() * ((float)Math.PI / 180));
            vec3d1 = vec3d1.b(this.dc(), this.dg(), this.di());
            this.s.a(new ParticleParamItem(Particles.J, stack), vec3d1.b, vec3d1.c, vec3d1.d, vec3d.b, vec3d.c + 0.05, vec3d.d);
        }
    }

    protected void v() {
        if (!this.s.x || this.eM()) {
            EnumHand enumhand = this.eN();
            if (!this.bz.equals(this.b(enumhand))) {
                this.eR();
            } else if (!this.bz.b() && this.eM()) {
                ItemStack itemstack;
                this.startUsingItem(this.eN(), true);
                this.b(this.bz, 16);
                PlayerItemConsumeEvent event = null;
                if (this instanceof EntityPlayer) {
                    org.bukkit.inventory.ItemStack craftItem = CraftItemStack.asBukkitCopy(this.bz);
                    event = new PlayerItemConsumeEvent((Player)this.getBukkitEntity(), craftItem);
                    this.s.getCraftServer().getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        this.eS();
                        ((EntityPlayer)this).getBukkitEntity().updateInventory();
                        ((EntityPlayer)this).getBukkitEntity().updateScaledHealth();
                        return;
                    }
                    itemstack = craftItem.equals((Object)event.getItem()) ? this.bz.a(this.s, this) : CraftItemStack.asNMSCopy(event.getItem()).a(this.s, this);
                } else {
                    itemstack = this.bz.a(this.s, this);
                }
                ItemStack defaultReplacement = itemstack;
                if (event != null && event.getReplacement() != null) {
                    itemstack = CraftItemStack.asNMSCopy(event.getReplacement());
                }
                if (itemstack != this.bz) {
                    this.a(enumhand, itemstack);
                }
                this.eS();
                if (this instanceof EntityPlayer) {
                    ((EntityPlayer)this).getBukkitEntity().updateInventory();
                }
            }
        }
    }

    public ItemStack eO() {
        return this.bz;
    }

    public int eP() {
        return this.bA;
    }

    public int eQ() {
        return this.eM() ? this.bz.p() - this.eP() : 0;
    }

    public void eR() {
        if (!this.bz.b()) {
            this.bz.a(this.s, this, this.eP());
            if (this.bz.r()) {
                this.A();
            }
        }
        this.eS();
    }

    public void eS() {
        if (!this.s.x) {
            this.c(1, false);
        }
        this.bz = ItemStack.b;
        this.totalEatTimeTicks = 0;
        this.bA = 0;
        this.eatStartTime = -1L;
    }

    public boolean eT() {
        if (this.eM() && !this.bz.b()) {
            net.minecraft.world.item.Item item = this.bz.c();
            return item.c(this.bz) != EnumAnimation.d ? false : item.b(this.bz) - this.bA >= this.getShieldBlockingDelay();
        }
        return false;
    }

    public MovingObjectPosition getRayTrace(int maxDistance) {
        return this.getRayTrace(maxDistance, RayTrace.FluidCollisionOption.a);
    }

    public MovingObjectPosition getRayTrace(int maxDistance, RayTrace.FluidCollisionOption fluidCollisionOption) {
        if (maxDistance < 1 || maxDistance > 120) {
            throw new IllegalArgumentException("maxDistance must be between 1-120");
        }
        Vec3D start = new Vec3D(this.dc(), this.de() + (double)this.cy(), this.di());
        Vector dir = this.getBukkitEntity().getLocation().getDirection().multiply(maxDistance);
        Vec3D end = new Vec3D(start.b + dir.getX(), start.c + dir.getY(), start.d + dir.getZ());
        RayTrace raytrace = new RayTrace(start, end, RayTrace.BlockCollisionOption.b, fluidCollisionOption, this);
        return this.s.a(raytrace);
    }

    public MovingObjectPositionEntity getTargetEntity(int maxDistance) {
        if (maxDistance < 1 || maxDistance > 120) {
            throw new IllegalArgumentException("maxDistance must be between 1-120");
        }
        Vec3D start = this.i(1.0f);
        Vec3D direction = this.bv();
        Vec3D end = start.b(direction.b * (double)maxDistance, direction.c * (double)maxDistance, direction.d * (double)maxDistance);
        List<Entity> entityList = this.s.a((Entity)this, this.cw().b(direction.b * (double)maxDistance, direction.c * (double)maxDistance, direction.d * (double)maxDistance).c(1.0, 1.0, 1.0), IEntitySelector.e.and(Entity::bh));
        double distance = 0.0;
        MovingObjectPositionEntity result = null;
        for (Entity entity : entityList) {
            Vec3D rayTrace;
            double distanceTo;
            double inflationAmount = entity.bu();
            AxisAlignedBB aabb = entity.cw().c(inflationAmount, inflationAmount, inflationAmount);
            Optional<Vec3D> rayTraceResult = aabb.b(start, end);
            if (!rayTraceResult.isPresent() || !((distanceTo = start.g(rayTrace = rayTraceResult.get())) < distance) && distance != 0.0) continue;
            result = new MovingObjectPositionEntity(entity, rayTrace);
            distance = distanceTo;
        }
        return result;
    }

    public int getShieldBlockingDelay() {
        return this.shieldBlockingDelay;
    }

    public void setShieldBlockingDelay(int shieldBlockingDelay) {
        this.shieldBlockingDelay = shieldBlockingDelay;
    }

    public boolean eU() {
        return this.bI();
    }

    public boolean eV() {
        return this.h(7);
    }

    @Override
    public boolean bQ() {
        return super.bQ() || !this.eV() && this.ak() == EntityPose.b;
    }

    public int eW() {
        return this.bB;
    }

    public boolean a(double x2, double y2, double z2, boolean particleEffects) {
        return this.randomTeleport(x2, y2, z2, particleEffects, PlayerTeleportEvent.TeleportCause.UNKNOWN).orElse(false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Optional<Boolean> randomTeleport(double d0, double d1, double d2, boolean flag, PlayerTeleportEvent.TeleportCause cause) {
        double d3 = this.dc();
        double d4 = this.de();
        double d5 = this.di();
        double d6 = d1;
        boolean flag1 = false;
        net.minecraft.world.level.World world = this.s;
        BlockPosition blockposition = new BlockPosition(d0, d1, d2);
        if (world.C(blockposition)) {
            boolean flag2 = false;
            while (!flag2 && blockposition.v() > world.u_()) {
                BlockPosition blockposition1 = blockposition.c();
                IBlockData iblockdata = world.a_(blockposition1);
                if (iblockdata.c().c()) {
                    flag2 = true;
                    continue;
                }
                d6 -= 1.0;
                blockposition = blockposition1;
            }
            if (flag2) {
                this.e(d0, d6, d2);
                if (world.g(this) && !world.d(this.cw())) {
                    flag1 = true;
                }
                this.e(d3, d4, d5);
                if (flag1) {
                    if (!(this instanceof EntityPlayer)) {
                        EntityTeleportEvent teleport = new EntityTeleportEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), new Location((World)this.s.getWorld(), d3, d4, d5), new Location((World)this.s.getWorld(), d0, d6, d2));
                        this.s.getCraftServer().getPluginManager().callEvent((Event)teleport);
                        if (teleport.isCancelled()) return Optional.empty();
                        Location to = teleport.getTo();
                        this.b(to.getX(), to.getY(), to.getZ());
                    } else if (((EntityPlayer)this).b.teleport(d0, d6, d2, this.dn(), this.do(), Collections.emptySet(), false, cause)) {
                        return Optional.empty();
                    }
                }
            }
        }
        if (!flag1) {
            return Optional.of(false);
        }
        if (flag) {
            world.a((Entity)this, (byte)46);
        }
        if (!(this instanceof EntityCreature)) return Optional.of(true);
        ((EntityCreature)this).D().n();
        return Optional.of(true);
    }

    public boolean eX() {
        return true;
    }

    public boolean eY() {
        return true;
    }

    public void a(BlockPosition songPosition, boolean playing) {
    }

    public boolean g(ItemStack stack) {
        return false;
    }

    @Override
    public Packet<?> S() {
        return new PacketPlayOutSpawnEntityLiving(this);
    }

    @Override
    public EntitySize a(EntityPose pose) {
        return pose == EntityPose.c ? aD : super.a(pose).a(this.dF());
    }

    public ImmutableList<EntityPose> eZ() {
        return ImmutableList.of((Object)((Object)EntityPose.a));
    }

    public AxisAlignedBB f(EntityPose pose) {
        EntitySize entitysize = this.a(pose);
        return new AxisAlignedBB(-entitysize.a / 2.0f, 0.0, -entitysize.a / 2.0f, entitysize.a / 2.0f, entitysize.b, entitysize.a / 2.0f);
    }

    public Optional<BlockPosition> fa() {
        return this.Y.a(bP);
    }

    public void e(BlockPosition pos) {
        this.Y.b(bP, Optional.of(pos));
    }

    public void fb() {
        this.Y.b(bP, Optional.empty());
    }

    public boolean fc() {
        return this.fa().isPresent();
    }

    public void b(BlockPosition pos) {
        IBlockData iblockdata;
        if (this.bF()) {
            this.p();
        }
        if ((iblockdata = this.s.a_(pos)).b() instanceof BlockBed) {
            this.s.a(pos, (IBlockData)iblockdata.a(BlockBed.b, true), 3);
        }
        this.b(EntityPose.c);
        this.a(pos);
        this.e(pos);
        this.g(Vec3D.a);
        this.af = true;
    }

    private void a(BlockPosition pos) {
        this.e((double)pos.u() + 0.5, (double)pos.v() + 0.6875, (double)pos.w() + 0.5);
    }

    private boolean E() {
        return this.fa().map(blockposition -> this.s.a_((BlockPosition)blockposition).b() instanceof BlockBed).orElse(false);
    }

    public void fd() {
        Optional<BlockPosition> optional = this.fa();
        net.minecraft.world.level.World world = this.s;
        Objects.requireNonNull(this.s);
        optional.filter(world::C).ifPresent(blockposition -> {
            IBlockData iblockdata = this.s.a_((BlockPosition)blockposition);
            if (iblockdata.b() instanceof BlockBed) {
                this.s.a((BlockPosition)blockposition, (IBlockData)iblockdata.a(BlockBed.b, false), 3);
                Vec3D vec3d = BlockBed.a(this.ad(), (ICollisionAccess)this.s, blockposition, this.dn()).orElseGet(() -> {
                    BlockPosition blockposition1 = blockposition.b();
                    return new Vec3D((double)blockposition1.u() + 0.5, (double)blockposition1.v() + 0.1, (double)blockposition1.w() + 0.5);
                });
                Vec3D vec3d1 = Vec3D.c(blockposition).d(vec3d).d();
                float f2 = (float)MathHelper.f(MathHelper.d(vec3d1.d, vec3d1.b) * 57.2957763671875 - 90.0);
                this.e(vec3d.b, vec3d.c, vec3d.d);
                this.o(f2);
                this.p(0.0f);
            }
        });
        Vec3D vec3d = this.cV();
        this.b(EntityPose.a);
        this.e(vec3d.b, vec3d.c, vec3d.d);
        this.fb();
    }

    @Nullable
    public EnumDirection fe() {
        BlockPosition blockposition = this.fa().orElse(null);
        return blockposition != null ? BlockBed.a(this.s, blockposition) : null;
    }

    @Override
    public boolean bm() {
        return !this.fc() && super.bm();
    }

    @Override
    protected final float a(EntityPose pose, EntitySize dimensions) {
        return pose == EntityPose.c ? 0.2f : this.b(pose, dimensions);
    }

    protected float b(EntityPose pose, EntitySize dimensions) {
        return super.a(pose, dimensions);
    }

    public ItemStack h(ItemStack stack) {
        return ItemStack.b;
    }

    public ItemStack a(net.minecraft.world.level.World world, ItemStack stack) {
        if (stack.K()) {
            world.a((Entity)this, GameEvent.p, this.cY());
            world.a((EntityHuman)null, this.dc(), this.de(), this.di(), this.e(stack), SoundCategory.g, 1.0f, 1.0f + (world.v.nextFloat() - world.v.nextFloat()) * 0.4f);
            this.a(stack, world, this);
            if (!(this instanceof EntityHuman) || !((EntityHuman)this).fs().d) {
                stack.g(1);
            }
            this.a(GameEvent.p);
        }
        return stack;
    }

    private void a(ItemStack stack, net.minecraft.world.level.World world, EntityLiving targetEntity) {
        net.minecraft.world.item.Item item = stack.c();
        if (item.v()) {
            List<Pair<MobEffect, Float>> list = item.w().f();
            for (Pair<MobEffect, Float> pair : list) {
                if (world.x || pair.getFirst() == null || !(world.v.nextFloat() < ((Float)pair.getSecond()).floatValue())) continue;
                targetEntity.addEffect(new MobEffect((MobEffect)pair.getFirst()), EntityPotionEffectEvent.Cause.FOOD);
            }
        }
    }

    private static byte f(EnumItemSlot slot) {
        switch (slot) {
            case a: {
                return 47;
            }
            case b: {
                return 48;
            }
            case f: {
                return 49;
            }
            case e: {
                return 50;
            }
            case c: {
                return 52;
            }
            case d: {
                return 51;
            }
        }
        return 47;
    }

    public void c(EnumItemSlot slot) {
        this.s.a((Entity)this, EntityLiving.f(slot));
    }

    public void d(EnumHand hand) {
        this.c(hand == EnumHand.a ? EnumItemSlot.a : EnumItemSlot.b);
    }

    @Override
    public AxisAlignedBB cx() {
        if (this.b(EnumItemSlot.f).a(Items.rw)) {
            float f2 = 0.5f;
            return this.cw().c(0.5, 0.5, 0.5);
        }
        return super.cx();
    }

    public static EnumItemSlot i(ItemStack stack) {
        net.minecraft.world.item.Item item = stack.c();
        return !(stack.a(Items.eg) || item instanceof ItemBlock && ((ItemBlock)item).e() instanceof BlockSkullAbstract) ? (item instanceof ItemArmor ? ((ItemArmor)item).b() : (stack.a(Items.lT) ? EnumItemSlot.e : (stack.a(Items.sv) ? EnumItemSlot.b : EnumItemSlot.a))) : EnumItemSlot.f;
    }

    private static SlotAccess a(EntityLiving entity, EnumItemSlot slot) {
        return slot != EnumItemSlot.f && slot != EnumItemSlot.a && slot != EnumItemSlot.b ? SlotAccess.a(entity, slot, itemstack -> itemstack.b() || EntityInsentient.i(itemstack) == slot) : SlotAccess.a(entity, slot);
    }

    @Nullable
    private static EnumItemSlot d(int slotId) {
        return slotId == 100 + EnumItemSlot.f.b() ? EnumItemSlot.f : (slotId == 100 + EnumItemSlot.e.b() ? EnumItemSlot.e : (slotId == 100 + EnumItemSlot.d.b() ? EnumItemSlot.d : (slotId == 100 + EnumItemSlot.c.b() ? EnumItemSlot.c : (slotId == 98 ? EnumItemSlot.a : (slotId == 99 ? EnumItemSlot.b : null)))));
    }

    @Override
    public SlotAccess k(int mappedIndex) {
        EnumItemSlot enumitemslot = EntityLiving.d(mappedIndex);
        return enumitemslot != null ? EntityLiving.a(this, enumitemslot) : super.k(mappedIndex);
    }

    @Override
    public boolean dl() {
        if (this.B_()) {
            return false;
        }
        boolean flag = !this.b(EnumItemSlot.f).a(TagsItem.ap) && !this.b(EnumItemSlot.e).a(TagsItem.ap) && !this.b(EnumItemSlot.d).a(TagsItem.ap) && !this.b(EnumItemSlot.c).a(TagsItem.ap);
        return flag && super.dl();
    }

    @Override
    public boolean bT() {
        return !this.s.k_() && this.a(MobEffects.x) || super.bT();
    }

    public void a(PacketPlayOutSpawnEntityLiving packet) {
        double d0 = packet.e();
        double d1 = packet.f();
        double d2 = packet.g();
        float f2 = (float)(packet.k() * 360) / 256.0f;
        float f1 = (float)(packet.l() * 360) / 256.0f;
        this.d(d0, d1, d2);
        this.aX = (float)(packet.m() * 360) / 256.0f;
        this.aZ = (float)(packet.m() * 360) / 256.0f;
        this.aY = this.aX;
        this.ba = this.aZ;
        this.e(packet.b());
        this.a_(packet.c());
        this.a(d0, d1, d2, f2, f1);
        this.n((float)packet.h() / 8000.0f, (float)packet.i() / 8000.0f, (float)packet.j() / 8000.0f);
    }

    private static class ProcessableEffect {
        private MobEffectList type;
        private MobEffect effect;
        private final EntityPotionEffectEvent.Cause cause;

        private ProcessableEffect(MobEffect effect, EntityPotionEffectEvent.Cause cause) {
            this.effect = effect;
            this.cause = cause;
        }

        private ProcessableEffect(MobEffectList type, EntityPotionEffectEvent.Cause cause) {
            this.type = type;
            this.cause = cause;
        }
    }

    public record a(SoundEffect a, SoundEffect b) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "small;big", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "small;big", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "small;big", "a", "b"}, this, o2);
        }
    }
}

