/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.destroystokyo.paper.event.player.PlayerPickupExperienceEvent;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntityExperienceOrb;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.tags.TagsFluid;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.World;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_18_R2.event.CraftEventFactory;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.event.player.PlayerItemMendEvent;

public class EntityExperienceOrb
extends Entity {
    private static final int b = 6000;
    private static final int c = 20;
    private static final int d = 8;
    private static final int e = 40;
    private static final double f = 0.5;
    private int ao;
    private int ap = 5;
    public int aq;
    private int ar = 1;
    private EntityHuman as;
    public UUID sourceEntityId;
    public UUID triggerEntityId;
    public ExperienceOrb.SpawnReason spawnReason = ExperienceOrb.SpawnReason.UNKNOWN;

    private void loadPaperNBT(NBTTagCompound nbttagcompound) {
        if (!nbttagcompound.b("Paper.ExpData", 10)) {
            return;
        }
        NBTTagCompound comp = nbttagcompound.p("Paper.ExpData");
        if (comp.b("source")) {
            this.sourceEntityId = comp.a("source");
        }
        if (comp.b("trigger")) {
            this.triggerEntityId = comp.a("trigger");
        }
        if (comp.e("reason")) {
            String reason = comp.l("reason");
            try {
                this.spawnReason = ExperienceOrb.SpawnReason.valueOf((String)reason);
            }
            catch (Exception e2) {
                this.s.getCraftServer().getLogger().warning("Invalid spawnReason set for experience orb: " + e2.getMessage() + " - " + reason);
            }
        }
    }

    private void savePaperNBT(NBTTagCompound nbttagcompound) {
        NBTTagCompound comp = new NBTTagCompound();
        if (this.sourceEntityId != null) {
            comp.a("source", this.sourceEntityId);
        }
        if (this.triggerEntityId != null) {
            comp.a("trigger", this.triggerEntityId);
        }
        if (this.spawnReason != null && this.spawnReason != ExperienceOrb.SpawnReason.UNKNOWN) {
            comp.a("reason", this.spawnReason.name());
        }
        nbttagcompound.a("Paper.ExpData", comp);
    }

    public EntityExperienceOrb(World world, double x2, double y2, double z2, int amount) {
        this(world, x2, y2, z2, amount, null, null);
    }

    public EntityExperienceOrb(World world, double d0, double d1, double d2, int i2, ExperienceOrb.SpawnReason reason, Entity triggerId) {
        this(world, d0, d1, d2, i2, reason, triggerId, null);
    }

    public EntityExperienceOrb(World world, double d0, double d1, double d2, int i2, ExperienceOrb.SpawnReason reason, Entity triggerId, Entity sourceId) {
        this((EntityTypes<? extends EntityExperienceOrb>)EntityTypes.A, world);
        this.sourceEntityId = sourceId != null ? sourceId.cm() : null;
        this.triggerEntityId = triggerId != null ? triggerId.cm() : null;
        this.spawnReason = reason != null ? reason : ExperienceOrb.SpawnReason.UNKNOWN;
        this.e(d0, d1, d2);
        this.o((float)(this.R.nextDouble() * 360.0));
        this.n((this.R.nextDouble() * (double)0.2f - (double)0.1f) * 2.0, this.R.nextDouble() * 0.2 * 2.0, (this.R.nextDouble() * (double)0.2f - (double)0.1f) * 2.0);
        this.aq = i2;
    }

    public EntityExperienceOrb(EntityTypes<? extends EntityExperienceOrb> type, World world) {
        super(type, world);
    }

    @Override
    protected Entity.MovementEmission aN() {
        return Entity.MovementEmission.a;
    }

    @Override
    protected void a_() {
    }

    @Override
    public void k() {
        Vec3D vec3d;
        double d0;
        super.k();
        EntityHuman prevTarget = this.as;
        this.t = this.dc();
        this.u = this.de();
        this.v = this.di();
        if (this.a(TagsFluid.a)) {
            this.l();
        } else if (!this.aM()) {
            this.g(this.da().b(0.0, -0.03, 0.0));
        }
        if (this.s.b_(this.cW()).a(TagsFluid.b)) {
            this.n((this.R.nextFloat() - this.R.nextFloat()) * 0.2f, 0.2f, (this.R.nextFloat() - this.R.nextFloat()) * 0.2f);
        }
        if (!this.s.b(this.cw())) {
            this.l(this.dc(), (this.cw().b + this.cw().e) / 2.0, this.di());
        }
        if (this.S % 20 == 1) {
            this.j();
        }
        if (this.as != null && (this.as.B_() || this.as.eb())) {
            this.as = null;
        }
        boolean cancelled = false;
        if (this.as != prevTarget) {
            EntityTargetLivingEntityEvent event = CraftEventFactory.callEntityTargetLivingEvent(this, this.as, this.as != null ? EntityTargetEvent.TargetReason.CLOSEST_PLAYER : EntityTargetEvent.TargetReason.FORGOT_TARGET);
            EntityLiving target = event.getTarget() == null ? null : ((CraftLivingEntity)event.getTarget()).getHandle();
            cancelled = event.isCancelled();
            if (cancelled) {
                this.as = prevTarget;
            } else {
                EntityHuman entityHuman = this.as = target instanceof EntityHuman ? (EntityHuman)target : null;
            }
        }
        if (this.as != null && !cancelled && (d0 = (vec3d = new Vec3D(this.as.dc() - this.dc(), this.as.de() + (double)this.as.cy() / 2.0 - this.de(), this.as.di() - this.di())).g()) < 64.0) {
            double d1 = 1.0 - Math.sqrt(d0) / 8.0;
            this.g(this.da().e(vec3d.d().a(d1 * d1 * 0.1)));
        }
        this.a(EnumMoveType.a, this.da());
        float f2 = 0.98f;
        if (this.y) {
            f2 = this.s.a_(new BlockPosition(this.dc(), this.de() - 1.0, this.di())).b().i() * 0.98f;
        }
        this.g(this.da().d(f2, 0.98, f2));
        if (this.y) {
            this.g(this.da().d(1.0, -0.9, 1.0));
        }
        ++this.ao;
        if (this.ao >= 6000) {
            this.ah();
        }
    }

    private void j() {
        if (this.as == null || this.as.f(this) > 64.0) {
            this.as = this.s.a((Entity)this, 8.0);
        }
        if (this.s instanceof WorldServer) {
            List<EntityExperienceOrb> list = this.s.a(EntityTypeTest.a(EntityExperienceOrb.class), this.cw().g(0.5), this::a);
            for (EntityExperienceOrb entityexperienceorb : list) {
                this.b(entityexperienceorb);
            }
        }
    }

    public static void a(WorldServer world, Vec3D pos, int amount) {
        EntityExperienceOrb.award(world, pos, amount, null, null, null);
    }

    public static void award(WorldServer world, Vec3D pos, int amount, ExperienceOrb.SpawnReason reason, Entity triggerId) {
        EntityExperienceOrb.award(world, pos, amount, reason, triggerId, null);
    }

    public static void award(WorldServer world, Vec3D pos, int amount, ExperienceOrb.SpawnReason reason, Entity triggerId, Entity sourceId) {
        while (amount > 0) {
            int j2 = EntityExperienceOrb.a(amount);
            amount -= j2;
            if (EntityExperienceOrb.b(world, pos, j2)) continue;
            world.b(new EntityExperienceOrb(world, pos.a(), pos.b(), pos.c(), j2, reason, triggerId, sourceId));
        }
    }

    private static boolean b(WorldServer world, Vec3D pos, int amount) {
        AxisAlignedBB axisalignedbb = AxisAlignedBB.a(pos, 1.0, 1.0, 1.0);
        int j2 = world.r_().nextInt(40);
        List<EntityExperienceOrb> list = world.a(EntityTypeTest.a(EntityExperienceOrb.class), axisalignedbb, (? super T entityexperienceorb) -> EntityExperienceOrb.a(entityexperienceorb, j2, amount));
        if (!list.isEmpty()) {
            EntityExperienceOrb entityexperienceorb2 = list.get(0);
            ++entityexperienceorb2.ar;
            entityexperienceorb2.ao = 0;
            return true;
        }
        return false;
    }

    private boolean a(EntityExperienceOrb other) {
        return other != this && EntityExperienceOrb.a(other, this.ae(), this.aq);
    }

    private static boolean a(EntityExperienceOrb orb, int seed, int amount) {
        return !orb.dp() && (orb.ae() - seed) % 40 == 0 && orb.aq == amount;
    }

    private void b(EntityExperienceOrb other) {
        this.ar += other.ar;
        this.ao = Math.min(this.ao, other.ao);
        other.ah();
    }

    private void l() {
        Vec3D vec3d = this.da();
        this.n(vec3d.b * (double)0.99f, Math.min(vec3d.c + (double)5.0E-4f, (double)0.06f), vec3d.d * (double)0.99f);
    }

    @Override
    protected void aY() {
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        if (this.b(source)) {
            return false;
        }
        if (this.s.x) {
            return true;
        }
        this.bf();
        this.ap = (int)((float)this.ap - amount);
        if (this.ap <= 0) {
            this.ah();
        }
        return true;
    }

    @Override
    public void b(NBTTagCompound nbt) {
        nbt.a("Health", (short)this.ap);
        nbt.a("Age", (short)this.ao);
        nbt.a("Value", this.aq);
        nbt.a("Count", this.ar);
        this.savePaperNBT(nbt);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        this.ap = nbt.g("Health");
        this.ao = nbt.g("Age");
        this.aq = nbt.h("Value");
        this.ar = Math.max(nbt.h("Count"), 1);
        this.loadPaperNBT(nbt);
    }

    @Override
    public void b(EntityHuman player) {
        if (!this.s.x && player.ca == 0 && new PlayerPickupExperienceEvent((Player)((EntityPlayer)player).getBukkitEntity(), (ExperienceOrb)this.getBukkitEntity()).callEvent()) {
            player.ca = 2;
            player.a((Entity)this, 1);
            int i2 = this.a(player, this.aq);
            if (i2 > 0) {
                player.d(CraftEventFactory.callPlayerExpChangeEvent(player, this).getAmount());
            }
            --this.ar;
            if (this.ar == 0) {
                this.ah();
            }
        }
    }

    private int a(EntityHuman player, int amount) {
        Map.Entry<EnumItemSlot, ItemStack> entry = EnchantmentManager.a(Enchantments.K, player, ItemStack::h);
        if (entry != null) {
            int k2;
            ItemStack itemstack = entry.getValue();
            int j2 = Math.min(this.c(this.aq), itemstack.i());
            PlayerItemMendEvent event = CraftEventFactory.callPlayerItemMendEvent(player, this, itemstack, j2);
            j2 = event.getRepairAmount();
            if (event.isCancelled()) {
                return amount;
            }
            itemstack.b(itemstack.i() - j2);
            this.aq = k2 = amount - this.b(j2);
            return k2 > 0 ? this.a(player, k2) : 0;
        }
        return amount;
    }

    public int b(int repairAmount) {
        return repairAmount / 2;
    }

    public int c(int experienceAmount) {
        return experienceAmount * 2;
    }

    public int h() {
        return this.aq;
    }

    public int i() {
        return this.aq >= 2477 ? 10 : (this.aq >= 1237 ? 9 : (this.aq >= 617 ? 8 : (this.aq >= 307 ? 7 : (this.aq >= 149 ? 6 : (this.aq >= 73 ? 5 : (this.aq >= 37 ? 4 : (this.aq >= 17 ? 3 : (this.aq >= 7 ? 2 : (this.aq >= 3 ? 1 : 0)))))))));
    }

    public static int a(int value) {
        if (value > 162670129) {
            return value - 100000;
        }
        if (value > 81335063) {
            return 81335063;
        }
        if (value > 40667527) {
            return 40667527;
        }
        if (value > 20333759) {
            return 20333759;
        }
        if (value > 10166857) {
            return 10166857;
        }
        if (value > 5083423) {
            return 5083423;
        }
        if (value > 2541701) {
            return 2541701;
        }
        if (value > 1270849) {
            return 1270849;
        }
        if (value > 635413) {
            return 635413;
        }
        if (value > 317701) {
            return 317701;
        }
        if (value > 158849) {
            return 158849;
        }
        if (value > 79423) {
            return 79423;
        }
        if (value > 39709) {
            return 39709;
        }
        if (value > 19853) {
            return 19853;
        }
        if (value > 9923) {
            return 9923;
        }
        if (value > 4957) {
            return 4957;
        }
        return value >= 2477 ? 2477 : (value >= 1237 ? 1237 : (value >= 617 ? 617 : (value >= 307 ? 307 : (value >= 149 ? 149 : (value >= 73 ? 73 : (value >= 37 ? 37 : (value >= 17 ? 17 : (value >= 7 ? 7 : (value >= 3 ? 3 : 1)))))))));
    }

    @Override
    public boolean cf() {
        return false;
    }

    @Override
    public Packet<?> S() {
        return new PacketPlayOutSpawnEntityExperienceOrb(this);
    }

    @Override
    public SoundCategory cO() {
        return SoundCategory.i;
    }
}

