/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.ArgumentParticle;
import net.minecraft.core.IRegistry;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.item.alchemy.PotionRegistry;
import net.minecraft.world.item.alchemy.PotionUtil;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.World;
import net.minecraft.world.level.material.EnumPistonReaction;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_18_R2.event.CraftEventFactory;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.entity.AreaEffectCloudApplyEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.slf4j.Logger;

public class EntityAreaEffectCloud
extends Entity {
    private static final Logger b = LogUtils.getLogger();
    private static final int c = 5;
    private static final DataWatcherObject<Float> d = DataWatcher.a(EntityAreaEffectCloud.class, DataWatcherRegistry.c);
    private static final DataWatcherObject<Integer> e = DataWatcher.a(EntityAreaEffectCloud.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Boolean> f = DataWatcher.a(EntityAreaEffectCloud.class, DataWatcherRegistry.i);
    private static final DataWatcherObject<ParticleParam> ao = DataWatcher.a(EntityAreaEffectCloud.class, DataWatcherRegistry.j);
    private static final float ap = 32.0f;
    private PotionRegistry aq = Potions.a;
    public List<MobEffect> ar = Lists.newArrayList();
    private final Map<Entity, Integer> as = Maps.newHashMap();
    private int at = 600;
    public int au = 20;
    public int av = 20;
    private boolean aw;
    public int ax;
    public float ay;
    public float az;
    @Nullable
    private EntityLiving aA;
    @Nullable
    private UUID aB;

    public EntityAreaEffectCloud(EntityTypes<? extends EntityAreaEffectCloud> type, World world) {
        super(type, world);
        this.Q = true;
        this.a(3.0f);
    }

    public EntityAreaEffectCloud(World world, double x2, double y2, double z2) {
        this((EntityTypes<? extends EntityAreaEffectCloud>)EntityTypes.b, world);
        this.e(x2, y2, z2);
    }

    @Override
    protected void a_() {
        this.ai().a(e, 0);
        this.ai().a(d, Float.valueOf(0.5f));
        this.ai().a(f, false);
        this.ai().a(ao, Particles.v);
    }

    public void a(float radius) {
        if (!this.s.x) {
            this.ai().b(d, Float.valueOf(MathHelper.a(radius, 0.0f, 32.0f)));
        }
    }

    @Override
    public void z_() {
        double d0 = this.dc();
        double d1 = this.de();
        double d2 = this.di();
        super.z_();
        this.e(d0, d1, d2);
    }

    public float h() {
        return this.ai().a(d).floatValue();
    }

    public void a(PotionRegistry potion) {
        this.aq = potion;
        if (!this.aw) {
            this.w();
        }
    }

    private void w() {
        if (this.aq == Potions.a && this.ar.isEmpty()) {
            this.ai().b(e, 0);
        } else {
            this.ai().b(e, PotionUtil.a(PotionUtil.a(this.aq, this.ar)));
        }
    }

    public void a(MobEffect effect) {
        this.ar.add(effect);
        if (!this.aw) {
            this.w();
        }
    }

    public void refreshEffects() {
        if (!this.aw) {
            this.ai().b(e, PotionUtil.a(PotionUtil.a(this.aq, this.ar)));
        }
    }

    public String getPotionType() {
        return IRegistry.Y.b(this.aq).toString();
    }

    public void setPotionType(String string) {
        this.a(IRegistry.Y.a(new MinecraftKey(string)));
    }

    public int i() {
        return this.ai().a(e);
    }

    public void a(int rgb) {
        this.aw = true;
        this.ai().b(e, rgb);
    }

    public ParticleParam j() {
        return this.ai().a(ao);
    }

    public void a(ParticleParam particle) {
        this.ai().b(ao, particle);
    }

    protected void a(boolean waiting) {
        this.ai().b(f, waiting);
    }

    public boolean l() {
        return this.ai().a(f);
    }

    public int n() {
        return this.at;
    }

    public void b(int duration) {
        this.at = duration;
    }

    @Override
    public void inactiveTick() {
        super.inactiveTick();
        if (this.S >= this.au + this.at) {
            this.ah();
            return;
        }
    }

    @Override
    public void k() {
        block22: {
            ArrayList list;
            float f2;
            block23: {
                boolean flag1;
                boolean flag;
                block21: {
                    float f1;
                    int i2;
                    super.k();
                    flag = this.l();
                    f2 = this.h();
                    if (!this.s.x) break block21;
                    if (flag && this.R.nextBoolean()) {
                        return;
                    }
                    ParticleParam particleparam = this.j();
                    if (flag) {
                        i2 = 2;
                        f1 = 0.2f;
                    } else {
                        i2 = MathHelper.f((float)Math.PI * f2 * f2);
                        f1 = f2;
                    }
                    for (int j2 = 0; j2 < i2; ++j2) {
                        double d5;
                        double d4;
                        double d3;
                        float f22 = this.R.nextFloat() * ((float)Math.PI * 2);
                        float f3 = MathHelper.c(this.R.nextFloat()) * f1;
                        double d0 = this.dc() + (double)(MathHelper.b(f22) * f3);
                        double d1 = this.de();
                        double d2 = this.di() + (double)(MathHelper.a(f22) * f3);
                        if (particleparam.b() == Particles.v) {
                            int k2 = flag && this.R.nextBoolean() ? 0xFFFFFF : this.i();
                            d3 = (float)(k2 >> 16 & 0xFF) / 255.0f;
                            d4 = (float)(k2 >> 8 & 0xFF) / 255.0f;
                            d5 = (float)(k2 & 0xFF) / 255.0f;
                        } else if (flag) {
                            d3 = 0.0;
                            d4 = 0.0;
                            d5 = 0.0;
                        } else {
                            d3 = (0.5 - this.R.nextDouble()) * 0.15;
                            d4 = 0.01f;
                            d5 = (0.5 - this.R.nextDouble()) * 0.15;
                        }
                        this.s.b(particleparam, d0, d1, d2, d3, d4, d5);
                    }
                    break block22;
                }
                if (this.S >= this.au + this.at) {
                    this.ah();
                    return;
                }
                boolean bl = flag1 = this.S < this.au;
                if (flag != flag1) {
                    this.a(flag1);
                }
                if (flag1) {
                    return;
                }
                if (this.az != 0.0f) {
                    if ((f2 += this.az) < 0.5f) {
                        this.ah();
                        return;
                    }
                    this.a(f2);
                }
                if (this.S % 5 != 0) break block22;
                this.as.entrySet().removeIf(entry -> this.S >= (Integer)entry.getValue());
                list = Lists.newArrayList();
                for (MobEffect mobeffect : this.aq.a()) {
                    list.add(new MobEffect(mobeffect.a(), mobeffect.b() / 4, mobeffect.c(), mobeffect.d(), mobeffect.e()));
                }
                list.addAll(this.ar);
                if (!list.isEmpty()) break block23;
                this.as.clear();
                break block22;
            }
            List<EntityLiving> list1 = this.s.a(EntityLiving.class, this.cw());
            if (list1.isEmpty()) break block22;
            Iterator<EntityLiving> iterator1 = list1.iterator();
            ArrayList<LivingEntity> entities = new ArrayList<LivingEntity>();
            while (iterator1.hasNext()) {
                double d7;
                double d6;
                double d8;
                EntityLiving entityliving = iterator1.next();
                if (this.as.containsKey(entityliving) || !entityliving.eX() || !((d8 = (d6 = entityliving.dc() - this.dc()) * d6 + (d7 = entityliving.di() - this.di()) * d7) <= (double)(f2 * f2))) continue;
                entities.add((LivingEntity)entityliving.getBukkitEntity());
            }
            AreaEffectCloudApplyEvent event = CraftEventFactory.callAreaEffectCloudApplyEvent(this, entities);
            if (!event.isCancelled()) {
                for (LivingEntity entity : event.getAffectedEntities()) {
                    if (!(entity instanceof CraftLivingEntity)) continue;
                    EntityLiving entityliving = ((CraftLivingEntity)entity).getHandle();
                    this.as.put(entityliving, this.S + this.av);
                    for (MobEffect mobeffect1 : list) {
                        if (mobeffect1.a().a()) {
                            mobeffect1.a().a(this, this.t(), entityliving, mobeffect1.c(), 0.5);
                            continue;
                        }
                        entityliving.addEffect(new MobEffect(mobeffect1), this, EntityPotionEffectEvent.Cause.AREA_EFFECT_CLOUD);
                    }
                    if (this.ay != 0.0f) {
                        if ((f2 += this.ay) < 0.5f) {
                            this.ah();
                            return;
                        }
                        this.a(f2);
                    }
                    if (this.ax == 0) continue;
                    this.at += this.ax;
                    if (this.at > 0) continue;
                    this.ah();
                    return;
                }
            }
        }
    }

    public float o() {
        return this.ay;
    }

    public void b(float radiusOnUse) {
        this.ay = radiusOnUse;
    }

    public float q() {
        return this.az;
    }

    public void c(float radiusGrowth) {
        this.az = radiusGrowth;
    }

    public int r() {
        return this.ax;
    }

    public void c(int durationOnUse) {
        this.ax = durationOnUse;
    }

    public int s() {
        return this.au;
    }

    public void d(int waitTime) {
        this.au = waitTime;
    }

    public void a(@Nullable EntityLiving owner) {
        this.aA = owner;
        this.aB = owner == null ? null : owner.cm();
    }

    @Nullable
    public EntityLiving t() {
        Entity entity;
        if (this.aA == null && this.aB != null && this.s instanceof WorldServer && (entity = ((WorldServer)this.s).a(this.aB)) instanceof EntityLiving) {
            this.aA = (EntityLiving)entity;
        }
        return this.aA;
    }

    @Override
    protected void a(NBTTagCompound nbt) {
        this.S = nbt.h("Age");
        this.at = nbt.h("Duration");
        this.au = nbt.h("WaitTime");
        this.av = nbt.h("ReapplicationDelay");
        this.ax = nbt.h("DurationOnUse");
        this.ay = nbt.j("RadiusOnUse");
        this.az = nbt.j("RadiusPerTick");
        this.a(nbt.j("Radius"));
        if (nbt.b("Owner")) {
            this.aB = nbt.a("Owner");
        }
        if (nbt.b("Particle", 8)) {
            try {
                this.a(ArgumentParticle.b(new StringReader(nbt.l("Particle"))));
            }
            catch (CommandSyntaxException commandsyntaxexception) {
                b.warn("Couldn't load custom particle {}", (Object)nbt.l("Particle"), (Object)commandsyntaxexception);
            }
        }
        if (nbt.b("Color", 99)) {
            this.a(nbt.h("Color"));
        }
        if (nbt.b("Potion", 8)) {
            this.a(PotionUtil.c(nbt));
        }
        if (nbt.b("Effects", 9)) {
            NBTTagList nbttaglist = nbt.c("Effects", 10);
            this.ar.clear();
            for (int i2 = 0; i2 < nbttaglist.size(); ++i2) {
                MobEffect mobeffect = MobEffect.b(nbttaglist.a(i2));
                if (mobeffect == null) continue;
                this.a(mobeffect);
            }
        }
    }

    @Override
    protected void b(NBTTagCompound nbt) {
        nbt.a("Age", this.S);
        nbt.a("Duration", this.at);
        nbt.a("WaitTime", this.au);
        nbt.a("ReapplicationDelay", this.av);
        nbt.a("DurationOnUse", this.ax);
        nbt.a("RadiusOnUse", this.ay);
        nbt.a("RadiusPerTick", this.az);
        nbt.a("Radius", this.h());
        nbt.a("Particle", this.j().a());
        if (this.aB != null) {
            nbt.a("Owner", this.aB);
        }
        if (this.aw) {
            nbt.a("Color", this.i());
        }
        if (this.aq != Potions.a) {
            nbt.a("Potion", IRegistry.Y.b(this.aq).toString());
        }
        if (!this.ar.isEmpty()) {
            NBTTagList nbttaglist = new NBTTagList();
            for (MobEffect mobeffect : this.ar) {
                nbttaglist.add(mobeffect.a(new NBTTagCompound()));
            }
            nbt.a("Effects", nbttaglist);
        }
    }

    @Override
    public void a(DataWatcherObject<?> data) {
        if (d.equals(data)) {
            this.z_();
        }
        super.a(data);
    }

    public PotionRegistry u() {
        return this.aq;
    }

    @Override
    public EnumPistonReaction c_() {
        return EnumPistonReaction.d;
    }

    @Override
    public Packet<?> S() {
        return new PacketPlayOutSpawnEntity(this);
    }

    @Override
    public EntitySize a(EntityPose pose) {
        return EntitySize.b(this.h() * 2.0f, 0.5f);
    }
}

