/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.destroystokyo.paper.PaperConfig;
import com.destroystokyo.paper.loottable.PaperLootableInventoryData;
import com.destroystokyo.paper.util.misc.PooledLinkedHashSets;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import com.mojang.logging.LogUtils;
import io.papermc.paper.util.CachedLists;
import io.papermc.paper.util.CollisionUtil;
import io.papermc.paper.util.KeyedObject;
import io.papermc.paper.util.TickThread;
import it.unimi.dsi.fastutil.objects.Object2DoubleArrayMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.BlockUtil;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICommandListener;
import net.minecraft.commands.arguments.ArgumentAnchor;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.chat.ChatClickable;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MCUtil;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.PlayerChunk;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsEntity;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.INamableTileEntity;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTameableAnimal;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityFish;
import net.minecraft.world.entity.decoration.EntityHanging;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityShulker;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.EnchantmentProtection;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFenceGate;
import net.minecraft.world.level.block.BlockHoney;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.SoundEffectType;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.level.entity.EntityInLevelCallback;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListenerRegistrar;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.portal.BlockPortalShape;
import net.minecraft.world.level.portal.ShapeDetectorShape;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.scores.ScoreboardTeamBase;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_18_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_18_R2.block.CraftBlock;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_18_R2.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_18_R2.event.CraftPortalEvent;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_18_R2.util.CraftVector;
import org.bukkit.craftbukkit.v1_18_R2.util.UnsafeList;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Pose;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityAirChangeEvent;
import org.bukkit.event.entity.EntityCombustByBlockEvent;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.event.entity.EntityDropItemEvent;
import org.bukkit.event.entity.EntityPortalEnterEvent;
import org.bukkit.event.entity.EntityPortalEvent;
import org.bukkit.event.entity.EntityPortalExitEvent;
import org.bukkit.event.entity.EntityPoseChangeEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.vehicle.VehicleBlockCollisionEvent;
import org.bukkit.event.vehicle.VehicleEnterEvent;
import org.bukkit.event.vehicle.VehicleExitEvent;
import org.bukkit.plugin.PluginManager;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.spigotmc.ActivationRange;
import org.spigotmc.TrackingRange;
import org.spigotmc.event.entity.EntityDismountEvent;
import org.spigotmc.event.entity.EntityMountEvent;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class Entity
implements INamableTileEntity,
EntityAccess,
ICommandListener,
KeyedObject {
    private static final int CURRENT_LEVEL = 2;
    public boolean preserveMotion = true;
    public static Random SHARED_RANDOM = new Random(){
        private boolean locked = false;

        @Override
        public synchronized void setSeed(long seed) {
            if (this.locked) {
                b.error("Ignoring setSeed on Entity.SHARED_RANDOM", new Throwable());
            } else {
                super.setSeed(seed);
                this.locked = true;
            }
        }
    };
    public CreatureSpawnEvent.SpawnReason spawnReason;
    public PaperLootableInventoryData lootableData;
    public boolean collisionLoadChunks = false;
    private CraftEntity bukkitEntity;
    @Nullable
    public PlayerChunkMap.EntityTracker tracker;
    @javax.annotation.Nullable
    public Throwable addedToWorldStack;
    private static final Logger b = LogUtils.getLogger();
    public static final String g = "id";
    public static final String h = "Passengers";
    private static final AtomicInteger c = new AtomicInteger();
    private static final List<ItemStack> d = Collections.emptyList();
    public static final int i = 60;
    public static final int j = 300;
    public static final int k = 1024;
    public static final double l = 0.5000001;
    public static final float m = 0.11111111f;
    public static final int n = 140;
    public static final int o = 40;
    private static final AxisAlignedBB e = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    private static final double ao = 0.014;
    private static final double ap = 0.007;
    private static final double aq = 0.0023333333333333335;
    public static final String p = "UUID";
    private static double ar = 1.0;
    private final EntityTypes<?> as;
    private int at;
    public boolean q;
    public ImmutableList<Entity> au;
    protected int r;
    @javax.annotation.Nullable
    private Entity av;
    public net.minecraft.world.level.World s;
    public double t;
    public double u;
    public double v;
    private Vec3D aw;
    private BlockPosition ax;
    private ChunkCoordIntPair ay;
    private Vec3D az;
    public float aA;
    private float aB;
    public float w;
    public float x;
    private AxisAlignedBB aC;
    public boolean y;
    public boolean z;
    public boolean A;
    public boolean B;
    public boolean C;
    public boolean D;
    protected Vec3D E;
    @javax.annotation.Nullable
    private RemovalReason aD;
    public static final float F = 0.6f;
    public static final float G = 1.8f;
    public float H;
    public float I;
    public float J;
    public float K;
    public float L;
    private float aE = 1.0f;
    public double M;
    public double N;
    public double O;
    public float P;
    public boolean Q;
    protected final Random R;
    public int S;
    public int aF;
    public boolean T;
    protected Object2DoubleMap<TagKey<FluidType>> U;
    protected boolean V;
    private final Set<TagKey<FluidType>> aG;
    public int W;
    protected boolean X = true;
    protected final DataWatcher Y;
    protected static final DataWatcherObject<Byte> Z = DataWatcher.a(Entity.class, DataWatcherRegistry.a);
    protected static final int aa = 0;
    private static final int aH = 1;
    private static final int aI = 3;
    private static final int aJ = 4;
    private static final int aK = 5;
    protected static final int ab = 6;
    protected static final int ac = 7;
    private static final DataWatcherObject<Integer> aL = DataWatcher.a(Entity.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Optional<IChatBaseComponent>> aM = DataWatcher.a(Entity.class, DataWatcherRegistry.f);
    private static final DataWatcherObject<Boolean> aN = DataWatcher.a(Entity.class, DataWatcherRegistry.i);
    private static final DataWatcherObject<Boolean> aO = DataWatcher.a(Entity.class, DataWatcherRegistry.i);
    private static final DataWatcherObject<Boolean> aP = DataWatcher.a(Entity.class, DataWatcherRegistry.i);
    protected static final DataWatcherObject<EntityPose> ad = DataWatcher.a(Entity.class, DataWatcherRegistry.s);
    private static final DataWatcherObject<Integer> aQ = DataWatcher.a(Entity.class, DataWatcherRegistry.b);
    private EntityInLevelCallback aR;
    private Vec3D aS;
    public boolean ae;
    public boolean af;
    public int aT;
    public boolean ag;
    protected int ah;
    protected BlockPosition ai;
    private boolean aU;
    protected UUID aj;
    protected String ak;
    private boolean aV;
    private final Set<String> aW;
    private final double[] aX;
    private long aY;
    private EntitySize aZ;
    private float ba;
    public boolean al;
    public boolean am;
    public boolean an;
    private float bb;
    private int bc;
    public boolean bd;
    @javax.annotation.Nullable
    private IBlockData be = null;
    public boolean persist = true;
    public boolean valid;
    public boolean generation;
    public int maxAirTicks = this.getDefaultMaxAirSupply();
    public ProjectileSource projectileSource;
    public boolean lastDamageCancelled;
    public boolean persistentInvisibility = false;
    public BlockPosition lastLavaContact;
    public final ActivationRange.ActivationType activationType = ActivationRange.initializeEntityActivationType(this);
    public final boolean defaultActivationState;
    public long activatedTick = Integer.MIN_VALUE;
    public long activatedImmunityTick = Integer.MIN_VALUE;
    public boolean isTemporarilyActive = false;
    public boolean fromNetherPortal;
    protected int numCollisions = 0;
    public boolean spawnedViaMobSpawner;
    @javax.annotation.Nullable
    private Vector origin;
    @javax.annotation.Nullable
    private UUID originWorld;
    public boolean freezeLocked = false;
    final TrackingRange.TrackingRangeType trackingRangeType = TrackingRange.getTrackingRangeType(this);
    public boolean isLegacyTrackingEntity = false;
    public BlockPosition portalBlock;
    public WorldServer portalWorld;
    private final boolean hardCollides = this instanceof EntityBoat || this instanceof EntityShulker || this instanceof EntityMinecartAbstract || this.shouldHardCollide();
    private static final Map<Class<? extends Entity>, Boolean> cachedOverrides = Collections.synchronizedMap(new WeakHashMap());
    public PlayerChunk.State chunkStatus;
    public int sectionX = Integer.MIN_VALUE;
    public int sectionY = Integer.MIN_VALUE;
    public int sectionZ = Integer.MIN_VALUE;
    public final Object posLock = new Object();
    private Vec3D moveVector;
    private double moveStartX;
    private double moveStartY;
    private double moveStartZ;
    private MinecraftKey entityKey;
    private String entityKeyString;

    static boolean isLevelAtLeast(NBTTagCompound tag, int level) {
        return tag.e("Bukkit.updateLevel") && tag.h("Bukkit.updateLevel") >= level;
    }

    public CraftEntity getBukkitEntity() {
        if (this.bukkitEntity == null) {
            this.bukkitEntity = CraftEntity.getEntity(this.s.getCraftServer(), this);
        }
        return this.bukkitEntity;
    }

    @Override
    public CommandSender getBukkitSender(CommandListenerWrapper wrapper) {
        return this.getBukkitEntity();
    }

    public int getDefaultMaxAirSupply() {
        return 300;
    }

    public void inactiveTick() {
    }

    public void setOrigin(@Nonnull Location location) {
        this.origin = location.toVector();
        this.originWorld = location.getWorld().getUID();
    }

    @javax.annotation.Nullable
    public Vector getOriginVector() {
        return this.origin != null ? this.origin.clone() : null;
    }

    @javax.annotation.Nullable
    public UUID getOriginWorld() {
        return this.originWorld;
    }

    public float getBukkitYaw() {
        return this.aA;
    }

    public boolean isChunkLoaded() {
        return this.s.b((int)Math.floor(this.dc()) >> 4, (int)Math.floor(this.di()) >> 4);
    }

    public final AxisAlignedBB getBoundingBoxAt(double x2, double y2, double z2) {
        return this.aZ.a(x2, y2, z2);
    }

    public final void setLegacyTrackingEntity(boolean isLegacyTrackingEntity) {
        this.isLegacyTrackingEntity = isLegacyTrackingEntity;
    }

    public final PooledLinkedHashSets.PooledObjectLinkedOpenHashSet<EntityPlayer> getPlayersInTrackRange() {
        if (this.au.isEmpty()) {
            return ((WorldServer)this.s).k().a.playerEntityTrackerTrackMaps[this.trackingRangeType.ordinal()].getObjectsInRange(MCUtil.getCoordinateKey(this));
        }
        Iterable<Entity> passengers = this.cJ();
        PlayerChunkMap chunkMap = ((WorldServer)this.s).k().a;
        TrackingRange.TrackingRangeType type = this.trackingRangeType;
        int range = chunkMap.getEntityTrackerRange(type.ordinal());
        for (Entity passenger : passengers) {
            TrackingRange.TrackingRangeType passengerType = passenger.trackingRangeType;
            int passengerRange = chunkMap.getEntityTrackerRange(passengerType.ordinal());
            if (passengerRange <= range) continue;
            type = passengerType;
            range = passengerRange;
        }
        return chunkMap.playerEntityTrackerTrackMaps[type.ordinal()].getObjectsInRange(MCUtil.getCoordinateKey(this));
    }

    public void tickEndPortal() {
        BlockPosition pos = this.portalBlock;
        WorldServer world = this.portalWorld;
        this.portalBlock = null;
        this.portalWorld = null;
        if (pos == null || world == null || world != this.s) {
            return;
        }
        if (this.bF() || this.bG() || !this.ci() || this.dp() || !this.valid || !this.bl()) {
            return;
        }
        ResourceKey<net.minecraft.world.level.World> resourcekey = world.getTypeKey() == WorldDimension.d ? net.minecraft.world.level.World.e : net.minecraft.world.level.World.g;
        WorldServer worldserver = world.n().a(resourcekey);
        EntityPortalEnterEvent event = new EntityPortalEnterEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), new Location((World)world.getWorld(), (double)pos.u(), (double)pos.v(), (double)pos.w()));
        event.callEvent();
        if (this instanceof EntityPlayer) {
            ((EntityPlayer)this).changeDimension(worldserver, PlayerTeleportEvent.TeleportCause.END_PORTAL);
            return;
        }
        this.teleportTo(worldserver, null);
    }

    protected boolean shouldHardCollide() {
        return false;
    }

    public final boolean hardCollides() {
        return this.hardCollides;
    }

    public Entity(EntityTypes<?> type, net.minecraft.world.level.World world) {
        this.at = c.incrementAndGet();
        this.au = ImmutableList.of();
        this.az = Vec3D.a;
        this.aC = e;
        this.E = Vec3D.a;
        this.R = SHARED_RANDOM;
        this.aF = -this.cP();
        this.U = new Object2DoubleArrayMap(2);
        this.aG = new HashSet<TagKey<FluidType>>();
        this.aR = EntityInLevelCallback.a;
        this.aj = MathHelper.a(this.R);
        this.ak = this.aj.toString();
        this.aW = Sets.newHashSet();
        this.aX = new double[]{0.0, 0.0, 0.0};
        this.as = type;
        this.s = world;
        this.aZ = type.m();
        this.aw = Vec3D.a;
        this.ax = BlockPosition.b;
        this.ay = ChunkCoordIntPair.b;
        this.aS = Vec3D.a;
        this.defaultActivationState = world != null ? ActivationRange.initializeEntityActivationState(this, world.spigotConfig) : false;
        this.Y = new DataWatcher(this);
        this.Y.a(Z, (byte)0);
        this.Y.a(aL, this.bX());
        this.Y.a(aN, false);
        this.Y.a(aM, Optional.empty());
        this.Y.a(aO, false);
        this.Y.a(aP, false);
        this.Y.a(ad, EntityPose.a);
        this.Y.a(aQ, 0);
        this.a_();
        this.ai().registrationLocked = true;
        this.e(0.0, 0.0, 0.0);
        this.ba = this.a(EntityPose.a, this.aZ);
    }

    public boolean a(BlockPosition pos, IBlockData state) {
        VoxelShape voxelshape = state.b((IBlockAccess)this.s, pos, VoxelShapeCollision.a(this));
        VoxelShape voxelshape1 = voxelshape.a((double)pos.u(), (double)pos.v(), (double)pos.w());
        return VoxelShapes.c(voxelshape1, VoxelShapes.a(this.cw()), OperatorBoolean.i);
    }

    public int aa() {
        ScoreboardTeamBase scoreboardteambase = this.bW();
        return scoreboardteambase != null && scoreboardteambase.n().e() != null ? scoreboardteambase.n().e() : 0xFFFFFF;
    }

    public boolean B_() {
        return false;
    }

    public final void ab() {
        if (this.bG()) {
            this.bs();
        }
        if (this.bF()) {
            this.p();
        }
    }

    public void d(double x2, double y2, double z2) {
        this.a_(new Vec3D(x2, y2, z2));
    }

    public void a_(Vec3D pos) {
        this.aS = pos;
    }

    public Vec3D ac() {
        return this.aS;
    }

    public EntityTypes<?> ad() {
        return this.as;
    }

    @Override
    public int ae() {
        return this.at;
    }

    public void e(int id) {
        this.at = id;
    }

    public Set<String> af() {
        return this.aW;
    }

    public boolean a(String tag) {
        return this.aW.size() >= 1024 ? false : this.aW.add(tag);
    }

    public boolean b(String tag) {
        return this.aW.remove(tag);
    }

    public void ag() {
        this.a(RemovalReason.a);
    }

    public final void ah() {
        this.a(RemovalReason.b);
    }

    protected abstract void a_();

    public DataWatcher ai() {
        return this.Y;
    }

    public boolean equals(Object object) {
        return object instanceof Entity ? ((Entity)object).at == this.at : false;
    }

    public int hashCode() {
        return this.at;
    }

    public void a(RemovalReason reason) {
        this.b(reason);
        if (reason == RemovalReason.a) {
            this.a(GameEvent.s);
        }
    }

    public void aj() {
    }

    public void b(EntityPose pose) {
        if (pose == this.ak()) {
            return;
        }
        this.s.getCraftServer().getPluginManager().callEvent((Event)new EntityPoseChangeEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), Pose.values()[pose.ordinal()]));
        this.Y.b(ad, pose);
    }

    public EntityPose ak() {
        return this.Y.a(ad);
    }

    public boolean a(Entity other, double radius) {
        double d1 = other.aw.b - this.aw.b;
        double d2 = other.aw.c - this.aw.c;
        double d3 = other.aw.d - this.aw.d;
        return d1 * d1 + d2 * d2 + d3 * d3 < radius * radius;
    }

    public void a(float yaw, float pitch) {
        if (Float.isNaN(yaw)) {
            yaw = 0.0f;
        }
        if (yaw == Float.POSITIVE_INFINITY || yaw == Float.NEGATIVE_INFINITY) {
            if (this instanceof EntityPlayer) {
                this.s.getCraftServer().getLogger().warning(this.co() + " was caught trying to crash the server with an invalid yaw");
                ((CraftPlayer)this.getBukkitEntity()).kickPlayer("Infinite yaw (Hacking?)");
            }
            yaw = 0.0f;
        }
        if (Float.isNaN(pitch)) {
            pitch = 0.0f;
        }
        if (pitch == Float.POSITIVE_INFINITY || pitch == Float.NEGATIVE_INFINITY) {
            if (this instanceof EntityPlayer) {
                this.s.getCraftServer().getLogger().warning(this.co() + " was caught trying to crash the server with an invalid pitch");
                ((CraftPlayer)this.getBukkitEntity()).kickPlayer("Infinite pitch (Hacking?)");
            }
            pitch = 0.0f;
        }
        this.o(yaw % 360.0f);
        this.p(pitch % 360.0f);
    }

    public final void b(Vec3D pos) {
        this.e(pos.a(), pos.b(), pos.c());
    }

    public void e(double x2, double y2, double z2) {
        this.setPosRaw(x2, y2, z2, true);
    }

    protected AxisAlignedBB al() {
        return this.aZ.a(this.aw);
    }

    protected void am() {
        this.e(this.aw.b, this.aw.c, this.aw.d);
    }

    public void a(double cursorDeltaX, double cursorDeltaY) {
        float f2 = (float)cursorDeltaY * 0.15f;
        float f1 = (float)cursorDeltaX * 0.15f;
        this.p(this.do() + f2);
        this.o(this.dn() + f1);
        this.p(MathHelper.a(this.do(), -90.0f, 90.0f));
        this.x += f2;
        this.w += f1;
        this.x = MathHelper.a(this.x, -90.0f, 90.0f);
        if (this.av != null) {
            this.av.j(this);
        }
    }

    public void k() {
        this.an();
    }

    public void postTick() {
        if (!(this instanceof EntityPlayer) && this.bl()) {
            this.by();
        }
    }

    public void an() {
        this.s.ab().a("entityBaseTick");
        this.be = null;
        if (this.bF() && this.cN().dp()) {
            this.p();
        }
        if (this.r > 0) {
            --this.r;
        }
        this.H = this.I;
        this.x = this.do();
        this.w = this.dn();
        if (this instanceof EntityPlayer) {
            this.by();
        }
        if (this.ba()) {
            this.bb();
        }
        this.am = this.al;
        this.al = false;
        this.aW();
        this.l();
        this.aV();
        if (this.s.x) {
            this.au();
        } else if (this.aF > 0) {
            if (this.aP()) {
                this.g(this.aF - 4);
                if (this.aF < 0) {
                    this.au();
                }
            } else {
                if (this.aF % 20 == 0 && !this.bc()) {
                    this.a(DamageSource.c, 1.0f);
                }
                this.g(this.aF - 1);
            }
            if (this.bZ() > 0 && !this.freezeLocked) {
                this.j(0);
                this.s.a((EntityHuman)null, 1009, this.ax, 1);
            }
        }
        if (this.bc()) {
            this.as();
            this.L *= 0.5f;
        } else {
            this.lastLavaContact = null;
        }
        this.ao();
        if (!this.s.x) {
            this.a_(this.aF > 0);
        }
        this.X = false;
        this.s.ab().c();
    }

    public void a_(boolean onFire) {
        this.b(0, onFire || this.bd);
    }

    public void ao() {
        if (this.de() < (double)(this.s.u_() - 64) || this.s.getWorld().getEnvironment() == World.Environment.NETHER && this.s.paperConfig.doNetherTopVoidDamage() && this.de() >= (double)this.s.paperConfig.netherVoidTopDamageHeight) {
            this.av();
        }
    }

    public void ap() {
        this.aT = this.bz();
    }

    public boolean aq() {
        return this.aT > 0;
    }

    protected void H() {
        if (this.aq()) {
            --this.aT;
        }
    }

    public int ar() {
        return 0;
    }

    public void as() {
        if (!this.aP()) {
            if (this instanceof EntityLiving && this.aF <= 0) {
                CraftBlock damager = this.lastLavaContact == null ? null : CraftBlock.at(this.s, this.lastLavaContact);
                CraftEntity damagee = this.getBukkitEntity();
                EntityCombustByBlockEvent combustEvent = new EntityCombustByBlockEvent((org.bukkit.block.Block)damager, (org.bukkit.entity.Entity)damagee, 15);
                this.s.getCraftServer().getPluginManager().callEvent((Event)combustEvent);
                if (!combustEvent.isCancelled()) {
                    this.setSecondsOnFire(combustEvent.getDuration(), false);
                }
            } else {
                this.setSecondsOnFire(15, false);
            }
            CraftBlock craftBlock = CraftEventFactory.blockDamage = this.lastLavaContact == null ? null : CraftBlock.at(this.s, this.lastLavaContact);
            if (this.a(DamageSource.d, 4.0f)) {
                this.a(SoundEffects.gI, 0.4f, 2.0f + this.R.nextFloat() * 0.4f);
            }
            CraftEventFactory.blockDamage = null;
        }
    }

    public void f(int seconds) {
        this.setSecondsOnFire(seconds, true);
    }

    public void setSecondsOnFire(int i2, boolean callEvent) {
        if (callEvent) {
            EntityCombustEvent event = new EntityCombustEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), i2);
            this.s.getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            i2 = event.getDuration();
        }
        int j2 = i2 * 20;
        if (this instanceof EntityLiving) {
            j2 = EnchantmentProtection.a((EntityLiving)this, j2);
        }
        if (this.aF < j2) {
            this.g(j2);
        }
    }

    public void g(int fireTicks) {
        this.aF = fireTicks;
    }

    public int at() {
        return this.aF;
    }

    public void au() {
        this.g(0);
    }

    protected void av() {
        this.ah();
    }

    public boolean f(double offsetX, double offsetY, double offsetZ) {
        return this.b(this.cw().d(offsetX, offsetY, offsetZ));
    }

    private boolean b(AxisAlignedBB box) {
        return this.s.a(this, box) && !this.s.d(box);
    }

    public void c(boolean onGround) {
        this.y = onGround;
    }

    public boolean aw() {
        return this.y;
    }

    public final Vec3D getMoveVector() {
        return this.moveVector;
    }

    public final double getMoveStartX() {
        return this.moveStartX;
    }

    public final double getMoveStartY() {
        return this.moveStartY;
    }

    public final double getMoveStartZ() {
        return this.moveStartZ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(EnumMoveType movementType, Vec3D movement) {
        TickThread.ensureTickThread("Cannot move an entity off-main");
        Object object = this.posLock;
        synchronized (object) {
            this.moveStartX = this.dc();
            this.moveStartY = this.de();
            this.moveStartZ = this.di();
            this.moveVector = movement;
        }
        try {
            if (this.Q) {
                this.e(this.dc() + movement.b, this.de() + movement.c, this.di() + movement.d);
            } else {
                this.an = this.bE();
                if (movementType == EnumMoveType.c) {
                    this.activatedTick = Math.max(this.activatedTick, (long)(MinecraftServer.currentTick + 20));
                    this.activatedImmunityTick = Math.max(this.activatedImmunityTick, (long)(MinecraftServer.currentTick + 20));
                    if ((movement = this.d(movement)).equals(Vec3D.a)) {
                        return;
                    }
                }
                this.s.ab().a("move");
                if (this.E.g() > 1.0E-7) {
                    movement = movement.h(this.E);
                    this.E = Vec3D.a;
                    this.g(Vec3D.a);
                }
                if (this.isTemporarilyActive && !(this instanceof EntityItem) && !(this instanceof EntityMinecartAbstract) && movement == this.da() && movementType == EnumMoveType.a) {
                    this.g(Vec3D.a);
                    this.s.ab().c();
                    return;
                }
                Vec3D vec3d1 = this.h(movement = this.a(movement, movementType));
                double d0 = vec3d1.g();
                if (d0 > 1.0E-7) {
                    MovingObjectPositionBlock movingobjectpositionblock;
                    if (this.L != 0.0f && d0 >= 1.0 && (movingobjectpositionblock = this.s.a(new RayTrace(this.cV(), this.cV().e(vec3d1), RayTrace.BlockCollisionOption.d, RayTrace.FluidCollisionOption.d, this))).c() != MovingObjectPosition.EnumMovingObjectType.a) {
                        this.m();
                    }
                    this.e(this.dc() + vec3d1.b, this.de() + vec3d1.c, this.di() + vec3d1.d);
                }
                this.s.ab().c();
                this.s.ab().a("rest");
                boolean flag = !MathHelper.b(movement.b, vec3d1.b);
                boolean flag1 = !MathHelper.b(movement.d, vec3d1.d);
                this.z = flag || flag1;
                this.A = movement.c != vec3d1.c;
                this.B = this.A && movement.c < 0.0;
                this.C = this.z ? this.c(vec3d1) : false;
                this.y = this.A && movement.c < 0.0;
                BlockPosition blockposition = this.aA();
                IBlockData iblockdata = this.s.a_(blockposition);
                this.a(vec3d1.c, this.y, iblockdata, blockposition);
                if (this.dp()) {
                    this.s.ab().c();
                } else {
                    MovementEmission entity_movementemission;
                    if (this.z) {
                        Vec3D vec3d2 = this.da();
                        this.n(flag ? 0.0 : vec3d2.b, vec3d2.c, flag1 ? 0.0 : vec3d2.d);
                    }
                    Block block = iblockdata.b();
                    if (movement.c != vec3d1.c) {
                        block.a(this.s, this);
                    }
                    if (this.z && this.getBukkitEntity() instanceof Vehicle) {
                        Vehicle vehicle = (Vehicle)this.getBukkitEntity();
                        org.bukkit.block.Block bl = this.s.getWorld().getBlockAt(MathHelper.b(this.dc()), MathHelper.b(this.de()), MathHelper.b(this.di()));
                        if (movement.b > vec3d1.b) {
                            bl = bl.getRelative(BlockFace.EAST);
                        } else if (movement.b < vec3d1.b) {
                            bl = bl.getRelative(BlockFace.WEST);
                        } else if (movement.d > vec3d1.d) {
                            bl = bl.getRelative(BlockFace.SOUTH);
                        } else if (movement.d < vec3d1.d) {
                            bl = bl.getRelative(BlockFace.NORTH);
                        }
                        if (!bl.getType().isAir()) {
                            VehicleBlockCollisionEvent event = new VehicleBlockCollisionEvent(vehicle, bl);
                            this.s.getCraftServer().getPluginManager().callEvent((Event)event);
                        }
                    }
                    if (this.y && !this.bJ()) {
                        block.a(this.s, blockposition, iblockdata, this);
                    }
                    if ((entity_movementemission = this.aN()).a() && !this.bF()) {
                        double d1 = vec3d1.b;
                        double d2 = vec3d1.c;
                        double d3 = vec3d1.d;
                        this.K += (float)(vec3d1.f() * 0.6);
                        if (!iblockdata.a(TagsBlock.aC) && !iblockdata.a(Blocks.oO)) {
                            d2 = 0.0;
                        }
                        this.I += (float)vec3d1.h() * 0.6f;
                        this.J += (float)Math.sqrt(d1 * d1 + d2 * d2 + d3 * d3) * 0.6f;
                        if (this.J > this.aE && !iblockdata.g()) {
                            this.aE = this.aE();
                            if (this.aQ()) {
                                if (entity_movementemission.c()) {
                                    Entity entity = this.bG() && this.cE() != null ? this.cE() : this;
                                    float f2 = entity == this ? 0.35f : 0.4f;
                                    Vec3D vec3d3 = entity.da();
                                    float f1 = Math.min(1.0f, (float)Math.sqrt(vec3d3.b * vec3d3.b * (double)0.2f + vec3d3.c * vec3d3.c + vec3d3.d * vec3d3.d * (double)0.2f) * f2);
                                    this.d(f1);
                                }
                                if (entity_movementemission.b()) {
                                    this.a(GameEvent.R);
                                }
                            } else {
                                if (entity_movementemission.c()) {
                                    this.b(iblockdata);
                                    this.b(blockposition, iblockdata);
                                }
                                if (entity_movementemission.b() && !iblockdata.a(TagsBlock.aZ)) {
                                    this.a(GameEvent.Q);
                                }
                            }
                        } else if (iblockdata.g()) {
                            this.az();
                        }
                    }
                    this.ax();
                    float f2 = this.aC();
                    this.g(this.da().d(f2, 1.0, f2));
                    boolean noneMatch = true;
                    AxisAlignedBB fireSearchBox = this.cw().h(1.0E-6);
                    int minX = MathHelper.b(fireSearchBox.a);
                    int minY = MathHelper.b(fireSearchBox.b);
                    int minZ = MathHelper.b(fireSearchBox.c);
                    int maxX = MathHelper.b(fireSearchBox.d);
                    int maxY = MathHelper.b(fireSearchBox.e);
                    int maxZ = MathHelper.b(fireSearchBox.f);
                    block20: for (int fz = minZ; fz <= maxZ; ++fz) {
                        for (int fx = minX; fx <= maxX; ++fx) {
                            for (int fy = minY; fy <= maxY; ++fy) {
                                IBlockData type;
                                Chunk chunk = (Chunk)this.s.getChunkIfLoadedImmediately(fx >> 4, fz >> 4);
                                if (chunk == null) {
                                    noneMatch = true;
                                    break block20;
                                }
                                if (!noneMatch || !(type = chunk.getBlockStateFinal(fx, fy, fz)).a(TagsBlock.aw) && !type.a(Blocks.B)) continue;
                                noneMatch = false;
                            }
                        }
                    }
                    if (noneMatch) {
                        if (this.aF <= 0) {
                            this.g(-this.cP());
                        }
                        if (this.an && (this.al || this.aS())) {
                            this.ay();
                        }
                    }
                    if (this.bE() && (this.al || this.aS())) {
                        this.g(-this.cP());
                    }
                    this.s.ab().c();
                }
            }
        }
        finally {
            object = this.posLock;
            synchronized (object) {
                this.moveVector = null;
            }
        }
    }

    protected boolean c(Vec3D adjustedMovement) {
        return false;
    }

    protected void ax() {
        try {
            this.aI();
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.a(throwable, "Checking entity block collision");
            CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Entity being checked for collision");
            this.a(crashreportsystemdetails);
            throw new ReportedException(crashreport);
        }
    }

    protected void ay() {
        this.a(SoundEffects.gN, 0.7f, 1.6f + (this.R.nextFloat() - this.R.nextFloat()) * 0.4f);
    }

    protected void az() {
        if (this.aK()) {
            this.aJ();
            if (this.aN().b()) {
                this.a(GameEvent.y);
            }
        }
    }

    public BlockPosition aA() {
        BlockPosition blockposition1;
        IBlockData iblockdata;
        int k2;
        int j2;
        int i2 = MathHelper.b(this.aw.b);
        BlockPosition blockposition = new BlockPosition(i2, j2 = MathHelper.b(this.aw.c - (double)0.2f), k2 = MathHelper.b(this.aw.d));
        if (this.s.a_(blockposition).g() && ((iblockdata = this.s.a_(blockposition1 = blockposition.c())).a(TagsBlock.L) || iblockdata.a(TagsBlock.E) || iblockdata.b() instanceof BlockFenceGate)) {
            return blockposition1;
        }
        return blockposition;
    }

    protected float aB() {
        float f2 = this.s.a_(this.cW()).b().k();
        float f1 = this.s.a_(this.aD()).b().k();
        return (double)f2 == 1.0 ? f1 : f2;
    }

    protected float aC() {
        IBlockData iblockdata = this.s.a_(this.cW());
        float f2 = iblockdata.b().j();
        return !iblockdata.a(Blocks.A) && !iblockdata.a(Blocks.lq) ? ((double)f2 == 1.0 ? this.s.a_(this.aD()).b().j() : f2) : f2;
    }

    protected BlockPosition aD() {
        return new BlockPosition(this.aw.b, this.cw().b - 0.5000001, this.aw.d);
    }

    protected Vec3D a(Vec3D movement, EnumMoveType type) {
        return movement;
    }

    protected Vec3D d(Vec3D movement) {
        if (movement.g() <= 1.0E-7) {
            return movement;
        }
        long i2 = this.s.U();
        if (i2 != this.aY) {
            Arrays.fill(this.aX, 0.0);
            this.aY = i2;
        }
        if (movement.b != 0.0) {
            double d0 = this.a(EnumDirection.EnumAxis.a, movement.b);
            return Math.abs(d0) <= (double)1.0E-5f ? Vec3D.a : new Vec3D(d0, 0.0, 0.0);
        }
        if (movement.c != 0.0) {
            double d0 = this.a(EnumDirection.EnumAxis.b, movement.c);
            return Math.abs(d0) <= (double)1.0E-5f ? Vec3D.a : new Vec3D(0.0, d0, 0.0);
        }
        if (movement.d != 0.0) {
            double d0 = this.a(EnumDirection.EnumAxis.c, movement.d);
            return Math.abs(d0) <= (double)1.0E-5f ? Vec3D.a : new Vec3D(0.0, 0.0, d0);
        }
        return Vec3D.a;
    }

    private double a(EnumDirection.EnumAxis axis, double offsetFactor) {
        int i2 = axis.ordinal();
        double d1 = MathHelper.a(offsetFactor + this.aX[i2], -0.51, 0.51);
        offsetFactor = d1 - this.aX[i2];
        this.aX[i2] = d1;
        return offsetFactor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vec3D h(Vec3D movement) {
        if (movement.b == 0.0 && movement.c == 0.0 && movement.d == 0.0) {
            return movement;
        }
        net.minecraft.world.level.World world = this.s;
        AxisAlignedBB currBoundingBox = this.cw();
        if (CollisionUtil.isEmpty(currBoundingBox)) {
            return movement;
        }
        UnsafeList<AxisAlignedBB> potentialCollisions = CachedLists.getTempCollisionList();
        try {
            double stepHeight = this.P;
            AxisAlignedBB collisionBox = movement.b == 0.0 && movement.d == 0.0 && movement.c != 0.0 ? (movement.c > 0.0 ? CollisionUtil.cutUpwards(currBoundingBox, movement.c) : CollisionUtil.cutDownwards(currBoundingBox, movement.c)) : (stepHeight > 0.0 && (this.y || movement.c < 0.0) && (movement.b != 0.0 || movement.d != 0.0) ? (movement.c <= 0.0 ? CollisionUtil.expandUpwards(currBoundingBox.b(movement.b, movement.c, movement.d), stepHeight) : currBoundingBox.b(movement.b, Math.max(stepHeight, movement.c), movement.d)) : currBoundingBox.b(movement.b, movement.c, movement.d));
            CollisionUtil.getCollisions(world, this, collisionBox, potentialCollisions, false, true, false, false, null, null);
            if (CollisionUtil.isCollidingWithBorderEdge(world.p_(), collisionBox)) {
                CollisionUtil.addBoxesToIfIntersects(world.p_().c(), collisionBox, potentialCollisions);
            }
            Vec3D limitedMoveVector = CollisionUtil.performCollisions(movement, currBoundingBox, potentialCollisions);
            if (stepHeight > 0.0 && (this.y || limitedMoveVector.c != movement.c && movement.c < 0.0) && (limitedMoveVector.b != movement.b || limitedMoveVector.d != movement.d)) {
                Vec3D vec3D;
                Vec3D vec3d4;
                Vec3D vec3d2 = CollisionUtil.performCollisions(new Vec3D(movement.b, stepHeight, movement.d), currBoundingBox, potentialCollisions);
                Vec3D vec3d3 = CollisionUtil.performCollisions(new Vec3D(0.0, stepHeight, 0.0), currBoundingBox.b(movement.b, 0.0, movement.d), potentialCollisions);
                if (vec3d3.c < stepHeight && (vec3d4 = CollisionUtil.performCollisions(new Vec3D(movement.b, 0.0, movement.d), currBoundingBox.c(vec3d3), potentialCollisions).e(vec3d3)).i() > vec3d2.i()) {
                    vec3d2 = vec3d4;
                }
                if (vec3d2.i() > limitedMoveVector.i()) {
                    vec3D = vec3d2.e(CollisionUtil.performCollisions(new Vec3D(0.0, -vec3d2.c + movement.c, 0.0), currBoundingBox.c(vec3d2), potentialCollisions));
                    return vec3D;
                }
                vec3D = limitedMoveVector;
                return vec3D;
            }
            Vec3D vec3D = limitedMoveVector;
            return vec3D;
        }
        finally {
            CachedLists.returnTempCollisionList(potentialCollisions);
        }
    }

    public static Vec3D a(@javax.annotation.Nullable Entity entity, Vec3D movement, AxisAlignedBB entityBoundingBox, net.minecraft.world.level.World world, List<VoxelShape> collisions) {
        boolean flag;
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)(collisions.size() + 1));
        if (!collisions.isEmpty()) {
            builder.addAll(collisions);
        }
        WorldBorder worldborder = world.p_();
        boolean bl = flag = entity != null && worldborder.a(entity, entityBoundingBox.b(movement));
        if (flag) {
            builder.add((Object)worldborder.c());
        }
        builder.addAll(world.d(entity, entityBoundingBox.b(movement)));
        return Entity.a(movement, entityBoundingBox, (List<VoxelShape>)builder.build());
    }

    private static Vec3D a(Vec3D movement, AxisAlignedBB entityBoundingBox, List<VoxelShape> collisions) {
        boolean flag;
        if (collisions.isEmpty()) {
            return movement;
        }
        double d0 = movement.b;
        double d1 = movement.c;
        double d2 = movement.d;
        if (d1 != 0.0 && (d1 = VoxelShapes.a(EnumDirection.EnumAxis.b, entityBoundingBox, collisions, d1)) != 0.0) {
            entityBoundingBox = entityBoundingBox.d(0.0, d1, 0.0);
        }
        boolean bl = flag = Math.abs(d0) < Math.abs(d2);
        if (flag && d2 != 0.0 && (d2 = VoxelShapes.a(EnumDirection.EnumAxis.c, entityBoundingBox, collisions, d2)) != 0.0) {
            entityBoundingBox = entityBoundingBox.d(0.0, 0.0, d2);
        }
        if (d0 != 0.0) {
            d0 = VoxelShapes.a(EnumDirection.EnumAxis.a, entityBoundingBox, collisions, d0);
            if (!flag && d0 != 0.0) {
                entityBoundingBox = entityBoundingBox.d(d0, 0.0, 0.0);
            }
        }
        if (!flag && d2 != 0.0) {
            d2 = VoxelShapes.a(EnumDirection.EnumAxis.c, entityBoundingBox, collisions, d2);
        }
        return new Vec3D(d0, d1, d2);
    }

    protected float aE() {
        return (int)this.J + 1;
    }

    protected SoundEffect aF() {
        return SoundEffects.gR;
    }

    protected SoundEffect aG() {
        return SoundEffects.gQ;
    }

    protected SoundEffect aH() {
        return SoundEffects.gQ;
    }

    protected void aI() {
        AxisAlignedBB axisalignedbb = this.cw();
        BlockPosition blockposition = new BlockPosition(axisalignedbb.a + 0.001, axisalignedbb.b + 0.001, axisalignedbb.c + 0.001);
        BlockPosition blockposition1 = new BlockPosition(axisalignedbb.d - 0.001, axisalignedbb.e - 0.001, axisalignedbb.f - 0.001);
        if (this.s.a(blockposition, blockposition1)) {
            BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
            for (int i2 = blockposition.u(); i2 <= blockposition1.u(); ++i2) {
                for (int j2 = blockposition.v(); j2 <= blockposition1.v(); ++j2) {
                    for (int k2 = blockposition.w(); k2 <= blockposition1.w(); ++k2) {
                        blockposition_mutableblockposition.d(i2, j2, k2);
                        IBlockData iblockdata = this.s.a_(blockposition_mutableblockposition);
                        try {
                            iblockdata.a(this.s, (BlockPosition)blockposition_mutableblockposition, this);
                            this.a(iblockdata);
                            continue;
                        }
                        catch (Throwable throwable) {
                            CrashReport crashreport = CrashReport.a(throwable, "Colliding entity with block");
                            CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Block being collided with");
                            CrashReportSystemDetails.a(crashreportsystemdetails, this.s, blockposition_mutableblockposition, iblockdata);
                            throw new ReportedException(crashreport);
                        }
                    }
                }
            }
        }
    }

    protected void a(IBlockData state) {
    }

    public void a(GameEvent event, @javax.annotation.Nullable Entity entity, BlockPosition pos) {
        this.s.a(entity, event, pos);
    }

    public void a(GameEvent event, @javax.annotation.Nullable Entity entity) {
        this.a(event, entity, this.ax);
    }

    public void a(GameEvent event, BlockPosition pos) {
        this.a(event, this, pos);
    }

    public void a(GameEvent event) {
        this.a(event, this.ax);
    }

    protected void b(BlockPosition pos, IBlockData state) {
        if (!state.c().a()) {
            IBlockData iblockdata1 = this.s.a_(pos.b());
            SoundEffectType soundeffecttype = iblockdata1.a(TagsBlock.aY) ? iblockdata1.q() : state.q();
            this.a(soundeffecttype.d(), soundeffecttype.a() * 0.15f, soundeffecttype.b());
        }
    }

    private void b(IBlockData state) {
        if (state.a(TagsBlock.aX) && this.S >= this.bc + 20) {
            this.bb *= (float)Math.pow(0.997, this.S - this.bc);
            this.bb = Math.min(1.0f, this.bb + 0.07f);
            float f2 = 0.5f + this.bb * this.R.nextFloat() * 1.2f;
            float f1 = 0.1f + this.bb * 1.2f;
            this.a(SoundEffects.x, f1, f2);
            this.bc = this.S;
        }
    }

    protected void d(float volume) {
        this.a(this.aF(), volume, 1.0f + (this.R.nextFloat() - this.R.nextFloat()) * 0.4f);
    }

    protected void aJ() {
    }

    protected boolean aK() {
        return false;
    }

    public void a(SoundEffect sound, float volume, float pitch) {
        if (!this.aL()) {
            this.s.a((EntityHuman)null, this.dc(), this.de(), this.di(), sound, this.cO(), volume, pitch);
        }
    }

    public boolean aL() {
        return this.Y.a(aO);
    }

    public void d(boolean silent) {
        this.Y.b(aO, silent);
    }

    public boolean aM() {
        return this.Y.a(aP);
    }

    public void e(boolean noGravity) {
        this.Y.b(aP, noGravity);
    }

    protected MovementEmission aN() {
        return MovementEmission.d;
    }

    public boolean aO() {
        return false;
    }

    protected void a(double heightDifference, boolean onGround, IBlockData landedState, BlockPosition landedPosition) {
        if (onGround) {
            if (this.L > 0.0f) {
                landedState.b().a(this.s, landedState, landedPosition, this, this.L);
                if (!landedState.a(TagsBlock.aZ)) {
                    this.a(GameEvent.B);
                }
            }
            this.m();
        } else if (heightDifference < 0.0) {
            this.L -= (float)heightDifference;
        }
    }

    public boolean aP() {
        return this.ad().d();
    }

    public boolean a(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        if (this.bG()) {
            for (Entity entity : this.cF()) {
                entity.a(fallDistance, damageMultiplier, damageSource);
            }
        }
        return false;
    }

    public boolean aQ() {
        return this.T;
    }

    public boolean i() {
        BlockPosition blockposition = this.cW();
        return this.s.s(blockposition) || this.s.s(new BlockPosition((double)blockposition.u(), this.cw().e, (double)blockposition.w()));
    }

    public boolean j() {
        return this.s.a_(this.cW()).a(Blocks.lq);
    }

    public boolean aR() {
        return this.aQ() || this.i();
    }

    public boolean aS() {
        return this.aQ() || this.i() || this.j();
    }

    public boolean aT() {
        return this.aQ() || this.j();
    }

    public boolean aU() {
        return this.V && this.aQ();
    }

    public void aV() {
        if (this.bP()) {
            this.h(this.bO() && this.aQ() && !this.bF());
        } else {
            this.h(this.bO() && this.aU() && !this.bF() && this.s.b_(this.ax).a(TagsFluid.a));
        }
    }

    protected boolean aW() {
        this.U.clear();
        this.aX();
        double d0 = this.s.q_().c() ? 0.007 : 0.0023333333333333335;
        boolean flag = this.a(TagsFluid.b, d0);
        return this.aQ() || flag;
    }

    void aX() {
        if (this.cN() instanceof EntityBoat) {
            this.T = false;
        } else if (this.a(TagsFluid.a, 0.014)) {
            if (!this.T && !this.X) {
                this.aY();
            }
            this.m();
            this.T = true;
            this.au();
        } else {
            this.T = false;
        }
    }

    private void l() {
        EntityBoat entityboat;
        this.V = this.a(TagsFluid.a);
        this.aG.clear();
        double d0 = this.dg() - 0.1111111119389534;
        Entity entity = this.cN();
        if (entity instanceof EntityBoat && !(entityboat = (EntityBoat)entity).aU() && entityboat.cw().e >= d0 && entityboat.cw().b <= d0) {
            return;
        }
        BlockPosition blockposition = new BlockPosition(this.dc(), d0, this.di());
        Fluid fluid = this.s.b_(blockposition);
        double d1 = (float)blockposition.v() + fluid.a((IBlockAccess)this.s, blockposition);
        if (d1 > d0) {
            Stream<TagKey<FluidType>> stream = fluid.k();
            Set<TagKey<FluidType>> set = this.aG;
            Objects.requireNonNull(this.aG);
            stream.forEach(set::add);
        }
    }

    protected void aY() {
        double d1;
        double d0;
        Entity entity = this.bG() && this.cE() != null ? this.cE() : this;
        float f2 = entity == this ? 0.2f : 0.9f;
        Vec3D vec3d = entity.da();
        float f1 = Math.min(1.0f, (float)Math.sqrt(vec3d.b * vec3d.b * (double)0.2f + vec3d.c * vec3d.c + vec3d.d * vec3d.d * (double)0.2f) * f2);
        if (f1 < 0.25f) {
            this.a(this.aG(), f1, 1.0f + (this.R.nextFloat() - this.R.nextFloat()) * 0.4f);
        } else {
            this.a(this.aH(), f1, 1.0f + (this.R.nextFloat() - this.R.nextFloat()) * 0.4f);
        }
        float f22 = MathHelper.b(this.de());
        int i2 = 0;
        while ((float)i2 < 1.0f + this.aZ.a * 20.0f) {
            d0 = (this.R.nextDouble() * 2.0 - 1.0) * (double)this.aZ.a;
            d1 = (this.R.nextDouble() * 2.0 - 1.0) * (double)this.aZ.a;
            this.s.a(Particles.e, this.dc() + d0, (double)(f22 + 1.0f), this.di() + d1, vec3d.b, vec3d.c - this.R.nextDouble() * (double)0.2f, vec3d.d);
            ++i2;
        }
        i2 = 0;
        while ((float)i2 < 1.0f + this.aZ.a * 20.0f) {
            d0 = (this.R.nextDouble() * 2.0 - 1.0) * (double)this.aZ.a;
            d1 = (this.R.nextDouble() * 2.0 - 1.0) * (double)this.aZ.a;
            this.s.a(Particles.ab, this.dc() + d0, (double)(f22 + 1.0f), this.di() + d1, vec3d.b, vec3d.c, vec3d.d);
            ++i2;
        }
        this.a(GameEvent.P);
    }

    protected IBlockData aZ() {
        return this.s.a_(this.aA());
    }

    public boolean ba() {
        return this.bO() && !this.aQ() && !this.B_() && !this.bN() && !this.bc() && this.bl();
    }

    protected void bb() {
        int k2;
        int j2;
        int i2 = MathHelper.b(this.dc());
        BlockPosition blockposition = new BlockPosition(i2, j2 = MathHelper.b(this.de() - (double)0.2f), k2 = MathHelper.b(this.di()));
        IBlockData iblockdata = this.s.a_(blockposition);
        if (iblockdata.h() != EnumRenderType.a) {
            Vec3D vec3d = this.da();
            this.s.a(new ParticleParamBlock(Particles.c, iblockdata), this.dc() + (this.R.nextDouble() - 0.5) * (double)this.aZ.a, this.de() + 0.1, this.di() + (this.R.nextDouble() - 0.5) * (double)this.aZ.a, vec3d.b * -4.0, 1.5, vec3d.d * -4.0);
        }
    }

    public boolean a(TagKey<FluidType> fluidTag) {
        return this.aG.contains(fluidTag);
    }

    public boolean bc() {
        return !this.X && this.U.getDouble(TagsFluid.b) > 0.0;
    }

    public void a(float speed, Vec3D movementInput) {
        Vec3D vec3d1 = Entity.a(movementInput, speed, this.dn());
        this.g(this.da().e(vec3d1));
    }

    private static Vec3D a(Vec3D movementInput, float speed, float yaw) {
        double d0 = movementInput.g();
        if (d0 < 1.0E-7) {
            return Vec3D.a;
        }
        Vec3D vec3d1 = (d0 > 1.0 ? movementInput.d() : movementInput).a((double)speed);
        float f2 = MathHelper.a(yaw * ((float)Math.PI / 180));
        float f3 = MathHelper.b(yaw * ((float)Math.PI / 180));
        return new Vec3D(vec3d1.b * (double)f3 - vec3d1.d * (double)f2, vec3d1.c, vec3d1.d * (double)f3 + vec3d1.b * (double)f2);
    }

    public float bd() {
        return this.s.f(this.db(), this.dh()) ? this.s.y(new BlockPosition(this.dc(), this.dg(), this.di())) : 0.0f;
    }

    public void a(double x2, double y2, double z2, float yaw, float pitch) {
        this.g(x2, y2, z2);
        this.o(yaw % 360.0f);
        this.p(MathHelper.a(pitch, -90.0f, 90.0f) % 360.0f);
        this.w = this.dn();
        this.x = this.do();
        this.l(yaw);
    }

    public void g(double x2, double y2, double z2) {
        double d3 = MathHelper.a(x2, -3.0E7, 3.0E7);
        double d4 = MathHelper.a(z2, -3.0E7, 3.0E7);
        this.t = d3;
        this.u = y2;
        this.v = d4;
        this.e(d3, y2, d4);
        if (this.valid) {
            this.s.d((int)Math.floor(this.dc()) >> 4, (int)Math.floor(this.di()) >> 4);
        }
    }

    public void e(Vec3D pos) {
        this.c(pos.b, pos.c, pos.d);
    }

    public void c(double x2, double y2, double z2) {
        this.b(x2, y2, z2, this.dn(), this.do());
    }

    public void a(BlockPosition pos, float yaw, float pitch) {
        this.b((double)pos.u() + 0.5, pos.v(), (double)pos.w() + 0.5, yaw, pitch);
    }

    public void b(double x2, double y2, double z2, float yaw, float pitch) {
        if (!this.preserveMotion) {
            this.az = Vec3D.a;
        } else {
            this.preserveMotion = false;
        }
        this.o(x2, y2, z2);
        this.o(yaw);
        this.p(pitch);
        this.be();
        this.am();
        this.l(yaw);
    }

    public final void be() {
        double d0 = this.dc();
        double d1 = this.de();
        double d2 = this.di();
        this.t = d0;
        this.u = d1;
        this.v = d2;
        this.M = d0;
        this.N = d1;
        this.O = d2;
        this.w = this.dn();
        this.x = this.do();
    }

    public float e(Entity entity) {
        float f2 = (float)(this.dc() - entity.dc());
        float f1 = (float)(this.de() - entity.de());
        float f22 = (float)(this.di() - entity.di());
        return MathHelper.c(f2 * f2 + f1 * f1 + f22 * f22);
    }

    public double h(double x2, double y2, double z2) {
        double d3 = this.dc() - x2;
        double d4 = this.de() - y2;
        double d5 = this.di() - z2;
        return d3 * d3 + d4 * d4 + d5 * d5;
    }

    public double f(Entity entity) {
        return this.f(entity.cV());
    }

    public double f(Vec3D vector) {
        double d0 = this.dc() - vector.b;
        double d1 = this.de() - vector.c;
        double d2 = this.di() - vector.d;
        return d0 * d0 + d1 * d1 + d2 * d2;
    }

    public void b(EntityHuman player) {
    }

    public void g(Entity entity) {
        if (!(this.v(entity) || entity.Q || this.Q)) {
            double d1;
            if (this.s.paperConfig.onlyPlayersCollide && !(entity instanceof EntityPlayer) && !(this instanceof EntityPlayer)) {
                return;
            }
            double d0 = entity.dc() - this.dc();
            double d2 = MathHelper.a(d0, d1 = entity.di() - this.di());
            if (d2 >= (double)0.01f) {
                d2 = Math.sqrt(d2);
                d0 /= d2;
                d1 /= d2;
                double d3 = 1.0 / d2;
                if (d3 > 1.0) {
                    d3 = 1.0;
                }
                d0 *= d3;
                d1 *= d3;
                d0 *= (double)0.05f;
                d1 *= (double)0.05f;
                if (!this.bG()) {
                    this.i(-d0, 0.0, -d1);
                }
                if (!entity.bG()) {
                    entity.i(d0, 0.0, d1);
                }
            }
        }
    }

    public void i(double deltaX, double deltaY, double deltaZ) {
        this.g(this.da().b(deltaX, deltaY, deltaZ));
        this.af = true;
    }

    protected void bf() {
        this.D = true;
    }

    public boolean a(DamageSource source, float amount) {
        if (this.b(source)) {
            return false;
        }
        this.bf();
        return false;
    }

    public final Vec3D e(float tickDelta) {
        return this.b(this.f(tickDelta), this.g(tickDelta));
    }

    public float f(float tickDelta) {
        return tickDelta == 1.0f ? this.do() : MathHelper.i(tickDelta, this.x, this.do());
    }

    public float g(float tickDelta) {
        return tickDelta == 1.0f ? this.dn() : MathHelper.i(tickDelta, this.w, this.dn());
    }

    protected final Vec3D b(float pitch, float yaw) {
        float f2 = pitch * ((float)Math.PI / 180);
        float f3 = -yaw * ((float)Math.PI / 180);
        float f4 = MathHelper.b(f3);
        float f5 = MathHelper.a(f3);
        float f6 = MathHelper.b(f2);
        float f7 = MathHelper.a(f2);
        return new Vec3D(f5 * f6, -f7, f4 * f6);
    }

    public final Vec3D h(float tickDelta) {
        return this.c(this.f(tickDelta), this.g(tickDelta));
    }

    protected final Vec3D c(float pitch, float yaw) {
        return this.b(pitch - 90.0f, yaw);
    }

    public final Vec3D bg() {
        return new Vec3D(this.dc(), this.dg(), this.di());
    }

    public final Vec3D i(float tickDelta) {
        double d0 = MathHelper.d((double)tickDelta, this.t, this.dc());
        double d1 = MathHelper.d((double)tickDelta, this.u, this.de()) + (double)this.cy();
        double d2 = MathHelper.d((double)tickDelta, this.v, this.di());
        return new Vec3D(d0, d1, d2);
    }

    public Vec3D j(float tickDelta) {
        return this.i(tickDelta);
    }

    public final Vec3D k(float delta) {
        double d0 = MathHelper.d((double)delta, this.t, this.dc());
        double d1 = MathHelper.d((double)delta, this.u, this.de());
        double d2 = MathHelper.d((double)delta, this.v, this.di());
        return new Vec3D(d0, d1, d2);
    }

    public MovingObjectPosition a(double maxDistance, float tickDelta, boolean includeFluids) {
        Vec3D vec3d = this.i(tickDelta);
        Vec3D vec3d1 = this.e(tickDelta);
        Vec3D vec3d2 = vec3d.b(vec3d1.b * maxDistance, vec3d1.c * maxDistance, vec3d1.d * maxDistance);
        return this.s.a(new RayTrace(vec3d, vec3d2, RayTrace.BlockCollisionOption.b, includeFluids ? RayTrace.FluidCollisionOption.c : RayTrace.FluidCollisionOption.a, this));
    }

    public boolean bh() {
        return false;
    }

    public boolean bi() {
        return this.isCollidable(false);
    }

    public boolean isCollidable(boolean ignoreClimbing) {
        return false;
    }

    public boolean canCollideWithBukkit(Entity entity) {
        return this.bi();
    }

    public void a(Entity entityKilled, int score, DamageSource damageSource) {
        if (entityKilled instanceof EntityPlayer) {
            CriterionTriggers.c.a((EntityPlayer)entityKilled, this, damageSource);
        }
    }

    public boolean j(double cameraX, double cameraY, double cameraZ) {
        double d3 = this.dc() - cameraX;
        double d4 = this.de() - cameraY;
        double d5 = this.di() - cameraZ;
        double d6 = d3 * d3 + d4 * d4 + d5 * d5;
        return this.a(d6);
    }

    public boolean a(double distance) {
        double d1 = this.cw().a();
        if (Double.isNaN(d1)) {
            d1 = 1.0;
        }
        return distance < (d1 *= 64.0 * ar) * d1;
    }

    public boolean d(NBTTagCompound nbt) {
        if (this.aD != null && !this.aD.b()) {
            return false;
        }
        String s2 = this.bk();
        if (!this.persist || s2 == null) {
            return false;
        }
        nbt.a(g, s2);
        this.f(nbt);
        return true;
    }

    public boolean serializeEntity(NBTTagCompound compound) {
        ArrayList<Entity> pass = new ArrayList<Entity>(this.cF());
        this.au = ImmutableList.of();
        boolean result = this.e(compound);
        this.au = ImmutableList.copyOf(pass);
        return result;
    }

    public boolean e(NBTTagCompound nbt) {
        return this.bF() ? false : this.d(nbt);
    }

    public NBTTagCompound f(NBTTagCompound nbt) {
        try {
            NBTTagList nbttaglist;
            int i2;
            if (this.av != null) {
                nbt.a("Pos", this.a(new double[]{this.av.dc(), this.de(), this.av.di()}));
            } else {
                nbt.a("Pos", this.a(new double[]{this.dc(), this.de(), this.di()}));
            }
            Vec3D vec3d = this.da();
            nbt.a("Motion", this.a(new double[]{vec3d.b, vec3d.c, vec3d.d}));
            if (Float.isNaN(this.aA)) {
                this.aA = 0.0f;
            }
            if (Float.isNaN(this.aB)) {
                this.aB = 0.0f;
            }
            nbt.a("Rotation", this.a(new float[]{this.dn(), this.do()}));
            nbt.a("FallDistance", this.L);
            nbt.a("Fire", (short)this.aF);
            nbt.a("Air", (short)this.bY());
            nbt.a("OnGround", this.y);
            nbt.a("Invulnerable", this.aU);
            nbt.a("PortalCooldown", this.aT);
            nbt.a(p, this.cm());
            nbt.a("WorldUUIDLeast", ((WorldServer)this.s).getWorld().getUID().getLeastSignificantBits());
            nbt.a("WorldUUIDMost", ((WorldServer)this.s).getWorld().getUID().getMostSignificantBits());
            nbt.a("Bukkit.updateLevel", 2);
            if (!this.persist) {
                nbt.a("Bukkit.persist", this.persist);
            }
            if (this.persistentInvisibility) {
                nbt.a("Bukkit.invisible", this.persistentInvisibility);
            }
            if (this.maxAirTicks != this.getDefaultMaxAirSupply()) {
                nbt.a("Bukkit.MaxAirSupply", this.bX());
            }
            nbt.a("Spigot.ticksLived", this.S);
            IChatBaseComponent ichatbasecomponent = this.Z();
            if (ichatbasecomponent != null) {
                nbt.a("CustomName", IChatBaseComponent.ChatSerializer.a(ichatbasecomponent));
            }
            if (this.cr()) {
                nbt.a("CustomNameVisible", this.cr());
            }
            if (this.aL()) {
                nbt.a("Silent", this.aL());
            }
            if (this.aM()) {
                nbt.a("NoGravity", this.aM());
            }
            if (this.aV) {
                nbt.a("Glowing", true);
            }
            if ((i2 = this.bZ()) > 0) {
                nbt.a("TicksFrozen", this.bZ());
            }
            if (this.bd) {
                nbt.a("HasVisualFire", this.bd);
            }
            if (!this.aW.isEmpty()) {
                nbttaglist = new NBTTagList();
                for (String s2 : this.aW) {
                    nbttaglist.add(NBTTagString.a(s2));
                }
                nbt.a("Tags", nbttaglist);
            }
            this.b(nbt);
            if (this.bG()) {
                nbttaglist = new NBTTagList();
                for (Entity entity : this.cF()) {
                    NBTTagCompound nbttagcompound1;
                    if (!entity.d(nbttagcompound1 = new NBTTagCompound())) continue;
                    nbttaglist.add(nbttagcompound1);
                }
                if (!nbttaglist.isEmpty()) {
                    nbt.a(h, nbttaglist);
                }
            }
            if (this.bukkitEntity != null) {
                this.bukkitEntity.storeBukkitValues(nbt);
            }
            if (this.origin != null) {
                UUID originWorld;
                UUID uUID = this.originWorld != null ? this.originWorld : (originWorld = this.s != null ? this.s.getWorld().getUID() : null);
                if (originWorld != null) {
                    nbt.a("Paper.OriginWorld", originWorld);
                }
                nbt.a("Paper.Origin", this.a(new double[]{this.origin.getX(), this.origin.getY(), this.origin.getZ()}));
            }
            if (this.spawnReason != null) {
                nbt.a("Paper.SpawnReason", this.spawnReason.name());
            }
            if (this.spawnedViaMobSpawner) {
                nbt.a("Paper.FromMobSpawner", true);
            }
            if (this.fromNetherPortal) {
                nbt.a("Paper.FromNetherPortal", true);
            }
            if (this.freezeLocked) {
                nbt.a("Paper.FreezeLock", true);
            }
            return nbt;
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.a(throwable, "Saving entity NBT");
            CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Entity being saved");
            this.a(crashreportsystemdetails);
            throw new ReportedException(crashreport);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void g(NBTTagCompound nbt) {
        try {
            NBTTagList originTag;
            NBTTagList nbttaglist = nbt.c("Pos", 6);
            NBTTagList nbttaglist1 = nbt.c("Motion", 6);
            NBTTagList nbttaglist2 = nbt.c("Rotation", 5);
            double d0 = nbttaglist1.h(0);
            double d1 = nbttaglist1.h(1);
            double d2 = nbttaglist1.h(2);
            this.n(Math.abs(d0) > 10.0 ? 0.0 : d0, Math.abs(d1) > 10.0 ? 0.0 : d1, Math.abs(d2) > 10.0 ? 0.0 : d2);
            this.o(nbttaglist.h(0), MathHelper.a(nbttaglist.h(1), -2.0E7, 2.0E7), nbttaglist.h(2));
            this.o(nbttaglist2.i(0));
            this.p(nbttaglist2.i(1));
            this.be();
            this.l(this.dn());
            this.m(this.dn());
            this.L = nbt.j("FallDistance");
            this.aF = nbt.g("Fire");
            if (nbt.e("Air")) {
                this.i(nbt.g("Air"));
            }
            this.y = nbt.q("OnGround");
            this.aU = nbt.q("Invulnerable");
            this.aT = nbt.h("PortalCooldown");
            if (nbt.b(p)) {
                this.aj = nbt.a(p);
                this.ak = this.aj.toString();
            }
            if (!Double.isFinite(this.dc()) || !Double.isFinite(this.de()) || !Double.isFinite(this.di())) throw new IllegalStateException("Entity has invalid position");
            if (!Double.isFinite(this.dn()) || !Double.isFinite(this.do())) throw new IllegalStateException("Entity has invalid rotation");
            this.am();
            this.a(this.dn(), this.do());
            if (nbt.b("CustomName", 8)) {
                String s2 = nbt.l("CustomName");
                try {
                    this.a(IChatBaseComponent.ChatSerializer.a(s2));
                }
                catch (Exception exception) {
                    b.warn("Failed to parse entity custom name {}", (Object)s2, (Object)exception);
                }
            }
            this.n(nbt.q("CustomNameVisible"));
            this.d(nbt.q("Silent"));
            this.e(nbt.q("NoGravity"));
            this.i(nbt.q("Glowing"));
            this.j(nbt.h("TicksFrozen"));
            this.bd = nbt.q("HasVisualFire");
            if (nbt.b("Tags", 9)) {
                this.aW.clear();
                NBTTagList nbttaglist3 = nbt.c("Tags", 8);
                int i2 = Math.min(nbttaglist3.size(), 1024);
                for (int j2 = 0; j2 < i2; ++j2) {
                    this.aW.add(nbttaglist3.j(j2));
                }
            }
            this.a(nbt);
            if (this.bj()) {
                this.am();
            }
            if (this instanceof EntityLiving) {
                EntityLiving entity = (EntityLiving)this;
                this.S = nbt.h("Spigot.ticksLived");
                if (entity instanceof EntityTameableAnimal && !Entity.isLevelAtLeast(nbt, 2) && !nbt.q("PersistenceRequired")) {
                    EntityInsentient entityinsentient;
                    entityinsentient.setPersistenceRequired(!(entityinsentient = (EntityInsentient)entity).h(0.0));
                }
            }
            boolean bl = this.persist = !nbt.e("Bukkit.persist") || nbt.q("Bukkit.persist");
            if (nbt.e("Bukkit.MaxAirSupply")) {
                this.maxAirTicks = nbt.h("Bukkit.MaxAirSupply");
            }
            if (this instanceof EntityPlayer) {
                Server server = Bukkit.getServer();
                World bworld = null;
                String worldName = nbt.l("world");
                if (nbt.e("WorldUUIDMost") && nbt.e("WorldUUIDLeast")) {
                    UUID uid = new UUID(nbt.i("WorldUUIDMost"), nbt.i("WorldUUIDLeast"));
                    bworld = server.getWorld(uid);
                } else {
                    bworld = server.getWorld(worldName);
                }
                ((EntityPlayer)this).c(bworld == null ? null : ((CraftWorld)bworld).getHandle());
            }
            this.getBukkitEntity().readBukkitValues(nbt);
            if (nbt.e("Bukkit.invisible")) {
                boolean bukkitInvisible = nbt.q("Bukkit.invisible");
                this.j(bukkitInvisible);
                this.persistentInvisibility = bukkitInvisible;
            }
            if (!(originTag = nbt.c("Paper.Origin", 6)).isEmpty()) {
                UUID originWorld = null;
                if (nbt.e("Paper.OriginWorld")) {
                    originWorld = nbt.a("Paper.OriginWorld");
                } else if (this.s != null) {
                    originWorld = this.s.getWorld().getUID();
                }
                this.originWorld = originWorld;
                this.origin = new Vector(originTag.h(0), originTag.h(1), originTag.h(2));
            }
            this.spawnedViaMobSpawner = nbt.q("Paper.FromMobSpawner");
            this.fromNetherPortal = nbt.q("Paper.FromNetherPortal");
            if (nbt.e("Paper.SpawnReason")) {
                String spawnReasonName = nbt.l("Paper.SpawnReason");
                try {
                    this.spawnReason = CreatureSpawnEvent.SpawnReason.valueOf((String)spawnReasonName);
                }
                catch (Exception ignored) {
                    b.error("Unknown SpawnReason " + spawnReasonName + " for " + this);
                }
            }
            if (this.spawnReason == null) {
                if (this.spawnedViaMobSpawner) {
                    this.spawnReason = CreatureSpawnEvent.SpawnReason.SPAWNER;
                } else if (this instanceof EntityInsentient && (this instanceof EntityAnimal || this instanceof EntityFish) && !((EntityInsentient)this).h(0.0) && !nbt.q("PersistenceRequired")) {
                    this.spawnReason = CreatureSpawnEvent.SpawnReason.NATURAL;
                }
            }
            if (this.spawnReason == null) {
                this.spawnReason = CreatureSpawnEvent.SpawnReason.DEFAULT;
            }
            if (!nbt.e("Paper.FreezeLock")) return;
            this.freezeLocked = nbt.q("Paper.FreezeLock");
            return;
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.a(throwable, "Loading entity NBT");
            CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Entity being loaded");
            this.a(crashreportsystemdetails);
            throw new ReportedException(crashreport);
        }
    }

    protected boolean bj() {
        return true;
    }

    @Override
    public MinecraftKey getMinecraftKey() {
        if (this.entityKey == null) {
            this.entityKey = EntityTypes.a(this.ad());
            this.entityKeyString = this.entityKey != null ? this.entityKey.toString() : null;
        }
        return this.entityKey;
    }

    @Override
    public String getMinecraftKeyString() {
        this.getMinecraftKey();
        return this.entityKeyString;
    }

    @javax.annotation.Nullable
    public final String bk() {
        EntityTypes<?> entitytypes = this.ad();
        MinecraftKey minecraftkey = EntityTypes.a(entitytypes);
        return entitytypes != null && entitytypes.b() ? this.getMinecraftKeyString() : null;
    }

    protected abstract void a(NBTTagCompound var1);

    protected abstract void b(NBTTagCompound var1);

    protected NBTTagList a(double ... values) {
        NBTTagList nbttaglist = new NBTTagList();
        double[] adouble1 = values;
        int i2 = values.length;
        for (int j2 = 0; j2 < i2; ++j2) {
            double d0 = adouble1[j2];
            nbttaglist.add(NBTTagDouble.a(d0));
        }
        return nbttaglist;
    }

    protected NBTTagList a(float ... values) {
        NBTTagList nbttaglist = new NBTTagList();
        float[] afloat1 = values;
        int i2 = values.length;
        for (int j2 = 0; j2 < i2; ++j2) {
            float f2 = afloat1[j2];
            nbttaglist.add(NBTTagFloat.a(f2));
        }
        return nbttaglist;
    }

    @javax.annotation.Nullable
    public EntityItem a(IMaterial item) {
        return this.a(item, 0);
    }

    @javax.annotation.Nullable
    public EntityItem a(IMaterial item, int yOffset) {
        return this.a(new ItemStack(item), (float)yOffset);
    }

    @javax.annotation.Nullable
    public EntityItem b(ItemStack stack) {
        return this.a(stack, 0.0f);
    }

    @javax.annotation.Nullable
    public EntityItem a(ItemStack stack, float yOffset) {
        if (stack.b()) {
            return null;
        }
        if (this.s.x) {
            return null;
        }
        if (this instanceof EntityLiving && !((EntityLiving)this).forceDrops) {
            ((EntityLiving)this).drops.add(CraftItemStack.asCraftMirror(stack));
            return null;
        }
        EntityItem entityitem = new EntityItem(this.s, this.dc(), this.de() + (double)yOffset, this.di(), stack.n());
        stack.e(0);
        entityitem.n();
        EntityDropItemEvent event = new EntityDropItemEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (Item)entityitem.getBukkitEntity());
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return null;
        }
        this.s.b(entityitem);
        return entityitem;
    }

    public boolean bl() {
        return !this.dp();
    }

    public boolean bm() {
        if (this.Q) {
            return false;
        }
        float f2 = this.aZ.a * 0.8f;
        AxisAlignedBB axisalignedbb = AxisAlignedBB.a(this.bg(), f2, 1.0E-6, f2);
        BlockPosition.MutableBlockPosition blockposition = new BlockPosition.MutableBlockPosition();
        int minX = MathHelper.b(axisalignedbb.a);
        int minY = MathHelper.b(axisalignedbb.b);
        int minZ = MathHelper.b(axisalignedbb.c);
        int maxX = MathHelper.b(axisalignedbb.d);
        int maxY = MathHelper.b(axisalignedbb.e);
        int maxZ = MathHelper.b(axisalignedbb.f);
        for (int fz = minZ; fz <= maxZ; ++fz) {
            for (int fx = minX; fx <= maxX; ++fx) {
                for (int fy = minY; fy <= maxY; ++fy) {
                    Chunk chunk = (Chunk)this.s.getChunkIfLoadedImmediately(fx >> 4, fz >> 4);
                    if (chunk == null) continue;
                    IBlockData iblockdata = chunk.getBlockStateFinal(fx, fy, fz);
                    blockposition.d(fx, fy, fz);
                    if (iblockdata.g() || !iblockdata.o(this.s, blockposition) || !VoxelShapes.c(iblockdata.k(this.s, blockposition).a((double)blockposition.u(), (double)blockposition.v(), (double)blockposition.w()), VoxelShapes.a(axisalignedbb), OperatorBoolean.i)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public EnumInteractionResult a(EntityHuman player, EnumHand hand) {
        return EnumInteractionResult.d;
    }

    public boolean h(Entity other) {
        return other.bn() && !this.v(other);
    }

    public boolean bn() {
        return false;
    }

    public void bo() {
        this.g(Vec3D.a);
        this.k();
        if (this.bF()) {
            this.cN().i(this);
        }
    }

    public void i(Entity passenger) {
        this.a(passenger, Entity::e);
    }

    private void a(Entity passenger, MoveFunction positionUpdater) {
        if (this.u(passenger)) {
            double d0 = this.de() + this.bq() + passenger.bp();
            positionUpdater.accept(passenger, this.dc(), d0, this.di());
        }
    }

    public void j(Entity passenger) {
    }

    public double bp() {
        return 0.0;
    }

    public double bq() {
        return (double)this.aZ.b * 0.75;
    }

    public boolean k(Entity entity) {
        return this.a(entity, false);
    }

    public boolean br() {
        return this instanceof EntityLiving;
    }

    public boolean a(Entity entity, boolean force) {
        if (entity == this.av) {
            return false;
        }
        Entity entity1 = entity;
        while (entity1.av != null) {
            if (entity1.av == this) {
                return false;
            }
            entity1 = entity1.av;
        }
        if (!(force || this.l(entity) && entity.o(this))) {
            return false;
        }
        if (this.bF()) {
            this.p();
        }
        this.b(EntityPose.a);
        this.av = entity;
        if (!this.av.addPassenger(this)) {
            this.av = null;
        }
        entity.n().filter(entity2 -> entity2 instanceof EntityPlayer).forEach(entity2 -> CriterionTriggers.Q.a((EntityPlayer)entity2));
        return true;
    }

    protected boolean l(Entity entity) {
        return !this.bI() && this.r <= 0;
    }

    protected boolean c(EntityPose pose) {
        return this.s.a(this, this.d(pose).h(1.0E-7));
    }

    public void bs() {
        for (int i2 = this.au.size() - 1; i2 >= 0; --i2) {
            ((Entity)this.au.get(i2)).p();
        }
    }

    public void bt() {
        this.stopRiding(false);
    }

    public void stopRiding(boolean suppressCancellation) {
        if (this.av != null) {
            Entity entity = this.av;
            this.av = null;
            if (!entity.removePassenger(this, suppressCancellation)) {
                this.av = entity;
            }
        }
    }

    public void p() {
        this.bt();
    }

    protected boolean addPassenger(Entity entity) {
        EntityMountEvent event;
        Entity orig;
        if (entity == this) {
            throw new IllegalArgumentException("Entities cannot become a passenger of themselves");
        }
        if (entity.cN() != this) {
            throw new IllegalStateException("Use x.startRiding(y), not y.addPassenger(x)");
        }
        Preconditions.checkState((!entity.au.contains((Object)this) ? 1 : 0) != 0, (String)"Circular entity riding! %s %s", (Object)this, (Object)entity);
        CraftEntity craft = (CraftEntity)entity.getBukkitEntity().getVehicle();
        Entity entity2 = orig = craft == null ? null : craft.getHandle();
        if (this.getBukkitEntity() instanceof Vehicle && entity.getBukkitEntity() instanceof LivingEntity) {
            CraftEntity craftn;
            Entity n2;
            event = new VehicleEnterEvent((Vehicle)this.getBukkitEntity(), (org.bukkit.entity.Entity)entity.getBukkitEntity());
            if (this.valid) {
                Bukkit.getPluginManager().callEvent((Event)event);
            }
            Entity entity3 = n2 = (craftn = (CraftEntity)entity.getBukkitEntity().getVehicle()) == null ? null : craftn.getHandle();
            if (event.isCancelled() || n2 != orig) {
                return false;
            }
        }
        event = new EntityMountEvent((org.bukkit.entity.Entity)entity.getBukkitEntity(), (org.bukkit.entity.Entity)this.getBukkitEntity());
        if (this.valid) {
            Bukkit.getPluginManager().callEvent((Event)event);
        }
        if (event.isCancelled()) {
            return false;
        }
        if (this.au.isEmpty()) {
            this.au = ImmutableList.of((Object)entity);
        } else {
            ArrayList list = Lists.newArrayList(this.au);
            if (!this.s.x && entity instanceof EntityHuman && !(this.cE() instanceof EntityHuman)) {
                list.add(0, entity);
            } else {
                list.add(entity);
            }
            this.au = ImmutableList.copyOf((Collection)list);
        }
        return true;
    }

    protected boolean removePassenger(Entity entity) {
        return this.removePassenger(entity, false);
    }

    protected boolean removePassenger(Entity entity, boolean suppressCancellation) {
        EntityDismountEvent event;
        Entity orig;
        if (entity.cN() == this) {
            throw new IllegalStateException("Use x.stopRiding(y), not y.removePassenger(x)");
        }
        CraftEntity craft = (CraftEntity)entity.getBukkitEntity().getVehicle();
        Entity entity2 = orig = craft == null ? null : craft.getHandle();
        if (this.getBukkitEntity() instanceof Vehicle && entity.getBukkitEntity() instanceof LivingEntity) {
            CraftEntity craftn;
            Entity n2;
            event = new VehicleExitEvent((Vehicle)this.getBukkitEntity(), (LivingEntity)entity.getBukkitEntity(), !suppressCancellation);
            if (this.valid) {
                Bukkit.getPluginManager().callEvent((Event)event);
            }
            Entity entity3 = n2 = (craftn = (CraftEntity)entity.getBukkitEntity().getVehicle()) == null ? null : craftn.getHandle();
            if (event.isCancelled() || n2 != orig) {
                return false;
            }
        }
        event = new EntityDismountEvent((org.bukkit.entity.Entity)entity.getBukkitEntity(), (org.bukkit.entity.Entity)this.getBukkitEntity(), !suppressCancellation);
        if (this.valid) {
            Bukkit.getPluginManager().callEvent((Event)event);
        }
        if (event.isCancelled()) {
            return false;
        }
        this.au = this.au.size() == 1 && this.au.get(0) == entity ? ImmutableList.of() : (ImmutableList)this.au.stream().filter(entity1 -> entity1 != entity).collect(ImmutableList.toImmutableList());
        entity.r = 60;
        return true;
    }

    protected boolean o(Entity passenger) {
        return this.au.isEmpty();
    }

    public void a(double x2, double y2, double z2, float yaw, float pitch, int interpolationSteps, boolean interpolate) {
        this.e(x2, y2, z2);
        this.a(yaw, pitch);
    }

    public void a(float yaw, int interpolationSteps) {
        this.l(yaw);
    }

    public float bu() {
        return 0.0f;
    }

    public Vec3D bv() {
        return this.b(this.do(), this.dn());
    }

    public Vec3D a(net.minecraft.world.item.Item item) {
        if (!(this instanceof EntityHuman)) {
            return Vec3D.a;
        }
        EntityHuman entityhuman = (EntityHuman)this;
        boolean flag = entityhuman.et().a(item) && !entityhuman.es().a(item);
        EnumMainHand enummainhand = flag ? entityhuman.eL().a() : entityhuman.eL();
        return this.b(0.0f, this.dn() + (float)(enummainhand == EnumMainHand.b ? 80 : -80)).a(0.5);
    }

    public Vec2F bw() {
        return new Vec2F(this.do(), this.dn());
    }

    public Vec3D bx() {
        return Vec3D.a(this.bw());
    }

    public void d(BlockPosition pos) {
        if (this.aq()) {
            this.ap();
        } else {
            if (!this.s.x && !pos.equals(this.ai)) {
                this.ai = pos.h();
            }
            this.ag = true;
        }
    }

    protected void by() {
        if (this.s instanceof WorldServer) {
            int i2 = this.ar();
            WorldServer worldserver = (WorldServer)this.s;
            if (this.ag) {
                MinecraftServer minecraftserver = worldserver.n();
                ResourceKey<net.minecraft.world.level.World> resourcekey = this.s.getTypeKey() == WorldDimension.c ? net.minecraft.world.level.World.e : net.minecraft.world.level.World.f;
                WorldServer worldserver1 = minecraftserver.a(resourcekey);
                if (!this.bF() && this.ah++ >= i2) {
                    this.s.ab().a("portal");
                    this.ah = i2;
                    this.ap();
                    if (this instanceof EntityPlayer) {
                        ((EntityPlayer)this).changeDimension(worldserver1, PlayerTeleportEvent.TeleportCause.NETHER_PORTAL);
                    } else {
                        this.b(worldserver1);
                    }
                    this.s.ab().c();
                }
                this.ag = false;
            } else {
                if (this.ah > 0) {
                    this.ah -= 4;
                }
                if (this.ah < 0) {
                    this.ah = 0;
                }
            }
            this.H();
            this.tickEndPortal();
        }
    }

    public int bz() {
        return 300;
    }

    public void k(double x2, double y2, double z2) {
        this.n(x2, y2, z2);
    }

    public void a(byte status) {
        switch (status) {
            case 53: {
                BlockHoney.a(this);
            }
        }
    }

    public void bA() {
    }

    public Iterable<ItemStack> bB() {
        return d;
    }

    public Iterable<ItemStack> bC() {
        return d;
    }

    public Iterable<ItemStack> bD() {
        return Iterables.concat(this.bB(), this.bC());
    }

    public void a(EnumItemSlot slot, ItemStack stack) {
    }

    public boolean bE() {
        boolean flag = this.s != null && this.s.x;
        return !this.aP() && (this.aF > 0 || flag && this.h(0));
    }

    public boolean bF() {
        return this.cN() != null;
    }

    public boolean bG() {
        return !this.au.isEmpty();
    }

    public boolean bH() {
        return true;
    }

    public void f(boolean sneaking) {
        this.b(1, sneaking);
    }

    public boolean bI() {
        return this.h(1);
    }

    public boolean bJ() {
        return this.bI();
    }

    public boolean bK() {
        return this.bI();
    }

    public boolean bL() {
        return this.bI();
    }

    public boolean bM() {
        return this.bI();
    }

    public boolean bN() {
        return this.ak() == EntityPose.f;
    }

    public boolean bO() {
        return this.h(3);
    }

    public void g(boolean sprinting) {
        this.b(3, sprinting);
    }

    public boolean bP() {
        return this.h(4);
    }

    public boolean bQ() {
        return this.ak() == EntityPose.d;
    }

    public boolean bR() {
        return this.bQ() && !this.aQ();
    }

    public void h(boolean swimming) {
        if (this.valid && this.bP() != swimming && this instanceof EntityLiving && CraftEventFactory.callToggleSwimEvent((EntityLiving)this, swimming).isCancelled()) {
            return;
        }
        this.b(4, swimming);
    }

    public final boolean bS() {
        return this.aV;
    }

    public final void i(boolean glowing) {
        this.aV = glowing;
        this.b(6, this.bT());
    }

    public boolean bT() {
        return this.s.k_() ? this.h(6) : this.aV;
    }

    public boolean bU() {
        return this.h(5);
    }

    public boolean c(EntityHuman player) {
        if (player.B_()) {
            return false;
        }
        ScoreboardTeamBase scoreboardteambase = this.bW();
        return scoreboardteambase != null && player != null && player.bW() == scoreboardteambase && scoreboardteambase.i() ? false : this.bU();
    }

    @javax.annotation.Nullable
    public GameEventListenerRegistrar bV() {
        return null;
    }

    @javax.annotation.Nullable
    public ScoreboardTeamBase bW() {
        if (!this.s.paperConfig.nonPlayerEntitiesOnScoreboards && !(this instanceof EntityHuman)) {
            return null;
        }
        return this.s.J().i(this.co());
    }

    public boolean p(Entity other) {
        return this.a(other.bW());
    }

    public boolean a(ScoreboardTeamBase team) {
        return this.bW() != null ? this.bW().a(team) : false;
    }

    public void j(boolean invisible) {
        if (!this.persistentInvisibility) {
            this.b(5, invisible);
        }
    }

    public boolean h(int index) {
        return (this.Y.a(Z) & 1 << index) != 0;
    }

    public void b(int index, boolean value) {
        byte b0 = this.Y.a(Z);
        if (value) {
            this.Y.b(Z, (byte)(b0 | 1 << index));
        } else {
            this.Y.b(Z, (byte)(b0 & ~(1 << index)));
        }
    }

    public int bX() {
        return this.maxAirTicks;
    }

    public int bY() {
        return this.Y.a(aL);
    }

    public void i(int air) {
        EntityAirChangeEvent event = new EntityAirChangeEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), air);
        if (this.valid) {
            event.getEntity().getServer().getPluginManager().callEvent((Event)event);
        }
        if (event.isCancelled() && this.bY() != air) {
            this.Y.markDirty(aL);
            return;
        }
        this.Y.b(aL, event.getAmount());
    }

    public int bZ() {
        return this.Y.a(aQ);
    }

    public void j(int frozenTicks) {
        this.Y.b(aQ, frozenTicks);
    }

    public float ca() {
        int i2 = this.cc();
        return (float)Math.min(this.bZ(), i2) / (float)i2;
    }

    public boolean cb() {
        return this.bZ() >= this.cc();
    }

    public int cc() {
        return 140;
    }

    public void a(WorldServer world, EntityLightning lightning) {
        this.g(this.aF + 1);
        CraftEntity thisBukkitEntity = this.getBukkitEntity();
        CraftEntity stormBukkitEntity = lightning.getBukkitEntity();
        PluginManager pluginManager = Bukkit.getPluginManager();
        if (this.aF == 0) {
            EntityCombustByEntityEvent entityCombustEvent = new EntityCombustByEntityEvent((org.bukkit.entity.Entity)stormBukkitEntity, (org.bukkit.entity.Entity)thisBukkitEntity, 8);
            pluginManager.callEvent((Event)entityCombustEvent);
            if (!entityCombustEvent.isCancelled()) {
                this.setSecondsOnFire(entityCombustEvent.getDuration(), false);
            }
        }
        if (thisBukkitEntity instanceof Hanging) {
            HangingBreakByEntityEvent hangingEvent = new HangingBreakByEntityEvent((Hanging)thisBukkitEntity, (org.bukkit.entity.Entity)stormBukkitEntity);
            pluginManager.callEvent((Event)hangingEvent);
            if (hangingEvent.isCancelled()) {
                return;
            }
        }
        if (this.aP()) {
            return;
        }
        CraftEventFactory.entityDamage = lightning;
        if (!this.a(DamageSource.b, 5.0f)) {
            CraftEventFactory.entityDamage = null;
            return;
        }
    }

    public void k(boolean drag) {
        Vec3D vec3d = this.da();
        double d0 = drag ? Math.max(-0.9, vec3d.c - 0.03) : Math.min(1.8, vec3d.c + 0.1);
        this.n(vec3d.b, d0, vec3d.d);
    }

    public void l(boolean drag) {
        Vec3D vec3d = this.da();
        double d0 = drag ? Math.max(-0.3, vec3d.c - 0.03) : Math.min(0.7, vec3d.c + 0.06);
        this.n(vec3d.b, d0, vec3d.d);
        this.m();
    }

    public void a(WorldServer world, EntityLiving other) {
    }

    public void m() {
        this.L = 0.0f;
    }

    protected void l(double x2, double y2, double z2) {
        BlockPosition blockposition = new BlockPosition(x2, y2, z2);
        Vec3D vec3d = new Vec3D(x2 - (double)blockposition.u(), y2 - (double)blockposition.v(), z2 - (double)blockposition.w());
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        EnumDirection enumdirection = EnumDirection.b;
        double d3 = Double.MAX_VALUE;
        for (EnumDirection enumdirection1 : new EnumDirection[]{EnumDirection.c, EnumDirection.d, EnumDirection.e, EnumDirection.f, EnumDirection.b}) {
            double d5;
            blockposition_mutableblockposition.a((BaseBlockPosition)blockposition, enumdirection1);
            if (this.s.a_(blockposition_mutableblockposition).r(this.s, blockposition_mutableblockposition)) continue;
            double d4 = vec3d.a(enumdirection1.n());
            double d2 = d5 = enumdirection1.e() == EnumDirection.EnumAxisDirection.a ? 1.0 - d4 : d4;
            if (!(d5 < d3)) continue;
            d3 = d5;
            enumdirection = enumdirection1;
        }
        float f2 = this.R.nextFloat() * 0.2f + 0.1f;
        float f1 = enumdirection.e().a();
        Vec3D vec3d1 = this.da().a(0.75);
        if (enumdirection.n() == EnumDirection.EnumAxis.a) {
            this.n(f1 * f2, vec3d1.c, vec3d1.d);
        } else if (enumdirection.n() == EnumDirection.EnumAxis.b) {
            this.n(vec3d1.b, f1 * f2, vec3d1.d);
        } else if (enumdirection.n() == EnumDirection.EnumAxis.c) {
            this.n(vec3d1.b, vec3d1.c, f1 * f2);
        }
    }

    public void a(IBlockData state, Vec3D multiplier) {
        this.m();
        this.E = multiplier;
    }

    private static IChatBaseComponent b(IChatBaseComponent textComponent) {
        IChatMutableComponent ichatmutablecomponent = textComponent.g().a(textComponent.c().a((ChatClickable)null));
        for (IChatBaseComponent ichatbasecomponent1 : textComponent.b()) {
            ichatmutablecomponent.a(Entity.b(ichatbasecomponent1));
        }
        return ichatmutablecomponent;
    }

    @Override
    public IChatBaseComponent X() {
        IChatBaseComponent ichatbasecomponent = this.Z();
        return ichatbasecomponent != null ? Entity.b(ichatbasecomponent) : this.cd();
    }

    protected IChatBaseComponent cd() {
        return this.as.h();
    }

    public boolean q(Entity entity) {
        return this == entity;
    }

    public float ce() {
        return 0.0f;
    }

    public void l(float headYaw) {
    }

    public void m(float bodyYaw) {
    }

    public boolean cf() {
        return true;
    }

    public boolean r(Entity attacker) {
        return false;
    }

    public String toString() {
        String s2 = this.s == null ? "~NULL~" : this.s.toString();
        return this.aD != null ? String.format(Locale.ROOT, "%s['%s'/%d, uuid='%s', l='%s', x=%.2f, y=%.2f, z=%.2f, cpos=%s, tl=%d, v=%b, removed=%s]", new Object[]{this.getClass().getSimpleName(), this.X().getString(), this.at, this.aj, s2, this.dc(), this.de(), this.di(), this.cZ(), this.S, this.valid, this.aD}) : String.format(Locale.ROOT, "%s['%s'/%d, uuid='%s', l='%s', x=%.2f, y=%.2f, z=%.2f, cpos=%s, tl=%d, v=%b]", this.getClass().getSimpleName(), this.X().getString(), this.at, this.aj, s2, this.dc(), this.de(), this.di(), this.cZ(), this.S, this.valid);
    }

    public boolean b(DamageSource damageSource) {
        return this.dp() || this.aU && damageSource != DamageSource.m && !damageSource.B();
    }

    public boolean cg() {
        return this.aU;
    }

    public void m(boolean invulnerable) {
        this.aU = invulnerable;
    }

    public void s(Entity entity) {
        this.b(entity.dc(), entity.de(), entity.di(), entity.dn(), entity.do());
    }

    public void t(Entity original) {
        CraftEntity bukkitEntity = original.bukkitEntity;
        if (bukkitEntity != null) {
            bukkitEntity.setHandle(this);
            this.bukkitEntity = bukkitEntity;
        }
        NBTTagCompound nbttagcompound = original.f(new NBTTagCompound());
        nbttagcompound.r("Dimension");
        this.g(nbttagcompound);
        this.aT = original.aT;
        this.ai = original.ai;
    }

    @javax.annotation.Nullable
    public Entity b(WorldServer destination) {
        return this.teleportTo(destination, null);
    }

    @javax.annotation.Nullable
    public Entity teleportTo(WorldServer worldserver, BlockPosition location) {
        if (!this.bl() || !this.valid) {
            b.warn("Illegal Entity Teleport " + this + " to " + worldserver + ":" + location, new Throwable());
            return null;
        }
        if (this.s instanceof WorldServer && !this.dp()) {
            Object entity;
            ShapeDetectorShape shapedetectorshape;
            this.s.ab().a("changeDimension");
            if (worldserver == null) {
                return null;
            }
            this.s.ab().a("reposition");
            ShapeDetectorShape shapeDetectorShape = shapedetectorshape = location == null ? this.a(worldserver) : new ShapeDetectorShape(new Vec3D(location.u(), location.v(), location.w()), Vec3D.a, this.aA, this.aB, worldserver, null);
            if (shapedetectorshape == null) {
                return null;
            }
            worldserver = shapedetectorshape.world;
            CraftEntity bukkitEntity = this.getBukkitEntity();
            Vec3D position = shapedetectorshape.a;
            float yaw = shapedetectorshape.c;
            float pitch = bukkitEntity.getLocation().getPitch();
            Vec3D velocity = shapedetectorshape.b;
            EntityPortalExitEvent event = new EntityPortalExitEvent((org.bukkit.entity.Entity)bukkitEntity, bukkitEntity.getLocation(), new Location((World)worldserver.getWorld(), position.b, position.c, position.d, yaw, pitch), bukkitEntity.getVelocity(), CraftVector.toBukkit(shapedetectorshape.b));
            if (event.callEvent() && event.getTo() != null && this.bl()) {
                worldserver = ((CraftWorld)event.getTo().getWorld()).getHandle();
                position = new Vec3D(event.getTo().getX(), event.getTo().getY(), event.getTo().getZ());
                yaw = event.getTo().getYaw();
                pitch = event.getTo().getPitch();
                velocity = CraftVector.toNMS(event.getAfter());
            }
            if (worldserver == this.s) {
                this.b(shapedetectorshape.a.b, shapedetectorshape.a.c, shapedetectorshape.a.d, shapedetectorshape.c, shapedetectorshape.d);
                this.g(shapedetectorshape.b);
                return this;
            }
            this.ab();
            this.s.ab().b("reloading");
            if (this instanceof EntityInsentient) {
                ((EntityInsentient)this).a(true, true);
            }
            if ((entity = this.ad().a(worldserver)) != null) {
                ((Entity)entity).t(this);
                ((Entity)entity).b(position.b, position.c, position.d, yaw, pitch);
                ((Entity)entity).g(velocity);
                worldserver.d((Entity)entity);
                if (worldserver.getTypeKey() == WorldDimension.d) {
                    WorldServer.makeObsidianPlatform(worldserver, this);
                }
            }
            this.ch();
            this.s.ab().c();
            ((WorldServer)this.s).g();
            worldserver.g();
            this.s.ab().c();
            return entity;
        }
        return null;
    }

    protected void ch() {
        this.b(RemovalReason.e);
    }

    @javax.annotation.Nullable
    protected ShapeDetectorShape a(WorldServer destination) {
        BlockPosition blockposition1;
        boolean flag1;
        if (destination == null) {
            return null;
        }
        boolean flag = this.s.getTypeKey() == WorldDimension.d && destination.getTypeKey() == WorldDimension.b;
        boolean bl = flag1 = destination.getTypeKey() == WorldDimension.d;
        if (!flag && !flag1) {
            CraftPortalEvent event;
            boolean flag2;
            boolean bl2 = flag2 = destination.getTypeKey() == WorldDimension.c;
            if (this.s.getTypeKey() != WorldDimension.c && !flag2) {
                return null;
            }
            WorldBorder worldborder = destination.p_();
            double d0 = DimensionManager.a(this.s.q_(), destination.q_());
            BlockPosition blockposition = worldborder.b(this.dc() * d0, this.de(), this.di() * d0);
            int portalSearchRadius = destination.paperConfig.portalSearchRadius;
            if (this.s.paperConfig.portalSearchVanillaDimensionScaling && flag2) {
                portalSearchRadius = (int)((double)portalSearchRadius / destination.q_().e());
            }
            if ((event = this.callPortalEvent(this, destination, blockposition, PlayerTeleportEvent.TeleportCause.NETHER_PORTAL, portalSearchRadius, destination.paperConfig.portalCreateRadius)) == null) {
                return null;
            }
            WorldServer worldserverFinal = destination = ((CraftWorld)event.getTo().getWorld()).getHandle();
            worldborder = worldserverFinal.p_();
            blockposition = worldborder.b(event.getTo().getX(), event.getTo().getY(), event.getTo().getZ());
            return this.getExitPortal(destination, blockposition, flag2, worldborder, event.getSearchRadius(), event.getCanCreatePortal(), event.getCreationRadius()).map(blockutil_rectangle -> {
                Vec3D vec3d;
                EnumDirection.EnumAxis enumdirection_enumaxis;
                IBlockData iblockdata = this.s.a_(this.ai);
                if (iblockdata.b(BlockProperties.F)) {
                    enumdirection_enumaxis = iblockdata.c(BlockProperties.F);
                    BlockUtil.Rectangle blockutil_rectangle1 = BlockUtil.a(this.ai, enumdirection_enumaxis, 21, EnumDirection.EnumAxis.b, 21, blockposition1 -> this.s.a_((BlockPosition)blockposition1) == iblockdata);
                    vec3d = this.a(enumdirection_enumaxis, blockutil_rectangle1);
                } else {
                    enumdirection_enumaxis = EnumDirection.EnumAxis.a;
                    vec3d = new Vec3D(0.5, 0.0, 0.0);
                }
                return BlockPortalShape.createPortalInfo(worldserverFinal, blockutil_rectangle, enumdirection_enumaxis, vec3d, this.a(this.ak()), this.da(), this.dn(), this.do(), event);
            }).orElse(null);
        }
        if (flag1) {
            blockposition1 = WorldServer.a;
        } else {
            destination.l(destination.v());
            blockposition1 = destination.a(HeightMap.Type.f, destination.v());
        }
        CraftPortalEvent event = this.callPortalEvent(this, destination, blockposition1, PlayerTeleportEvent.TeleportCause.END_PORTAL, 0, 0);
        if (event == null) {
            return null;
        }
        blockposition1 = new BlockPosition(event.getTo().getX(), event.getTo().getY(), event.getTo().getZ());
        return new ShapeDetectorShape(new Vec3D((double)blockposition1.u() + 0.5, blockposition1.v(), (double)blockposition1.w() + 0.5), this.da(), this.dn(), this.do(), ((CraftWorld)event.getTo().getWorld()).getHandle(), event);
    }

    protected Vec3D a(EnumDirection.EnumAxis portalAxis, BlockUtil.Rectangle portalRect) {
        return BlockPortalShape.a(portalRect, portalAxis, this.cV(), this.a(this.ak()));
    }

    protected CraftPortalEvent callPortalEvent(Entity entity, WorldServer exitWorldServer, BlockPosition exitPosition, PlayerTeleportEvent.TeleportCause cause, int searchRadius, int creationRadius) {
        CraftEntity bukkitEntity = entity.getBukkitEntity();
        Location enter = bukkitEntity.getLocation();
        Location exit = new Location((World)exitWorldServer.getWorld(), (double)exitPosition.u(), (double)exitPosition.v(), (double)exitPosition.w());
        EntityPortalEvent event = new EntityPortalEvent((org.bukkit.entity.Entity)bukkitEntity, enter, exit, searchRadius);
        event.getEntity().getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled() || event.getTo() == null || event.getTo().getWorld() == null || !entity.bl()) {
            return null;
        }
        return new CraftPortalEvent(event);
    }

    protected Optional<BlockUtil.Rectangle> getExitPortal(WorldServer worldserver, BlockPosition blockposition, boolean flag, WorldBorder worldborder, int searchRadius, boolean canCreatePortal, int createRadius) {
        return worldserver.o().findPortalAround(blockposition, worldborder, searchRadius);
    }

    public boolean ci() {
        return this.bl() && this.valid;
    }

    public float a(Explosion explosion, IBlockAccess world, BlockPosition pos, IBlockData blockState, Fluid fluidState, float max) {
        return max;
    }

    public boolean a(Explosion explosion, IBlockAccess world, BlockPosition pos, IBlockData state, float explosionPower) {
        return true;
    }

    public int cj() {
        return 3;
    }

    public boolean ck() {
        return false;
    }

    public void a(CrashReportSystemDetails section) {
        section.a("Entity Type", () -> {
            MinecraftKey minecraftkey = EntityTypes.a(this.ad());
            return minecraftkey + " (" + this.getClass().getCanonicalName() + ")";
        });
        section.a("Entity ID", this.at);
        section.a("Entity Name", () -> this.X().getString());
        section.a("Entity's Exact location", String.format(Locale.ROOT, "%.2f, %.2f, %.2f", this.dc(), this.de(), this.di()));
        section.a("Entity's Block location", CrashReportSystemDetails.a((LevelHeightAccessor)this.s, MathHelper.b(this.dc()), MathHelper.b(this.de()), MathHelper.b(this.di())));
        Vec3D vec3d = this.da();
        section.a("Entity's Momentum", String.format(Locale.ROOT, "%.2f, %.2f, %.2f", vec3d.b, vec3d.c, vec3d.d));
        section.a("Entity's Passengers", () -> this.cF().toString());
        section.a("Entity's Vehicle", () -> String.valueOf(this.cN()));
    }

    public boolean cl() {
        return this.bE() && !this.B_();
    }

    public void a_(UUID uuid) {
        this.aj = uuid;
        this.ak = this.aj.toString();
    }

    @Override
    public UUID cm() {
        return this.aj;
    }

    public String cn() {
        return this.ak;
    }

    public String co() {
        return this.ak;
    }

    public boolean cp() {
        return true;
    }

    public static double cq() {
        return ar;
    }

    public static void b(double value) {
        ar = value;
    }

    @Override
    public IChatBaseComponent C_() {
        return ScoreboardTeam.a(this.bW(), this.X()).a(chatmodifier -> chatmodifier.a(this.cv()).a(this.cn()));
    }

    public void a(@javax.annotation.Nullable IChatBaseComponent name) {
        this.Y.b(aM, Optional.ofNullable(name));
    }

    @Override
    @javax.annotation.Nullable
    public IChatBaseComponent Z() {
        return this.Y.a(aM).orElse(null);
    }

    @Override
    public boolean Y() {
        return this.Y.a(aM).isPresent();
    }

    public void n(boolean visible) {
        this.Y.b(aN, visible);
    }

    public boolean cr() {
        return this.Y.a(aN);
    }

    public final void m(double destX, double destY, double destZ) {
        if (this.s instanceof WorldServer) {
            ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(new BlockPosition(destX, destY, destZ));
            ((WorldServer)this.s).k().a(TicketType.g, chunkcoordintpair, 0, this.ae());
            this.s.d(chunkcoordintpair.c, chunkcoordintpair.d);
            this.b(destX, destY, destZ);
        }
    }

    public void a(double destX, double destY, double destZ) {
        this.b(destX, destY, destZ);
    }

    public void b(double destX, double destY, double destZ) {
        if (this.s instanceof WorldServer) {
            this.b(destX, destY, destZ, this.dn(), this.do());
            this.cH().forEach(entity -> {
                for (Entity entity1 : entity.au) {
                    entity.a(entity1, Entity::c);
                }
            });
        }
    }

    public boolean cs() {
        return this.cr();
    }

    public void a(DataWatcherObject<?> data) {
        if (ad.equals(data)) {
            this.z_();
        }
    }

    public void z_() {
        boolean flag;
        EntitySize entitysize1;
        EntitySize entitysize = this.aZ;
        EntityPose entitypose = this.ak();
        this.aZ = entitysize1 = this.a(entitypose);
        this.ba = this.a(entitypose, entitysize1);
        this.am();
        boolean bl = flag = (double)entitysize1.a <= 4.0 && (double)entitysize1.b <= 4.0;
        if (!(this.s.x || this.X || this.Q || !flag || !(entitysize1.a > entitysize.a) && !(entitysize1.b > entitysize.b) || this instanceof EntityHuman)) {
            Vec3D vec3d = this.cV().b(0.0, (double)entitysize.b / 2.0, 0.0);
            double d0 = (double)Math.max(0.0f, entitysize1.a - entitysize.a) + 1.0E-6;
            double d1 = (double)Math.max(0.0f, entitysize1.b - entitysize.b) + 1.0E-6;
            VoxelShape voxelshape = VoxelShapes.a(AxisAlignedBB.a(vec3d, d0, d1, d0));
            this.s.a(this, voxelshape, vec3d, (double)entitysize1.a, (double)entitysize1.b, (double)entitysize1.a).ifPresent(vec3d1 -> this.b(vec3d1.b(0.0, (double)(-entitysize1.b) / 2.0, 0.0)));
        }
    }

    public EnumDirection ct() {
        return EnumDirection.a(this.dn());
    }

    public EnumDirection cu() {
        return this.ct();
    }

    protected ChatHoverable cv() {
        return new ChatHoverable(ChatHoverable.EnumHoverAction.c, new ChatHoverable.b(this.ad(), this.cm(), this.X()));
    }

    public boolean a(EntityPlayer spectator) {
        return true;
    }

    @Override
    public final AxisAlignedBB cw() {
        return this.aC;
    }

    public AxisAlignedBB cx() {
        return this.cw();
    }

    protected AxisAlignedBB d(EntityPose pos) {
        EntitySize entitysize = this.a(pos);
        float f2 = entitysize.a / 2.0f;
        Vec3D vec3d = new Vec3D(this.dc() - (double)f2, this.de(), this.di() - (double)f2);
        Vec3D vec3d1 = new Vec3D(this.dc() + (double)f2, this.de() + (double)entitysize.b, this.di() + (double)f2);
        return new AxisAlignedBB(vec3d, vec3d1);
    }

    public final void a(AxisAlignedBB boundingBox) {
        double minX = boundingBox.a;
        double minY = boundingBox.b;
        double minZ = boundingBox.c;
        double maxX = boundingBox.d;
        double maxY = boundingBox.e;
        double maxZ = boundingBox.f;
        double len = boundingBox.d - boundingBox.a;
        if (len < 0.0) {
            maxX = minX;
        }
        if (len > 64.0) {
            maxX = minX + 64.0;
        }
        if ((len = boundingBox.e - boundingBox.b) < 0.0) {
            maxY = minY;
        }
        if (len > 64.0) {
            maxY = minY + 64.0;
        }
        if ((len = boundingBox.f - boundingBox.c) < 0.0) {
            maxZ = minZ;
        }
        if (len > 64.0) {
            maxZ = minZ + 64.0;
        }
        this.aC = new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    protected float a(EntityPose pose, EntitySize dimensions) {
        return dimensions.b * 0.85f;
    }

    public float e(EntityPose pose) {
        return this.a(pose, this.a(pose));
    }

    public final float cy() {
        return this.ba;
    }

    public Vec3D cz() {
        return new Vec3D(0.0, this.cy(), this.cT() * 0.4f);
    }

    public SlotAccess k(int mappedIndex) {
        return SlotAccess.a;
    }

    @Override
    public void a(IChatBaseComponent message, UUID sender) {
    }

    public net.minecraft.world.level.World cA() {
        return this.s;
    }

    @javax.annotation.Nullable
    public MinecraftServer cB() {
        return this.s.n();
    }

    public EnumInteractionResult a(EntityHuman player, Vec3D hitPos, EnumHand hand) {
        return EnumInteractionResult.d;
    }

    public boolean cC() {
        return false;
    }

    public void a(EntityLiving attacker, Entity target) {
        if (target instanceof EntityLiving) {
            EnchantmentManager.a((EntityLiving)target, (Entity)attacker);
        }
        EnchantmentManager.b(attacker, target);
    }

    public void c(EntityPlayer player) {
    }

    public void d(EntityPlayer player) {
    }

    public float a(EnumBlockRotation rotation) {
        float f2 = MathHelper.g(this.dn());
        switch (rotation) {
            case c: {
                return f2 + 180.0f;
            }
            case d: {
                return f2 + 270.0f;
            }
            case b: {
                return f2 + 90.0f;
            }
        }
        return f2;
    }

    public float a(EnumBlockMirror mirror) {
        float f2 = MathHelper.g(this.dn());
        switch (mirror) {
            case c: {
                return -f2;
            }
            case b: {
                return 180.0f - f2;
            }
        }
        return f2;
    }

    public boolean cD() {
        return false;
    }

    @javax.annotation.Nullable
    public Entity cE() {
        return null;
    }

    public final List<Entity> cF() {
        return this.au;
    }

    @javax.annotation.Nullable
    public Entity cG() {
        return this.au.isEmpty() ? null : (Entity)this.au.get(0);
    }

    public boolean u(Entity passenger) {
        return this.au.contains((Object)passenger);
    }

    public boolean a(Predicate<Entity> predicate) {
        Entity entity;
        UnmodifiableIterator unmodifiableiterator = this.au.iterator();
        do {
            if (unmodifiableiterator.hasNext()) continue;
            return false;
        } while (!predicate.test(entity = (Entity)unmodifiableiterator.next()));
        return true;
    }

    private Stream<Entity> n() {
        if (this.au.isEmpty()) {
            return Stream.of(new Entity[0]);
        }
        return this.au.stream().flatMap(Entity::cH);
    }

    public Stream<Entity> cH() {
        if (this.au.isEmpty()) {
            return Stream.of(this);
        }
        return Stream.concat(Stream.of(this), this.n());
    }

    public Stream<Entity> cI() {
        if (this.au.isEmpty()) {
            return Stream.of(this);
        }
        return Stream.concat(this.au.stream().flatMap(Entity::cI), Stream.of(this));
    }

    public Iterable<Entity> cJ() {
        if (this.au.isEmpty()) {
            return ImmutableList.of();
        }
        ImmutableList.Builder indirectPassengers = ImmutableList.builder();
        for (Entity passenger : this.au) {
            indirectPassengers.add((Object)passenger);
            indirectPassengers.addAll(passenger.cJ());
        }
        return indirectPassengers.build();
    }

    private Iterable<Entity> getIndirectPassengers_old() {
        return () -> this.n().iterator();
    }

    public boolean cK() {
        if (this.au.isEmpty()) {
            return false;
        }
        return this.n().filter(entity -> entity instanceof EntityHuman).count() == 1L;
    }

    public Entity cL() {
        Entity entity = this;
        while (entity.bF()) {
            entity = entity.cN();
        }
        return entity;
    }

    public boolean v(Entity entity) {
        return this.cL() == entity.cL();
    }

    public boolean w(Entity passenger) {
        return this.n().anyMatch(entity1 -> entity1 == passenger);
    }

    public boolean cM() {
        Entity entity = this.cE();
        return entity instanceof EntityHuman ? ((EntityHuman)entity).fp() : !this.s.x;
    }

    protected static Vec3D a(double vehicleWidth, double passengerWidth, float passengerYaw) {
        double d2 = (vehicleWidth + passengerWidth + (double)1.0E-5f) / 2.0;
        float f1 = -MathHelper.a(passengerYaw * ((float)Math.PI / 180));
        float f2 = MathHelper.b(passengerYaw * ((float)Math.PI / 180));
        float f3 = Math.max(Math.abs(f1), Math.abs(f2));
        return new Vec3D((double)f1 * d2 / (double)f3, 0.0, (double)f2 * d2 / (double)f3);
    }

    public Vec3D b(EntityLiving passenger) {
        return new Vec3D(this.dc(), this.cw().e, this.di());
    }

    @javax.annotation.Nullable
    public Entity cN() {
        return this.av;
    }

    public EnumPistonReaction c_() {
        return EnumPistonReaction.a;
    }

    public SoundCategory cO() {
        return SoundCategory.g;
    }

    public int cP() {
        return 1;
    }

    public CommandListenerWrapper cQ() {
        return new CommandListenerWrapper(this, this.cV(), this.bw(), this.s instanceof WorldServer ? (WorldServer)this.s : null, this.B(), this.X().getString(), this.C_(), this.s.n(), this);
    }

    protected int B() {
        return 0;
    }

    public boolean l(int permissionLevel) {
        return this.B() >= permissionLevel;
    }

    @Override
    public boolean i_() {
        return this.s.W().b(GameRules.o);
    }

    @Override
    public boolean j_() {
        return true;
    }

    @Override
    public boolean G_() {
        return true;
    }

    public void a(ArgumentAnchor.Anchor anchorPoint, Vec3D target) {
        Vec3D vec3d1 = anchorPoint.a(this);
        double d0 = target.b - vec3d1.b;
        double d1 = target.c - vec3d1.c;
        double d2 = target.d - vec3d1.d;
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        this.p(MathHelper.g((float)(-(MathHelper.d(d1, d3) * 57.2957763671875))));
        this.o(MathHelper.g((float)(MathHelper.d(d2, d0) * 57.2957763671875) - 90.0f));
        this.l(this.dn());
        this.x = this.do();
        this.w = this.dn();
    }

    public boolean a(TagKey<FluidType> tag, double speed) {
        if (this.cR()) {
            return false;
        }
        AxisAlignedBB axisalignedbb = this.cw().h(0.001);
        int i2 = MathHelper.b(axisalignedbb.a);
        int j2 = MathHelper.e(axisalignedbb.d);
        int k2 = MathHelper.b(axisalignedbb.b);
        int l2 = MathHelper.e(axisalignedbb.e);
        int i1 = MathHelper.b(axisalignedbb.c);
        int j1 = MathHelper.e(axisalignedbb.f);
        double d1 = 0.0;
        boolean flag = this.cp();
        boolean flag1 = false;
        Vec3D vec3d = Vec3D.a;
        int k1 = 0;
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        for (int l1 = i2; l1 < j2; ++l1) {
            for (int i22 = k2; i22 < l2; ++i22) {
                for (int j22 = i1; j22 < j1; ++j22) {
                    double d2;
                    blockposition_mutableblockposition.d(l1, i22, j22);
                    Fluid fluid = this.s.b_(blockposition_mutableblockposition);
                    if (!fluid.a(tag) || !((d2 = (double)((float)i22 + fluid.a((IBlockAccess)this.s, (BlockPosition)blockposition_mutableblockposition))) >= axisalignedbb.b)) continue;
                    flag1 = true;
                    d1 = Math.max(d2 - axisalignedbb.b, d1);
                    if (flag) {
                        Vec3D vec3d1 = fluid.c(this.s, blockposition_mutableblockposition);
                        if (d1 < 0.4) {
                            vec3d1 = vec3d1.a(d1);
                        }
                        vec3d = vec3d.e(vec3d1);
                        ++k1;
                    }
                    if (tag != TagsFluid.b) continue;
                    this.lastLavaContact = blockposition_mutableblockposition.h();
                }
            }
        }
        if (vec3d.f() > 0.0) {
            if (k1 > 0) {
                vec3d = vec3d.a(1.0 / (double)k1);
            }
            if (!(this instanceof EntityHuman)) {
                vec3d = vec3d.d();
            }
            Vec3D vec3d2 = this.da();
            vec3d = vec3d.a(speed * 1.0);
            double d3 = 0.003;
            if (Math.abs(vec3d2.b) < 0.003 && Math.abs(vec3d2.d) < 0.003 && vec3d.f() < 0.0045000000000000005) {
                vec3d = vec3d.d().a(0.0045000000000000005);
            }
            this.g(this.da().e(vec3d));
        }
        this.U.put(tag, d1);
        return flag1;
    }

    public boolean cR() {
        int l2;
        AxisAlignedBB axisalignedbb = this.cw().g(1.0);
        int i2 = MathHelper.b(axisalignedbb.a);
        int j2 = MathHelper.e(axisalignedbb.d);
        int k2 = MathHelper.b(axisalignedbb.c);
        return !this.s.b(i2, k2, j2, l2 = MathHelper.e(axisalignedbb.f));
    }

    public double b(TagKey<FluidType> fluid) {
        return this.U.getDouble(fluid);
    }

    public double cS() {
        return (double)this.cy() < 0.4 ? 0.0 : 0.4;
    }

    public final float cT() {
        return this.aZ.a;
    }

    public final float cU() {
        return this.aZ.b;
    }

    public abstract Packet<?> S();

    public EntitySize a(EntityPose pose) {
        return this.as.m();
    }

    public Vec3D cV() {
        return this.aw;
    }

    @Override
    public BlockPosition cW() {
        return this.ax;
    }

    public IBlockData cX() {
        if (this.be == null) {
            this.be = this.s.a_(this.cW());
        }
        return this.be;
    }

    public BlockPosition cY() {
        return new BlockPosition(this.i(1.0f));
    }

    public ChunkCoordIntPair cZ() {
        return this.ay;
    }

    public Vec3D da() {
        return this.az;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void g(Vec3D velocity) {
        Object object = this.posLock;
        synchronized (object) {
            this.az = velocity;
        }
    }

    public void n(double x2, double y2, double z2) {
        this.g(new Vec3D(x2, y2, z2));
    }

    public final int db() {
        return this.ax.u();
    }

    public final double dc() {
        return this.aw.b;
    }

    public double c(double widthScale) {
        return this.aw.b + (double)this.cT() * widthScale;
    }

    public double d(double widthScale) {
        return this.c((2.0 * this.R.nextDouble() - 1.0) * widthScale);
    }

    public final int dd() {
        return this.ax.v();
    }

    public final double de() {
        return this.aw.c;
    }

    public double e(double heightScale) {
        return this.aw.c + (double)this.cU() * heightScale;
    }

    public double df() {
        return this.e(this.R.nextDouble());
    }

    public double dg() {
        return this.aw.c + (double)this.ba;
    }

    public final int dh() {
        return this.ax.w();
    }

    public final double di() {
        return this.aw.d;
    }

    public double f(double widthScale) {
        return this.aw.d + (double)this.cT() * widthScale;
    }

    public double g(double widthScale) {
        return this.f((2.0 * this.R.nextDouble() - 1.0) * widthScale);
    }

    public final void o(double x2, double y2, double z2) {
        this.setPosRaw(x2, y2, z2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setPosRaw(double x2, double y2, double z2, boolean forceBoundingBoxUpdate) {
        if (this instanceof EntityItem && PaperConfig.fixEntityPositionDesync) {
            x2 = (double)MathHelper.c(x2 * 4096.0) * 2.44140625E-4;
            y2 = (double)MathHelper.c(y2 * 4096.0) * 2.44140625E-4;
            z2 = (double)MathHelper.c(z2 * 4096.0) * 2.44140625E-4;
        }
        if (this.aw.b != x2 || this.aw.c != y2 || this.aw.d != z2) {
            Object object = this.posLock;
            synchronized (object) {
                this.aw = new Vec3D(x2, y2, z2);
            }
            int i2 = MathHelper.b(x2);
            int j2 = MathHelper.b(y2);
            int k2 = MathHelper.b(z2);
            if (i2 != this.ax.u() || j2 != this.ax.v() || k2 != this.ax.w()) {
                this.ax = new BlockPosition(i2, j2, k2);
                this.be = null;
                if (SectionPosition.a(i2) != this.ay.c || SectionPosition.a(k2) != this.ay.d) {
                    this.ay = new ChunkCoordIntPair(this.ax);
                }
            }
            this.aR.a();
            GameEventListenerRegistrar gameeventlistenerregistrar = this.bV();
            if (gameeventlistenerregistrar != null) {
                gameeventlistenerregistrar.b(this.s);
            }
        }
        if (!(this instanceof EntityHanging) && (forceBoundingBoxUpdate || this.aw.b != x2 || this.aw.c != y2 || this.aw.d != z2)) {
            this.a(this.al());
        }
    }

    public void dj() {
    }

    public Vec3D n(float delta) {
        return this.k(delta).b(0.0, (double)this.ba * 0.7, 0.0);
    }

    public void a(PacketPlayOutSpawnEntity packet) {
        int i2 = packet.b();
        double d0 = packet.d();
        double d1 = packet.e();
        double d2 = packet.f();
        this.d(d0, d1, d2);
        this.c(d0, d1, d2);
        this.p((float)(packet.j() * 360) / 256.0f);
        this.o((float)(packet.k() * 360) / 256.0f);
        this.e(i2);
        this.a_(packet.c());
    }

    @javax.annotation.Nullable
    public ItemStack dk() {
        return null;
    }

    public void o(boolean inPowderSnow) {
        this.al = inPowderSnow;
    }

    public boolean dl() {
        return !this.ad().a(TagsEntity.i);
    }

    public boolean dm() {
        return (this.al || this.am) && this.dl();
    }

    public float dn() {
        return this.aA;
    }

    public void o(float yaw) {
        if (!Float.isFinite(yaw)) {
            SystemUtils.a("Invalid entity rotation: " + yaw + ", discarding.");
        } else {
            this.aA = yaw;
        }
    }

    public float do() {
        return this.aB;
    }

    public void p(float pitch) {
        if (!Float.isFinite(pitch)) {
            SystemUtils.a("Invalid entity rotation: " + pitch + ", discarding.");
        } else {
            this.aB = pitch;
        }
    }

    public final boolean dp() {
        return this.aD != null;
    }

    @javax.annotation.Nullable
    public RemovalReason dq() {
        return this.aD;
    }

    @Override
    public final void b(RemovalReason reason) {
        if (this.aD == null) {
            this.aD = reason;
        }
        if (this.aD.a()) {
            this.p();
        }
        this.cF().forEach(Entity::p);
        this.aR.a(reason);
    }

    public void dr() {
        this.aD = null;
    }

    @Override
    public void a(EntityInLevelCallback changeListener) {
        this.aR = changeListener;
    }

    @Override
    public boolean ds() {
        return this.aD != null && !this.aD.b() ? false : (this.bF() ? false : !this.bG() || !this.cK());
    }

    @Override
    public boolean dt() {
        return false;
    }

    public boolean a(net.minecraft.world.level.World world, BlockPosition pos) {
        return true;
    }

    public net.minecraft.world.level.World W() {
        return this.s;
    }

    public static int nextEntityId() {
        return c.incrementAndGet();
    }

    public boolean isTicking() {
        return ((ChunkProviderServer)this.s.K()).isPositionTicking(this);
    }

    public static enum RemovalReason {
        a(true, false),
        b(true, false),
        c(false, true),
        d(false, false),
        e(false, false);

        private final boolean f;
        private final boolean g;

        private RemovalReason(boolean flag, boolean flag1) {
            this.f = flag;
            this.g = flag1;
        }

        public boolean a() {
            return this.f;
        }

        public boolean b() {
            return this.g;
        }
    }

    public static enum MovementEmission {
        a(false, false),
        b(true, false),
        c(false, true),
        d(true, true);

        final boolean e;
        final boolean f;

        private MovementEmission(boolean flag, boolean flag1) {
            this.e = flag;
            this.f = flag1;
        }

        public boolean a() {
            return this.f || this.e;
        }

        public boolean b() {
            return this.f;
        }

        public boolean c() {
            return this.e;
        }
    }

    @FunctionalInterface
    public static interface MoveFunction {
        public void accept(Entity var1, double var2, double var4, double var6);
    }
}

