/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.effect;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.IRegistry;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketPlayOutUpdateHealth;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInfo;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeMapBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.EntityHuman;
import org.bukkit.craftbukkit.v1_18_R2.event.CraftEventFactory;
import org.bukkit.event.entity.EntityExhaustionEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;

public class MobEffectList {
    private final Map<AttributeBase, AttributeModifier> a = Maps.newHashMap();
    private final MobEffectInfo b;
    private final int c;
    @Nullable
    private String d;

    @Nullable
    public static MobEffectList a(int rawId) {
        return (MobEffectList)IRegistry.T.a(rawId);
    }

    public static int a(MobEffectList type) {
        return IRegistry.T.a(type);
    }

    protected MobEffectList(MobEffectInfo category, int color) {
        this.b = category;
        this.c = color;
    }

    public void a(EntityLiving entity, int amplifier) {
        if (this == MobEffects.j) {
            if (entity.ea() < entity.em()) {
                entity.heal(1.0f, EntityRegainHealthEvent.RegainReason.MAGIC_REGEN);
            }
        } else if (this == MobEffects.s) {
            if (entity.ea() > 1.0f) {
                entity.a(CraftEventFactory.POISON, 1.0f);
            }
        } else if (this == MobEffects.t) {
            entity.a(DamageSource.p, 1.0f);
        } else if (this == MobEffects.q && entity instanceof EntityHuman) {
            ((EntityHuman)entity).causeFoodExhaustion(0.005f * (float)(amplifier + 1), EntityExhaustionEvent.ExhaustionReason.HUNGER_EFFECT);
        } else if (this == MobEffects.w && entity instanceof EntityHuman) {
            if (!entity.s.x) {
                EntityHuman entityhuman = (EntityHuman)entity;
                int oldFoodLevel = entityhuman.fA().a;
                FoodLevelChangeEvent event = CraftEventFactory.callFoodLevelChangeEvent(entityhuman, amplifier + 1 + oldFoodLevel);
                if (!event.isCancelled()) {
                    entityhuman.fA().a(event.getFoodLevel() - oldFoodLevel, 1.0f);
                }
                ((EntityPlayer)entityhuman).b.a(new PacketPlayOutUpdateHealth(((EntityPlayer)entityhuman).getBukkitEntity().getScaledHealth(), entityhuman.fA().a, entityhuman.fA().b));
            }
        } else if (!(this == MobEffects.f && !entity.dZ() || this == MobEffects.g && entity.dZ())) {
            if (this == MobEffects.g && !entity.dZ() || this == MobEffects.f && entity.dZ()) {
                entity.a(DamageSource.o, (float)(6 << amplifier));
            }
        } else {
            entity.heal(Math.max(4 << amplifier, 0), EntityRegainHealthEvent.RegainReason.MAGIC);
        }
    }

    public void a(@Nullable Entity source, @Nullable Entity attacker, EntityLiving target, int amplifier, double proximity) {
        if (!(this == MobEffects.f && !target.dZ() || this == MobEffects.g && target.dZ())) {
            if (!(this == MobEffects.g && !target.dZ() || this == MobEffects.f && target.dZ())) {
                this.a(target, amplifier);
            } else {
                int j2 = (int)(proximity * (double)(6 << amplifier) + 0.5);
                if (source == null) {
                    target.a(DamageSource.o, (float)j2);
                } else {
                    target.a(DamageSource.c(source, attacker), (float)j2);
                }
            }
        } else {
            int j3 = (int)(proximity * (double)(4 << amplifier) + 0.5);
            target.heal(j3, EntityRegainHealthEvent.RegainReason.MAGIC);
        }
    }

    public boolean a(int duration, int amplifier) {
        if (this == MobEffects.j) {
            int k2 = 50 >> amplifier;
            return k2 > 0 ? duration % k2 == 0 : true;
        }
        if (this == MobEffects.s) {
            int k3 = 25 >> amplifier;
            return k3 > 0 ? duration % k3 == 0 : true;
        }
        if (this == MobEffects.t) {
            int k4 = 40 >> amplifier;
            return k4 > 0 ? duration % k4 == 0 : true;
        }
        return this == MobEffects.q;
    }

    public boolean a() {
        return false;
    }

    protected String b() {
        if (this.d == null) {
            this.d = SystemUtils.a("effect", IRegistry.T.b(this));
        }
        return this.d;
    }

    public String c() {
        return this.b();
    }

    public IChatBaseComponent d() {
        return new ChatMessage(this.c());
    }

    public MobEffectInfo e() {
        return this.b;
    }

    public int f() {
        return this.c;
    }

    public MobEffectList a(AttributeBase attribute, String uuid, double amount, AttributeModifier.Operation operation) {
        AttributeModifier attributemodifier = new AttributeModifier(UUID.fromString(uuid), this::c, amount, operation);
        this.a.put(attribute, attributemodifier);
        return this;
    }

    public Map<AttributeBase, AttributeModifier> g() {
        return this.a;
    }

    public void a(EntityLiving entity, AttributeMapBase attributes, int amplifier) {
        for (Map.Entry<AttributeBase, AttributeModifier> entry : this.a.entrySet()) {
            AttributeModifiable attributemodifiable = attributes.a(entry.getKey());
            if (attributemodifiable == null) continue;
            attributemodifiable.d(entry.getValue());
        }
    }

    public void b(EntityLiving entity, AttributeMapBase attributes, int amplifier) {
        for (Map.Entry<AttributeBase, AttributeModifier> entry : this.a.entrySet()) {
            AttributeModifiable attributemodifiable = attributes.a(entry.getKey());
            if (attributemodifiable == null) continue;
            AttributeModifier attributemodifier = entry.getValue();
            attributemodifiable.d(attributemodifier);
            attributemodifiable.c(new AttributeModifier(attributemodifier.a(), this.c() + " " + amplifier, this.a(amplifier, attributemodifier), attributemodifier.c()));
        }
    }

    public double a(int amplifier, AttributeModifier modifier) {
        return modifier.d() * (double)(amplifier + 1);
    }

    public boolean h() {
        return this.b == MobEffectInfo.a;
    }
}

