/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.thread;

import com.mojang.logging.LogUtils;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;

public class NamedThreadFactory
implements ThreadFactory {
    private static final Logger a = LogUtils.getLogger();
    private final ThreadGroup b;
    private final AtomicInteger c = new AtomicInteger(1);
    private final String d;

    public NamedThreadFactory(String name) {
        SecurityManager securityManager = System.getSecurityManager();
        this.b = securityManager != null ? securityManager.getThreadGroup() : Thread.currentThread().getThreadGroup();
        this.d = name + "-";
    }

    @Override
    @Override
    public Thread newThread(Runnable runnable) {
        Thread thread2 = new Thread(this.b, runnable, this.d + this.c.getAndIncrement(), 0L);
        thread2.setUncaughtExceptionHandler((thread, throwable) -> {
            a.error("Caught exception in thread {} from {}", (Object)thread, (Object)runnable);
            a.error("", throwable);
        });
        if (thread2.getPriority() != 5) {
            thread2.setPriority(5);
        }
        return thread2;
    }
}

