/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.random;

import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.SystemUtils;
import net.minecraft.util.random.WeightedEntry;

public class WeightedRandom2 {
    private WeightedRandom2() {
    }

    public static int a(List<? extends WeightedEntry> pool) {
        long l2 = 0L;
        for (WeightedEntry weightedEntry : pool) {
            l2 += (long)weightedEntry.a().a();
        }
        if (l2 > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Sum of weights must be <= 2147483647");
        }
        return (int)l2;
    }

    public static <T extends WeightedEntry> Optional<T> a(Random random, List<T> pool, int totalWeight) {
        if (totalWeight < 0) {
            throw SystemUtils.c(new IllegalArgumentException("Negative total weight in getRandomItem"));
        }
        if (totalWeight == 0) {
            return Optional.empty();
        }
        int i2 = random.nextInt(totalWeight);
        return WeightedRandom2.a(pool, i2);
    }

    public static <T extends WeightedEntry> Optional<T> a(List<T> pool, int totalWeight) {
        for (WeightedEntry weightedEntry : pool) {
            if ((totalWeight -= weightedEntry.a().a()) >= 0) continue;
            return Optional.of(weightedEntry);
        }
        return Optional.empty();
    }

    public static <T extends WeightedEntry> Optional<T> a(Random random, List<T> pool) {
        return WeightedRandom2.a(random, pool, WeightedRandom2.a(pool));
    }
}

