/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.profiling.jfr.stats;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.time.Duration;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import jdk.jfr.consumer.RecordedEvent;
import net.minecraft.network.EnumProtocol;
import net.minecraft.network.protocol.EnumProtocolDirection;
import net.minecraft.network.protocol.Packet;

public final class NetworkPacketSummary {
    private final a a;
    private final List<Pair<b, a>> b;
    private final Duration c;

    public NetworkPacketSummary(Duration duration, List<Pair<b, a>> packetsToStatistics) {
        this.c = duration;
        this.a = packetsToStatistics.stream().map(Pair::getSecond).reduce(a::a).orElseGet(() -> new a(0L, 0L));
        this.b = packetsToStatistics.stream().sorted(Comparator.comparing(Pair::getSecond, net.minecraft.util.profiling.jfr.stats.NetworkPacketSummary$a.c)).limit(10L).toList();
    }

    public double a() {
        return (double)this.a.a / (double)this.c.getSeconds();
    }

    public double b() {
        return (double)this.a.b / (double)this.c.getSeconds();
    }

    public long c() {
        return this.a.a;
    }

    public long d() {
        return this.a.b;
    }

    public List<Pair<b, a>> e() {
        return this.b;
    }

    public record a(long a, long b) {
        static final Comparator<a> c = Comparator.comparing(a::b).thenComparing(a::a).reversed();

        a a(a statistics) {
            return new a(this.a + statistics.a, this.b + statistics.b);
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "totalCount;totalSize", "a", "b"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "totalCount;totalSize", "a", "b"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "totalCount;totalSize", "a", "b"}, this, object);
        }
    }

    public record b(EnumProtocolDirection a, int b, int c) {
        private final EnumProtocolDirection a;
        private final int b;
        private final int c;
        private static final Map<b, String> d;

        public String a() {
            return d.getOrDefault(this, "unknown");
        }

        public static b a(RecordedEvent event) {
            return new b(event.getEventType().getName().equals("minecraft.PacketSent") ? EnumProtocolDirection.b : EnumProtocolDirection.a, event.getInt("protocolId"), event.getInt("packetId"));
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "direction;protocolId;packetId", "a", "b", "c"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "direction;protocolId;packetId", "a", "b", "c"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "direction;protocolId;packetId", "a", "b", "c"}, this, object);
        }

        public EnumProtocolDirection b() {
            return this.a;
        }

        public int c() {
            return this.b;
        }

        public int d() {
            return this.c;
        }

        static {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (EnumProtocol connectionProtocol : EnumProtocol.values()) {
                for (EnumProtocolDirection packetFlow : EnumProtocolDirection.values()) {
                    Int2ObjectMap<Class<? extends Packet<?>>> int2ObjectMap = connectionProtocol.a(packetFlow);
                    int2ObjectMap.forEach((packetId, clazz) -> builder.put((Object)new b(packetFlow, connectionProtocol.a(), (int)packetId), (Object)clazz.getSimpleName()));
                }
            }
            d = builder.build();
        }
    }
}

