/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.profiling;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongMaps;
import java.io.BufferedWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.util.profiling.MethodProfilerResult;
import net.minecraft.util.profiling.MethodProfilerResults;
import net.minecraft.util.profiling.MethodProfilerResultsField;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;

public class MethodProfilerResultsFilled
implements MethodProfilerResults {
    private static final Logger a = LogUtils.getLogger();
    private static final MethodProfilerResult b = new MethodProfilerResult(){

        @Override
        @Override
        public long a() {
            return 0L;
        }

        @Override
        @Override
        public long b() {
            return 0L;
        }

        @Override
        @Override
        public long c() {
            return 0L;
        }

        @Override
        @Override
        public Object2LongMap<String> d() {
            return Object2LongMaps.emptyMap();
        }
    };
    private static final Splitter c = Splitter.on((char)'\u001e');
    private static final Comparator<Map.Entry<String, a>> e = Map.Entry.comparingByValue(Comparator.comparingLong(counterCollector -> counterCollector.b)).reversed();
    private final Map<String, ? extends MethodProfilerResult> f;
    private final long g;
    private final int h;
    private final long i;
    private final int j;
    private final int k;

    public MethodProfilerResultsFilled(Map<String, ? extends MethodProfilerResult> locationInfos, long startTime, int startTick, long endTime, int endTick) {
        this.f = locationInfos;
        this.g = startTime;
        this.h = startTick;
        this.i = endTime;
        this.j = endTick;
        this.k = endTick - startTick;
    }

    private MethodProfilerResult c(String path) {
        MethodProfilerResult profilerPathEntry = this.f.get(path);
        return profilerPathEntry != null ? profilerPathEntry : b;
    }

    @Override
    @Override
    public List<MethodProfilerResultsField> a(String parentPath) {
        String string = parentPath;
        MethodProfilerResult profilerPathEntry = this.c("root");
        long l2 = profilerPathEntry.a();
        MethodProfilerResult profilerPathEntry2 = this.c((String)parentPath);
        long m2 = profilerPathEntry2.a();
        long n2 = profilerPathEntry2.c();
        ArrayList list = Lists.newArrayList();
        if (!((String)parentPath).isEmpty()) {
            parentPath = (String)parentPath + "\u001e";
        }
        long o2 = 0L;
        for (String string2 : this.f.keySet()) {
            if (!MethodProfilerResultsFilled.a((String)parentPath, string2)) continue;
            o2 += this.c(string2).a();
        }
        float f2 = o2;
        if (o2 < m2) {
            o2 = m2;
        }
        if (l2 < o2) {
            l2 = o2;
        }
        for (String string3 : this.f.keySet()) {
            if (!MethodProfilerResultsFilled.a((String)parentPath, string3)) continue;
            MethodProfilerResult profilerPathEntry3 = this.c(string3);
            long p2 = profilerPathEntry3.a();
            double d2 = (double)p2 * 100.0 / (double)o2;
            double e2 = (double)p2 * 100.0 / (double)l2;
            String string4 = string3.substring(((String)parentPath).length());
            list.add(new MethodProfilerResultsField(string4, d2, e2, profilerPathEntry3.c()));
        }
        if ((float)o2 > f2) {
            list.add(new MethodProfilerResultsField("unspecified", (double)((float)o2 - f2) * 100.0 / (double)o2, (double)((float)o2 - f2) * 100.0 / (double)l2, n2));
        }
        Collections.sort(list);
        list.add(0, new MethodProfilerResultsField(string, 100.0, (double)o2 * 100.0 / (double)l2, n2));
        return list;
    }

    private static boolean a(String parent, String path) {
        return path.length() > parent.length() && path.startsWith(parent) && path.indexOf(30, parent.length() + 1) < 0;
    }

    private Map<String, a> h() {
        TreeMap map = Maps.newTreeMap();
        this.f.forEach((location, info) -> {
            Object2LongMap<String> object2LongMap = info.d();
            if (!object2LongMap.isEmpty()) {
                List list = c.splitToList((CharSequence)location);
                object2LongMap.forEach((marker, count) -> map.computeIfAbsent(marker, k2 -> new a()).a(list.iterator(), (long)count));
            }
        });
        return map;
    }

    @Override
    @Override
    public long a() {
        return this.g;
    }

    @Override
    @Override
    public int b() {
        return this.h;
    }

    @Override
    @Override
    public long c() {
        return this.i;
    }

    @Override
    @Override
    public int d() {
        return this.j;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Override
    public boolean a(Path path) {
        boolean bl;
        BufferedWriter writer = null;
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            writer = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);
            writer.write(this.a(this.g(), this.f()));
            bl = true;
        }
        catch (Throwable throwable) {
            boolean bl2;
            try {
                a.error("Could not save profiler results to {}", (Object)path, (Object)throwable);
                bl2 = false;
            }
            catch (Throwable throwable2) {
                IOUtils.closeQuietly(writer);
                throw throwable2;
            }
            IOUtils.closeQuietly((Writer)writer);
            return bl2;
        }
        IOUtils.closeQuietly((Writer)writer);
        return bl;
    }

    protected String a(long timeSpan, int tickSpan) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("---- Minecraft Profiler Results ----\n");
        stringBuilder.append("// ");
        stringBuilder.append(MethodProfilerResultsFilled.i());
        stringBuilder.append("\n\n");
        stringBuilder.append("Version: ").append(SharedConstants.b().getId()).append('\n');
        stringBuilder.append("Time span: ").append(timeSpan / 1000000L).append(" ms\n");
        stringBuilder.append("Tick span: ").append(tickSpan).append(" ticks\n");
        stringBuilder.append("// This is approximately ").append(String.format(Locale.ROOT, "%.2f", Float.valueOf((float)tickSpan / ((float)timeSpan / 1.0E9f)))).append(" ticks per second. It should be ").append(20).append(" ticks per second\n\n");
        stringBuilder.append("--- BEGIN PROFILE DUMP ---\n\n");
        this.a(0, "root", stringBuilder);
        stringBuilder.append("--- END PROFILE DUMP ---\n\n");
        Map<String, a> map = this.h();
        if (!map.isEmpty()) {
            stringBuilder.append("--- BEGIN COUNTER DUMP ---\n\n");
            this.a(map, stringBuilder, tickSpan);
            stringBuilder.append("--- END COUNTER DUMP ---\n\n");
        }
        return stringBuilder.toString();
    }

    @Override
    @Override
    public String e() {
        StringBuilder stringBuilder = new StringBuilder();
        this.a(0, "root", stringBuilder);
        return stringBuilder.toString();
    }

    private static StringBuilder a(StringBuilder sb, int size) {
        sb.append(String.format("[%02d] ", size));
        for (int i2 = 0; i2 < size; ++i2) {
            sb.append("|   ");
        }
        return sb;
    }

    private void a(int level, String name, StringBuilder sb) {
        List<MethodProfilerResultsField> list = this.a(name);
        Object2LongMap<String> object2LongMap = ((MethodProfilerResult)ObjectUtils.firstNonNull((Object[])new MethodProfilerResult[]{this.f.get(name), b})).d();
        object2LongMap.forEach((marker, count) -> MethodProfilerResultsFilled.a(sb, level).append('#').append((String)marker).append(' ').append(count).append('/').append(count / (long)this.k).append('\n'));
        if (list.size() < 3) {
            return;
        }
        for (int i2 = 1; i2 < list.size(); ++i2) {
            MethodProfilerResultsField resultField = list.get(i2);
            MethodProfilerResultsFilled.a(sb, level).append(resultField.d).append('(').append(resultField.c).append('/').append(String.format(Locale.ROOT, "%.0f", Float.valueOf((float)resultField.c / (float)this.k))).append(')').append(" - ").append(String.format(Locale.ROOT, "%.2f", resultField.a)).append("%/").append(String.format(Locale.ROOT, "%.2f", resultField.b)).append("%\n");
            if ("unspecified".equals(resultField.d)) continue;
            try {
                this.a(level + 1, name + "\u001e" + resultField.d, sb);
                continue;
            }
            catch (Exception exception) {
                sb.append("[[ EXCEPTION ").append(exception).append(" ]]");
            }
        }
    }

    private void a(int depth, String name, a info, int tickSpan, StringBuilder sb) {
        MethodProfilerResultsFilled.a(sb, depth).append(name).append(" total:").append(info.a).append('/').append(info.b).append(" average: ").append(info.a / (long)tickSpan).append('/').append(info.b / (long)tickSpan).append('\n');
        info.c.entrySet().stream().sorted(e).forEach(entry -> this.a(depth + 1, (String)entry.getKey(), (a)entry.getValue(), tickSpan, sb));
    }

    private void a(Map<String, a> counters, StringBuilder sb, int tickSpan) {
        counters.forEach((name, info) -> {
            sb.append("-- Counter: ").append((String)name).append(" --\n");
            this.a(0, "root", info.c.get("root"), tickSpan, sb);
            sb.append("\n\n");
        });
    }

    private static String i() {
        String[] strings = new String[]{"I'd Rather Be Surfing", "Shiny numbers!", "Am I not running fast enough? :(", "I'm working as hard as I can!", "Will I ever be good enough for you? :(", "Speedy. Zoooooom!", "Hello world", "40% better than a crash report.", "Now with extra numbers", "Now with less numbers", "Now with the same numbers", "You should add flames to things, it makes them go faster!", "Do you feel the need for... optimization?", "*cracks redstone whip*", "Maybe if you treated it better then it'll have more motivation to work faster! Poor server."};
        try {
            return strings[(int)(SystemUtils.c() % (long)strings.length)];
        }
        catch (Throwable throwable) {
            return "Witty comment unavailable :(";
        }
    }

    @Override
    @Override
    public int f() {
        return this.k;
    }

    static class a {
        long a;
        long b;
        final Map<String, a> c = Maps.newHashMap();

        a() {
        }

        public void a(Iterator<String> pathIterator, long time) {
            this.b += time;
            if (!pathIterator.hasNext()) {
                this.a += time;
            } else {
                this.c.computeIfAbsent(pathIterator.next(), k2 -> new a()).a(pathIterator, time);
            }
        }
    }
}

