/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.profiling;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongMaps;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.util.profiling.GameProfilerFillerActive;
import net.minecraft.util.profiling.MethodProfilerResult;
import net.minecraft.util.profiling.MethodProfilerResults;
import net.minecraft.util.profiling.MethodProfilerResultsFilled;
import net.minecraft.util.profiling.metrics.MetricCategory;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;

public class MethodProfiler
implements GameProfilerFillerActive {
    private static final long a = Duration.ofMillis(100L).toNanos();
    private static final Logger c = LogUtils.getLogger();
    private final List<String> d = Lists.newArrayList();
    private final LongList e = new LongArrayList();
    private final Map<String, a> f = Maps.newHashMap();
    private final IntSupplier g;
    private final LongSupplier h;
    private final long i;
    private final int j;
    private String k = "";
    private boolean l;
    @Nullable
    private a m;
    private final boolean n;
    private final Set<Pair<String, MetricCategory>> o = new ObjectArraySet();

    public MethodProfiler(LongSupplier timeGetter, IntSupplier tickGetter, boolean checkTimeout) {
        this.i = timeGetter.getAsLong();
        this.h = timeGetter;
        this.j = tickGetter.getAsInt();
        this.g = tickGetter;
        this.n = checkTimeout;
    }

    @Override
    @Override
    public void a() {
        if (this.l) {
            c.error("Profiler tick already started - missing endTick()?");
            return;
        }
        this.l = true;
        this.k = "";
        this.d.clear();
        this.a("root");
    }

    @Override
    @Override
    public void b() {
        if (!this.l) {
            c.error("Profiler tick already ended - missing startTick()?");
            return;
        }
        this.c();
        this.l = false;
        if (!this.k.isEmpty()) {
            c.error("Profiler tick ended before path was fully popped (remainder: '{}'). Mismatched push/pop?", LogUtils.defer(() -> MethodProfilerResults.b(this.k)));
        }
    }

    @Override
    @Override
    public void a(String location) {
        if (!this.l) {
            c.error("Cannot push '{}' to profiler if profiler tick hasn't started - missing startTick()?", (Object)location);
            return;
        }
        if (!this.k.isEmpty()) {
            this.k = this.k + "\u001e";
        }
        this.k = this.k + location;
        this.d.add(this.k);
        this.e.add(SystemUtils.c());
        this.m = null;
    }

    @Override
    @Override
    public void a(Supplier<String> locationGetter) {
        this.a(locationGetter.get());
    }

    @Override
    @Override
    public void a(MetricCategory type) {
        this.o.add((Pair<String, MetricCategory>)Pair.of((Object)this.k, (Object)((Object)type)));
    }

    @Override
    @Override
    public void c() {
        if (!this.l) {
            c.error("Cannot pop from profiler if profiler tick hasn't started - missing startTick()?");
            return;
        }
        if (this.e.isEmpty()) {
            c.error("Tried to pop one too many times! Mismatched push() and pop()?");
            return;
        }
        long l2 = SystemUtils.c();
        long m2 = this.e.removeLong(this.e.size() - 1);
        this.d.remove(this.d.size() - 1);
        long n2 = l2 - m2;
        a pathEntry = this.f();
        pathEntry.c += n2;
        ++pathEntry.d;
        pathEntry.a = Math.max(pathEntry.a, n2);
        pathEntry.b = Math.min(pathEntry.b, n2);
        if (this.n && n2 > a) {
            c.warn("Something's taking too long! '{}' took aprox {} ms", LogUtils.defer(() -> MethodProfilerResults.b(this.k)), LogUtils.defer(() -> (double)n2 / 1000000.0));
        }
        this.k = this.d.isEmpty() ? "" : this.d.get(this.d.size() - 1);
        this.m = null;
    }

    @Override
    @Override
    public void b(String location) {
        this.c();
        this.a(location);
    }

    @Override
    @Override
    public void b(Supplier<String> locationGetter) {
        this.c();
        this.a(locationGetter);
    }

    private a f() {
        if (this.m == null) {
            this.m = this.f.computeIfAbsent(this.k, k2 -> new a());
        }
        return this.m;
    }

    @Override
    @Override
    public void a(String marker, int i2) {
        this.f().e.addTo((Object)marker, (long)i2);
    }

    @Override
    @Override
    public void a(Supplier<String> markerGetter, int i2) {
        this.f().e.addTo((Object)markerGetter.get(), (long)i2);
    }

    @Override
    @Override
    public MethodProfilerResults d() {
        return new MethodProfilerResultsFilled(this.f, this.i, this.j, this.h.getAsLong(), this.g.getAsInt());
    }

    @Override
    @Nullable
    @Override
    public a c(String name) {
        return this.f.get(name);
    }

    @Override
    @Override
    public Set<Pair<String, MetricCategory>> e() {
        return this.o;
    }

    public static class a
    implements MethodProfilerResult {
        long a = Long.MIN_VALUE;
        long b = Long.MAX_VALUE;
        long c;
        long d;
        final Object2LongOpenHashMap<String> e = new Object2LongOpenHashMap();

        @Override
        @Override
        public long a() {
            return this.c;
        }

        @Override
        @Override
        public long b() {
            return this.a;
        }

        @Override
        @Override
        public long c() {
            return this.d;
        }

        @Override
        @Override
        public Object2LongMap<String> d() {
            return Object2LongMaps.unmodifiable(this.e);
        }
    }
}

