/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.Dynamic;
import java.util.List;
import java.util.Optional;
import net.minecraft.util.datafix.fixes.DataConverterTypes;

public class OverreachingTickFix
extends DataFix {
    public OverreachingTickFix(Schema schema) {
        super(schema, false);
    }

    protected TypeRewriteRule makeRule() {
        Type type = this.getInputSchema().getType(DataConverterTypes.c);
        OpticFinder opticFinder = type.findField("block_ticks");
        return this.fixTypeEverywhereTyped("Handle ticks saved in the wrong chunk", type, typed -> {
            Optional optional = typed.getOptionalTyped(opticFinder);
            Optional optional2 = optional.isPresent() ? ((Typed)optional.get()).write().result() : Optional.empty();
            return typed.update(DSL.remainderFinder(), dynamic -> {
                int i2 = dynamic.get("xPos").asInt(0);
                int j2 = dynamic.get("zPos").asInt(0);
                Optional optional2 = dynamic.get("fluid_ticks").get().result();
                dynamic = OverreachingTickFix.a(dynamic, i2, j2, optional2, "neighbor_block_ticks");
                dynamic = OverreachingTickFix.a(dynamic, i2, j2, optional2, "neighbor_fluid_ticks");
                return dynamic;
            });
        });
    }

    private static Dynamic<?> a(Dynamic<?> dynamic2, int i2, int j2, Optional<? extends Dynamic<?>> optional, String string) {
        List<Dynamic> list;
        if (optional.isPresent() && !(list = optional.get().asStream().filter(dynamic -> {
            int k2 = dynamic.get("x").asInt(0);
            int l2 = dynamic.get("z").asInt(0);
            int m2 = Math.abs(i2 - (k2 >> 4));
            int n2 = Math.abs(j2 - (l2 >> 4));
            return (m2 != 0 || n2 != 0) && m2 <= 1 && n2 <= 1;
        }).toList()).isEmpty()) {
            dynamic2 = dynamic2.set("UpgradeData", dynamic2.get("UpgradeData").orElseEmptyMap().set(string, dynamic2.createList(list.stream())));
        }
        return dynamic2;
    }
}

