/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicLike;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.OptionalDynamic;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableInt;

public class DataConverterWorldGenSettingsBuilding
extends DataFix {
    private static final String a = "minecraft:village";
    private static final String b = "minecraft:desert_pyramid";
    private static final String c = "minecraft:igloo";
    private static final String d = "minecraft:jungle_pyramid";
    private static final String e = "minecraft:swamp_hut";
    private static final String f = "minecraft:pillager_outpost";
    private static final String g = "minecraft:endcity";
    private static final String h = "minecraft:mansion";
    private static final String i = "minecraft:monument";
    private static final ImmutableMap<String, a> j = ImmutableMap.builder().put((Object)"minecraft:village", (Object)new a(32, 8, 10387312)).put((Object)"minecraft:desert_pyramid", (Object)new a(32, 8, 14357617)).put((Object)"minecraft:igloo", (Object)new a(32, 8, 14357618)).put((Object)"minecraft:jungle_pyramid", (Object)new a(32, 8, 14357619)).put((Object)"minecraft:swamp_hut", (Object)new a(32, 8, 14357620)).put((Object)"minecraft:pillager_outpost", (Object)new a(32, 8, 165745296)).put((Object)"minecraft:monument", (Object)new a(32, 5, 10387313)).put((Object)"minecraft:endcity", (Object)new a(20, 11, 10387313)).put((Object)"minecraft:mansion", (Object)new a(80, 20, 10387319)).build();

    public DataConverterWorldGenSettingsBuilding(Schema outputSchema) {
        super(outputSchema, true);
    }

    protected TypeRewriteRule makeRule() {
        return this.fixTypeEverywhereTyped("WorldGenSettings building", this.getInputSchema().getType(DataConverterTypes.z), typed -> typed.update(DSL.remainderFinder(), DataConverterWorldGenSettingsBuilding::a));
    }

    private static <T> Dynamic<T> a(long l2, DynamicLike<T> dynamicLike, Dynamic<T> dynamic, Dynamic<T> dynamic2) {
        return dynamicLike.createMap((Map)ImmutableMap.of((Object)((Object)dynamicLike.createString("type")), (Object)((Object)dynamicLike.createString("minecraft:noise")), (Object)((Object)dynamicLike.createString("biome_source")), dynamic2, (Object)((Object)dynamicLike.createString("seed")), (Object)((Object)dynamicLike.createLong(l2)), (Object)((Object)dynamicLike.createString("settings")), dynamic));
    }

    private static <T> Dynamic<T> a(Dynamic<T> dynamic, long l2, boolean bl, boolean bl2) {
        ImmutableMap.Builder builder = ImmutableMap.builder().put((Object)dynamic.createString("type"), (Object)dynamic.createString("minecraft:vanilla_layered")).put((Object)dynamic.createString("seed"), (Object)dynamic.createLong(l2)).put((Object)dynamic.createString("large_biomes"), (Object)dynamic.createBoolean(bl2));
        if (bl) {
            builder.put((Object)dynamic.createString("legacy_biome_init_layer"), (Object)dynamic.createBoolean(bl));
        }
        return dynamic.createMap((Map)builder.build());
    }

    private static <T> Dynamic<T> a(Dynamic<T> dynamic2) {
        Dynamic<T> dynamic13;
        DynamicOps dynamicOps = dynamic2.getOps();
        long l2 = dynamic2.get("RandomSeed").asLong(0L);
        Optional optional = dynamic2.get("generatorName").asString().map(string -> string.toLowerCase(Locale.ROOT)).result();
        Optional optional2 = dynamic2.get("legacy_custom_options").asString().result().map(Optional::of).orElseGet(() -> {
            if (optional.equals(Optional.of("customized"))) {
                return dynamic2.get("generatorOptions").asString().result();
            }
            return Optional.empty();
        });
        boolean bl = false;
        if (optional.equals(Optional.of("customized"))) {
            Dynamic<T> dynamic22 = DataConverterWorldGenSettingsBuilding.a(dynamic2, l2);
        } else if (!optional.isPresent()) {
            Dynamic<T> dynamic3 = DataConverterWorldGenSettingsBuilding.a(dynamic2, l2);
        } else {
            switch ((String)optional.get()) {
                case "flat": {
                    OptionalDynamic<T> optionalDynamic = dynamic2.get("generatorOptions");
                    Map<Dynamic<T>, Dynamic<T>> map = DataConverterWorldGenSettingsBuilding.a(dynamicOps, optionalDynamic);
                    Dynamic dynamic4 = dynamic2.createMap((Map)ImmutableMap.of((Object)((Object)dynamic2.createString("type")), (Object)((Object)dynamic2.createString("minecraft:flat")), (Object)((Object)dynamic2.createString("settings")), (Object)((Object)dynamic2.createMap((Map)ImmutableMap.of((Object)((Object)dynamic2.createString("structures")), (Object)((Object)dynamic2.createMap(map)), (Object)((Object)dynamic2.createString("layers")), (Object)((Object)optionalDynamic.get("layers").result().orElseGet(() -> dynamic2.createList(Stream.of(dynamic2.createMap((Map)ImmutableMap.of((Object)((Object)dynamic2.createString("height")), (Object)((Object)dynamic2.createInt(1)), (Object)((Object)dynamic2.createString("block")), (Object)((Object)dynamic2.createString("minecraft:bedrock")))), dynamic2.createMap((Map)ImmutableMap.of((Object)((Object)dynamic2.createString("height")), (Object)((Object)dynamic2.createInt(2)), (Object)((Object)dynamic2.createString("block")), (Object)((Object)dynamic2.createString("minecraft:dirt")))), dynamic2.createMap((Map)ImmutableMap.of((Object)((Object)dynamic2.createString("height")), (Object)((Object)dynamic2.createInt(1)), (Object)((Object)dynamic2.createString("block")), (Object)((Object)dynamic2.createString("minecraft:grass_block")))))))), (Object)((Object)dynamic2.createString("biome")), (Object)((Object)dynamic2.createString(optionalDynamic.get("biome").asString("minecraft:plains"))))))));
                    break;
                }
                case "debug_all_block_states": {
                    Dynamic dynamic5 = dynamic2.createMap((Map)ImmutableMap.of((Object)((Object)dynamic2.createString("type")), (Object)((Object)dynamic2.createString("minecraft:debug"))));
                    break;
                }
                case "buffet": {
                    Dynamic dynamic11;
                    Dynamic dynamic8;
                    OptionalDynamic<T> optionalDynamic2 = dynamic2.get("generatorOptions");
                    OptionalDynamic optionalDynamic3 = optionalDynamic2.get("chunk_generator");
                    Optional optional3 = optionalDynamic3.get("type").asString().result();
                    if (Objects.equals(optional3, Optional.of("minecraft:caves"))) {
                        Dynamic dynamic6 = dynamic2.createString("minecraft:caves");
                        bl = true;
                    } else if (Objects.equals(optional3, Optional.of("minecraft:floating_islands"))) {
                        Dynamic dynamic7 = dynamic2.createString("minecraft:floating_islands");
                    } else {
                        dynamic8 = dynamic2.createString("minecraft:overworld");
                    }
                    Dynamic dynamic9 = optionalDynamic2.get("biome_source").result().orElseGet(() -> dynamic2.createMap((Map)ImmutableMap.of((Object)((Object)dynamic2.createString("type")), (Object)((Object)dynamic2.createString("minecraft:fixed")))));
                    if (dynamic9.get("type").asString().result().equals(Optional.of("minecraft:fixed"))) {
                        String string2 = dynamic9.get("options").get("biomes").asStream().findFirst().flatMap(dynamic -> dynamic.asString().result()).orElse("minecraft:ocean");
                        Dynamic dynamic10 = dynamic9.remove("options").set("biome", dynamic2.createString(string2));
                    } else {
                        dynamic11 = dynamic9;
                    }
                    Dynamic<T> dynamic12 = DataConverterWorldGenSettingsBuilding.a(l2, dynamic2, dynamic8, dynamic11);
                    break;
                }
                default: {
                    boolean bl2 = ((String)optional.get()).equals("default");
                    boolean bl3 = ((String)optional.get()).equals("default_1_1") || bl2 && dynamic2.get("generatorVersion").asInt(0) == 0;
                    boolean bl4 = ((String)optional.get()).equals("amplified");
                    boolean bl5 = ((String)optional.get()).equals("largebiomes");
                    dynamic13 = DataConverterWorldGenSettingsBuilding.a(l2, dynamic2, dynamic2.createString(bl4 ? "minecraft:amplified" : "minecraft:overworld"), DataConverterWorldGenSettingsBuilding.a(dynamic2, l2, bl3, bl5));
                }
            }
        }
        boolean bl6 = dynamic2.get("MapFeatures").asBoolean(true);
        boolean bl7 = dynamic2.get("BonusChest").asBoolean(false);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put(dynamicOps.createString("seed"), dynamicOps.createLong(l2));
        builder.put(dynamicOps.createString("generate_features"), dynamicOps.createBoolean(bl6));
        builder.put(dynamicOps.createString("bonus_chest"), dynamicOps.createBoolean(bl7));
        builder.put(dynamicOps.createString("dimensions"), DataConverterWorldGenSettingsBuilding.a(dynamic2, l2, dynamic13, bl));
        optional2.ifPresent(string -> builder.put(dynamicOps.createString("legacy_custom_options"), dynamicOps.createString(string)));
        return new Dynamic<Object>(dynamicOps, dynamicOps.createMap((Map)builder.build()));
    }

    protected static <T> Dynamic<T> a(Dynamic<T> dynamic, long l2) {
        return DataConverterWorldGenSettingsBuilding.a(l2, dynamic, dynamic.createString("minecraft:overworld"), DataConverterWorldGenSettingsBuilding.a(dynamic, l2, false, false));
    }

    protected static <T> T a(Dynamic<T> dynamic, long l2, Dynamic<T> dynamic2, boolean bl) {
        DynamicOps dynamicOps = dynamic.getOps();
        return (T)dynamicOps.createMap((Map)ImmutableMap.of((Object)dynamicOps.createString("minecraft:overworld"), (Object)dynamicOps.createMap((Map)ImmutableMap.of((Object)dynamicOps.createString("type"), (Object)dynamicOps.createString("minecraft:overworld" + (bl ? "_caves" : "")), (Object)dynamicOps.createString("generator"), dynamic2.getValue())), (Object)dynamicOps.createString("minecraft:the_nether"), (Object)dynamicOps.createMap((Map)ImmutableMap.of((Object)dynamicOps.createString("type"), (Object)dynamicOps.createString("minecraft:the_nether"), (Object)dynamicOps.createString("generator"), DataConverterWorldGenSettingsBuilding.a(l2, dynamic, dynamic.createString("minecraft:nether"), dynamic.createMap((Map)ImmutableMap.of((Object)((Object)dynamic.createString("type")), (Object)((Object)dynamic.createString("minecraft:multi_noise")), (Object)((Object)dynamic.createString("seed")), (Object)((Object)dynamic.createLong(l2)), (Object)((Object)dynamic.createString("preset")), (Object)((Object)dynamic.createString("minecraft:nether"))))).getValue())), (Object)dynamicOps.createString("minecraft:the_end"), (Object)dynamicOps.createMap((Map)ImmutableMap.of((Object)dynamicOps.createString("type"), (Object)dynamicOps.createString("minecraft:the_end"), (Object)dynamicOps.createString("generator"), DataConverterWorldGenSettingsBuilding.a(l2, dynamic, dynamic.createString("minecraft:end"), dynamic.createMap((Map)ImmutableMap.of((Object)((Object)dynamic.createString("type")), (Object)((Object)dynamic.createString("minecraft:the_end")), (Object)((Object)dynamic.createString("seed")), (Object)((Object)dynamic.createLong(l2))))).getValue()))));
    }

    private static <T> Map<Dynamic<T>, Dynamic<T>> a(DynamicOps<T> dynamicOps, OptionalDynamic<T> optionalDynamic) {
        MutableInt mutableInt = new MutableInt(32);
        MutableInt mutableInt2 = new MutableInt(3);
        MutableInt mutableInt3 = new MutableInt(128);
        MutableBoolean mutableBoolean = new MutableBoolean(false);
        HashMap map = Maps.newHashMap();
        if (!optionalDynamic.result().isPresent()) {
            mutableBoolean.setTrue();
            map.put(a, (a)j.get((Object)a));
        }
        optionalDynamic.get("structures").flatMap(Dynamic::getMapValues).result().ifPresent(map2 -> map2.forEach((dynamic, dynamic2) -> dynamic2.getMapValues().result().ifPresent(map2 -> map2.forEach((dynamic2, dynamic3) -> {
            String string = dynamic.asString("");
            String string2 = dynamic2.asString("");
            String string3 = dynamic3.asString("");
            if ("stronghold".equals(string)) {
                mutableBoolean.setTrue();
                switch (string2) {
                    case "distance": {
                        mutableInt.setValue(DataConverterWorldGenSettingsBuilding.a(string3, mutableInt.getValue(), 1));
                        return;
                    }
                    case "spread": {
                        mutableInt2.setValue(DataConverterWorldGenSettingsBuilding.a(string3, mutableInt2.getValue(), 1));
                        return;
                    }
                    case "count": {
                        mutableInt3.setValue(DataConverterWorldGenSettingsBuilding.a(string3, mutableInt3.getValue(), 1));
                        return;
                    }
                }
                return;
            }
            switch (string2) {
                case "distance": {
                    switch (string) {
                        case "village": {
                            DataConverterWorldGenSettingsBuilding.a(map, a, string3, 9);
                            return;
                        }
                        case "biome_1": {
                            DataConverterWorldGenSettingsBuilding.a(map, b, string3, 9);
                            DataConverterWorldGenSettingsBuilding.a(map, c, string3, 9);
                            DataConverterWorldGenSettingsBuilding.a(map, d, string3, 9);
                            DataConverterWorldGenSettingsBuilding.a(map, e, string3, 9);
                            DataConverterWorldGenSettingsBuilding.a(map, f, string3, 9);
                            return;
                        }
                        case "endcity": {
                            DataConverterWorldGenSettingsBuilding.a(map, g, string3, 1);
                            return;
                        }
                        case "mansion": {
                            DataConverterWorldGenSettingsBuilding.a(map, h, string3, 1);
                            return;
                        }
                    }
                    return;
                }
                case "separation": {
                    if ("oceanmonument".equals(string)) {
                        a structureFeatureConfiguration = map.getOrDefault(i, (a)j.get((Object)i));
                        int i2 = DataConverterWorldGenSettingsBuilding.a(string3, structureFeatureConfiguration.c, 1);
                        map.put(i, new a(i2, structureFeatureConfiguration.c, structureFeatureConfiguration.d));
                    }
                    return;
                }
                case "spacing": {
                    if ("oceanmonument".equals(string)) {
                        DataConverterWorldGenSettingsBuilding.a(map, i, string3, 1);
                    }
                    return;
                }
            }
        }))));
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)optionalDynamic.createString("structures"), (Object)optionalDynamic.createMap(map.entrySet().stream().collect(Collectors.toMap(entry -> optionalDynamic.createString((String)entry.getKey()), entry -> ((a)entry.getValue()).a(dynamicOps)))));
        if (mutableBoolean.isTrue()) {
            builder.put((Object)optionalDynamic.createString("stronghold"), (Object)optionalDynamic.createMap((Map)ImmutableMap.of((Object)((Object)optionalDynamic.createString("distance")), (Object)((Object)optionalDynamic.createInt(mutableInt.getValue().intValue())), (Object)((Object)optionalDynamic.createString("spread")), (Object)((Object)optionalDynamic.createInt(mutableInt2.getValue().intValue())), (Object)((Object)optionalDynamic.createString("count")), (Object)((Object)optionalDynamic.createInt(mutableInt3.getValue().intValue())))));
        }
        return builder.build();
    }

    private static int a(String string, int i2) {
        return NumberUtils.toInt((String)string, (int)i2);
    }

    private static int a(String string, int i2, int j2) {
        return Math.max(j2, DataConverterWorldGenSettingsBuilding.a(string, i2));
    }

    private static void a(Map<String, a> map, String string, String string2, int i2) {
        a structureFeatureConfiguration = map.getOrDefault(string, (a)j.get((Object)string));
        int j2 = DataConverterWorldGenSettingsBuilding.a(string2, structureFeatureConfiguration.b, i2);
        map.put(string, new a(j2, structureFeatureConfiguration.c, structureFeatureConfiguration.d));
    }

    static final class a {
        public static final Codec<a> a = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("spacing").forGetter(structureFeatureConfiguration -> structureFeatureConfiguration.b), (App)Codec.INT.fieldOf("separation").forGetter(structureFeatureConfiguration -> structureFeatureConfiguration.c), (App)Codec.INT.fieldOf("salt").forGetter(structureFeatureConfiguration -> structureFeatureConfiguration.d)).apply((Applicative)instance, a::new));
        final int b;
        final int c;
        final int d;

        public a(int spacing, int separation, int salt) {
            this.b = spacing;
            this.c = separation;
            this.d = salt;
        }

        public <T> Dynamic<T> a(DynamicOps<T> dynamicOps) {
            return new Dynamic<Object>(dynamicOps, a.encodeStart(dynamicOps, (Object)this).result().orElse(dynamicOps.emptyMap()));
        }
    }
}

