/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import java.util.stream.Stream;
import net.minecraft.SystemUtils;
import net.minecraft.core.HolderSet;
import org.apache.commons.lang3.mutable.MutableObject;

public class ExtraCodecs {
    public static final Codec<Integer> a = ExtraCodecs.a(0, Integer.MAX_VALUE, (Integer v2) -> "Value must be non-negative: " + v2);
    public static final Codec<Integer> b = ExtraCodecs.a(1, Integer.MAX_VALUE, (Integer v2) -> "Value must be positive: " + v2);
    public static final Codec<Float> c = ExtraCodecs.a(0.0f, Float.MAX_VALUE, (Float v2) -> "Value must be positive: " + v2);

    public static <F, S> Codec<Either<F, S>> a(Codec<F> first, Codec<S> second) {
        return new d<F, S>(first, second);
    }

    public static <P, I> Codec<I> a(Codec<P> codec, String leftFieldName, String rightFieldName, BiFunction<P, P, DataResult<I>> combineFunction, Function<I, P> leftFunction, Function<I, P> rightFunction) {
        Codec codec2 = Codec.list(codec).comapFlatMap(list2 -> SystemUtils.a(list2, 2).flatMap(list -> {
            Object object = list.get(0);
            Object object2 = list.get(1);
            return (DataResult)combineFunction.apply(object, object2);
        }), object -> ImmutableList.of(leftFunction.apply(object), rightFunction.apply(object)));
        Codec codec3 = RecordCodecBuilder.create(instance -> instance.group((App)codec.fieldOf(leftFieldName).forGetter(Pair::getFirst), (App)codec.fieldOf(rightFieldName).forGetter(Pair::getSecond)).apply((Applicative)instance, Pair::of)).comapFlatMap(pair -> (DataResult)combineFunction.apply(pair.getFirst(), pair.getSecond()), object -> Pair.of(leftFunction.apply(object), rightFunction.apply(object)));
        Codec codec4 = new b(codec2, codec3).xmap(either -> either.map(object -> object, object -> object), Either::left);
        return Codec.either(codec, (Codec)codec4).comapFlatMap(either -> either.map(object -> (DataResult)combineFunction.apply(object, object), DataResult::success), object -> {
            Object object3;
            Object object2 = leftFunction.apply(object);
            if (Objects.equals(object2, object3 = rightFunction.apply(object))) {
                return Either.left(object2);
            }
            return Either.right(object);
        });
    }

    public static <A> Codec.ResultFunction<A> a(final A object) {
        return new Codec.ResultFunction<A>(){

            public <T> DataResult<Pair<A, T>> apply(DynamicOps<T> dynamicOps, T object2, DataResult<Pair<A, T>> dataResult) {
                MutableObject mutableObject = new MutableObject();
                Optional optional = dataResult.resultOrPartial(arg_0 -> ((MutableObject)mutableObject).setValue(arg_0));
                if (optional.isPresent()) {
                    return dataResult;
                }
                return DataResult.error((String)("(" + (String)mutableObject.getValue() + " -> using default)"), (Object)Pair.of((Object)object, object2));
            }

            public <T> DataResult<T> coApply(DynamicOps<T> dynamicOps, A object2, DataResult<T> dataResult) {
                return dataResult;
            }

            @Override
            public String toString() {
                return "OrElsePartial[" + object + "]";
            }
        };
    }

    public static <E> Codec<E> a(ToIntFunction<E> elementToRawId, IntFunction<E> rawIdToElement, int errorRawId) {
        return Codec.INT.flatXmap(rawId -> Optional.ofNullable(rawIdToElement.apply((int)rawId)).map(DataResult::success).orElseGet(() -> DataResult.error((String)("Unknown element id: " + rawId))), element -> {
            int j2 = elementToRawId.applyAsInt(element);
            return j2 == errorRawId ? DataResult.error((String)("Element with unknown id: " + element)) : DataResult.success((Object)j2);
        });
    }

    public static <E> Codec<E> a(Function<E, String> function, Function<String, E> function2) {
        return Codec.STRING.flatXmap(string -> Optional.ofNullable(function2.apply((String)string)).map(DataResult::success).orElseGet(() -> DataResult.error((String)("Unknown element name:" + string))), object -> Optional.ofNullable((String)function.apply(object)).map(DataResult::success).orElseGet(() -> DataResult.error((String)("Element with unknown name: " + object))));
    }

    public static <E> Codec<E> b(final Codec<E> uncompressedCodec, final Codec<E> compressedCodec) {
        return new Codec<E>(){

            public <T> DataResult<T> encode(E object, DynamicOps<T> dynamicOps, T object2) {
                if (dynamicOps.compressMaps()) {
                    return compressedCodec.encode(object, dynamicOps, object2);
                }
                return uncompressedCodec.encode(object, dynamicOps, object2);
            }

            public <T> DataResult<Pair<E, T>> decode(DynamicOps<T> dynamicOps, T object) {
                if (dynamicOps.compressMaps()) {
                    return compressedCodec.decode(dynamicOps, object);
                }
                return uncompressedCodec.decode(dynamicOps, object);
            }

            @Override
            public String toString() {
                return uncompressedCodec + " orCompressed " + compressedCodec;
            }
        };
    }

    public static <E> Codec<E> a(Codec<E> originalCodec, final Function<E, Lifecycle> function, final Function<E, Lifecycle> function2) {
        return originalCodec.mapResult(new Codec.ResultFunction<E>(){

            public <T> DataResult<Pair<E, T>> apply(DynamicOps<T> dynamicOps, T object, DataResult<Pair<E, T>> dataResult) {
                return dataResult.result().map(pair -> dataResult.setLifecycle((Lifecycle)function.apply(pair.getFirst()))).orElse(dataResult);
            }

            public <T> DataResult<T> coApply(DynamicOps<T> dynamicOps, E object, DataResult<T> dataResult) {
                return dataResult.setLifecycle((Lifecycle)function2.apply(object));
            }

            @Override
            public String toString() {
                return "WithLifecycle[" + function + " " + function2 + "]";
            }
        });
    }

    private static <N extends Number> Function<N, DataResult<N>> a(N min, N max, Function<N, String> messageFactory) {
        return value -> {
            if (((Comparable)((Object)value)).compareTo(min) >= 0 && ((Comparable)((Object)value)).compareTo(max) <= 0) {
                return DataResult.success((Object)value);
            }
            return DataResult.error((String)((String)messageFactory.apply(value)));
        };
    }

    private static Codec<Integer> a(int min, int max, Function<Integer, String> messageFactory) {
        Function<Integer, DataResult<Integer>> function = ExtraCodecs.a(Integer.valueOf(min), Integer.valueOf(max), messageFactory);
        return Codec.INT.flatXmap(function, function);
    }

    private static <N extends Number> Function<N, DataResult<N>> b(N min, N max, Function<N, String> messageFactory) {
        return value -> {
            if (((Comparable)((Object)value)).compareTo(min) > 0 && ((Comparable)((Object)value)).compareTo(max) <= 0) {
                return DataResult.success((Object)value);
            }
            return DataResult.error((String)((String)messageFactory.apply(value)));
        };
    }

    private static Codec<Float> a(float min, float max, Function<Float, String> messageFactory) {
        Function<Float, DataResult<Float>> function = ExtraCodecs.b(Float.valueOf(min), Float.valueOf(max), messageFactory);
        return Codec.FLOAT.flatXmap(function, function);
    }

    public static <T> Function<List<T>, DataResult<List<T>>> a() {
        return list -> {
            if (list.isEmpty()) {
                return DataResult.error((String)"List must have contents");
            }
            return DataResult.success((Object)list);
        };
    }

    public static <T> Codec<List<T>> a(Codec<List<T>> originalCodec) {
        return originalCodec.flatXmap(ExtraCodecs.a(), ExtraCodecs.a());
    }

    public static <T> Function<HolderSet<T>, DataResult<HolderSet<T>>> b() {
        return entries -> {
            if (entries.c().right().filter(List::isEmpty).isPresent()) {
                return DataResult.error((String)"List must have contents");
            }
            return DataResult.success((Object)entries);
        };
    }

    public static <T> Codec<HolderSet<T>> b(Codec<HolderSet<T>> originalCodec) {
        return originalCodec.flatXmap(ExtraCodecs.b(), ExtraCodecs.b());
    }

    public static <A> Codec<A> a(Supplier<Codec<A>> supplier) {
        return new c<A>(supplier);
    }

    public static <E> MapCodec<E> a(Function<DynamicOps<?>, DataResult<E>> retriever) {
        class A
        extends MapCodec<E> {
            final /* synthetic */ Function a;

            A(Function retriever) {
                this.a = retriever;
            }

            public <T> RecordBuilder<T> encode(E object, DynamicOps<T> dynamicOps, RecordBuilder<T> recordBuilder) {
                return recordBuilder;
            }

            public <T> DataResult<E> decode(DynamicOps<T> dynamicOps, MapLike<T> mapLike) {
                return (DataResult)this.a.apply(dynamicOps);
            }

            public String toString() {
                return "ContextRetrievalCodec[" + this.a + "]";
            }

            public <T> Stream<T> keys(DynamicOps<T> dynamicOps) {
                return Stream.empty();
            }
        }
        return new A(retriever);
    }

    public static <E, L extends Collection<E>, T> Function<L, DataResult<L>> b(Function<E, T> typeGetter) {
        return collection -> {
            Iterator iterator = collection.iterator();
            if (iterator.hasNext()) {
                Object object = typeGetter.apply(iterator.next());
                while (iterator.hasNext()) {
                    Object object2 = iterator.next();
                    Object object3 = typeGetter.apply(object2);
                    if (object3 == object) continue;
                    return DataResult.error((String)("Mixed type list: element " + object2 + " had type " + object3 + ", but list is of type " + object));
                }
            }
            return DataResult.success((Object)collection, (Lifecycle)Lifecycle.stable());
        };
    }

    static final class d<F, S>
    implements Codec<Either<F, S>> {
        private final Codec<F> a;
        private final Codec<S> b;

        public d(Codec<F> first, Codec<S> second) {
            this.a = first;
            this.b = second;
        }

        public <T> DataResult<Pair<Either<F, S>, T>> decode(DynamicOps<T> dynamicOps, T object) {
            DataResult dataResult = this.a.decode(dynamicOps, object).map(pair -> pair.mapFirst(Either::left));
            DataResult dataResult2 = this.b.decode(dynamicOps, object).map(pair -> pair.mapFirst(Either::right));
            Optional optional = dataResult.result();
            Optional optional2 = dataResult2.result();
            if (optional.isPresent() && optional2.isPresent()) {
                return DataResult.error((String)("Both alternatives read successfully, can not pick the correct one; first: " + optional.get() + " second: " + optional2.get()), (Object)((Pair)optional.get()));
            }
            return optional.isPresent() ? dataResult : dataResult2;
        }

        public <T> DataResult<T> a(Either<F, S> either, DynamicOps<T> dynamicOps, T object) {
            return either.map(left -> this.a.encode(left, dynamicOps, object), right -> this.b.encode(right, dynamicOps, object));
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            d xorCodec = (d)object;
            return Objects.equals(this.a, xorCodec.a) && Objects.equals(this.b, xorCodec.b);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.a, this.b);
        }

        @Override
        public String toString() {
            return "XorCodec[" + this.a + ", " + this.b + "]";
        }

        public /* synthetic */ DataResult encode(Object object, DynamicOps dynamicOps, Object object2) {
            return this.a((Either)object, dynamicOps, object2);
        }
    }

    static final class b<F, S>
    implements Codec<Either<F, S>> {
        private final Codec<F> a;
        private final Codec<S> b;

        public b(Codec<F> first, Codec<S> second) {
            this.a = first;
            this.b = second;
        }

        public <T> DataResult<Pair<Either<F, S>, T>> decode(DynamicOps<T> dynamicOps, T object) {
            DataResult dataResult = this.a.decode(dynamicOps, object).map(pair -> pair.mapFirst(Either::left));
            if (!dataResult.error().isPresent()) {
                return dataResult;
            }
            DataResult dataResult2 = this.b.decode(dynamicOps, object).map(pair -> pair.mapFirst(Either::right));
            if (!dataResult2.error().isPresent()) {
                return dataResult2;
            }
            return dataResult.apply2((pair, pair2) -> pair2, dataResult2);
        }

        public <T> DataResult<T> a(Either<F, S> either, DynamicOps<T> dynamicOps, T object) {
            return either.map(left -> this.a.encode(left, dynamicOps, object), right -> this.b.encode(right, dynamicOps, object));
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            b eitherCodec = (b)object;
            return Objects.equals(this.a, eitherCodec.a) && Objects.equals(this.b, eitherCodec.b);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.a, this.b);
        }

        @Override
        public String toString() {
            return "EitherCodec[" + this.a + ", " + this.b + "]";
        }

        public /* synthetic */ DataResult encode(Object object, DynamicOps dynamicOps, Object object2) {
            return this.a((Either)object, dynamicOps, object2);
        }
    }

    record c<A>(Supplier<Codec<A>> a) implements Codec<A>
    {
        c(Supplier<Codec<A>> supplier) {
            this.a = supplier = Suppliers.memoize(() -> supplier.get());
        }

        public <T> DataResult<Pair<A, T>> decode(DynamicOps<T> dynamicOps, T object) {
            return this.a.get().decode(dynamicOps, object);
        }

        public <T> DataResult<T> encode(A object, DynamicOps<T> dynamicOps, T object2) {
            return this.a.get().encode(object, dynamicOps, object2);
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{c.class, "delegate", "a"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{c.class, "delegate", "a"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{c.class, "delegate", "a"}, this, object);
        }
    }
}

