/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.annotation.Nullable;
import net.minecraft.core.IRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.item.Item;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Contract;

public class ChatDeserializer {
    private static final Gson a = new GsonBuilder().create();

    public static boolean a(JsonObject object, String element) {
        if (!ChatDeserializer.f(object, element)) {
            return false;
        }
        return object.getAsJsonPrimitive(element).isString();
    }

    public static boolean a(JsonElement element) {
        if (!element.isJsonPrimitive()) {
            return false;
        }
        return element.getAsJsonPrimitive().isString();
    }

    public static boolean b(JsonObject object, String element) {
        if (!ChatDeserializer.f(object, element)) {
            return false;
        }
        return object.getAsJsonPrimitive(element).isNumber();
    }

    public static boolean b(JsonElement element) {
        if (!element.isJsonPrimitive()) {
            return false;
        }
        return element.getAsJsonPrimitive().isNumber();
    }

    public static boolean c(JsonObject object, String element) {
        if (!ChatDeserializer.f(object, element)) {
            return false;
        }
        return object.getAsJsonPrimitive(element).isBoolean();
    }

    public static boolean c(JsonElement object) {
        if (!object.isJsonPrimitive()) {
            return false;
        }
        return object.getAsJsonPrimitive().isBoolean();
    }

    public static boolean d(JsonObject object, String element) {
        if (!ChatDeserializer.g(object, element)) {
            return false;
        }
        return object.get(element).isJsonArray();
    }

    public static boolean e(JsonObject object, String element) {
        if (!ChatDeserializer.g(object, element)) {
            return false;
        }
        return object.get(element).isJsonObject();
    }

    public static boolean f(JsonObject object, String element) {
        if (!ChatDeserializer.g(object, element)) {
            return false;
        }
        return object.get(element).isJsonPrimitive();
    }

    public static boolean g(JsonObject object, String element) {
        if (object == null) {
            return false;
        }
        return object.get(element) != null;
    }

    public static String a(JsonElement element, String name) {
        if (element.isJsonPrimitive()) {
            return element.getAsString();
        }
        throw new JsonSyntaxException("Expected " + name + " to be a string, was " + ChatDeserializer.d(element));
    }

    public static String h(JsonObject object, String element) {
        if (object.has(element)) {
            return ChatDeserializer.a(object.get(element), element);
        }
        throw new JsonSyntaxException("Missing " + element + ", expected to find a string");
    }

    @Nullable
    @Contract(value="_,_,!null->!null;_,_,null->_")
    public static String a(JsonObject object, String element, @Nullable String defaultStr) {
        if (object.has(element)) {
            return ChatDeserializer.a(object.get(element), element);
        }
        return defaultStr;
    }

    public static Item b(JsonElement element, String name) {
        if (element.isJsonPrimitive()) {
            String string = element.getAsString();
            return IRegistry.X.b(new MinecraftKey(string)).orElseThrow(() -> new JsonSyntaxException("Expected " + name + " to be an item, was unknown string '" + string + "'"));
        }
        throw new JsonSyntaxException("Expected " + name + " to be an item, was " + ChatDeserializer.d(element));
    }

    public static Item i(JsonObject object, String key) {
        if (object.has(key)) {
            return ChatDeserializer.b(object.get(key), key);
        }
        throw new JsonSyntaxException("Missing " + key + ", expected to find an item");
    }

    @Nullable
    @Contract(value="_,_,!null->!null;_,_,null->_")
    public static Item a(JsonObject object, String key, @Nullable Item defaultItem) {
        if (object.has(key)) {
            return ChatDeserializer.b(object.get(key), key);
        }
        return defaultItem;
    }

    public static boolean c(JsonElement element, String name) {
        if (element.isJsonPrimitive()) {
            return element.getAsBoolean();
        }
        throw new JsonSyntaxException("Expected " + name + " to be a Boolean, was " + ChatDeserializer.d(element));
    }

    public static boolean j(JsonObject object, String element) {
        if (object.has(element)) {
            return ChatDeserializer.c(object.get(element), element);
        }
        throw new JsonSyntaxException("Missing " + element + ", expected to find a Boolean");
    }

    public static boolean a(JsonObject object, String element, boolean defaultBoolean) {
        if (object.has(element)) {
            return ChatDeserializer.c(object.get(element), element);
        }
        return defaultBoolean;
    }

    public static double d(JsonElement object, String name) {
        if (object.isJsonPrimitive() && object.getAsJsonPrimitive().isNumber()) {
            return object.getAsDouble();
        }
        throw new JsonSyntaxException("Expected " + name + " to be a Double, was " + ChatDeserializer.d(object));
    }

    public static double k(JsonObject object, String element) {
        if (object.has(element)) {
            return ChatDeserializer.d(object.get(element), element);
        }
        throw new JsonSyntaxException("Missing " + element + ", expected to find a Double");
    }

    public static double a(JsonObject object, String element, double defaultDouble) {
        if (object.has(element)) {
            return ChatDeserializer.d(object.get(element), element);
        }
        return defaultDouble;
    }

    public static float e(JsonElement element, String name) {
        if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isNumber()) {
            return element.getAsFloat();
        }
        throw new JsonSyntaxException("Expected " + name + " to be a Float, was " + ChatDeserializer.d(element));
    }

    public static float l(JsonObject object, String element) {
        if (object.has(element)) {
            return ChatDeserializer.e(object.get(element), element);
        }
        throw new JsonSyntaxException("Missing " + element + ", expected to find a Float");
    }

    public static float a(JsonObject object, String element, float defaultFloat) {
        if (object.has(element)) {
            return ChatDeserializer.e(object.get(element), element);
        }
        return defaultFloat;
    }

    public static long f(JsonElement element, String name) {
        if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isNumber()) {
            return element.getAsLong();
        }
        throw new JsonSyntaxException("Expected " + name + " to be a Long, was " + ChatDeserializer.d(element));
    }

    public static long m(JsonObject object, String name) {
        if (object.has(name)) {
            return ChatDeserializer.f(object.get(name), name);
        }
        throw new JsonSyntaxException("Missing " + name + ", expected to find a Long");
    }

    public static long a(JsonObject object, String element, long defaultLong) {
        if (object.has(element)) {
            return ChatDeserializer.f(object.get(element), element);
        }
        return defaultLong;
    }

    public static int g(JsonElement element, String name) {
        if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isNumber()) {
            return element.getAsInt();
        }
        throw new JsonSyntaxException("Expected " + name + " to be a Int, was " + ChatDeserializer.d(element));
    }

    public static int n(JsonObject object, String element) {
        if (object.has(element)) {
            return ChatDeserializer.g(object.get(element), element);
        }
        throw new JsonSyntaxException("Missing " + element + ", expected to find a Int");
    }

    public static int a(JsonObject object, String element, int defaultInt) {
        if (object.has(element)) {
            return ChatDeserializer.g(object.get(element), element);
        }
        return defaultInt;
    }

    public static byte h(JsonElement element, String name) {
        if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isNumber()) {
            return element.getAsByte();
        }
        throw new JsonSyntaxException("Expected " + name + " to be a Byte, was " + ChatDeserializer.d(element));
    }

    public static byte o(JsonObject object, String element) {
        if (object.has(element)) {
            return ChatDeserializer.h(object.get(element), element);
        }
        throw new JsonSyntaxException("Missing " + element + ", expected to find a Byte");
    }

    public static byte a(JsonObject object, String element, byte defaultByte) {
        if (object.has(element)) {
            return ChatDeserializer.h(object.get(element), element);
        }
        return defaultByte;
    }

    public static char i(JsonElement element, String name) {
        if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isNumber()) {
            return element.getAsCharacter();
        }
        throw new JsonSyntaxException("Expected " + name + " to be a Character, was " + ChatDeserializer.d(element));
    }

    public static char p(JsonObject object, String element) {
        if (object.has(element)) {
            return ChatDeserializer.i(object.get(element), element);
        }
        throw new JsonSyntaxException("Missing " + element + ", expected to find a Character");
    }

    public static char a(JsonObject object, String element, char defaultChar) {
        if (object.has(element)) {
            return ChatDeserializer.i(object.get(element), element);
        }
        return defaultChar;
    }

    public static BigDecimal j(JsonElement element, String name) {
        if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isNumber()) {
            return element.getAsBigDecimal();
        }
        throw new JsonSyntaxException("Expected " + name + " to be a BigDecimal, was " + ChatDeserializer.d(element));
    }

    public static BigDecimal q(JsonObject object, String element) {
        if (object.has(element)) {
            return ChatDeserializer.j(object.get(element), element);
        }
        throw new JsonSyntaxException("Missing " + element + ", expected to find a BigDecimal");
    }

    public static BigDecimal a(JsonObject object, String element, BigDecimal defaultBigDecimal) {
        if (object.has(element)) {
            return ChatDeserializer.j(object.get(element), element);
        }
        return defaultBigDecimal;
    }

    public static BigInteger k(JsonElement element, String name) {
        if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isNumber()) {
            return element.getAsBigInteger();
        }
        throw new JsonSyntaxException("Expected " + name + " to be a BigInteger, was " + ChatDeserializer.d(element));
    }

    public static BigInteger r(JsonObject object, String element) {
        if (object.has(element)) {
            return ChatDeserializer.k(object.get(element), element);
        }
        throw new JsonSyntaxException("Missing " + element + ", expected to find a BigInteger");
    }

    public static BigInteger a(JsonObject object, String element, BigInteger defaultBigInteger) {
        if (object.has(element)) {
            return ChatDeserializer.k(object.get(element), element);
        }
        return defaultBigInteger;
    }

    public static short l(JsonElement element, String name) {
        if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isNumber()) {
            return element.getAsShort();
        }
        throw new JsonSyntaxException("Expected " + name + " to be a Short, was " + ChatDeserializer.d(element));
    }

    public static short s(JsonObject object, String element) {
        if (object.has(element)) {
            return ChatDeserializer.l(object.get(element), element);
        }
        throw new JsonSyntaxException("Missing " + element + ", expected to find a Short");
    }

    public static short a(JsonObject object, String element, short defaultShort) {
        if (object.has(element)) {
            return ChatDeserializer.l(object.get(element), element);
        }
        return defaultShort;
    }

    public static JsonObject m(JsonElement element, String name) {
        if (element.isJsonObject()) {
            return element.getAsJsonObject();
        }
        throw new JsonSyntaxException("Expected " + name + " to be a JsonObject, was " + ChatDeserializer.d(element));
    }

    public static JsonObject t(JsonObject object, String element) {
        if (object.has(element)) {
            return ChatDeserializer.m(object.get(element), element);
        }
        throw new JsonSyntaxException("Missing " + element + ", expected to find a JsonObject");
    }

    @Nullable
    @Contract(value="_,_,!null->!null;_,_,null->_")
    public static JsonObject a(JsonObject object, String element, @Nullable JsonObject defaultObject) {
        if (object.has(element)) {
            return ChatDeserializer.m(object.get(element), element);
        }
        return defaultObject;
    }

    public static JsonArray n(JsonElement element, String name) {
        if (element.isJsonArray()) {
            return element.getAsJsonArray();
        }
        throw new JsonSyntaxException("Expected " + name + " to be a JsonArray, was " + ChatDeserializer.d(element));
    }

    public static JsonArray u(JsonObject object, String element) {
        if (object.has(element)) {
            return ChatDeserializer.n(object.get(element), element);
        }
        throw new JsonSyntaxException("Missing " + element + ", expected to find a JsonArray");
    }

    @Nullable
    @Contract(value="_,_,!null->!null;_,_,null->_")
    public static JsonArray a(JsonObject object, String name, @Nullable JsonArray defaultArray) {
        if (object.has(name)) {
            return ChatDeserializer.n(object.get(name), name);
        }
        return defaultArray;
    }

    public static <T> T a(@Nullable JsonElement element, String name, JsonDeserializationContext context, Class<? extends T> type) {
        if (element != null) {
            return (T)context.deserialize(element, type);
        }
        throw new JsonSyntaxException("Missing " + name);
    }

    public static <T> T a(JsonObject object, String element, JsonDeserializationContext context, Class<? extends T> type) {
        if (object.has(element)) {
            return ChatDeserializer.a(object.get(element), element, context, type);
        }
        throw new JsonSyntaxException("Missing " + element);
    }

    @Nullable
    @Contract(value="_,_,!null,_,_->!null;_,_,null,_,_->_")
    public static <T> T a(JsonObject object, String element, @Nullable T defaultValue, JsonDeserializationContext context, Class<? extends T> type) {
        if (object.has(element)) {
            return ChatDeserializer.a(object.get(element), element, context, type);
        }
        return defaultValue;
    }

    public static String d(@Nullable JsonElement element) {
        String string = StringUtils.abbreviateMiddle((String)String.valueOf(element), (String)"...", (int)10);
        if (element == null) {
            return "null (missing)";
        }
        if (element.isJsonNull()) {
            return "null (json)";
        }
        if (element.isJsonArray()) {
            return "an array (" + string + ")";
        }
        if (element.isJsonObject()) {
            return "an object (" + string + ")";
        }
        if (element.isJsonPrimitive()) {
            JsonPrimitive jsonPrimitive = element.getAsJsonPrimitive();
            if (jsonPrimitive.isNumber()) {
                return "a number (" + string + ")";
            }
            if (jsonPrimitive.isBoolean()) {
                return "a boolean (" + string + ")";
            }
        }
        return string;
    }

    @Nullable
    public static <T> T a(Gson gson, Reader reader, Class<T> type, boolean lenient) {
        try {
            JsonReader jsonReader = new JsonReader(reader);
            jsonReader.setLenient(lenient);
            return (T)gson.getAdapter(type).read(jsonReader);
        }
        catch (IOException iOException) {
            throw new JsonParseException((Throwable)iOException);
        }
    }

    @Nullable
    public static <T> T a(Gson gson, Reader reader, TypeToken<T> typeToken, boolean lenient) {
        try {
            JsonReader jsonReader = new JsonReader(reader);
            jsonReader.setLenient(lenient);
            return (T)gson.getAdapter(typeToken).read(jsonReader);
        }
        catch (IOException iOException) {
            throw new JsonParseException((Throwable)iOException);
        }
    }

    @Nullable
    public static <T> T a(Gson gson, String content, TypeToken<T> typeToken, boolean lenient) {
        return ChatDeserializer.a(gson, (Reader)new StringReader(content), typeToken, lenient);
    }

    @Nullable
    public static <T> T a(Gson gson, String content, Class<T> class_, boolean lenient) {
        return ChatDeserializer.a(gson, (Reader)new StringReader(content), class_, lenient);
    }

    @Nullable
    public static <T> T a(Gson gson, Reader reader, TypeToken<T> typeToken) {
        return ChatDeserializer.a(gson, reader, typeToken, false);
    }

    @Nullable
    public static <T> T a(Gson gson, String content, TypeToken<T> typeToken) {
        return ChatDeserializer.a(gson, content, typeToken, false);
    }

    @Nullable
    public static <T> T a(Gson gson, Reader reader, Class<T> class_) {
        return ChatDeserializer.a(gson, reader, class_, false);
    }

    @Nullable
    public static <T> T a(Gson gson, String content, Class<T> class_) {
        return ChatDeserializer.a(gson, content, class_, false);
    }

    public static JsonObject a(String content, boolean lenient) {
        return ChatDeserializer.a(new StringReader(content), lenient);
    }

    public static JsonObject a(Reader reader, boolean lenient) {
        return ChatDeserializer.a(a, reader, JsonObject.class, lenient);
    }

    public static JsonObject a(String content) {
        return ChatDeserializer.a(content, false);
    }

    public static JsonObject a(Reader reader) {
        return ChatDeserializer.a(reader, false);
    }

    public static JsonArray b(Reader reader) {
        return ChatDeserializer.a(a, reader, JsonArray.class, false);
    }
}

