/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.stats;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.SystemUtils;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.world.inventory.RecipeBookType;

public final class RecipeBookSettings {
    private static final Map<RecipeBookType, Pair<String, String>> a = ImmutableMap.of((Object)((Object)RecipeBookType.a), (Object)Pair.of((Object)"isGuiOpen", (Object)"isFilteringCraftable"), (Object)((Object)RecipeBookType.b), (Object)Pair.of((Object)"isFurnaceGuiOpen", (Object)"isFurnaceFilteringCraftable"), (Object)((Object)RecipeBookType.c), (Object)Pair.of((Object)"isBlastingFurnaceGuiOpen", (Object)"isBlastingFurnaceFilteringCraftable"), (Object)((Object)RecipeBookType.d), (Object)Pair.of((Object)"isSmokerGuiOpen", (Object)"isSmokerFilteringCraftable"));
    private final Map<RecipeBookType, a> b;

    private RecipeBookSettings(Map<RecipeBookType, a> categoryOptions) {
        this.b = categoryOptions;
    }

    public RecipeBookSettings() {
        this(SystemUtils.a(Maps.newEnumMap(RecipeBookType.class), enumMap -> {
            for (RecipeBookType recipeBookType : RecipeBookType.values()) {
                enumMap.put(recipeBookType, new a(false, false));
            }
        }));
    }

    public boolean a(RecipeBookType category) {
        return this.b.get((Object)((Object)category)).a;
    }

    public void a(RecipeBookType category, boolean open) {
        this.b.get((Object)((Object)category)).a = open;
    }

    public boolean b(RecipeBookType category) {
        return this.b.get((Object)((Object)category)).b;
    }

    public void b(RecipeBookType category, boolean filtering) {
        this.b.get((Object)((Object)category)).b = filtering;
    }

    public static RecipeBookSettings a(PacketDataSerializer buf) {
        EnumMap map = Maps.newEnumMap(RecipeBookType.class);
        for (RecipeBookType recipeBookType : RecipeBookType.values()) {
            boolean bl = buf.readBoolean();
            boolean bl2 = buf.readBoolean();
            map.put(recipeBookType, new a(bl, bl2));
        }
        return new RecipeBookSettings(map);
    }

    public void b(PacketDataSerializer buf) {
        for (RecipeBookType recipeBookType : RecipeBookType.values()) {
            a typeSettings = this.b.get((Object)recipeBookType);
            if (typeSettings == null) {
                buf.writeBoolean(false);
                buf.writeBoolean(false);
                continue;
            }
            buf.writeBoolean(typeSettings.a);
            buf.writeBoolean(typeSettings.b);
        }
    }

    public static RecipeBookSettings a(NBTTagCompound nbt) {
        EnumMap map = Maps.newEnumMap(RecipeBookType.class);
        a.forEach((category, pair) -> {
            boolean bl = nbt.q((String)pair.getFirst());
            boolean bl2 = nbt.q((String)pair.getSecond());
            map.put(category, new a(bl, bl2));
        });
        return new RecipeBookSettings(map);
    }

    public void b(NBTTagCompound nbt) {
        a.forEach((category, pair) -> {
            a typeSettings = this.b.get(category);
            nbt.a((String)pair.getFirst(), typeSettings.a);
            nbt.a((String)pair.getSecond(), typeSettings.b);
        });
    }

    public RecipeBookSettings a() {
        EnumMap map = Maps.newEnumMap(RecipeBookType.class);
        for (RecipeBookType recipeBookType : RecipeBookType.values()) {
            a typeSettings = this.b.get((Object)recipeBookType);
            map.put(recipeBookType, typeSettings.a());
        }
        return new RecipeBookSettings(map);
    }

    public void a(RecipeBookSettings other) {
        this.b.clear();
        for (RecipeBookType recipeBookType : RecipeBookType.values()) {
            a typeSettings = other.b.get((Object)recipeBookType);
            this.b.put(recipeBookType, typeSettings.a());
        }
    }

    @Override
    public boolean equals(Object object) {
        return this == object || object instanceof RecipeBookSettings && this.b.equals(((RecipeBookSettings)object).b);
    }

    @Override
    public int hashCode() {
        return this.b.hashCode();
    }

    static final class a {
        boolean a;
        boolean b;

        public a(boolean guiOpen, boolean filteringCraftable) {
            this.a = guiOpen;
            this.b = filteringCraftable;
        }

        public a a() {
            return new a(this.a, this.b);
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof a) {
                a typeSettings = (a)object;
                return this.a == typeSettings.a && this.b == typeSettings.b;
            }
            return false;
        }

        @Override
        public int hashCode() {
            int i2 = this.a ? 1 : 0;
            i2 = 31 * i2 + (this.b ? 1 : 0);
            return i2;
        }

        @Override
        public String toString() {
            return "[open=" + this.a + ", filtering=" + this.b + "]";
        }
    }
}

