/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.rcon.thread;

import com.destroystokyo.paper.event.server.GS4QueryEvent;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.PortUnreachableException;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.server.IMinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.rcon.RemoteStatusReply;
import net.minecraft.server.rcon.StatusChallengeUtils;
import net.minecraft.server.rcon.thread.RemoteConnectionThread;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.slf4j.Logger;

public class RemoteStatusListener
extends RemoteConnectionThread {
    private static final Logger d = LogUtils.getLogger();
    private static final String e = "SMP";
    private static final String f = "MINECRAFT";
    private static final long g = 30000L;
    private static final long h = 5000L;
    private long i;
    private final int j;
    private final int k;
    private final int l;
    private final String m;
    private final String n;
    private DatagramSocket o;
    private final byte[] p = new byte[1460];
    private String q;
    private String r;
    private final Map<SocketAddress, RemoteStatusChallenge> s;
    private final RemoteStatusReply t;
    private long u;
    private final IMinecraftServer v;

    private RemoteStatusListener(IMinecraftServer server, int queryPort) {
        super("Query Listener");
        this.v = server;
        this.j = queryPort;
        this.r = server.b();
        this.k = server.d();
        this.m = server.p();
        this.l = server.I();
        this.n = server.r();
        this.u = 0L;
        this.q = "0.0.0.0";
        if (!this.r.isEmpty() && !this.q.equals(this.r)) {
            this.q = this.r;
        } else {
            this.r = "0.0.0.0";
            try {
                InetAddress inetAddress = InetAddress.getLocalHost();
                this.q = inetAddress.getHostAddress();
            }
            catch (UnknownHostException var4) {
                d.warn("Unable to determine local host IP, please set server-ip in server.properties", (Throwable)var4);
            }
        }
        this.t = new RemoteStatusReply(1460);
        this.s = Maps.newHashMap();
    }

    @Nullable
    public static RemoteStatusListener a(IMinecraftServer server) {
        int i2 = server.a().t;
        if (0 < i2 && 65535 >= i2) {
            RemoteStatusListener queryThreadGs4 = new RemoteStatusListener(server, i2);
            return !queryThreadGs4.a() ? null : queryThreadGs4;
        }
        d.warn("Invalid query port {} found in server.properties (queries disabled)", (Object)i2);
        return null;
    }

    private void a(byte[] buf, DatagramPacket packet) throws IOException {
        this.o.send(new DatagramPacket(buf, buf.length, packet.getSocketAddress()));
    }

    private boolean a(DatagramPacket packet) throws IOException {
        byte[] bs = packet.getData();
        int i2 = packet.getLength();
        SocketAddress socketAddress = packet.getSocketAddress();
        d.debug("Packet len {} [{}]", (Object)i2, (Object)socketAddress);
        if (3 <= i2 && -2 == bs[0] && -3 == bs[1]) {
            d.debug("Packet '{}' [{}]", (Object)StatusChallengeUtils.a(bs[2]), (Object)socketAddress);
            switch (bs[2]) {
                case 0: {
                    if (!this.c(packet).booleanValue()) {
                        d.debug("Invalid challenge [{}]", (Object)socketAddress);
                        return false;
                    }
                    if (15 == i2) {
                        this.a(this.b(packet), packet);
                        d.debug("Rules [{}]", (Object)socketAddress);
                    } else {
                        RemoteStatusReply networkDataOutputStream = new RemoteStatusReply(1460);
                        networkDataOutputStream.a(0);
                        networkDataOutputStream.a(this.a(packet.getSocketAddress()));
                        GS4QueryEvent.QueryType queryType = GS4QueryEvent.QueryType.BASIC;
                        GS4QueryEvent.QueryResponse queryResponse = GS4QueryEvent.QueryResponse.builder().motd(this.m).map(this.n).currentPlayers(this.v.H()).maxPlayers(this.l).port(this.k).hostname(this.q).gameVersion(this.v.G()).serverVersion(Bukkit.getServer().getName() + " on " + Bukkit.getServer().getBukkitVersion()).build();
                        GS4QueryEvent queryEvent = new GS4QueryEvent(queryType, packet.getAddress(), queryResponse);
                        queryEvent.callEvent();
                        queryResponse = queryEvent.getResponse();
                        networkDataOutputStream.a(queryResponse.getMotd());
                        networkDataOutputStream.a(e);
                        networkDataOutputStream.a(queryResponse.getMap());
                        networkDataOutputStream.a(Integer.toString(queryResponse.getCurrentPlayers()));
                        networkDataOutputStream.a(Integer.toString(queryResponse.getMaxPlayers()));
                        networkDataOutputStream.a((short)queryResponse.getPort());
                        networkDataOutputStream.a(queryResponse.getHostname());
                        this.a(networkDataOutputStream.a(), packet);
                        d.debug("Status [{}]", (Object)socketAddress);
                    }
                }
                default: {
                    return true;
                }
                case 9: 
            }
            this.d(packet);
            d.debug("Challenge [{}]", (Object)socketAddress);
            return true;
        }
        d.debug("Invalid packet [{}]", (Object)socketAddress);
        return false;
    }

    private byte[] b(DatagramPacket packet) throws IOException {
        String[] strings;
        Plugin[] bukkitPlugins;
        long l2 = SystemUtils.b();
        if (l2 < this.u + 5000L) {
            byte[] bs = this.t.a();
            byte[] cs = this.a(packet.getSocketAddress());
            bs[1] = cs[0];
            bs[2] = cs[1];
            bs[3] = cs[2];
            bs[4] = cs[3];
            return bs;
        }
        this.u = l2;
        this.t.b();
        this.t.a(0);
        this.t.a(this.a(packet.getSocketAddress()));
        this.t.a("splitnum");
        this.t.a(128);
        this.t.a(0);
        List plugins = Collections.emptyList();
        if (((DedicatedServer)this.v).server.getQueryPlugins() && (bukkitPlugins = Bukkit.getPluginManager().getPlugins()).length > 0) {
            plugins = Stream.of(bukkitPlugins).map(plugin -> GS4QueryEvent.QueryResponse.PluginInformation.of((String)plugin.getName(), (String)plugin.getDescription().getVersion())).collect(Collectors.toList());
        }
        GS4QueryEvent.QueryResponse queryResponse = GS4QueryEvent.QueryResponse.builder().motd(this.m).map(this.n).currentPlayers(this.v.H()).maxPlayers(this.l).port(this.k).hostname(this.q).plugins(plugins).players(this.v.J()).gameVersion(this.v.G()).serverVersion(Bukkit.getServer().getName() + " on " + Bukkit.getServer().getBukkitVersion()).build();
        GS4QueryEvent.QueryType queryType = GS4QueryEvent.QueryType.FULL;
        GS4QueryEvent queryEvent = new GS4QueryEvent(queryType, packet.getAddress(), queryResponse);
        queryEvent.callEvent();
        queryResponse = queryEvent.getResponse();
        this.t.a("hostname");
        this.t.a(queryResponse.getMotd());
        this.t.a("gametype");
        this.t.a(e);
        this.t.a("game_id");
        this.t.a(f);
        this.t.a("version");
        this.t.a(queryResponse.getGameVersion());
        this.t.a("plugins");
        StringBuilder pluginsString = new StringBuilder();
        pluginsString.append(queryResponse.getServerVersion());
        if (!queryResponse.getPlugins().isEmpty()) {
            pluginsString.append(": ");
            Iterator iter = queryResponse.getPlugins().iterator();
            while (iter.hasNext()) {
                GS4QueryEvent.QueryResponse.PluginInformation info = (GS4QueryEvent.QueryResponse.PluginInformation)iter.next();
                pluginsString.append(info.getName());
                if (info.getVersion() != null) {
                    pluginsString.append(' ').append(info.getVersion().replace(";", ","));
                }
                if (!iter.hasNext()) continue;
                pluginsString.append(';').append(' ');
            }
        }
        this.t.a(pluginsString.toString());
        this.t.a("map");
        this.t.a(queryResponse.getMap());
        this.t.a("numplayers");
        this.t.a(Integer.toString(queryResponse.getCurrentPlayers()));
        this.t.a("maxplayers");
        this.t.a(Integer.toString(queryResponse.getMaxPlayers()));
        this.t.a("hostport");
        this.t.a(Integer.toString(queryResponse.getPort()));
        this.t.a("hostip");
        this.t.a(queryResponse.getHostname());
        this.t.a(0);
        this.t.a(1);
        this.t.a("player_");
        this.t.a(0);
        for (String string : strings = (String[])queryResponse.getPlayers().toArray(String[]::new)) {
            this.t.a(string);
        }
        this.t.a(0);
        return this.t.a();
    }

    private byte[] a(SocketAddress address) {
        return this.s.get(address).c();
    }

    private Boolean c(DatagramPacket packet) {
        SocketAddress socketAddress = packet.getSocketAddress();
        if (!this.s.containsKey(socketAddress)) {
            return false;
        }
        byte[] bs = packet.getData();
        return this.s.get(socketAddress).a() == StatusChallengeUtils.c(bs, 7, packet.getLength());
    }

    private void d(DatagramPacket packet) throws IOException {
        RemoteStatusChallenge requestChallenge = new RemoteStatusChallenge(packet);
        this.s.put(packet.getSocketAddress(), requestChallenge);
        this.a(requestChallenge.b(), packet);
    }

    private void d() {
        long l2;
        if (this.a && (l2 = SystemUtils.b()) >= this.i + 30000L) {
            this.i = l2;
            this.s.values().removeIf(query -> query.a(l2));
        }
    }

    @Override
    public void run() {
        d.info("Query running on {}:{}", (Object)this.r, (Object)this.j);
        this.i = SystemUtils.b();
        DatagramPacket datagramPacket = new DatagramPacket(this.p, this.p.length);
        try {
            while (this.a) {
                try {
                    this.o.receive(datagramPacket);
                    this.d();
                    this.a(datagramPacket);
                }
                catch (SocketTimeoutException var8) {
                    this.d();
                }
                catch (PortUnreachableException var8) {
                }
                catch (IOException var10) {
                    this.a(var10);
                }
            }
        }
        finally {
            d.debug("closeSocket: {}:{}", (Object)this.r, (Object)this.j);
            this.o.close();
        }
    }

    @Override
    public boolean a() {
        if (this.a) {
            return true;
        }
        return !this.e() ? false : super.a();
    }

    private void a(Exception e2) {
        if (this.a) {
            d.warn("Unexpected exception", (Throwable)e2);
            if (!this.e()) {
                d.error("Failed to recover from exception, shutting down!");
                this.a = false;
            }
        }
    }

    private boolean e() {
        try {
            this.o = new DatagramSocket(this.j, InetAddress.getByName(this.r));
            this.o.setSoTimeout(500);
            return true;
        }
        catch (Exception var2) {
            d.warn("Unable to initialise query system on {}:{}", new Object[]{this.r, this.j, var2});
            return false;
        }
    }

    static class RemoteStatusChallenge {
        private final long a = new Date().getTime();
        private final int b;
        private final byte[] c;
        private final byte[] d;
        private final String e;

        public RemoteStatusChallenge(DatagramPacket packet) {
            byte[] bs = packet.getData();
            this.c = new byte[4];
            this.c[0] = bs[3];
            this.c[1] = bs[4];
            this.c[2] = bs[5];
            this.c[3] = bs[6];
            this.e = new String(this.c, StandardCharsets.UTF_8);
            this.b = new Random().nextInt(0x1000000);
            this.d = String.format("\t%s%d\u0000", this.e, this.b).getBytes(StandardCharsets.UTF_8);
        }

        public Boolean a(long lastQueryTime) {
            return this.a < lastQueryTime;
        }

        public int a() {
            return this.b;
        }

        public byte[] b() {
            return this.d;
        }

        public byte[] c() {
            return this.c;
        }

        public String d() {
            return this.e;
        }
    }
}

