/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.players;

import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import java.util.Date;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.network.chat.ChatComponentText;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.players.ExpirableListEntry;

public class GameProfileBanEntry
extends ExpirableListEntry<GameProfile> {
    public GameProfileBanEntry(GameProfile profile) {
        this(profile, (Date)null, (String)null, (Date)null, (String)null);
    }

    public GameProfileBanEntry(GameProfile profile, @Nullable Date created, @Nullable String source, @Nullable Date expiry, @Nullable String reason) {
        super(profile, created, source, expiry, reason);
    }

    public GameProfileBanEntry(JsonObject json) {
        super(GameProfileBanEntry.b(json), json);
    }

    @Override
    protected void a(JsonObject json) {
        if (this.g() != null) {
            json.addProperty("uuid", ((GameProfile)this.g()).getId() == null ? "" : ((GameProfile)this.g()).getId().toString());
            json.addProperty("name", ((GameProfile)this.g()).getName());
            super.a(json);
        }
    }

    @Override
    public IChatBaseComponent e() {
        GameProfile gameprofile = (GameProfile)this.g();
        return new ChatComponentText(gameprofile.getName() != null ? gameprofile.getName() : Objects.toString(gameprofile.getId(), "(Unknown)"));
    }

    private static GameProfile b(JsonObject json) {
        UUID uuid = null;
        String name = null;
        if (json.has("uuid")) {
            String s2 = json.get("uuid").getAsString();
            try {
                uuid = UUID.fromString(s2);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (json.has("name")) {
            name = json.get("name").getAsString();
        }
        if (uuid != null || name != null) {
            return new GameProfile(uuid, name);
        }
        return null;
    }
}

