/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.resources;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.IResourcePack;
import net.minecraft.server.packs.resources.IReloadableResourceManager;
import net.minecraft.server.packs.resources.IResource;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerFallback;

public class ResourceManager
implements IReloadableResourceManager {
    private final Map<String, ResourceManagerFallback> a;
    private final List<IResourcePack> b;

    public ResourceManager(EnumResourcePackType type, List<IResourcePack> packs) {
        this.b = List.copyOf(packs);
        HashMap<String, ResourceManagerFallback> map = new HashMap<String, ResourceManagerFallback>();
        for (IResourcePack packResources : packs) {
            for (String string : packResources.a(type)) {
                map.computeIfAbsent(string, namespace -> new ResourceManagerFallback(type, (String)namespace)).a(packResources);
            }
        }
        this.a = map;
    }

    @Override
    @Override
    public Set<String> a() {
        return this.a.keySet();
    }

    @Override
    @Override
    public IResource getResource(MinecraftKey id) throws IOException {
        IResourceManager resourceManager = this.a.get(id.b());
        if (resourceManager != null) {
            return resourceManager.getResource(id);
        }
        throw new FileNotFoundException(id.toString());
    }

    @Override
    @Override
    public boolean a(MinecraftKey id) {
        IResourceManager resourceManager = this.a.get(id.b());
        if (resourceManager != null) {
            return resourceManager.a(id);
        }
        return false;
    }

    @Override
    @Override
    public List<IResource> b(MinecraftKey id) throws IOException {
        IResourceManager resourceManager = this.a.get(id.b());
        if (resourceManager != null) {
            return resourceManager.b(id);
        }
        throw new FileNotFoundException(id.toString());
    }

    @Override
    @Override
    public Collection<MinecraftKey> a(String startingPath, Predicate<String> pathPredicate) {
        HashSet set = Sets.newHashSet();
        for (ResourceManagerFallback fallbackResourceManager : this.a.values()) {
            set.addAll(fallbackResourceManager.a(startingPath, pathPredicate));
        }
        ArrayList list = Lists.newArrayList((Iterable)set);
        Collections.sort(list);
        return list;
    }

    @Override
    @Override
    public Stream<IResourcePack> b() {
        return this.b.stream();
    }

    @Override
    @Override
    public void close() {
        this.b.forEach(IResourcePack::close);
    }
}

