/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.resources;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.packs.resources.IResource;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.ResourceDataAbstract;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.util.profiling.GameProfilerFiller;
import org.slf4j.Logger;

public abstract class ResourceDataJson
extends ResourceDataAbstract<Map<MinecraftKey, JsonElement>> {
    private static final Logger a = LogUtils.getLogger();
    private static final String b = ".json";
    private static final int c = ".json".length();
    private final Gson d;
    private final String e;

    public ResourceDataJson(Gson gson, String dataType) {
        this.d = gson;
        this.e = dataType;
    }

    @Override
    protected Map<MinecraftKey, JsonElement> a(IResourceManager resourceManager, GameProfilerFiller profilerFiller) {
        HashMap map = Maps.newHashMap();
        int i2 = this.e.length() + 1;
        for (MinecraftKey resourceLocation : resourceManager.a(this.e, (String path) -> path.endsWith(b))) {
            String string = resourceLocation.a();
            MinecraftKey resourceLocation2 = new MinecraftKey(resourceLocation.b(), string.substring(i2, string.length() - c));
            try {
                IResource resource = resourceManager.getResource(resourceLocation);
                try {
                    InputStream inputStream = resource.b();
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
                        JsonElement jsonElement = ChatDeserializer.a(this.d, (Reader)reader, JsonElement.class);
                        if (jsonElement != null) {
                            JsonElement jsonElement2 = map.put(resourceLocation2, jsonElement);
                            if (jsonElement2 == null) continue;
                            throw new IllegalStateException("Duplicate data file ignored with ID " + resourceLocation2);
                        }
                        a.error("Couldn't load data file {} from {} as it's null or empty", (Object)resourceLocation2, (Object)resourceLocation);
                    }
                    finally {
                        if (inputStream == null) continue;
                        inputStream.close();
                    }
                }
                finally {
                    if (resource == null) continue;
                    resource.close();
                }
            }
            catch (JsonParseException | IOException | IllegalArgumentException exception) {
                a.error("Couldn't parse data file {} from {}", new Object[]{resourceLocation2, resourceLocation, exception});
            }
        }
        return map;
    }

    @Override
    protected /* synthetic */ Object b(IResourceManager manager, GameProfilerFiller profiler) {
        return this.a(manager, profiler);
    }
}

