/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.resources;

import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.packs.metadata.ResourcePackMetaParser;
import net.minecraft.server.packs.resources.IResource;
import net.minecraft.util.ChatDeserializer;
import org.apache.commons.io.IOUtils;

public class Resource
implements IResource {
    private final String a;
    private final MinecraftKey b;
    private final InputStream c;
    private final InputStream d;
    private boolean e;
    private JsonObject f;

    public Resource(String packName, MinecraftKey id, InputStream inputStream, @Nullable InputStream metaInputStream) {
        this.a = packName;
        this.b = id;
        this.c = inputStream;
        this.d = metaInputStream;
    }

    @Override
    @Override
    public MinecraftKey a() {
        return this.b;
    }

    @Override
    @Override
    public InputStream b() {
        return this.c;
    }

    @Override
    @Override
    public boolean c() {
        return this.d != null;
    }

    @Override
    @Nullable
    @Override
    public <T> T a(ResourcePackMetaParser<T> metaReader) {
        if (!this.c()) {
            return null;
        }
        if (this.f == null && !this.e) {
            this.e = true;
            BufferedReader bufferedReader = null;
            try {
                bufferedReader = new BufferedReader(new InputStreamReader(this.d, StandardCharsets.UTF_8));
                this.f = ChatDeserializer.a(bufferedReader);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bufferedReader);
                throw throwable;
            }
            IOUtils.closeQuietly((Reader)bufferedReader);
        }
        if (this.f == null) {
            return null;
        }
        String string = metaReader.a();
        return this.f.has(string) ? (T)metaReader.a(ChatDeserializer.t(this.f, string)) : null;
    }

    @Override
    @Override
    public String d() {
        return this.a;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Resource)) {
            return false;
        }
        Resource simpleResource = (Resource)object;
        if (this.b != null ? !this.b.equals(simpleResource.b) : simpleResource.b != null) {
            return false;
        }
        return !(this.a != null ? !this.a.equals(simpleResource.a) : simpleResource.a != null);
    }

    @Override
    public int hashCode() {
        int i2 = this.a != null ? this.a.hashCode() : 0;
        i2 = 31 * i2 + (this.b != null ? this.b.hashCode() : 0);
        return i2;
    }

    @Override
    @Override
    public void close() throws IOException {
        this.c.close();
        if (this.d != null) {
            this.d.close();
        }
    }
}

