/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.resources;

import com.google.common.base.Stopwatch;
import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import net.minecraft.SystemUtils;
import net.minecraft.server.packs.resources.IReloadListener;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.Reloadable;
import net.minecraft.util.Unit;
import net.minecraft.util.profiling.MethodProfiler;
import net.minecraft.util.profiling.MethodProfilerResults;
import org.slf4j.Logger;

public class ReloadableProfiled
extends Reloadable<a> {
    private static final Logger c = LogUtils.getLogger();
    private final Stopwatch d = Stopwatch.createUnstarted();

    public ReloadableProfiled(IResourceManager manager, List<IReloadListener> reloaders, Executor prepareExecutor, Executor applyExecutor, CompletableFuture<Unit> initialStage) {
        super(prepareExecutor, applyExecutor, manager, reloaders, (synchronizer, resourceManager, reloader, prepare, apply) -> {
            AtomicLong atomicLong = new AtomicLong();
            AtomicLong atomicLong2 = new AtomicLong();
            MethodProfiler activeProfiler = new MethodProfiler(SystemUtils.a, () -> 0, false);
            MethodProfiler activeProfiler2 = new MethodProfiler(SystemUtils.a, () -> 0, false);
            CompletableFuture<Void> completableFuture = reloader.a(synchronizer, resourceManager, activeProfiler, activeProfiler2, preparation -> prepare.execute(() -> {
                long l2 = SystemUtils.c();
                preparation.run();
                atomicLong.addAndGet(SystemUtils.c() - l2);
            }), application -> apply.execute(() -> {
                long l2 = SystemUtils.c();
                application.run();
                atomicLong2.addAndGet(SystemUtils.c() - l2);
            }));
            return completableFuture.thenApplyAsync(dummy -> {
                c.debug("Finished reloading " + reloader.c());
                return new a(reloader.c(), activeProfiler.d(), activeProfiler2.d(), atomicLong, atomicLong2);
            }, applyExecutor);
        }, initialStage);
        this.d.start();
        this.b.thenAcceptAsync(this::a, applyExecutor);
    }

    private void a(List<a> summaries) {
        this.d.stop();
        int i2 = 0;
        c.info("Resource reload finished after {} ms", (Object)this.d.elapsed(TimeUnit.MILLISECONDS));
        for (a state : summaries) {
            MethodProfilerResults profileResults = state.b;
            MethodProfilerResults profileResults2 = state.c;
            int j2 = (int)((double)state.d.get() / 1000000.0);
            int k2 = (int)((double)state.e.get() / 1000000.0);
            int l2 = j2 + k2;
            String string = state.a;
            c.info("{} took approximately {} ms ({} ms preparing, {} ms applying)", new Object[]{string, l2, j2, k2});
            i2 += k2;
        }
        c.info("Total blocking time: {} ms", (Object)i2);
    }

    public static class a {
        final String a;
        final MethodProfilerResults b;
        final MethodProfilerResults c;
        final AtomicLong d;
        final AtomicLong e;

        a(String name, MethodProfilerResults prepareProfile, MethodProfilerResults applyProfile, AtomicLong prepareTimeMs, AtomicLong applyTimeMs) {
            this.a = name;
            this.b = prepareProfile;
            this.c = applyProfile;
            this.d = prepareTimeMs;
            this.e = applyTimeMs;
        }
    }
}

