/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.repository;

import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.network.chat.ChatComponentText;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.IResourcePack;
import net.minecraft.server.packs.metadata.pack.ResourcePackInfo;
import net.minecraft.server.packs.repository.EnumResourcePackVersion;
import net.minecraft.server.packs.repository.PackSource;
import org.slf4j.Logger;

public class ResourcePackLoader
implements AutoCloseable {
    private static final Logger a = LogUtils.getLogger();
    private final String b;
    private final Supplier<IResourcePack> c;
    private final IChatBaseComponent d;
    private final IChatBaseComponent e;
    private final EnumResourcePackVersion f;
    private final Position g;
    private final boolean h;
    private final boolean i;
    private final PackSource j;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static ResourcePackLoader a(String name, boolean alwaysEnabled, Supplier<IResourcePack> packFactory, a profileFactory, Position insertionPosition, PackSource packSource) {
        try (IResourcePack packResources = packFactory.get();){
            ResourcePackInfo packMetadataSection = packResources.a(ResourcePackInfo.a);
            if (packMetadataSection != null) {
                ResourcePackLoader resourcePackLoader = profileFactory.create(name, new ChatComponentText(packResources.a()), alwaysEnabled, packFactory, packMetadataSection, insertionPosition, packSource);
                return resourcePackLoader;
            }
            a.warn("Couldn't find pack meta for pack {}", (Object)name);
            return null;
        }
        catch (IOException iOException) {
            a.warn("Couldn't get pack info for: {}", (Object)iOException.toString());
        }
        return null;
    }

    public ResourcePackLoader(String name, boolean alwaysEnabled, Supplier<IResourcePack> packFactory, IChatBaseComponent displayName, IChatBaseComponent description, EnumResourcePackVersion compatibility, Position direction, boolean pinned, PackSource source) {
        this.b = name;
        this.c = packFactory;
        this.d = displayName;
        this.e = description;
        this.f = compatibility;
        this.h = alwaysEnabled;
        this.g = direction;
        this.i = pinned;
        this.j = source;
    }

    public ResourcePackLoader(String name, IChatBaseComponent displayName, boolean alwaysEnabled, Supplier<IResourcePack> packFactory, ResourcePackInfo metadata, EnumResourcePackType type, Position direction, PackSource source) {
        this(name, alwaysEnabled, packFactory, displayName, metadata.a(), EnumResourcePackVersion.a(metadata, type), direction, false, source);
    }

    public IChatBaseComponent a() {
        return this.d;
    }

    public IChatBaseComponent b() {
        return this.e;
    }

    public IChatBaseComponent a(boolean enabled) {
        return ChatComponentUtils.a(this.j.decorate(new ChatComponentText(this.b))).a(style -> style.a(enabled ? EnumChatFormat.k : EnumChatFormat.m).a(StringArgumentType.escapeIfRequired((String)this.b)).a(new ChatHoverable(ChatHoverable.EnumHoverAction.a, new ChatComponentText("").a(this.d).c("\n").a(this.e))));
    }

    public EnumResourcePackVersion c() {
        return this.f;
    }

    public IResourcePack d() {
        return this.c.get();
    }

    public String e() {
        return this.b;
    }

    public boolean f() {
        return this.h;
    }

    public boolean g() {
        return this.i;
    }

    public Position h() {
        return this.g;
    }

    public PackSource i() {
        return this.j;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ResourcePackLoader)) {
            return false;
        }
        ResourcePackLoader pack = (ResourcePackLoader)object;
        return this.b.equals(pack.b);
    }

    @Override
    public int hashCode() {
        return this.b.hashCode();
    }

    @Override
    @Override
    public void close() {
    }

    @FunctionalInterface
    public static interface a {
        @Nullable
        public ResourcePackLoader create(String var1, IChatBaseComponent var2, boolean var3, Supplier<IResourcePack> var4, ResourcePackInfo var5, Position var6, PackSource var7);
    }

    public static final class Position
    extends Enum<Position> {
        public static final /* enum */ Position a = new Position();
        public static final /* enum */ Position b = new Position();
        private static final /* synthetic */ Position[] c;

        public static Position[] values() {
            return (Position[])c.clone();
        }

        public static Position valueOf(String string) {
            return Enum.valueOf(Position.class, string);
        }

        public <T> int a(List<T> items, T item, Function<T, ResourcePackLoader> profileGetter, boolean listInverted) {
            ResourcePackLoader pack2;
            int j2;
            Position position;
            Position position2 = position = listInverted ? this.a() : this;
            if (position == b) {
                ResourcePackLoader pack;
                int i2;
                for (i2 = 0; i2 < items.size() && (pack = profileGetter.apply(items.get(i2))).g() && pack.h() == this; ++i2) {
                }
                items.add(i2, item);
                return i2;
            }
            for (j2 = items.size() - 1; j2 >= 0 && (pack2 = profileGetter.apply(items.get(j2))).g() && pack2.h() == this; --j2) {
            }
            items.add(j2 + 1, item);
            return j2 + 1;
        }

        public Position a() {
            return this == a ? b : a;
        }

        private static /* synthetic */ Position[] b() {
            return new Position[]{a, b};
        }

        static {
            c = Position.b();
        }
    }
}

