/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs;

import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.IResourcePack;
import net.minecraft.server.packs.metadata.ResourcePackMetaParser;
import net.minecraft.util.ChatDeserializer;
import org.slf4j.Logger;

public abstract class ResourcePackAbstract
implements IResourcePack {
    private static final Logger b = LogUtils.getLogger();
    protected final File a;

    public ResourcePackAbstract(File base) {
        this.a = base;
    }

    private static String c(EnumResourcePackType type, MinecraftKey id) {
        return String.format("%s/%s/%s", type.a(), id.b(), id.a());
    }

    protected static String a(File base, File target) {
        return base.toURI().relativize(target.toURI()).getPath();
    }

    @Override
    @Override
    public InputStream a(EnumResourcePackType type, MinecraftKey id) throws IOException {
        return this.a(ResourcePackAbstract.c(type, id));
    }

    @Override
    @Override
    public boolean b(EnumResourcePackType type, MinecraftKey id) {
        return this.c(ResourcePackAbstract.c(type, id));
    }

    protected abstract InputStream a(String var1) throws IOException;

    @Override
    @Override
    public InputStream b(String fileName) throws IOException {
        if (fileName.contains("/") || fileName.contains("\\")) {
            throw new IllegalArgumentException("Root resources can only be filenames, not paths (no / allowed!)");
        }
        return this.a(fileName);
    }

    protected abstract boolean c(String var1);

    protected void d(String namespace) {
        b.warn("ResourcePack: ignored non-lowercase namespace: {} in {}", (Object)namespace, (Object)this.a);
    }

    @Override
    @Nullable
    @Override
    public <T> T a(ResourcePackMetaParser<T> metaReader) throws IOException {
        try (InputStream inputStream = this.a("pack.mcmeta");){
            T t2 = ResourcePackAbstract.a(metaReader, inputStream);
            return t2;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static <T> T a(ResourcePackMetaParser<T> metaReader, InputStream inputStream) {
        void jsonObject3;
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
            JsonObject jsonObject = ChatDeserializer.a(bufferedReader);
        }
        catch (Exception exception) {
            b.error("Couldn't load {} metadata", (Object)metaReader.a(), (Object)exception);
            return null;
        }
        if (!jsonObject3.has(metaReader.a())) {
            return null;
        }
        try {
            return metaReader.a(ChatDeserializer.t((JsonObject)jsonObject3, metaReader.a()));
        }
        catch (Exception exception2) {
            b.error("Couldn't load {} metadata", (Object)metaReader.a(), (Object)exception2);
            return null;
        }
    }

    @Override
    @Override
    public String a() {
        return this.a.getName();
    }
}

