/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.destroystokyo.paper.PaperConfig;
import com.destroystokyo.paper.profile.CraftPlayerProfile;
import com.destroystokyo.paper.profile.PlayerProfile;
import com.destroystokyo.paper.proxy.VelocityProxy;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.exceptions.AuthenticationUnavailableException;
import com.mojang.authlib.properties.Property;
import com.mojang.logging.LogUtils;
import io.netty.buffer.Unpooled;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.papermc.paper.adventure.PaperAdventure;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.PrivateKey;
import java.util.Arrays;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import javax.annotation.Nullable;
import javax.crypto.SecretKey;
import net.minecraft.DefaultUncaughtExceptionHandler;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.ChatComponentText;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketPlayOutKickDisconnect;
import net.minecraft.network.protocol.login.PacketLoginInCustomPayload;
import net.minecraft.network.protocol.login.PacketLoginInEncryptionBegin;
import net.minecraft.network.protocol.login.PacketLoginInListener;
import net.minecraft.network.protocol.login.PacketLoginInStart;
import net.minecraft.network.protocol.login.PacketLoginOutCustomPayload;
import net.minecraft.network.protocol.login.PacketLoginOutDisconnect;
import net.minecraft.network.protocol.login.PacketLoginOutEncryptionBegin;
import net.minecraft.network.protocol.login.PacketLoginOutSetCompression;
import net.minecraft.network.protocol.login.PacketLoginOutSuccess;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.network.HandshakeListener;
import net.minecraft.util.CryptographyException;
import net.minecraft.util.MinecraftEncryption;
import net.minecraft.world.entity.player.EntityHuman;
import org.apache.commons.lang3.Validate;
import org.bukkit.craftbukkit.v1_18_R2.CraftServer;
import org.bukkit.craftbukkit.v1_18_R2.util.CraftChatMessage;
import org.bukkit.craftbukkit.v1_18_R2.util.Waitable;
import org.bukkit.event.Event;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import org.bukkit.event.player.PlayerPreLoginEvent;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public class LoginListener
implements PacketLoginInListener {
    private static final AtomicInteger b = new AtomicInteger(0);
    static final Logger c = LogUtils.getLogger();
    private static final int d = 600;
    private static final Random e = new Random();
    private final byte[] f = new byte[4];
    final MinecraftServer g;
    public final NetworkManager a;
    public EnumProtocolState h = EnumProtocolState.a;
    private int i;
    @Nullable
    public GameProfile j;
    private final String k;
    @Nullable
    private EntityPlayer l;
    public String hostname = "";
    private int velocityLoginMessageId = -1;
    public boolean iKnowThisMayNotBeTheBestIdeaButPleaseDisableUsernameValidation = false;
    private static final AtomicInteger threadId = new AtomicInteger(0);
    private static final ExecutorService authenticatorPool = Executors.newCachedThreadPool(r2 -> {
        Thread ret = new Thread(r2, "User Authenticator #" + threadId.incrementAndGet());
        ret.setUncaughtExceptionHandler(new DefaultUncaughtExceptionHandler(c));
        return ret;
    });

    public LoginListener(MinecraftServer server, NetworkManager connection) {
        this.k = "";
        this.g = server;
        this.a = connection;
        e.nextBytes(this.f);
    }

    public void c() {
        EntityPlayer entityplayer;
        if (!MinecraftServer.getServer().v()) {
            this.b(CraftChatMessage.fromString(SpigotConfig.restartMessage)[0]);
            return;
        }
        if (this.h == EnumProtocolState.e) {
            if (this.a.h()) {
                this.d();
            }
        } else if (this.h == EnumProtocolState.f && (entityplayer = this.g.ac().getActivePlayer(this.j.getId())) == null) {
            this.h = EnumProtocolState.e;
            this.a(this.l);
            this.l = null;
        }
        if (this.i++ == 600) {
            this.b(new ChatMessage("multiplayer.disconnect.slow_login"));
        }
    }

    @Deprecated
    public void disconnect(String s2) {
        this.b(CraftChatMessage.fromString(s2, true)[0]);
    }

    @Override
    public NetworkManager a() {
        return this.a;
    }

    public void b(IChatBaseComponent reason) {
        try {
            c.info("Disconnecting {}: {}", (Object)this.e(), (Object)reason.getString());
            this.a.a(new PacketLoginOutDisconnect(reason));
            this.a.a(reason);
        }
        catch (Exception exception) {
            c.error("Error whilst disconnecting player", (Throwable)exception);
        }
    }

    public void initUUID() {
        UUID uuid = this.a.spoofedUUID != null ? this.a.spoofedUUID : EntityHuman.c(this.j.getName());
        this.j = new GameProfile(uuid, this.j.getName());
        if (this.a.spoofedProfile != null) {
            for (Property property : this.a.spoofedProfile) {
                if (!HandshakeListener.PROP_PATTERN.matcher(property.getName()).matches()) continue;
                this.j.getProperties().put((Object)property.getName(), (Object)property);
            }
        }
    }

    public void d() {
        EntityPlayer s2 = this.g.ac().canPlayerLogin(this, this.j, this.hostname);
        if (s2 != null) {
            this.h = EnumProtocolState.g;
            if (this.g.au() >= 0 && !this.a.d()) {
                this.a.a(new PacketLoginOutSetCompression(this.g.au()), (GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener)channelfuture -> this.a.a(this.g.au(), true)));
            }
            this.a.a(new PacketLoginOutSuccess(this.j));
            EntityPlayer entityplayer = this.g.ac().getActivePlayer(this.j.getId());
            try {
                EntityPlayer entityplayer1 = this.g.ac().getPlayerForLogin(this.j, s2);
                if (entityplayer != null) {
                    this.h = EnumProtocolState.f;
                    this.l = entityplayer1;
                } else {
                    this.a(entityplayer1);
                }
            }
            catch (Exception exception) {
                c.error("Couldn't place player in world", (Throwable)exception);
                ChatMessage chatmessage = new ChatMessage("multiplayer.disconnect.invalid_player_data");
                if (MinecraftServer.getServer().isDebugging()) {
                    exception.printStackTrace();
                }
                this.a.a(new PacketPlayOutKickDisconnect(chatmessage));
                this.a.a(chatmessage);
            }
        }
    }

    private void a(EntityPlayer player) {
        this.g.ac().a(this.a, player);
    }

    @Override
    public void a(IChatBaseComponent reason) {
        c.info("{} lost connection: {}", (Object)this.e(), (Object)reason.getString());
    }

    public String e() {
        String ip = PaperConfig.logPlayerIpAddresses ? String.valueOf(this.a.c()) : "<ip address withheld>";
        return this.j != null ? this.j + " (" + ip + ")" : String.valueOf(ip);
    }

    public static boolean validateUsername(String in) {
        if (in == null || in.isEmpty() || in.length() > 16) {
            return false;
        }
        int len = in.length();
        for (int i2 = 0; i2 < len; ++i2) {
            char c2 = in.charAt(i2);
            if (c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z' || c2 >= '0' && c2 <= '9' || c2 == '_' || c2 == '.') continue;
            return false;
        }
        return true;
    }

    @Override
    public void a(PacketLoginInStart packet) {
        Validate.validState((this.h == EnumProtocolState.a ? 1 : 0) != 0, (String)"Unexpected hello packet", (Object[])new Object[0]);
        this.j = packet.b();
        Validate.validState((boolean)LoginListener.a(this.j.getName()), (String)"Invalid characters in username", (Object[])new Object[0]);
        if (PaperConfig.isProxyOnlineMode() && PaperConfig.performUsernameValidation && !this.iKnowThisMayNotBeTheBestIdeaButPleaseDisableUsernameValidation && !LoginListener.validateUsername(this.j.getName())) {
            this.disconnect("Failed to verify username!");
            return;
        }
        if (this.g.U() && !this.a.d()) {
            this.h = EnumProtocolState.b;
            this.a.a(new PacketLoginOutEncryptionBegin("", this.g.L().getPublic().getEncoded(), this.f));
        } else {
            if (PaperConfig.velocitySupport) {
                this.velocityLoginMessageId = ThreadLocalRandom.current().nextInt();
                PacketLoginOutCustomPayload packet1 = new PacketLoginOutCustomPayload(this.velocityLoginMessageId, VelocityProxy.PLAYER_INFO_CHANNEL, new PacketDataSerializer(Unpooled.EMPTY_BUFFER));
                this.a.a(packet1);
                return;
            }
            authenticatorPool.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        LoginListener.this.initUUID();
                        new LoginHandler().fireEvents();
                    }
                    catch (Exception ex) {
                        LoginListener.this.disconnect("Failed to verify username!");
                        LoginListener.this.g.server.getLogger().log(Level.WARNING, "Exception verifying " + LoginListener.this.j.getName(), ex);
                    }
                }
            });
        }
    }

    public static boolean a(String name) {
        return name.chars().filter(i2 -> i2 <= 32 || i2 >= 127).findAny().isEmpty();
    }

    @Override
    public void a(PacketLoginInEncryptionBegin packet) {
        String s2;
        Validate.validState((this.h == EnumProtocolState.b ? 1 : 0) != 0, (String)"Unexpected key packet", (Object[])new Object[0]);
        PrivateKey privatekey = this.g.L().getPrivate();
        try {
            if (!Arrays.equals(this.f, packet.b(privatekey))) {
                throw new IllegalStateException("Protocol error");
            }
            SecretKey secretkey = packet.a(privatekey);
            s2 = new BigInteger(MinecraftEncryption.a("", this.g.L().getPublic(), secretkey)).toString(16);
            this.h = EnumProtocolState.c;
            this.a.setupEncryption(secretkey);
        }
        catch (CryptographyException cryptographyexception) {
            throw new IllegalStateException("Protocol error", cryptographyexception);
        }
        authenticatorPool.execute(new Runnable(){

            @Override
            public void run() {
                GameProfile gameprofile = LoginListener.this.j;
                try {
                    LoginListener.this.j = LoginListener.this.g.am().hasJoinedServer(new GameProfile((UUID)null, gameprofile.getName()), s2, this.getAddress());
                    if (LoginListener.this.j != null) {
                        if (!LoginListener.this.a.h()) {
                            return;
                        }
                        new LoginHandler().fireEvents();
                    } else if (LoginListener.this.g.O()) {
                        c.warn("Failed to verify username but will let them in anyway!");
                        LoginListener.this.j = LoginListener.this.a(gameprofile);
                        LoginListener.this.h = EnumProtocolState.e;
                    } else {
                        LoginListener.this.b(new ChatMessage("multiplayer.disconnect.unverified_username"));
                        c.error("Username '{}' tried to join with an invalid session", (Object)gameprofile.getName());
                    }
                }
                catch (AuthenticationUnavailableException authenticationunavailableexception) {
                    if (LoginListener.this.g.O()) {
                        c.warn("Authentication servers are down but will let them in anyway!");
                        LoginListener.this.j = LoginListener.this.a(gameprofile);
                        LoginListener.this.h = EnumProtocolState.e;
                    } else {
                        if (PaperConfig.authenticationServersDownKickMessage != null) {
                            LoginListener.this.b(new ChatComponentText(PaperConfig.authenticationServersDownKickMessage));
                        } else {
                            LoginListener.this.b(new ChatMessage("multiplayer.disconnect.authservers_down"));
                        }
                        c.error("Couldn't verify username because servers are unavailable");
                    }
                }
                catch (Exception exception) {
                    LoginListener.this.disconnect("Failed to verify username!");
                    LoginListener.this.g.server.getLogger().log(Level.WARNING, "Exception verifying " + gameprofile.getName(), exception);
                }
            }

            @Nullable
            private InetAddress getAddress() {
                SocketAddress socketaddress = LoginListener.this.a.c();
                return LoginListener.this.g.V() && socketaddress instanceof InetSocketAddress ? ((InetSocketAddress)socketaddress).getAddress() : null;
            }
        });
    }

    @Override
    public void a(PacketLoginInCustomPayload packet) {
        if (PaperConfig.velocitySupport && packet.b() == this.velocityLoginMessageId) {
            PacketDataSerializer buf = packet.c();
            if (buf == null) {
                this.disconnect("This server requires you to connect with Velocity.");
                return;
            }
            if (!VelocityProxy.checkIntegrity(buf)) {
                this.disconnect("Unable to verify player details");
                return;
            }
            SocketAddress listening = this.a.c();
            int port = 0;
            if (listening instanceof InetSocketAddress) {
                port = ((InetSocketAddress)listening).getPort();
            }
            this.a.n = new InetSocketAddress(VelocityProxy.readAddress(buf), port);
            this.j = VelocityProxy.createProfile(buf);
            authenticatorPool.execute(() -> {
                try {
                    new LoginHandler().fireEvents();
                }
                catch (Exception ex) {
                    this.disconnect("Failed to verify username!");
                    this.g.server.getLogger().log(Level.WARNING, "Exception verifying " + this.j.getName(), ex);
                }
            });
            return;
        }
        this.b(new ChatMessage("multiplayer.disconnect.unexpected_query_response"));
    }

    protected GameProfile a(GameProfile profile) {
        UUID uuid = EntityHuman.c(profile.getName());
        return new GameProfile(uuid, profile.getName());
    }

    public static enum EnumProtocolState {
        a,
        b,
        c,
        d,
        e,
        f,
        g;

    }

    public class LoginHandler {
        public void fireEvents() throws Exception {
            if (LoginListener.this.velocityLoginMessageId == -1 && PaperConfig.velocitySupport) {
                LoginListener.this.disconnect("This server requires you to connect with Velocity.");
                return;
            }
            String playerName = LoginListener.this.j.getName();
            InetAddress address = ((InetSocketAddress)LoginListener.this.a.c()).getAddress();
            InetAddress rawAddress = ((InetSocketAddress)LoginListener.this.a.getRawAddress()).getAddress();
            UUID uniqueId = LoginListener.this.j.getId();
            CraftServer server = LoginListener.this.g.server;
            PlayerProfile profile = CraftPlayerProfile.asBukkitMirror(LoginListener.this.j);
            AsyncPlayerPreLoginEvent asyncEvent = new AsyncPlayerPreLoginEvent(playerName, address, rawAddress, uniqueId, profile, LoginListener.this.hostname);
            server.getPluginManager().callEvent((Event)asyncEvent);
            profile = asyncEvent.getPlayerProfile();
            profile.complete(true);
            LoginListener.this.j = CraftPlayerProfile.asAuthlibCopy(profile);
            playerName = LoginListener.this.j.getName();
            uniqueId = LoginListener.this.j.getId();
            if (PlayerPreLoginEvent.getHandlerList().getRegisteredListeners().length != 0) {
                PlayerPreLoginEvent event = new PlayerPreLoginEvent(playerName, address, uniqueId);
                if (asyncEvent.getResult() != PlayerPreLoginEvent.Result.ALLOWED) {
                    event.disallow(asyncEvent.getResult(), asyncEvent.kickMessage());
                }
                Waitable<PlayerPreLoginEvent.Result> waitable = new Waitable<PlayerPreLoginEvent.Result>(this, server, event){
                    final /* synthetic */ CraftServer val$server;
                    final /* synthetic */ PlayerPreLoginEvent val$event;
                    final /* synthetic */ LoginHandler this$1;
                    {
                        this.this$1 = this$1;
                        this.val$server = craftServer;
                        this.val$event = playerPreLoginEvent;
                    }

                    protected PlayerPreLoginEvent.Result evaluate() {
                        this.val$server.getPluginManager().callEvent((Event)this.val$event);
                        return this.val$event.getResult();
                    }
                };
                LoginListener.this.g.processQueue.add(waitable);
                if (waitable.get() != PlayerPreLoginEvent.Result.ALLOWED) {
                    LoginListener.this.b(PaperAdventure.asVanilla(event.kickMessage()));
                    return;
                }
            } else if (asyncEvent.getLoginResult() != AsyncPlayerPreLoginEvent.Result.ALLOWED) {
                LoginListener.this.b(PaperAdventure.asVanilla(asyncEvent.kickMessage()));
                return;
            }
            c.info("UUID of player {} is {}", (Object)LoginListener.this.j.getName(), (Object)LoginListener.this.j.getId());
            LoginListener.this.h = EnumProtocolState.e;
        }
    }
}

