/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.destroystokyo.paper.PaperConfig;
import com.destroystokyo.paper.event.player.PlayerHandshakeEvent;
import com.destroystokyo.paper.network.PaperNetworkClient;
import com.google.gson.Gson;
import com.mojang.authlib.properties.Property;
import com.mojang.util.UUIDTypeAdapter;
import io.netty.channel.unix.DomainSocketAddress;
import io.papermc.paper.adventure.PaperAdventure;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.regex.Pattern;
import net.minecraft.SharedConstants;
import net.minecraft.network.EnumProtocol;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.chat.ChatComponentText;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.handshake.PacketHandshakingInListener;
import net.minecraft.network.protocol.handshake.PacketHandshakingInSetProtocol;
import net.minecraft.network.protocol.login.PacketLoginOutDisconnect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.network.LoginListener;
import net.minecraft.server.network.PacketStatusListener;
import org.apache.logging.log4j.LogManager;
import org.bukkit.craftbukkit.v1_18_R2.util.CraftChatMessage;
import org.spigotmc.SpigotConfig;

public class HandshakeListener
implements PacketHandshakingInListener {
    private static final Gson gson = new Gson();
    static final Pattern HOST_PATTERN = Pattern.compile("[0-9a-f\\.:]{0,45}");
    static final Pattern PROP_PATTERN = Pattern.compile("\\w{0,16}");
    private static final HashMap<InetAddress, Long> throttleTracker = new HashMap();
    private static int throttleCounter = 0;
    private static final IChatBaseComponent a = new ChatComponentText("Ignoring status request");
    private final MinecraftServer b;
    private final NetworkManager c;
    private static final boolean BYPASS_HOSTCHECK = Boolean.getBoolean("Paper.bypassHostCheck");

    public HandshakeListener(MinecraftServer server, NetworkManager connection) {
        this.b = server;
        this.c = connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void a(PacketHandshakingInSetProtocol packet) {
        switch (1.$SwitchMap$net$minecraft$network$ConnectionProtocol[packet.b().ordinal()]) {
            case 1: {
                this.c.a(EnumProtocol.d);
                try {
                    if (this.c.m.localAddress() instanceof DomainSocketAddress) ** GOTO lbl35
                    currentTime = System.currentTimeMillis();
                    connectionThrottle = this.b.server.getConnectionThrottle();
                    address = ((InetSocketAddress)this.c.c()).getAddress();
                    var7_10 = HandshakeListener.throttleTracker;
                    synchronized (var7_10) {
                        if (HandshakeListener.throttleTracker.containsKey(address) && !"127.0.0.1".equals(address.getHostAddress()) && currentTime - HandshakeListener.throttleTracker.get(address) < connectionThrottle) {
                            HandshakeListener.throttleTracker.put(address, currentTime);
                            chatmessage = CraftChatMessage.fromString(PaperConfig.connectionThrottleKickMessage, true)[0];
                            this.c.a(new PacketLoginOutDisconnect(chatmessage));
                            this.c.a(chatmessage);
                            return;
                        }
                        HandshakeListener.throttleTracker.put(address, currentTime);
                        if (++HandshakeListener.throttleCounter > 200) {
                            HandshakeListener.throttleCounter = 0;
                            iter = HandshakeListener.throttleTracker.entrySet().iterator();
                            while (iter.hasNext()) {
                                entry = iter.next();
                                if (entry.getValue() <= connectionThrottle) continue;
                                iter.remove();
                            }
                        }
                    }
                }
                catch (Throwable t) {
                    LogManager.getLogger().debug("Failed to check connection throttle", t);
                }
lbl35:
                // 3 sources

                if (packet.c() != SharedConstants.b().getProtocolVersion()) {
                    chatmessage = packet.c() < SharedConstants.b().getProtocolVersion() ? CraftChatMessage.fromString(MessageFormat.format(SpigotConfig.outdatedClientMessage.replaceAll("'", "''"), new Object[]{SharedConstants.b().getName()}), true)[0] : CraftChatMessage.fromString(MessageFormat.format(SpigotConfig.outdatedServerMessage.replaceAll("'", "''"), new Object[]{SharedConstants.b().getName()}), true)[0];
                    this.c.a(new PacketLoginOutDisconnect(chatmessage));
                    this.c.a(chatmessage);
                    break;
                }
                this.c.a(new LoginListener(this.b, this.c));
                proxyLogicEnabled = SpigotConfig.bungee;
                handledByEvent = false;
                if (PlayerHandshakeEvent.getHandlerList().getRegisteredListeners().length != 0 && (event = new PlayerHandshakeEvent(packet.c, hostnameOfRemote = (socketAddress = this.c.n) instanceof InetSocketAddress != false ? ((InetSocketAddress)socketAddress).getHostString() : InetAddress.getLoopbackAddress().getHostAddress(), proxyLogicEnabled == false)).callEvent()) {
                    if (event.isFailed()) {
                        component = PaperAdventure.asVanilla(event.failMessage());
                        this.c.a(new PacketLoginOutDisconnect(component));
                        this.c.a(component);
                        return;
                    }
                    if (event.getServerHostname() != null) {
                        packet.c = event.getServerHostname();
                    }
                    if (event.getSocketAddressHostname() != null) {
                        this.c.n = new InetSocketAddress(event.getSocketAddressHostname(), socketAddress instanceof InetSocketAddress != false ? ((InetSocketAddress)socketAddress).getPort() : 0);
                    }
                    this.c.spoofedUUID = event.getUniqueId();
                    this.c.spoofedProfile = (Property[])HandshakeListener.gson.fromJson(event.getPropertiesJson(), Property[].class);
                    handledByEvent = true;
                }
                split = packet.c.split("\u0000");
                if (!handledByEvent && proxyLogicEnabled) {
                    if (split.length != 3 && split.length != 4 || !HandshakeListener.BYPASS_HOSTCHECK && !HandshakeListener.HOST_PATTERN.matcher(split[1]).matches()) {
                        chatmessage = new ChatMessage("If you wish to use IP forwarding, please enable it in your BungeeCord config as well!");
                        this.c.a(new PacketLoginOutDisconnect(chatmessage));
                        this.c.a(chatmessage);
                        return;
                    }
                    socketAddress = this.c.c();
                    packet.c = split[0];
                    this.c.n = new InetSocketAddress(split[1], socketAddress instanceof InetSocketAddress != false ? ((InetSocketAddress)socketAddress).getPort() : 0);
                    this.c.spoofedUUID = UUIDTypeAdapter.fromString((String)split[2]);
                    if (split.length == 4) {
                        this.c.spoofedProfile = (Property[])HandshakeListener.gson.fromJson(split[3], Property[].class);
                    }
                } else if ((split.length == 3 || split.length == 4) && HandshakeListener.HOST_PATTERN.matcher(split[1]).matches()) {
                    chatmessage = new ChatMessage("Unknown data in login hostname, did you forget to enable BungeeCord in spigot.yml?");
                    this.c.a(new PacketLoginOutDisconnect(chatmessage));
                    this.c.a(chatmessage);
                    return;
                }
                ((LoginListener)this.c.j()).hostname = packet.c + ":" + packet.d;
                break;
            }
            case 2: {
                if (this.b.ai()) {
                    this.c.a(EnumProtocol.c);
                    this.c.a(new PacketStatusListener(this.b, this.c));
                    break;
                }
                this.c.a(HandshakeListener.a);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Invalid intention " + packet.b());
            }
        }
        this.c.protocolVersion = packet.c();
        this.c.virtualHost = PaperNetworkClient.prepareVirtualHost(packet.c, packet.d);
    }

    @Override
    public void a(IChatBaseComponent reason) {
    }

    @Override
    public NetworkManager a() {
        return this.c;
    }
}

