/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.mojang.logging.LogUtils;
import io.papermc.paper.util.TraceUtil;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.util.MathHelper;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ITileEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.IChunkProvider;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.lighting.LightEngine;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.ticks.LevelTickAccess;
import net.minecraft.world.ticks.TickListWorldGen;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.slf4j.Logger;

public class RegionLimitedWorldAccess
implements GeneratorAccessSeed {
    private static final Logger a = LogUtils.getLogger();
    private final List<IChunkAccess> b;
    private final IChunkAccess c;
    private final int d;
    private final WorldServer e;
    private final long f;
    private final WorldData g;
    private final Random h;
    private final DimensionManager i;
    private final TickListWorldGen<Block> j = new TickListWorldGen(blockposition -> this.z((BlockPosition)blockposition).o());
    private final TickListWorldGen<FluidType> k = new TickListWorldGen(blockposition -> this.z((BlockPosition)blockposition).p());
    private final BiomeManager l;
    private final ChunkCoordIntPair m;
    private final ChunkCoordIntPair n;
    private final StructureManager o;
    private final ChunkStatus p;
    private final int q;
    @Nullable
    private Supplier<String> r;
    private final AtomicLong s = new AtomicLong();
    private boolean hasSetFarWarned = false;

    public RegionLimitedWorldAccess(WorldServer world, List<IChunkAccess> chunks, ChunkStatus status, int placementRadius) {
        this.p = status;
        this.q = placementRadius;
        int j2 = MathHelper.b(Math.sqrt(chunks.size()));
        if (j2 * j2 != chunks.size()) {
            throw SystemUtils.c(new IllegalStateException("Cache size is not a square."));
        }
        this.b = chunks;
        this.c = chunks.get(chunks.size() / 2);
        this.d = j2;
        this.e = world;
        this.f = world.D();
        this.g = world.n_();
        this.h = world.r_();
        this.i = world.q_();
        this.l = new BiomeManager(this, BiomeManager.a(this.f));
        this.m = chunks.get(0).f();
        this.n = chunks.get(chunks.size() - 1).f();
        this.o = world.a().a(this);
    }

    public ChunkCoordIntPair a() {
        return this.c.f();
    }

    @Override
    public void a(@Nullable Supplier<String> structureName) {
        this.r = structureName;
    }

    @Override
    public IChunkAccess a(int chunkX, int chunkZ) {
        return this.a(chunkX, chunkZ, ChunkStatus.c);
    }

    @Override
    @Nullable
    public IChunkAccess a(int chunkX, int chunkZ, ChunkStatus leastStatus, boolean create) {
        IChunkAccess ichunkaccess;
        if (this.b(chunkX, chunkZ)) {
            int k2 = chunkX - this.m.c;
            int l2 = chunkZ - this.m.d;
            ichunkaccess = this.b.get(k2 + l2 * this.d);
            if (ichunkaccess.j().b(leastStatus)) {
                return ichunkaccess;
            }
        } else {
            ichunkaccess = null;
        }
        if (!create) {
            return null;
        }
        a.error("Requested chunk : {} {}", (Object)chunkX, (Object)chunkZ);
        a.error("Region bounds : {} {} | {} {}", new Object[]{this.m.c, this.m.d, this.n.c, this.n.d});
        if (ichunkaccess != null) {
            throw SystemUtils.c(new RuntimeException(String.format("Chunk is not of correct status. Expecting %s, got %s | %s %s", leastStatus, ichunkaccess.j(), chunkX, chunkZ)));
        }
        throw SystemUtils.c(new RuntimeException(String.format("We are asking a region for a chunk out of bound | %s %s", chunkX, chunkZ)));
    }

    @Override
    public boolean b(int chunkX, int chunkZ) {
        return chunkX >= this.m.c && chunkX <= this.n.c && chunkZ >= this.m.d && chunkZ <= this.n.d;
    }

    @Override
    @Nullable
    public IChunkAccess getChunkIfLoadedImmediately(int x2, int z2) {
        return this.a(x2, z2, ChunkStatus.o, false);
    }

    @Override
    public final IBlockData getBlockStateIfLoaded(BlockPosition blockposition) {
        IChunkAccess chunk = this.getChunkIfLoadedImmediately(blockposition.u() >> 4, blockposition.w() >> 4);
        return chunk == null ? null : chunk.a_(blockposition);
    }

    @Override
    public final Fluid getFluidIfLoaded(BlockPosition blockposition) {
        IChunkAccess chunk = this.getChunkIfLoadedImmediately(blockposition.u() >> 4, blockposition.w() >> 4);
        return chunk == null ? null : chunk.b_(blockposition);
    }

    @Override
    public IBlockData a_(BlockPosition pos) {
        return this.a(SectionPosition.a(pos.u()), SectionPosition.a(pos.w())).a_(pos);
    }

    @Override
    public Fluid b_(BlockPosition pos) {
        return this.z(pos).b_(pos);
    }

    @Override
    @Nullable
    public EntityHuman a(double x2, double y2, double z2, double maxDistance, Predicate<Entity> targetPredicate) {
        return null;
    }

    @Override
    public int o_() {
        return 0;
    }

    @Override
    public BiomeManager s_() {
        return this.l;
    }

    @Override
    public Holder<BiomeBase> a(int biomeX, int biomeY, int biomeZ) {
        return this.e.a(biomeX, biomeY, biomeZ);
    }

    @Override
    public float a(EnumDirection direction, boolean shaded) {
        return 1.0f;
    }

    @Override
    public LightEngine l_() {
        return this.e.l_();
    }

    @Override
    public boolean a(BlockPosition pos, boolean drop, @Nullable Entity breakingEntity, int maxUpdateDepth) {
        IBlockData iblockdata = this.a_(pos);
        if (iblockdata.g()) {
            return false;
        }
        return this.a(pos, Blocks.a.n(), 3, maxUpdateDepth);
    }

    @Override
    @Nullable
    public TileEntity c_(BlockPosition pos) {
        IChunkAccess ichunkaccess = this.z(pos);
        TileEntity tileentity = ichunkaccess.c_(pos);
        if (tileentity != null) {
            return tileentity;
        }
        NBTTagCompound nbttagcompound = ichunkaccess.f(pos);
        IBlockData iblockdata = ichunkaccess.a_(pos);
        if (nbttagcompound != null) {
            if ("DUMMY".equals(nbttagcompound.l("id"))) {
                if (!iblockdata.n()) {
                    return null;
                }
                tileentity = ((ITileEntity)((Object)iblockdata.b())).a(pos, iblockdata);
            } else {
                tileentity = TileEntity.a(pos, iblockdata, nbttagcompound);
            }
            if (tileentity != null) {
                ichunkaccess.a(tileentity);
                return tileentity;
            }
        }
        if (iblockdata.n()) {
            a.warn("Tried to access a block entity before it was created. {}", (Object)pos);
        }
        return null;
    }

    @Override
    public boolean e_(BlockPosition pos) {
        int i2 = SectionPosition.a(pos.u());
        int j2 = SectionPosition.a(pos.w());
        ChunkCoordIntPair chunkcoordintpair = this.a();
        int k2 = Math.abs(chunkcoordintpair.c - i2);
        int l2 = Math.abs(chunkcoordintpair.d - j2);
        if (k2 <= this.q && l2 <= this.q) {
            if (this.c.y()) {
                LevelHeightAccessor levelheightaccessor = this.c.z();
                if (pos.v() < levelheightaccessor.u_() || pos.v() >= levelheightaccessor.ag()) {
                    return false;
                }
            }
            return true;
        }
        if (!this.hasSetFarWarned) {
            SystemUtils.a("Detected setBlock in a far chunk [" + i2 + ", " + j2 + "], pos: " + pos + ", status: " + this.p + (String)(this.r == null ? "" : ", currently generating: " + this.r.get()));
            this.hasSetFarWarned = true;
            if (this.n() != null && this.n().isDebugging()) {
                TraceUtil.dumpTraceForThread("far setBlock call");
            }
        }
        return false;
    }

    @Override
    public boolean a(BlockPosition pos, IBlockData state, int flags, int maxUpdateDepth) {
        if (!this.e_(pos)) {
            return false;
        }
        IChunkAccess ichunkaccess = this.z(pos);
        IBlockData iblockdata1 = ichunkaccess.a(pos, state, false);
        if (iblockdata1 != null) {
            this.e.a(pos, iblockdata1, state);
        }
        if (state.n()) {
            if (ichunkaccess.j().g() == ChunkStatus.Type.b) {
                TileEntity tileentity = ((ITileEntity)((Object)state.b())).a(pos, state);
                if (tileentity != null) {
                    ichunkaccess.a(tileentity);
                } else {
                    ichunkaccess.d(pos);
                }
            } else {
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                nbttagcompound.a("x", pos.u());
                nbttagcompound.a("y", pos.v());
                nbttagcompound.a("z", pos.w());
                nbttagcompound.a("id", "DUMMY");
                ichunkaccess.a(nbttagcompound);
            }
        } else if (iblockdata1 != null && iblockdata1.n()) {
            ichunkaccess.d(pos);
        }
        if (state.q(this, pos)) {
            this.f(pos);
        }
        return true;
    }

    private void f(BlockPosition pos) {
        this.z(pos).e(pos);
    }

    @Override
    public boolean b(Entity entity) {
        return this.addFreshEntity(entity, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    @Override
    public boolean addFreshEntity(Entity entity, CreatureSpawnEvent.SpawnReason reason) {
        int i2 = SectionPosition.a(entity.db());
        int j2 = SectionPosition.a(entity.dh());
        this.a(i2, j2).a(entity);
        return true;
    }

    @Override
    public boolean a(BlockPosition pos, boolean move) {
        return this.a(pos, Blocks.a.n(), 3);
    }

    @Override
    public WorldBorder p_() {
        return this.e.p_();
    }

    @Override
    public boolean k_() {
        return false;
    }

    @Override
    @Deprecated
    public WorldServer F() {
        return this.e;
    }

    @Override
    public IRegistryCustom s() {
        return this.e.s();
    }

    @Override
    public WorldData n_() {
        return this.g;
    }

    @Override
    public DifficultyDamageScaler d_(BlockPosition pos) {
        if (!this.b(SectionPosition.a(pos.u()), SectionPosition.a(pos.w()))) {
            throw new RuntimeException("We are asking a region for a chunk out of bound");
        }
        return new DifficultyDamageScaler(this.e.af(), this.e.V(), 0L, this.e.ak());
    }

    @Override
    @Nullable
    public MinecraftServer n() {
        return this.e.n();
    }

    @Override
    public IChunkProvider K() {
        return this.e.k();
    }

    @Override
    public long D() {
        return this.f;
    }

    @Override
    public LevelTickAccess<Block> M() {
        return this.j;
    }

    @Override
    public LevelTickAccess<FluidType> L() {
        return this.k;
    }

    @Override
    public int m_() {
        return this.e.m_();
    }

    @Override
    public Random r_() {
        return this.h;
    }

    @Override
    public int a(HeightMap.Type heightmap, int x2, int z2) {
        return this.a(SectionPosition.a(x2), SectionPosition.a(z2)).a(heightmap, x2 & 0xF, z2 & 0xF) + 1;
    }

    @Override
    public void a(@Nullable EntityHuman player, BlockPosition pos, SoundEffect sound, SoundCategory category, float volume, float pitch) {
    }

    @Override
    public void a(ParticleParam parameters, double x2, double y2, double z2, double velocityX, double velocityY, double velocityZ) {
    }

    @Override
    public void a(@Nullable EntityHuman player, int eventId, BlockPosition pos, int data) {
    }

    @Override
    public void a(@Nullable Entity entity, GameEvent event, BlockPosition pos) {
    }

    @Override
    public DimensionManager q_() {
        return this.i;
    }

    @Override
    public boolean a(BlockPosition pos, Predicate<IBlockData> state) {
        return state.test(this.a_(pos));
    }

    @Override
    public boolean b(BlockPosition pos, Predicate<Fluid> state) {
        return state.test(this.b_(pos));
    }

    @Override
    public <T extends Entity> List<T> a(EntityTypeTest<Entity, T> filter, AxisAlignedBB box, Predicate<? super T> predicate) {
        return Collections.emptyList();
    }

    @Override
    public List<Entity> a(@Nullable Entity except, AxisAlignedBB box, @Nullable Predicate<? super Entity> predicate) {
        return Collections.emptyList();
    }

    public List<EntityHuman> y() {
        return Collections.emptyList();
    }

    @Override
    public int u_() {
        return this.e.u_();
    }

    @Override
    public int v_() {
        return this.e.v_();
    }

    @Override
    public long t_() {
        return this.s.getAndIncrement();
    }

    @Override
    public List<Entity> getHardCollidingEntities(Entity except, AxisAlignedBB box, Predicate<? super Entity> predicate) {
        return Collections.emptyList();
    }

    @Override
    public void getEntities(Entity except, AxisAlignedBB box, Predicate<? super Entity> predicate, List<Entity> into) {
    }

    @Override
    public void getHardCollidingEntities(Entity except, AxisAlignedBB box, Predicate<? super Entity> predicate, List<Entity> into) {
    }

    @Override
    public <T> void getEntitiesByClass(Class<? extends T> clazz, Entity except, AxisAlignedBB box, List<? super T> into, Predicate<? super T> predicate) {
    }
}

