/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import co.aikar.timings.Timing;
import com.destroystokyo.paper.PaperWorldConfig;
import com.destroystokyo.paper.exception.ServerInternalException;
import com.destroystokyo.paper.io.IOUtil;
import com.destroystokyo.paper.io.PaperFileIOThread;
import com.destroystokyo.paper.io.chunk.ChunkTaskManager;
import com.destroystokyo.paper.util.SneakyThrow;
import com.destroystokyo.paper.util.map.QueuedChangesMapLong2Object;
import com.destroystokyo.paper.util.misc.PlayerAreaMap;
import com.destroystokyo.paper.util.misc.PooledLinkedHashSets;
import com.destroystokyo.paper.utils.CachedSizeConcurrentLinkedQueue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.papermc.paper.chunk.PlayerChunkLoader;
import io.papermc.paper.chunk.SingleThreadChunkRegionManager;
import io.papermc.paper.util.CoordinateUtils;
import io.papermc.paper.util.maplist.IteratorSafeOrderedReferenceSet;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ByteMap;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import it.unimi.dsi.fastutil.objects.ObjectRBTreeSet;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.SystemUtils;
import net.minecraft.core.IRegistry;
import net.minecraft.core.SectionPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.protocol.game.PacketPlayOutAttachEntity;
import net.minecraft.network.protocol.game.PacketPlayOutMount;
import net.minecraft.server.MCUtil;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.ChunkMapDistance;
import net.minecraft.server.level.ChunkTaskQueue;
import net.minecraft.server.level.ChunkTaskQueueSorter;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.LightEngineThreaded;
import net.minecraft.server.level.PlayerChunk;
import net.minecraft.server.level.PlayerMap;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.level.progress.WorldLoadListener;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.util.CSVWriter;
import net.minecraft.util.MathHelper;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.thread.IAsyncTaskHandler;
import net.minecraft.util.thread.Mailbox;
import net.minecraft.util.thread.ThreadedMailbox;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityWaterAnimal;
import net.minecraft.world.entity.boss.EntityComplexPart;
import net.minecraft.world.entity.npc.NPC;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkConverter;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.ILightAccess;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.ProtoChunkExtension;
import net.minecraft.world.level.chunk.storage.ChunkRegionLoader;
import net.minecraft.world.level.chunk.storage.IChunkLoader;
import net.minecraft.world.level.chunk.storage.RegionFile;
import net.minecraft.world.level.entity.ChunkStatusUpdateListener;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureManager;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.WorldPersistentData;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableObject;
import org.slf4j.Logger;
import org.spigotmc.AsyncCatcher;
import org.spigotmc.SpigotWorldConfig;
import org.spigotmc.TrackingRange;

public class PlayerChunkMap
extends IChunkLoader
implements PlayerChunk.e {
    private static final byte f = -1;
    private static final byte g = 0;
    private static final byte h = 1;
    private static final Logger i = LogUtils.getLogger();
    private static final int j = 200;
    private static final int k = 20;
    private static final int l = 10000;
    private static final int m = 3;
    public static final int a = 33;
    public static final int b = 33 + ChunkStatus.b();
    public final QueuedChangesMapLong2Object<PlayerChunk> updatingChunks = new QueuedChangesMapLong2Object();
    public static final int c = 31;
    private final Long2ObjectLinkedOpenHashMap<PlayerChunk> p;
    public final LongSet q;
    public final WorldServer r;
    private final LightEngineThreaded s;
    public final IAsyncTaskHandler<Runnable> t;
    final Executor mainInvokingExecutor;
    public ChunkGenerator u;
    public final Supplier<WorldPersistentData> v;
    private final VillagePlace w;
    public final LongSet x;
    private boolean y;
    private final ChunkTaskQueueSorter z;
    private final Mailbox<ChunkTaskQueueSorter.a<Runnable>> A;
    public final Mailbox<ChunkTaskQueueSorter.a<Runnable>> B;
    final Mailbox<ChunkTaskQueueSorter.a<Runnable>> mailboxLight;
    public final WorldLoadListener C;
    private final ChunkStatusUpdateListener D;
    public final ChunkDistanceManager E;
    private final AtomicInteger F;
    public final DefinedStructureManager G;
    private final String H;
    private final PlayerMap I;
    public final Int2ObjectMap<EntityTracker> J;
    private final Long2ByteMap K;
    private final Long2LongMap L;
    private final Queue<Runnable> M;
    int N;
    public final PlayerAreaMap playerMobDistanceMap;
    public final ReferenceOpenHashSet<PlayerChunk> needsChangeBroadcasting = new ReferenceOpenHashSet();
    public static final int GENERAL_AREA_MAP_SQUARE_RADIUS = 40;
    public static final double GENERAL_AREA_MAP_ACCEPTABLE_SEARCH_RANGE = 624.0;
    public static final double GENERAL_AREA_MAP_ACCEPTABLE_SEARCH_RANGE_SQUARED = 389376.0;
    public final PlayerAreaMap playerGeneralAreaMap;
    public final CallbackExecutor callbackExecutor = new CallbackExecutor();
    final CallbackExecutor chunkLoadConversionCallbackExecutor = new CallbackExecutor();
    private final PooledLinkedHashSets<EntityPlayer> pooledLinkedPlayerHashSets = new PooledLinkedHashSets();
    public final PlayerAreaMap playerMobSpawnMap;
    public final PlayerAreaMap playerChunkTickRangeMap;
    public final PlayerChunkLoader playerChunkManager = new PlayerChunkLoader(this, this.pooledLinkedPlayerHashSets);
    static final TrackingRange.TrackingRangeType[] TRACKING_RANGE_TYPES = TrackingRange.TrackingRangeType.values();
    public final PlayerAreaMap[] playerEntityTrackerTrackMaps;
    final int[] entityTrackerTrackRanges;
    public final List<SingleThreadChunkRegionManager> regionManagers = new ArrayList<SingleThreadChunkRegionManager>();
    public final SingleThreadChunkRegionManager dataRegionManager;
    boolean unloadingPlayerChunk = false;
    final ObjectRBTreeSet<PlayerChunk> autoSaveQueue = new ObjectRBTreeSet((playerchunk1, playerchunk2) -> {
        int timeCompare = Long.compare(playerchunk1.lastAutoSaveTime, playerchunk2.lastAutoSaveTime);
        if (timeCompare != 0) {
            return timeCompare;
        }
        return Long.compare(MCUtil.getCoordinateKey(playerchunk1.s), MCUtil.getCoordinateKey(playerchunk2.s));
    });

    public void addLightTask(PlayerChunk playerchunk, Runnable run) {
        this.mailboxLight.a(ChunkTaskQueueSorter.a(playerchunk, run));
    }

    public static boolean isLegacyTrackingEntity(Entity entity) {
        return entity.isLegacyTrackingEntity;
    }

    public final int getEntityTrackerRange(int ordinal) {
        return this.entityTrackerTrackRanges[ordinal];
    }

    private int convertSpigotRangeToVanilla(int vanilla) {
        return MinecraftServer.getServer().b(vanilla);
    }

    void addPlayerToDistanceMaps(EntityPlayer player) {
        this.playerChunkManager.addPlayer(player);
        int chunkX = MCUtil.getChunkCoordinate(player.dc());
        int chunkZ = MCUtil.getChunkCoordinate(player.di());
        int len = TRACKING_RANGE_TYPES.length;
        for (int i2 = 0; i2 < len; ++i2) {
            PlayerAreaMap trackMap = this.playerEntityTrackerTrackMaps[i2];
            int trackRange = this.entityTrackerTrackRanges[i2];
            trackMap.add(player, chunkX, chunkZ, Math.min(trackRange, PlayerChunkLoader.getSendViewDistance(player)));
        }
        this.playerChunkTickRangeMap.add(player, chunkX, chunkZ, 8);
        this.playerGeneralAreaMap.add(player, chunkX, chunkZ, 40);
        if (this.playerMobDistanceMap != null) {
            this.playerMobDistanceMap.add(player, chunkX, chunkZ, this.E.getSimulationDistance());
        }
    }

    void removePlayerFromDistanceMaps(EntityPlayer player) {
        int len = TRACKING_RANGE_TYPES.length;
        for (int i2 = 0; i2 < len; ++i2) {
            this.playerEntityTrackerTrackMaps[i2].remove(player);
        }
        this.playerMobSpawnMap.remove(player);
        this.playerChunkTickRangeMap.remove(player);
        this.playerGeneralAreaMap.remove(player);
        if (this.playerMobDistanceMap != null) {
            this.playerMobDistanceMap.remove(player);
        }
        this.playerChunkManager.removePlayer(player);
    }

    void updateMaps(EntityPlayer player) {
        int chunkX = MCUtil.getChunkCoordinate(player.dc());
        int chunkZ = MCUtil.getChunkCoordinate(player.di());
        int len = TRACKING_RANGE_TYPES.length;
        for (int i2 = 0; i2 < len; ++i2) {
            PlayerAreaMap trackMap = this.playerEntityTrackerTrackMaps[i2];
            int trackRange = this.entityTrackerTrackRanges[i2];
            trackMap.update(player, chunkX, chunkZ, Math.min(trackRange, PlayerChunkLoader.getSendViewDistance(player)));
        }
        this.playerChunkTickRangeMap.update(player, chunkX, chunkZ, 8);
        this.playerGeneralAreaMap.update(player, chunkX, chunkZ, 40);
        if (this.playerMobDistanceMap != null) {
            this.playerMobDistanceMap.update(player, chunkX, chunkZ, this.E.getSimulationDistance());
        }
        this.playerChunkManager.updatePlayer(player);
    }

    public final PlayerChunk getUnloadingChunkHolder(int chunkX, int chunkZ) {
        return (PlayerChunk)this.p.get(CoordinateUtils.getChunkKey(chunkX, chunkZ));
    }

    public PlayerChunkMap(WorldServer world, Convertable.ConversionSession session, DataFixer dataFixer, DefinedStructureManager structureManager, Executor executor, IAsyncTaskHandler<Runnable> mainThreadExecutor, ILightAccess chunkProvider, ChunkGenerator chunkGenerator, WorldLoadListener worldGenerationProgressListener, ChunkStatusUpdateListener chunkStatusChangeListener, Supplier<WorldPersistentData> persistentStateManagerFactory, int viewDistance, boolean dsync) {
        super(session.a(world.aa()).resolve("region"), dataFixer, dsync);
        ThreadedMailbox<Runnable> lightthreaded;
        this.p = new Long2ObjectLinkedOpenHashMap();
        this.q = new LongOpenHashSet();
        this.x = new LongOpenHashSet();
        this.F = new AtomicInteger();
        this.I = new PlayerMap();
        this.J = new Int2ObjectOpenHashMap();
        this.K = new Long2ByteOpenHashMap();
        this.L = new Long2LongOpenHashMap();
        this.G = structureManager;
        this.M = new CachedSizeConcurrentLinkedQueue();
        Path path = session.a(world.aa());
        this.H = path.getFileName().toString();
        this.r = world;
        this.u = chunkGenerator;
        this.t = mainThreadExecutor;
        this.mainInvokingExecutor = run -> {
            if (MCUtil.isMainThread()) {
                run.run();
            } else {
                mainThreadExecutor.execute(run);
            }
        };
        ThreadedMailbox<Runnable> threadedmailbox = ThreadedMailbox.a(executor, "worldgen");
        Objects.requireNonNull(mainThreadExecutor);
        Mailbox<Runnable> mailbox = Mailbox.a("main", mainThreadExecutor::i);
        this.C = worldGenerationProgressListener;
        this.D = chunkStatusChangeListener;
        ThreadedMailbox<Runnable> threadedmailbox1 = lightthreaded = ThreadedMailbox.a(executor, "light");
        this.z = new ChunkTaskQueueSorter((List<Mailbox<?>>)ImmutableList.of(threadedmailbox, mailbox, threadedmailbox1), executor, Integer.MAX_VALUE);
        this.A = this.z.a(threadedmailbox, false);
        this.B = this.z.a(mailbox, false);
        this.mailboxLight = this.z.a(lightthreaded, false);
        this.s = new LightEngineThreaded(chunkProvider, this, this.r.q_().a(), threadedmailbox1, this.z.a(threadedmailbox1, false));
        this.E = new ChunkDistanceManager(executor, mainThreadExecutor);
        this.v = persistentStateManagerFactory;
        this.w = new VillagePlace(path.resolve("poi"), dataFixer, dsync, world);
        this.a(viewDistance);
        this.dataRegionManager = new SingleThreadChunkRegionManager(this.r, 2, 0.3333333333333333, 1, 6, "Data", DataRegionData::new, DataRegionSectionData::new);
        this.regionManagers.add(this.dataRegionManager);
        this.playerMobDistanceMap = this.r.paperConfig.perPlayerMobSpawns ? new PlayerAreaMap(this.pooledLinkedPlayerHashSets) : null;
        this.playerEntityTrackerTrackMaps = new PlayerAreaMap[TRACKING_RANGE_TYPES.length];
        this.entityTrackerTrackRanges = new int[TRACKING_RANGE_TYPES.length];
        SpigotWorldConfig spigotWorldConfig = this.r.spigotConfig;
        for (TrackingRange.TrackingRangeType trackingRangeType : TRACKING_RANGE_TYPES) {
            int trackRange;
            int configuredSpigotValue = switch (trackingRangeType) {
                case TrackingRange.TrackingRangeType.PLAYER -> spigotWorldConfig.playerTrackingRange;
                case TrackingRange.TrackingRangeType.ANIMAL -> spigotWorldConfig.animalTrackingRange;
                case TrackingRange.TrackingRangeType.MONSTER -> spigotWorldConfig.monsterTrackingRange;
                case TrackingRange.TrackingRangeType.MISC -> spigotWorldConfig.miscTrackingRange;
                case TrackingRange.TrackingRangeType.OTHER -> spigotWorldConfig.otherTrackingRange;
                case TrackingRange.TrackingRangeType.ENDERDRAGON -> EntityTypes.v.n() * 16;
                default -> throw new IllegalStateException("Missing case for enum " + trackingRangeType);
            };
            configuredSpigotValue = this.convertSpigotRangeToVanilla(configuredSpigotValue);
            this.entityTrackerTrackRanges[ordinal] = trackRange = (configuredSpigotValue >>> 4) + ((configuredSpigotValue & 0xF) != 0 ? 1 : 0);
            this.playerEntityTrackerTrackMaps[ordinal] = new PlayerAreaMap(this.pooledLinkedPlayerHashSets);
        }
        this.playerChunkTickRangeMap = new PlayerAreaMap(this.pooledLinkedPlayerHashSets, (player, rangeX, rangeZ, currPosX, currPosZ, prevPosX, prevPosZ, newState) -> {
            PlayerChunk playerChunk = this.a(MCUtil.getCoordinateKey(rangeX, rangeZ));
            if (playerChunk != null) {
                playerChunk.playersInChunkTickRange = newState;
            }
        }, (player, rangeX, rangeZ, currPosX, currPosZ, prevPosX, prevPosZ, newState) -> {
            PlayerChunk playerChunk = this.a(MCUtil.getCoordinateKey(rangeX, rangeZ));
            if (playerChunk != null) {
                playerChunk.playersInChunkTickRange = newState;
            }
        });
        this.playerMobSpawnMap = new PlayerAreaMap(this.pooledLinkedPlayerHashSets, (player, rangeX, rangeZ, currPosX, currPosZ, prevPosX, prevPosZ, newState) -> {
            PlayerChunk playerChunk = this.a(MCUtil.getCoordinateKey(rangeX, rangeZ));
            if (playerChunk != null) {
                playerChunk.playersInMobSpawnRange = newState;
            }
        }, (player, rangeX, rangeZ, currPosX, currPosZ, prevPosX, prevPosZ, newState) -> {
            PlayerChunk playerChunk = this.a(MCUtil.getCoordinateKey(rangeX, rangeZ));
            if (playerChunk != null) {
                playerChunk.playersInMobSpawnRange = newState;
            }
        });
        this.playerGeneralAreaMap = new PlayerAreaMap(this.pooledLinkedPlayerHashSets, (player, rangeX, rangeZ, currPosX, currPosZ, prevPosX, prevPosZ, newState) -> {
            Chunk chunk = this.r.k().getChunkAtIfCachedImmediately(rangeX, rangeZ);
            if (chunk != null) {
                chunk.updateGeneralAreaCache(newState);
            }
        }, (player, rangeX, rangeZ, currPosX, currPosZ, prevPosX, prevPosZ, newState) -> {
            Chunk chunk = this.r.k().getChunkAtIfCachedImmediately(rangeX, rangeZ);
            if (chunk != null) {
                chunk.updateGeneralAreaCache(newState);
            }
        });
    }

    protected ChunkGenerator a() {
        return this.u;
    }

    public void b() {
        DataResult dataresult = ChunkGenerator.a.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this.u);
        DataResult dataresult1 = dataresult.flatMap(jsonelement -> ChunkGenerator.a.parse((DynamicOps)JsonOps.INSTANCE, jsonelement));
        dataresult1.result().ifPresent(chunkgenerator -> {
            this.u = chunkgenerator;
        });
    }

    public void queueHolderUpdate(PlayerChunk playerchunk) {
        Runnable runnable = () -> {
            if (this.isUnloading(playerchunk)) {
                return;
            }
            this.E.pendingChunkUpdates.add(playerchunk);
            if (!this.E.pollingPendingChunkUpdates) {
                this.r.k().q();
            }
        };
        if (MCUtil.isMainThread()) {
            runnable.run();
        } else {
            this.t.execute(runnable);
        }
    }

    private boolean isUnloading(PlayerChunk playerchunk) {
        return playerchunk == null || this.x.contains(playerchunk.s.a());
    }

    private void updateChunkPriorityMap(Long2IntOpenHashMap map, long chunk, int level) {
        int prev = map.getOrDefault(chunk, -1);
        if (level > prev) {
            map.put(chunk, level);
        }
    }

    public void updatePlayerMobTypeMap(Entity entity) {
        if (!this.r.paperConfig.perPlayerMobSpawns) {
            return;
        }
        int index = entity.ad().f().ordinal();
        PooledLinkedHashSets.PooledObjectLinkedOpenHashSet inRange = this.playerMobDistanceMap.getObjectsInRange(entity.cZ());
        if (inRange == null) {
            return;
        }
        E[] backingSet = inRange.getBackingSet();
        for (int i2 = 0; i2 < backingSet.length; ++i2) {
            Object e2 = backingSet[i2];
            if (!(e2 instanceof EntityPlayer)) continue;
            EntityPlayer player = (EntityPlayer)e2;
            int n2 = index;
            player.mobCounts[n2] = player.mobCounts[n2] + 1;
        }
    }

    public int getMobCountNear(EntityPlayer entityPlayer, EnumCreatureType mobCategory) {
        return entityPlayer.mobCounts[mobCategory.ordinal()];
    }

    private static double a(ChunkCoordIntPair pos, Entity entity) {
        double d0 = SectionPosition.a(pos.c, 8);
        double d1 = SectionPosition.a(pos.d, 8);
        double d2 = d0 - entity.dc();
        double d3 = d1 - entity.di();
        return d2 * d2 + d3 * d3;
    }

    public static boolean a(int x1, int z1, int x2, int z2, int distance) {
        int k2;
        int l2;
        int j1 = Math.max(0, Math.abs(x1 - x2) - 1);
        int k1 = Math.max(0, Math.abs(z1 - z2) - 1);
        long l1 = Math.max(0, Math.max(j1, k1) - 1);
        long i2 = Math.min(j1, k1);
        long j2 = i2 * i2 + l1 * l1;
        return j2 <= (long)(l2 = (k2 = distance - 1) * k2);
    }

    private static boolean b(int x1, int z1, int x2, int z2, int distance) {
        return !PlayerChunkMap.a(x1, z1, x2, z2, distance) ? false : (!PlayerChunkMap.a(x1 + 1, z1, x2, z2, distance) ? true : (!PlayerChunkMap.a(x1, z1 + 1, x2, z2, distance) ? true : (!PlayerChunkMap.a(x1 - 1, z1, x2, z2, distance) ? true : !PlayerChunkMap.a(x1, z1 - 1, x2, z2, distance))));
    }

    protected LightEngineThreaded c() {
        return this.s;
    }

    @Nullable
    public PlayerChunk a(long pos) {
        return this.updatingChunks.getUpdating(pos);
    }

    @Nullable
    public PlayerChunk b(long pos) {
        if (Thread.currentThread() == ((World)this.r).y) {
            return this.updatingChunks.getVisible(pos);
        }
        return this.updatingChunks.getVisibleAsync(pos);
    }

    protected IntSupplier c(long pos) {
        return () -> {
            PlayerChunk playerchunk = this.b(pos);
            return playerchunk == null ? ChunkTaskQueue.a - 1 : Math.min(playerchunk.l(), ChunkTaskQueue.a - 1);
        };
    }

    public String a(ChunkCoordIntPair chunkPos) {
        PlayerChunk playerchunk = this.b(chunkPos.a());
        if (playerchunk == null) {
            return "null";
        }
        String s2 = playerchunk.k() + "\n";
        ChunkStatus chunkstatus = playerchunk.f();
        IChunkAccess ichunkaccess = playerchunk.g();
        if (chunkstatus != null) {
            s2 = s2 + "St: \u00a7" + chunkstatus.c() + chunkstatus + "\u00a7r\n";
        }
        if (ichunkaccess != null) {
            s2 = s2 + "Ch: \u00a7" + ichunkaccess.j().c() + ichunkaccess.j() + "\u00a7r\n";
        }
        PlayerChunk.State playerchunk_state = playerchunk.i();
        s2 = s2 + "\u00a7" + playerchunk_state.ordinal() + playerchunk_state;
        return s2 + "\u00a7r";
    }

    public final int getEffectiveViewDistance() {
        return this.N - 1;
    }

    private CompletableFuture<Either<List<IChunkAccess>, PlayerChunk.Failure>> a(ChunkCoordIntPair centerChunk, final int margin, IntFunction<ChunkStatus> distanceToStatus) {
        ArrayList<CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>>> list = new ArrayList<CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>>>();
        ArrayList<PlayerChunk> list1 = new ArrayList<PlayerChunk>();
        final int j2 = centerChunk.c;
        final int k2 = centerChunk.d;
        PlayerChunk requestingNeighbor = this.a(centerChunk.a());
        for (int l2 = -margin; l2 <= margin; ++l2) {
            for (int i1 = -margin; i1 <= margin; ++i1) {
                int j1 = Math.max(Math.abs(i1), Math.abs(l2));
                final ChunkCoordIntPair chunkcoordintpair1 = new ChunkCoordIntPair(j2 + i1, k2 + l2);
                long k1 = chunkcoordintpair1.a();
                PlayerChunk playerchunk = this.a(k1);
                if (playerchunk == null) {
                    return CompletableFuture.completedFuture(Either.right(new PlayerChunk.Failure(){

                        public String toString() {
                            return "Unloaded " + chunkcoordintpair1;
                        }
                    }));
                }
                ChunkStatus chunkstatus = distanceToStatus.apply(j1);
                CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>> completablefuture = playerchunk.a(chunkstatus, this);
                if (requestingNeighbor != null && requestingNeighbor != playerchunk && !completablefuture.isDone()) {
                    requestingNeighbor.onNeighborRequest(playerchunk, chunkstatus);
                    completablefuture.thenAccept(either -> requestingNeighbor.onNeighborDone(playerchunk, chunkstatus, either.left().orElse(null)));
                }
                list1.add(playerchunk);
                list.add(completablefuture);
            }
        }
        CompletableFuture completablefuture1 = SystemUtils.b(list);
        CompletionStage completablefuture2 = completablefuture1.thenApply(list2 -> {
            ArrayList list3 = Lists.newArrayList();
            int cnt = 0;
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                final int l1 = cnt++;
                final Either either = (Either)iterator.next();
                if (either == null) {
                    throw this.a(new IllegalStateException("At least one of the chunk futures were null"), "n/a");
                }
                Optional optional = either.left();
                if (!optional.isPresent()) {
                    return Either.right(new PlayerChunk.Failure(){

                        public String toString() {
                            ChunkCoordIntPair chunkcoordintpair2 = new ChunkCoordIntPair(j2 + l1 % (margin * 2 + 1), k2 + l1 / (margin * 2 + 1));
                            return "Unloaded " + chunkcoordintpair2 + " " + either.right().get();
                        }
                    });
                }
                list3.add((IChunkAccess)optional.get());
            }
            return Either.left(list3);
        });
        for (PlayerChunk playerchunk1 : list1) {
            playerchunk1.a("getChunkRangeFuture " + centerChunk + " " + margin, (CompletableFuture<?>)completablefuture2);
        }
        return completablefuture2;
    }

    public ReportedException a(IllegalStateException exception, String s2) {
        StringBuilder stringbuilder = new StringBuilder();
        Consumer<PlayerChunk> consumer = playerchunk -> playerchunk.o().forEach(pair -> {
            ChunkStatus chunkstatus = (ChunkStatus)pair.getFirst();
            CompletableFuture completablefuture = (CompletableFuture)pair.getSecond();
            if (completablefuture != null && completablefuture.isDone() && completablefuture.join() == null) {
                stringbuilder.append(playerchunk.j()).append(" - status: ").append(chunkstatus).append(" future: ").append(completablefuture).append(System.lineSeparator());
            }
        });
        stringbuilder.append("Updating:").append(System.lineSeparator());
        this.updatingChunks.getUpdatingValuesCopy().forEach(consumer);
        stringbuilder.append("Visible:").append(System.lineSeparator());
        this.updatingChunks.getVisibleValuesCopy().forEach(consumer);
        CrashReport crashreport = CrashReport.a(exception, "Chunk loading");
        CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Chunk loading");
        crashreportsystemdetails.a("Details", s2);
        crashreportsystemdetails.a("Futures", stringbuilder);
        return new ReportedException(crashreport);
    }

    public CompletableFuture<Either<Chunk, PlayerChunk.Failure>> b(ChunkCoordIntPair pos) {
        return this.a(pos, 2, (int i2) -> ChunkStatus.o).thenApplyAsync(either -> either.mapLeft(list -> (Chunk)list.get(list.size() / 2)), this.mainInvokingExecutor);
    }

    @Nullable
    PlayerChunk a(long pos, int level, @Nullable PlayerChunk holder, int k2) {
        if (this.unloadingPlayerChunk) {
            MinecraftServer.q.error("Cannot tick distance manager while unloading playerchunks", new Throwable());
            throw new IllegalStateException("Cannot tick distance manager while unloading playerchunks");
        }
        if (k2 > b && level > b) {
            return holder;
        }
        if (holder != null) {
            holder.a(level);
        }
        if (holder != null) {
            if (level > b) {
                this.x.add(pos);
            } else {
                this.x.remove(pos);
            }
        }
        if (level <= b && holder == null) {
            holder = (PlayerChunk)this.p.remove(pos);
            if (holder != null) {
                holder.a(level);
                holder.onChunkAdd();
            } else {
                holder = new PlayerChunk(new ChunkCoordIntPair(pos), level, this.r, this.s, this.z, this);
                int len = this.regionManagers.size();
                for (int index = 0; index < len; ++index) {
                    this.regionManagers.get(index).addChunk(holder.s.c, holder.s.d);
                }
            }
            this.k().dequeueUnload(holder.s.longKey);
            this.updatingChunks.queueUpdate(pos, holder);
            this.y = true;
        }
        return holder;
    }

    @Override
    public void close() throws IOException {
        try {
            this.z.close();
            this.r.asyncChunkTaskManager.close(true);
            this.w.close();
        }
        finally {
            super.close();
        }
    }

    protected void saveIncrementally() {
        int savedThisTick = 0;
        ArrayList<PlayerChunk> reschedule = new ArrayList<PlayerChunk>(this.r.paperConfig.maxAutoSaveChunksPerTick);
        long currentTick = this.r.U();
        long maxSaveTime = currentTick - (long)this.r.paperConfig.autoSavePeriod;
        ObjectBidirectionalIterator iterator = this.autoSaveQueue.iterator();
        while (iterator.hasNext()) {
            PlayerChunk playerchunk = (PlayerChunk)iterator.next();
            if (playerchunk.lastAutoSaveTime > maxSaveTime) break;
            iterator.remove();
            IChunkAccess ichunkaccess = playerchunk.h().getNow(null);
            if (ichunkaccess instanceof Chunk) {
                boolean shouldSave;
                boolean bl = shouldSave = ((Chunk)ichunkaccess).lastSaveTime <= maxSaveTime;
                if (shouldSave && this.a(ichunkaccess) && this.r.O.a(playerchunk.s.a(), (T entity) -> {})) {
                    ++savedThisTick;
                    if (!playerchunk.setHasBeenLoaded()) {
                        playerchunk.inactiveTimeStart = currentTick;
                        if (savedThisTick < this.r.paperConfig.maxAutoSaveChunksPerTick) continue;
                        break;
                    }
                }
            }
            reschedule.add(playerchunk);
            if (savedThisTick < this.r.paperConfig.maxAutoSaveChunksPerTick) continue;
            break;
        }
        int len = reschedule.size();
        for (int i2 = 0; i2 < len; ++i2) {
            PlayerChunk playerchunk = (PlayerChunk)reschedule.get(i2);
            playerchunk.lastAutoSaveTime = this.r.U();
            this.autoSaveQueue.add((Object)playerchunk);
        }
    }

    protected void a(boolean flush) {
        int[] saved = new int[1];
        int maxAsyncSaves = 50;
        Runnable onChunkSave = () -> {
            saved[0] = saved[0] + 1;
            if (saved[0] >= maxAsyncSaves) {
                saved[0] = 0;
                PaperFileIOThread.Holder.INSTANCE.flush();
            }
        };
        if (flush) {
            List list = this.updatingChunks.getVisibleValuesCopy().stream().filter(PlayerChunk::m).peek(PlayerChunk::n).collect(Collectors.toList());
            MutableBoolean mutableboolean = new MutableBoolean();
            do {
                boolean isShuttingDown = this.r.n().hasStopped();
                mutableboolean.setFalse();
                list.stream().map(playerchunk -> {
                    CompletableFuture<IChunkAccess> completablefuture;
                    do {
                        completablefuture = playerchunk.h();
                        IAsyncTaskHandler<Runnable> iasynctaskhandler = this.t;
                        Objects.requireNonNull(completablefuture);
                        iasynctaskhandler.c(completablefuture::isDone);
                    } while (completablefuture != playerchunk.h());
                    return completablefuture.join();
                }).filter(ichunkaccess -> ichunkaccess instanceof ProtoChunkExtension || ichunkaccess instanceof Chunk).filter(this::a).forEach(ichunkaccess -> {
                    onChunkSave.run();
                    mutableboolean.setTrue();
                });
            } while (mutableboolean.isTrue());
            this.b(() -> true);
            this.r.asyncChunkTaskManager.flush();
        } else {
            this.updatingChunks.getVisibleValuesCopy().forEach(this::d);
        }
    }

    protected void a(BooleanSupplier shouldKeepTicking) {
        GameProfilerFiller gameprofilerfiller = this.r.ab();
        try (Timing ignored = this.r.timings.poiUnload.startTiming();){
            gameprofilerfiller.a("poi");
            this.w.a(shouldKeepTicking);
        }
        gameprofilerfiller.b("chunk_unload");
        if (!this.r.r()) {
            ignored = this.r.timings.chunkUnload.startTiming();
            try {
                this.b(shouldKeepTicking);
            }
            finally {
                if (ignored != null) {
                    ignored.close();
                }
            }
        }
        gameprofilerfiller.c();
    }

    public boolean d() {
        return this.s.A_() || !this.p.isEmpty() || !this.updatingChunks.getUpdatingValuesCopy().isEmpty() || this.w.a() || !this.x.isEmpty() || !this.M.isEmpty() || this.z.a() || this.E.f();
    }

    private void b(BooleanSupplier shouldKeepTicking) {
        Runnable runnable;
        LongIterator longiterator = this.x.iterator();
        int i2 = 0;
        while (longiterator.hasNext() && (shouldKeepTicking.getAsBoolean() || i2 < 200 || this.x.size() > 2000)) {
            long j2 = longiterator.nextLong();
            PlayerChunk playerchunk = this.updatingChunks.queueRemove(j2);
            if (playerchunk != null) {
                playerchunk.onChunkRemove();
                this.p.put(j2, (Object)playerchunk);
                this.y = true;
                ++i2;
                this.a(j2, playerchunk);
            }
            longiterator.remove();
        }
        for (int k2 = Math.max(100, this.M.size() - 2000); (shouldKeepTicking.getAsBoolean() || k2 > 0) && (runnable = this.M.poll()) != null; --k2) {
            runnable.run();
        }
        boolean l2 = false;
    }

    private void a(long pos, PlayerChunk holder) {
        CompletableFuture<IChunkAccess> completablefuture = holder.h();
        Consumer<IChunkAccess> consumer = ichunkaccess -> {
            block14: {
                CompletableFuture<IChunkAccess> completablefuture1 = holder.h();
                if (completablefuture1 != completablefuture) {
                    this.a(pos, holder);
                } else {
                    AsyncCatcher.catchOp("playerchunk unload");
                    boolean unloadingBefore = this.unloadingPlayerChunk;
                    this.unloadingPlayerChunk = true;
                    try {
                        boolean removed = this.p.remove(pos, (Object)holder);
                        if (removed && ichunkaccess != null) {
                            int len = this.regionManagers.size();
                            for (int index = 0; index < len; ++index) {
                                this.regionManagers.get(index).removeChunk(holder.s.c, holder.s.d);
                            }
                            this.k().queueUnload(holder.s.longKey, MinecraftServer.currentTickLong + 1L);
                            if (ichunkaccess instanceof Chunk) {
                                ((Chunk)ichunkaccess).c(false);
                            }
                            try {
                                this.asyncSave((IChunkAccess)ichunkaccess);
                            }
                            catch (ThreadDeath ex) {
                                throw ex;
                            }
                            catch (Throwable ex) {
                                i.error("Failed to prepare async save, attempting synchronous save", ex);
                                this.a((IChunkAccess)ichunkaccess);
                            }
                            if (this.q.remove(pos) && ichunkaccess instanceof Chunk) {
                                Chunk chunk = (Chunk)ichunkaccess;
                                this.r.a(chunk);
                            }
                            this.autoSaveQueue.remove((Object)holder);
                            this.s.a(ichunkaccess.f());
                            this.s.a();
                            this.C.a(ichunkaccess.f(), null);
                            this.L.remove(ichunkaccess.f().a());
                            break block14;
                        }
                        if (removed) {
                            int len = this.regionManagers.size();
                            for (int index = 0; index < len; ++index) {
                                this.regionManagers.get(index).removeChunk(holder.s.c, holder.s.d);
                            }
                            this.k().queueUnload(holder.s.longKey, MinecraftServer.currentTickLong + 1L);
                        }
                    }
                    finally {
                        this.unloadingPlayerChunk = unloadingBefore;
                    }
                }
            }
        };
        Queue<Runnable> queue = this.M;
        Objects.requireNonNull(this.M);
        ((CompletableFuture)completablefuture.thenAcceptAsync((Consumer)consumer, queue::add)).whenComplete((ovoid, throwable) -> {
            if (throwable != null) {
                i.error("Failed to save chunk {}", (Object)holder.j(), throwable);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean e() {
        if (!this.y) {
            return false;
        }
        QueuedChangesMapLong2Object<PlayerChunk> queuedChangesMapLong2Object = this.updatingChunks;
        synchronized (queuedChangesMapLong2Object) {
            this.updatingChunks.performUpdates();
        }
        this.y = false;
        return true;
    }

    public CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>> a(PlayerChunk holder, ChunkStatus requiredStatus) {
        ChunkCoordIntPair chunkcoordintpair = holder.j();
        if (requiredStatus == ChunkStatus.c) {
            return this.g(chunkcoordintpair);
        }
        CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>> future = holder.a(requiredStatus.e(), this);
        return ((CompletableFuture)future.thenComposeAsync(either -> {
            Optional optional = either.left();
            if (!optional.isPresent()) {
                return CompletableFuture.completedFuture(either);
            }
            if (requiredStatus == ChunkStatus.l) {
                this.E.a(TicketType.e, chunkcoordintpair, 33 + ChunkStatus.a(ChunkStatus.l), chunkcoordintpair);
            }
            if (optional.isPresent() && ((IChunkAccess)optional.get()).j().b(requiredStatus)) {
                CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>> completablefuture = requiredStatus.a(this.r, this.G, this.s, ichunkaccess -> this.c(holder), (IChunkAccess)optional.get());
                this.C.a(chunkcoordintpair, requiredStatus);
                return completablefuture;
            }
            return this.b(holder, requiredStatus);
        }, (Executor)this.t)).thenComposeAsync(CompletableFuture::completedFuture, (Executor)this.t);
    }

    private CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>> g(ChunkCoordIntPair pos) {
        boolean isHighestPriority;
        BiFunction<ChunkRegionLoader.InProgressChunkHolder, Throwable, Either> syncLoadComplete = (chunkHolder, ioThrowable) -> {
            block17: {
                try (Timing ignored = this.r.timings.chunkLoad.startTimingIfSync();){
                    Either either;
                    block18: {
                        this.r.ab().d("chunkLoad");
                        if (ioThrowable != null) {
                            SneakyThrow.sneaky((Throwable)ioThrowable);
                        }
                        this.w.loadInData(pos, chunkHolder.poiData);
                        chunkHolder.tasks.forEach(Runnable::run);
                        this.k().dequeueUnload(pos.longKey);
                        if (chunkHolder.protoChunk == null) break block17;
                        Timing ignored2 = this.r.timings.chunkLoadLevelTimer.startTimingIfSync();
                        try {
                            ProtoChunk protochunk = chunkHolder.protoChunk;
                            this.a(pos, protochunk.j().g());
                            either = Either.left(protochunk);
                            if (ignored2 == null) break block18;
                        }
                        catch (Throwable throwable) {
                            if (ignored2 != null) {
                                try {
                                    ignored2.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        ignored2.close();
                    }
                    return either;
                }
                catch (ReportedException reportedexception) {
                    Throwable throwable = reportedexception.getCause();
                    if (!(throwable instanceof IOException)) {
                        this.h(pos);
                        throw reportedexception;
                    }
                    i.error("Couldn't load chunk {}", (Object)pos, (Object)throwable);
                }
                catch (Exception exception) {
                    i.error("Couldn't load chunk {}", (Object)pos, (Object)exception);
                }
            }
            this.h(pos);
            return Either.left(new ProtoChunk(pos, ChunkConverter.a, this.r, this.r.s().d(IRegistry.aP), null));
        };
        CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>> ret = new CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>>();
        Consumer<ChunkRegionLoader.InProgressChunkHolder> chunkHolderConsumer = holder -> ChunkTaskManager.queueChunkWaitTask(() -> {
            try {
                ret.complete((Either)syncLoadComplete.apply((ChunkRegionLoader.InProgressChunkHolder)holder, (Throwable)null));
            }
            catch (Exception e2) {
                ret.completeExceptionally(e2);
            }
        });
        CompletableFuture<NBTTagCompound> chunkSaveFuture = this.r.asyncChunkTaskManager.getChunkSaveFuture(pos.c, pos.d);
        PlayerChunk playerChunk = this.a(pos.a());
        int chunkPriority = playerChunk != null ? playerChunk.requestedPriority : 33;
        int priority = 3;
        if (chunkPriority <= 10) {
            priority = 0;
        } else if (chunkPriority <= 20) {
            priority = 2;
        }
        boolean bl = isHighestPriority = priority == 0;
        if (chunkSaveFuture != null) {
            this.r.asyncChunkTaskManager.scheduleChunkLoad(pos.c, pos.d, priority, chunkHolderConsumer, isHighestPriority, chunkSaveFuture);
        } else {
            this.r.asyncChunkTaskManager.scheduleChunkLoad(pos.c, pos.d, priority, chunkHolderConsumer, isHighestPriority);
        }
        this.r.asyncChunkTaskManager.raisePriority(pos.c, pos.d, priority);
        return ret;
    }

    private void h(ChunkCoordIntPair pos) {
        this.K.put(pos.a(), (byte)-1);
    }

    private byte a(ChunkCoordIntPair pos, ChunkStatus.Type type) {
        return this.K.put(pos.a(), (byte)(type == ChunkStatus.Type.a ? -1 : 1));
    }

    private CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>> b(PlayerChunk holder, ChunkStatus requiredStatus) {
        ChunkCoordIntPair chunkcoordintpair = holder.j();
        CompletableFuture<Either<List<IChunkAccess>, PlayerChunk.Failure>> completablefuture = this.a(chunkcoordintpair, requiredStatus.f(), (int i2) -> this.a(requiredStatus, i2));
        this.r.ab().c(() -> "chunkGenerate " + requiredStatus.d());
        Executor executor = runnable -> {
            if (holder.canAdvanceStatus()) {
                this.mainInvokingExecutor.execute(runnable);
                return;
            }
            this.A.a(ChunkTaskQueueSorter.a(holder, runnable));
        };
        return ((CompletableFuture)completablefuture.thenComposeAsync(either -> either.map(list -> {
            try {
                CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>> completablefuture1 = requiredStatus.a(executor, this.r, this.u, this.G, this.s, ichunkaccess -> this.c(holder), (List<IChunkAccess>)list, false);
                this.C.a(chunkcoordintpair, requiredStatus);
                return completablefuture1;
            }
            catch (Exception exception) {
                exception.getStackTrace();
                CrashReport crashreport = CrashReport.a(exception, "Exception generating new chunk");
                CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Chunk to be generated");
                crashreportsystemdetails.a("Location", String.format("%d,%d", chunkcoordintpair.c, chunkcoordintpair.d));
                crashreportsystemdetails.a("Position hash", ChunkCoordIntPair.a(chunkcoordintpair.c, chunkcoordintpair.d));
                crashreportsystemdetails.a("Generator", this.u);
                this.t.execute(() -> {
                    throw new ReportedException(crashreport);
                });
                throw new ReportedException(crashreport);
            }
        }, playerchunk_failure -> {
            this.c(chunkcoordintpair);
            return CompletableFuture.completedFuture(Either.right(playerchunk_failure));
        }), executor)).thenComposeAsync(either -> CompletableFuture.completedFuture(either), (Executor)this.t);
    }

    protected void c(ChunkCoordIntPair pos) {
        this.t.i(SystemUtils.a(() -> this.E.b(TicketType.e, pos, 33 + ChunkStatus.a(ChunkStatus.l), pos), () -> "release light ticket " + pos));
    }

    private ChunkStatus a(ChunkStatus centerChunkTargetStatus, int distance) {
        ChunkStatus chunkstatus1 = distance == 0 ? centerChunkTargetStatus.e() : ChunkStatus.a(ChunkStatus.a(centerChunkTargetStatus) + distance);
        return chunkstatus1;
    }

    private static void a(WorldServer world, List<NBTTagCompound> nbt) {
        if (!nbt.isEmpty()) {
            world.b(EntityTypes.a(nbt, (World)world).filter(entity -> {
                boolean needsRemoval = false;
                DedicatedServer server = world.getCraftServer().getServer();
                if (!server.X() && entity instanceof NPC) {
                    entity.ah();
                    needsRemoval = true;
                }
                if (!server.W() && (entity instanceof EntityAnimal || entity instanceof EntityWaterAnimal)) {
                    entity.ah();
                    needsRemoval = true;
                }
                PlayerChunkMap.checkDupeUUID(world, entity);
                return !needsRemoval;
            }));
        }
    }

    private CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>> c(PlayerChunk chunkHolder) {
        CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>> completablefuture = chunkHolder.a(ChunkStatus.o.e());
        return completablefuture.thenApplyAsync(either -> {
            ChunkStatus chunkstatus = PlayerChunk.b(chunkHolder.k());
            return !chunkstatus.b(ChunkStatus.o) ? PlayerChunk.a : either.mapLeft(ichunkaccess -> {
                try (Timing ignored = this.r.timings.chunkPostLoad.startTimingIfSync();){
                    Chunk chunk;
                    ChunkCoordIntPair chunkcoordintpair = chunkHolder.j();
                    ProtoChunk protochunk = (ProtoChunk)ichunkaccess;
                    if (protochunk instanceof ProtoChunkExtension) {
                        chunk = ((ProtoChunkExtension)protochunk).A();
                    } else {
                        chunk = new Chunk(this.r, protochunk, chunk1 -> PlayerChunkMap.a(this.r, protochunk.D()));
                        chunkHolder.a(new ProtoChunkExtension(chunk, false));
                    }
                    chunk.b(() -> PlayerChunk.c(chunkHolder.k()));
                    chunk.C();
                    if (this.q.add(chunkcoordintpair.a())) {
                        chunk.c(true);
                        chunk.H();
                        chunk.a(this.r);
                    }
                    Chunk chunk2 = chunk;
                    return chunk2;
                }
            });
        }, runnable -> {
            Mailbox<ChunkTaskQueueSorter.a<Runnable>> mailbox = this.B;
            long i2 = chunkHolder.j().a();
            Objects.requireNonNull(chunkHolder);
            mailbox.a(ChunkTaskQueueSorter.a(runnable, i2, () -> 1));
        });
    }

    private static void checkDupeUUID(WorldServer level, Entity entity) {
        PaperWorldConfig.DuplicateUUIDMode mode = level.paperConfig.duplicateUUIDMode;
        if (mode != PaperWorldConfig.DuplicateUUIDMode.WARN && mode != PaperWorldConfig.DuplicateUUIDMode.DELETE && mode != PaperWorldConfig.DuplicateUUIDMode.SAFE_REGEN) {
            return;
        }
        Entity other = level.a(entity.cm());
        if (mode == PaperWorldConfig.DuplicateUUIDMode.SAFE_REGEN && other != null && !other.dp() && Objects.equals(other.bk(), entity.bk()) && entity.getBukkitEntity().getLocation().distance(other.getBukkitEntity().getLocation()) < (double)level.paperConfig.duplicateUUIDDeleteRange) {
            if (World.DEBUG_ENTITIES) {
                i.warn("[DUPE-UUID] Duplicate UUID found used by " + other + ", deleted entity " + entity + " because it was near the duplicate and likely an actual duplicate. See https://github.com/PaperMC/Paper/issues/1223 for discussion on what this is about.");
            }
            entity.ah();
            return;
        }
        if (other != null && !other.dp()) {
            switch (mode) {
                case SAFE_REGEN: {
                    entity.a_(UUID.randomUUID());
                    if (!World.DEBUG_ENTITIES) break;
                    i.warn("[DUPE-UUID] Duplicate UUID found used by " + other + ", regenerated UUID for " + entity + ". See https://github.com/PaperMC/Paper/issues/1223 for discussion on what this is about.");
                    break;
                }
                case DELETE: {
                    if (World.DEBUG_ENTITIES) {
                        i.warn("[DUPE-UUID] Duplicate UUID found used by " + other + ", deleted entity " + entity + ". See https://github.com/PaperMC/Paper/issues/1223 for discussion on what this is about.");
                    }
                    entity.ah();
                    break;
                }
                default: {
                    if (!World.DEBUG_ENTITIES) break;
                    i.warn("[DUPE-UUID] Duplicate UUID found used by " + other + ", doing nothing to " + entity + ". See https://github.com/PaperMC/Paper/issues/1223 for discussion on what this is about.");
                }
            }
        }
    }

    public CompletableFuture<Either<Chunk, PlayerChunk.Failure>> a(PlayerChunk holder) {
        ChunkCoordIntPair chunkcoordintpair = holder.j();
        CompletableFuture<Either<List<IChunkAccess>, PlayerChunk.Failure>> completablefuture = this.a(chunkcoordintpair, 1, (int i2) -> ChunkStatus.o);
        CompletionStage completablefuture1 = completablefuture.thenApplyAsync(either -> either.mapLeft(list -> {
            Chunk chunk = (Chunk)list.get(list.size() / 2);
            chunk.F();
            this.r.b(chunk);
            return chunk;
        }), runnable -> this.B.a(ChunkTaskQueueSorter.a(holder, () -> this.chunkLoadConversionCallbackExecutor.execute(runnable))));
        ((CompletableFuture)completablefuture1).thenAcceptAsync(either -> either.ifLeft(chunk -> this.F.getAndIncrement()), runnable -> this.B.a(ChunkTaskQueueSorter.a(holder, runnable)));
        return completablefuture1;
    }

    public CompletableFuture<Either<Chunk, PlayerChunk.Failure>> b(PlayerChunk holder) {
        return this.a(holder.j(), 1, ChunkStatus::a).thenApplyAsync(either -> either.mapLeft(list -> {
            Chunk chunk = (Chunk)list.get(list.size() / 2);
            return chunk;
        }), (Executor)this.t);
    }

    public int f() {
        return this.F.get();
    }

    private boolean d(PlayerChunk chunkHolder) {
        if (!chunkHolder.m()) {
            return false;
        }
        IChunkAccess ichunkaccess = chunkHolder.h().getNow(null);
        if (!(ichunkaccess instanceof ProtoChunkExtension) && !(ichunkaccess instanceof Chunk)) {
            return false;
        }
        long i2 = ichunkaccess.f().a();
        long j2 = this.L.getOrDefault(i2, -1L);
        long k2 = System.currentTimeMillis();
        if (k2 < j2) {
            return false;
        }
        boolean flag = this.a(ichunkaccess);
        chunkHolder.n();
        if (flag) {
            this.L.put(i2, k2 + 10000L);
        }
        return flag;
    }

    private void asyncSave(IChunkAccess chunk) {
        ChunkRegionLoader.AsyncSaveData asyncSaveData;
        NBTTagCompound poiData;
        ChunkCoordIntPair chunkPos = chunk.f();
        try (Timing ignored = this.r.timings.chunkUnloadPOISerialization.startTiming();){
            poiData = this.w.getData(chunk.f());
        }
        PaperFileIOThread.Holder.INSTANCE.scheduleSave(this.r, chunkPos.c, chunkPos.d, poiData, null, 3);
        if (!chunk.i()) {
            return;
        }
        ChunkStatus chunkstatus = chunk.j();
        if (chunkstatus.g() != ChunkStatus.Type.b && chunkstatus == ChunkStatus.c && chunk.g().values().stream().noneMatch(StructureStart::b)) {
            return;
        }
        try (Timing ignored = this.r.timings.chunkUnloadPrepareSave.startTiming();){
            asyncSaveData = ChunkRegionLoader.getAsyncSaveData(this.r, chunk);
        }
        this.r.asyncChunkTaskManager.scheduleChunkSave(chunkPos.c, chunkPos.d, 3, asyncSaveData, chunk);
        chunk.a(false);
        chunk.setLastSaved(this.r.U());
    }

    public boolean a(IChunkAccess chunk) {
        try (Timing ignored = this.r.timings.chunkSave.startTiming();){
            NBTTagCompound nbttagcompound;
            ChunkStatus chunkstatus;
            this.w.a(chunk.f());
            if (!chunk.i()) {
                boolean bl = false;
                return bl;
            }
            chunk.setLastSaved(this.r.U());
            chunk.a(false);
            ChunkCoordIntPair chunkcoordintpair = chunk.f();
            try {
                chunkstatus = chunk.j();
                if (chunkstatus.g() != ChunkStatus.Type.b && chunkstatus == ChunkStatus.c && chunk.g().values().stream().noneMatch(StructureStart::b)) {
                    boolean bl = false;
                    return bl;
                }
                this.r.ab().d("chunkSave");
            }
            catch (Exception exception) {
                i.error("Failed to save chunk {},{}", new Object[]{chunkcoordintpair.c, chunkcoordintpair.d, exception});
                ServerInternalException.reportInternalException((Throwable)exception);
                boolean bl = false;
                return bl;
            }
            try (Timing ignored1 = this.r.timings.chunkSaveDataSerialization.startTiming();){
                nbttagcompound = ChunkRegionLoader.a(this.r, chunk);
            }
            PaperFileIOThread.Holder.INSTANCE.scheduleSave(this.r, chunkcoordintpair.c, chunkcoordintpair.d, null, nbttagcompound, 3);
            this.a(chunkcoordintpair, chunkstatus.g());
            boolean bl = true;
            return bl;
        }
    }

    private boolean i(ChunkCoordIntPair pos) {
        NBTTagCompound nbttagcompound;
        byte b0 = this.K.get(pos.a());
        if (b0 != 0) {
            return b0 == 1;
        }
        try {
            nbttagcompound = this.j(pos);
            if (nbttagcompound == null) {
                this.h(pos);
                return false;
            }
        }
        catch (Exception exception) {
            i.error("Failed to read chunk {}", (Object)pos, (Object)exception);
            this.h(pos);
            return false;
        }
        ChunkStatus.Type chunkstatus_type = ChunkRegionLoader.a(nbttagcompound);
        return this.a(pos, chunkstatus_type) == 1;
    }

    public void a(int watchDistance) {
        int j2 = MathHelper.a(watchDistance + 1, 3, 33);
        if (j2 != this.N) {
            int k2 = this.N;
            this.N = j2;
            this.playerChunkManager.setLoadDistance(this.N);
        }
    }

    public void setTickViewDistance(int distance) {
        this.playerChunkManager.setTickDistance(distance);
    }

    public void a(EntityPlayer player, ChunkCoordIntPair pos, MutableObject<Map<Object, ClientboundLevelChunkWithLightPacket>> packet, boolean oldWithinViewDistance, boolean newWithinViewDistance) {
        if (player.s == this.r) {
            PlayerChunk playerchunk;
            if (newWithinViewDistance && !oldWithinViewDistance && (playerchunk = this.b(pos.a())) != null) {
                Chunk chunk = playerchunk.getSendingChunk();
                if (chunk != null) {
                    this.a(player, packet, chunk);
                }
                PacketDebug.a(this.r, pos);
            }
            if (!newWithinViewDistance && oldWithinViewDistance) {
                player.a(pos);
            }
        }
    }

    public int g() {
        return this.updatingChunks.getVisibleMap().size();
    }

    public ChunkMapDistance h() {
        return this.E;
    }

    protected Iterable<PlayerChunk> i() {
        return Iterables.unmodifiableIterable(this.updatingChunks.getVisibleValuesCopy());
    }

    void a(Writer writer) throws IOException {
        CSVWriter csvwriter = CSVWriter.a().a("x").a("z").a("level").a("in_memory").a("status").a("full_status").a("accessible_ready").a("ticking_ready").a("entity_ticking_ready").a("ticket").a("spawning").a("block_entity_count").a("ticking_ticket").a("ticking_level").a("block_ticks").a("fluid_ticks").a(writer);
        ObjectBidirectionalIterator objectbidirectionaliterator = this.updatingChunks.getVisibleMap().clone().long2ObjectEntrySet().fastIterator();
        while (objectbidirectionaliterator.hasNext()) {
            Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)objectbidirectionaliterator.next();
            long i2 = entry.getLongKey();
            ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(i2);
            PlayerChunk playerchunk = (PlayerChunk)entry.getValue();
            Optional<IChunkAccess> optional = Optional.ofNullable(playerchunk.g());
            Optional<Object> optional1 = optional.flatMap(ichunkaccess -> ichunkaccess instanceof Chunk ? Optional.of((Chunk)ichunkaccess) : Optional.empty());
            csvwriter.a(chunkcoordintpair.c, chunkcoordintpair.d, playerchunk.k(), optional.isPresent(), optional.map(IChunkAccess::j).orElse(null), optional1.map(Chunk::B).orElse(null), PlayerChunkMap.a(playerchunk.c()), PlayerChunkMap.a(playerchunk.a()), PlayerChunkMap.a(playerchunk.b()), this.E.e(i2), this.d(chunkcoordintpair), optional1.map(chunk -> chunk.E().size()).orElse(0), "Use ticket level", -1000, optional1.map(chunk -> chunk.o().a()).orElse(0), optional1.map(chunk -> chunk.p().a()).orElse(0));
        }
    }

    private static String a(CompletableFuture<Either<Chunk, PlayerChunk.Failure>> future) {
        try {
            Either either = future.getNow(null);
            return either != null ? either.map(chunk -> "done", playerchunk_failure -> "unloaded") : "not completed";
        }
        catch (CompletionException completionexception) {
            return "failed " + completionexception.getCause().getMessage();
        }
        catch (CancellationException cancellationexception) {
            return "cancelled";
        }
    }

    @Override
    @Nullable
    public NBTTagCompound f(ChunkCoordIntPair chunkcoordintpair) throws IOException {
        if (Thread.currentThread() != PaperFileIOThread.Holder.INSTANCE) {
            NBTTagCompound ret = PaperFileIOThread.Holder.INSTANCE.loadChunkDataAsyncFuture((WorldServer)this.r, (int)chunkcoordintpair.c, (int)chunkcoordintpair.d, (int)IOUtil.getPriorityForCurrentThread(), (boolean)false, (boolean)true, (boolean)true).join().chunkData;
            if (ret == PaperFileIOThread.FAILURE_VALUE) {
                throw new IOException("See logs for further detail");
            }
            return ret;
        }
        return super.f(chunkcoordintpair);
    }

    @Override
    public void a(ChunkCoordIntPair chunkcoordintpair, NBTTagCompound nbttagcompound) throws IOException {
        if (Thread.currentThread() != PaperFileIOThread.Holder.INSTANCE) {
            PaperFileIOThread.Holder.INSTANCE.scheduleSave(this.r, chunkcoordintpair.c, chunkcoordintpair.d, null, nbttagcompound, IOUtil.getPriorityForCurrentThread());
            return;
        }
        super.a(chunkcoordintpair, nbttagcompound);
    }

    @Nullable
    public NBTTagCompound j(ChunkCoordIntPair pos) throws IOException {
        NBTTagCompound nbttagcompound = this.f(pos);
        if (nbttagcompound == null) {
            return null;
        }
        nbttagcompound = this.upgradeChunkTag(this.r.getTypeKey(), this.v, nbttagcompound, this.u.c(), pos, this.r);
        if (nbttagcompound == null) {
            return null;
        }
        this.updateChunkStatusOnDisk(pos, nbttagcompound);
        return nbttagcompound;
    }

    public ChunkStatus getChunkStatusOnDiskIfCached(ChunkCoordIntPair chunkPos) {
        RegionFile regionFile = this.regionFileCache.getRegionFileIfLoaded(chunkPos);
        return regionFile == null ? null : regionFile.getStatusIfCached(chunkPos.c, chunkPos.d);
    }

    public ChunkStatus getChunkStatusOnDisk(ChunkCoordIntPair chunkPos) throws IOException {
        RegionFile regionFile = this.regionFileCache.getRegionFile(chunkPos, true);
        if (regionFile == null || !this.regionFileCache.chunkExists(chunkPos)) {
            return null;
        }
        ChunkStatus status = regionFile.getStatusIfCached(chunkPos.c, chunkPos.d);
        if (status != null) {
            return status;
        }
        this.j(chunkPos);
        return regionFile.getStatusIfCached(chunkPos.c, chunkPos.d);
    }

    public void updateChunkStatusOnDisk(ChunkCoordIntPair chunkPos, @Nullable NBTTagCompound compound) throws IOException {
        RegionFile regionFile = this.regionFileCache.getRegionFile(chunkPos, false);
        regionFile.setStatus(chunkPos.c, chunkPos.d, ChunkRegionLoader.getStatus(compound));
    }

    public IChunkAccess getUnloadingChunk(int chunkX, int chunkZ) {
        PlayerChunk chunkHolder = (PlayerChunk)this.p.get(ChunkCoordIntPair.a(chunkX, chunkZ));
        return chunkHolder == null ? null : chunkHolder.getAvailableChunkNow();
    }

    boolean d(ChunkCoordIntPair pos) {
        return this.anyPlayerCloseEnoughForSpawning(pos, false);
    }

    final boolean anyPlayerCloseEnoughForSpawning(ChunkCoordIntPair chunkcoordintpair, boolean reducedRange) {
        return this.anyPlayerCloseEnoughForSpawning(this.a(chunkcoordintpair.a()), chunkcoordintpair, reducedRange);
    }

    final boolean anyPlayerCloseEnoughForSpawning(PlayerChunk playerchunk, ChunkCoordIntPair chunkcoordintpair, boolean reducedRange) {
        PooledLinkedHashSets.PooledObjectLinkedOpenHashSet<EntityPlayer> playersInRange;
        PooledLinkedHashSets.PooledObjectLinkedOpenHashSet<EntityPlayer> pooledObjectLinkedOpenHashSet = playersInRange = reducedRange ? playerchunk.playersInMobSpawnRange : playerchunk.playersInChunkTickRange;
        if (playersInRange == null) {
            return false;
        }
        EntityPlayer[] backingSet = playersInRange.getBackingSet();
        if (reducedRange) {
            for (EntityPlayer raw : backingSet) {
                EntityPlayer player;
                if (!(raw instanceof EntityPlayer) || !(PlayerChunkMap.a(chunkcoordintpair, player = raw) < player.lastEntitySpawnRadiusSquared)) continue;
                return true;
            }
        } else {
            double range = 16384.0;
            for (EntityPlayer raw : backingSet) {
                EntityPlayer player;
                if (!(raw instanceof EntityPlayer) || !(PlayerChunkMap.a(chunkcoordintpair, player = raw) < 16384.0)) continue;
                return true;
            }
        }
        return false;
    }

    public List<EntityPlayer> e(ChunkCoordIntPair pos) {
        long i2 = pos.a();
        if (!this.E.f(i2)) {
            return List.of();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (EntityPlayer entityplayer : this.I.a(i2)) {
            if (!this.playerIsCloseEnoughForSpawning(entityplayer, pos, 16384.0)) continue;
            builder.add((Object)entityplayer);
        }
        return builder.build();
    }

    private boolean playerIsCloseEnoughForSpawning(EntityPlayer entityplayer, ChunkCoordIntPair chunkcoordintpair, double range) {
        if (entityplayer.B_()) {
            return false;
        }
        double d0 = PlayerChunkMap.a(chunkcoordintpair, entityplayer);
        return d0 < range;
    }

    private boolean b(EntityPlayer player) {
        return player.B_() && !this.r.W().b(GameRules.q);
    }

    void a(EntityPlayer player, boolean added) {
        boolean flag1 = this.b(player);
        boolean flag2 = this.I.c(player);
        int i2 = SectionPosition.a(player.db());
        int j2 = SectionPosition.a(player.dh());
        if (added) {
            this.I.a(ChunkCoordIntPair.a(i2, j2), player, flag1);
            this.c(player);
            if (!flag1) {
                this.E.a(SectionPosition.a(player), player);
            }
            this.addPlayerToDistanceMaps(player);
        } else {
            SectionPosition sectionposition = player.R();
            this.I.a(sectionposition.r().a(), player);
            if (!flag2) {
                this.E.b(sectionposition, player);
            }
            this.removePlayerFromDistanceMaps(player);
        }
    }

    private SectionPosition c(EntityPlayer player) {
        SectionPosition sectionposition = SectionPosition.a(player);
        player.a(sectionposition);
        return sectionposition;
    }

    public void a(EntityPlayer player) {
        boolean flag2;
        int i2 = SectionPosition.a(player.db());
        int j2 = SectionPosition.a(player.dh());
        SectionPosition sectionposition = player.R();
        SectionPosition sectionposition1 = SectionPosition.a(player);
        long k2 = sectionposition.r().a();
        long l2 = sectionposition1.r().a();
        boolean flag = this.I.d(player);
        boolean flag1 = this.b(player);
        boolean bl = flag2 = sectionposition.s() != sectionposition1.s();
        if (flag2 || flag != flag1) {
            this.c(player);
            if (!flag) {
                this.E.b(sectionposition, player);
            }
            if (!flag1) {
                this.E.a(sectionposition1, player);
            }
            if (!flag && flag1) {
                this.I.a(player);
            }
            if (flag && !flag1) {
                this.I.b(player);
            }
            if (k2 != l2) {
                this.I.a(k2, l2, player);
            }
        }
        int i1 = sectionposition.a();
        int j1 = sectionposition.c();
        this.updateMaps(player);
        this.playerChunkManager.updatePlayer(player);
    }

    @Override
    public List<EntityPlayer> a(ChunkCoordIntPair chunkPos, boolean onlyOnWatchDistanceEdge) {
        ArrayList<EntityPlayer> ret = new ArrayList<EntityPlayer>(4);
        PooledLinkedHashSets.PooledObjectLinkedOpenHashSet players = this.playerChunkManager.broadcastMap.getObjectsInRange(chunkPos);
        if (players == null) {
            return ret;
        }
        for (Object temp : players.getBackingSet()) {
            EntityPlayer player;
            if (!(temp instanceof EntityPlayer) || !this.playerChunkManager.isChunkSent(player = (EntityPlayer)temp, chunkPos.c, chunkPos.d, onlyOnWatchDistanceEdge)) continue;
            ret.add(player);
        }
        return ret;
    }

    public void a(Entity entity) {
        AsyncCatcher.catchOp("entity track");
        if (!entity.valid || entity.s != this.r || this.J.containsKey(entity.ae())) {
            new Throwable("[ERROR] Illegal PlayerChunkMap::addEntity for world " + this.r.getWorld().getName() + ": " + entity + (this.J.containsKey(entity.ae()) ? " ALREADY CONTAINED (This would have crashed your server)" : "")).printStackTrace();
            return;
        }
        if (entity instanceof EntityPlayer && ((EntityPlayer)entity).supressTrackerForLogin) {
            return;
        }
        if (!(entity instanceof EntityComplexPart)) {
            EntityTypes<?> entitytypes = entity.ad();
            int i2 = entitytypes.n() * 16;
            if ((i2 = TrackingRange.getEntityTrackingRange(entity, i2)) != 0) {
                EntityTracker playerchunkmap_entitytracker;
                int j2 = entitytypes.o();
                if (this.J.containsKey(entity.ae())) {
                    throw SystemUtils.c(new IllegalStateException("Entity is already tracked!"));
                }
                entity.tracker = playerchunkmap_entitytracker = new EntityTracker(entity, i2, j2, entitytypes.p());
                this.J.put(entity.ae(), (Object)playerchunkmap_entitytracker);
                playerchunkmap_entitytracker.updatePlayers(entity.getPlayersInTrackRange());
                if (entity instanceof EntityPlayer) {
                    EntityPlayer entityplayer = (EntityPlayer)entity;
                    this.a(entityplayer, true);
                    for (EntityTracker playerchunkmap_entitytracker1 : this.J.values()) {
                        if (playerchunkmap_entitytracker1.c == entityplayer) continue;
                        playerchunkmap_entitytracker1.b(entityplayer);
                    }
                }
            }
        }
    }

    protected void b(Entity entity) {
        EntityTracker playerchunkmap_entitytracker1;
        AsyncCatcher.catchOp("entity untrack");
        if (entity instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)entity;
            this.a(entityplayer, false);
            for (EntityTracker playerchunkmap_entitytracker : this.J.values()) {
                playerchunkmap_entitytracker.a(entityplayer);
            }
        }
        if ((playerchunkmap_entitytracker1 = (EntityTracker)this.J.remove(entity.ae())) != null) {
            playerchunkmap_entitytracker1.a();
        }
        entity.tracker = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void processTrackQueue() {
        this.r.timings.tracker1.startTiming();
        try {
            for (EntityTracker tracker : this.J.values()) {
                tracker.updatePlayers(tracker.c.getPlayersInTrackRange());
            }
        }
        finally {
            this.r.timings.tracker1.stopTiming();
        }
        this.r.timings.tracker2.startTiming();
        try {
            for (EntityTracker tracker : this.J.values()) {
                tracker.b.a();
            }
        }
        finally {
            this.r.timings.tracker2.stopTiming();
        }
    }

    protected void j() {
        this.processTrackQueue();
    }

    public void a(Entity entity, Packet<?> packet) {
        EntityTracker playerchunkmap_entitytracker = (EntityTracker)this.J.get(entity.ae());
        if (playerchunkmap_entitytracker != null) {
            playerchunkmap_entitytracker.a(packet);
        }
    }

    protected void b(Entity entity, Packet<?> packet) {
        EntityTracker playerchunkmap_entitytracker = (EntityTracker)this.J.get(entity.ae());
        if (playerchunkmap_entitytracker != null) {
            playerchunkmap_entitytracker.b(packet);
        }
    }

    private void a(EntityPlayer player, MutableObject<Map<Object, ClientboundLevelChunkWithLightPacket>> cachedDataPackets, Chunk chunk) {
        if (cachedDataPackets.getValue() == null) {
            cachedDataPackets.setValue(new HashMap());
        }
        Boolean shouldModify = chunk.D().chunkPacketBlockController.shouldModify(player, chunk);
        player.a(chunk.f(), ((Map)cachedDataPackets.getValue()).computeIfAbsent(shouldModify, s2 -> new ClientboundLevelChunkWithLightPacket(chunk, this.s, null, null, true, (Boolean)s2)));
        PacketDebug.a(this.r, chunk.f());
        ArrayList list = Lists.newArrayList();
        ArrayList list1 = Lists.newArrayList();
        Entity[] entities = chunk.entities.getRawData();
        int size = chunk.entities.size();
        for (int i2 = 0; i2 < size; ++i2) {
            Entity entity = entities[i2];
            if (entity == player) continue;
            EntityTracker tracker = (EntityTracker)this.J.get(entity.ae());
            if (tracker != null) {
                tracker.b(player);
            }
            if (entity instanceof EntityInsentient && ((EntityInsentient)entity).fr() != null) {
                list.add(entity);
            }
            if (entity.cF().isEmpty()) continue;
            list1.add(entity);
        }
        if (!list.isEmpty()) {
            for (Entity entity1 : list) {
                player.b.a(new PacketPlayOutAttachEntity(entity1, ((EntityInsentient)entity1).fr()));
            }
        }
        if (!list1.isEmpty()) {
            for (Entity entity1 : list1) {
                player.b.a(new PacketPlayOutMount(entity1));
            }
        }
    }

    public VillagePlace k() {
        return this.w;
    }

    public String l() {
        return this.H;
    }

    void a(ChunkCoordIntPair chunkPos, PlayerChunk.State levelType) {
        this.D.onChunkStatusChange(chunkPos, levelType);
    }

    public class ChunkDistanceManager
    extends ChunkMapDistance {
        protected ChunkDistanceManager(Executor workerExecutor, Executor mainThreadExecutor) {
            super(workerExecutor, mainThreadExecutor, PlayerChunkMap.this);
        }

        @Override
        protected boolean a(long pos) {
            return PlayerChunkMap.this.x.contains(pos);
        }

        @Override
        @Nullable
        protected PlayerChunk b(long pos) {
            return PlayerChunkMap.this.a(pos);
        }

        @Override
        @Nullable
        protected PlayerChunk a(long pos, int level, @Nullable PlayerChunk holder, int k2) {
            return PlayerChunkMap.this.a(pos, level, holder, k2);
        }
    }

    public static final class CallbackExecutor
    implements Executor,
    Runnable {
        private Runnable queued;

        @Override
        public void execute(Runnable runnable) {
            AsyncCatcher.catchOp("Callback Executor execute");
            if (this.queued != null) {
                i.error("Failed to schedule runnable", (Throwable)new IllegalStateException("Already queued"));
                throw new IllegalStateException("Already queued");
            }
            this.queued = runnable;
        }

        @Override
        public void run() {
            AsyncCatcher.catchOp("Callback Executor execute");
            Runnable task = this.queued;
            if (task != null) {
                this.queued = null;
                task.run();
            }
        }
    }

    public class EntityTracker {
        final EntityTrackerEntry b;
        final Entity c;
        private final int d;
        SectionPosition e;
        public final Set<ServerPlayerConnection> f = new ReferenceOpenHashSet();
        PooledLinkedHashSets.PooledObjectLinkedOpenHashSet<EntityPlayer> lastTrackerCandidates;

        public EntityTracker(Entity entity, int i2, int j2, boolean flag) {
            this.b = new EntityTrackerEntry(PlayerChunkMap.this.r, entity, j2, flag, this::a, this.f);
            this.c = entity;
            this.d = i2;
            this.e = SectionPosition.a(entity);
        }

        final void updatePlayers(PooledLinkedHashSets.PooledObjectLinkedOpenHashSet<EntityPlayer> newTrackerCandidates) {
            PooledLinkedHashSets.PooledObjectLinkedOpenHashSet<EntityPlayer> oldTrackerCandidates = this.lastTrackerCandidates;
            this.lastTrackerCandidates = newTrackerCandidates;
            if (newTrackerCandidates != null) {
                for (EntityPlayer raw : newTrackerCandidates.getBackingSet()) {
                    if (!(raw instanceof EntityPlayer)) continue;
                    EntityPlayer player = raw;
                    this.b(player);
                }
            }
            if (oldTrackerCandidates == newTrackerCandidates) {
                return;
            }
            for (ServerPlayerConnection conn : this.f.toArray(new ServerPlayerConnection[0])) {
                if (newTrackerCandidates != null && newTrackerCandidates.contains(conn.e())) continue;
                this.b(conn.e());
            }
        }

        public boolean equals(Object object) {
            return object instanceof EntityTracker ? ((EntityTracker)object).c.ae() == this.c.ae() : false;
        }

        public int hashCode() {
            return this.c.ae();
        }

        public void a(Packet<?> packet) {
            for (ServerPlayerConnection serverplayerconnection : this.f) {
                serverplayerconnection.a(packet);
            }
        }

        public void b(Packet<?> packet) {
            this.a(packet);
            if (this.c instanceof EntityPlayer) {
                ((EntityPlayer)this.c).b.a(packet);
            }
        }

        public void a() {
            for (ServerPlayerConnection serverplayerconnection : this.f) {
                this.b.a(serverplayerconnection.e());
            }
        }

        public void a(EntityPlayer player) {
            AsyncCatcher.catchOp("player tracker clear");
            if (this.f.remove(player.b)) {
                this.b.a(player);
            }
        }

        public void b(EntityPlayer player) {
            AsyncCatcher.catchOp("player tracker update");
            if (player != this.c) {
                double d0;
                double d2;
                boolean flag;
                double vec3d_dz;
                double vec3d_dx = player.dc() - this.c.dc();
                double d1 = vec3d_dx * vec3d_dx + (vec3d_dz = player.di() - this.c.di()) * vec3d_dz;
                boolean bl = flag = d1 <= (d2 = (d0 = (double)Math.min(this.b(), PlayerChunkLoader.getSendViewDistance(player) * 16)) * d0) && this.c.a(player);
                if (!player.getBukkitEntity().canSee(this.c.getBukkitEntity())) {
                    flag = false;
                }
                if (flag) {
                    if (this.f.add(player.b)) {
                        this.b.b(player);
                    }
                } else if (this.f.remove(player.b)) {
                    this.b.a(player);
                }
            }
        }

        private int a(int initialDistance) {
            return PlayerChunkMap.this.r.n().b(initialDistance);
        }

        private int b() {
            int i2 = this.d;
            for (Entity entity : this.c.cJ()) {
                int j2 = entity.ad().n() * 16;
                if ((j2 = TrackingRange.getEntityTrackingRange(entity, j2)) <= i2) continue;
                i2 = j2;
            }
            return this.a(i2);
        }

        public void a(List<EntityPlayer> players) {
            for (EntityPlayer entityplayer : players) {
                this.b(entityplayer);
            }
        }
    }

    public static final class DataRegionSectionData
    implements SingleThreadChunkRegionManager.RegionSectionData {
        private IteratorSafeOrderedReferenceSet<EntityInsentient> navigators;

        public IteratorSafeOrderedReferenceSet<EntityInsentient> getNavigators() {
            return this.navigators;
        }

        public boolean addToNavigators(SingleThreadChunkRegionManager.RegionSection section, EntityInsentient navigator) {
            DataRegionData data;
            boolean ret;
            if (this.navigators == null) {
                this.navigators = new IteratorSafeOrderedReferenceSet();
            }
            if ((ret = this.navigators.add(navigator)) && !(data = (DataRegionData)section.getRegion().regionData).addToNavigators(navigator)) {
                throw new IllegalStateException();
            }
            return ret;
        }

        public boolean removeFromNavigators(SingleThreadChunkRegionManager.RegionSection section, EntityInsentient navigator) {
            DataRegionData data;
            if (this.navigators == null) {
                return false;
            }
            boolean ret = this.navigators.remove(navigator);
            if (ret && !(data = (DataRegionData)section.getRegion().regionData).removeFromNavigators(navigator)) {
                throw new IllegalStateException();
            }
            return ret;
        }

        @Override
        public void removeFromRegion(SingleThreadChunkRegionManager.RegionSection section, SingleThreadChunkRegionManager.Region from) {
            DataRegionSectionData sectionData = (DataRegionSectionData)section.sectionData;
            DataRegionData fromData = (DataRegionData)from.regionData;
            if (sectionData.navigators != null) {
                Iterator<EntityInsentient> iterator = sectionData.navigators.unsafeIterator(1);
                while (iterator.hasNext()) {
                    if (fromData.removeFromNavigators(iterator.next())) continue;
                    throw new IllegalStateException();
                }
            }
        }

        @Override
        public void addToRegion(SingleThreadChunkRegionManager.RegionSection section, SingleThreadChunkRegionManager.Region oldRegion, SingleThreadChunkRegionManager.Region newRegion) {
            DataRegionSectionData sectionData = (DataRegionSectionData)section.sectionData;
            DataRegionData oldRegionData = oldRegion == null ? null : (DataRegionData)oldRegion.regionData;
            DataRegionData newRegionData = (DataRegionData)newRegion.regionData;
            if (sectionData.navigators != null) {
                Iterator<EntityInsentient> iterator = sectionData.navigators.unsafeIterator(1);
                while (iterator.hasNext()) {
                    if (newRegionData.addToNavigators(iterator.next())) continue;
                    throw new IllegalStateException();
                }
            }
        }
    }

    public static final class DataRegionData
    implements SingleThreadChunkRegionManager.RegionData {
        private IteratorSafeOrderedReferenceSet<EntityInsentient> navigators;

        public IteratorSafeOrderedReferenceSet<EntityInsentient> getNavigators() {
            return this.navigators;
        }

        public boolean addToNavigators(EntityInsentient navigator) {
            if (this.navigators == null) {
                this.navigators = new IteratorSafeOrderedReferenceSet();
            }
            return this.navigators.add(navigator);
        }

        public boolean removeFromNavigators(EntityInsentient navigator) {
            if (this.navigators == null) {
                return false;
            }
            return this.navigators.remove(navigator);
        }
    }
}

