/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.destroystokyo.paper.util.misc.PlayerAreaMap;
import com.destroystokyo.paper.util.misc.PooledLinkedHashSets;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import io.papermc.paper.util.TickThread;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.shorts.ShortOpenHashSet;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.SectionPosition;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutBlockChange;
import net.minecraft.network.protocol.game.PacketPlayOutLightUpdate;
import net.minecraft.network.protocol.game.PacketPlayOutMultiBlockChange;
import net.minecraft.server.MCUtil;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.DebugBuffer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.ProtoChunkExtension;
import net.minecraft.world.level.lighting.LightEngine;
import org.spigotmc.AsyncCatcher;

public class PlayerChunk {
    public static final Either<IChunkAccess, Failure> a = Either.right(Failure.b);
    public static final CompletableFuture<Either<IChunkAccess, Failure>> b = CompletableFuture.completedFuture(a);
    public static final Either<Chunk, Failure> c = Either.right(Failure.b);
    private static final Either<IChunkAccess, Failure> d = Either.right(Failure.b);
    private static final CompletableFuture<Either<Chunk, Failure>> e = CompletableFuture.completedFuture(c);
    private static final List<ChunkStatus> f = ChunkStatus.a();
    private static final State[] g = State.values();
    private static final int h = 64;
    private final AtomicReferenceArray<CompletableFuture<Either<IChunkAccess, Failure>>> i;
    private final LevelHeightAccessor j;
    private volatile CompletableFuture<Either<Chunk, Failure>> k;
    private int fullChunkCreateCount;
    private volatile boolean isFullChunkReady;
    private volatile CompletableFuture<Either<Chunk, Failure>> l;
    private volatile boolean isTickingReady;
    private volatile CompletableFuture<Either<Chunk, Failure>> m;
    private volatile boolean isEntityTickingReady;
    public CompletableFuture<IChunkAccess> n;
    @Nullable
    private final DebugBuffer<b> o = null;
    public int p;
    private int q;
    public volatile int r;
    public final ChunkCoordIntPair s;
    private boolean t;
    private final ShortSet[] u;
    private final BitSet v;
    private final BitSet w;
    private final LightEngine x;
    private final d y;
    public final e z;
    private boolean A;
    private boolean B;
    private CompletableFuture<Void> C;
    boolean isUpdateQueued = false;
    private final PlayerChunkMap chunkMap;
    PooledLinkedHashSets.PooledObjectLinkedOpenHashSet<EntityPlayer> playersInMobSpawnRange;
    PooledLinkedHashSets.PooledObjectLinkedOpenHashSet<EntityPlayer> playersInChunkTickRange;
    long lastAutoSaveTime;
    long inactiveTimeStart;
    private boolean loadCallbackScheduled = false;
    private boolean unloadCallbackScheduled = false;
    protected long updateCount;
    volatile int neighborPriority = -1;
    volatile int priorityBoost = 0;
    public final ConcurrentHashMap<PlayerChunk, ChunkStatus> neighbors = new ConcurrentHashMap();
    public final Long2ObjectOpenHashMap<Integer> neighborPriorities = new Long2ObjectOpenHashMap();
    int requestedPriority = PlayerChunkMap.b + 1;

    public WorldServer getWorld() {
        return this.chunkMap.r;
    }

    public final Chunk getSendingChunk() {
        Chunk ret = this.chunkMap.r.k().getChunkAtIfLoadedImmediately(this.s.c, this.s.d);
        if (ret != null && ret.areNeighboursLoaded(1)) {
            return ret;
        }
        return null;
    }

    void onChunkAdd() {
        Chunk chunk;
        long key = MCUtil.getCoordinateKey(this.s);
        this.playersInMobSpawnRange = this.chunkMap.playerMobSpawnMap.getObjectsInRange(key);
        this.playersInChunkTickRange = this.chunkMap.playerChunkTickRangeMap.getObjectsInRange(key);
        if (this.needsBroadcastChanges()) {
            this.chunkMap.needsChangeBroadcasting.add((Object)this);
        }
        if ((chunk = this.getFullChunkUnchecked()) != null) {
            chunk.updateGeneralAreaCache();
        }
    }

    void onChunkRemove() {
        Chunk chunk;
        this.playersInMobSpawnRange = null;
        this.playersInChunkTickRange = null;
        if (this.needsBroadcastChanges()) {
            this.chunkMap.needsChangeBroadcasting.remove((Object)this);
        }
        if ((chunk = this.getFullChunkUnchecked()) != null) {
            chunk.removeGeneralAreaCache();
        }
    }

    public boolean canAdvanceStatus() {
        ChunkStatus status = this.getChunkHolderStatus();
        IChunkAccess chunk = this.getAvailableChunkNow();
        return chunk != null && (status == null || chunk.j().b(PlayerChunk.getNextStatus(status)));
    }

    public PlayerChunk(ChunkCoordIntPair pos, int level, LevelHeightAccessor world, LightEngine lightingProvider, d levelUpdateListener, e playersWatchingChunkProvider) {
        this.i = new AtomicReferenceArray(f.size());
        this.k = e;
        this.l = e;
        this.m = e;
        this.n = CompletableFuture.completedFuture(null);
        this.v = new BitSet();
        this.w = new BitSet();
        this.C = CompletableFuture.completedFuture(null);
        this.s = pos;
        this.j = world;
        this.x = lightingProvider;
        this.y = levelUpdateListener;
        this.z = playersWatchingChunkProvider;
        this.q = this.p = PlayerChunkMap.b + 1;
        this.r = this.p;
        this.a(level);
        this.u = new ShortSet[world.ah()];
        this.chunkMap = (PlayerChunkMap)playersWatchingChunkProvider;
        this.onChunkAdd();
    }

    public Chunk getFullChunkUnchecked() {
        CompletableFuture<Either<IChunkAccess, Failure>> statusFuture = this.a(ChunkStatus.o);
        Either either = statusFuture.getNow(null);
        return either == null ? null : (Chunk)either.left().orElse(null);
    }

    public IChunkAccess getAvailableChunkNow() {
        ChunkStatus curr = ChunkStatus.o;
        for (ChunkStatus next = curr.e(); curr != next; next = next.e()) {
            CompletableFuture<Either<IChunkAccess, Failure>> future = this.a(curr);
            Either either = future.getNow(null);
            if (either != null && either.left().isPresent()) {
                return (IChunkAccess)either.left().get();
            }
            curr = next;
        }
        return null;
    }

    public CompletableFuture<Either<IChunkAccess, Failure>> a(ChunkStatus leastStatus) {
        CompletableFuture<Either<IChunkAccess, Failure>> completablefuture = this.i.get(leastStatus.c());
        return completablefuture == null ? b : completablefuture;
    }

    public CompletableFuture<Either<IChunkAccess, Failure>> b(ChunkStatus leastStatus) {
        return PlayerChunk.b(this.q).b(leastStatus) ? this.a(leastStatus) : b;
    }

    public final CompletableFuture<Either<Chunk, Failure>> a() {
        return this.l;
    }

    public final CompletableFuture<Either<Chunk, Failure>> b() {
        return this.m;
    }

    public final CompletableFuture<Either<Chunk, Failure>> c() {
        return this.k;
    }

    @Nullable
    public final Chunk d() {
        CompletableFuture<Either<Chunk, Failure>> completablefuture = this.a();
        Either either = completablefuture.getNow(null);
        return either == null ? null : (Chunk)either.left().orElse(null);
    }

    @Nullable
    public final Chunk e() {
        CompletableFuture<Either<Chunk, Failure>> completablefuture = this.c();
        Either either = completablefuture.getNow(null);
        return either == null ? null : (Chunk)either.left().orElse(null);
    }

    @Nullable
    public ChunkStatus f() {
        for (int i2 = f.size() - 1; i2 >= 0; --i2) {
            ChunkStatus chunkstatus = f.get(i2);
            CompletableFuture<Either<IChunkAccess, Failure>> completablefuture = this.a(chunkstatus);
            if (!completablefuture.getNow(a).left().isPresent()) continue;
            return chunkstatus;
        }
        return null;
    }

    public ChunkStatus getChunkHolderStatus() {
        ChunkStatus curr = ChunkStatus.o;
        for (ChunkStatus next = curr.e(); curr != next; next = next.e()) {
            CompletableFuture<Either<IChunkAccess, Failure>> future = this.a(curr);
            Either either = future.getNow(null);
            if (either != null && either.left().isPresent()) {
                return curr;
            }
            curr = next;
        }
        return null;
    }

    @Nullable
    public IChunkAccess g() {
        for (int i2 = f.size() - 1; i2 >= 0; --i2) {
            Optional<IChunkAccess> optional;
            ChunkStatus chunkstatus = f.get(i2);
            CompletableFuture<Either<IChunkAccess, Failure>> completablefuture = this.a(chunkstatus);
            if (completablefuture.isCompletedExceptionally() || !(optional = completablefuture.getNow(a).left()).isPresent()) continue;
            return optional.get();
        }
        return null;
    }

    public final CompletableFuture<IChunkAccess> h() {
        return this.n;
    }

    public void a(BlockPosition pos) {
        if (!pos.isInsideBuildHeightAndWorldBoundsHorizontal(this.j)) {
            return;
        }
        Chunk chunk = this.getSendingChunk();
        if (chunk != null) {
            int i2 = this.j.e(pos.v());
            if (i2 < 0 || i2 >= this.u.length) {
                return;
            }
            if (this.u[i2] == null) {
                this.t = true;
                this.addToBroadcastMap();
                this.u[i2] = new ShortOpenHashSet();
            }
            this.u[i2].add(SectionPosition.b(pos));
        }
    }

    public void a(EnumSkyBlock lightType, int y2) {
        IChunkAccess chunk = this.getAvailableChunkNow();
        if (chunk != null) {
            chunk.a(true);
            Chunk chunk1 = this.getSendingChunk();
            if (chunk1 != null) {
                int j2 = this.x.c();
                int k2 = this.x.d();
                if (y2 >= j2 && y2 <= k2) {
                    this.addToBroadcastMap();
                    int l2 = y2 - j2;
                    if (lightType == EnumSkyBlock.a) {
                        this.w.set(l2);
                    } else {
                        this.v.set(l2);
                    }
                }
            }
        }
    }

    public final boolean needsBroadcastChanges() {
        return this.t || !this.w.isEmpty() || !this.v.isEmpty();
    }

    private void addToBroadcastMap() {
        AsyncCatcher.catchOp("ChunkHolder update");
        this.chunkMap.needsChangeBroadcasting.add((Object)this);
    }

    public void a(Chunk chunk) {
        if (this.needsBroadcastChanges()) {
            int j2;
            World world = chunk.D();
            int i2 = 0;
            for (j2 = 0; j2 < this.u.length; ++j2) {
                i2 += this.u[j2] != null ? this.u[j2].size() : 0;
            }
            this.B |= i2 >= 64;
            if (!this.w.isEmpty() || !this.v.isEmpty()) {
                this.a(new PacketPlayOutLightUpdate(chunk.f(), this.x, this.w, this.v, true), !this.B);
                this.w.clear();
                this.v.clear();
            }
            for (j2 = 0; j2 < this.u.length; ++j2) {
                ShortSet shortset = this.u[j2];
                if (shortset == null) continue;
                int k2 = this.j.g(j2);
                SectionPosition sectionposition = SectionPosition.a(chunk.f(), k2);
                if (shortset.size() == 1) {
                    BlockPosition blockposition = sectionposition.g(shortset.iterator().nextShort());
                    IBlockData iblockdata = world.a_(blockposition);
                    this.a(new PacketPlayOutBlockChange(blockposition, iblockdata), false);
                    this.a(world, blockposition, iblockdata);
                } else {
                    ChunkSection chunksection = chunk.b(j2);
                    PacketPlayOutMultiBlockChange packetplayoutmultiblockchange = new PacketPlayOutMultiBlockChange(sectionposition, shortset, chunksection, this.B);
                    this.a(packetplayoutmultiblockchange, false);
                    packetplayoutmultiblockchange.a((BlockPosition blockposition1, IBlockData iblockdata1) -> this.a(world, (BlockPosition)blockposition1, (IBlockData)iblockdata1));
                }
                this.u[j2] = null;
            }
            this.t = false;
        }
    }

    private void a(World world, BlockPosition pos, IBlockData state) {
        if (state.n()) {
            this.a(world, pos);
        }
    }

    private void a(World world, BlockPosition pos) {
        Packet<PacketListenerPlayOut> packet;
        TileEntity tileentity = world.c_(pos);
        if (tileentity != null && (packet = tileentity.h()) != null) {
            this.a(packet, false);
        }
    }

    public void a(Packet<?> packet, boolean onlyOnWatchDistanceEdge) {
        PlayerAreaMap viewDistanceMap = this.chunkMap.playerChunkManager.broadcastMap;
        PooledLinkedHashSets.PooledObjectLinkedOpenHashSet players = viewDistanceMap.getObjectsInRange(this.s);
        if (players == null) {
            return;
        }
        for (Object temp : players.getBackingSet()) {
            EntityPlayer player;
            if (!(temp instanceof EntityPlayer) || !this.chunkMap.playerChunkManager.isChunkSent(player = (EntityPlayer)temp, this.s.c, this.s.d, onlyOnWatchDistanceEdge)) continue;
            player.b.a(packet);
        }
    }

    public CompletableFuture<Either<IChunkAccess, Failure>> a(ChunkStatus targetStatus, PlayerChunkMap chunkStorage) {
        int i2 = targetStatus.c();
        CompletableFuture<Either<IChunkAccess, Failure>> completablefuture = this.i.get(i2);
        if (completablefuture != null) {
            Either<IChunkAccess, Failure> either = completablefuture.getNow(d);
            if (either == null) {
                String s2 = "value in future for status: " + targetStatus + " was incorrectly set to null at chunk: " + this.s;
                throw chunkStorage.a(new IllegalStateException("null value previously set for chunk status"), s2);
            }
            if (either == d || either.right().isEmpty()) {
                return completablefuture;
            }
        }
        if (PlayerChunk.b(this.q).b(targetStatus)) {
            CompletableFuture<Either<IChunkAccess, Failure>> completablefuture1 = chunkStorage.a(this, targetStatus);
            this.a(completablefuture1, "schedule " + targetStatus);
            this.i.set(i2, completablefuture1);
            return completablefuture1;
        }
        return completablefuture == null ? b : completablefuture;
    }

    protected void a(String thenDesc, CompletableFuture<?> then) {
        if (this.o != null) {
            this.o.a(new b(Thread.currentThread(), then, thenDesc));
        }
        this.n = this.n.thenCombine(then, (ichunkaccess, object) -> ichunkaccess);
    }

    private void a(CompletableFuture<? extends Either<? extends IChunkAccess, Failure>> then, String thenDesc) {
        if (this.o != null) {
            this.o.a(new b(Thread.currentThread(), then, thenDesc));
        }
        this.n = this.n.thenCombine(then, (ichunkaccess, either) -> either.map(ichunkaccess1 -> ichunkaccess1, playerchunk_failure -> ichunkaccess));
    }

    public State i() {
        return PlayerChunk.c(this.q);
    }

    public final ChunkCoordIntPair j() {
        return this.s;
    }

    public final int k() {
        return this.q;
    }

    public int l() {
        return this.r;
    }

    private void d(int level) {
        this.r = level;
    }

    public void a(int level) {
        this.q = level;
    }

    private void a(PlayerChunkMap playerchunkmap, CompletableFuture<Either<Chunk, Failure>> completablefuture, Executor executor, State playerchunk_state) {
        this.C.cancel(false);
        CompletableFuture completablefuture1 = new CompletableFuture();
        completablefuture1.thenRunAsync(() -> {
            boolean unloadingBefore = this.chunkMap.unloadingPlayerChunk;
            this.chunkMap.unloadingPlayerChunk = true;
            try {
                playerchunkmap.a(this.s, playerchunk_state);
            }
            finally {
                this.chunkMap.unloadingPlayerChunk = unloadingBefore;
            }
        }, executor);
        this.C = completablefuture1;
        completablefuture.thenAccept(either -> either.ifLeft(chunk -> completablefuture1.complete(null)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(PlayerChunkMap playerchunkmap, State playerchunk_state) {
        this.C.cancel(false);
        boolean unloadingBefore = this.chunkMap.unloadingPlayerChunk;
        this.chunkMap.unloadingPlayerChunk = true;
        try {
            playerchunkmap.a(this.s, playerchunk_state);
        }
        finally {
            this.chunkMap.unloadingPlayerChunk = unloadingBefore;
        }
    }

    protected void a(PlayerChunkMap chunkStorage, Executor executor) {
        int priority;
        TickThread.ensureTickThread("Async ticket level update");
        long updateCount = ++this.updateCount;
        ChunkStatus chunkstatus = PlayerChunk.b(this.p);
        ChunkStatus chunkstatus1 = PlayerChunk.b(this.q);
        boolean flag = this.p <= PlayerChunkMap.b;
        boolean flag1 = this.q <= PlayerChunkMap.b;
        State playerchunk_state = PlayerChunk.c(this.p);
        State playerchunk_state1 = PlayerChunk.c(this.q);
        if (playerchunk_state.a(State.b) && !playerchunk_state1.a(State.b)) {
            ((CompletableFuture)this.a(ChunkStatus.o).thenAccept(either -> {
                TickThread.ensureTickThread("Async full status chunk future completion");
                Chunk chunk = either.left().orElse(null);
                if (chunk != null && chunk.wasLoadCallbackInvoked() && this.q > 33) {
                    if (this.unloadCallbackScheduled) {
                        return;
                    }
                    this.unloadCallbackScheduled = true;
                    chunkStorage.callbackExecutor.execute(() -> {
                        this.unloadCallbackScheduled = false;
                        if (this.q <= 33) {
                            return;
                        }
                        chunk.a(true);
                        chunk.unloadCallback();
                    });
                }
            })).exceptionally(throwable -> {
                MinecraftServer.q.error("Failed to schedule unload callback for chunk " + this.s, throwable);
                return null;
            });
            chunkStorage.callbackExecutor.run();
            if (this.updateCount != updateCount) {
                return;
            }
        }
        if (flag) {
            int i2;
            Either either2 = Either.right(new Failure(){

                public String toString() {
                    return "Unloaded ticket level " + PlayerChunk.this.s;
                }
            });
            int n2 = i2 = flag1 ? chunkstatus1.c() + 1 : 0;
            while (i2 <= chunkstatus.c()) {
                CompletableFuture<Either<IChunkAccess, Failure>> completablefuture = this.i.get(i2);
                if (completablefuture == null) {
                    this.i.set(i2, CompletableFuture.completedFuture(either2));
                }
                ++i2;
            }
        }
        boolean flag2 = playerchunk_state.a(State.b);
        boolean flag3 = playerchunk_state1.a(State.b);
        boolean prevHasBeenLoaded = this.A;
        this.A |= flag3;
        if (this.A & !prevHasBeenLoaded) {
            long timeSinceAutoSave = this.inactiveTimeStart - this.lastAutoSaveTime;
            if (timeSinceAutoSave < 0L) {
                timeSinceAutoSave = this.chunkMap.r.paperConfig.autoSavePeriod;
            }
            this.lastAutoSaveTime = this.chunkMap.r.U() - timeSinceAutoSave;
            this.chunkMap.autoSaveQueue.add((Object)this);
        }
        if (!flag2 && flag3) {
            int expectCreateCount = ++this.fullChunkCreateCount;
            this.k = chunkStorage.b(this);
            this.a(chunkStorage, this.k, executor, State.b);
            this.k.thenAccept(either -> {
                TickThread.ensureTickThread("Async full chunk future completion");
                Optional left = either.left();
                if (left.isPresent() && this.fullChunkCreateCount == expectCreateCount) {
                    Chunk fullChunk = (Chunk)either.left().get();
                    this.isFullChunkReady = true;
                    fullChunk.playerChunk = this;
                    this.chunkMap.E.clearPriorityTickets(this.s);
                }
            });
            this.a(this.k, "full");
        }
        if (flag2 && !flag3) {
            this.k.complete(c);
            this.k = e;
            ++this.fullChunkCreateCount;
            this.isFullChunkReady = false;
        }
        boolean flag4 = playerchunk_state.a(State.c);
        boolean flag5 = playerchunk_state1.a(State.c);
        if (!flag4 && flag5) {
            this.l = chunkStorage.a(this);
            this.a(chunkStorage, this.l, executor, State.c);
            this.l.thenAccept(either -> {
                TickThread.ensureTickThread("Async full chunk future completion");
                either.ifLeft(chunk -> {
                    this.isTickingReady = true;
                    this.chunkMap.r.k().tickingChunks.add((Chunk)chunk);
                });
            });
            this.a(this.l, "ticking");
        }
        if (flag4 && !flag5) {
            this.l.complete(c);
            this.isTickingReady = false;
            this.l = e;
            Chunk chunkIfCached = this.getFullChunkUnchecked();
            if (chunkIfCached != null) {
                this.chunkMap.r.k().tickingChunks.remove(chunkIfCached);
            }
        }
        boolean flag6 = playerchunk_state.a(State.d);
        boolean flag7 = playerchunk_state1.a(State.d);
        if (!flag6 && flag7) {
            if (this.m != e) {
                throw SystemUtils.c(new IllegalStateException());
            }
            this.m = chunkStorage.b(this.s);
            this.a(chunkStorage, this.m, executor, State.d);
            this.m.thenAccept(either -> {
                TickThread.ensureTickThread("Async full chunk future completion");
                either.ifLeft(chunk -> {
                    this.isEntityTickingReady = true;
                    this.chunkMap.r.k().entityTickingChunks.add((Chunk)chunk);
                });
            });
            this.a(this.m, "entity ticking");
        }
        if (flag6 && !flag7) {
            this.m.complete(c);
            this.isEntityTickingReady = false;
            this.m = e;
            Chunk chunkIfCached = this.getFullChunkUnchecked();
            if (chunkIfCached != null) {
                this.chunkMap.r.k().entityTickingChunks.remove(chunkIfCached);
            }
        }
        if (!playerchunk_state1.a(playerchunk_state)) {
            this.a(chunkStorage, playerchunk_state1);
        }
        this.priorityBoost = this.chunkMap.E.getChunkPriority(this.s);
        int currRequestedPriority = this.requestedPriority;
        int newRequestedPriority = this.requestedPriority = (priority = this.getDemandedPriority());
        if (this.r > priority) {
            int ioPriority = 3;
            if (priority <= 10) {
                ioPriority = 0;
            } else if (priority <= 20) {
                ioPriority = 2;
            }
            this.chunkMap.r.asyncChunkTaskManager.raisePriority(this.s.c, this.s.d, ioPriority);
            this.chunkMap.r.k().a().queue.changePriority(this.s.a(), this.r, priority);
        }
        if (currRequestedPriority != newRequestedPriority) {
            this.y.onLevelChange(this.s, () -> this.r, priority, p2 -> {
                this.r = p2;
            });
            int neighborsPriority = this.getNeighborsPriority();
            this.neighbors.forEach((neighbor, neighborDesired) -> neighbor.setNeighborPriority(this, neighborsPriority));
        }
        this.p = this.q;
        if (!playerchunk_state.a(State.b) && playerchunk_state1.a(State.b)) {
            ((CompletableFuture)this.a(ChunkStatus.o).thenAccept(either -> {
                TickThread.ensureTickThread("Async full status chunk future completion");
                Chunk chunk = either.left().orElse(null);
                if (chunk != null && this.p <= 33 && !chunk.wasLoadCallbackInvoked()) {
                    if (this.loadCallbackScheduled) {
                        return;
                    }
                    this.loadCallbackScheduled = true;
                    chunkStorage.callbackExecutor.execute(() -> {
                        this.loadCallbackScheduled = false;
                        if (this.p <= 33) {
                            chunk.loadCallback();
                        }
                    });
                }
            })).exceptionally(throwable -> {
                MinecraftServer.q.error("Failed to schedule load callback for chunk " + this.s, throwable);
                return null;
            });
            chunkStorage.callbackExecutor.run();
        }
    }

    public static ChunkStatus b(int level) {
        return level < 33 ? ChunkStatus.o : ChunkStatus.a(level - 33);
    }

    public static State c(int distance) {
        return g[MathHelper.a(33 - distance + 1, 0, g.length - 1)];
    }

    public boolean m() {
        return this.A;
    }

    public void n() {
        boolean prev = this.A;
        this.A = PlayerChunk.c(this.q).a(State.b);
        if (prev != this.A) {
            if (this.A) {
                long timeSinceAutoSave = this.inactiveTimeStart - this.lastAutoSaveTime;
                if (timeSinceAutoSave < 0L) {
                    timeSinceAutoSave = this.chunkMap.r.paperConfig.autoSavePeriod;
                }
                this.lastAutoSaveTime = this.chunkMap.r.U() - timeSinceAutoSave;
                this.chunkMap.autoSaveQueue.add((Object)this);
            } else {
                this.inactiveTimeStart = this.chunkMap.r.U();
                this.chunkMap.autoSaveQueue.remove((Object)this);
            }
        }
    }

    public boolean setHasBeenLoaded() {
        this.A = PlayerChunk.c(this.q).a(State.b);
        return this.A;
    }

    public void a(ProtoChunkExtension chunk) {
        for (int i2 = 0; i2 < this.i.length(); ++i2) {
            Optional<IChunkAccess> optional;
            CompletableFuture<Either<IChunkAccess, Failure>> completablefuture = this.i.get(i2);
            if (completablefuture == null || (optional = completablefuture.getNow(a).left()).isEmpty() || !(optional.get() instanceof ProtoChunk)) continue;
            this.i.set(i2, CompletableFuture.completedFuture(Either.left(chunk)));
        }
        this.a(CompletableFuture.completedFuture(Either.left(chunk.A())), "replaceProto");
    }

    public List<Pair<ChunkStatus, CompletableFuture<Either<IChunkAccess, Failure>>>> o() {
        ArrayList<Pair<ChunkStatus, CompletableFuture<Either<IChunkAccess, Failure>>>> list = new ArrayList<Pair<ChunkStatus, CompletableFuture<Either<IChunkAccess, Failure>>>>();
        for (int i2 = 0; i2 < f.size(); ++i2) {
            list.add((Pair<ChunkStatus, CompletableFuture<Either<IChunkAccess, Failure>>>)Pair.of((Object)f.get(i2), this.i.get(i2)));
        }
        return list;
    }

    private int getDemandedPriority() {
        int priority = this.neighborPriority;
        int myPriority = this.getMyPriority();
        if (priority == -1 || this.q <= 33 && priority > myPriority) {
            priority = myPriority;
        }
        return Math.max(1, Math.min(Math.max(this.q, PlayerChunkMap.b), priority));
    }

    private int getMyPriority() {
        if (this.priorityBoost == 29) {
            return 2;
        }
        return this.q - this.priorityBoost;
    }

    private int getNeighborsPriority() {
        return (this.neighborPriorities.isEmpty() ? this.getMyPriority() : this.getDemandedPriority()) + 1;
    }

    public void onNeighborRequest(PlayerChunk neighbor, ChunkStatus status) {
        neighbor.setNeighborPriority(this, this.getNeighborsPriority());
        this.neighbors.compute(neighbor, (playerChunk, currentWantedStatus) -> {
            if (currentWantedStatus == null || !currentWantedStatus.b(status)) {
                return status;
            }
            return currentWantedStatus;
        });
    }

    public void onNeighborDone(PlayerChunk neighbor, ChunkStatus chunkstatus, IChunkAccess chunk) {
        this.neighbors.compute(neighbor, (playerChunk, wantedStatus) -> {
            if (wantedStatus != null && chunkstatus.b((ChunkStatus)wantedStatus)) {
                neighbor.removeNeighborPriority(this);
                return null;
            }
            return wantedStatus;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeNeighborPriority(PlayerChunk requester) {
        Long2ObjectOpenHashMap<Integer> long2ObjectOpenHashMap = this.neighborPriorities;
        synchronized (long2ObjectOpenHashMap) {
            this.neighborPriorities.remove(requester.s.a());
            this.recalcNeighborPriority();
        }
        this.checkPriority();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setNeighborPriority(PlayerChunk requester, int priority) {
        Long2ObjectOpenHashMap<Integer> long2ObjectOpenHashMap = this.neighborPriorities;
        synchronized (long2ObjectOpenHashMap) {
            if (!Integer.valueOf(priority).equals(this.neighborPriorities.put(requester.s.a(), (Object)priority))) {
                this.recalcNeighborPriority();
            }
        }
        this.checkPriority();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recalcNeighborPriority() {
        this.neighborPriority = -1;
        if (!this.neighborPriorities.isEmpty()) {
            Long2ObjectOpenHashMap<Integer> long2ObjectOpenHashMap = this.neighborPriorities;
            synchronized (long2ObjectOpenHashMap) {
                for (Integer neighbor : this.neighborPriorities.values()) {
                    if (neighbor >= this.neighborPriority && this.neighborPriority != -1) continue;
                    this.neighborPriority = neighbor;
                }
            }
        }
    }

    private void checkPriority() {
        if (this.requestedPriority != this.getDemandedPriority()) {
            this.chunkMap.queueHolderUpdate(this);
        }
    }

    public final double getDistance(EntityPlayer player) {
        return this.getDistance(player.dc(), player.di());
    }

    public final double getDistance(double blockX, double blockZ) {
        int cx = MCUtil.fastFloor(blockX) >> 4;
        int cz = MCUtil.fastFloor(blockZ) >> 4;
        double x2 = this.s.c - cx;
        double z2 = this.s.d - cz;
        return x2 * x2 + z2 * z2;
    }

    public final double getDistanceFrom(BlockPosition pos) {
        return this.getDistance(pos.u(), pos.w());
    }

    public static ChunkStatus getNextStatus(ChunkStatus status) {
        if (status == ChunkStatus.o) {
            return status;
        }
        return f.get(status.c() + 1);
    }

    public CompletableFuture<Either<IChunkAccess, Failure>> getStatusFutureUncheckedMain(ChunkStatus chunkstatus) {
        return this.ensureMain(this.a(chunkstatus));
    }

    public <T> CompletableFuture<T> ensureMain(CompletableFuture<T> future) {
        return future.thenApplyAsync(r2 -> r2, this.chunkMap.mainInvokingExecutor);
    }

    public String toString() {
        return "PlayerChunk{location=" + this.s + ", ticketLevel=" + this.q + "/" + PlayerChunk.b(this.q) + ", chunkHolderStatus=" + this.getChunkHolderStatus() + ", neighborPriority=" + this.getNeighborsPriority() + ", priority=(" + this.q + " - " + this.priorityBoost + " vs N " + this.neighborPriority + ") = " + this.getDemandedPriority() + " A " + this.r + "}";
    }

    public final boolean isEntityTickingReady() {
        return this.isEntityTickingReady;
    }

    public final boolean isTickingReady() {
        return this.isTickingReady;
    }

    public final boolean isFullChunkReady() {
        return this.isFullChunkReady;
    }

    @FunctionalInterface
    public static interface d {
        public void onLevelChange(ChunkCoordIntPair var1, IntSupplier var2, int var3, IntConsumer var4);
    }

    public static interface e {
        public List<EntityPlayer> a(ChunkCoordIntPair var1, boolean var2);
    }

    private static final class b {
        private final Thread a;
        private final CompletableFuture<?> b;
        private final String c;

        b(Thread thread, CompletableFuture<?> action, String actionDesc) {
            this.a = thread;
            this.b = action;
            this.c = actionDesc;
        }
    }

    public static enum State {
        a,
        b,
        c,
        d;


        public boolean a(State levelType) {
            return this.ordinal() >= levelType.ordinal();
        }
    }

    public static interface Failure {
        public static final Failure b = new Failure(){

            public String toString() {
                return "UNLOADED";
            }
        };
    }
}

