/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.destroystokyo.paper.ClientOption;
import com.destroystokyo.paper.PaperSkinParts;
import com.destroystokyo.paper.SkinParts;
import com.destroystokyo.paper.event.entity.PlayerNaturallySpawnCreaturesEvent;
import com.destroystokyo.paper.event.player.PlayerClientOptionsChangeEvent;
import com.destroystokyo.paper.event.player.PlayerLocaleChangeEvent;
import com.destroystokyo.paper.event.player.PlayerSetSpawnEvent;
import com.destroystokyo.paper.event.player.PlayerStartSpectatingEntityEvent;
import com.destroystokyo.paper.event.player.PlayerStopSpectatingEntityEvent;
import com.destroystokyo.paper.util.PooledHashSets;
import com.destroystokyo.paper.util.misc.PooledLinkedHashSets;
import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.event.packet.PlayerChunkLoadEvent;
import io.papermc.paper.event.packet.PlayerChunkUnloadEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.translation.Translator;
import net.minecraft.BlockUtil;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.EnumChatFormat;
import net.minecraft.ReportedException;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.commands.arguments.ArgumentAnchor;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.NonNullList;
import net.minecraft.core.SectionPosition;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.chat.ChatComponentText;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.network.chat.ChatMessageType;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatEndPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatEnterPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatKillPacket;
import net.minecraft.network.protocol.game.PacketPlayInSettings;
import net.minecraft.network.protocol.game.PacketPlayOutAbilities;
import net.minecraft.network.protocol.game.PacketPlayOutAnimation;
import net.minecraft.network.protocol.game.PacketPlayOutBlockChange;
import net.minecraft.network.protocol.game.PacketPlayOutCamera;
import net.minecraft.network.protocol.game.PacketPlayOutChat;
import net.minecraft.network.protocol.game.PacketPlayOutCloseWindow;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEffect;
import net.minecraft.network.protocol.game.PacketPlayOutEntityStatus;
import net.minecraft.network.protocol.game.PacketPlayOutExperience;
import net.minecraft.network.protocol.game.PacketPlayOutGameStateChange;
import net.minecraft.network.protocol.game.PacketPlayOutLookAt;
import net.minecraft.network.protocol.game.PacketPlayOutNamedEntitySpawn;
import net.minecraft.network.protocol.game.PacketPlayOutNamedSoundEffect;
import net.minecraft.network.protocol.game.PacketPlayOutOpenBook;
import net.minecraft.network.protocol.game.PacketPlayOutOpenSignEditor;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindow;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindowHorse;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindowMerchant;
import net.minecraft.network.protocol.game.PacketPlayOutRemoveEntityEffect;
import net.minecraft.network.protocol.game.PacketPlayOutResourcePackSend;
import net.minecraft.network.protocol.game.PacketPlayOutRespawn;
import net.minecraft.network.protocol.game.PacketPlayOutServerDifficulty;
import net.minecraft.network.protocol.game.PacketPlayOutSetSlot;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.network.protocol.game.PacketPlayOutUnloadChunk;
import net.minecraft.network.protocol.game.PacketPlayOutUpdateHealth;
import net.minecraft.network.protocol.game.PacketPlayOutWindowData;
import net.minecraft.network.protocol.game.PacketPlayOutWindowItems;
import net.minecraft.network.protocol.game.PacketPlayOutWorldEvent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.AdvancementDataPlayer;
import net.minecraft.server.MCUtil;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.PlayerInteractManager;
import net.minecraft.server.level.WorldProviderNormal;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.ITextFilter;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.server.players.PlayerList;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.stats.RecipeBookServer;
import net.minecraft.stats.ServerStatisticManager;
import net.minecraft.stats.Statistic;
import net.minecraft.stats.StatisticList;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Unit;
import net.minecraft.world.EnumHand;
import net.minecraft.world.IInventory;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.damagesource.CombatTracker;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.IEntityAngerable;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.EnumChatVisibility;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.food.FoodMetaData;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerHorse;
import net.minecraft.world.inventory.ContainerSynchronizer;
import net.minecraft.world.inventory.ICrafting;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.SlotResult;
import net.minecraft.world.item.ItemCooldown;
import net.minecraft.world.item.ItemCooldownPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemWorldMapBase;
import net.minecraft.world.item.ItemWrittenBook;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.trading.MerchantRecipeList;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.BlockChest;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.BlockPortal;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityCommand;
import net.minecraft.world.level.block.entity.TileEntitySign;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.portal.ShapeDetectorShape;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.ScoreboardScore;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.scores.ScoreboardTeamBase;
import net.minecraft.world.scores.criteria.IScoreboardCriteria;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.WeatherType;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_18_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_18_R2.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_18_R2.event.CraftPortalEvent;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_18_R2.util.BlockStateListPopulator;
import org.bukkit.craftbukkit.v1_18_R2.util.CraftDimensionUtil;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerBedLeaveEvent;
import org.bukkit.event.player.PlayerChangedMainHandEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.world.PortalCreateEvent;
import org.bukkit.inventory.MainHand;
import org.slf4j.Logger;

public class EntityPlayer
extends EntityHuman {
    private static final Logger co = LogUtils.getLogger();
    public long lastSave = MinecraftServer.currentTick;
    private static final int cp = 32;
    private static final int cq = 10;
    public PlayerConnection b;
    public NetworkManager networkManager;
    public final MinecraftServer c;
    public final PlayerInteractManager d;
    private final AdvancementDataPlayer cr;
    private final ServerStatisticManager cs;
    private float ct = Float.MIN_VALUE;
    private int cu = Integer.MIN_VALUE;
    private int cv = Integer.MIN_VALUE;
    private int cw = Integer.MIN_VALUE;
    private int cx = Integer.MIN_VALUE;
    private int cy = Integer.MIN_VALUE;
    public boolean isRealPlayer;
    private float cz = -1.0E8f;
    private int cA = -99999999;
    private boolean cB = true;
    public int cC = -99999999;
    public int cD = 60;
    private EnumChatVisibility cE;
    private boolean cF = true;
    private long cG;
    @Nullable
    private net.minecraft.world.entity.Entity cH;
    public boolean cI;
    private boolean cJ;
    private final RecipeBookServer cK;
    @Nullable
    private Vec3D cL;
    private int cM;
    private boolean cN;
    @Nullable
    private Vec3D cO;
    @Nullable
    private Vec3D cP;
    @Nullable
    private Vec3D cQ;
    private SectionPosition cR;
    private ResourceKey<net.minecraft.world.level.World> cS;
    @Nullable
    private BlockPosition cT;
    private boolean cU;
    private float cV;
    private final ITextFilter cW;
    private boolean cX;
    private boolean cY = true;
    private final ContainerSynchronizer cZ;
    private final ICrafting da;
    private int db;
    public int e;
    public boolean f;
    private int containerUpdateDelay;
    public long loginTime;
    public int patrolSpawnDelay;
    public boolean queueHealthUpdatePacket = false;
    public PacketPlayOutUpdateHealth queuedHealthUpdatePacket;
    public static final int MOBCATEGORY_TOTAL_ENUMS = EnumCreatureType.values().length;
    public final int[] mobCounts = new int[MOBCATEGORY_TOTAL_ENUMS];
    public final PooledHashSets.PooledObjectLinkedOpenHashSet<EntityPlayer> cachedSingleMobDistanceMap;
    public String displayName;
    public Component adventure$displayName;
    public IChatBaseComponent listName;
    public Location compassTarget;
    public int newExp = 0;
    public int newLevel = 0;
    public int newTotalExp = 0;
    public boolean keepLevel = false;
    public double maxHealthCache;
    public boolean joining = true;
    public boolean sentListPacket = false;
    public boolean supressTrackerForLogin = false;
    public boolean didPlayerJoinEvent = false;
    public Integer clientViewDistance;
    public PlayerNaturallySpawnCreaturesEvent playerNaturallySpawnedEvent;
    public double lastEntitySpawnRadiusSquared;
    public final PooledLinkedHashSets.PooledObjectLinkedOpenHashSet<EntityPlayer> cachedSingleHashSet;
    public PlayerQuitEvent.QuitReason quitReason = null;
    public String locale = null;
    public Locale adventure$locale = Locale.US;
    public long timeOffset = 0L;
    public boolean relativeTime = true;
    public WeatherType weather = null;
    private float pluginRainPosition;
    private float pluginRainPositionPrevious;

    public EntityPlayer(MinecraftServer server, WorldServer world, GameProfile profile) {
        super(world, world.v(), world.w(), profile);
        this.cE = EnumChatVisibility.a;
        this.cG = SystemUtils.b();
        this.cK = new RecipeBookServer();
        this.cR = SectionPosition.a(0, 0, 0);
        this.cS = net.minecraft.world.level.World.e;
        this.cZ = new ContainerSynchronizer(){

            @Override
            public void a(Container handler, NonNullList<ItemStack> stacks, ItemStack cursorStack, int[] properties) {
                EntityPlayer.this.b.a(new PacketPlayOutWindowItems(handler.j, handler.k(), stacks, cursorStack));
                for (int i2 = 0; i2 < properties.length; ++i2) {
                    this.b(handler, i2, properties[i2]);
                }
            }

            @Override
            public void a(Container handler, int slot, ItemStack stack) {
                EntityPlayer.this.b.a(new PacketPlayOutSetSlot(handler.j, handler.k(), slot, stack));
            }

            @Override
            public void a(Container handler, ItemStack stack) {
                EntityPlayer.this.b.a(new PacketPlayOutSetSlot(-1, handler.k(), -1, stack));
            }

            @Override
            public void a(Container handler, int property, int value) {
                this.b(handler, property, value);
            }

            private void b(Container handler, int property, int value) {
                EntityPlayer.this.b.a(new PacketPlayOutWindowData(handler.j, property, value));
            }
        };
        this.da = new ICrafting(){

            @Override
            public void a(Container handler, int slotId, ItemStack stack) {
                Slot slot = handler.b(slotId);
                if (!(slot instanceof SlotResult) && slot.c == EntityPlayer.this.fr()) {
                    CriterionTriggers.e.a(EntityPlayer.this, EntityPlayer.this.fr(), stack);
                }
            }

            @Override
            public void a(Container handler, int property, int value) {
            }
        };
        this.cW = server.a(this);
        this.d = server.b(this);
        this.c = server;
        this.cs = server.ac().getPlayerStats(this);
        this.cr = server.ac().f(this);
        this.P = 1.0f;
        this.cachedSingleHashSet = new PooledLinkedHashSets.PooledObjectLinkedOpenHashSet<EntityPlayer>(this);
        this.displayName = this.co();
        this.adventure$displayName = Component.text((String)this.co());
        this.bukkitPickUpLoot = true;
        this.maxHealthCache = this.em();
        this.cachedSingleMobDistanceMap = new PooledHashSets.PooledObjectLinkedOpenHashSet<EntityPlayer>(this);
    }

    public BlockPosition getPointInFront(double inFront) {
        double rads = Math.toRadians(MCUtil.normalizeYaw(((net.minecraft.world.entity.Entity)this).aA + 90.0f));
        double x2 = this.dc() + inFront * Math.cos(rads);
        double z2 = this.di() + inFront * Math.sin(rads);
        return new BlockPosition(x2, this.de(), z2);
    }

    public ChunkCoordIntPair getChunkInFront(double inFront) {
        double rads = Math.toRadians(MCUtil.normalizeYaw(((net.minecraft.world.entity.Entity)this).aA + 90.0f));
        double x2 = this.dc() + inFront * 16.0 * Math.cos(rads);
        double z2 = this.di() + inFront * 16.0 * Math.sin(rads);
        return new ChunkCoordIntPair(MathHelper.b(x2) >> 4, MathHelper.b(z2) >> 4);
    }

    public final BlockPosition getSpawnPoint(WorldServer worldserver) {
        BlockPosition blockposition = worldserver.v();
        if (worldserver.q_().a() && worldserver.M.m() != EnumGamemode.c) {
            long k2;
            long l2;
            int i2 = Math.max(0, this.c.a(worldserver));
            int j2 = MathHelper.b(worldserver.p_().b(blockposition.u(), blockposition.w()));
            if (j2 < i2) {
                i2 = j2;
            }
            if (j2 <= 1) {
                i2 = 1;
            }
            int i1 = (l2 = (k2 = (long)(i2 * 2 + 1)) * k2) > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l2;
            int j1 = this.u(i1);
            int k1 = new Random().nextInt(i1);
            for (int l1 = 0; l1 < i1; ++l1) {
                int i22 = (k1 + j1 * l1) % i1;
                int j22 = i22 % (i2 * 2 + 1);
                int k22 = i22 / (i2 * 2 + 1);
                BlockPosition blockposition1 = WorldProviderNormal.a(worldserver, blockposition.u() + j22 - i2, blockposition.w() + k22 - i2);
                if (blockposition1 == null) continue;
                return blockposition1;
            }
        }
        return blockposition;
    }

    public void d(WorldServer world) {
        BlockPosition blockposition = world.v();
        if (world.q_().a() && world.M.m() != EnumGamemode.c) {
            long k2;
            long l2;
            int i2 = Math.max(0, this.c.a(world));
            int j2 = MathHelper.b(world.p_().b(blockposition.u(), blockposition.w()));
            if (j2 < i2) {
                i2 = j2;
            }
            if (j2 <= 1) {
                i2 = 1;
            }
            int i1 = (l2 = (k2 = (long)(i2 * 2 + 1)) * k2) > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l2;
            int j1 = this.u(i1);
            int k1 = new Random().nextInt(i1);
            for (int l1 = 0; l1 < i1; ++l1) {
                int i22 = (k1 + j1 * l1) % i1;
                int j22 = i22 % (i2 * 2 + 1);
                int k22 = i22 / (i2 * 2 + 1);
                BlockPosition blockposition1 = WorldProviderNormal.a(world, blockposition.u() + j22 - i2, blockposition.w() + k22 - i2);
                if (blockposition1 == null) continue;
                this.a(blockposition1, 0.0f, 0.0f);
                if (!world.noCollision(this, this.cw(), true)) {
                    continue;
                }
                break;
            }
        } else {
            this.a(blockposition, 0.0f, 0.0f);
            while (!world.noCollision(this, this.cw(), true) && this.de() < (double)(world.ag() - 1)) {
                this.e(this.dc(), this.de() + 1.0, this.di());
            }
        }
    }

    private int u(int horizontalSpawnArea) {
        return horizontalSpawnArea <= 16 ? horizontalSpawnArea - 1 : 17;
    }

    @Override
    public void a(NBTTagCompound nbt) {
        String spawnWorld;
        CraftWorld oldWorld;
        super.a(nbt);
        if (nbt.b("enteredNetherPosition", 10)) {
            NBTTagCompound nbttagcompound1 = nbt.p("enteredNetherPosition");
            this.cP = new Vec3D(nbttagcompound1.k("x"), nbttagcompound1.k("y"), nbttagcompound1.k("z"));
        }
        this.cJ = nbt.q("seenCredits");
        if (nbt.b("recipeBook", 10)) {
            this.cK.a(nbt.p("recipeBook"), this.c.aC());
        }
        this.getBukkitEntity().readExtraData(nbt);
        if (this.fc()) {
            this.fd();
        }
        if ((oldWorld = (CraftWorld)Bukkit.getWorld((String)(spawnWorld = nbt.l("SpawnWorld")))) != null) {
            this.cS = oldWorld.getHandle().aa();
        }
        if (nbt.b("SpawnX", 99) && nbt.b("SpawnY", 99) && nbt.b("SpawnZ", 99)) {
            this.cT = new BlockPosition(nbt.h("SpawnX"), nbt.h("SpawnY"), nbt.h("SpawnZ"));
            this.cU = nbt.q("SpawnForced");
            this.cV = nbt.j("SpawnAngle");
            if (nbt.e("SpawnDimension")) {
                DataResult dataresult = net.minecraft.world.level.World.d.parse((DynamicOps)DynamicOpsNBT.a, (Object)nbt.c("SpawnDimension"));
                Logger logger = co;
                Objects.requireNonNull(logger);
                this.cS = dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).orElse(net.minecraft.world.level.World.e);
            }
        }
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        this.k(nbt);
        nbt.a("seenCredits", this.cJ);
        if (this.cP != null) {
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.a("x", this.cP.b);
            nbttagcompound1.a("y", this.cP.c);
            nbttagcompound1.a("z", this.cP.d);
            nbt.a("enteredNetherPosition", nbttagcompound1);
        }
        net.minecraft.world.entity.Entity entity = this.cL();
        net.minecraft.world.entity.Entity entity1 = this.cN();
        boolean persistVehicle = true;
        if (entity1 != null) {
            for (net.minecraft.world.entity.Entity vehicle = entity1; vehicle != null; vehicle = vehicle.cN()) {
                if (vehicle.persist) continue;
                persistVehicle = false;
                break;
            }
        }
        if (persistVehicle && entity1 != null && entity != this && entity.cK() && !entity.dp()) {
            NBTTagCompound nbttagcompound2 = new NBTTagCompound();
            NBTTagCompound nbttagcompound3 = new NBTTagCompound();
            entity.e(nbttagcompound3);
            nbttagcompound2.a("Attach", entity1.cm());
            nbttagcompound2.a("Entity", nbttagcompound3);
            nbt.a("RootVehicle", nbttagcompound2);
        }
        nbt.a("recipeBook", this.cK.b());
        nbt.a("Dimension", this.s.aa().a().toString());
        if (this.cT != null) {
            nbt.a("SpawnX", this.cT.u());
            nbt.a("SpawnY", this.cT.v());
            nbt.a("SpawnZ", this.cT.w());
            nbt.a("SpawnForced", this.cU);
            nbt.a("SpawnAngle", this.cV);
            DataResult dataresult = MinecraftKey.a.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.cS.a());
            Logger logger = co;
            Objects.requireNonNull(logger);
            dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(nbtbase -> nbt.a("SpawnDimension", (NBTBase)nbtbase));
        }
        this.getBukkitEntity().setExtraData(nbt);
    }

    public void spawnIn(net.minecraft.world.level.World world) {
        this.s = world;
        if (world == null) {
            this.dr();
            Vec3D position = null;
            if (this.cS != null && (world = this.x().getCraftServer().getHandle().b().a(this.cS)) != null && this.N() != null) {
                position = EntityHuman.a((WorldServer)world, this.N(), this.O(), false, false).orElse(null);
            }
            if (world == null || position == null) {
                world = ((CraftWorld)Bukkit.getServer().getWorlds().get(0)).getHandle();
                position = Vec3D.a(((WorldServer)world).v());
            }
            this.s = world;
            this.o(position.a(), position.b(), position.c());
        }
        this.d.a((WorldServer)world);
    }

    public void a(int points) {
        float f2 = this.fz();
        float f1 = (f2 - 1.0f) / f2;
        this.ck = MathHelper.a((float)points / f2, 0.0f, f1);
        this.cC = -1;
    }

    public void b(int level) {
        this.ci = level;
        this.cC = -1;
    }

    @Override
    public void c(int levels) {
        super.c(levels);
        this.cC = -1;
    }

    @Override
    public void a(ItemStack enchantedItem, int experienceLevels) {
        super.a(enchantedItem, experienceLevels);
        this.cC = -1;
    }

    public void a(Container screenHandler) {
        screenHandler.a(this.da);
        screenHandler.a(this.cZ);
    }

    public void g() {
        this.a(this.bU);
    }

    @Override
    public void h() {
        super.h();
        this.b.a(new ClientboundPlayerCombatEnterPacket());
    }

    @Override
    public void i() {
        super.i();
        this.b.a(new ClientboundPlayerCombatEndPacket(this.ek()));
    }

    @Override
    protected void a(IBlockData state) {
        CriterionTriggers.d.a(this, state);
    }

    @Override
    protected ItemCooldown j() {
        return new ItemCooldownPlayer(this);
    }

    @Override
    public void k() {
        net.minecraft.world.entity.Entity entity;
        if (this.joining) {
            this.joining = false;
        }
        this.d.a();
        --this.cD;
        if (this.W > 0) {
            --this.W;
        }
        if (--this.containerUpdateDelay <= 0) {
            this.bV.d();
            this.containerUpdateDelay = this.s.paperConfig.containerUpdateTickRate;
        }
        if (!(this.s.x || this.bV == this.bU || !this.ex() && this.bV.a(this))) {
            this.closeContainer(InventoryCloseEvent.Reason.CANT_USE);
            this.bV = this.bU;
        }
        if ((entity = this.G()) != this) {
            if (entity.bl()) {
                this.a(entity.dc(), entity.de(), entity.di(), entity.dn(), entity.do());
                this.x().k().a(this);
                if (this.fh()) {
                    this.c((net.minecraft.world.entity.Entity)this);
                }
            } else {
                this.c((net.minecraft.world.entity.Entity)this);
            }
        }
        CriterionTriggers.w.a(this);
        if (this.cL != null) {
            CriterionTriggers.u.a(this, this.cL, this.S - this.cM);
        }
        this.n();
        this.o();
        this.cr.b(this);
    }

    public void l() {
        try {
            if (this.valid && !this.B_() || !this.cR()) {
                super.k();
            }
            for (int i2 = 0; i2 < this.fr().b(); ++i2) {
                Packet<?> packet;
                ItemStack itemstack = this.fr().a(i2);
                if (!itemstack.c().O_() || (packet = ((ItemWorldMapBase)itemstack.c()).a(itemstack, this.s, this)) == null) continue;
                this.b.a(packet);
            }
            if (this.ea() != this.cz || this.cA != this.bW.a() || this.bW.e() == 0.0f != this.cB) {
                this.b.a(new PacketPlayOutUpdateHealth(this.getBukkitEntity().getScaledHealth(), this.bW.a(), this.bW.e()));
                this.cz = this.ea();
                this.cA = this.bW.a();
                boolean bl = this.cB = this.bW.e() == 0.0f;
            }
            if (this.ea() + this.eJ() != this.ct) {
                this.ct = this.ea() + this.eJ();
                this.a(IScoreboardCriteria.f, MathHelper.f(this.ct));
            }
            if (this.bW.a() != this.cu) {
                this.cu = this.bW.a();
                this.a(IScoreboardCriteria.g, MathHelper.f((float)this.cu));
            }
            if (this.bY() != this.cv) {
                this.cv = this.bY();
                this.a(IScoreboardCriteria.h, MathHelper.f((float)this.cv));
            }
            if (this.ej() != this.cw) {
                this.cw = this.ej();
                this.a(IScoreboardCriteria.i, MathHelper.f((float)this.cw));
            }
            if (this.cj != this.cy) {
                this.cy = this.cj;
                this.a(IScoreboardCriteria.j, MathHelper.f((float)this.cy));
            }
            if (this.maxHealthCache != (double)this.em()) {
                this.getBukkitEntity().updateScaledHealth();
            }
            if (this.ci != this.cx) {
                this.cx = this.ci;
                this.a(IScoreboardCriteria.k, MathHelper.f((float)this.cx));
            }
            if (this.cj != this.cC) {
                this.cC = this.cj;
                this.b.a(new PacketPlayOutExperience(this.ck, this.cj, this.ci));
            }
            if (this.S % 20 == 0) {
                CriterionTriggers.p.a(this);
            }
            if (this.oldLevel == -1) {
                this.oldLevel = this.ci;
            }
            if (this.oldLevel != this.ci) {
                CraftEventFactory.callPlayerLevelChangeEvent(this.getBukkitEntity(), this.oldLevel, this.ci);
                this.oldLevel = this.ci;
            }
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.a(throwable, "Ticking player");
            CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Player being ticked");
            this.a(crashreportsystemdetails);
            throw new ReportedException(crashreport);
        }
    }

    @Override
    public void m() {
        if (this.ea() > 0.0f && this.cO != null) {
            CriterionTriggers.T.a(this, this.cO);
        }
        this.cO = null;
        super.m();
    }

    public void n() {
        if (this.L > 0.0f && this.cO == null) {
            this.cO = this.cV();
        }
    }

    public void o() {
        if (this.cN() != null && this.cN().bc()) {
            if (this.cQ == null) {
                this.cQ = this.cV();
            } else {
                CriterionTriggers.U.a(this, this.cQ);
            }
        }
        if (!(this.cQ == null || this.cN() != null && this.cN().bc())) {
            this.cQ = null;
        }
    }

    private void a(IScoreboardCriteria criterion, int score) {
        this.s.getCraftServer().getScoreboardManager().getScoreboardScores(criterion, this.co(), scoreboardscore -> scoreboardscore.b(score));
    }

    private static void processKeep(PlayerDeathEvent event, NonNullList<ItemStack> inv) {
        List itemsToKeep = event.getItemsToKeep();
        if (inv == null) {
            if (!itemsToKeep.isEmpty()) {
                for (org.bukkit.inventory.ItemStack itemStack : itemsToKeep) {
                    event.getEntity().getInventory().addItem(new org.bukkit.inventory.ItemStack[]{itemStack});
                }
            }
            return;
        }
        for (int i2 = 0; i2 < inv.size(); ++i2) {
            ItemStack item = inv.get(i2);
            if (EnchantmentManager.e(item) || itemsToKeep.isEmpty() || item.b()) {
                inv.set(i2, ItemStack.b);
                continue;
            }
            org.bukkit.inventory.ItemStack bukkitStack = item.getBukkitStack();
            boolean keep = false;
            Iterator iterator = itemsToKeep.iterator();
            while (iterator.hasNext()) {
                org.bukkit.inventory.ItemStack itemStack = (org.bukkit.inventory.ItemStack)iterator.next();
                if (!bukkitStack.equals((Object)itemStack)) continue;
                iterator.remove();
                keep = true;
                break;
            }
            if (keep) continue;
            inv.set(i2, ItemStack.b);
        }
    }

    @Override
    public void a(DamageSource source) {
        TextComponent deathMessage;
        boolean keepInventory;
        boolean flag = this.s.W().b(GameRules.m);
        if (this.dp()) {
            return;
        }
        ArrayList<org.bukkit.inventory.ItemStack> loot = new ArrayList<org.bukkit.inventory.ItemStack>(this.fr().b());
        boolean bl = keepInventory = this.s.W().b(GameRules.d) || this.B_();
        if (!keepInventory) {
            for (ItemStack itemStack : this.fr().getContents()) {
                if (itemStack.b() || EnchantmentManager.e(itemStack)) continue;
                loot.add(CraftItemStack.asCraftMirror(itemStack));
            }
        }
        this.a(source, this.bd > 0);
        for (org.bukkit.inventory.ItemStack itemStack : this.drops) {
            loot.add(itemStack);
        }
        this.drops.clear();
        IChatBaseComponent defaultMessage = this.ek().b();
        String string = defaultMessage.getString();
        this.keepLevel = keepInventory;
        PlayerDeathEvent event = CraftEventFactory.callPlayerDeathEvent(this, loot, PaperAdventure.asAdventure(defaultMessage), defaultMessage.getString(), keepInventory);
        if (event.isCancelled()) {
            if (this.ea() <= 0.0f) {
                this.c((float)event.getReviveHealth());
            }
            return;
        }
        if (this.bV != this.bU) {
            this.closeContainer(InventoryCloseEvent.Reason.DEATH);
        }
        Object object = deathMessage = event.deathMessage() != null ? event.deathMessage() : Component.empty();
        if (deathMessage != null && deathMessage != Component.empty() && flag) {
            IChatBaseComponent ichatbasecomponent = PaperAdventure.asVanilla((Component)deathMessage);
            this.b.a(new ClientboundPlayerCombatKillPacket(this.ek(), ichatbasecomponent), (GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener)future -> {
                if (!future.isSuccess()) {
                    boolean flag1 = true;
                    String s2 = ichatbasecomponent.a(256);
                    ChatMessage chatmessage = new ChatMessage("death.attack.message_too_long", new ChatComponentText(s2).a(EnumChatFormat.o));
                    IChatMutableComponent ichatmutablecomponent = new ChatMessage("death.attack.even_more_magic", this.C_()).a(chatmodifier -> chatmodifier.a(new ChatHoverable(ChatHoverable.EnumHoverAction.a, chatmessage)));
                    this.b.a(new ClientboundPlayerCombatKillPacket(this.ek(), ichatmutablecomponent));
                }
            }));
            ScoreboardTeamBase scoreboardTeamBase = this.bW();
            if (scoreboardTeamBase != null && scoreboardTeamBase.k() != ScoreboardTeamBase.EnumNameTagVisibility.a) {
                if (scoreboardTeamBase.k() == ScoreboardTeamBase.EnumNameTagVisibility.c) {
                    this.c.ac().a((EntityHuman)this, ichatbasecomponent);
                } else if (scoreboardTeamBase.k() == ScoreboardTeamBase.EnumNameTagVisibility.d) {
                    this.c.ac().b(this, ichatbasecomponent);
                }
            } else {
                this.c.ac().a(ichatbasecomponent, ChatMessageType.b, SystemUtils.c);
            }
        } else {
            this.b.a(new ClientboundPlayerCombatKillPacket(this.ek(), ChatComponentText.d));
        }
        this.fE();
        if (this.s.W().b(GameRules.H)) {
            this.fP();
        }
        if (event.shouldDropExperience()) {
            this.ee();
        }
        if (!event.getKeepInventory()) {
            for (NonNullList nonNullList : this.fr().n) {
                EntityPlayer.processKeep(event, nonNullList);
            }
            EntityPlayer.processKeep(event, null);
        }
        this.c((net.minecraft.world.entity.Entity)this);
        this.s.getCraftServer().getScoreboardManager().getScoreboardScores(IScoreboardCriteria.c, this.co(), ScoreboardScore::a);
        EntityLiving entityliving = this.el();
        if (entityliving != null) {
            this.b(StatisticList.h.b(entityliving.ad()));
            entityliving.a((net.minecraft.world.entity.Entity)this, this.bl, source);
            this.f(entityliving);
        }
        this.s.a((net.minecraft.world.entity.Entity)this, (byte)3);
        this.a(StatisticList.N);
        this.a(StatisticList.i.b(StatisticList.m));
        this.a(StatisticList.i.b(StatisticList.n));
        this.au();
        this.j(0);
        this.a_(false);
        this.ek().g();
    }

    private void fP() {
        AxisAlignedBB axisalignedbb = new AxisAlignedBB(this.cW()).c(32.0, 10.0, 32.0);
        this.s.a(EntityInsentient.class, axisalignedbb, IEntitySelector.f).stream().filter(entityinsentient -> entityinsentient instanceof IEntityAngerable).forEach(entityinsentient -> ((IEntityAngerable)((Object)entityinsentient)).a_(this));
    }

    @Override
    public void a(net.minecraft.world.entity.Entity entityKilled, int score, DamageSource damageSource) {
        if (entityKilled != this) {
            super.a(entityKilled, score, damageSource);
            this.s(score);
            String s2 = this.co();
            String s1 = entityKilled.co();
            this.s.getCraftServer().getScoreboardManager().getScoreboardScores(IScoreboardCriteria.e, s2, ScoreboardScore::a);
            if (entityKilled instanceof EntityHuman) {
                this.a(StatisticList.Q);
                this.s.getCraftServer().getScoreboardManager().getScoreboardScores(IScoreboardCriteria.d, s2, ScoreboardScore::a);
            } else {
                this.a(StatisticList.O);
            }
            this.a(s2, s1, IScoreboardCriteria.l);
            this.a(s1, s2, IScoreboardCriteria.m);
            CriterionTriggers.b.a(this, entityKilled, damageSource);
        }
    }

    private void a(String playerName, String team, IScoreboardCriteria[] criterions) {
        int i2;
        ScoreboardTeam scoreboardteam = this.fF().i(team);
        if (scoreboardteam != null && (i2 = scoreboardteam.n().b()) >= 0 && i2 < criterions.length) {
            this.s.getCraftServer().getScoreboardManager().getScoreboardScores(criterions[i2], playerName, ScoreboardScore::a);
        }
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        boolean flag;
        if (this.b(source)) {
            return false;
        }
        boolean bl = flag = this.c.k() && this.fQ() && "fall".equals(source.y);
        if (!flag && this.cD > 0 && source != DamageSource.m) {
            return false;
        }
        if (source instanceof EntityDamageSource) {
            EntityArrow entityarrow;
            net.minecraft.world.entity.Entity entity1;
            net.minecraft.world.entity.Entity entity = source.l();
            if (entity instanceof EntityHuman && !this.a((EntityHuman)entity)) {
                return false;
            }
            if (entity instanceof EntityArrow && (entity1 = (entityarrow = (EntityArrow)entity).x()) instanceof EntityHuman && !this.a((EntityHuman)entity1)) {
                return false;
            }
        }
        this.queueHealthUpdatePacket = true;
        boolean damaged = super.a(source, amount);
        this.queueHealthUpdatePacket = false;
        if (this.queuedHealthUpdatePacket != null) {
            this.b.a(this.queuedHealthUpdatePacket);
            this.queuedHealthUpdatePacket = null;
        }
        return damaged;
    }

    @Override
    public boolean a(EntityHuman player) {
        return !this.fQ() ? false : super.a(player);
    }

    private boolean fQ() {
        return this.s.pvpMode;
    }

    @Override
    @Nullable
    protected ShapeDetectorShape a(WorldServer destination) {
        ShapeDetectorShape shapedetectorshape = super.a(destination);
        WorldServer worldServer = destination = shapedetectorshape == null ? destination : shapedetectorshape.world;
        if (shapedetectorshape != null && this.s.getTypeKey() == WorldDimension.b && destination != null && destination.getTypeKey() == WorldDimension.d) {
            Vec3D vec3d = shapedetectorshape.a.b(0.0, -1.0, 0.0);
            return new ShapeDetectorShape(vec3d, Vec3D.a, 90.0f, 0.0f, destination, shapedetectorshape.portalEventInfo);
        }
        return shapedetectorshape;
    }

    @Override
    @Nullable
    public net.minecraft.world.entity.Entity b(WorldServer destination) {
        return this.changeDimension(destination, PlayerTeleportEvent.TeleportCause.UNKNOWN);
    }

    @Nullable
    public net.minecraft.world.entity.Entity changeDimension(WorldServer worldserver, PlayerTeleportEvent.TeleportCause cause) {
        if (this.fc()) {
            return this;
        }
        WorldServer worldserver1 = this.x();
        ResourceKey<WorldDimension> resourcekey = worldserver1.getTypeKey();
        if (resourcekey == WorldDimension.d && worldserver != null && worldserver.getTypeKey() == WorldDimension.b) {
            this.cI = true;
            this.ab();
            this.x().a(this, Entity.RemovalReason.e);
            if (!this.f) {
                if (this.s.paperConfig.disableEndCredits) {
                    this.cJ = true;
                }
                this.f = true;
                this.b.a(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.e, this.cJ ? 0.0f : 1.0f));
                this.cJ = true;
            }
            return this;
        }
        ShapeDetectorShape shapedetectorshape = this.a(worldserver);
        if (shapedetectorshape != null) {
            worldserver1.ab().a("moving");
            worldserver = shapedetectorshape.world;
            if (worldserver != null) {
                if (resourcekey == WorldDimension.b && worldserver.getTypeKey() == WorldDimension.c) {
                    this.cP = this.cV();
                } else if (worldserver.getTypeKey() == WorldDimension.d && shapedetectorshape.portalEventInfo != null && shapedetectorshape.portalEventInfo.getCanCreatePortal()) {
                    this.a(worldserver, new BlockPosition(shapedetectorshape.a));
                }
            }
        } else {
            return null;
        }
        Location enter = this.getBukkitEntity().getLocation();
        Location exit = worldserver == null ? null : new Location((World)worldserver.getWorld(), shapedetectorshape.a.b, shapedetectorshape.a.c, shapedetectorshape.a.d, shapedetectorshape.c, shapedetectorshape.d);
        PlayerTeleportEvent tpEvent = new PlayerTeleportEvent((Player)this.getBukkitEntity(), enter, exit, cause);
        Bukkit.getServer().getPluginManager().callEvent((Event)tpEvent);
        if (tpEvent.isCancelled() || tpEvent.getTo() == null) {
            return null;
        }
        exit = tpEvent.getTo();
        worldserver = ((CraftWorld)exit.getWorld()).getHandle();
        worldserver1.ab().c();
        worldserver1.ab().a("placing");
        this.cI = true;
        this.b.a(new PacketPlayOutRespawn(worldserver.Z(), worldserver.aa(), BiomeManager.a(worldserver.D()), this.d.b(), this.d.c(), worldserver.ad(), worldserver.C(), true));
        this.b.a(new PacketPlayOutServerDifficulty(worldserver.af(), this.s.n_().t()));
        PlayerList playerlist = this.c.ac();
        playerlist.d(this);
        worldserver1.a(this, Entity.RemovalReason.e);
        this.dr();
        this.c(worldserver);
        worldserver.b(this);
        this.b.teleport(exit);
        this.b.d();
        worldserver1.ab().c();
        this.e(worldserver1);
        this.b.a(new PacketPlayOutAbilities(this.fs()));
        playerlist.a(this, worldserver);
        playerlist.e(this);
        for (MobEffect mobeffect : this.dX()) {
            this.b.a(new PacketPlayOutEntityEffect(this.ae(), mobeffect));
        }
        this.b.a(new PacketPlayOutWorldEvent(1032, BlockPosition.b, 0, false));
        this.cC = -1;
        this.cz = -1.0f;
        this.cA = -1;
        PlayerChangedWorldEvent changeEvent = new PlayerChangedWorldEvent((Player)this.getBukkitEntity(), (World)worldserver1.getWorld());
        this.s.getCraftServer().getPluginManager().callEvent((Event)changeEvent);
        if (this.eT()) {
            this.eS();
        }
        return this;
    }

    @Override
    protected CraftPortalEvent callPortalEvent(net.minecraft.world.entity.Entity entity, WorldServer exitWorldServer, BlockPosition exitPosition, PlayerTeleportEvent.TeleportCause cause, int searchRadius, int creationRadius) {
        Location enter = this.getBukkitEntity().getLocation();
        Location exit = new Location((World)exitWorldServer.getWorld(), (double)exitPosition.u(), (double)exitPosition.v(), (double)exitPosition.w(), this.dn(), this.do());
        PlayerPortalEvent event = new PlayerPortalEvent((Player)this.getBukkitEntity(), enter, exit, cause, searchRadius, true, creationRadius);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled() || event.getTo() == null || event.getTo().getWorld() == null) {
            return null;
        }
        return new CraftPortalEvent(event);
    }

    private void a(WorldServer world, BlockPosition centerPos) {
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = centerPos.i();
        BlockStateListPopulator blockList = new BlockStateListPopulator(world);
        for (int i2 = -2; i2 <= 2; ++i2) {
            for (int j2 = -2; j2 <= 2; ++j2) {
                for (int k2 = -1; k2 < 3; ++k2) {
                    IBlockData iblockdata = k2 == -1 ? Blocks.bQ.n() : Blocks.a.n();
                    blockList.a((BlockPosition)blockposition_mutableblockposition.g(centerPos).e(j2, k2, i2), iblockdata, 3);
                }
            }
        }
        if (new PortalCreateEvent(blockList.getList(), (World)world.getWorld(), (Entity)this.getBukkitEntity(), PortalCreateEvent.CreateReason.END_PLATFORM).callEvent()) {
            blockList.updateList();
        }
    }

    @Override
    protected Optional<BlockUtil.Rectangle> getExitPortal(WorldServer worldserver, BlockPosition blockposition, boolean flag, WorldBorder worldborder, int searchRadius, boolean canCreatePortal, int createRadius) {
        Optional<BlockUtil.Rectangle> optional = super.getExitPortal(worldserver, blockposition, flag, worldborder, searchRadius, canCreatePortal, createRadius);
        if (optional.isPresent() || !canCreatePortal) {
            return optional;
        }
        EnumDirection.EnumAxis enumdirection_enumaxis = this.s.a_(this.ai).d(BlockPortal.a).orElse(EnumDirection.EnumAxis.a);
        Optional<BlockUtil.Rectangle> optional1 = worldserver.o().createPortal(blockposition, enumdirection_enumaxis, this, createRadius);
        if (!optional1.isPresent()) {
            // empty if block
        }
        return optional1;
    }

    public void e(WorldServer origin) {
        ResourceKey<net.minecraft.world.level.World> resourcekey = origin.aa();
        ResourceKey<net.minecraft.world.level.World> resourcekey1 = this.s.aa();
        ResourceKey<net.minecraft.world.level.World> maindimensionkey = CraftDimensionUtil.getMainDimensionKey(origin);
        ResourceKey<net.minecraft.world.level.World> maindimensionkey1 = CraftDimensionUtil.getMainDimensionKey(this.s);
        CriterionTriggers.v.a(this, maindimensionkey, maindimensionkey1);
        if (maindimensionkey != resourcekey || maindimensionkey1 != resourcekey1) {
            CriterionTriggers.v.a(this, resourcekey, resourcekey1);
        }
        if (maindimensionkey == net.minecraft.world.level.World.f && maindimensionkey1 == net.minecraft.world.level.World.e && this.cP != null) {
            CriterionTriggers.C.a(this, this.cP);
        }
        if (maindimensionkey1 != net.minecraft.world.level.World.f) {
            this.cP = null;
        }
    }

    @Override
    public boolean a(EntityPlayer spectator) {
        return spectator.B_() ? this.G() == this : (this.B_() ? false : super.a(spectator));
    }

    @Override
    public void a(net.minecraft.world.entity.Entity item, int count) {
        super.a(item, count);
        this.bV.d();
    }

    private Either<EntityHuman.EnumBedResult, Unit> getBedResult(BlockPosition blockposition, EnumDirection enumdirection) {
        if (!this.fc() && this.bl()) {
            if (!this.s.q_().d() || !this.s.q_().g()) {
                return Either.left(EntityHuman.EnumBedResult.a);
            }
            if (!this.a(blockposition, enumdirection)) {
                return Either.left(EntityHuman.EnumBedResult.c);
            }
            if (this.b(blockposition, enumdirection)) {
                return Either.left(EntityHuman.EnumBedResult.d);
            }
            this.setRespawnPosition(this.s.aa(), blockposition, this.dn(), false, true, PlayerSetSpawnEvent.Cause.BED);
            if (this.s.O()) {
                return Either.left(EntityHuman.EnumBedResult.b);
            }
            if (!this.f()) {
                double d0 = 8.0;
                double d1 = 5.0;
                Vec3D vec3d = Vec3D.c(blockposition);
                List<EntityMonster> list = this.s.a(EntityMonster.class, new AxisAlignedBB(vec3d.a() - 8.0, vec3d.b() - 5.0, vec3d.c() - 8.0, vec3d.a() + 8.0, vec3d.b() + 5.0, vec3d.c() + 8.0), (? super T entitymonster) -> entitymonster.f(this));
                if (!list.isEmpty()) {
                    return Either.left(EntityHuman.EnumBedResult.f);
                }
            }
            return Either.right(Unit.a);
        }
        return Either.left(EntityHuman.EnumBedResult.e);
    }

    @Override
    public Either<EntityHuman.EnumBedResult, Unit> startSleepInBed(BlockPosition blockposition, boolean force) {
        EnumDirection enumdirection = this.s.a_(blockposition).c(BlockFacingHorizontal.aD);
        Either<EntityHuman.EnumBedResult, Unit> bedResult = this.getBedResult(blockposition, enumdirection);
        if (bedResult.left().orElse(null) == EntityHuman.EnumBedResult.e) {
            return bedResult;
        }
        if (force) {
            bedResult = Either.right(Unit.a);
        }
        if ((bedResult = CraftEventFactory.callPlayerBedEnterEvent(this, blockposition, bedResult)).left().isPresent()) {
            return bedResult;
        }
        Either<EntityHuman.EnumBedResult, Unit> either = super.startSleepInBed(blockposition, force).ifRight(unit -> {
            this.a(StatisticList.ap);
            CriterionTriggers.q.a(this);
        });
        if (!this.x().d()) {
            this.a((IChatBaseComponent)new ChatMessage("sleep.not_possible"), true);
        }
        ((WorldServer)this.s).e();
        return either;
    }

    @Override
    public void b(BlockPosition pos) {
        this.a(StatisticList.i.b(StatisticList.n));
        super.b(pos);
    }

    private boolean a(BlockPosition pos, EnumDirection direction) {
        return this.g(pos) || this.g(pos.a(direction.f()));
    }

    private boolean g(BlockPosition pos) {
        Vec3D vec3d = Vec3D.c(pos);
        return Math.abs(this.dc() - vec3d.a()) <= 3.0 && Math.abs(this.de() - vec3d.b()) <= 2.0 && Math.abs(this.di() - vec3d.c()) <= 3.0;
    }

    private boolean b(BlockPosition pos, EnumDirection direction) {
        BlockPosition blockposition1 = pos.b();
        return !this.f(blockposition1) || !this.f(blockposition1.a(direction.f()));
    }

    @Override
    public void a(boolean skipSleepTimer, boolean updateSleepingPlayers) {
        if (!this.fc()) {
            return;
        }
        CraftPlayer player = this.getBukkitEntity();
        BlockPosition bedPosition = this.fa().orElse(null);
        Block bed = bedPosition != null ? this.s.getWorld().getBlockAt(bedPosition.u(), bedPosition.v(), bedPosition.w()) : this.s.getWorld().getBlockAt(player.getLocation());
        PlayerBedLeaveEvent event = new PlayerBedLeaveEvent((Player)player, bed, true);
        this.s.getCraftServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        if (this.fc()) {
            this.x().k().a(this, new PacketPlayOutAnimation(this, 2));
        }
        super.a(skipSleepTimer, updateSleepingPlayers);
        if (this.b != null) {
            this.b.b(this.dc(), this.de(), this.di(), this.dn(), this.do());
        }
    }

    @Override
    public boolean a(net.minecraft.world.entity.Entity entity, boolean force) {
        net.minecraft.world.entity.Entity entity1 = this.cN();
        if (!super.a(entity, force)) {
            return false;
        }
        net.minecraft.world.entity.Entity entity2 = this.cN();
        if (entity2 != entity1 && this.b != null) {
            this.b.b(this.dc(), this.de(), this.di(), this.dn(), this.do());
        }
        return true;
    }

    @Override
    public void p() {
        this.stopRiding(false);
    }

    @Override
    public void stopRiding(boolean suppressCancellation) {
        net.minecraft.world.entity.Entity entity = this.cN();
        super.stopRiding(suppressCancellation);
        net.minecraft.world.entity.Entity entity1 = this.cN();
        if (entity1 != entity && this.b != null) {
            this.b.a(this.dc(), this.de(), this.di(), this.dn(), this.do());
        }
    }

    @Override
    public void a(double destX, double destY, double destZ) {
        this.bt();
        if (this.b != null) {
            this.b.a(destX, destY, destZ, this.dn(), this.do());
        }
    }

    @Override
    public boolean b(DamageSource damageSource) {
        return super.b(damageSource) || this.K() || this.fs().a && damageSource == DamageSource.p || !this.s.paperConfig.allowPlayerCrammingDamage && damageSource == DamageSource.g;
    }

    @Override
    protected void a(double heightDifference, boolean onGround, IBlockData landedState, BlockPosition landedPosition) {
    }

    @Override
    protected void c(BlockPosition pos) {
        if (!this.B_()) {
            super.c(pos);
        }
    }

    public void a(double heightDifference, boolean onGround) {
        if (!this.cR()) {
            BlockPosition blockposition = this.aA();
            super.a(heightDifference, onGround, this.s.a_(blockposition), blockposition);
        }
    }

    @Override
    public void a(TileEntitySign sign) {
        sign.a(this.cm());
        this.b.a(new PacketPlayOutBlockChange(this.s, sign.p()));
        this.b.a(new PacketPlayOutOpenSignEditor(sign.p()));
    }

    public int nextContainerCounter() {
        this.db = this.db % 100 + 1;
        return this.db;
    }

    @Override
    public OptionalInt a(@Nullable ITileInventory factory) {
        if (factory == null) {
            return OptionalInt.empty();
        }
        this.nextContainerCounter();
        Container container = factory.createMenu(this.db, this.fr(), this);
        if (container != null) {
            container.setTitle(factory.C_());
            boolean cancelled = false;
            container = CraftEventFactory.callInventoryOpenEvent(this, container, cancelled);
            if (container == null && !cancelled) {
                if (factory instanceof IInventory) {
                    ((IInventory)((Object)factory)).c_(this);
                } else if (factory instanceof BlockChest.DoubleInventory) {
                    ((BlockChest.DoubleInventory)factory).inventorylargechest.c_(this);
                }
                return OptionalInt.empty();
            }
        }
        if (container == null) {
            if (this.B_()) {
                this.a((IChatBaseComponent)new ChatMessage("container.spectatorCantOpen").a(EnumChatFormat.m), true);
            }
            return OptionalInt.empty();
        }
        this.bV = container;
        if (!this.ex()) {
            this.b.a(new PacketPlayOutOpenWindow(container.j, container.a(), container.getTitle()));
        }
        this.a(container);
        return OptionalInt.of(this.db);
    }

    @Override
    public void a(int syncId, MerchantRecipeList offers, int levelProgress, int experience, boolean leveled, boolean refreshable) {
        this.b.a(new PacketPlayOutOpenWindowMerchant(syncId, offers, levelProgress, experience, leveled, refreshable));
    }

    @Override
    public void a(EntityHorseAbstract horse, IInventory inventory) {
        this.nextContainerCounter();
        Container container = new ContainerHorse(this.db, this.fr(), inventory, horse);
        container.setTitle(horse.C_());
        container = CraftEventFactory.callInventoryOpenEvent(this, container);
        if (container == null) {
            inventory.c_(this);
            return;
        }
        if (this.bV != this.bU) {
            this.closeContainer(InventoryCloseEvent.Reason.OPEN_NEW);
        }
        this.b.a(new PacketPlayOutOpenWindowHorse(this.db, inventory.b(), horse.ae()));
        this.bV = container;
        this.a(this.bV);
    }

    @Override
    public void a(ItemStack book, EnumHand hand) {
        if (book.a(Items.rh)) {
            if (ItemWrittenBook.a(book, this.cQ(), this)) {
                this.bV.d();
            }
            this.b.a(new PacketPlayOutOpenBook(hand));
        }
    }

    @Override
    public void a(TileEntityCommand commandBlock) {
        this.b.a(PacketPlayOutTileEntityData.a(commandBlock, TileEntity::o));
    }

    @Override
    public void q() {
        this.closeContainer(InventoryCloseEvent.Reason.UNKNOWN);
    }

    @Override
    public void closeContainer(InventoryCloseEvent.Reason reason) {
        CraftEventFactory.handleInventoryCloseEvent(this, reason);
        this.b.a(new PacketPlayOutCloseWindow(this.bV.j));
        this.r();
    }

    @Override
    public void closeUnloadedInventory(InventoryCloseEvent.Reason reason) {
        CraftEventFactory.handleInventoryCloseEvent(this, reason);
        this.b.a(new PacketPlayOutCloseWindow(this.bV.j));
        this.bV = this.bU;
    }

    public void r() {
        this.bV.b(this);
        this.bU.a(this.bV);
        this.bV = this.bU;
    }

    public void a(float sidewaysSpeed, float forwardSpeed, boolean jumping, boolean sneaking) {
        if (this.bF()) {
            if (sidewaysSpeed >= -1.0f && sidewaysSpeed <= 1.0f) {
                this.bo = sidewaysSpeed;
            }
            if (forwardSpeed >= -1.0f && forwardSpeed <= 1.0f) {
                this.bq = forwardSpeed;
            }
            this.bn = jumping;
            this.f(sneaking);
        }
    }

    @Override
    public void a(Statistic<?> stat, int amount) {
        this.cs.b(this, stat, amount);
        this.s.getCraftServer().getScoreboardManager().getScoreboardScores(stat, this.co(), scoreboardscore -> scoreboardscore.a(amount));
    }

    @Override
    public void a(Statistic<?> stat) {
        this.cs.a(this, stat, 0);
        this.s.getCraftServer().getScoreboardManager().getScoreboardScores(stat, this.co(), ScoreboardScore::c);
    }

    @Override
    public int a(Collection<IRecipe<?>> recipes) {
        return this.cK.a(recipes, this);
    }

    @Override
    public void a(MinecraftKey[] ids) {
        ArrayList list = Lists.newArrayList();
        MinecraftKey[] aminecraftkey1 = ids;
        int i2 = ids.length;
        for (int j2 = 0; j2 < i2; ++j2) {
            MinecraftKey minecraftkey = aminecraftkey1[j2];
            Optional<IRecipe<?>> optional = this.c.aC().a(minecraftkey);
            Objects.requireNonNull(list);
            optional.ifPresent(list::add);
        }
        this.a(list);
    }

    @Override
    public int b(Collection<IRecipe<?>> recipes) {
        return this.cK.b(recipes, this);
    }

    @Override
    public void d(int experience) {
        super.d(experience);
        this.cC = -1;
    }

    public void s() {
        this.cN = true;
        this.bs();
        if (this.bF() && this.cN() instanceof EntityPlayer) {
            this.p();
        }
        if (this.fc()) {
            this.a(true, false);
        }
    }

    public boolean t() {
        return this.cN;
    }

    public void u() {
        this.cz = -1.0E8f;
        this.cC = -1;
    }

    public void sendMessage(UUID uuid, IChatBaseComponent[] ichatbasecomponent) {
        for (IChatBaseComponent component : ichatbasecomponent) {
            this.a(component, uuid == null ? SystemUtils.c : uuid);
        }
    }

    @Override
    public void a(IChatBaseComponent message, boolean actionBar) {
        this.a(message, actionBar ? ChatMessageType.c : ChatMessageType.a, SystemUtils.c);
    }

    @Override
    protected void v() {
        if (!this.bz.b() && this.eM()) {
            this.b.a(new PacketPlayOutEntityStatus(this, 9));
            super.v();
        }
    }

    @Override
    public void a(ArgumentAnchor.Anchor anchorPoint, Vec3D target) {
        super.a(anchorPoint, target);
        this.b.a(new PacketPlayOutLookAt(anchorPoint, target.b, target.c, target.d));
    }

    public void a(ArgumentAnchor.Anchor anchorPoint, net.minecraft.world.entity.Entity targetEntity, ArgumentAnchor.Anchor targetAnchor) {
        Vec3D vec3d = targetAnchor.a(targetEntity);
        super.a(anchorPoint, vec3d);
        this.b.a(new PacketPlayOutLookAt(anchorPoint, targetEntity, targetAnchor));
    }

    public void a(EntityPlayer oldPlayer, boolean alive) {
        this.cX = oldPlayer.cX;
        this.d.a(oldPlayer.d.b(), oldPlayer.d.c());
        if (alive) {
            this.fr().a(oldPlayer.fr());
            this.c(oldPlayer.ea());
            this.bW = oldPlayer.bW;
            this.ci = oldPlayer.ci;
            this.cj = oldPlayer.cj;
            this.ck = oldPlayer.ck;
            this.r(oldPlayer.fl());
            this.ai = oldPlayer.ai;
        } else if (this.s.W().b(GameRules.d) || oldPlayer.B_()) {
            this.fr().a(oldPlayer.fr());
            this.ci = oldPlayer.ci;
            this.cj = oldPlayer.cj;
            this.ck = oldPlayer.ck;
            this.r(oldPlayer.fl());
        }
        this.cl = oldPlayer.cl;
        this.bT = oldPlayer.bT;
        this.ai().b(EntityHuman.bP, oldPlayer.ai().a(EntityHuman.bP));
        this.cC = -1;
        this.cz = -1.0f;
        this.cA = -1;
        this.cJ = oldPlayer.cJ;
        this.cP = oldPlayer.cP;
        this.i(oldPlayer.fH());
        this.j(oldPlayer.fI());
    }

    @Override
    protected void a(MobEffect effect, @Nullable net.minecraft.world.entity.Entity source) {
        super.a(effect, source);
        this.b.a(new PacketPlayOutEntityEffect(this.ae(), effect));
        if (effect.a() == MobEffects.y) {
            this.cM = this.S;
            this.cL = this.cV();
        }
        CriterionTriggers.A.a(this, source);
    }

    @Override
    protected void a(MobEffect effect, boolean reapplyEffect, @Nullable net.minecraft.world.entity.Entity source) {
        super.a(effect, reapplyEffect, source);
        this.b.a(new PacketPlayOutEntityEffect(this.ae(), effect));
        CriterionTriggers.A.a(this, source);
    }

    @Override
    protected void a(MobEffect effect) {
        super.a(effect);
        this.b.a(new PacketPlayOutRemoveEntityEffect(this.ae(), effect.a()));
        if (effect.a() == MobEffects.y) {
            this.cL = null;
        }
        CriterionTriggers.A.a(this, (net.minecraft.world.entity.Entity)null);
    }

    @Override
    public void b(double destX, double destY, double destZ) {
        this.b.b(destX, destY, destZ, this.dn(), this.do());
    }

    @Override
    public void c(double x2, double y2, double z2) {
        this.b(x2, y2, z2);
        this.b.d();
    }

    @Override
    public void a(net.minecraft.world.entity.Entity target) {
        this.x().k().a(this, new PacketPlayOutAnimation(target, 4));
    }

    @Override
    public void b(net.minecraft.world.entity.Entity target) {
        this.x().k().a(this, new PacketPlayOutAnimation(target, 5));
    }

    @Override
    public void w() {
        if (this.b != null) {
            this.b.a(new PacketPlayOutAbilities(this.fs()));
            this.F();
        }
    }

    public WorldServer x() {
        return (WorldServer)this.s;
    }

    public boolean a(EnumGamemode gameMode) {
        PlayerGameModeChangeEvent event = this.setGameMode(gameMode, PlayerGameModeChangeEvent.Cause.UNKNOWN, null);
        return event == null ? false : event.isCancelled();
    }

    public PlayerGameModeChangeEvent setGameMode(EnumGamemode gameMode, PlayerGameModeChangeEvent.Cause cause, Component message) {
        PlayerGameModeChangeEvent event = this.d.changeGameModeForPlayer(gameMode, cause, message);
        if (event == null || event.isCancelled()) {
            return null;
        }
        this.b.a(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.d, gameMode.a()));
        if (gameMode == EnumGamemode.d) {
            this.fE();
            this.p();
        } else {
            this.c((net.minecraft.world.entity.Entity)this);
        }
        this.w();
        this.eK();
        return event;
    }

    @Override
    public boolean B_() {
        return this.d.b() == EnumGamemode.d;
    }

    @Override
    public boolean f() {
        return this.d.b() == EnumGamemode.b;
    }

    @Override
    public void a(IChatBaseComponent message, UUID sender) {
        this.a(message, ChatMessageType.b, sender);
    }

    public void a(IChatBaseComponent message, ChatMessageType type, UUID sender) {
        if (this.a(type)) {
            this.b.a(new PacketPlayOutChat(message, type, sender), (GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener)future -> {
                if (!future.isSuccess() && (type == ChatMessageType.c || type == ChatMessageType.b) && this.a(ChatMessageType.b)) {
                    boolean flag = true;
                    String s2 = message.a(256);
                    IChatMutableComponent ichatmutablecomponent = new ChatComponentText(s2).a(EnumChatFormat.o);
                    this.b.a(new PacketPlayOutChat(new ChatMessage("multiplayer.message_not_delivered", ichatmutablecomponent).a(EnumChatFormat.m), ChatMessageType.b, sender));
                }
            }));
        }
    }

    public String y() {
        String s2 = this.b.a.c().toString();
        s2 = s2.substring(s2.indexOf("/") + 1);
        s2 = s2.substring(0, s2.indexOf(":"));
        return s2;
    }

    public void a(PacketPlayInSettings packet) {
        PlayerChangedMainHandEvent event;
        new PlayerClientOptionsChangeEvent((Player)this.getBukkitEntity(), packet.b, packet.c, ClientOption.ChatVisibility.valueOf((String)packet.d().name()), packet.e(), (SkinParts)new PaperSkinParts(packet.f()), packet.g() == EnumMainHand.a ? MainHand.LEFT : MainHand.RIGHT).callEvent();
        if (this.eL() != packet.g()) {
            event = new PlayerChangedMainHandEvent((Player)this.getBukkitEntity(), this.eL() == EnumMainHand.a ? MainHand.LEFT : MainHand.RIGHT);
            this.c.server.getPluginManager().callEvent((Event)event);
        }
        if (this.locale == null || !this.locale.equals(packet.b)) {
            event = new org.bukkit.event.player.PlayerLocaleChangeEvent((Player)this.getBukkitEntity(), packet.b);
            this.c.server.getPluginManager().callEvent((Event)event);
            this.c.server.getPluginManager().callEvent((Event)new PlayerLocaleChangeEvent((Player)this.getBukkitEntity(), this.locale, packet.b));
        }
        this.locale = packet.b;
        this.adventure$locale = Translator.parseLocale((String)this.locale);
        this.b.a.m.attr(PaperAdventure.LOCALE_ATTRIBUTE).set((Object)this.adventure$locale);
        this.clientViewDistance = packet.c;
        this.cE = packet.d();
        this.cF = packet.e();
        this.cX = packet.h();
        this.cY = packet.i();
        this.ai().b(EntityHuman.bP, (byte)packet.f());
        this.ai().b(EntityHuman.bQ, (byte)(packet.g() != EnumMainHand.a ? 1 : 0));
    }

    public boolean z() {
        return this.cF;
    }

    public EnumChatVisibility A() {
        return this.cE;
    }

    private boolean a(ChatMessageType type) {
        switch (this.cE) {
            case c: {
                return type == ChatMessageType.c;
            }
            case b: {
                return type == ChatMessageType.b || type == ChatMessageType.c;
            }
        }
        return true;
    }

    public void a(String url, String hash, boolean required, @Nullable IChatBaseComponent resourcePackPrompt) {
        this.b.a(new PacketPlayOutResourcePackSend(url, hash, required, resourcePackPrompt));
    }

    @Override
    protected int B() {
        return this.c.b(this.fq());
    }

    public void C() {
        this.cG = SystemUtils.b();
    }

    public ServerStatisticManager D() {
        return this.cs;
    }

    public RecipeBookServer E() {
        return this.cK;
    }

    @Override
    protected void F() {
        if (this.B_()) {
            this.dV();
            this.j(true);
        } else {
            super.F();
        }
    }

    public net.minecraft.world.entity.Entity G() {
        return this.cH == null ? this : this.cH;
    }

    public void c(@Nullable net.minecraft.world.entity.Entity entity) {
        PlayerStartSpectatingEntityEvent playerStartSpectatingEntityEvent;
        PlayerStopSpectatingEntityEvent playerStopSpectatingEntityEvent;
        net.minecraft.world.entity.Entity entity1 = this.G();
        if (entity == null) {
            entity = this;
        }
        if (entity1 == entity) {
            return;
        }
        if (entity == this ? !(playerStopSpectatingEntityEvent = new PlayerStopSpectatingEntityEvent((Player)this.getBukkitEntity(), (Entity)entity1.getBukkitEntity())).callEvent() : !(playerStartSpectatingEntityEvent = new PlayerStartSpectatingEntityEvent((Player)this.getBukkitEntity(), (Entity)entity1.getBukkitEntity(), (Entity)entity.getBukkitEntity())).callEvent()) {
            return;
        }
        if (entity != this) {
            if (entity.dp() || !entity.valid || entity.s == null) {
                MinecraftServer.q.info("Blocking player " + this + " from spectating invalid entity " + entity);
                return;
            }
            if (this.ex()) {
                MinecraftServer.q.debug("Blocking frozen player " + this + " from spectating entity " + entity);
                return;
            }
        }
        this.cH = entity;
        if (entity != this) {
            this.bs();
            this.getBukkitEntity().teleport(new Location((World)entity.cA().getWorld(), entity.dc(), entity.de(), entity.di(), this.dn(), this.do()), PlayerTeleportEvent.TeleportCause.SPECTATE);
            PlayerChunkMap.EntityTracker tracker = (PlayerChunkMap.EntityTracker)((WorldServer)entity.s).k().a.J.get(entity.ae());
            if (tracker != null) {
                tracker.b(this);
            }
        } else {
            this.b.teleport(this.cH.dc(), this.cH.de(), this.cH.di(), this.dn(), this.do(), PlayerTeleportEvent.TeleportCause.SPECTATE);
        }
        this.b.a(new PacketPlayOutCamera(entity));
    }

    @Override
    protected void H() {
        if (!this.cI) {
            super.H();
        }
    }

    @Override
    public void d(net.minecraft.world.entity.Entity target) {
        if (this.d.b() == EnumGamemode.d) {
            this.c(target);
        } else {
            super.d(target);
        }
    }

    public long I() {
        return this.cG;
    }

    @Nullable
    public IChatBaseComponent J() {
        return this.listName;
    }

    @Override
    public void a(EnumHand hand) {
        super.a(hand);
        this.fK();
    }

    public boolean K() {
        return this.cI;
    }

    public void L() {
        this.cI = false;
    }

    public AdvancementDataPlayer M() {
        return this.cr;
    }

    public void a(WorldServer targetWorld, double x2, double y2, double z2, float yaw, float pitch) {
        this.teleportTo(targetWorld, x2, y2, z2, yaw, pitch, PlayerTeleportEvent.TeleportCause.UNKNOWN);
    }

    public void teleportTo(WorldServer worldserver, double d0, double d1, double d2, float f2, float f1, PlayerTeleportEvent.TeleportCause cause) {
        this.c((net.minecraft.world.entity.Entity)this);
        this.p();
        this.getBukkitEntity().teleport(new Location((World)worldserver.getWorld(), d0, d1, d2, f2, f1), cause);
    }

    @Nullable
    public BlockPosition N() {
        return this.cT;
    }

    public float O() {
        return this.cV;
    }

    public ResourceKey<net.minecraft.world.level.World> P() {
        return this.cS;
    }

    public boolean Q() {
        return this.cU;
    }

    @Deprecated
    public void a(ResourceKey<net.minecraft.world.level.World> dimension, @Nullable BlockPosition pos, float angle, boolean forced, boolean sendMessage) {
        this.setRespawnPosition(dimension, pos, angle, forced, sendMessage, PlayerSetSpawnEvent.Cause.UNKNOWN);
    }

    public void setRespawnPosition(ResourceKey<net.minecraft.world.level.World> dimension, @Nullable BlockPosition pos, float angle, boolean forced, boolean sendMessage, PlayerSetSpawnEvent.Cause cause) {
        PlayerSetSpawnEvent event;
        Location spawnLoc = null;
        boolean willNotify = false;
        if (pos != null) {
            boolean flag2 = pos.equals(this.cT) && dimension.equals(this.cS);
            spawnLoc = MCUtil.toLocation(this.cB().a(dimension), pos);
            spawnLoc.setYaw(angle);
            willNotify = sendMessage && !flag2;
        }
        if (!(event = new PlayerSetSpawnEvent((Player)this.getBukkitEntity(), cause, spawnLoc, forced, willNotify, (Component)(willNotify ? Component.translatable((String)"block.minecraft.set_spawn") : null))).callEvent()) {
            return;
        }
        if (event.getLocation() != null) {
            dimension = event.getLocation().getWorld() != null ? ((CraftWorld)event.getLocation().getWorld()).getHandle().aa() : dimension;
            pos = MCUtil.toBlockPosition(event.getLocation());
            angle = event.getLocation().getYaw();
            forced = event.isForced();
            if (event.willNotifyPlayer() && event.getNotification() != null) {
                this.a(PaperAdventure.asVanilla(event.getNotification()), SystemUtils.c);
            }
            this.cT = pos;
            this.cS = dimension;
            this.cV = angle;
            this.cU = forced;
        } else {
            this.cT = null;
            this.cS = net.minecraft.world.level.World.e;
            this.cV = 0.0f;
            this.cU = false;
        }
    }

    public void a(ChunkCoordIntPair chunkPos, Packet<?> chunkDataPacket) {
        this.b.a(chunkDataPacket);
        if (PlayerChunkLoadEvent.getHandlerList().getRegisteredListeners().length > 0) {
            new PlayerChunkLoadEvent(this.getBukkitEntity().getWorld().getChunkAt(chunkPos.longKey), (Player)this.getBukkitEntity()).callEvent();
        }
    }

    public void a(ChunkCoordIntPair chunkPos) {
        if (this.bl()) {
            this.b.a(new PacketPlayOutUnloadChunk(chunkPos.c, chunkPos.d));
            if (PlayerChunkUnloadEvent.getHandlerList().getRegisteredListeners().length > 0) {
                new PlayerChunkUnloadEvent(this.getBukkitEntity().getWorld().getChunkAt(chunkPos.longKey), (Player)this.getBukkitEntity()).callEvent();
            }
        }
    }

    public SectionPosition R() {
        return this.cR;
    }

    public void a(SectionPosition section) {
        this.cR = section;
    }

    @Override
    public void a(SoundEffect event, SoundCategory category, float volume, float pitch) {
        this.b.a(new PacketPlayOutNamedSoundEffect(event, category, this.dc(), this.de(), this.di(), volume, pitch));
    }

    @Override
    public Packet<?> S() {
        return new PacketPlayOutNamedEntitySpawn(this);
    }

    @Override
    public EntityItem a(ItemStack stack, boolean throwRandomly, boolean retainOwnership) {
        EntityItem entityitem = super.a(stack, throwRandomly, retainOwnership);
        if (entityitem == null) {
            return null;
        }
        this.s.b(entityitem);
        ItemStack itemstack1 = entityitem.h();
        if (retainOwnership) {
            if (!itemstack1.b()) {
                this.a(StatisticList.f.b(itemstack1.c()), itemstack1.J());
            }
            this.a(StatisticList.F);
        }
        return entityitem;
    }

    public ITextFilter T() {
        return this.cW;
    }

    public void c(WorldServer world) {
        this.s = world;
        this.d.a(world);
    }

    @Nullable
    private static EnumGamemode a(@Nullable NBTTagCompound nbt, String key) {
        return nbt != null && nbt.b(key, 99) ? EnumGamemode.a(nbt.h(key)) : null;
    }

    private EnumGamemode b(@Nullable EnumGamemode backupGameMode) {
        EnumGamemode enumgamemode1 = this.c.aW();
        return enumgamemode1 != null ? enumgamemode1 : (backupGameMode != null ? backupGameMode : this.c.h_());
    }

    public void c(@Nullable NBTTagCompound nbt) {
        if (this.c.aW() != null && this.c.aW() != EntityPlayer.a(nbt, "playerGameType")) {
            if (new PlayerGameModeChangeEvent((Player)this.getBukkitEntity(), GameMode.getByValue((int)this.c.h_().a()), PlayerGameModeChangeEvent.Cause.DEFAULT_GAMEMODE, null).callEvent()) {
                this.d.a(this.c.aW(), EnumGamemode.e);
            } else {
                this.d.a(EntityPlayer.a(nbt, "playerGameType"), EntityPlayer.a(nbt, "previousPlayerGameType"));
            }
            return;
        }
        this.d.a(this.b(EntityPlayer.a(nbt, "playerGameType")), EntityPlayer.a(nbt, "previousPlayerGameType"));
    }

    private void k(NBTTagCompound nbt) {
        nbt.a("playerGameType", this.d.b().a());
        EnumGamemode enumgamemode = this.d.c();
        if (enumgamemode != null) {
            nbt.a("previousPlayerGameType", enumgamemode.a());
        }
    }

    public boolean U() {
        return this.cX;
    }

    public boolean b(EntityPlayer player) {
        return player == this ? false : this.cX || player.cX;
    }

    @Override
    public boolean a(net.minecraft.world.level.World world, BlockPosition pos) {
        return super.a(world, pos) && world.a(this, pos);
    }

    @Override
    protected void a(ItemStack stack) {
        CriterionTriggers.S.a(this, stack);
        super.a(stack);
    }

    public boolean a(boolean entireStack) {
        PlayerInventory playerinventory = this.fr();
        ItemStack itemstack = playerinventory.a(entireStack);
        this.bV.b(playerinventory, playerinventory.k).ifPresent(i2 -> this.bV.a(i2, playerinventory.f()));
        return this.a(itemstack, false, true) != null;
    }

    public boolean V() {
        return this.cY;
    }

    public long getPlayerTime() {
        if (this.relativeTime) {
            return this.s.V() + this.timeOffset;
        }
        return this.s.V() - this.s.V() % 24000L + this.timeOffset;
    }

    public WeatherType getPlayerWeather() {
        return this.weather;
    }

    public void setPlayerWeather(WeatherType type, boolean plugin) {
        if (!plugin && this.weather != null) {
            return;
        }
        if (plugin) {
            this.weather = type;
        }
        if (type == WeatherType.DOWNFALL) {
            this.b.a(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.c, 0.0f));
        } else {
            this.b.a(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.b, 0.0f));
        }
    }

    public void updateWeather(float oldRain, float newRain, float oldThunder, float newThunder) {
        if (this.weather == null) {
            if (oldRain != newRain) {
                this.b.a(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.h, newRain));
            }
        } else if (this.pluginRainPositionPrevious != this.pluginRainPosition) {
            this.b.a(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.h, this.pluginRainPosition));
        }
        if (oldThunder != newThunder) {
            if (this.weather == WeatherType.DOWNFALL || this.weather == null) {
                this.b.a(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.i, newThunder));
            } else {
                this.b.a(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.i, 0.0f));
            }
        }
    }

    public void tickWeather() {
        if (this.weather == null) {
            return;
        }
        this.pluginRainPositionPrevious = this.pluginRainPosition;
        this.pluginRainPosition = this.weather == WeatherType.DOWNFALL ? (float)((double)this.pluginRainPosition + 0.01) : (float)((double)this.pluginRainPosition - 0.01);
        this.pluginRainPosition = MathHelper.a(this.pluginRainPosition, 0.0f, 1.0f);
    }

    public void resetPlayerWeather() {
        this.weather = null;
        this.setPlayerWeather(this.s.n_().k() ? WeatherType.DOWNFALL : WeatherType.CLEAR, false);
    }

    @Override
    public String toString() {
        return super.toString() + "(" + this.co() + " at " + this.dc() + "," + this.de() + "," + this.di() + ")";
    }

    public void forceSetPositionRotation(double x2, double y2, double z2, float yaw, float pitch) {
        this.b(x2, y2, z2, yaw, pitch);
        this.b.d();
    }

    @Override
    public boolean ex() {
        return super.ex() || this.b != null && this.b.isDisconnected();
    }

    @Override
    public Scoreboard fF() {
        return this.getBukkitEntity().getScoreboard().getHandle();
    }

    public void reset() {
        float exp = 0.0f;
        boolean keepInventory = this.s.W().b(GameRules.d);
        if (this.keepLevel) {
            exp = this.ck;
            this.newTotalExp = this.cj;
            this.newLevel = this.ci;
        }
        this.c(this.em());
        this.eS();
        this.i(this.bX());
        ((net.minecraft.world.entity.Entity)this).aF = 0;
        this.L = 0.0f;
        this.bW = new FoodMetaData(this);
        this.ci = this.newLevel;
        this.cj = this.newTotalExp;
        this.ck = 0.0f;
        this.aN = 0;
        this.setArrowCount(0, true);
        this.removeAllEffects(EntityPotionEffectEvent.Cause.DEATH);
        ((EntityLiving)this).bW = true;
        this.bV = this.bU;
        this.bc = null;
        ((EntityLiving)this).bX = null;
        ((EntityLiving)this).bR = new CombatTracker(this);
        this.cC = -1;
        if (this.keepLevel) {
            this.ck = exp;
        } else {
            this.d(this.newExp);
        }
        this.keepLevel = false;
    }

    @Override
    public CraftPlayer getBukkitEntity() {
        return (CraftPlayer)super.getBukkitEntity();
    }

    public final int getViewDistance() {
        throw new UnsupportedOperationException("Use PlayerChunkLoader");
    }
}

