/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import co.aikar.timings.MinecraftTimings;
import co.aikar.timings.Timing;
import com.destroystokyo.paper.event.entity.PlayerNaturallySpawnCreaturesEvent;
import com.destroystokyo.paper.io.SyncLoadFinder;
import com.destroystokyo.paper.io.chunk.ChunkTaskManager;
import com.destroystokyo.paper.util.concurrent.WeakSeqLock;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import io.papermc.paper.util.CoordinateUtils;
import io.papermc.paper.util.maplist.IteratorSafeOrderedReferenceSet;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.SectionPosition;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.MCUtil;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkMapDistance;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.LightEngineThreaded;
import net.minecraft.server.level.PlayerChunk;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.level.progress.WorldLoadListener;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.util.MathHelper;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.thread.IAsyncTaskHandler;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.LocalMobCapCalculator;
import net.minecraft.world.level.SpawnerCreature;
import net.minecraft.world.level.World;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.IChunkProvider;
import net.minecraft.world.level.chunk.ProtoChunkExtension;
import net.minecraft.world.level.chunk.storage.ChunkScanAccess;
import net.minecraft.world.level.entity.ChunkStatusUpdateListener;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureManager;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.level.storage.WorldPersistentData;
import org.bukkit.entity.Player;
import org.bukkit.entity.SpawnCategory;
import org.slf4j.Logger;

public class ChunkProviderServer
extends IChunkProvider {
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final List<ChunkStatus> b = ChunkStatus.a();
    private final ChunkMapDistance c;
    final WorldServer d;
    public final Thread e;
    final LightEngineThreaded f;
    public final b g;
    public final PlayerChunkMap a;
    private final WorldPersistentData h;
    private long i;
    public boolean j = true;
    public boolean k = true;
    private static final int l = 4;
    private final long[] m = new long[4];
    private final ChunkStatus[] n = new ChunkStatus[4];
    private final IChunkAccess[] o = new IChunkAccess[4];
    @Nullable
    @VisibleForDebug
    private SpawnerCreature.d p;
    final WeakSeqLock loadedChunkMapSeqLock = new WeakSeqLock();
    final Long2ObjectOpenHashMap<Chunk> loadedChunkMap = new Long2ObjectOpenHashMap(8192, 0.5f);
    private final Chunk[] lastLoadedChunks = new Chunk[16];
    long chunkFutureAwaitCounter;
    final IteratorSafeOrderedReferenceSet<Chunk> tickingChunks = new IteratorSafeOrderedReferenceSet(4096, 0.75f, 4096, 0.15, true);
    final IteratorSafeOrderedReferenceSet<Chunk> entityTickingChunks = new IteratorSafeOrderedReferenceSet(4096, 0.75f, 4096, 0.15, true);
    private long asyncLoadSeqCounter;
    private long syncLoadCounter;

    private static int getChunkCacheKey(int x2, int z2) {
        return x2 & 3 | (z2 & 3) << 2;
    }

    public void addLoadedChunk(Chunk chunk) {
        this.loadedChunkMapSeqLock.acquireWrite();
        try {
            this.loadedChunkMap.put(chunk.coordinateKey, (Object)chunk);
        }
        finally {
            this.loadedChunkMapSeqLock.releaseWrite();
        }
        int cacheKey = ChunkProviderServer.getChunkCacheKey(chunk.locX, chunk.locZ);
        this.lastLoadedChunks[cacheKey] = chunk;
    }

    public void removeLoadedChunk(Chunk chunk) {
        this.loadedChunkMapSeqLock.acquireWrite();
        try {
            this.loadedChunkMap.remove(chunk.coordinateKey);
        }
        finally {
            this.loadedChunkMapSeqLock.releaseWrite();
        }
        int cacheKey = ChunkProviderServer.getChunkCacheKey(chunk.locX, chunk.locZ);
        Chunk cachedChunk = this.lastLoadedChunks[cacheKey];
        if (cachedChunk != null && cachedChunk.coordinateKey == chunk.coordinateKey) {
            this.lastLoadedChunks[cacheKey] = null;
        }
    }

    public final Chunk getChunkAtIfLoadedMainThread(int x2, int z2) {
        int cacheKey = ChunkProviderServer.getChunkCacheKey(x2, z2);
        Chunk cachedChunk = this.lastLoadedChunks[cacheKey];
        if (cachedChunk != null && cachedChunk.locX == x2 & cachedChunk.locZ == z2) {
            return this.lastLoadedChunks[cacheKey];
        }
        long chunkKey = ChunkCoordIntPair.a(x2, z2);
        this.lastLoadedChunks[cacheKey] = cachedChunk = (Chunk)this.loadedChunkMap.get(chunkKey);
        return cachedChunk;
    }

    public final Chunk getChunkAtIfLoadedMainThreadNoCache(int x2, int z2) {
        return (Chunk)this.loadedChunkMap.get(ChunkCoordIntPair.a(x2, z2));
    }

    public final Chunk getChunkAtMainThread(int x2, int z2) {
        Chunk ret = this.getChunkAtIfLoadedMainThread(x2, z2);
        if (ret != null) {
            return ret;
        }
        return (Chunk)this.a(x2, z2, ChunkStatus.o, true);
    }

    public void getEntityTickingChunkAsync(int x2, int z2, Consumer<Chunk> onLoad) {
        if (Thread.currentThread() != this.e) {
            this.g.execute(() -> this.getEntityTickingChunkAsync(x2, z2, onLoad));
            return;
        }
        this.getChunkFutureAsynchronously(x2, z2, 31, PlayerChunk::b, onLoad);
    }

    public void getTickingChunkAsync(int x2, int z2, Consumer<Chunk> onLoad) {
        if (Thread.currentThread() != this.e) {
            this.g.execute(() -> this.getTickingChunkAsync(x2, z2, onLoad));
            return;
        }
        this.getChunkFutureAsynchronously(x2, z2, 32, PlayerChunk::a, onLoad);
    }

    public void getFullChunkAsync(int x2, int z2, Consumer<Chunk> onLoad) {
        if (Thread.currentThread() != this.e) {
            this.g.execute(() -> this.getFullChunkAsync(x2, z2, onLoad));
            return;
        }
        this.getChunkFutureAsynchronously(x2, z2, 33, PlayerChunk::c, onLoad);
    }

    private void getChunkFutureAsynchronously(int x2, int z2, int ticketLevel, Function<PlayerChunk, CompletableFuture<Either<Chunk, PlayerChunk.Failure>>> futureGet, Consumer<Chunk> onLoad) {
        if (Thread.currentThread() != this.e) {
            throw new IllegalStateException();
        }
        ChunkCoordIntPair chunkPos = new ChunkCoordIntPair(x2, z2);
        Long identifier = this.chunkFutureAwaitCounter++;
        this.c.a(TicketType.FUTURE_AWAIT, chunkPos, ticketLevel, identifier);
        this.q();
        PlayerChunk chunk = this.a.a(chunkPos.a());
        if (chunk == null) {
            throw new IllegalStateException("Expected playerchunk " + chunkPos + " in world '" + this.d.getWorld().getName() + "'");
        }
        CompletableFuture<Either<Chunk, PlayerChunk.Failure>> future = futureGet.apply(chunk);
        future.whenCompleteAsync((either, throwable) -> {
            try {
                if (throwable != null) {
                    if (throwable instanceof ThreadDeath) {
                        throw (ThreadDeath)throwable;
                    }
                    MinecraftServer.q.error("Failed to complete future await for chunk " + chunkPos.toString() + " in world '" + this.d.getWorld().getName() + "'", throwable);
                } else if (either.right().isPresent()) {
                    MinecraftServer.q.error("Failed to complete future await for chunk " + chunkPos.toString() + " in world '" + this.d.getWorld().getName() + "': " + ((PlayerChunk.Failure)either.right().get()).toString());
                }
                try {
                    if (onLoad != null) {
                        onLoad.accept(either == null ? null : (Chunk)either.left().orElse(null));
                    }
                }
                catch (Throwable thr) {
                    if (thr instanceof ThreadDeath) {
                        throw (ThreadDeath)thr;
                    }
                    MinecraftServer.q.error("Load callback for future await failed " + chunkPos.toString() + " in world '" + this.d.getWorld().getName() + "'", thr);
                    this.c.a(TicketType.h, chunkPos, ticketLevel, chunkPos);
                    this.c.b(TicketType.FUTURE_AWAIT, chunkPos, ticketLevel, identifier);
                    return;
                }
            }
            finally {
                this.c.a(TicketType.h, chunkPos, ticketLevel, chunkPos);
                this.c.b(TicketType.FUTURE_AWAIT, chunkPos, ticketLevel, identifier);
            }
        }, (Executor)this.g);
    }

    @Nullable
    public IChunkAccess getChunkAtImmediately(int x2, int z2) {
        PlayerChunk holder = this.a.b(ChunkCoordIntPair.a(x2, z2));
        if (holder == null) {
            return null;
        }
        return holder.g();
    }

    public final IChunkAccess getFullStatusChunkAt(int chunkX, int chunkZ) {
        Chunk ifLoaded = this.getChunkAtIfLoadedImmediately(chunkX, chunkZ);
        if (ifLoaded != null) {
            return ifLoaded;
        }
        IChunkAccess empty = this.a(chunkX, chunkZ, ChunkStatus.c, true);
        if (empty != null && empty.j().b(ChunkStatus.o)) {
            return empty;
        }
        return this.a(chunkX, chunkZ, ChunkStatus.o, true);
    }

    public final IChunkAccess getFullStatusChunkAtIfLoaded(int chunkX, int chunkZ) {
        Chunk ifLoaded = this.getChunkAtIfLoadedImmediately(chunkX, chunkZ);
        if (ifLoaded != null) {
            return ifLoaded;
        }
        IChunkAccess ret = this.getChunkAtImmediately(chunkX, chunkZ);
        if (ret != null && ret.j().b(ChunkStatus.o)) {
            return ret;
        }
        return null;
    }

    void getChunkAtAsynchronously(int chunkX, int chunkZ, int ticketLevel, Consumer<IChunkAccess> consumer) {
        this.getChunkAtAsynchronously(chunkX, chunkZ, ticketLevel, chunkHolder -> {
            if (ticketLevel <= 33) {
                return chunkHolder.c();
            }
            return chunkHolder.a(PlayerChunk.b(ticketLevel), this.a);
        }, consumer);
    }

    void getChunkAtAsynchronously(int chunkX, int chunkZ, int ticketLevel, Function<PlayerChunk, CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>>> function, Consumer<IChunkAccess> consumer) {
        if (Thread.currentThread() != this.e) {
            throw new IllegalStateException();
        }
        ChunkCoordIntPair chunkPos = new ChunkCoordIntPair(chunkX, chunkZ);
        Long identifier = this.chunkFutureAwaitCounter++;
        this.addTicketAtLevel(TicketType.FUTURE_AWAIT, chunkPos, ticketLevel, identifier);
        this.q();
        PlayerChunk chunk = this.a.a(chunkPos.a());
        if (chunk == null) {
            throw new IllegalStateException("Expected playerchunk " + chunkPos + " in world '" + this.d.getWorld().getName() + "'");
        }
        CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>> future = function.apply(chunk);
        future.whenCompleteAsync((either, throwable) -> {
            try {
                if (throwable != null) {
                    if (throwable instanceof ThreadDeath) {
                        throw (ThreadDeath)throwable;
                    }
                    LOGGER.error("Failed to complete future await for chunk " + chunkPos.toString() + " in world '" + this.d.getWorld().getName() + "'", throwable);
                } else if (either.right().isPresent()) {
                    LOGGER.error("Failed to complete future await for chunk " + chunkPos.toString() + " in world '" + this.d.getWorld().getName() + "': " + ((PlayerChunk.Failure)either.right().get()).toString());
                }
                try {
                    if (consumer != null) {
                        consumer.accept(either == null ? null : (IChunkAccess)either.left().orElse(null));
                    }
                }
                catch (Throwable thr) {
                    if (thr instanceof ThreadDeath) {
                        throw (ThreadDeath)thr;
                    }
                    LOGGER.error("Load callback for future await failed " + chunkPos.toString() + " in world '" + this.d.getWorld().getName() + "'", thr);
                    this.addTicketAtLevel(TicketType.h, chunkPos, ticketLevel, chunkPos);
                    this.removeTicketAtLevel(TicketType.FUTURE_AWAIT, chunkPos, ticketLevel, identifier);
                    return;
                }
            }
            finally {
                this.addTicketAtLevel(TicketType.h, chunkPos, ticketLevel, chunkPos);
                this.removeTicketAtLevel(TicketType.FUTURE_AWAIT, chunkPos, ticketLevel, identifier);
            }
        }, (Executor)this.g);
    }

    public <T> void addTicketAtLevel(TicketType<T> ticketType, ChunkCoordIntPair chunkPos, int ticketLevel, T identifier) {
        this.c.a(ticketType, chunkPos, ticketLevel, identifier);
    }

    public <T> void removeTicketAtLevel(TicketType<T> ticketType, ChunkCoordIntPair chunkPos, int ticketLevel, T identifier) {
        this.c.b(ticketType, chunkPos, ticketLevel, identifier);
    }

    void chunkLoadAccept(int chunkX, int chunkZ, IChunkAccess chunk, Consumer<IChunkAccess> consumer) {
        try {
            consumer.accept(chunk);
        }
        catch (Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            LOGGER.error("Load callback for chunk " + chunkX + "," + chunkZ + " in world '" + this.d.getWorld().getName() + "' threw an exception", throwable);
        }
    }

    public final void getChunkAtAsynchronously(int chunkX, int chunkZ, ChunkStatus status, boolean gen, boolean allowSubTicketLevel, Consumer<IChunkAccess> onLoad) {
        int chunkStatusTicketLevel = 33 + ChunkStatus.a(status);
        PlayerChunk playerChunk = this.a.a(CoordinateUtils.getChunkKey(chunkX, chunkZ));
        if (playerChunk != null) {
            ChunkStatus holderStatus = playerChunk.getChunkHolderStatus();
            IChunkAccess immediate = playerChunk.getAvailableChunkNow();
            if (immediate != null) {
                if (allowSubTicketLevel ? immediate.j().b(status) : playerChunk.k() <= chunkStatusTicketLevel && holderStatus != null && holderStatus.b(status)) {
                    this.chunkLoadAccept(chunkX, chunkZ, immediate, onLoad);
                    return;
                }
                if (gen || !allowSubTicketLevel && immediate.j().b(status)) {
                    this.getChunkAtAsynchronously(chunkX, chunkZ, chunkStatusTicketLevel, onLoad);
                    return;
                }
                this.chunkLoadAccept(chunkX, chunkZ, null, onLoad);
                return;
            }
        }
        if (gen && !allowSubTicketLevel) {
            this.getChunkAtAsynchronously(chunkX, chunkZ, chunkStatusTicketLevel, onLoad);
            return;
        }
        this.getChunkAtAsynchronously(chunkX, chunkZ, MCUtil.getTicketLevelFor(ChunkStatus.c), chunk -> {
            if (chunk == null) {
                throw new IllegalStateException("Chunk cannot be null");
            }
            if (!chunk.j().b(status)) {
                if (gen) {
                    this.getChunkAtAsynchronously(chunkX, chunkZ, chunkStatusTicketLevel, onLoad);
                    return;
                }
                this.chunkLoadAccept(chunkX, chunkZ, null, onLoad);
                return;
            }
            if (allowSubTicketLevel) {
                this.chunkLoadAccept(chunkX, chunkZ, (IChunkAccess)chunk, onLoad);
                return;
            }
            this.getChunkAtAsynchronously(chunkX, chunkZ, chunkStatusTicketLevel, onLoad);
        });
    }

    public ChunkProviderServer(WorldServer world, Convertable.ConversionSession session, DataFixer dataFixer, DefinedStructureManager structureManager, Executor workerExecutor, ChunkGenerator chunkGenerator, int viewDistance, int simulationDistance, boolean dsync, WorldLoadListener worldGenerationProgressListener, ChunkStatusUpdateListener chunkStatusChangeListener, Supplier<WorldPersistentData> persistentStateManagerFactory) {
        this.d = world;
        this.g = new b(world);
        this.e = Thread.currentThread();
        File file = session.a(world.aa()).resolve("data").toFile();
        file.mkdirs();
        this.h = new WorldPersistentData(file, dataFixer);
        this.a = new PlayerChunkMap(world, session, dataFixer, structureManager, workerExecutor, this.g, this, chunkGenerator, worldGenerationProgressListener, chunkStatusChangeListener, persistentStateManagerFactory, viewDistance, dsync);
        this.f = this.a.c();
        this.c = this.a.h();
        this.c.b(simulationDistance);
        this.p();
    }

    public boolean isChunkLoaded(int chunkX, int chunkZ) {
        PlayerChunk chunk = this.a.a(ChunkCoordIntPair.a(chunkX, chunkZ));
        if (chunk == null) {
            return false;
        }
        return chunk.e() != null;
    }

    public Chunk getChunkUnchecked(int chunkX, int chunkZ) {
        PlayerChunk chunk = this.a.a(ChunkCoordIntPair.a(chunkX, chunkZ));
        if (chunk == null) {
            return null;
        }
        return chunk.e();
    }

    public LightEngineThreaded a() {
        return this.f;
    }

    @Nullable
    private PlayerChunk b(long pos) {
        return this.a.b(pos);
    }

    public int b() {
        return this.a.f();
    }

    private void a(long pos, IChunkAccess chunk, ChunkStatus status) {
        for (int j2 = 3; j2 > 0; --j2) {
            this.m[j2] = this.m[j2 - 1];
            this.n[j2] = this.n[j2 - 1];
            this.o[j2] = this.o[j2 - 1];
        }
        this.m[0] = pos;
        this.n[0] = status;
        this.o[0] = chunk;
    }

    @Nullable
    public Chunk getChunkAtIfCachedImmediately(int x2, int z2) {
        long k2 = ChunkCoordIntPair.a(x2, z2);
        PlayerChunk playerChunk = this.b(k2);
        if (playerChunk == null) {
            return null;
        }
        return playerChunk.getFullChunkUnchecked();
    }

    @Nullable
    public Chunk getChunkAtIfLoadedImmediately(int x2, int z2) {
        long readlock;
        long k2 = ChunkCoordIntPair.a(x2, z2);
        if (Thread.currentThread() == this.e) {
            return this.getChunkAtIfLoadedMainThread(x2, z2);
        }
        Chunk ret = null;
        do {
            readlock = this.loadedChunkMapSeqLock.acquireRead();
            try {
                ret = (Chunk)this.loadedChunkMap.get(k2);
            }
            catch (Throwable thr) {
                if (!(thr instanceof ThreadDeath)) continue;
                throw (ThreadDeath)thr;
            }
        } while (!this.loadedChunkMapSeqLock.tryReleaseRead(readlock));
        return ret;
    }

    public CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>> getChunkAtAsynchronously(int x2, int z2, boolean gen, boolean isUrgent) {
        if (Thread.currentThread() != this.e) {
            CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>> future = new CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>>();
            this.g.execute(() -> this.getChunkAtAsynchronously(x2, z2, gen, isUrgent).whenComplete((chunk, ex) -> {
                if (ex != null) {
                    future.completeExceptionally((Throwable)ex);
                } else {
                    future.complete((Either<IChunkAccess, PlayerChunk.Failure>)chunk);
                }
            }));
            return future;
        }
        long k2 = ChunkCoordIntPair.a(x2, z2);
        ChunkCoordIntPair chunkPos = new ChunkCoordIntPair(x2, z2);
        for (int l2 = 0; l2 < 4; ++l2) {
            IChunkAccess ichunkaccess;
            if (k2 != this.m[l2] || ChunkStatus.o != this.n[l2] || (ichunkaccess = this.o[l2]) == null) continue;
            for (int i1 = 3; i1 > 0; --i1) {
                this.m[i1] = this.m[i1 - 1];
                this.n[i1] = this.n[i1 - 1];
                this.o[i1] = this.o[i1 - 1];
            }
            this.m[0] = k2;
            this.n[0] = ChunkStatus.o;
            this.o[0] = ichunkaccess;
            return CompletableFuture.completedFuture(Either.left(ichunkaccess));
        }
        if (gen) {
            return this.bringToFullStatusAsync(x2, z2, chunkPos, isUrgent);
        }
        IChunkAccess current = this.getChunkAtImmediately(x2, z2);
        if (current != null) {
            if (!(current instanceof ProtoChunkExtension) && !(current instanceof Chunk)) {
                return CompletableFuture.completedFuture(PlayerChunk.a);
            }
            return this.bringToFullStatusAsync(x2, z2, chunkPos, isUrgent);
        }
        return this.bringToStatusAsync(x2, z2, chunkPos, ChunkStatus.c, isUrgent).thenCompose(either -> {
            IChunkAccess chunk = either.left().orElse(null);
            if (!(chunk instanceof ProtoChunkExtension) && !(chunk instanceof Chunk)) {
                return CompletableFuture.completedFuture(PlayerChunk.a);
            }
            return this.bringToFullStatusAsync(x2, z2, chunkPos, isUrgent);
        });
    }

    private CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>> bringToFullStatusAsync(int x2, int z2, ChunkCoordIntPair chunkPos, boolean isUrgent) {
        return this.bringToStatusAsync(x2, z2, chunkPos, ChunkStatus.o, isUrgent);
    }

    private CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>> bringToStatusAsync(int x2, int z2, ChunkCoordIntPair chunkPos, ChunkStatus status, boolean isUrgent) {
        CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>> future = this.getChunkFutureMainThread(x2, z2, status, true, isUrgent);
        Long identifier = this.asyncLoadSeqCounter++;
        int ticketLevel = MCUtil.getTicketLevelFor(status);
        this.addTicketAtLevel(TicketType.ASYNC_LOAD, chunkPos, ticketLevel, identifier);
        return future.thenComposeAsync(either -> {
            this.removeTicketAtLevel(TicketType.ASYNC_LOAD, chunkPos, ticketLevel, identifier);
            this.addTicketAtLevel(TicketType.h, chunkPos, ticketLevel, chunkPos);
            Optional failure = either.right();
            if (failure.isPresent()) {
                throw new IllegalStateException("Chunk failed to load: " + ((PlayerChunk.Failure)failure.get()).toString());
            }
            return CompletableFuture.completedFuture(either);
        }, (Executor)this.g);
    }

    public boolean markUrgent(ChunkCoordIntPair coords) {
        return this.c.markUrgent(coords);
    }

    public boolean markHighPriority(ChunkCoordIntPair coords, int priority) {
        return this.c.markHighPriority(coords, priority);
    }

    public void markAreaHighPriority(ChunkCoordIntPair center, int priority, int radius) {
        this.c.markAreaHighPriority(center, priority, radius);
    }

    public void clearAreaPriorityTickets(ChunkCoordIntPair center, int radius) {
        this.c.clearAreaPriorityTickets(center, radius);
    }

    public void clearPriorityTickets(ChunkCoordIntPair coords) {
        this.c.clearPriorityTickets(coords);
    }

    @Override
    @Nullable
    public IChunkAccess a(int x2, int z2, ChunkStatus leastStatus, boolean create) {
        IChunkAccess ichunkaccess;
        int x1 = x2;
        int z1 = z2;
        if (Thread.currentThread() != this.e) {
            return CompletableFuture.supplyAsync(() -> this.a(x2, z2, leastStatus, create), this.g).join();
        }
        Chunk ifLoaded = this.getChunkAtIfLoadedMainThread(x2, z2);
        if (ifLoaded != null) {
            return ifLoaded;
        }
        GameProfilerFiller gameprofilerfiller = this.d.ab();
        gameprofilerfiller.d("getChunk");
        long k2 = ChunkCoordIntPair.a(x2, z2);
        for (int l2 = 0; l2 < 4; ++l2) {
            if (k2 != this.m[l2] || leastStatus != this.n[l2] || (ichunkaccess = this.o[l2]) == null) continue;
            return ichunkaccess;
        }
        gameprofilerfiller.d("getChunkCacheMiss");
        CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>> completablefuture = this.getChunkFutureMainThread(x2, z2, leastStatus, create, true);
        b chunkproviderserver_b = this.g;
        Objects.requireNonNull(completablefuture);
        if (!completablefuture.isDone()) {
            ChunkCoordIntPair pair = new ChunkCoordIntPair(x1, z1);
            this.c.markUrgent(pair);
            this.d.asyncChunkTaskManager.raisePriority(x1, z1, 0);
            ChunkTaskManager.pushChunkWait(this.d, x1, z1);
            SyncLoadFinder.logSyncLoad(this.d, x1, z1);
            this.d.timings.syncChunkLoad.startTiming();
            chunkproviderserver_b.c(completablefuture::isDone);
            ChunkTaskManager.popChunkWait();
            this.d.timings.syncChunkLoad.stopTiming();
            this.c.clearPriorityTickets(pair);
            this.c.clearUrgent(pair);
        }
        ichunkaccess = (IChunkAccess)completablefuture.join().map(ichunkaccess1 -> ichunkaccess1, playerchunk_failure -> {
            if (create) {
                throw SystemUtils.c(new IllegalStateException("Chunk not there when requested: " + playerchunk_failure));
            }
            return null;
        });
        this.a(k2, ichunkaccess, leastStatus);
        return ichunkaccess;
    }

    @Override
    @Nullable
    public Chunk a(int chunkX, int chunkZ) {
        if (Thread.currentThread() != this.e) {
            return null;
        }
        return this.getChunkAtIfLoadedMainThread(chunkX, chunkZ);
    }

    private void p() {
        Arrays.fill(this.m, ChunkCoordIntPair.a);
        Arrays.fill(this.n, null);
        Arrays.fill(this.o, null);
    }

    public CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>> b(int chunkX, int chunkZ, ChunkStatus leastStatus, boolean create) {
        CompletionStage<Either<IChunkAccess, PlayerChunk.Failure>> completablefuture;
        boolean flag1;
        boolean bl = flag1 = Thread.currentThread() == this.e;
        if (flag1) {
            completablefuture = this.c(chunkX, chunkZ, leastStatus, create);
            b chunkproviderserver_b = this.g;
            Objects.requireNonNull(completablefuture);
            chunkproviderserver_b.c(() -> completablefuture.isDone());
        } else {
            completablefuture = CompletableFuture.supplyAsync(() -> this.c(chunkX, chunkZ, leastStatus, create), this.g).thenCompose(completablefuture1 -> completablefuture1);
        }
        return completablefuture;
    }

    private CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>> c(int chunkX, int chunkZ, ChunkStatus leastStatus, boolean create) {
        return this.getChunkFutureMainThread(chunkX, chunkZ, leastStatus, create, false);
    }

    private CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>> getChunkFutureMainThread(int chunkX, int chunkZ, ChunkStatus leastStatus, boolean create, boolean isUrgent) {
        CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>> future;
        Long identifier;
        ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(chunkX, chunkZ);
        long k2 = chunkcoordintpair.a();
        int l2 = 33 + ChunkStatus.a(leastStatus);
        PlayerChunk playerchunk = this.b(k2);
        boolean currentlyUnloading = false;
        if (playerchunk != null) {
            PlayerChunk.State oldChunkState = PlayerChunk.c(playerchunk.p);
            PlayerChunk.State currentChunkState = PlayerChunk.c(playerchunk.k());
            boolean bl = currentlyUnloading = oldChunkState.a(PlayerChunk.State.b) && !currentChunkState.a(PlayerChunk.State.b);
        }
        if (create && !currentlyUnloading) {
            this.c.a(TicketType.h, chunkcoordintpair, l2, chunkcoordintpair);
            identifier = this.syncLoadCounter++;
            this.c.a(TicketType.REQUIRED_LOAD, chunkcoordintpair, l2, identifier);
            if (isUrgent) {
                this.c.markUrgent(chunkcoordintpair);
            }
            if (this.a(playerchunk, l2)) {
                GameProfilerFiller gameprofilerfiller = this.d.ab();
                gameprofilerfiller.a("chunkLoad");
                this.c.delayDistanceManagerTick = false;
                this.q();
                playerchunk = this.b(k2);
                gameprofilerfiller.c();
                if (this.a(playerchunk, l2)) {
                    this.c.b(TicketType.REQUIRED_LOAD, chunkcoordintpair, l2, identifier);
                    throw SystemUtils.c(new IllegalStateException("No chunk holder after ticket has been added"));
                }
            }
        } else {
            identifier = null;
        }
        CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>> completableFuture = future = this.a(playerchunk, l2) ? PlayerChunk.b : playerchunk.a(leastStatus, this.a);
        if (create && !currentlyUnloading) {
            future.thenAcceptAsync(either -> this.c.b(TicketType.REQUIRED_LOAD, chunkcoordintpair, l2, identifier), (Executor)this.g);
        }
        if (isUrgent) {
            future.thenAccept(either -> this.c.clearUrgent(chunkcoordintpair));
        }
        return future;
    }

    private boolean a(@Nullable PlayerChunk holder, int maxLevel) {
        return holder == null || holder.p > maxLevel;
    }

    @Override
    public boolean b(int x2, int z2) {
        int k2;
        PlayerChunk playerchunk = this.b(new ChunkCoordIntPair(x2, z2).a());
        return !this.a(playerchunk, k2 = 33 + ChunkStatus.a(ChunkStatus.o));
    }

    @Override
    public IBlockAccess c(int chunkX, int chunkZ) {
        long k2 = ChunkCoordIntPair.a(chunkX, chunkZ);
        PlayerChunk playerchunk = this.b(k2);
        if (playerchunk == null) {
            return null;
        }
        int l2 = b.size() - 1;
        ChunkStatus chunkstatus;
        Optional<IChunkAccess> optional;
        while (!(optional = playerchunk.a(chunkstatus = b.get(l2)).getNow(PlayerChunk.a).left()).isPresent()) {
            if (chunkstatus == ChunkStatus.l.e()) {
                return null;
            }
            --l2;
        }
        return optional.get();
    }

    public World c() {
        return this.d;
    }

    public boolean d() {
        return this.g.y();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean q() {
        if (this.c.delayDistanceManagerTick) {
            return false;
        }
        if (this.a.unloadingPlayerChunk) {
            LOGGER.error("Cannot tick distance manager while unloading playerchunks", new Throwable());
            throw new IllegalStateException("Cannot tick distance manager while unloading playerchunks");
        }
        MinecraftTimings.distanceManagerTick.startTiming();
        try {
            boolean flag = this.c.a(this.a);
            boolean flag1 = this.a.e();
            if (!flag && !flag1) {
                boolean bl = false;
                return bl;
            }
            this.p();
            boolean bl = true;
            return bl;
        }
        finally {
            MinecraftTimings.distanceManagerTick.stopTiming();
        }
    }

    public boolean isPositionTicking(Entity entity) {
        return this.a(ChunkCoordIntPair.a(MathHelper.b(entity.dc()) >> 4, MathHelper.b(entity.di()) >> 4));
    }

    public boolean a(long pos) {
        PlayerChunk holder = this.a.b(pos);
        return holder != null && holder.isTickingReady();
    }

    public void a(boolean flush) {
        this.q();
        try (Timing timed = this.d.timings.chunkSaveData.startTiming();){
            this.a.a(flush);
        }
    }

    public void saveIncrementally() {
        this.q();
        try (Timing timed = this.d.timings.chunkSaveData.startTiming();){
            this.a.saveIncrementally();
        }
    }

    @Override
    public void close() throws IOException {
        this.close(true);
    }

    public void close(boolean save) throws IOException {
        if (save) {
            this.a(true);
        }
        this.f.close();
        this.a.close();
    }

    public void purgeUnload() {
    }

    @Override
    public void a(BooleanSupplier shouldKeepTicking, boolean tickChunks) {
        this.d.ab().a("purge");
        this.d.timings.doChunkMap.startTiming();
        this.c.a();
        this.q();
        this.d.timings.doChunkMap.stopTiming();
        this.d.ab().b("chunks");
        if (tickChunks) {
            this.d.timings.chunks.startTiming();
            this.a.playerChunkManager.tick();
            this.r();
            this.d.timings.chunks.stopTiming();
        }
        this.d.timings.doChunkUnload.startTiming();
        this.d.ab().b("unload");
        this.a.a(shouldKeepTicking);
        this.d.timings.doChunkUnload.stopTiming();
        this.d.ab().c();
        this.p();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void r() {
        long i2 = this.d.U();
        long j2 = i2 - this.i;
        this.i = i2;
        boolean flag = this.d.ad();
        if (flag) {
            this.a.j();
        } else {
            Iterator<Chunk> iterator1;
            boolean flag2;
            SpawnerCreature.d spawnercreature_d;
            PlayerChunkMap playerChunkMap = this.a;
            for (EntityPlayer player : this.d.J) {
                if (!player.affectsSpawning || player.B_()) {
                    playerChunkMap.playerMobSpawnMap.remove(player);
                    continue;
                }
                int chunkRange = this.d.spigotConfig.mobSpawnRange;
                int viewDistance = this.a.getEffectiveViewDistance();
                chunkRange = chunkRange > viewDistance ? (int)viewDistance : chunkRange;
                chunkRange = chunkRange > 8 ? 8 : (int)chunkRange;
                PlayerNaturallySpawnCreaturesEvent event = new PlayerNaturallySpawnCreaturesEvent((Player)player.getBukkitEntity(), (byte)chunkRange);
                event.callEvent();
                if (event.isCancelled() || event.getSpawnRadius() < 0 || playerChunkMap.playerChunkTickRangeMap.getLastViewDistance(player) == -1) {
                    playerChunkMap.playerMobSpawnMap.remove(player);
                    continue;
                }
                int range = Math.min(event.getSpawnRadius(), 32);
                int chunkX = MCUtil.getChunkCoordinate(player.dc());
                int chunkZ = MCUtil.getChunkCoordinate(player.di());
                playerChunkMap.playerMobSpawnMap.addOrUpdate(player, chunkX, chunkZ, range);
                player.lastEntitySpawnRadiusSquared = (range << 4) * (range << 4);
                player.playerNaturallySpawnedEvent = event;
            }
            WorldData worlddata = this.d.n_();
            GameProfilerFiller gameprofilerfiller = this.d.ab();
            gameprofilerfiller.a("pollingChunks");
            int k2 = this.d.W().c(GameRules.n);
            boolean flag1 = this.d.ticksPerSpawnCategory.getLong((Object)SpawnCategory.ANIMAL) != 0L && worlddata.e() % this.d.ticksPerSpawnCategory.getLong((Object)SpawnCategory.ANIMAL) == 0L;
            gameprofilerfiller.a("naturalSpawnCount");
            this.d.timings.countNaturalMobs.startTiming();
            int l2 = this.c.b();
            if ((this.k || this.j) && this.a.playerMobDistanceMap != null) {
                for (EntityPlayer player : this.d.J) {
                    Arrays.fill(player.mobCounts, 0);
                }
                spawnercreature_d = SpawnerCreature.createState(l2, this.d.B(), this::a, null, true);
            } else {
                spawnercreature_d = SpawnerCreature.createState(l2, this.d.B(), this::a, this.a.playerMobDistanceMap == null ? new LocalMobCapCalculator(this.a) : null, false);
            }
            this.d.timings.countNaturalMobs.stopTiming();
            this.p = spawnercreature_d;
            gameprofilerfiller.b("filteringLoadedChunks");
            this.d.timings.chunkTicks.startTiming();
            gameprofilerfiller.b("spawnAndTick");
            boolean bl = flag2 = this.d.W().b(GameRules.e) && !this.d.y().isEmpty();
            if (this.d.paperConfig.perPlayerMobSpawns) {
                iterator1 = this.entityTickingChunks.iterator();
            } else {
                iterator1 = this.entityTickingChunks.unsafeIterator();
                ArrayList shuffled = Lists.newArrayListWithCapacity((int)this.entityTickingChunks.size());
                while (iterator1.hasNext()) {
                    shuffled.add(iterator1.next());
                }
                Collections.shuffle(shuffled);
                iterator1 = shuffled.iterator();
            }
            int chunksTicked = 0;
            try {
                while (iterator1.hasNext()) {
                    ChunkCoordIntPair chunkcoordintpair;
                    Chunk chunk1 = iterator1.next();
                    PlayerChunk holder = chunk1.playerChunk;
                    if (holder == null || !this.a.anyPlayerCloseEnoughForSpawning(holder, chunkcoordintpair = chunk1.f(), false)) continue;
                    chunk1.a(j2);
                    if (flag2 && (this.j || this.k) && this.d.p_().a(chunkcoordintpair) && this.a.anyPlayerCloseEnoughForSpawning(holder, chunkcoordintpair, true)) {
                        SpawnerCreature.a(this.d, chunk1, spawnercreature_d, this.k, this.j, flag1);
                    }
                    this.d.a(chunk1, k2);
                    if ((chunksTicked++ & 1) != 0) continue;
                    MinecraftServer.getServer().executeMidTickTasks();
                }
            }
            finally {
                if (iterator1 instanceof IteratorSafeOrderedReferenceSet.Iterator) {
                    IteratorSafeOrderedReferenceSet.Iterator safeIterator = iterator1;
                    safeIterator.finishedIterating();
                }
            }
            this.d.timings.chunkTicks.stopTiming();
            gameprofilerfiller.b("customSpawners");
            if (flag2) {
                try (Timing ignored = this.d.timings.miscMobSpawning.startTiming();){
                    this.d.a(this.j, this.k);
                }
            }
            gameprofilerfiller.c();
            gameprofilerfiller.b("broadcast");
            this.d.timings.broadcastChunkUpdates.startTiming();
            if (!this.a.needsChangeBroadcasting.isEmpty()) {
                ReferenceOpenHashSet copy = this.a.needsChangeBroadcasting.clone();
                this.a.needsChangeBroadcasting.clear();
                for (PlayerChunk holder : copy) {
                    holder.a(holder.getFullChunkUnchecked());
                    if (!holder.needsBroadcastChanges()) continue;
                    this.a.needsChangeBroadcasting.add((Object)holder);
                }
            }
            this.d.timings.broadcastChunkUpdates.stopTiming();
            gameprofilerfiller.c();
            ArrayList<NetworkManager> disabledFlushes = new ArrayList<NetworkManager>(this.d.J.size());
            for (EntityPlayer player : this.d.J) {
                PlayerConnection connection = player.b;
                if (connection == null) continue;
                connection.a.disableAutomaticFlush();
                disabledFlushes.add(connection.a);
            }
            try {
                this.a.j();
            }
            finally {
                for (NetworkManager networkManager : disabledFlushes) {
                    networkManager.enableAutomaticFlush();
                }
            }
        }
    }

    private void a(long pos, Consumer<Chunk> chunkConsumer) {
        PlayerChunk playerchunk = this.b(pos);
        if (playerchunk != null) {
            playerchunk.c().getNow(PlayerChunk.c).left().ifPresent(chunkConsumer);
        }
    }

    @Override
    public String e() {
        return Integer.toString(this.h());
    }

    @VisibleForTesting
    public int f() {
        return this.g.bl();
    }

    public ChunkGenerator g() {
        return this.a.a();
    }

    @Override
    public int h() {
        return this.a.g();
    }

    public void a(BlockPosition pos) {
        int j2;
        int i2 = SectionPosition.a(pos.u());
        PlayerChunk playerchunk = this.b(ChunkCoordIntPair.a(i2, j2 = SectionPosition.a(pos.w())));
        if (playerchunk != null) {
            playerchunk.a(pos);
        }
    }

    @Override
    public void a(EnumSkyBlock type, SectionPosition pos) {
        this.g.execute(() -> {
            PlayerChunk playerchunk = this.b(pos.r().a());
            if (playerchunk != null) {
                playerchunk.a(type, pos.b());
            }
        });
    }

    public <T> void a(TicketType<T> ticketType, ChunkCoordIntPair pos, int radius, T argument) {
        this.c.c(ticketType, pos, radius, argument);
    }

    public <T> void b(TicketType<T> ticketType, ChunkCoordIntPair pos, int radius, T argument) {
        this.c.d(ticketType, pos, radius, argument);
    }

    @Override
    public void a(ChunkCoordIntPair pos, boolean forced) {
        this.c.a(pos, forced);
    }

    public void a(EntityPlayer player) {
        if (!player.dp()) {
            this.a.a(player);
        }
    }

    public void a(Entity entity) {
        this.a.b(entity);
    }

    public void b(Entity entity) {
        this.a.a(entity);
    }

    public void a(Entity entity, Packet<?> packet) {
        this.a.b(entity, packet);
    }

    public void b(Entity entity, Packet<?> packet) {
        this.a.a(entity, packet);
    }

    public void a(int watchDistance) {
        this.a.a(watchDistance);
    }

    public void b(int simulationDistance) {
        this.c.b(simulationDistance);
    }

    @Override
    public void a(boolean spawnMonsters, boolean spawnAnimals) {
        this.j = spawnMonsters;
        this.k = spawnAnimals;
    }

    public String a(ChunkCoordIntPair pos) {
        return this.a.a(pos);
    }

    public WorldPersistentData i() {
        return this.h;
    }

    public VillagePlace j() {
        return this.a.k();
    }

    public ChunkScanAccess k() {
        return this.a.n();
    }

    @Nullable
    @VisibleForDebug
    public SpawnerCreature.d l() {
        return this.p;
    }

    public void m() {
        this.c.e();
    }

    private static /* synthetic */ boolean lambda$purgeUnload$18() {
        return true;
    }

    public final class b
    extends IAsyncTaskHandler<Runnable> {
        b(World world) {
            super("Chunk source main thread executor for " + world.aa().a());
        }

        @Override
        protected Runnable f(Runnable runnable) {
            return runnable;
        }

        @Override
        protected boolean e(Runnable task) {
            return true;
        }

        @Override
        protected boolean as() {
            return true;
        }

        @Override
        protected Thread at() {
            return ChunkProviderServer.this.e;
        }

        @Override
        protected void d(Runnable task) {
            ChunkProviderServer.this.d.ab().d("runTask");
            super.d(task);
        }

        @Override
        public boolean y() {
            try {
                boolean execChunkTask = ChunkTaskManager.pollChunkWaitQueue() || ChunkProviderServer.this.d.asyncChunkTaskManager.pollNextChunkTask();
                ChunkProviderServer.this.a.playerChunkManager.tickMidTick();
                if (ChunkProviderServer.this.q()) {
                    boolean bl = true;
                    return bl;
                }
                ChunkProviderServer.this.f.a();
                boolean bl = super.y() || execChunkTask;
                return bl;
            }
            finally {
                ChunkProviderServer.this.a.chunkLoadConversionCallbackExecutor.run();
                ChunkProviderServer.this.a.callbackExecutor.run();
            }
        }
    }

    private record a(Chunk a, PlayerChunk b) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "chunk;holder", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "chunk;holder", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "chunk;holder", "a", "b"}, this, o2);
        }
    }
}

