/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import ca.spottedleaf.starlight.common.light.StarLightInterface;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.logging.LogUtils;
import io.papermc.paper.util.misc.Delayed8WayDistancePropagator2D;
import it.unimi.dsi.fastutil.longs.Long2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.SectionPosition;
import net.minecraft.server.MCUtil;
import net.minecraft.server.level.ChunkTaskQueueSorter;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.PlayerChunk;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.Ticket;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.ArraySetSorted;
import net.minecraft.util.thread.Mailbox;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.chunk.ChunkStatus;
import org.slf4j.Logger;
import org.spigotmc.AsyncCatcher;

public abstract class ChunkMapDistance {
    static final Logger a = LogUtils.getLogger();
    private static final int b = 2;
    static final int c = 33 + ChunkStatus.a(ChunkStatus.o) - 2;
    private static final int d = 4;
    private static final int e = 32;
    private static final int f = 33;
    final Long2ObjectMap<ObjectSet<EntityPlayer>> g = new Long2ObjectOpenHashMap();
    public final Long2ObjectOpenHashMap<ArraySetSorted<Ticket<?>>> h = new Long2ObjectOpenHashMap();
    public static final int MOB_SPAWN_RANGE = 8;
    public final Queue<PlayerChunk> pendingChunkUpdates = new ArrayDeque<PlayerChunk>(){

        @Override
        public boolean add(PlayerChunk o2) {
            if (o2.isUpdateQueued) {
                return true;
            }
            o2.isUpdateQueued = true;
            return super.add(o2);
        }
    };
    final ChunkTaskQueueSorter n;
    final Mailbox<ChunkTaskQueueSorter.a<Runnable>> o;
    final Mailbox<ChunkTaskQueueSorter.b> p;
    final LongSet q = new LongOpenHashSet();
    final Executor r;
    private long s;
    private int t = 10;
    private final PlayerChunkMap chunkMap;
    protected final Long2IntLinkedOpenHashMap ticketLevelUpdates = new Long2IntLinkedOpenHashMap(){

        protected void rehash(int newN) {
            if (newN < this.n) {
                return;
            }
            super.rehash(newN);
        }
    };
    protected final Delayed8WayDistancePropagator2D ticketLevelPropagator = new Delayed8WayDistancePropagator2D((coordinate, oldLevel, newLevel) -> this.ticketLevelUpdates.putAndMoveToLast(coordinate, ChunkMapDistance.convertBetweenTicketLevels(newLevel)));
    protected long ticketLevelUpdateCount;
    boolean pollingPendingChunkUpdates = false;
    public static final int PRIORITY_TICKET_LEVEL = PlayerChunkMap.b;
    public static final int URGENT_PRIORITY = 29;
    public boolean delayDistanceManagerTick = false;

    protected ChunkMapDistance(Executor workerExecutor, Executor mainThreadExecutor, PlayerChunkMap chunkMap) {
        ChunkTaskQueueSorter chunktaskqueuesorter;
        Objects.requireNonNull(mainThreadExecutor);
        Mailbox<Runnable> mailbox = Mailbox.a("player ticket throttler", mainThreadExecutor::execute);
        this.n = chunktaskqueuesorter = new ChunkTaskQueueSorter((List<Mailbox<?>>)ImmutableList.of(mailbox), workerExecutor, 4);
        this.o = chunktaskqueuesorter.a(mailbox, true);
        this.p = chunktaskqueuesorter.a(mailbox);
        this.r = mainThreadExecutor;
        this.chunkMap = chunkMap;
    }

    public static int convertBetweenTicketLevels(int level) {
        return PlayerChunkMap.b - level + 1;
    }

    protected final int getPropagatedTicketLevel(long coordinate) {
        return ChunkMapDistance.convertBetweenTicketLevels(this.ticketLevelPropagator.getLevel(coordinate));
    }

    protected final void updateTicketLevel(long coordinate, int ticketLevel) {
        if (ticketLevel > PlayerChunkMap.b) {
            this.ticketLevelPropagator.removeSource(coordinate);
        } else {
            this.ticketLevelPropagator.setSource(coordinate, ChunkMapDistance.convertBetweenTicketLevels(ticketLevel));
        }
    }

    protected void a() {
        ++this.s;
        ObjectIterator objectiterator = this.h.long2ObjectEntrySet().fastIterator();
        long[] currChunk = new long[1];
        long ticketCounter = this.s;
        Predicate<Ticket> removeIf = ticket -> {
            boolean ret = ticket.b(ticketCounter);
            if (ret) {
                // empty if block
            }
            return ret;
        };
        while (objectiterator.hasNext()) {
            Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)objectiterator.next();
            Object iterator = null;
            currChunk[0] = entry.getLongKey();
            boolean flag = ((ArraySetSorted)entry.getValue()).removeIf(removeIf);
            if (flag) {
                this.updateTicketLevel(entry.getLongKey(), ChunkMapDistance.a((ArraySetSorted)entry.getValue()));
            }
            if (!((ArraySetSorted)entry.getValue()).isEmpty()) continue;
            objectiterator.remove();
        }
    }

    private static int a(ArraySetSorted<Ticket<?>> tickets) {
        AsyncCatcher.catchOp("ChunkMapDistance::getTicketLevelAt");
        return !tickets.isEmpty() ? tickets.b().b() : PlayerChunkMap.b + 1;
    }

    protected abstract boolean a(long var1);

    @Nullable
    protected abstract PlayerChunk b(long var1);

    @Nullable
    protected abstract PlayerChunk a(long var1, int var3, @Nullable PlayerChunk var4, int var5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean a(PlayerChunkMap chunkStorage) {
        AsyncCatcher.catchOp("DistanceManagerTick");
        boolean flag = this.ticketLevelPropagator.propagateUpdates();
        if (flag) {
            // empty if block
        }
        block5: while (!this.ticketLevelUpdates.isEmpty()) {
            flag = true;
            boolean oldPolling = this.pollingPendingChunkUpdates;
            this.pollingPendingChunkUpdates = true;
            try {
                PlayerChunk pendingUpdate;
                int currentLevel;
                PlayerChunk chunk;
                int newLevel;
                long key;
                ObjectBidirectionalIterator iterator = this.ticketLevelUpdates.long2IntEntrySet().fastIterator();
                while (iterator.hasNext()) {
                    Long2IntMap.Entry entry = (Long2IntMap.Entry)iterator.next();
                    key = entry.getLongKey();
                    newLevel = entry.getIntValue();
                    chunk = this.b(key);
                    if (chunk == null && newLevel > PlayerChunkMap.b) continue;
                    int n2 = currentLevel = chunk == null ? PlayerChunkMap.b + 1 : chunk.k();
                    if (currentLevel == newLevel) continue;
                    this.a(key, newLevel, chunk, currentLevel);
                }
                long recursiveCheck = ++this.ticketLevelUpdateCount;
                while (!this.ticketLevelUpdates.isEmpty()) {
                    key = this.ticketLevelUpdates.firstLongKey();
                    newLevel = this.ticketLevelUpdates.removeFirstInt();
                    chunk = this.b(key);
                    if (chunk == null) {
                        if (newLevel > PlayerChunkMap.b) continue;
                        throw new IllegalStateException("Expected chunk holder to be created");
                    }
                    currentLevel = chunk.p;
                    if (currentLevel == newLevel) continue;
                    chunk.a(chunkStorage, this.r);
                    if (recursiveCheck != this.ticketLevelUpdateCount) continue block5;
                }
                while (recursiveCheck == this.ticketLevelUpdateCount && (pendingUpdate = this.pendingChunkUpdates.poll()) != null) {
                    pendingUpdate.a(chunkStorage, this.r);
                }
            }
            finally {
                this.pollingPendingChunkUpdates = oldPolling;
            }
        }
        return flag;
    }

    boolean addTicket(long i2, Ticket<?> ticket) {
        AsyncCatcher.catchOp("ChunkMapDistance::addTicket");
        ArraySetSorted<Ticket<?>> arraysetsorted = this.g(i2);
        int j2 = ChunkMapDistance.a(arraysetsorted);
        Ticket<?> ticket1 = arraysetsorted.a(ticket);
        ticket1.a(this.s);
        if (ticket.b() < j2) {
            this.updateTicketLevel(i2, ticket.b());
        }
        return ticket == ticket1;
    }

    boolean removeTicket(long i2, Ticket<?> ticket) {
        int newLevel;
        AsyncCatcher.catchOp("ChunkMapDistance::removeTicket");
        ArraySetSorted<Ticket<?>> arraysetsorted = this.g(i2);
        int oldLevel = ChunkMapDistance.a(arraysetsorted);
        boolean removed = false;
        if (arraysetsorted.remove(ticket)) {
            removed = true;
            long delayChunkUnloadsBy = this.chunkMap.r.paperConfig.delayChunkUnloadsBy;
            if (ticket.a() == TicketType.c && delayChunkUnloadsBy > 0L) {
                boolean hasPlayer = false;
                for (Ticket<?> ticket1 : arraysetsorted) {
                    if (ticket1.a() != TicketType.c) continue;
                    hasPlayer = true;
                    break;
                }
                PlayerChunk playerChunk = this.chunkMap.a(i2);
                if (!hasPlayer && playerChunk != null && playerChunk.isFullChunkReady()) {
                    Ticket<Long> delayUnload = new Ticket<Long>(TicketType.DELAY_UNLOAD, 33, i2);
                    delayUnload.delayUnloadBy = delayChunkUnloadsBy;
                    delayUnload.a(this.s);
                    arraysetsorted.remove(delayUnload);
                    arraysetsorted.add(delayUnload);
                }
            }
        }
        if (arraysetsorted.isEmpty()) {
            this.h.remove(i2);
        }
        if ((newLevel = ChunkMapDistance.a(arraysetsorted)) > oldLevel) {
            this.updateTicketLevel(i2, newLevel);
        }
        return removed;
    }

    public <T> void a(TicketType<T> type, ChunkCoordIntPair pos, int level, T argument) {
        this.addTicket(pos.a(), new Ticket<T>(type, level, argument));
    }

    public <T> void b(TicketType<T> type, ChunkCoordIntPair pos, int level, T argument) {
        Ticket<T> ticket = new Ticket<T>(type, level, argument);
        this.removeTicket(pos.a(), ticket);
    }

    public <T> void c(TicketType<T> type, ChunkCoordIntPair pos, int radius, T argument) {
        this.addRegionTicketAtDistance(type, pos, radius, argument);
    }

    public <T> boolean addRegionTicketAtDistance(TicketType<T> tickettype, ChunkCoordIntPair chunkcoordintpair, int i2, T t0) {
        Ticket<T> ticket = new Ticket<T>(tickettype, 33 - i2, t0);
        long j2 = chunkcoordintpair.a();
        boolean added = this.addTicket(j2, ticket);
        return added;
    }

    public <T> void d(TicketType<T> type, ChunkCoordIntPair pos, int radius, T argument) {
        this.removeRegionTicketAtDistance(type, pos, radius, argument);
    }

    public <T> boolean removeRegionTicketAtDistance(TicketType<T> tickettype, ChunkCoordIntPair chunkcoordintpair, int i2, T t0) {
        Ticket<T> ticket = new Ticket<T>(tickettype, 33 - i2, t0);
        long j2 = chunkcoordintpair.a();
        boolean removed = this.removeTicket(j2, ticket);
        return removed;
    }

    private ArraySetSorted<Ticket<?>> g(long position) {
        return (ArraySetSorted)this.h.computeIfAbsent(position, j2 -> ArraySetSorted.a(4));
    }

    public boolean markUrgent(ChunkCoordIntPair coords) {
        return this.addPriorityTicket(coords, TicketType.URGENT, 29);
    }

    public boolean markHighPriority(ChunkCoordIntPair coords, int priority) {
        priority = Math.min(28, Math.max(1, priority));
        return this.addPriorityTicket(coords, TicketType.PRIORITY, priority);
    }

    public void markAreaHighPriority(ChunkCoordIntPair center, int priority, int radius) {
        this.delayDistanceManagerTick = true;
        int finalPriority = priority = Math.min(28, Math.max(1, priority));
        MCUtil.getSpiralOutChunks(center.l(), radius).forEach(coords -> this.addPriorityTicket((ChunkCoordIntPair)coords, TicketType.PRIORITY, finalPriority));
        this.delayDistanceManagerTick = false;
        this.chunkMap.r.k().q();
    }

    public void clearAreaPriorityTickets(ChunkCoordIntPair center, int radius) {
        this.delayDistanceManagerTick = true;
        MCUtil.getSpiralOutChunks(center.l(), radius).forEach(coords -> this.removeTicket(coords.a(), new Ticket<ChunkCoordIntPair>(TicketType.PRIORITY, PRIORITY_TICKET_LEVEL, (ChunkCoordIntPair)coords)));
        this.delayDistanceManagerTick = false;
        this.chunkMap.r.k().q();
    }

    private boolean addPriorityTicket(ChunkCoordIntPair coords, TicketType<ChunkCoordIntPair> ticketType, int priority) {
        AsyncCatcher.catchOp("ChunkMapDistance::addPriorityTicket");
        long pair = coords.a();
        PlayerChunk chunk = this.chunkMap.a(pair);
        if (chunk != null && chunk.isFullChunkReady()) {
            return false;
        }
        boolean success = this.updatePriorityTicket(coords, ticketType, priority);
        if (!success) {
            Ticket<ChunkCoordIntPair> ticket = new Ticket<ChunkCoordIntPair>(ticketType, PRIORITY_TICKET_LEVEL, coords);
            ticket.priority = priority;
            success = this.addTicket(pair, ticket);
        } else {
            if (chunk == null) {
                chunk = this.chunkMap.a(pair);
            }
            this.chunkMap.queueHolderUpdate(chunk);
        }
        this.chunkMap.r.k().q();
        return success;
    }

    private boolean updatePriorityTicket(ChunkCoordIntPair coords, TicketType<ChunkCoordIntPair> type, int priority) {
        ArraySetSorted tickets = (ArraySetSorted)this.h.get(coords.a());
        if (tickets == null) {
            return false;
        }
        for (Ticket ticket : tickets) {
            if (ticket.a() != type) continue;
            ticket.a(this.s);
            ticket.priority = Math.max(ticket.priority, priority);
            return true;
        }
        return false;
    }

    public int getChunkPriority(ChunkCoordIntPair coords) {
        AsyncCatcher.catchOp("ChunkMapDistance::getChunkPriority");
        ArraySetSorted tickets = (ArraySetSorted)this.h.get(coords.a());
        if (tickets == null) {
            return 0;
        }
        for (Ticket ticket : tickets) {
            if (ticket.a() != TicketType.URGENT) continue;
            return 29;
        }
        for (Ticket ticket : tickets) {
            if (ticket.a() != TicketType.PRIORITY || ticket.priority <= 0) continue;
            return ticket.priority;
        }
        return 0;
    }

    public void clearPriorityTickets(ChunkCoordIntPair coords) {
        AsyncCatcher.catchOp("ChunkMapDistance::clearPriority");
        this.removeTicket(coords.a(), new Ticket<ChunkCoordIntPair>(TicketType.PRIORITY, PRIORITY_TICKET_LEVEL, coords));
    }

    public void clearUrgent(ChunkCoordIntPair coords) {
        AsyncCatcher.catchOp("ChunkMapDistance::clearUrgent");
        this.removeTicket(coords.a(), new Ticket<ChunkCoordIntPair>(TicketType.URGENT, PRIORITY_TICKET_LEVEL, coords));
    }

    protected void a(ChunkCoordIntPair pos, boolean forced) {
        Ticket<ChunkCoordIntPair> ticket = new Ticket<ChunkCoordIntPair>(TicketType.d, 31, pos);
        long i2 = pos.a();
        if (forced) {
            this.addTicket(i2, ticket);
        } else {
            this.removeTicket(i2, ticket);
        }
    }

    public void a(SectionPosition pos, EntityPlayer player) {
        ChunkCoordIntPair chunkcoordintpair = pos.r();
        long i2 = chunkcoordintpair.a();
        ((ObjectSet)this.g.computeIfAbsent(i2, j2 -> new ObjectOpenHashSet())).add((Object)player);
    }

    public void b(SectionPosition pos, EntityPlayer player) {
        ChunkCoordIntPair chunkcoordintpair = pos.r();
        long i2 = chunkcoordintpair.a();
        ObjectSet objectset = (ObjectSet)this.g.get(i2);
        if (objectset == null) {
            return;
        }
        if (objectset != null) {
            objectset.remove((Object)player);
        }
        if (objectset == null || objectset.isEmpty()) {
            this.g.remove(i2);
        }
    }

    private int g() {
        return Math.max(0, 31 - this.t);
    }

    public boolean c(long chunkPos) {
        PlayerChunk holder = this.chunkMap.b(chunkPos);
        return holder != null && holder.isEntityTickingReady();
    }

    public boolean d(long chunkPos) {
        PlayerChunk holder = this.chunkMap.b(chunkPos);
        return holder != null && holder.isTickingReady();
    }

    protected String e(long pos) {
        ArraySetSorted arraysetsorted = (ArraySetSorted)this.h.get(pos);
        return arraysetsorted != null && !arraysetsorted.isEmpty() ? ((Ticket)arraysetsorted.b()).toString() : "no_ticket";
    }

    protected void a(int viewDistance) {
        this.chunkMap.playerChunkManager.setTargetNoTickViewDistance(viewDistance);
    }

    public void b(int simulationDistance) {
        this.chunkMap.playerChunkManager.setTargetTickViewDistance(simulationDistance);
    }

    public int getSimulationDistance() {
        return this.chunkMap.playerChunkManager.getTargetTickViewDistance();
    }

    public int b() {
        return this.chunkMap.playerChunkTickRangeMap.size();
    }

    public boolean f(long chunkPos) {
        return this.chunkMap.playerChunkTickRangeMap.getObjectsInRange(chunkPos) != null;
    }

    public String c() {
        return this.n.b();
    }

    private void a(String path) {
        try (FileOutputStream fileoutputstream = new FileOutputStream(new File(path));){
            for (Long2ObjectMap.Entry entry : this.h.long2ObjectEntrySet()) {
                ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(entry.getLongKey());
                for (Ticket ticket : (ArraySetSorted)entry.getValue()) {
                    fileoutputstream.write((chunkcoordintpair.c + "\t" + chunkcoordintpair.d + "\t" + ticket.a() + "\t" + ticket.b() + "\t\n").getBytes(StandardCharsets.UTF_8));
                }
            }
        }
        catch (IOException ioexception) {
            a.error("Failed to dump tickets to {}", (Object)path, (Object)ioexception);
        }
    }

    public void e() {
        ImmutableSet immutableset = ImmutableSet.of(TicketType.h, TicketType.g, TicketType.e, TicketType.FUTURE_AWAIT, TicketType.ASYNC_LOAD, TicketType.REQUIRED_LOAD, (Object[])new TicketType[]{TicketType.CHUNK_RELIGHT, StarLightInterface.CHUNK_WORK_TICKET});
        ObjectIterator objectiterator = this.h.long2ObjectEntrySet().fastIterator();
        while (objectiterator.hasNext()) {
            Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)objectiterator.next();
            Iterator iterator = ((ArraySetSorted)entry.getValue()).iterator();
            boolean flag = false;
            while (iterator.hasNext()) {
                Ticket ticket = (Ticket)iterator.next();
                if (immutableset.contains(ticket.a())) continue;
                iterator.remove();
                flag = true;
            }
            if (flag) {
                this.updateTicketLevel(entry.getLongKey(), ChunkMapDistance.a((ArraySetSorted)entry.getValue()));
            }
            if (!((ArraySetSorted)entry.getValue()).isEmpty()) continue;
            objectiterator.remove();
        }
    }

    public boolean f() {
        return !this.h.isEmpty();
    }

    public <T> void removeAllTicketsFor(TicketType<T> ticketType, int ticketLevel, T ticketIdentifier) {
        Ticket<T> target = new Ticket<T>(ticketType, ticketLevel, ticketIdentifier);
        ObjectIterator iterator = this.h.long2ObjectEntrySet().fastIterator();
        while (iterator.hasNext()) {
            Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)iterator.next();
            ArraySetSorted tickets = (ArraySetSorted)entry.getValue();
            if (!tickets.remove(target)) continue;
            this.updateTicketLevel(entry.getLongKey(), ChunkMapDistance.a(tickets));
            if (!tickets.isEmpty()) continue;
            iterator.remove();
        }
    }
}

