/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.Timer;
import net.minecraft.SystemUtils;
import net.minecraft.server.MinecraftServer;
import org.bukkit.Bukkit;

public class GuiStatsComponent
extends JComponent {
    private static final DecimalFormat a = SystemUtils.a(new DecimalFormat("########0.000"), decimalFormat -> decimalFormat.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));
    private final int[] b = new int[256];
    private int c;
    private final String[] d = new String[11];
    private final MinecraftServer e;
    private final Timer f;

    public GuiStatsComponent(MinecraftServer server) {
        this.e = server;
        this.setPreferredSize(new Dimension(456, 246));
        this.setMinimumSize(new Dimension(456, 246));
        this.setMaximumSize(new Dimension(456, 246));
        this.f = new Timer(500, event -> this.b());
        this.f.start();
        this.setBackground(Color.BLACK);
    }

    private void b() {
        long l2 = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        double[] tps = Bukkit.getTPS();
        CharSequence[] tpsAvg = new String[tps.length];
        for (int g2 = 0; g2 < tps.length; ++g2) {
            tpsAvg[g2] = GuiStatsComponent.format(tps[g2]);
        }
        this.d[0] = "Memory use: " + l2 / 1024L / 1024L + " mb (" + Runtime.getRuntime().freeMemory() * 100L / Runtime.getRuntime().maxMemory() + "% free)";
        this.d[1] = "Avg tick: " + a.format(this.a(this.e.o) * 1.0E-6) + " ms";
        this.d[2] = "TPS from last 1m, 5m, 15m: " + String.join((CharSequence)", ", tpsAvg);
        this.b[this.c++ & 0xFF] = (int)(l2 * 100L / Runtime.getRuntime().maxMemory());
        this.repaint();
    }

    private double a(long[] values) {
        long l2 = 0L;
        for (long m2 : values) {
            l2 += m2;
        }
        return (double)l2 / (double)values.length;
    }

    @Override
    public void paint(Graphics graphics) {
        graphics.setColor(new Color(0xFFFFFF));
        graphics.fillRect(0, 0, 456, 246);
        for (int i2 = 0; i2 < 256; ++i2) {
            int j2 = this.b[i2 + this.c & 0xFF];
            graphics.setColor(new Color(j2 + 28 << 16));
            graphics.fillRect(i2, 100 - j2, 1, j2);
        }
        graphics.setColor(Color.BLACK);
        for (int k2 = 0; k2 < this.d.length; ++k2) {
            String string = this.d[k2];
            if (string == null) continue;
            graphics.drawString(string, 32, 116 + k2 * 16);
        }
    }

    public void a() {
        this.f.stop();
    }

    private static String format(double tps) {
        return (tps > 21.0 ? "*" : "") + Math.min((double)Math.round(tps * 100.0) / 100.0, 20.0);
    }
}

