/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands.data;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentNBTBase;
import net.minecraft.commands.arguments.ArgumentNBTKey;
import net.minecraft.commands.arguments.ArgumentNBTTag;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTList;
import net.minecraft.nbt.NBTNumber;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.server.commands.data.CommandDataAccessor;
import net.minecraft.server.commands.data.CommandDataAccessorEntity;
import net.minecraft.server.commands.data.CommandDataAccessorTile;
import net.minecraft.server.commands.data.CommandDataStorage;
import net.minecraft.util.MathHelper;

public class CommandData {
    private static final SimpleCommandExceptionType d = new SimpleCommandExceptionType((Message)new ChatMessage("commands.data.merge.failed"));
    private static final DynamicCommandExceptionType e = new DynamicCommandExceptionType(path -> new ChatMessage("commands.data.get.invalid", path));
    private static final DynamicCommandExceptionType f = new DynamicCommandExceptionType(path -> new ChatMessage("commands.data.get.unknown", path));
    private static final SimpleCommandExceptionType g = new SimpleCommandExceptionType((Message)new ChatMessage("commands.data.get.multiple"));
    private static final DynamicCommandExceptionType h = new DynamicCommandExceptionType(nbt -> new ChatMessage("commands.data.modify.expected_list", nbt));
    private static final DynamicCommandExceptionType i = new DynamicCommandExceptionType(nbt -> new ChatMessage("commands.data.modify.expected_object", nbt));
    private static final DynamicCommandExceptionType j = new DynamicCommandExceptionType(index -> new ChatMessage("commands.data.modify.invalid_index", index));
    public static final List<Function<String, c>> a = ImmutableList.of(CommandDataAccessorEntity.a, CommandDataAccessorTile.a, CommandDataStorage.a);
    public static final List<c> b = (List)a.stream().map(factory -> (c)factory.apply("target")).collect(ImmutableList.toImmutableList());
    public static final List<c> c = (List)a.stream().map(factory -> (c)factory.apply("source")).collect(ImmutableList.toImmutableList());

    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher) {
        LiteralArgumentBuilder literalArgumentBuilder = (LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("data").requires(source -> source.c(2));
        for (c dataProvider : b) {
            ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)literalArgumentBuilder.then(dataProvider.a((ArgumentBuilder<CommandListenerWrapper, ?>)net.minecraft.commands.CommandDispatcher.a("merge"), builder -> builder.then(net.minecraft.commands.CommandDispatcher.a("nbt", ArgumentNBTTag.a()).executes(context -> CommandData.a((CommandListenerWrapper)context.getSource(), dataProvider.a((CommandContext<CommandListenerWrapper>)context), ArgumentNBTTag.a(context, "nbt"))))))).then(dataProvider.a((ArgumentBuilder<CommandListenerWrapper, ?>)net.minecraft.commands.CommandDispatcher.a("get"), builder -> ((ArgumentBuilder)builder.executes(context -> CommandData.a((CommandListenerWrapper)context.getSource(), dataProvider.a((CommandContext<CommandListenerWrapper>)context)))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("path", ArgumentNBTKey.a()).executes(context -> CommandData.b((CommandListenerWrapper)context.getSource(), dataProvider.a((CommandContext<CommandListenerWrapper>)context), ArgumentNBTKey.a((CommandContext<CommandListenerWrapper>)context, "path")))).then(net.minecraft.commands.CommandDispatcher.a("scale", DoubleArgumentType.doubleArg()).executes(context -> CommandData.a((CommandListenerWrapper)context.getSource(), dataProvider.a((CommandContext<CommandListenerWrapper>)context), ArgumentNBTKey.a((CommandContext<CommandListenerWrapper>)context, "path"), DoubleArgumentType.getDouble((CommandContext)context, (String)"scale")))))))).then(dataProvider.a((ArgumentBuilder<CommandListenerWrapper, ?>)net.minecraft.commands.CommandDispatcher.a("remove"), builder -> builder.then(net.minecraft.commands.CommandDispatcher.a("path", ArgumentNBTKey.a()).executes(context -> CommandData.a((CommandListenerWrapper)context.getSource(), dataProvider.a((CommandContext<CommandListenerWrapper>)context), ArgumentNBTKey.a((CommandContext<CommandListenerWrapper>)context, "path"))))))).then(CommandData.a((ArgumentBuilder<CommandListenerWrapper, ?> builder, b modifier) -> ((ArgumentBuilder)((ArgumentBuilder)((ArgumentBuilder)((ArgumentBuilder)builder.then(net.minecraft.commands.CommandDispatcher.a("insert").then(net.minecraft.commands.CommandDispatcher.a("index", IntegerArgumentType.integer()).then(modifier.create((context, sourceNbt, path, elements) -> {
                int i2 = IntegerArgumentType.getInteger((CommandContext)context, (String)"index");
                return CommandData.a(i2, sourceNbt, path, (List<NBTBase>)elements);
            }))))).then(net.minecraft.commands.CommandDispatcher.a("prepend").then(modifier.create((context, sourceNbt, path, elements) -> CommandData.a(0, sourceNbt, path, (List<NBTBase>)elements))))).then(net.minecraft.commands.CommandDispatcher.a("append").then(modifier.create((context, sourceNbt, path, elements) -> CommandData.a(-1, sourceNbt, path, (List<NBTBase>)elements))))).then(net.minecraft.commands.CommandDispatcher.a("set").then(modifier.create((context, sourceNbt, path, elements) -> path.b(sourceNbt, ((NBTBase)Iterables.getLast((Iterable)elements))::c))))).then(net.minecraft.commands.CommandDispatcher.a("merge").then(modifier.create((context, sourceNbt, path, elements) -> {
                List<NBTBase> collection = path.a((NBTBase)sourceNbt, NBTTagCompound::new);
                int i2 = 0;
                for (NBTBase tag : collection) {
                    if (!(tag instanceof NBTTagCompound)) {
                        throw i.create((Object)tag);
                    }
                    NBTTagCompound compoundTag = (NBTTagCompound)tag;
                    NBTTagCompound compoundTag2 = compoundTag.g();
                    for (NBTBase tag2 : elements) {
                        if (!(tag2 instanceof NBTTagCompound)) {
                            throw i.create((Object)tag2);
                        }
                        compoundTag.a((NBTTagCompound)tag2);
                    }
                    i2 += compoundTag2.equals(compoundTag) ? 0 : 1;
                }
                return i2;
            })))));
        }
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)literalArgumentBuilder);
    }

    private static int a(int integer, NBTTagCompound sourceNbt, ArgumentNBTKey.g path, List<NBTBase> elements) throws CommandSyntaxException {
        List<NBTBase> collection = path.a((NBTBase)sourceNbt, NBTTagList::new);
        int i2 = 0;
        for (NBTBase tag : collection) {
            if (!(tag instanceof NBTList)) {
                throw h.create((Object)tag);
            }
            boolean bl = false;
            NBTList collectionTag = (NBTList)tag;
            int j2 = integer < 0 ? collectionTag.size() + integer + 1 : integer;
            for (NBTBase tag2 : elements) {
                try {
                    if (!collectionTag.b(j2, tag2.c())) continue;
                    ++j2;
                    bl = true;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    throw j.create((Object)j2);
                }
            }
            i2 += bl ? 1 : 0;
        }
        return i2;
    }

    private static ArgumentBuilder<CommandListenerWrapper, ?> a(BiConsumer<ArgumentBuilder<CommandListenerWrapper, ?>, b> subArgumentAdder) {
        LiteralArgumentBuilder<CommandListenerWrapper> literalArgumentBuilder = net.minecraft.commands.CommandDispatcher.a("modify");
        for (c dataProvider : b) {
            dataProvider.a((ArgumentBuilder<CommandListenerWrapper, ?>)literalArgumentBuilder, builder -> {
                RequiredArgumentBuilder<CommandListenerWrapper, ArgumentNBTKey.g> argumentBuilder = net.minecraft.commands.CommandDispatcher.a("targetPath", ArgumentNBTKey.a());
                for (c dataProvider2 : c) {
                    subArgumentAdder.accept((ArgumentBuilder<CommandListenerWrapper, ?>)argumentBuilder, modifier -> dataProvider2.a((ArgumentBuilder<CommandListenerWrapper, ?>)net.minecraft.commands.CommandDispatcher.a("from"), builder -> ((ArgumentBuilder)builder.executes(context -> {
                        List<NBTBase> list = Collections.singletonList(dataProvider2.a((CommandContext<CommandListenerWrapper>)context).a());
                        return CommandData.a((CommandContext<CommandListenerWrapper>)context, dataProvider, modifier, list);
                    })).then(net.minecraft.commands.CommandDispatcher.a("sourcePath", ArgumentNBTKey.a()).executes(context -> {
                        CommandDataAccessor dataAccessor = dataProvider2.a((CommandContext<CommandListenerWrapper>)context);
                        ArgumentNBTKey.g nbtPath = ArgumentNBTKey.a((CommandContext<CommandListenerWrapper>)context, "sourcePath");
                        List<NBTBase> list = nbtPath.a(dataAccessor.a());
                        return CommandData.a((CommandContext<CommandListenerWrapper>)context, dataProvider, modifier, list);
                    }))));
                }
                subArgumentAdder.accept((ArgumentBuilder<CommandListenerWrapper, ?>)argumentBuilder, modifier -> net.minecraft.commands.CommandDispatcher.a("value").then(net.minecraft.commands.CommandDispatcher.a("value", ArgumentNBTBase.a()).executes(context -> {
                    List<NBTBase> list = Collections.singletonList(ArgumentNBTBase.a(context, "value"));
                    return CommandData.a((CommandContext<CommandListenerWrapper>)context, dataProvider, modifier, list);
                })));
                return builder.then(argumentBuilder);
            });
        }
        return literalArgumentBuilder;
    }

    private static int a(CommandContext<CommandListenerWrapper> context, c objectType, a modifier, List<NBTBase> elements) throws CommandSyntaxException {
        CommandDataAccessor dataAccessor = objectType.a(context);
        ArgumentNBTKey.g nbtPath = ArgumentNBTKey.a(context, "targetPath");
        NBTTagCompound compoundTag = dataAccessor.a();
        int i2 = modifier.modify(context, compoundTag, nbtPath, elements);
        if (i2 == 0) {
            throw d.create();
        }
        dataAccessor.a(compoundTag);
        ((CommandListenerWrapper)context.getSource()).a(dataAccessor.b(), true);
        return i2;
    }

    private static int a(CommandListenerWrapper source, CommandDataAccessor object, ArgumentNBTKey.g path) throws CommandSyntaxException {
        NBTTagCompound compoundTag = object.a();
        int i2 = path.c(compoundTag);
        if (i2 == 0) {
            throw d.create();
        }
        object.a(compoundTag);
        source.a(object.b(), true);
        return i2;
    }

    private static NBTBase a(ArgumentNBTKey.g path, CommandDataAccessor object) throws CommandSyntaxException {
        List<NBTBase> collection = path.a(object.a());
        Iterator iterator = collection.iterator();
        NBTBase tag = (NBTBase)iterator.next();
        if (iterator.hasNext()) {
            throw g.create();
        }
        return tag;
    }

    /*
     * WARNING - void declaration
     */
    private static int b(CommandListenerWrapper source, CommandDataAccessor object, ArgumentNBTKey.g path) throws CommandSyntaxException {
        void m2;
        NBTBase tag = CommandData.a(path, object);
        if (tag instanceof NBTNumber) {
            int i2 = MathHelper.b(((NBTNumber)tag).i());
        } else if (tag instanceof NBTList) {
            int j2 = ((NBTList)tag).size();
        } else if (tag instanceof NBTTagCompound) {
            int k2 = ((NBTTagCompound)tag).e();
        } else if (tag instanceof NBTTagString) {
            int l2 = tag.e_().length();
        } else {
            throw f.create((Object)path.toString());
        }
        source.a(object.a(tag), false);
        return (int)m2;
    }

    private static int a(CommandListenerWrapper source, CommandDataAccessor object, ArgumentNBTKey.g path, double scale) throws CommandSyntaxException {
        NBTBase tag = CommandData.a(path, object);
        if (!(tag instanceof NBTNumber)) {
            throw e.create((Object)path.toString());
        }
        int i2 = MathHelper.b(((NBTNumber)tag).i() * scale);
        source.a(object.a(path, scale, i2), false);
        return i2;
    }

    private static int a(CommandListenerWrapper source, CommandDataAccessor object) throws CommandSyntaxException {
        source.a(object.a((NBTBase)object.a()), false);
        return 1;
    }

    private static int a(CommandListenerWrapper source, CommandDataAccessor object, NBTTagCompound nbt) throws CommandSyntaxException {
        NBTTagCompound compoundTag2;
        NBTTagCompound compoundTag = object.a();
        if (compoundTag.equals(compoundTag2 = compoundTag.g().a(nbt))) {
            throw d.create();
        }
        object.a(compoundTag2);
        source.a(object.b(), true);
        return 1;
    }

    public static interface c {
        public CommandDataAccessor a(CommandContext<CommandListenerWrapper> var1) throws CommandSyntaxException;

        public ArgumentBuilder<CommandListenerWrapper, ?> a(ArgumentBuilder<CommandListenerWrapper, ?> var1, Function<ArgumentBuilder<CommandListenerWrapper, ?>, ArgumentBuilder<CommandListenerWrapper, ?>> var2);
    }

    static interface a {
        public int modify(CommandContext<CommandListenerWrapper> var1, NBTTagCompound var2, ArgumentNBTKey.g var3, List<NBTBase> var4) throws CommandSyntaxException;
    }

    static interface b {
        public ArgumentBuilder<CommandListenerWrapper, ?> create(a var1);
    }
}

