/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentChatComponent;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.chat.ChatComponentText;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.raid.EntityRaider;
import net.minecraft.world.entity.raid.PersistentRaid;
import net.minecraft.world.entity.raid.Raid;

public class RaidCommand {
    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("raid").requires(source -> source.c(3))).then(net.minecraft.commands.CommandDispatcher.a("start").then(net.minecraft.commands.CommandDispatcher.a("omenlvl", IntegerArgumentType.integer((int)0)).executes(context -> RaidCommand.b((CommandListenerWrapper)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"omenlvl")))))).then(net.minecraft.commands.CommandDispatcher.a("stop").executes(context -> RaidCommand.c((CommandListenerWrapper)context.getSource())))).then(net.minecraft.commands.CommandDispatcher.a("check").executes(context -> RaidCommand.d((CommandListenerWrapper)context.getSource())))).then(net.minecraft.commands.CommandDispatcher.a("sound").then(net.minecraft.commands.CommandDispatcher.a("type", ArgumentChatComponent.a()).executes(context -> RaidCommand.a((CommandListenerWrapper)context.getSource(), ArgumentChatComponent.a((CommandContext<CommandListenerWrapper>)context, "type")))))).then(net.minecraft.commands.CommandDispatcher.a("spawnleader").executes(context -> RaidCommand.b((CommandListenerWrapper)context.getSource())))).then(net.minecraft.commands.CommandDispatcher.a("setomen").then(net.minecraft.commands.CommandDispatcher.a("level", IntegerArgumentType.integer((int)0)).executes(context -> RaidCommand.a((CommandListenerWrapper)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"level")))))).then(net.minecraft.commands.CommandDispatcher.a("glow").executes(context -> RaidCommand.a((CommandListenerWrapper)context.getSource())))));
    }

    private static int a(CommandListenerWrapper source) throws CommandSyntaxException {
        Raid raid = RaidCommand.a(source.h());
        if (raid != null) {
            Set<EntityRaider> set = raid.h();
            for (EntityRaider raider : set) {
                raider.b(new MobEffect(MobEffects.x, 1000, 1));
            }
        }
        return 1;
    }

    private static int a(CommandListenerWrapper source, int level) throws CommandSyntaxException {
        Raid raid = RaidCommand.a(source.h());
        if (raid != null) {
            int i2 = raid.l();
            if (level > i2) {
                source.a(new ChatComponentText("Sorry, the max bad omen level you can set is " + i2));
            } else {
                int j2 = raid.m();
                raid.a(level);
                source.a(new ChatComponentText("Changed village's bad omen level from " + j2 + " to " + level), false);
            }
        } else {
            source.a(new ChatComponentText("No raid found here"));
        }
        return 1;
    }

    private static int b(CommandListenerWrapper source) {
        source.a(new ChatComponentText("Spawned a raid captain"), false);
        EntityRaider raider = EntityTypes.aq.a(source.e());
        raider.v(true);
        raider.a(EnumItemSlot.f, Raid.s());
        raider.e(source.d().b, source.d().c, source.d().d);
        raider.a(source.e(), source.e().d_(new BlockPosition(source.d())), EnumMobSpawn.n, null, null);
        source.e().a_(raider);
        return 1;
    }

    private static int a(CommandListenerWrapper source, IChatBaseComponent type) {
        if (type != null && type.getString().equals("local")) {
            source.e().a(null, new BlockPosition(source.d().b(5.0, 0.0, 0.0)), SoundEffects.pw, SoundCategory.g, 2.0f, 1.0f);
        }
        return 1;
    }

    private static int b(CommandListenerWrapper source, int level) throws CommandSyntaxException {
        EntityPlayer serverPlayer = source.h();
        BlockPosition blockPos = serverPlayer.cW();
        if (serverPlayer.x().d(blockPos)) {
            source.a(new ChatComponentText("Raid already started close by"));
            return -1;
        }
        PersistentRaid raids = serverPlayer.x().A();
        Raid raid = raids.a(serverPlayer);
        if (raid != null) {
            raid.a(level);
            raids.b();
            source.a(new ChatComponentText("Created a raid in your local village"), false);
        } else {
            source.a(new ChatComponentText("Failed to create a raid in your local village"));
        }
        return 1;
    }

    private static int c(CommandListenerWrapper source) throws CommandSyntaxException {
        EntityPlayer serverPlayer = source.h();
        BlockPosition blockPos = serverPlayer.cW();
        Raid raid = serverPlayer.x().c(blockPos);
        if (raid != null) {
            raid.n();
            source.a(new ChatComponentText("Stopped raid"), false);
            return 1;
        }
        source.a(new ChatComponentText("No raid here"));
        return -1;
    }

    private static int d(CommandListenerWrapper source) throws CommandSyntaxException {
        Raid raid = RaidCommand.a(source.h());
        if (raid != null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Found a started raid! ");
            source.a(new ChatComponentText(stringBuilder.toString()), false);
            stringBuilder = new StringBuilder();
            stringBuilder.append("Num groups spawned: ");
            stringBuilder.append(raid.k());
            stringBuilder.append(" Bad omen level: ");
            stringBuilder.append(raid.m());
            stringBuilder.append(" Num mobs: ");
            stringBuilder.append(raid.r());
            stringBuilder.append(" Raid health: ");
            stringBuilder.append(raid.q());
            stringBuilder.append(" / ");
            stringBuilder.append(raid.g());
            source.a(new ChatComponentText(stringBuilder.toString()), false);
            return 1;
        }
        source.a(new ChatComponentText("Found no started raids"));
        return 0;
    }

    @Nullable
    private static Raid a(EntityPlayer player) {
        return player.x().c(player.cW());
    }
}

