/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentAnchor;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.coordinates.ArgumentRotation;
import net.minecraft.commands.arguments.coordinates.ArgumentVec3;
import net.minecraft.commands.arguments.coordinates.IVectorPosition;
import net.minecraft.commands.arguments.coordinates.VectorPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.network.protocol.game.PacketPlayOutPosition;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_18_R2.CraftWorld;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityTeleportEvent;
import org.bukkit.event.player.PlayerTeleportEvent;

public class CommandTeleport {
    private static final SimpleCommandExceptionType a = new SimpleCommandExceptionType((Message)new ChatMessage("commands.teleport.invalidPosition"));

    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher) {
        LiteralCommandNode<CommandListenerWrapper> literalcommandnode = dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("teleport").requires(commandlistenerwrapper -> commandlistenerwrapper.c(2))).then(net.minecraft.commands.CommandDispatcher.a("location", ArgumentVec3.a()).executes(commandcontext -> CommandTeleport.a((CommandListenerWrapper)commandcontext.getSource(), Collections.singleton(((CommandListenerWrapper)commandcontext.getSource()).g()), ((CommandListenerWrapper)commandcontext.getSource()).e(), ArgumentVec3.b((CommandContext<CommandListenerWrapper>)commandcontext, "location"), VectorPosition.d(), null)))).then(net.minecraft.commands.CommandDispatcher.a("destination", ArgumentEntity.a()).executes(commandcontext -> CommandTeleport.a((CommandListenerWrapper)commandcontext.getSource(), Collections.singleton(((CommandListenerWrapper)commandcontext.getSource()).g()), ArgumentEntity.a((CommandContext<CommandListenerWrapper>)commandcontext, "destination"))))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("targets", ArgumentEntity.b()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("location", ArgumentVec3.a()).executes(commandcontext -> CommandTeleport.a((CommandListenerWrapper)commandcontext.getSource(), ArgumentEntity.b((CommandContext<CommandListenerWrapper>)commandcontext, "targets"), ((CommandListenerWrapper)commandcontext.getSource()).e(), ArgumentVec3.b((CommandContext<CommandListenerWrapper>)commandcontext, "location"), null, null))).then(net.minecraft.commands.CommandDispatcher.a("rotation", ArgumentRotation.a()).executes(commandcontext -> CommandTeleport.a((CommandListenerWrapper)commandcontext.getSource(), ArgumentEntity.b((CommandContext<CommandListenerWrapper>)commandcontext, "targets"), ((CommandListenerWrapper)commandcontext.getSource()).e(), ArgumentVec3.b((CommandContext<CommandListenerWrapper>)commandcontext, "location"), ArgumentRotation.a((CommandContext<CommandListenerWrapper>)commandcontext, "rotation"), null)))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("facing").then(net.minecraft.commands.CommandDispatcher.a("entity").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("facingEntity", ArgumentEntity.a()).executes(commandcontext -> CommandTeleport.a((CommandListenerWrapper)commandcontext.getSource(), ArgumentEntity.b((CommandContext<CommandListenerWrapper>)commandcontext, "targets"), ((CommandListenerWrapper)commandcontext.getSource()).e(), ArgumentVec3.b((CommandContext<CommandListenerWrapper>)commandcontext, "location"), null, new a(ArgumentEntity.a((CommandContext<CommandListenerWrapper>)commandcontext, "facingEntity"), ArgumentAnchor.Anchor.a)))).then(net.minecraft.commands.CommandDispatcher.a("facingAnchor", ArgumentAnchor.a()).executes(commandcontext -> CommandTeleport.a((CommandListenerWrapper)commandcontext.getSource(), ArgumentEntity.b((CommandContext<CommandListenerWrapper>)commandcontext, "targets"), ((CommandListenerWrapper)commandcontext.getSource()).e(), ArgumentVec3.b((CommandContext<CommandListenerWrapper>)commandcontext, "location"), null, new a(ArgumentEntity.a((CommandContext<CommandListenerWrapper>)commandcontext, "facingEntity"), ArgumentAnchor.a((CommandContext<CommandListenerWrapper>)commandcontext, "facingAnchor")))))))).then(net.minecraft.commands.CommandDispatcher.a("facingLocation", ArgumentVec3.a()).executes(commandcontext -> CommandTeleport.a((CommandListenerWrapper)commandcontext.getSource(), ArgumentEntity.b((CommandContext<CommandListenerWrapper>)commandcontext, "targets"), ((CommandListenerWrapper)commandcontext.getSource()).e(), ArgumentVec3.b((CommandContext<CommandListenerWrapper>)commandcontext, "location"), null, new a(ArgumentVec3.a((CommandContext<CommandListenerWrapper>)commandcontext, "facingLocation")))))))).then(net.minecraft.commands.CommandDispatcher.a("destination", ArgumentEntity.a()).executes(commandcontext -> CommandTeleport.a((CommandListenerWrapper)commandcontext.getSource(), ArgumentEntity.b((CommandContext<CommandListenerWrapper>)commandcontext, "targets"), ArgumentEntity.a((CommandContext<CommandListenerWrapper>)commandcontext, "destination")))))));
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("tp").requires(commandlistenerwrapper -> commandlistenerwrapper.c(2))).redirect(literalcommandnode)));
    }

    private static int a(CommandListenerWrapper source, Collection<? extends net.minecraft.world.entity.Entity> targets, net.minecraft.world.entity.Entity destination) throws CommandSyntaxException {
        for (net.minecraft.world.entity.Entity entity : targets) {
            CommandTeleport.a(source, entity, (WorldServer)destination.s, destination.dc(), destination.de(), destination.di(), EnumSet.noneOf(PacketPlayOutPosition.EnumPlayerTeleportFlags.class), destination.dn(), destination.do(), null);
        }
        if (targets.size() == 1) {
            source.a(new ChatMessage("commands.teleport.success.entity.single", targets.iterator().next().C_(), destination.C_()), true);
        } else {
            source.a(new ChatMessage("commands.teleport.success.entity.multiple", targets.size(), destination.C_()), true);
        }
        return targets.size();
    }

    private static int a(CommandListenerWrapper source, Collection<? extends net.minecraft.world.entity.Entity> targets, WorldServer world, IVectorPosition location, @Nullable IVectorPosition rotation, @Nullable a facingLocation) throws CommandSyntaxException {
        Vec3D vec3d = location.a(source);
        Vec2F vec2f = rotation == null ? null : rotation.b(source);
        EnumSet<PacketPlayOutPosition.EnumPlayerTeleportFlags> set = EnumSet.noneOf(PacketPlayOutPosition.EnumPlayerTeleportFlags.class);
        if (location.a()) {
            set.add(PacketPlayOutPosition.EnumPlayerTeleportFlags.a);
        }
        if (location.b()) {
            set.add(PacketPlayOutPosition.EnumPlayerTeleportFlags.b);
        }
        if (location.c()) {
            set.add(PacketPlayOutPosition.EnumPlayerTeleportFlags.c);
        }
        if (rotation == null) {
            set.add(PacketPlayOutPosition.EnumPlayerTeleportFlags.e);
            set.add(PacketPlayOutPosition.EnumPlayerTeleportFlags.d);
        } else {
            if (rotation.a()) {
                set.add(PacketPlayOutPosition.EnumPlayerTeleportFlags.e);
            }
            if (rotation.b()) {
                set.add(PacketPlayOutPosition.EnumPlayerTeleportFlags.d);
            }
        }
        for (net.minecraft.world.entity.Entity entity : targets) {
            if (rotation == null) {
                CommandTeleport.a(source, entity, world, vec3d.b, vec3d.c, vec3d.d, set, entity.dn(), entity.do(), facingLocation);
                continue;
            }
            CommandTeleport.a(source, entity, world, vec3d.b, vec3d.c, vec3d.d, set, vec2f.j, vec2f.i, facingLocation);
        }
        if (targets.size() == 1) {
            source.a(new ChatMessage("commands.teleport.success.location.single", targets.iterator().next().C_(), CommandTeleport.a(vec3d.b), CommandTeleport.a(vec3d.c), CommandTeleport.a(vec3d.d)), true);
        } else {
            source.a(new ChatMessage("commands.teleport.success.location.multiple", targets.size(), CommandTeleport.a(vec3d.b), CommandTeleport.a(vec3d.c), CommandTeleport.a(vec3d.d)), true);
        }
        return targets.size();
    }

    private static String a(double d2) {
        return String.format(Locale.ROOT, "%f", d2);
    }

    private static void a(CommandListenerWrapper source, net.minecraft.world.entity.Entity target, WorldServer world, double x2, double y2, double z2, Set<PacketPlayOutPosition.EnumPlayerTeleportFlags> movementFlags, float yaw, float pitch, @Nullable a facingLocation) throws CommandSyntaxException {
        BlockPosition blockposition = new BlockPosition(x2, y2, z2);
        if (!World.k(blockposition)) {
            throw a.create();
        }
        float f2 = MathHelper.g(yaw);
        float f3 = MathHelper.g(pitch);
        if (target instanceof EntityPlayer) {
            ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(new BlockPosition(x2, y2, z2));
            world.k().a(TicketType.g, chunkcoordintpair, 1, target.ae());
            target.p();
            if (((EntityPlayer)target).fc()) {
                ((EntityPlayer)target).a(true, true);
            }
            if (world == target.s) {
                ((EntityPlayer)target).b.teleport(x2, y2, z2, f2, f3, movementFlags, PlayerTeleportEvent.TeleportCause.COMMAND);
            } else {
                ((EntityPlayer)target).teleportTo(world, x2, y2, z2, f2, f3, PlayerTeleportEvent.TeleportCause.COMMAND);
            }
            target.l(f2);
        } else {
            float f4 = MathHelper.a(f3, -90.0f, 90.0f);
            Location to = new Location((org.bukkit.World)world.getWorld(), x2, y2, z2, f2, f4);
            EntityTeleportEvent event = new EntityTeleportEvent((Entity)target.getBukkitEntity(), target.getBukkitEntity().getLocation(), to);
            world.getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            x2 = to.getX();
            y2 = to.getY();
            z2 = to.getZ();
            f2 = to.getYaw();
            f4 = to.getPitch();
            world = ((CraftWorld)to.getWorld()).getHandle();
            if (world == target.s) {
                target.b(x2, y2, z2, f2, f4);
                target.l(f2);
            } else {
                target.ab();
                net.minecraft.world.entity.Entity entity1 = target;
                target = target.ad().a(world);
                if (target == null) {
                    return;
                }
                target.t(entity1);
                target.b(x2, y2, z2, f2, f4);
                target.l(f2);
                entity1.b(Entity.RemovalReason.e);
                world.d(target);
            }
        }
        if (facingLocation != null) {
            facingLocation.a(source, target);
        }
        if (!(target instanceof EntityLiving) || !((EntityLiving)target).eV()) {
            target.g(target.da().d(1.0, 0.0, 1.0));
            target.c(true);
        }
        if (target instanceof EntityCreature) {
            ((EntityCreature)target).D().n();
        }
    }

    private static class a {
        private final Vec3D a;
        private final net.minecraft.world.entity.Entity b;
        private final ArgumentAnchor.Anchor c;

        public a(net.minecraft.world.entity.Entity target, ArgumentAnchor.Anchor targetAnchor) {
            this.b = target;
            this.c = targetAnchor;
            this.a = targetAnchor.a(target);
        }

        public a(Vec3D targetPos) {
            this.b = null;
            this.a = targetPos;
            this.c = null;
        }

        public void a(CommandListenerWrapper source, net.minecraft.world.entity.Entity entity) {
            if (this.b != null) {
                if (entity instanceof EntityPlayer) {
                    ((EntityPlayer)entity).a(source.k(), this.b, this.c);
                } else {
                    entity.a(source.k(), this.a);
                }
            } else {
                entity.a(source.k(), this.a);
            }
        }
    }
}

