/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentEntitySummon;
import net.minecraft.commands.arguments.ArgumentNBTTag;
import net.minecraft.commands.arguments.coordinates.ArgumentVec3;
import net.minecraft.commands.synchronization.CompletionProviders;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class CommandSummon {
    private static final SimpleCommandExceptionType a = new SimpleCommandExceptionType((Message)new ChatMessage("commands.summon.failed"));
    private static final SimpleCommandExceptionType b = new SimpleCommandExceptionType((Message)new ChatMessage("commands.summon.failed.uuid"));
    private static final SimpleCommandExceptionType c = new SimpleCommandExceptionType((Message)new ChatMessage("commands.summon.invalidPosition"));

    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("summon").requires(commandlistenerwrapper -> commandlistenerwrapper.c(2))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("entity", ArgumentEntitySummon.a()).suggests(CompletionProviders.d).executes(commandcontext -> CommandSummon.a((CommandListenerWrapper)commandcontext.getSource(), ArgumentEntitySummon.a((CommandContext<CommandListenerWrapper>)commandcontext, "entity"), ((CommandListenerWrapper)commandcontext.getSource()).d(), new NBTTagCompound(), true))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("pos", ArgumentVec3.a()).executes(commandcontext -> CommandSummon.a((CommandListenerWrapper)commandcontext.getSource(), ArgumentEntitySummon.a((CommandContext<CommandListenerWrapper>)commandcontext, "entity"), ArgumentVec3.a((CommandContext<CommandListenerWrapper>)commandcontext, "pos"), new NBTTagCompound(), true))).then(net.minecraft.commands.CommandDispatcher.a("nbt", ArgumentNBTTag.a()).executes(commandcontext -> CommandSummon.a((CommandListenerWrapper)commandcontext.getSource(), ArgumentEntitySummon.a((CommandContext<CommandListenerWrapper>)commandcontext, "entity"), ArgumentVec3.a((CommandContext<CommandListenerWrapper>)commandcontext, "pos"), ArgumentNBTTag.a(commandcontext, "nbt"), false)))))));
    }

    private static int a(CommandListenerWrapper source, MinecraftKey entity, Vec3D pos, NBTTagCompound nbt, boolean initialize) throws CommandSyntaxException {
        BlockPosition blockposition = new BlockPosition(pos);
        if (!World.k(blockposition)) {
            throw c.create();
        }
        NBTTagCompound nbttagcompound1 = nbt.g();
        nbttagcompound1.a("id", entity.toString());
        WorldServer worldserver = source.e();
        Entity entity1 = EntityTypes.a(nbttagcompound1, worldserver, loadedEntity -> {
            loadedEntity.b(pos.b, pos.c, pos.d, loadedEntity.dn(), loadedEntity.do());
            return loadedEntity;
        });
        if (entity1 == null) {
            throw a.create();
        }
        if (initialize && entity1 instanceof EntityInsentient) {
            ((EntityInsentient)entity1).a(source.e(), source.e().d_(entity1.cW()), EnumMobSpawn.n, (GroupDataEntity)null, null);
        }
        if (!worldserver.tryAddFreshEntityWithPassengers(entity1, CreatureSpawnEvent.SpawnReason.COMMAND)) {
            throw b.create();
        }
        source.a(new ChatMessage("commands.summon.success", entity1.C_()), true);
        return 1;
    }
}

