/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.ArgumentMinecraftKeyRegistered;
import net.minecraft.commands.arguments.coordinates.ArgumentVec3;
import net.minecraft.commands.synchronization.CompletionProviders;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.network.protocol.game.PacketPlayOutCustomSoundEffect;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.world.phys.Vec3D;

public class CommandPlaySound {
    private static final SimpleCommandExceptionType a = new SimpleCommandExceptionType((Message)new ChatMessage("commands.playsound.failed"));

    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher) {
        RequiredArgumentBuilder requiredArgumentBuilder = net.minecraft.commands.CommandDispatcher.a("sound", ArgumentMinecraftKeyRegistered.a()).suggests(CompletionProviders.c);
        for (SoundCategory soundSource : SoundCategory.values()) {
            requiredArgumentBuilder.then(CommandPlaySound.a(soundSource));
        }
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("playsound").requires(source -> source.c(2))).then((ArgumentBuilder)requiredArgumentBuilder)));
    }

    private static LiteralArgumentBuilder<CommandListenerWrapper> a(SoundCategory category) {
        return (LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a(category.a()).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("targets", ArgumentEntity.d()).executes(context -> CommandPlaySound.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.f((CommandContext<CommandListenerWrapper>)context, "targets"), ArgumentMinecraftKeyRegistered.e((CommandContext<CommandListenerWrapper>)context, "sound"), category, ((CommandListenerWrapper)context.getSource()).d(), 1.0f, 1.0f, 0.0f))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("pos", ArgumentVec3.a()).executes(context -> CommandPlaySound.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.f((CommandContext<CommandListenerWrapper>)context, "targets"), ArgumentMinecraftKeyRegistered.e((CommandContext<CommandListenerWrapper>)context, "sound"), category, ArgumentVec3.a((CommandContext<CommandListenerWrapper>)context, "pos"), 1.0f, 1.0f, 0.0f))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("volume", FloatArgumentType.floatArg((float)0.0f)).executes(context -> CommandPlaySound.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.f((CommandContext<CommandListenerWrapper>)context, "targets"), ArgumentMinecraftKeyRegistered.e((CommandContext<CommandListenerWrapper>)context, "sound"), category, ArgumentVec3.a((CommandContext<CommandListenerWrapper>)context, "pos"), ((Float)context.getArgument("volume", Float.class)).floatValue(), 1.0f, 0.0f))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("pitch", FloatArgumentType.floatArg((float)0.0f, (float)2.0f)).executes(context -> CommandPlaySound.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.f((CommandContext<CommandListenerWrapper>)context, "targets"), ArgumentMinecraftKeyRegistered.e((CommandContext<CommandListenerWrapper>)context, "sound"), category, ArgumentVec3.a((CommandContext<CommandListenerWrapper>)context, "pos"), ((Float)context.getArgument("volume", Float.class)).floatValue(), ((Float)context.getArgument("pitch", Float.class)).floatValue(), 0.0f))).then(net.minecraft.commands.CommandDispatcher.a("minVolume", FloatArgumentType.floatArg((float)0.0f, (float)1.0f)).executes(context -> CommandPlaySound.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.f((CommandContext<CommandListenerWrapper>)context, "targets"), ArgumentMinecraftKeyRegistered.e((CommandContext<CommandListenerWrapper>)context, "sound"), category, ArgumentVec3.a((CommandContext<CommandListenerWrapper>)context, "pos"), ((Float)context.getArgument("volume", Float.class)).floatValue(), ((Float)context.getArgument("pitch", Float.class)).floatValue(), ((Float)context.getArgument("minVolume", Float.class)).floatValue())))))));
    }

    private static int a(CommandListenerWrapper source, Collection<EntityPlayer> targets, MinecraftKey sound, SoundCategory category, Vec3D pos, float volume, float pitch, float minVolume) throws CommandSyntaxException {
        double d2 = Math.pow(volume > 1.0f ? (double)(volume * 16.0f) : 16.0, 2.0);
        int i2 = 0;
        for (EntityPlayer serverPlayer : targets) {
            double e2 = pos.b - serverPlayer.dc();
            double f2 = pos.c - serverPlayer.de();
            double g2 = pos.d - serverPlayer.di();
            double h2 = e2 * e2 + f2 * f2 + g2 * g2;
            Vec3D vec3 = pos;
            float j2 = volume;
            if (h2 > d2) {
                if (minVolume <= 0.0f) continue;
                double k2 = Math.sqrt(h2);
                vec3 = new Vec3D(serverPlayer.dc() + e2 / k2 * 2.0, serverPlayer.de() + f2 / k2 * 2.0, serverPlayer.di() + g2 / k2 * 2.0);
                j2 = minVolume;
            }
            serverPlayer.b.a(new PacketPlayOutCustomSoundEffect(sound, category, vec3, j2, pitch));
            ++i2;
        }
        if (i2 == 0) {
            throw a.create();
        }
        if (targets.size() == 1) {
            source.a(new ChatMessage("commands.playsound.success.single", sound, targets.iterator().next().C_()), true);
        } else {
            source.a(new ChatMessage("commands.playsound.success.multiple", sound, targets.size()), true);
        }
        return i2;
    }
}

