/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.ArgumentInventorySlot;
import net.minecraft.commands.arguments.ArgumentMinecraftKeyRegistered;
import net.minecraft.commands.arguments.coordinates.ArgumentPosition;
import net.minecraft.commands.arguments.coordinates.ArgumentVec3;
import net.minecraft.commands.arguments.item.ArgumentItemStack;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.commands.ItemCommands;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.IInventory;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.LootTableRegistry;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.Vec3D;

public class CommandLoot {
    public static final SuggestionProvider<CommandListenerWrapper> a = (commandcontext, suggestionsbuilder) -> {
        LootTableRegistry loottableregistry = ((CommandListenerWrapper)commandcontext.getSource()).j().aF();
        return ICompletionProvider.a(loottableregistry.a(), suggestionsbuilder);
    };
    private static final DynamicCommandExceptionType b = new DynamicCommandExceptionType(object -> new ChatMessage("commands.drop.no_held_items", object));
    private static final DynamicCommandExceptionType c = new DynamicCommandExceptionType(object -> new ChatMessage("commands.drop.no_loot_table", object));

    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)CommandLoot.a((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("loot").requires(commandlistenerwrapper -> commandlistenerwrapper.c(2)), (ArgumentBuilder<CommandListenerWrapper, ?> argumentbuilder, b commandloot_b) -> ((ArgumentBuilder)((ArgumentBuilder)((ArgumentBuilder)argumentbuilder.then(net.minecraft.commands.CommandDispatcher.a("fish").then(net.minecraft.commands.CommandDispatcher.a("loot_table", ArgumentMinecraftKeyRegistered.a()).suggests(a).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("pos", ArgumentPosition.a()).executes(commandcontext -> CommandLoot.a((CommandContext<CommandListenerWrapper>)commandcontext, ArgumentMinecraftKeyRegistered.e((CommandContext<CommandListenerWrapper>)commandcontext, "loot_table"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)commandcontext, "pos"), ItemStack.b, commandloot_b))).then(net.minecraft.commands.CommandDispatcher.a("tool", ArgumentItemStack.a()).executes(commandcontext -> CommandLoot.a((CommandContext<CommandListenerWrapper>)commandcontext, ArgumentMinecraftKeyRegistered.e((CommandContext<CommandListenerWrapper>)commandcontext, "loot_table"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)commandcontext, "pos"), ArgumentItemStack.a(commandcontext, "tool").a(1, false), commandloot_b)))).then(net.minecraft.commands.CommandDispatcher.a("mainhand").executes(commandcontext -> CommandLoot.a((CommandContext<CommandListenerWrapper>)commandcontext, ArgumentMinecraftKeyRegistered.e((CommandContext<CommandListenerWrapper>)commandcontext, "loot_table"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)commandcontext, "pos"), CommandLoot.a((CommandListenerWrapper)commandcontext.getSource(), EnumItemSlot.a), commandloot_b)))).then(net.minecraft.commands.CommandDispatcher.a("offhand").executes(commandcontext -> CommandLoot.a((CommandContext<CommandListenerWrapper>)commandcontext, ArgumentMinecraftKeyRegistered.e((CommandContext<CommandListenerWrapper>)commandcontext, "loot_table"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)commandcontext, "pos"), CommandLoot.a((CommandListenerWrapper)commandcontext.getSource(), EnumItemSlot.b), commandloot_b))))))).then(net.minecraft.commands.CommandDispatcher.a("loot").then(net.minecraft.commands.CommandDispatcher.a("loot_table", ArgumentMinecraftKeyRegistered.a()).suggests(a).executes(commandcontext -> CommandLoot.a((CommandContext<CommandListenerWrapper>)commandcontext, ArgumentMinecraftKeyRegistered.e((CommandContext<CommandListenerWrapper>)commandcontext, "loot_table"), commandloot_b))))).then(net.minecraft.commands.CommandDispatcher.a("kill").then(net.minecraft.commands.CommandDispatcher.a("target", ArgumentEntity.a()).executes(commandcontext -> CommandLoot.a((CommandContext<CommandListenerWrapper>)commandcontext, ArgumentEntity.a((CommandContext<CommandListenerWrapper>)commandcontext, "target"), commandloot_b))))).then(net.minecraft.commands.CommandDispatcher.a("mine").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("pos", ArgumentPosition.a()).executes(commandcontext -> CommandLoot.a((CommandContext<CommandListenerWrapper>)commandcontext, ArgumentPosition.a((CommandContext<CommandListenerWrapper>)commandcontext, "pos"), ItemStack.b, commandloot_b))).then(net.minecraft.commands.CommandDispatcher.a("tool", ArgumentItemStack.a()).executes(commandcontext -> CommandLoot.a((CommandContext<CommandListenerWrapper>)commandcontext, ArgumentPosition.a((CommandContext<CommandListenerWrapper>)commandcontext, "pos"), ArgumentItemStack.a(commandcontext, "tool").a(1, false), commandloot_b)))).then(net.minecraft.commands.CommandDispatcher.a("mainhand").executes(commandcontext -> CommandLoot.a((CommandContext<CommandListenerWrapper>)commandcontext, ArgumentPosition.a((CommandContext<CommandListenerWrapper>)commandcontext, "pos"), CommandLoot.a((CommandListenerWrapper)commandcontext.getSource(), EnumItemSlot.a), commandloot_b)))).then(net.minecraft.commands.CommandDispatcher.a("offhand").executes(commandcontext -> CommandLoot.a((CommandContext<CommandListenerWrapper>)commandcontext, ArgumentPosition.a((CommandContext<CommandListenerWrapper>)commandcontext, "pos"), CommandLoot.a((CommandListenerWrapper)commandcontext.getSource(), EnumItemSlot.b), commandloot_b)))))));
    }

    private static <T extends ArgumentBuilder<CommandListenerWrapper, T>> T a(T rootArgument, c sourceConstructor) {
        return ((ArgumentBuilder)((ArgumentBuilder)((ArgumentBuilder)rootArgument.then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("replace").then(net.minecraft.commands.CommandDispatcher.a("entity").then(net.minecraft.commands.CommandDispatcher.a("entities", ArgumentEntity.b()).then(sourceConstructor.construct((ArgumentBuilder<CommandListenerWrapper, ?>)net.minecraft.commands.CommandDispatcher.a("slot", ArgumentInventorySlot.a()), (commandcontext, list, commandloot_a) -> CommandLoot.a(ArgumentEntity.b((CommandContext<CommandListenerWrapper>)commandcontext, "entities"), ArgumentInventorySlot.a((CommandContext<CommandListenerWrapper>)commandcontext, "slot"), list.size(), list, commandloot_a)).then(sourceConstructor.construct((ArgumentBuilder<CommandListenerWrapper, ?>)net.minecraft.commands.CommandDispatcher.a("count", IntegerArgumentType.integer((int)0)), (commandcontext, list, commandloot_a) -> CommandLoot.a(ArgumentEntity.b((CommandContext<CommandListenerWrapper>)commandcontext, "entities"), ArgumentInventorySlot.a((CommandContext<CommandListenerWrapper>)commandcontext, "slot"), IntegerArgumentType.getInteger((CommandContext)commandcontext, (String)"count"), list, commandloot_a))))))).then(net.minecraft.commands.CommandDispatcher.a("block").then(net.minecraft.commands.CommandDispatcher.a("targetPos", ArgumentPosition.a()).then(sourceConstructor.construct((ArgumentBuilder<CommandListenerWrapper, ?>)net.minecraft.commands.CommandDispatcher.a("slot", ArgumentInventorySlot.a()), (commandcontext, list, commandloot_a) -> CommandLoot.a((CommandListenerWrapper)commandcontext.getSource(), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)commandcontext, "targetPos"), ArgumentInventorySlot.a((CommandContext<CommandListenerWrapper>)commandcontext, "slot"), list.size(), list, commandloot_a)).then(sourceConstructor.construct((ArgumentBuilder<CommandListenerWrapper, ?>)net.minecraft.commands.CommandDispatcher.a("count", IntegerArgumentType.integer((int)0)), (commandcontext, list, commandloot_a) -> CommandLoot.a((CommandListenerWrapper)commandcontext.getSource(), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)commandcontext, "targetPos"), IntegerArgumentType.getInteger((CommandContext)commandcontext, (String)"slot"), IntegerArgumentType.getInteger((CommandContext)commandcontext, (String)"count"), list, commandloot_a)))))))).then(net.minecraft.commands.CommandDispatcher.a("insert").then(sourceConstructor.construct((ArgumentBuilder<CommandListenerWrapper, ?>)net.minecraft.commands.CommandDispatcher.a("targetPos", ArgumentPosition.a()), (commandcontext, list, commandloot_a) -> CommandLoot.a((CommandListenerWrapper)commandcontext.getSource(), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)commandcontext, "targetPos"), (List<ItemStack>)list, commandloot_a))))).then(net.minecraft.commands.CommandDispatcher.a("give").then(sourceConstructor.construct((ArgumentBuilder<CommandListenerWrapper, ?>)net.minecraft.commands.CommandDispatcher.a("players", ArgumentEntity.d()), (commandcontext, list, commandloot_a) -> CommandLoot.a(ArgumentEntity.f((CommandContext<CommandListenerWrapper>)commandcontext, "players"), (List<ItemStack>)list, commandloot_a))))).then(net.minecraft.commands.CommandDispatcher.a("spawn").then(sourceConstructor.construct((ArgumentBuilder<CommandListenerWrapper, ?>)net.minecraft.commands.CommandDispatcher.a("targetPos", ArgumentVec3.a()), (commandcontext, list, commandloot_a) -> CommandLoot.a((CommandListenerWrapper)commandcontext.getSource(), ArgumentVec3.a((CommandContext<CommandListenerWrapper>)commandcontext, "targetPos"), (List<ItemStack>)list, commandloot_a))));
    }

    private static IInventory a(CommandListenerWrapper source, BlockPosition pos) throws CommandSyntaxException {
        TileEntity tileentity = source.e().c_(pos);
        if (!(tileentity instanceof IInventory)) {
            throw ItemCommands.a.create((Object)pos.u(), (Object)pos.v(), (Object)pos.w());
        }
        return (IInventory)((Object)tileentity);
    }

    private static int a(CommandListenerWrapper source, BlockPosition targetPos, List<ItemStack> stacks, a messageSender) throws CommandSyntaxException {
        IInventory iinventory = CommandLoot.a(source, targetPos);
        ArrayList list1 = Lists.newArrayListWithCapacity((int)stacks.size());
        for (ItemStack itemstack : stacks) {
            if (!CommandLoot.a(iinventory, itemstack.n())) continue;
            iinventory.e();
            list1.add(itemstack);
        }
        messageSender.accept(list1);
        return list1.size();
    }

    private static boolean a(IInventory inventory, ItemStack stack) {
        boolean flag = false;
        for (int i2 = 0; i2 < inventory.b() && !stack.b(); ++i2) {
            ItemStack itemstack1 = inventory.a(i2);
            if (!inventory.b(i2, stack)) continue;
            if (itemstack1.b()) {
                inventory.a(i2, stack);
                flag = true;
                break;
            }
            if (!CommandLoot.a(itemstack1, stack)) continue;
            int j2 = stack.e() - itemstack1.J();
            int k2 = Math.min(stack.J(), j2);
            stack.g(k2);
            itemstack1.f(k2);
            flag = true;
        }
        return flag;
    }

    private static int a(CommandListenerWrapper source, BlockPosition targetPos, int slot, int stackCount, List<ItemStack> stacks, a messageSender) throws CommandSyntaxException {
        IInventory iinventory = CommandLoot.a(source, targetPos);
        int k2 = iinventory.b();
        if (slot >= 0 && slot < k2) {
            ArrayList list1 = Lists.newArrayListWithCapacity((int)stacks.size());
            for (int l2 = 0; l2 < stackCount; ++l2) {
                ItemStack itemstack;
                int i1 = slot + l2;
                ItemStack itemStack = itemstack = l2 < stacks.size() ? stacks.get(l2) : ItemStack.b;
                if (!iinventory.b(i1, itemstack)) continue;
                iinventory.a(i1, itemstack);
                list1.add(itemstack);
            }
            messageSender.accept(list1);
            return list1.size();
        }
        throw ItemCommands.b.create((Object)slot);
    }

    private static boolean a(ItemStack first, ItemStack second) {
        return first.a(second.c()) && first.i() == second.i() && first.J() <= first.e() && Objects.equals(first.t(), second.t());
    }

    private static int a(Collection<EntityPlayer> players, List<ItemStack> stacks, a messageSender) throws CommandSyntaxException {
        ArrayList list1 = Lists.newArrayListWithCapacity((int)stacks.size());
        for (ItemStack itemstack : stacks) {
            for (EntityPlayer entityplayer : players) {
                if (!entityplayer.fr().e(itemstack.n())) continue;
                list1.add(itemstack);
            }
        }
        messageSender.accept(list1);
        return list1.size();
    }

    private static void a(Entity entity, List<ItemStack> stacks, int slot, int stackCount, List<ItemStack> addedStacks) {
        for (int k2 = 0; k2 < stackCount; ++k2) {
            ItemStack itemstack = k2 < stacks.size() ? stacks.get(k2) : ItemStack.b;
            SlotAccess slotaccess = entity.k(slot + k2);
            if (slotaccess == SlotAccess.a || !slotaccess.a(itemstack.n())) continue;
            addedStacks.add(itemstack);
        }
    }

    private static int a(Collection<? extends Entity> targets, int slot, int stackCount, List<ItemStack> stacks, a messageSender) throws CommandSyntaxException {
        ArrayList list1 = Lists.newArrayListWithCapacity((int)stacks.size());
        for (Entity entity : targets) {
            if (entity instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)entity;
                CommandLoot.a(entity, stacks, slot, stackCount, list1);
                entityplayer.bV.d();
                continue;
            }
            CommandLoot.a(entity, stacks, slot, stackCount, list1);
        }
        messageSender.accept(list1);
        return list1.size();
    }

    private static int a(CommandListenerWrapper source, Vec3D pos, List<ItemStack> stacks, a messageSender) throws CommandSyntaxException {
        WorldServer worldserver = source.e();
        stacks.removeIf(ItemStack::b);
        stacks.forEach(itemstack -> {
            EntityItem entityitem = new EntityItem(worldserver, pos.b, pos.c, pos.d, itemstack.n());
            entityitem.n();
            worldserver.b(entityitem);
        });
        messageSender.accept(stacks);
        return stacks.size();
    }

    private static void a(CommandListenerWrapper source, List<ItemStack> stacks) {
        if (stacks.size() == 1) {
            ItemStack itemstack = stacks.get(0);
            source.a(new ChatMessage("commands.drop.success.single", itemstack.J(), itemstack.H()), false);
        } else {
            source.a(new ChatMessage("commands.drop.success.multiple", stacks.size()), false);
        }
    }

    private static void a(CommandListenerWrapper source, List<ItemStack> stacks, MinecraftKey lootTable) {
        if (stacks.size() == 1) {
            ItemStack itemstack = stacks.get(0);
            source.a(new ChatMessage("commands.drop.success.single_with_table", itemstack.J(), itemstack.H(), lootTable), false);
        } else {
            source.a(new ChatMessage("commands.drop.success.multiple_with_table", stacks.size(), lootTable), false);
        }
    }

    private static ItemStack a(CommandListenerWrapper source, EnumItemSlot slot) throws CommandSyntaxException {
        Entity entity = source.g();
        if (entity instanceof EntityLiving) {
            return ((EntityLiving)entity).b(slot);
        }
        throw b.create((Object)entity.C_());
    }

    private static int a(CommandContext<CommandListenerWrapper> context, BlockPosition pos, ItemStack stack, b constructor) throws CommandSyntaxException {
        CommandListenerWrapper commandlistenerwrapper = (CommandListenerWrapper)context.getSource();
        WorldServer worldserver = commandlistenerwrapper.e();
        IBlockData iblockdata = worldserver.a_(pos);
        TileEntity tileentity = worldserver.c_(pos);
        LootTableInfo.Builder loottableinfo_builder = new LootTableInfo.Builder(worldserver).a(LootContextParameters.f, Vec3D.a(pos)).a(LootContextParameters.g, iblockdata).b(LootContextParameters.h, tileentity).b(LootContextParameters.a, commandlistenerwrapper.f()).a(LootContextParameters.i, stack);
        List<ItemStack> list = iblockdata.a(loottableinfo_builder);
        return constructor.accept(context, list, list1 -> CommandLoot.a(commandlistenerwrapper, (List<ItemStack>)list1, iblockdata.b().s()));
    }

    private static int a(CommandContext<CommandListenerWrapper> context, Entity entity, b constructor) throws CommandSyntaxException {
        if (!(entity instanceof EntityLiving)) {
            throw c.create((Object)entity.C_());
        }
        MinecraftKey minecraftkey = ((EntityLiving)entity).ef();
        CommandListenerWrapper commandlistenerwrapper = (CommandListenerWrapper)context.getSource();
        LootTableInfo.Builder loottableinfo_builder = new LootTableInfo.Builder(commandlistenerwrapper.e());
        Entity entity1 = commandlistenerwrapper.f();
        if (entity1 instanceof EntityHuman) {
            loottableinfo_builder.a(LootContextParameters.b, (EntityHuman)entity1);
        }
        loottableinfo_builder.a(LootContextParameters.c, DamageSource.o);
        loottableinfo_builder.b(LootContextParameters.e, entity1);
        loottableinfo_builder.b(LootContextParameters.d, entity1);
        loottableinfo_builder.a(LootContextParameters.a, entity);
        loottableinfo_builder.a(LootContextParameters.f, commandlistenerwrapper.d());
        LootTable loottable = commandlistenerwrapper.j().aF().a(minecraftkey);
        List<ItemStack> list = loottable.a(loottableinfo_builder.a(LootContextParameterSets.f));
        return constructor.accept(context, list, list1 -> CommandLoot.a(commandlistenerwrapper, (List<ItemStack>)list1, minecraftkey));
    }

    private static int a(CommandContext<CommandListenerWrapper> context, MinecraftKey lootTable, b constructor) throws CommandSyntaxException {
        CommandListenerWrapper commandlistenerwrapper = (CommandListenerWrapper)context.getSource();
        LootTableInfo.Builder loottableinfo_builder = new LootTableInfo.Builder(commandlistenerwrapper.e()).b(LootContextParameters.a, commandlistenerwrapper.f()).a(LootContextParameters.f, commandlistenerwrapper.d());
        return CommandLoot.a(context, lootTable, loottableinfo_builder.a(LootContextParameterSets.b), constructor);
    }

    private static int a(CommandContext<CommandListenerWrapper> context, MinecraftKey lootTable, BlockPosition pos, ItemStack stack, b constructor) throws CommandSyntaxException {
        CommandListenerWrapper commandlistenerwrapper = (CommandListenerWrapper)context.getSource();
        LootTableInfo loottableinfo = new LootTableInfo.Builder(commandlistenerwrapper.e()).a(LootContextParameters.f, Vec3D.a(pos)).a(LootContextParameters.i, stack).b(LootContextParameters.a, commandlistenerwrapper.f()).a(LootContextParameterSets.e);
        return CommandLoot.a(context, lootTable, loottableinfo, constructor);
    }

    private static int a(CommandContext<CommandListenerWrapper> context, MinecraftKey lootTable, LootTableInfo lootContext, b constructor) throws CommandSyntaxException {
        CommandListenerWrapper commandlistenerwrapper = (CommandListenerWrapper)context.getSource();
        LootTable loottable = commandlistenerwrapper.j().aF().a(lootTable);
        List<ItemStack> list = loottable.a(lootContext);
        return constructor.accept(context, list, list1 -> CommandLoot.a(commandlistenerwrapper, list1));
    }

    @FunctionalInterface
    private static interface c {
        public ArgumentBuilder<CommandListenerWrapper, ?> construct(ArgumentBuilder<CommandListenerWrapper, ?> var1, b var2);
    }

    @FunctionalInterface
    private static interface b {
        public int accept(CommandContext<CommandListenerWrapper> var1, List<ItemStack> var2, a var3) throws CommandSyntaxException;
    }

    @FunctionalInterface
    private static interface a {
        public void accept(List<ItemStack> var1) throws CommandSyntaxException;
    }
}

